<?php
/**
 * Netflix Declined Template 9: Netflix Inline Alert - Responsive
 * Supports custom colors
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined9($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $text = $c['text'];
    
    return <<<HTML
<style>
.nf-dec-9{background:{$text}15;border-radius:2px;padding:12px 16px;margin:0 0 16px;font-family:Netflix Sans,Helvetica Neue,Segoe UI,Roboto,sans-serif}
.nf-dec-9 .text{color:{$text};font-size:14px;line-height:1.5}
.nf-dec-9 .text strong{font-weight:600}
@media(max-width:480px){.nf-dec-9{padding:10px 12px}.nf-dec-9 .text{font-size:12px}}
</style>
<div class="nf-dec-9">
    <div class="text">
        <strong>Payment declined:</strong> Your {$scheme} ****{$last4} ({$issuer}) could not be charged. Please try a different payment method.
    </div>
</div>
HTML;
}
