<?php
/**
 * Save declined template selection
 */

header('Content-Type: application/json');

$template = $_GET['template'] ?? null;

if (!$template || !in_array($template, ['1', '2', '3', '4', '5'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid template']);
    exit;
}

$controlFile = __DIR__ . '/control.json';

// Read current config
$config = [];
if (file_exists($controlFile)) {
    $config = json_decode(file_get_contents($controlFile), true) ?? [];
}

// Update declined_template
$config['declined_template'] = $template;

// Save
$result = file_put_contents($controlFile, json_encode($config, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));

if ($result !== false) {
    echo json_encode(['success' => true, 'message' => 'Template updated']);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to save']);
}
